/*!
 * surveyjs - Survey JavaScript library v1.9.1
 * Copyright (c) 2015-2021 Devsoft Baltic OÜ  - http://surveyjs.io/
 * License: MIT (http://www.opensource.org/licenses/mit-license.php)
 */
(function webpackUniversalModuleDefinition(root, factory) {
	if(typeof exports === 'object' && typeof module === 'object')
		module.exports = factory(require("react"), require("react-dom"));
	else if(typeof define === 'function' && define.amd)
		define("survey-react", ["react", "react-dom"], factory);
	else if(typeof exports === 'object')
		exports["survey-react"] = factory(require("react"), require("react-dom"));
	else
		root["Survey"] = factory(root["React"], root["ReactDOM"]);
})(this, function(__WEBPACK_EXTERNAL_MODULE_react__, __WEBPACK_EXTERNAL_MODULE_react_dom__) {
return /******/ (function(modules) { // webpackBootstrap
/******/ 	// The module cache
/******/ 	var installedModules = {};
/******/
/******/ 	// The require function
/******/ 	function __webpack_require__(moduleId) {
/******/
/******/ 		// Check if module is in cache
/******/ 		if(installedModules[moduleId]) {
/******/ 			return installedModules[moduleId].exports;
/******/ 		}
/******/ 		// Create a new module (and put it into the cache)
/******/ 		var module = installedModules[moduleId] = {
/******/ 			i: moduleId,
/******/ 			l: false,
/******/ 			exports: {}
/******/ 		};
/******/
/******/ 		// Execute the module function
/******/ 		modules[moduleId].call(module.exports, module, module.exports, __webpack_require__);
/******/
/******/ 		// Flag the module as loaded
/******/ 		module.l = true;
/******/
/******/ 		// Return the exports of the module
/******/ 		return module.exports;
/******/ 	}
/******/
/******/
/******/ 	// expose the modules object (__webpack_modules__)
/******/ 	__webpack_require__.m = modules;
/******/
/******/ 	// expose the module cache
/******/ 	__webpack_require__.c = installedModules;
/******/
/******/ 	// define getter function for harmony exports
/******/ 	__webpack_require__.d = function(exports, name, getter) {
/******/ 		if(!__webpack_require__.o(exports, name)) {
/******/ 			Object.defineProperty(exports, name, { enumerable: true, get: getter });
/******/ 		}
/******/ 	};
/******/
/******/ 	// define __esModule on exports
/******/ 	__webpack_require__.r = function(exports) {
/******/ 		if(typeof Symbol !== 'undefined' && Symbol.toStringTag) {
/******/ 			Object.defineProperty(exports, Symbol.toStringTag, { value: 'Module' });
/******/ 		}
/******/ 		Object.defineProperty(exports, '__esModule', { value: true });
/******/ 	};
/******/
/******/ 	// create a fake namespace object
/******/ 	// mode & 1: value is a module id, require it
/******/ 	// mode & 2: merge all properties of value into the ns
/******/ 	// mode & 4: return value when already ns object
/******/ 	// mode & 8|1: behave like require
/******/ 	__webpack_require__.t = function(value, mode) {
/******/ 		if(mode & 1) value = __webpack_require__(value);
/******/ 		if(mode & 8) return value;
/******/ 		if((mode & 4) && typeof value === 'object' && value && value.__esModule) return value;
/******/ 		var ns = Object.create(null);
/******/ 		__webpack_require__.r(ns);
/******/ 		Object.defineProperty(ns, 'default', { enumerable: true, value: value });
/******/ 		if(mode & 2 && typeof value != 'string') for(var key in value) __webpack_require__.d(ns, key, function(key) { return value[key]; }.bind(null, key));
/******/ 		return ns;
/******/ 	};
/******/
/******/ 	// getDefaultExport function for compatibility with non-harmony modules
/******/ 	__webpack_require__.n = function(module) {
/******/ 		var getter = module && module.__esModule ?
/******/ 			function getDefault() { return module['default']; } :
/******/ 			function getModuleExports() { return module; };
/******/ 		__webpack_require__.d(getter, 'a', getter);
/******/ 		return getter;
/******/ 	};
/******/
/******/ 	// Object.prototype.hasOwnProperty.call
/******/ 	__webpack_require__.o = function(object, property) { return Object.prototype.hasOwnProperty.call(object, property); };
/******/
/******/ 	// __webpack_public_path__
/******/ 	__webpack_require__.p = "";
/******/
/******/
/******/ 	// Load entry module and return exports
/******/ 	return __webpack_require__(__webpack_require__.s = "./src/entries/react.ts");
/******/ })
/************************************************************************/
/******/ ({

/***/ "./node_modules/html-loader/index.js?interpolate!./node_modules/val-loader/index.js!./src/svgbundle.html":
/*!*********************************************************************************************!*\
  !*** ./node_modules/html-loader?interpolate!./node_modules/val-loader!./src/svgbundle.html ***!
  \*********************************************************************************************/
/*! no static exports found */
/***/ (function(module, exports) {

module.exports = "<svg style=\"display:none;\"><symbol viewBox=\"0 0 10 10\" id=\"icon-arrow_downgrey_10x10\"><style><![CDATA[.st0{fill:#6d7072}]]></style><path class=\"st0\" d=\"M2 2L0 4l5 5 5-5-2-2-3 3z\"></path></symbol><symbol viewBox=\"0 0 34 34\" id=\"icon-arrowdown_34x34\"><style><![CDATA[.st0{fill:#fff}]]></style><path class=\"st0\" d=\"M12 16l2-2 3 3 3-3 2 2-5 5z\"></path></symbol><symbol viewBox=\"0 0 24 24\" id=\"icon-delete\"><path d=\"M22 4h-6V2c0-1.1-.9-2-2-2h-4C8.9 0 8 .9 8 2v2H2v2h2v14c0 1.1.9 2 2 2h12c1.1 0 2-.9 2-2V6h2V4zM10 2h4v2h-4V2zm8 18H6V6h12v14zM14 8h2v10h-2V8zm-3 0h2v10h-2V8zM8 8h2v10H8V8z\"></path></symbol><symbol viewBox=\"0 0 34 34\" id=\"icon-down_34x34\"><style><![CDATA[.st0{fill:#1ab394}.st1{fill:#fff}]]></style><path class=\"st0\" d=\"M33 34H0V0h33c.6 0 1 .4 1 1v32c0 .6-.4 1-1 1z\"></path><path class=\"st1\" d=\"M12 16l2-2 3 3 3-3 2 2-5 5z\"></path></symbol><symbol viewBox=\"0 0 16 16\" id=\"icon-left\"><path d=\"M11 12l-2 2-6-6 6-6 2 2-4 4z\"></path></symbol><symbol viewBox=\"0 0 24 24\" id=\"icon-moderncheck\"><path d=\"M5 13l2-2 3 3 7-7 2 2-9 9-5-5z\"></path></symbol><symbol viewBox=\"-12 -12 24 24\" id=\"icon-modernradio\"><circle r=\"6\"></circle></symbol><symbol viewBox=\"0 0 24 24\" id=\"icon-more\"><path d=\"M6 12c0 1.1-.9 2-2 2s-2-.9-2-2 .9-2 2-2 2 .9 2 2zm6-2c-1.1 0-2 .9-2 2s.9 2 2 2 2-.9 2-2-.9-2-2-2zm8 0c-1.1 0-2 .9-2 2s.9 2 2 2 2-.9 2-2-.9-2-2-2z\"></path></symbol><symbol viewBox=\"0 0 10 10\" id=\"icon-progressbutton\"><path d=\"M2 2L0 4l5 5 5-5-2-2-3 3z\"></path></symbol><symbol viewBox=\"0 0 16 16\" id=\"icon-progressbuttonv2\"><path d=\"M15 9H4.4l4.3 4.3-1.4 1.4L.6 8l6.7-6.7 1.4 1.4L4.4 7H15v2z\"></path></symbol><symbol viewBox=\"0 0 16 16\" id=\"icon-right\"><path d=\"M5 4l2-2 6 6-6 6-2-2 4-4z\"></path></symbol><symbol viewBox=\"0 0 24 24\" id=\"icon-v2check\"><path d=\"M9 20.1L1 12l2.1-2.1 5.9 6L20.9 4 23 6.1l-14 14z\"></path></symbol></svg>";

/***/ }),

/***/ "./node_modules/signature_pad/dist/signature_pad.mjs":
/*!***********************************************************!*\
  !*** ./node_modules/signature_pad/dist/signature_pad.mjs ***!
  \***********************************************************/
/*! exports provided: default */
/***/ (function(__webpack_module__, __webpack_exports__, __webpack_require__) {

"use strict";
__webpack_require__.r(__webpack_exports__);
/*!
 * Signature Pad v2.3.2
 * https://github.com/szimek/signature_pad
 *
 * Copyright 2017 Szymon Nowak
 * Released under the MIT license
 *
 * The main idea and some parts of the code (e.g. drawing variable width Bézier curve) are taken from:
 * http://corner.squareup.com/2012/07/smoother-signatures.html
 *
 * Implementation of interpolation using cubic Bézier curves is taken from:
 * http://benknowscode.wordpress.com/2012/09/14/path-interpolation-using-cubic-bezier-and-control-point-estimation-in-javascript
 *
 * Algorithm for approximated length of a Bézier curve is taken from:
 * http://www.lemoda.net/maths/bezier-length/index.html
 *
 */

function Point(x, y, time) {
  this.x = x;
  this.y = y;
  this.time = time || new Date().getTime();
}

Point.prototype.velocityFrom = function (start) {
  return this.time !== start.time ? this.distanceTo(start) / (this.time - start.time) : 1;
};

Point.prototype.distanceTo = function (start) {
  return Math.sqrt(Math.pow(this.x - start.x, 2) + Math.pow(this.y - start.y, 2));
};

Point.prototype.equals = function (other) {
  return this.x === other.x && this.y === other.y && this.time === other.time;
};

function Bezier(startPoint, control1, control2, endPoint) {
  this.startPoint = startPoint;
  this.control1 = control1;
  this.control2 = control2;
  this.endPoint = endPoint;
}

// Returns approximated length.
Bezier.prototype.length = function () {
  var steps = 10;
  var length = 0;
  var px = void 0;
  var py = void 0;

  for (var i = 0; i <= steps; i += 1) {
    var t = i / steps;
    var cx = this._point(t, this.startPoint.x, this.control1.x, this.control2.x, this.endPoint.x);
    var cy = this._point(t, this.startPoint.y, this.control1.y, this.control2.y, this.endPoint.y);
    if (i > 0) {
      var xdiff = cx - px;
      var ydiff = cy - py;
      length += Math.sqrt(xdiff * xdiff + ydiff * ydiff);
    }
    px = cx;
    py = cy;
  }

  return length;
};

/* eslint-disable no-multi-spaces, space-in-parens */
Bezier.prototype._point = function (t, start, c1, c2, end) {
  return start * (1.0 - t) * (1.0 - t) * (1.0 - t) + 3.0 * c1 * (1.0 - t) * (1.0 - t) * t + 3.0 * c2 * (1.0 - t) * t * t + end * t * t * t;
};

/* eslint-disable */

// http://stackoverflow.com/a/27078401/815507
function throttle(func, wait, options) {
  var context, args, result;
  var timeout = null;
  var previous = 0;
  if (!options) options = {};
  var later = function later() {
    previous = options.leading === false ? 0 : Date.now();
    timeout = null;
    result = func.apply(context, args);
    if (!timeout) context = args = null;
  };
  return function () {
    var now = Date.now();
    if (!previous && options.leading === false) previous = now;
    var remaining = wait - (now - previous);
    context = this;
    args = arguments;
    if (remaining <= 0 || remaining > wait) {
      if (timeout) {
        clearTimeout(timeout);
        timeout = null;
      }
      previous = now;
      result = func.apply(context, args);
      if (!timeout) context = args = null;
    } else if (!timeout && options.trailing !== false) {
      timeout = setTimeout(later, remaining);
    }
    return result;
  };
}

function SignaturePad(canvas, options) {
  var self = this;
  var opts = options || {};

  this.velocityFilterWeight = opts.velocityFilterWeight || 0.7;
  this.minWidth = opts.minWidth || 0.5;
  this.maxWidth = opts.maxWidth || 2.5;
  this.throttle = 'throttle' in opts ? opts.throttle : 16; // in miliseconds
  this.minDistance = 'minDistance' in opts ? opts.minDistance : 5;

  if (this.throttle) {
    this._strokeMoveUpdate = throttle(SignaturePad.prototype._strokeUpdate, this.throttle);
  } else {
    this._strokeMoveUpdate = SignaturePad.prototype._strokeUpdate;
  }

  this.dotSize = opts.dotSize || function () {
    return (this.minWidth + this.maxWidth) / 2;
  };
  this.penColor = opts.penColor || 'black';
  this.backgroundColor = opts.backgroundColor || 'rgba(0,0,0,0)';
  this.onBegin = opts.onBegin;
  this.onEnd = opts.onEnd;

  this._canvas = canvas;
  this._ctx = canvas.getContext('2d');
  this.clear();

  // We need add these inline so they are available to unbind while still having
  // access to 'self' we could use _.bind but it's not worth adding a dependency.
  this._handleMouseDown = function (event) {
    if (event.which === 1) {
      self._mouseButtonDown = true;
      self._strokeBegin(event);
    }
  };

  this._handleMouseMove = function (event) {
    if (self._mouseButtonDown) {
      self._strokeMoveUpdate(event);
    }
  };

  this._handleMouseUp = function (event) {
    if (event.which === 1 && self._mouseButtonDown) {
      self._mouseButtonDown = false;
      self._strokeEnd(event);
    }
  };

  this._handleTouchStart = function (event) {
    if (event.targetTouches.length === 1) {
      var touch = event.changedTouches[0];
      self._strokeBegin(touch);
    }
  };

  this._handleTouchMove = function (event) {
    // Prevent scrolling.
    event.preventDefault();

    var touch = event.targetTouches[0];
    self._strokeMoveUpdate(touch);
  };

  this._handleTouchEnd = function (event) {
    var wasCanvasTouched = event.target === self._canvas;
    if (wasCanvasTouched) {
      event.preventDefault();
      self._strokeEnd(event);
    }
  };

  // Enable mouse and touch event handlers
  this.on();
}

// Public methods
SignaturePad.prototype.clear = function () {
  var ctx = this._ctx;
  var canvas = this._canvas;

  ctx.fillStyle = this.backgroundColor;
  ctx.clearRect(0, 0, canvas.width, canvas.height);
  ctx.fillRect(0, 0, canvas.width, canvas.height);

  this._data = [];
  this._reset();
  this._isEmpty = true;
};

SignaturePad.prototype.fromDataURL = function (dataUrl) {
  var _this = this;

  var options = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : {};

  var image = new Image();
  var ratio = options.ratio || window.devicePixelRatio || 1;
  var width = options.width || this._canvas.width / ratio;
  var height = options.height || this._canvas.height / ratio;

  this._reset();
  image.src = dataUrl;
  image.onload = function () {
    _this._ctx.drawImage(image, 0, 0, width, height);
  };
  this._isEmpty = false;
};

SignaturePad.prototype.toDataURL = function (type) {
  var _canvas;

  switch (type) {
    case 'image/svg+xml':
      return this._toSVG();
    default:
      for (var _len = arguments.length, options = Array(_len > 1 ? _len - 1 : 0), _key = 1; _key < _len; _key++) {
        options[_key - 1] = arguments[_key];
      }

      return (_canvas = this._canvas).toDataURL.apply(_canvas, [type].concat(options));
  }
};

SignaturePad.prototype.on = function () {
  this._handleMouseEvents();
  this._handleTouchEvents();
};

SignaturePad.prototype.off = function () {
  this._canvas.removeEventListener('mousedown', this._handleMouseDown);
  this._canvas.removeEventListener('mousemove', this._handleMouseMove);
  document.removeEventListener('mouseup', this._handleMouseUp);

  this._canvas.removeEventListener('touchstart', this._handleTouchStart);
  this._canvas.removeEventListener('touchmove', this._handleTouchMove);
  this._canvas.removeEventListener('touchend', this._handleTouchEnd);
};

SignaturePad.prototype.isEmpty = function () {
  return this._isEmpty;
};

// Private methods
SignaturePad.prototype._strokeBegin = function (event) {
  this._data.push([]);
  this._reset();
  this._strokeUpdate(event);

  if (typeof this.onBegin === 'function') {
    this.onBegin(event);
  }
};

SignaturePad.prototype._strokeUpdate = function (event) {
  var x = event.clientX;
  var y = event.clientY;

  var point = this._createPoint(x, y);
  var lastPointGroup = this._data[this._data.length - 1];
  var lastPoint = lastPointGroup && lastPointGroup[lastPointGroup.length - 1];
  var isLastPointTooClose = lastPoint && point.distanceTo(lastPoint) < this.minDistance;

  // Skip this point if it's too close to the previous one
  if (!(lastPoint && isLastPointTooClose)) {
    var _addPoint = this._addPoint(point),
        curve = _addPoint.curve,
        widths = _addPoint.widths;

    if (curve && widths) {
      this._drawCurve(curve, widths.start, widths.end);
    }

    this._data[this._data.length - 1].push({
      x: point.x,
      y: point.y,
      time: point.time,
      color: this.penColor
    });
  }
};

SignaturePad.prototype._strokeEnd = function (event) {
  var canDrawCurve = this.points.length > 2;
  var point = this.points[0]; // Point instance

  if (!canDrawCurve && point) {
    this._drawDot(point);
  }

  if (point) {
    var lastPointGroup = this._data[this._data.length - 1];
    var lastPoint = lastPointGroup[lastPointGroup.length - 1]; // plain object

    // When drawing a dot, there's only one point in a group, so without this check
    // such group would end up with exactly the same 2 points.
    if (!point.equals(lastPoint)) {
      lastPointGroup.push({
        x: point.x,
        y: point.y,
        time: point.time,
        color: this.penColor
      });
    }
  }

  if (typeof this.onEnd === 'function') {
    this.onEnd(event);
  }
};

SignaturePad.prototype._handleMouseEvents = function () {
  this._mouseButtonDown = false;

  this._canvas.addEventListener('mousedown', this._handleMouseDown);
  this._canvas.addEventListener('mousemove', this._handleMouseMove);
  document.addEventListener('mouseup', this._handleMouseUp);
};

SignaturePad.prototype._handleTouchEvents = function () {
  // Pass touch events to canvas element on mobile IE11 and Edge.
  this._canvas.style.msTouchAction = 'none';
  this._canvas.style.touchAction = 'none';

  this._canvas.addEventListener('touchstart', this._handleTouchStart);
  this._canvas.addEventListener('touchmove', this._handleTouchMove);
  this._canvas.addEventListener('touchend', this._handleTouchEnd);
};

SignaturePad.prototype._reset = function () {
  this.points = [];
  this._lastVelocity = 0;
  this._lastWidth = (this.minWidth + this.maxWidth) / 2;
  this._ctx.fillStyle = this.penColor;
};

SignaturePad.prototype._createPoint = function (x, y, time) {
  var rect = this._canvas.getBoundingClientRect();

  return new Point(x - rect.left, y - rect.top, time || new Date().getTime());
};

SignaturePad.prototype._addPoint = function (point) {
  var points = this.points;
  var tmp = void 0;

  points.push(point);

  if (points.length > 2) {
    // To reduce the initial lag make it work with 3 points
    // by copying the first point to the beginning.
    if (points.length === 3) points.unshift(points[0]);

    tmp = this._calculateCurveControlPoints(points[0], points[1], points[2]);
    var c2 = tmp.c2;
    tmp = this._calculateCurveControlPoints(points[1], points[2], points[3]);
    var c3 = tmp.c1;
    var curve = new Bezier(points[1], c2, c3, points[2]);
    var widths = this._calculateCurveWidths(curve);

    // Remove the first element from the list,
    // so that we always have no more than 4 points in points array.
    points.shift();

    return { curve: curve, widths: widths };
  }

  return {};
};

SignaturePad.prototype._calculateCurveControlPoints = function (s1, s2, s3) {
  var dx1 = s1.x - s2.x;
  var dy1 = s1.y - s2.y;
  var dx2 = s2.x - s3.x;
  var dy2 = s2.y - s3.y;

  var m1 = { x: (s1.x + s2.x) / 2.0, y: (s1.y + s2.y) / 2.0 };
  var m2 = { x: (s2.x + s3.x) / 2.0, y: (s2.y + s3.y) / 2.0 };

  var l1 = Math.sqrt(dx1 * dx1 + dy1 * dy1);
  var l2 = Math.sqrt(dx2 * dx2 + dy2 * dy2);

  var dxm = m1.x - m2.x;
  var dym = m1.y - m2.y;

  var k = l2 / (l1 + l2);
  var cm = { x: m2.x + dxm * k, y: m2.y + dym * k };

  var tx = s2.x - cm.x;
  var ty = s2.y - cm.y;

  return {
    c1: new Point(m1.x + tx, m1.y + ty),
    c2: new Point(m2.x + tx, m2.y + ty)
  };
};

SignaturePad.prototype._calculateCurveWidths = function (curve) {
  var startPoint = curve.startPoint;
  var endPoint = curve.endPoint;
  var widths = { start: null, end: null };

  var velocity = this.velocityFilterWeight * endPoint.velocityFrom(startPoint) + (1 - this.velocityFilterWeight) * this._lastVelocity;

  var newWidth = this._strokeWidth(velocity);

  widths.start = this._lastWidth;
  widths.end = newWidth;

  this._lastVelocity = velocity;
  this._lastWidth = newWidth;

  return widths;
};

SignaturePad.prototype._strokeWidth = function (velocity) {
  return Math.max(this.maxWidth / (velocity + 1), this.minWidth);
};

SignaturePad.prototype._drawPoint = function (x, y, size) {
  var ctx = this._ctx;

  ctx.moveTo(x, y);
  ctx.arc(x, y, size, 0, 2 * Math.PI, false);
  this._isEmpty = false;
};

SignaturePad.prototype._drawCurve = function (curve, startWidth, endWidth) {
  var ctx = this._ctx;
  var widthDelta = endWidth - startWidth;
  var drawSteps = Math.floor(curve.length());

  ctx.beginPath();

  for (var i = 0; i < drawSteps; i += 1) {
    // Calculate the Bezier (x, y) coordinate for this step.
    var t = i / drawSteps;
    var tt = t * t;
    var ttt = tt * t;
    var u = 1 - t;
    var uu = u * u;
    var uuu = uu * u;

    var x = uuu * curve.startPoint.x;
    x += 3 * uu * t * curve.control1.x;
    x += 3 * u * tt * curve.control2.x;
    x += ttt * curve.endPoint.x;

    var y = uuu * curve.startPoint.y;
    y += 3 * uu * t * curve.control1.y;
    y += 3 * u * tt * curve.control2.y;
    y += ttt * curve.endPoint.y;

    var width = startWidth + ttt * widthDelta;
    this._drawPoint(x, y, width);
  }

  ctx.closePath();
  ctx.fill();
};

SignaturePad.prototype._drawDot = function (point) {
  var ctx = this._ctx;
  var width = typeof this.dotSize === 'function' ? this.dotSize() : this.dotSize;

  ctx.beginPath();
  this._drawPoint(point.x, point.y, width);
  ctx.closePath();
  ctx.fill();
};

SignaturePad.prototype._fromData = function (pointGroups, drawCurve, drawDot) {
  for (var i = 0; i < pointGroups.length; i += 1) {
    var group = pointGroups[i];

    if (group.length > 1) {
      for (var j = 0; j < group.length; j += 1) {
        var rawPoint = group[j];
        var point = new Point(rawPoint.x, rawPoint.y, rawPoint.time);
        var color = rawPoint.color;

        if (j === 0) {
          // First point in a group. Nothing to draw yet.

          // All points in the group have the same color, so it's enough to set
          // penColor just at the beginning.
          this.penColor = color;
          this._reset();

          this._addPoint(point);
        } else if (j !== group.length - 1) {
          // Middle point in a group.
          var _addPoint2 = this._addPoint(point),
              curve = _addPoint2.curve,
              widths = _addPoint2.widths;

          if (curve && widths) {
            drawCurve(curve, widths, color);
          }
        } else {
          // Last point in a group. Do nothing.
        }
      }
    } else {
      this._reset();
      var _rawPoint = group[0];
      drawDot(_rawPoint);
    }
  }
};

SignaturePad.prototype._toSVG = function () {
  var _this2 = this;

  var pointGroups = this._data;
  var canvas = this._canvas;
  var ratio = Math.max(window.devicePixelRatio || 1, 1);
  var minX = 0;
  var minY = 0;
  var maxX = canvas.width / ratio;
  var maxY = canvas.height / ratio;
  var svg = document.createElementNS('http://www.w3.org/2000/svg', 'svg');

  svg.setAttributeNS(null, 'width', canvas.width);
  svg.setAttributeNS(null, 'height', canvas.height);

  this._fromData(pointGroups, function (curve, widths, color) {
    var path = document.createElement('path');

    // Need to check curve for NaN values, these pop up when drawing
    // lines on the canvas that are not continuous. E.g. Sharp corners
    // or stopping mid-stroke and than continuing without lifting mouse.
    if (!isNaN(curve.control1.x) && !isNaN(curve.control1.y) && !isNaN(curve.control2.x) && !isNaN(curve.control2.y)) {
      var attr = 'M ' + curve.startPoint.x.toFixed(3) + ',' + curve.startPoint.y.toFixed(3) + ' ' + ('C ' + curve.control1.x.toFixed(3) + ',' + curve.control1.y.toFixed(3) + ' ') + (curve.control2.x.toFixed(3) + ',' + curve.control2.y.toFixed(3) + ' ') + (curve.endPoint.x.toFixed(3) + ',' + curve.endPoint.y.toFixed(3));

      path.setAttribute('d', attr);
      path.setAttribute('stroke-width', (widths.end * 2.25).toFixed(3));
      path.setAttribute('stroke', color);
      path.setAttribute('fill', 'none');
      path.setAttribute('stroke-linecap', 'round');

      svg.appendChild(path);
    }
  }, function (rawPoint) {
    var circle = document.createElement('circle');
    var dotSize = typeof _this2.dotSize === 'function' ? _this2.dotSize() : _this2.dotSize;
    circle.setAttribute('r', dotSize);
    circle.setAttribute('cx', rawPoint.x);
    circle.setAttribute('cy', rawPoint.y);
    circle.setAttribute('fill', rawPoint.color);

    svg.appendChild(circle);
  });

  var prefix = 'data:image/svg+xml;base64,';
  var header = '<svg' + ' xmlns="http://www.w3.org/2000/svg"' + ' xmlns:xlink="http://www.w3.org/1999/xlink"' + (' viewBox="' + minX + ' ' + minY + ' ' + maxX + ' ' + maxY + '"') + (' width="' + maxX + '"') + (' height="' + maxY + '"') + '>';
  var body = svg.innerHTML;

  // IE hack for missing innerHTML property on SVGElement
  if (body === undefined) {
    var dummy = document.createElement('dummy');
    var nodes = svg.childNodes;
    dummy.innerHTML = '';

    for (var i = 0; i < nodes.length; i += 1) {
      dummy.appendChild(nodes[i].cloneNode(true));
    }

    body = dummy.innerHTML;
  }

  var footer = '</svg>';
  var data = header + body + footer;

  return prefix + btoa(data);
};

SignaturePad.prototype.fromData = function (pointGroups) {
  var _this3 = this;

  this.clear();

  this._fromData(pointGroups, function (curve, widths) {
    return _this3._drawCurve(curve, widths.start, widths.end);
  }, function (rawPoint) {
    return _this3._drawDot(rawPoint);
  });

  this._data = pointGroups;
};

SignaturePad.prototype.toData = function () {
  return this._data;
};

/* harmony default export */ __webpack_exports__["default"] = (SignaturePad);


/***/ }),

/***/ "./node_modules/sortablejs/modular/sortable.esm.js":
/*!*********************************************************!*\
  !*** ./node_modules/sortablejs/modular/sortable.esm.js ***!
  \*********************************************************/
/*! exports provided: default, MultiDrag, Sortable, Swap */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "MultiDrag", function() { return MultiDragPlugin; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "Sortable", function() { return Sortable; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "Swap", function() { return SwapPlugin; });
/**!
 * Sortable 1.13.0
 * @author	RubaXa   <trash@rubaxa.org>
 * @author	owenm    <owen23355@gmail.com>
 * @license MIT
 */
function _typeof(obj) {
  if (typeof Symbol === "function" && typeof Symbol.iterator === "symbol") {
    _typeof = function (obj) {
      return typeof obj;
    };
  } else {
    _typeof = function (obj) {
      return obj && typeof Symbol === "function" && obj.constructor === Symbol && obj !== Symbol.prototype ? "symbol" : typeof obj;
    };
  }

  return _typeof(obj);
}

function _defineProperty(obj, key, value) {
  if (key in obj) {
    Object.defineProperty(obj, key, {
      value: value,
      enumerable: true,
      configurable: true,
      writable: true
    });
  } else {
    obj[key] = value;
  }

  return obj;
}

function _extends() {
  _extends = Object.assign || function (target) {
    for (var i = 1; i < arguments.length; i++) {
      var source = arguments[i];

      for (var key in source) {
        if (Object.prototype.hasOwnProperty.call(source, key)) {
          target[key] = source[key];
        }
      }
    }

    return target;
  };

  return _extends.apply(this, arguments);
}

function _objectSpread(target) {
  for (var i = 1; i < arguments.length; i++) {
    var source = arguments[i] != null ? arguments[i] : {};
    var ownKeys = Object.keys(source);

    if (typeof Object.getOwnPropertySymbols === 'function') {
      ownKeys = ownKeys.concat(Object.getOwnPropertySymbols(source).filter(function (sym) {
        return Object.getOwnPropertyDescriptor(source, sym).enumerable;
      }));
    }

    ownKeys.forEach(function (key) {
      _defineProperty(target, key, source[key]);
    });
  }

  return target;
}

function _objectWithoutPropertiesLoose(source, excluded) {
  if (source == null) return {};
  var target = {};
  var sourceKeys = Object.keys(source);
  var key, i;

  for (i = 0; i < sourceKeys.length; i++) {
    key = sourceKeys[i];
    if (excluded.indexOf(key) >= 0) continue;
    target[key] = source[key];
  }

  return target;
}

function _objectWithoutProperties(source, excluded) {
  if (source == null) return {};

  var target = _objectWithoutPropertiesLoose(source, excluded);

  var key, i;

  if (Object.getOwnPropertySymbols) {
    var sourceSymbolKeys = Object.getOwnPropertySymbols(source);

    for (i = 0; i < sourceSymbolKeys.length; i++) {
      key = sourceSymbolKeys[i];
      if (excluded.indexOf(key) >= 0) continue;
      if (!Object.prototype.propertyIsEnumerable.call(source, key)) continue;
      target[key] = source[key];
    }
  }

  return target;
}

function _toConsumableArray(arr) {
  return _arrayWithoutHoles(arr) || _iterableToArray(arr) || _nonIterableSpread();
}

function _arrayWithoutHoles(arr) {
  if (Array.isArray(arr)) {
    for (var i = 0, arr2 = new Array(arr.length); i < arr.length; i++) arr2[i] = arr[i];

    return arr2;
  }
}

function _iterableToArray(iter) {
  if (Symbol.iterator in Object(iter) || Object.prototype.toString.call(iter) === "[object Arguments]") return Array.from(iter);
}

function _nonIterableSpread() {
  throw new TypeError("Invalid attempt to spread non-iterable instance");
}

var version = "1.13.0";

function userAgent(pattern) {
  if (typeof window !== 'undefined' && window.navigator) {
    return !!
    /*@__PURE__*/
    navigator.userAgent.match(pattern);
  }
}

var IE11OrLess = userAgent(/(?:Trident.*rv[ :]?11\.|msie|iemobile|Windows Phone)/i);
var Edge = userAgent(/Edge/i);
var FireFox = userAgent(/firefox/i);
var Safari = userAgent(/safari/i) && !userAgent(/chrome/i) && !userAgent(/android/i);
var IOS = userAgent(/iP(ad|od|hone)/i);
var ChromeForAndroid = userAgent(/chrome/i) && userAgent(/android/i);

var captureMode = {
  capture: false,
  passive: false
};

function on(el, event, fn) {
  el.addEventListener(event, fn, !IE11OrLess && captureMode);
}

function off(el, event, fn) {
  el.removeEventListener(event, fn, !IE11OrLess && captureMode);
}

function matches(
/**HTMLElement*/
el,
/**String*/
selector) {
  if (!selector) return;
  selector[0] === '>' && (selector = selector.substring(1));

  if (el) {
    try {
      if (el.matches) {
        return el.matches(selector);
      } else if (el.msMatchesSelector) {
        return el.msMatchesSelector(selector);
      } else if (el.webkitMatchesSelector) {
        return el.webkitMatchesSelector(selector);
      }
    } catch (_) {
      return false;
    }
  }

  return false;
}

function getParentOrHost(el) {
  return el.host && el !== document && el.host.nodeType ? el.host : el.parentNode;
}

function closest(
/**HTMLElement*/
el,
/**String*/
selector,
/**HTMLElement*/
ctx, includeCTX) {
  if (el) {
    ctx = ctx || document;

    do {
      if (selector != null && (selector[0] === '>' ? el.parentNode === ctx && matches(el, selector) : matches(el, selector)) || includeCTX && el === ctx) {
        return el;
      }

      if (el === ctx) break;
      /* jshint boss:true */
    } while (el = getParentOrHost(el));
  }

  return null;
}

var R_SPACE = /\s+/g;

function toggleClass(el, name, state) {
  if (el && name) {
    if (el.classList) {
      el.classList[state ? 'add' : 'remove'](name);
    } else {
      var className = (' ' + el.className + ' ').replace(R_SPACE, ' ').replace(' ' + name + ' ', ' ');
      el.className = (className + (state ? ' ' + name : '')).replace(R_SPACE, ' ');
    }
  }
}

function css(el, prop, val) {
  var style = el && el.style;

  if (style) {
    if (val === void 0) {
      if (document.defaultView && document.defaultView.getComputedStyle) {
        val = document.defaultView.getComputedStyle(el, '');
      } else if (el.currentStyle) {
        val = el.currentStyle;
      }

      return prop === void 0 ? val : val[prop];
    } else {
      if (!(prop in style) && prop.indexOf('webkit') === -1) {
        prop = '-webkit-' + prop;
      }

      style[prop] = val + (typeof val === 'string' ? '' : 'px');
    }
  }
}

function matrix(el, selfOnly) {
  var appliedTransforms = '';

  if (typeof el === 'string') {
    appliedTransforms = el;
  } else {
    do {
      var transform = css(el, 'transform');

      if (transform && transform !== 'none') {
        appliedTransforms = transform + ' ' + appliedTransforms;
      }
      /* jshint boss:true */

    } while (!selfOnly && (el = el.parentNode));
  }

  var matrixFn = window.DOMMatrix || window.WebKitCSSMatrix || window.CSSMatrix || window.MSCSSMatrix;
  /*jshint -W056 */

  return matrixFn && new matrixFn(appliedTransforms);
}

function find(ctx, tagName, iterator) {
  if (ctx) {
    var list = ctx.getElementsByTagName(tagName),
        i = 0,
        n = list.length;

    if (iterator) {
      for (; i < n; i++) {
        iterator(list[i], i);
      }
    }

    return list;
  }

  return [];
}

function getWindowScrollingElement() {
  var scrollingElement = document.scrollingElement;

  if (scrollingElement) {
    return scrollingElement;
  } else {
    return document.documentElement;
  }
}
/**
 * Returns the "bounding client rect" of given element
 * @param  {HTMLElement} el                       The element whose boundingClientRect is wanted
 * @param  {[Boolean]} relativeToContainingBlock  Whether the rect should be relative to the containing block of (including) the container
 * @param  {[Boolean]} relativeToNonStaticParent  Whether the rect should be relative to the relative parent of (including) the contaienr
 * @param  {[Boolean]} undoScale                  Whether the container's scale() should be undone
 * @param  {[HTMLElement]} container              The parent the element will be placed in
 * @return {Object}                               The boundingClientRect of el, with specified adjustments
 */


function getRect(el, relativeToContainingBlock, relativeToNonStaticParent, undoScale, container) {
  if (!el.getBoundingClientRect && el !== window) return;
  var elRect, top, left, bottom, right, height, width;

  if (el !== window && el.parentNode && el !== getWindowScrollingElement()) {
    elRect = el.getBoundingClientRect();
    top = elRect.top;
    left = elRect.left;
    bottom = elRect.bottom;
    right = elRect.right;
    height = elRect.height;
    width = elRect.width;
  } else {
    top = 0;
    left = 0;
    bottom = window.innerHeight;
    right = window.innerWidth;
    height = window.innerHeight;
    width = window.innerWidth;
  }

  if ((relativeToContainingBlock || relativeToNonStaticParent) && el !== window) {
    // Adjust for translate()
    container = container || el.parentNode; // solves #1123 (see: https://stackoverflow.com/a/37953806/6088312)
    // Not needed on <= IE11

    if (!IE11OrLess) {
      do {
        if (container && container.getBoundingClientRect && (css(container, 'transform') !== 'none' || relativeToNonStaticParent && css(container, 'position') !== 'static')) {
          var containerRect = container.getBoundingClientRect(); // Set relative to edges of padding box of container

          top -= containerRect.top + parseInt(css(container, 'border-top-width'));
          left -= containerRect.left + parseInt(css(container, 'border-left-width'));
          bottom = top + elRect.height;
          right = left + elRect.width;
          break;
        }
        /* jshint boss:true */

      } while (container = container.parentNode);
    }
  }

  if (undoScale && el !== window) {
    // Adjust for scale()
    var elMatrix = matrix(container || el),
        scaleX = elMatrix && elMatrix.a,
        scaleY = elMatrix && elMatrix.d;

    if (elMatrix) {
      top /= scaleY;
      left /= scaleX;
      width /= scaleX;
      height /= scaleY;
      bottom = top + height;
      right = left + width;
    }
  }

  return {
    top: top,
    left: left,
    bottom: bottom,
    right: right,
    width: width,
    height: height
  };
}
/**
 * Checks if a side of an element is scrolled past a side of its parents
 * @param  {HTMLElement}  el           The element who's side being scrolled out of view is in question
 * @param  {String}       elSide       Side of the element in question ('top', 'left', 'right', 'bottom')
 * @param  {String}       parentSide   Side of the parent in question ('top', 'left', 'right', 'bottom')
 * @return {HTMLElement}               The parent scroll element that the el's side is scrolled past, or null if there is no such element
 */


function isScrolledPast(el, elSide, parentSide) {
  var parent = getParentAutoScrollElement(el, true),
      elSideVal = getRect(el)[elSide];
  /* jshint boss:true */

  while (parent) {
    var parentSideVal = getRect(parent)[parentSide],
        visible = void 0;

    if (parentSide === 'top' || parentSide === 'left') {
      visible = elSideVal >= parentSideVal;
    } else {
      visible = elSideVal <= parentSideVal;
    }

    if (!visible) return parent;
    if (parent === getWindowScrollingElement()) break;
    parent = getParentAutoScrollElement(parent, false);
  }

  return false;
}
/**
 * Gets nth child of el, ignoring hidden children, sortable's elements (does not ignore clone if it's visible)
 * and non-draggable elements
 * @param  {HTMLElement} el       The parent element
 * @param  {Number} childNum      The index of the child
 * @param  {Object} options       Parent Sortable's options
 * @return {HTMLElement}          The child at index childNum, or null if not found
 */


function getChild(el, childNum, options) {
  var currentChild = 0,
      i = 0,
      children = el.children;

  while (i < children.length) {
    if (children[i].style.display !== 'none' && children[i] !== Sortable.ghost && children[i] !== Sortable.dragged && closest(children[i], options.draggable, el, false)) {
      if (currentChild === childNum) {
        return children[i];
      }

      currentChild++;
    }

    i++;
  }

  return null;
}
/**
 * Gets the last child in the el, ignoring ghostEl or invisible elements (clones)
 * @param  {HTMLElement} el       Parent element
 * @param  {selector} selector    Any other elements that should be ignored
 * @return {HTMLElement}          The last child, ignoring ghostEl
 */


function lastChild(el, selector) {
  var last = el.lastElementChild;

  while (last && (last === Sortable.ghost || css(last, 'display') === 'none' || selector && !matches(last, selector))) {
    last = last.previousElementSibling;
  }

  return last || null;
}
/**
 * Returns the index of an element within its parent for a selected set of
 * elements
 * @param  {HTMLElement} el
 * @param  {selector} selector
 * @return {number}
 */


function index(el, selector) {
  var index = 0;

  if (!el || !el.parentNode) {
    return -1;
  }
  /* jshint boss:true */


  while (el = el.previousElementSibling) {
    if (el.nodeName.toUpperCase() !== 'TEMPLATE' && el !== Sortable.clone && (!selector || matches(el, selector))) {
      index++;
    }
  }

  return index;
}
/**
 * Returns the scroll offset of the given element, added with all the scroll offsets of parent elements.
 * The value is returned in real pixels.
 * @param  {HTMLElement} el
 * @return {Array}             Offsets in the format of [left, top]
 */


function getRelativeScrollOffset(el) {
  var offsetLeft = 0,
      offsetTop = 0,
      winScroller = getWindowScrollingElement();

  if (el) {
    do {
      var elMatrix = matrix(el),
          scaleX = elMatrix.a,
          scaleY = elMatrix.d;
      offsetLeft += el.scrollLeft * scaleX;
      offsetTop += el.scrollTop * scaleY;
    } while (el !== winScroller && (el = el.parentNode));
  }

  return [offsetLeft, offsetTop];
}
/**
 * Returns the index of the object within the given array
 * @param  {Array} arr   Array that may or may not hold the object
 * @param  {Object} obj  An object that has a key-value pair unique to and identical to a key-value pair in the object you want to find
 * @return {Number}      The index of the object in the array, or -1
 */


function indexOfObject(arr, obj) {
  for (var i in arr) {
    if (!arr.hasOwnProperty(i)) continue;

    for (var key in obj) {
      if (obj.hasOwnProperty(key) && obj[key] === arr[i][key]) return Number(i);
    }
  }

  return -1;
}

function getParentAutoScrollElement(el, includeSelf) {
  // skip to window
  if (!el || !el.getBoundingClientRect) return getWindowScrollingElement();
  var elem = el;
  var gotSelf = false;

  do {
    // we don't need to get elem css if it isn't even overflowing in the first place (performance)
    if (elem.clientWidth < elem.scrollWidth || elem.clientHeight < elem.scrollHeight) {
      var elemCSS = css(elem);

      if (elem.clientWidth < elem.scrollWidth && (elemCSS.overflowX == 'auto' || elemCSS.overflowX == 'scroll') || elem.clientHeight < elem.scrollHeight && (elemCSS.overflowY == 'auto' || elemCSS.overflowY == 'scroll')) {
        if (!elem.getBoundingClientRect || elem === document.body) return getWindowScrollingElement();
        if (gotSelf || includeSelf) return elem;
        gotSelf = true;
      }
    }
    /* jshint boss:true */

  } while (elem = elem.parentNode);

  return getWindowScrollingElement();
}

function extend(dst, src) {
  if (dst && src) {
    for (var key in src) {
      if (src.hasOwnProperty(key)) {
        dst[key] = src[key];
      }
    }
  }

  return dst;
}

function isRectEqual(rect1, rect2) {
  return Math.round(rect1.top) === Math.round(rect2.top) && Math.round(rect1.left) === Math.round(rect2.left) && Math.round(rect1.height) === Math.round(rect2.height) && Math.round(rect1.width) === Math.round(rect2.width);
}

var _throttleTimeout;

function throttle(callback, ms) {
  return function () {
    if (!_throttleTimeout) {
      var args = arguments,
          _this = this;

      if (args.length === 1) {
        callback.call(_this, args[0]);
      } else {
        callback.apply(_this, args);
      }

      _throttleTimeout = setTimeout(function () {
        _throttleTimeout = void 0;
      }, ms);
    }
  };
}

function cancelThrottle() {
  clearTimeout(_throttleTimeout);
  _throttleTimeout = void 0;
}

function scrollBy(el, x, y) {
  el.scrollLeft += x;
  el.scrollTop += y;
}

function clone(el) {
  var Polymer = window.Polymer;
  var $ = window.jQuery || window.Zepto;

  if (Polymer && Polymer.dom) {
    return Polymer.dom(el).cloneNode(true);
  } else if ($) {
    return $(el).clone(true)[0];
  } else {
    return el.cloneNode(true);
  }
}

function setRect(el, rect) {
  css(el, 'position', 'absolute');
  css(el, 'top', rect.top);
  css(el, 'left', rect.left);
  css(el, 'width', rect.width);
  css(el, 'height', rect.height);
}

function unsetRect(el) {
  css(el, 'position', '');
  css(el, 'top', '');
  css(el, 'left', '');
  css(el, 'width', '');
  css(el, 'height', '');
}

var expando = 'Sortable' + new Date().getTime();

function AnimationStateManager() {
  var animationStates = [],
      animationCallbackId;
  return {
    captureAnimationState: function captureAnimationState() {
      animationStates = [];
      if (!this.options.animation) return;
      var children = [].slice.call(this.el.children);
      children.forEach(function (child) {
        if (css(child, 'display') === 'none' || child === Sortable.ghost) return;
        animationStates.push({
          target: child,
          rect: getRect(child)
        });

        var fromRect = _objectSpread({}, animationStates[animationStates.length - 1].rect); // If animating: compensate for current animation


        if (child.thisAnimationDuration) {
          var childMatrix = matrix(child, true);

          if (childMatrix) {
            fromRect.top -= childMatrix.f;
            fromRect.left -= childMatrix.e;
          }
        }

        child.fromRect = fromRect;
      });
    },
    addAnimationState: function addAnimationState(state) {
      animationStates.push(state);
    },
    removeAnimationState: function removeAnimationState(target) {
      animationStates.splice(indexOfObject(animationStates, {
        target: target
      }), 1);
    },
    animateAll: function animateAll(callback) {
      var _this = this;

      if (!this.options.animation) {
        clearTimeout(animationCallbackId);
        if (typeof callback === 'function') callback();
        return;
      }

      var animating = false,
          animationTime = 0;
      animationStates.forEach(function (state) {
        var time = 0,
            target = state.target,
            fromRect = target.fromRect,
            toRect = getRect(target),
            prevFromRect = target.prevFromRect,
            prevToRect = target.prevToRect,
            animatingRect = state.rect,
            targetMatrix = matrix(target, true);

        if (targetMatrix) {
          // Compensate for current animation
          toRect.top -= targetMatrix.f;
          toRect.left -= targetMatrix.e;
        }

        target.toRect = toRect;

        if (target.thisAnimationDuration) {
          // Could also check if animatingRect is between fromRect and toRect
          if (isRectEqual(prevFromRect, toRect) && !isRectEqual(fromRect, toRect) && // Make sure animatingRect is on line between toRect & fromRect
          (animatingRect.top - toRect.top) / (animatingRect.left - toRect.left) === (fromRect.top - toRect.top) / (fromRect.left - toRect.left)) {
            // If returning to same place as started from animation and on same axis
            time = calculateRealTime(animatingRect, prevFromRect, prevToRect, _this.options);
          }
        } // if fromRect != toRect: animate


        if (!isRectEqual(toRect, fromRect)) {
          target.prevFromRect = fromRect;
          target.prevToRect = toRect;

          if (!time) {
            time = _this.options.animation;
          }

          _this.animate(target, animatingRect, toRect, time);
        }

        if (time) {
          animating = true;
          animationTime = Math.max(animationTime, time);
          clearTimeout(target.animationResetTimer);
          target.animationResetTimer = setTimeout(function () {
            target.animationTime = 0;
            target.prevFromRect = null;
            target.fromRect = null;
            target.prevToRect = null;
            target.thisAnimationDuration = null;
          }, time);
          target.thisAnimationDuration = time;
        }
      });
      clearTimeout(animationCallbackId);

      if (!animating) {
        if (typeof callback === 'function') callback();
      } else {
        animationCallbackId = setTimeout(function () {
          if (typeof callback === 'function') callback();
        }, animationTime);
      }

      animationStates = [];
    },
    animate: function animate(target, currentRect, toRect, duration) {
      if (duration) {
        css(target, 'transition', '');
        css(target, 'transform', '');
        var elMatrix = matrix(this.el),
            scaleX = elMatrix && elMatrix.a,
            scaleY = elMatrix && elMatrix.d,
            translateX = (currentRect.left - toRect.left) / (scaleX || 1),
            translateY = (currentRect.top - toRect.top) / (scaleY || 1);
        target.animatingX = !!translateX;
        target.animatingY = !!translateY;
        css(target, 'transform', 'translate3d(' + translateX + 'px,' + translateY + 'px,0)');
        this.forRepaintDummy = repaint(target); // repaint

        css(target, 'transition', 'transform ' + duration + 'ms' + (this.options.easing ? ' ' + this.options.easing : ''));
        css(target, 'transform', 'translate3d(0,0,0)');
        typeof target.animated === 'number' && clearTimeout(target.animated);
        target.animated = setTimeout(function () {
          css(target, 'transition', '');
          css(target, 'transform', '');
          target.animated = false;
          target.animatingX = false;
          target.animatingY = false;
        }, duration);
      }
    }
  };
}

function repaint(target) {
  return target.offsetWidth;
}

function calculateRealTime(animatingRect, fromRect, toRect, options) {
  return Math.sqrt(Math.pow(fromRect.top - animatingRect.top, 2) + Math.pow(fromRect.left - animatingRect.left, 2)) / Math.sqrt(Math.pow(fromRect.top - toRect.top, 2) + Math.pow(fromRect.left - toRect.left, 2)) * options.animation;
}

var plugins = [];
var defaults = {
  initializeByDefault: true
};
var PluginManager = {
  mount: function mount(plugin) {
    // Set default static properties
    for (var option in defaults) {
      if (defaults.hasOwnProperty(option) && !(option in plugin)) {
        plugin[option] = defaults[option];
      }
    }

    plugins.forEach(function (p) {
      if (p.pluginName === plugin.pluginName) {
        throw "Sortable: Cannot mount plugin ".concat(plugin.pluginName, " more than once");
      }
    });
    plugins.push(plugin);
  },
  pluginEvent: function pluginEvent(eventName, sortable, evt) {
    var _this = this;

    this.eventCanceled = false;

    evt.cancel = function () {
      _this.eventCanceled = true;
    };

    var eventNameGlobal = eventName + 'Global';
    plugins.forEach(function (plugin) {
      if (!sortable[plugin.pluginName]) return; // Fire global events if it exists in this sortable

      if (sortable[plugin.pluginName][eventNameGlobal]) {
        sortable[plugin.pluginName][eventNameGlobal](_objectSpread({
          sortable: sortable
        }, evt));
      } // Only fire plugin event if plugin is enabled in this sortable,
      // and plugin has event defined


      if (sortable.options[plugin.pluginName] && sortable[plugin.pluginName][eventName]) {
        sortable[plugin.pluginName][eventName](_objectSpread({
          sortable: sortable
        }, evt));
      }
    });
  },
  initializePlugins: function initializePlugins(sortable, el, defaults, options) {
    plugins.forEach(function (plugin) {
      var pluginName = plugin.pluginName;
      if (!sortable.options[pluginName] && !plugin.initializeByDefault) return;
      var initialized = new plugin(sortable, el, sortable.options);
      initialized.sortable = sortable;
      initialized.options = sortable.options;
      sortable[pluginName] = initialized; // Add default options from plugin

      _extends(defaults, initialized.defaults);
    });

    for (var option in sortable.options) {
      if (!sortable.options.hasOwnProperty(option)) continue;
      var modified = this.modifyOption(sortable, option, sortable.options[option]);

      if (typeof modified !== 'undefined') {
        sortable.options[option] = modified;
      }
    }
  },
  getEventProperties: function getEventProperties(name, sortable) {
    var eventProperties = {};
    plugins.forEach(function (plugin) {
      if (typeof plugin.eventProperties !== 'function') return;

      _extends(eventProperties, plugin.eventProperties.call(sortable[plugin.pluginName], name));
    });
    return eventProperties;
  },
  modifyOption: function modifyOption(sortable, name, value) {
    var modifiedValue;
    plugins.forEach(function (plugin) {
      // Plugin must exist on the Sortable
      if (!sortable[plugin.pluginName]) return; // If static option listener exists for this option, call in the context of the Sortable's instance of this plugin

      if (plugin.optionListeners && typeof plugin.optionListeners[name] === 'function') {
        modifiedValue = plugin.optionListeners[name].call(sortable[plugin.pluginName], value);
      }
    });
    return modifiedValue;
  }
};

function dispatchEvent(_ref) {
  var sortable = _ref.sortable,
      rootEl = _ref.rootEl,
      name = _ref.name,
      targetEl = _ref.targetEl,
      cloneEl = _ref.cloneEl,
      toEl = _ref.toEl,
      fromEl = _ref.fromEl,
      oldIndex = _ref.oldIndex,
      newIndex = _ref.newIndex,
      oldDraggableIndex = _ref.oldDraggableIndex,
      newDraggableIndex = _ref.newDraggableIndex,
      originalEvent = _ref.originalEvent,
      putSortable = _ref.putSortable,
      extraEventProperties = _ref.extraEventProperties;
  sortable = sortable || rootEl && rootEl[expando];
  if (!sortable) return;
  var evt,
      options = sortable.options,
      onName = 'on' + name.charAt(0).toUpperCase() + name.substr(1); // Support for new CustomEvent feature

  if (window.CustomEvent && !IE11OrLess && !Edge) {
    evt = new CustomEvent(name, {
      bubbles: true,
      cancelable: true
    });
  } else {
    evt = document.createEvent('Event');
    evt.initEvent(name, true, true);
  }

  evt.to = toEl || rootEl;
  evt.from = fromEl || rootEl;
  evt.item = targetEl || rootEl;
  evt.clone = cloneEl;
  evt.oldIndex = oldIndex;
  evt.newIndex = newIndex;
  evt.oldDraggableIndex = oldDraggableIndex;
  evt.newDraggableIndex = newDraggableIndex;
  evt.originalEvent = originalEvent;
  evt.pullMode = putSortable ? putSortable.lastPutMode : undefined;

  var allEventProperties = _objectSpread({}, extraEventProperties, PluginManager.getEventProperties(name, sortable));

  for (var option in allEventProperties) {
    evt[option] = allEventProperties[option];
  }

  if (rootEl) {
    rootEl.dispatchEvent(evt);
  }

  if (options[onName]) {
    options[onName].call(sortable, evt);
  }
}

var pluginEvent = function pluginEvent(eventName, sortable) {
  var _ref = arguments.length > 2 && arguments[2] !== undefined ? arguments[2] : {},
      originalEvent = _ref.evt,
      data = _objectWithoutProperties(_ref, ["evt"]);

  PluginManager.pluginEvent.bind(Sortable)(eventName, sortable, _objectSpread({
    dragEl: dragEl,
    parentEl: parentEl,
    ghostEl: ghostEl,
    rootEl: rootEl,
    nextEl: nextEl,
    lastDownEl: lastDownEl,
    cloneEl: cloneEl,
    cloneHidden: cloneHidden,
    dragStarted: moved,
    putSortable: putSortable,
    activeSortable: Sortable.active,
    originalEvent: originalEvent,
    oldIndex: oldIndex,
    oldDraggableIndex: oldDraggableIndex,
    newIndex: newIndex,
    newDraggableIndex: newDraggableIndex,
    hideGhostForTarget: _hideGhostForTarget,
    unhideGhostForTarget: _unhideGhostForTarget,
    cloneNowHidden: function cloneNowHidden() {
      cloneHidden = true;
    },
    cloneNowShown: function cloneNowShown() {
      cloneHidden = false;
    },
    dispatchSortableEvent: function dispatchSortableEvent(name) {
      _dispatchEvent({
        sortable: sortable,
        name: name,
        originalEvent: originalEvent
      });
    }
  }, data));
};

function _dispatchEvent(info) {
  dispatchEvent(_objectSpread({
    putSortable: putSortable,
    cloneEl: cloneEl,
    targetEl: dragEl,
    rootEl: rootEl,
    oldIndex: oldIndex,
    oldDraggableIndex: oldDraggableIndex,
    newIndex: newIndex,
    newDraggableIndex: newDraggableIndex
  }, info));
}

var dragEl,
    parentEl,
    ghostEl,
    rootEl,
    nextEl,
    lastDownEl,
    cloneEl,
    cloneHidden,
    oldIndex,
    newIndex,
    oldDraggableIndex,
    newDraggableIndex,
    activeGroup,
    putSortable,
    awaitingDragStarted = false,
    ignoreNextClick = false,
    sortables = [],
    tapEvt,
    touchEvt,
    lastDx,
    lastDy,
    tapDistanceLeft,
    tapDistanceTop,
    moved,
    lastTarget,
    lastDirection,
    pastFirstInvertThresh = false,
    isCircumstantialInvert = false,
    targetMoveDistance,
    // For positioning ghost absolutely
ghostRelativeParent,
    ghostRelativeParentInitialScroll = [],
    // (left, top)
_silent = false,
    savedInputChecked = [];
/** @const */

var documentExists = typeof document !== 'undefined',
    PositionGhostAbsolutely = IOS,
    CSSFloatProperty = Edge || IE11OrLess ? 'cssFloat' : 'float',
    // This will not pass for IE9, because IE9 DnD only works on anchors
supportDraggable = documentExists && !ChromeForAndroid && !IOS && 'draggable' in document.createElement('div'),
    supportCssPointerEvents = function () {
  if (!documentExists) return; // false when <= IE11

  if (IE11OrLess) {
    return false;
  }

  var el = document.createElement('x');
  el.style.cssText = 'pointer-events:auto';
  return el.style.pointerEvents === 'auto';
}(),
    _detectDirection = function _detectDirection(el, options) {
  var elCSS = css(el),
      elWidth = parseInt(elCSS.width) - parseInt(elCSS.paddingLeft) - parseInt(elCSS.paddingRight) - parseInt(elCSS.borderLeftWidth) - parseInt(elCSS.borderRightWidth),
      child1 = getChild(el, 0, options),
      child2 = getChild(el, 1, options),
      firstChildCSS = child1 && css(child1),
      secondChildCSS = child2 && css(child2),
      firstChildWidth = firstChildCSS && parseInt(firstChildCSS.marginLeft) + parseInt(firstChildCSS.marginRight) + getRect(child1).width,
      secondChildWidth = secondChildCSS && parseInt(secondChildCSS.marginLeft) + parseInt(secondChildCSS.marginRight) + getRect(child2).width;

  if (elCSS.display === 'flex') {
    return elCSS.flexDirection === 'column' || elCSS.flexDirection === 'column-reverse' ? 'vertical' : 'horizontal';
  }

  if (elCSS.display === 'grid') {
    return elCSS.gridTemplateColumns.split(' ').length <= 1 ? 'vertical' : 'horizontal';
  }

  if (child1 && firstChildCSS["float"] && firstChildCSS["float"] !== 'none') {
    var touchingSideChild2 = firstChildCSS["float"] === 'left' ? 'left' : 'right';
    return child2 && (secondChildCSS.clear === 'both' || secondChildCSS.clear === touchingSideChild2) ? 'vertical' : 'horizontal';
  }

  return child1 && (firstChildCSS.display === 'block' || firstChildCSS.display === 'flex' || firstChildCSS.display === 'table' || firstChildCSS.display === 'grid' || firstChildWidth >= elWidth && elCSS[CSSFloatProperty] === 'none' || child2 && elCSS[CSSFloatProperty] === 'none' && firstChildWidth + secondChildWidth > elWidth) ? 'vertical' : 'horizontal';
},
    _dragElInRowColumn = function _dragElInRowColumn(dragRect, targetRect, vertical) {
  var dragElS1Opp = vertical ? dragRect.left : dragRect.top,
      dragElS2Opp = vertical ? dragRect.right : dragRect.bottom,
      dragElOppLength = vertical ? dragRect.width : dragRect.height,
      targetS1Opp = vertical ? targetRect.left : targetRect.top,
      targetS2Opp = vertical ? targetRect.right : targetRect.bottom,
      targetOppLength = vertical ? targetRect.width : targetRect.height;
  return dragElS1Opp === targetS1Opp || dragElS2Opp === targetS2Opp || dragElS1Opp + dragElOppLength / 2 === targetS1Opp + targetOppLength / 2;
},

/**
 * Detects first nearest empty sortable to X and Y position using emptyInsertThreshold.
 * @param  {Number} x      X position
 * @param  {Number} y      Y position
 * @return {HTMLElement}   Element of the first found nearest Sortable
 */
_detectNearestEmptySortable = function _detectNearestEmptySortable(x, y) {
  var ret;
  sortables.some(function (sortable) {
    if (lastChild(sortable)) return;
    var rect = getRect(sortable),
        threshold = sortable[expando].options.emptyInsertThreshold,
        insideHorizontally = x >= rect.left - threshold && x <= rect.right + threshold,
        insideVertically = y >= rect.top - threshold && y <= rect.bottom + threshold;

    if (threshold && insideHorizontally && insideVertically) {
      return ret = sortable;
    }
  });
  return ret;
},
    _prepareGroup = function _prepareGroup(options) {
  function toFn(value, pull) {
    return function (to, from, dragEl, evt) {
      var sameGroup = to.options.group.name && from.options.group.name && to.options.group.name === from.options.group.name;

      if (value == null && (pull || sameGroup)) {
        // Default pull value
        // Default pull and put value if same group
        return true;
      } else if (value == null || value === false) {
        return false;
      } else if (pull && value === 'clone') {
        return value;
      } else if (typeof value === 'function') {
        return toFn(value(to, from, dragEl, evt), pull)(to, from, dragEl, evt);
      } else {
        var otherGroup = (pull ? to : from).options.group.name;
        return value === true || typeof value === 'string' && value === otherGroup || value.join && value.indexOf(otherGroup) > -1;
      }
    };
  }

  var group = {};
  var originalGroup = options.group;

  if (!originalGroup || _typeof(originalGroup) != 'object') {
    originalGroup = {
      name: originalGroup
    };
  }

  group.name = originalGroup.name;
  group.checkPull = toFn(originalGroup.pull, true);
  group.checkPut = toFn(originalGroup.put);
  group.revertClone = originalGroup.revertClone;
  options.group = group;
},
    _hideGhostForTarget = function _hideGhostForTarget() {
  if (!supportCssPointerEvents && ghostEl) {
    css(ghostEl, 'display', 'none');
  }
},
    _unhideGhostForTarget = function _unhideGhostForTarget() {
  if (!supportCssPointerEvents && ghostEl) {
    css(ghostEl, 'display', '');
  }
}; // #1184 fix - Prevent click event on fallback if dragged but item not changed position


if (documentExists) {
  document.addEventListener('click', function (evt) {
    if (ignoreNextClick) {
      evt.preventDefault();
      evt.stopPropagation && evt.stopPropagation();
      evt.stopImmediatePropagation && evt.stopImmediatePropagation();
      ignoreNextClick = false;
      return false;
    }
  }, true);
}

var nearestEmptyInsertDetectEvent = function nearestEmptyInsertDetectEvent(evt) {
  if (dragEl) {
    evt = evt.touches ? evt.touches[0] : evt;

    var nearest = _detectNearestEmptySortable(evt.clientX, evt.clientY);

    if (nearest) {
      // Create imitation event
      var event = {};

      for (var i in evt) {
        if (evt.hasOwnProperty(i)) {
          event[i] = evt[i];
        }
      }

      event.target = event.rootEl = nearest;
      event.preventDefault = void 0;
      event.stopPropagation = void 0;

      nearest[expando]._onDragOver(event);
    }
  }
};

var _checkOutsideTargetEl = function _checkOutsideTargetEl(evt) {
  if (dragEl) {
    dragEl.parentNode[expando]._isOutsideThisEl(evt.target);
  }
};
/**
 * @class  Sortable
 * @param  {HTMLElement}  el
 * @param  {Object}       [options]
 */


function Sortable(el, options) {
  if (!(el && el.nodeType && el.nodeType === 1)) {
    throw "Sortable: `el` must be an HTMLElement, not ".concat({}.toString.call(el));
  }

  this.el = el; // root element

  this.options = options = _extends({}, options); // Export instance

  el[expando] = this;
  var defaults = {
    group: null,
    sort: true,
    disabled: false,
    store: null,
    handle: null,
    draggable: /^[uo]l$/i.test(el.nodeName) ? '>li' : '>*',
    swapThreshold: 1,
    // percentage; 0 <= x <= 1
    invertSwap: false,
    // invert always
    invertedSwapThreshold: null,
    // will be set to same as swapThreshold if default
    removeCloneOnHide: true,
    direction: function direction() {
      return _detectDirection(el, this.options);
    },
    ghostClass: 'sortable-ghost',
    chosenClass: 'sortable-chosen',
    dragClass: 'sortable-drag',
    ignore: 'a, img',
    filter: null,
    preventOnFilter: true,
    animation: 0,
    easing: null,
    setData: function setData(dataTransfer, dragEl) {
      dataTransfer.setData('Text', dragEl.textContent);
    },
    dropBubble: false,
    dragoverBubble: false,
    dataIdAttr: 'data-id',
    delay: 0,
    delayOnTouchOnly: false,
    touchStartThreshold: (Number.parseInt ? Number : window).parseInt(window.devicePixelRatio, 10) || 1,
    forceFallback: false,
    fallbackClass: 'sortable-fallback',
    fallbackOnBody: false,
    fallbackTolerance: 0,
    fallbackOffset: {
      x: 0,
      y: 0
    },
    supportPointer: Sortable.supportPointer !== false && 'PointerEvent' in window && !Safari,
    emptyInsertThreshold: 5
  };
  PluginManager.initializePlugins(this, el, defaults); // Set default options

  for (var name in defaults) {
    !(name in options) && (options[name] = defaults[name]);
  }

  _prepareGroup(options); // Bind all private methods


  for (var fn in this) {
    if (fn.charAt(0) === '_' && typeof this[fn] === 'function') {
      this[fn] = this[fn].bind(this);
    }
  } // Setup drag mode


  this.nativeDraggable = options.forceFallback ? false : supportDraggable;

  if (this.nativeDraggable) {
    // Touch start threshold cannot be greater than the native dragstart threshold
    this.options.touchStartThreshold = 1;
  } // Bind events


  if (options.supportPointer) {
    on(el, 'pointerdown', this._onTapStart);
  } else {
    on(el, 'mousedown', this._onTapStart);
    on(el, 'touchstart', this._onTapStart);
  }

  if (this.nativeDraggable) {
    on(el, 'dragover', this);
    on(el, 'dragenter', this);
  }

  sortables.push(this.el); // Restore sorting

  options.store && options.store.get && this.sort(options.store.get(this) || []); // Add animation state manager

  _extends(this, AnimationStateManager());
}

Sortable.prototype =
/** @lends Sortable.prototype */
{
  constructor: Sortable,
  _isOutsideThisEl: function _isOutsideThisEl(target) {
    if (!this.el.contains(target) && target !== this.el) {
      lastTarget = null;
    }
  },
  _getDirection: function _getDirection(evt, target) {
    return typeof this.options.direction === 'function' ? this.options.direction.call(this, evt, target, dragEl) : this.options.direction;
  },
  _onTapStart: function _onTapStart(
  /** Event|TouchEvent */
  evt) {
    if (!evt.cancelable) return;

    var _this = this,
        el = this.el,
        options = this.options,
        preventOnFilter = options.preventOnFilter,
        type = evt.type,
        touch = evt.touches && evt.touches[0] || evt.pointerType && evt.pointerType === 'touch' && evt,
        target = (touch || evt).target,
        originalTarget = evt.target.shadowRoot && (evt.path && evt.path[0] || evt.composedPath && evt.composedPath()[0]) || target,
        filter = options.filter;

    _saveInputCheckedState(el); // Don't trigger start event when an element is been dragged, otherwise the evt.oldindex always wrong when set option.group.


    if (dragEl) {
      return;
    }

    if (/mousedown|pointerdown/.test(type) && evt.button !== 0 || options.disabled) {
      return; // only left button and enabled
    } // cancel dnd if original target is content editable


    if (originalTarget.isContentEditable) {
      return;
    } // Safari ignores further event handling after mousedown


    if (!this.nativeDraggable && Safari && target && target.tagName.toUpperCase() === 'SELECT') {
      return;
    }

    target = closest(target, options.draggable, el, false);

    if (target && target.animated) {
      return;
    }

    if (lastDownEl === target) {
      // Ignoring duplicate `down`
      return;
    } // Get the index of the dragged element within its parent


    oldIndex = index(target);
    oldDraggableIndex = index(target, options.draggable); // Check filter

    if (typeof filter === 'function') {
      if (filter.call(this, evt, target, this)) {
        _dispatchEvent({
          sortable: _this,
          rootEl: originalTarget,
          name: 'filter',
          targetEl: target,
          toEl: el,
          fromEl: el
        });

        pluginEvent('filter', _this, {
          evt: evt
        });
        preventOnFilter && evt.cancelable && evt.preventDefault();
        return; // cancel dnd
      }
    } else if (filter) {
      filter = filter.split(',').some(function (criteria) {
        criteria = closest(originalTarget, criteria.trim(), el, false);

        if (criteria) {
          _dispatchEvent({
            sortable: _this,
            rootEl: criteria,
            name: 'filter',
            targetEl: target,
            fromEl: el,
            toEl: el
          });

          pluginEvent('filter', _this, {
            evt: evt
          });
          return true;
        }
      });

      if (filter) {
        preventOnFilter && evt.cancelable && evt.preventDefault();
        return; // cancel dnd
      }
    }

    if (options.handle && !closest(originalTarget, options.handle, el, false)) {
      return;
    } // Prepare `dragstart`


    this._prepareDragStart(evt, touch, target);
  },
  _prepareDragStart: function _prepareDragStart(
  /** Event */
  evt,
  /** Touch */
  touch,
  /** HTMLElement */
  target) {
    var _this = this,
        el = _this.el,
        options = _this.options,
        ownerDocument = el.ownerDocument,
        dragStartFn;

    if (target && !dragEl && target.parentNode === el) {
      var dragRect = getRect(target);
      rootEl = el;
      dragEl = target;
      parentEl = dragEl.parentNode;
      nextEl = dragEl.nextSibling;
      lastDownEl = target;
      activeGroup = options.group;
      Sortable.dragged = dragEl;
      tapEvt = {
        target: dragEl,
        clientX: (touch || evt).clientX,
        clientY: (touch || evt).clientY
      };
      tapDistanceLeft = tapEvt.clientX - dragRect.left;
      tapDistanceTop = tapEvt.clientY - dragRect.top;
      this._lastX = (touch || evt).clientX;
      this._lastY = (touch || evt).clientY;
      dragEl.style['will-change'] = 'all';

      dragStartFn = function dragStartFn() {
        pluginEvent('delayEnded', _this, {
          evt: evt
        });

        if (Sortable.eventCanceled) {
          _this._onDrop();

          return;
        } // Delayed drag has been triggered
        // we can re-enable the events: touchmove/mousemove


        _this._disableDelayedDragEvents();

        if (!FireFox && _this.nativeDraggable) {
          dragEl.draggable = true;
        } // Bind the events: dragstart/dragend


        _this._triggerDragStart(evt, touch); // Drag start event


        _dispatchEvent({
          sortable: _this,
          name: 'choose',
          originalEvent: evt
        }); // Chosen item


        toggleClass(dragEl, options.chosenClass, true);
      }; // Disable "draggable"


      options.ignore.split(',').forEach(function (criteria) {
        find(dragEl, criteria.trim(), _disableDraggable);
      });
      on(ownerDocument, 'dragover', nearestEmptyInsertDetectEvent);
      on(ownerDocument, 'mousemove', nearestEmptyInsertDetectEvent);
      on(ownerDocument, 'touchmove', nearestEmptyInsertDetectEvent);
      on(ownerDocument, 'mouseup', _this._onDrop);
      on(ownerDocument, 'touchend', _this._onDrop);
      on(ownerDocument, 'touchcancel', _this._onDrop); // Make dragEl draggable (must be before delay for FireFox)

      if (FireFox && this.nativeDraggable) {
        this.options.touchStartThreshold = 4;
        dragEl.draggable = true;
      }

      pluginEvent('delayStart', this, {
        evt: evt
      }); // Delay is impossible for native DnD in Edge or IE

      if (options.delay && (!options.delayOnTouchOnly || touch) && (!this.nativeDraggable || !(Edge || IE11OrLess))) {
        if (Sortable.eventCanceled) {
          this._onDrop();

          return;
        } // If the user moves the pointer or let go the click or touch
        // before the delay has been reached:
        // disable the delayed drag


        on(ownerDocument, 'mouseup', _this._disableDelayedDrag);
        on(ownerDocument, 'touchend', _this._disableDelayedDrag);
        on(ownerDocument, 'touchcancel', _this._disableDelayedDrag);
        on(ownerDocument, 'mousemove', _this._delayedDragTouchMoveHandler);
        on(ownerDocument, 'touchmove', _this._delayedDragTouchMoveHandler);
        options.supportPointer && on(ownerDocument, 'pointermove', _this._delayedDragTouchMoveHandler);
        _this._dragStartTimer = setTimeout(dragStartFn, options.delay);
      } else {
        dragStartFn();
      }
    }
  },
  _delayedDragTouchMoveHandler: function _delayedDragTouchMoveHandler(
  /** TouchEvent|PointerEvent **/
  e) {
    var touch = e.touches ? e.touches[0] : e;

    if (Math.max(Math.abs(touch.clientX - this._lastX), Math.abs(touch.clientY - this._lastY)) >= Math.floor(this.options.touchStartThreshold / (this.nativeDraggable && window.devicePixelRatio || 1))) {
      this._disableDelayedDrag();
    }
  },
  _disableDelayedDrag: function _disableDelayedDrag() {
    dragEl && _disableDraggable(dragEl);
    clearTimeout(this._dragStartTimer);

    this._disableDelayedDragEvents();
  },
  _disableDelayedDragEvents: function _disableDelayedDragEvents() {
    var ownerDocument = this.el.ownerDocument;
    off(ownerDocument, 'mouseup', this._disableDelayedDrag);
    off(ownerDocument, 'touchend', this._disableDelayedDrag);
    off(ownerDocument, 'touchcancel', this._disableDelayedDrag);
    off(ownerDocument, 'mousemove', this._delayedDragTouchMoveHandler);
    off(ownerDocument, 'touchmove', this._delayedDragTouchMoveHandler);
    off(ownerDocument, 'pointermove', this._delayedDragTouchMoveHandler);
  },
  _triggerDragStart: function _triggerDragStart(
  /** Event */
  evt,
  /** Touch */
  touch) {
    touch = touch || evt.pointerType == 'touch' && evt;

    if (!this.nativeDraggable || touch) {
      if (this.options.supportPointer) {
        on(document, 'pointermove', this._onTouchMove);
      } else if (touch) {
        on(document, 'touchmove', this._onTouchMove);
      } else {
        on(document, 'mousemove', this._onTouchMove);
      }
    } else {
      on(dragEl, 'dragend', this);
      on(rootEl, 'dragstart', this._onDragStart);
    }

    try {
      if (document.selection) {
        // Timeout neccessary for IE9
        _nextTick(function () {
          document.selection.empty();
        });
      } else {
        window.getSelection().removeAllRanges();
      }
    } catch (err) {}
  },
  _dragStarted: function _dragStarted(fallback, evt) {

    awaitingDragStarted = false;

    if (rootEl && dragEl) {
      pluginEvent('dragStarted', this, {
        evt: evt
      });

      if (this.nativeDraggable) {
        on(document, 'dragover', _checkOutsideTargetEl);
      }

      var options = this.options; // Apply effect

      !fallback && toggleClass(dragEl, options.dragClass, false);
      toggleClass(dragEl, options.ghostClass, true);
      Sortable.active = this;
      fallback && this._appendGhost(); // Drag start event

      _dispatchEvent({
        sortable: this,
        name: 'start',
        originalEvent: evt
      });
    } else {
      this._nulling();
    }
  },
  _emulateDragOver: function _emulateDragOver() {
    if (touchEvt) {
      this._lastX = touchEvt.clientX;
      this._lastY = touchEvt.clientY;

      _hideGhostForTarget();

      var target = document.elementFromPoint(touchEvt.clientX, touchEvt.clientY);
      var parent = target;

      while (target && target.shadowRoot) {
        target = target.shadowRoot.elementFromPoint(touchEvt.clientX, touchEvt.clientY);
        if (target === parent) break;
        parent = target;
      }

      dragEl.parentNode[expando]._isOutsideThisEl(target);

      if (parent) {
        do {
          if (parent[expando]) {
            var inserted = void 0;
            inserted = parent[expando]._onDragOver({
              clientX: touchEvt.clientX,
              clientY: touchEvt.clientY,
              target: target,
              rootEl: parent
            });

            if (inserted && !this.options.dragoverBubble) {
              break;
            }
          }

          target = parent; // store last element
        }
        /* jshint boss:true */
        while (parent = parent.parentNode);
      }

      _unhideGhostForTarget();
    }
  },
  _onTouchMove: function _onTouchMove(
  /**TouchEvent*/
  evt) {
    if (tapEvt) {
      var options = this.options,
          fallbackTolerance = options.fallbackTolerance,
          fallbackOffset = options.fallbackOffset,
          touch = evt.touches ? evt.touches[0] : evt,
          ghostMatrix = ghostEl && matrix(ghostEl, true),
          scaleX = ghostEl && ghostMatrix && ghostMatrix.a,
          scaleY = ghostEl && ghostMatrix && ghostMatrix.d,
          relativeScrollOffset = PositionGhostAbsolutely && ghostRelativeParent && getRelativeScrollOffset(ghostRelativeParent),
          dx = (touch.clientX - tapEvt.clientX + fallbackOffset.x) / (scaleX || 1) + (relativeScrollOffset ? relativeScrollOffset[0] - ghostRelativeParentInitialScroll[0] : 0) / (scaleX || 1),
          dy = (touch.clientY - tapEvt.clientY + fallbackOffset.y) / (scaleY || 1) + (relativeScrollOffset ? relativeScrollOffset[1] - ghostRelativeParentInitialScroll[1] : 0) / (scaleY || 1); // only set the status to dragging, when we are actually dragging

      if (!Sortable.active && !awaitingDragStarted) {
        if (fallbackTolerance && Math.max(Math.abs(touch.clientX - this._lastX), Math.abs(touch.clientY - this._lastY)) < fallbackTolerance) {
          return;
        }

        this._onDragStart(evt, true);
      }

      if (ghostEl) {
        if (ghostMatrix) {
          ghostMatrix.e += dx - (lastDx || 0);
          ghostMatrix.f += dy - (lastDy || 0);
        } else {
          ghostMatrix = {
            a: 1,
            b: 0,
            c: 0,
            d: 1,
            e: dx,
            f: dy
          };
        }

        var cssMatrix = "matrix(".concat(ghostMatrix.a, ",").concat(ghostMatrix.b, ",").concat(ghostMatrix.c, ",").concat(ghostMatrix.d, ",").concat(ghostMatrix.e, ",").concat(ghostMatrix.f, ")");
        css(ghostEl, 'webkitTransform', cssMatrix);
        css(ghostEl, 'mozTransform', cssMatrix);
        css(ghostEl, 'msTransform', cssMatrix);
        css(ghostEl, 'transform', cssMatrix);
        lastDx = dx;
        lastDy = dy;
        touchEvt = touch;
      }

      evt.cancelable && evt.preventDefault();
    }
  },
  _appendGhost: function _appendGhost() {
    // Bug if using scale(): https://stackoverflow.com/questions/2637058
    // Not being adjusted for
    if (!ghostEl) {
      var container = this.options.fallbackOnBody ? document.body : rootEl,
          rect = getRect(dragEl, true, PositionGhostAbsolutely, true, container),
          options = this.options; // Position absolutely

      if (PositionGhostAbsolutely) {
        // Get relatively positioned parent
        ghostRelativeParent = container;

        while (css(ghostRelativeParent, 'position') === 'static' && css(ghostRelativeParent, 'transform') === 'none' && ghostRelativeParent !== document) {
          ghostRelativeParent = ghostRelativeParent.parentNode;
        }

        if (ghostRelativeParent !== document.body && ghostRelativeParent !== document.documentElement) {
          if (ghostRelativeParent === document) ghostRelativeParent = getWindowScrollingElement();
          rect.top += ghostRelativeParent.scrollTop;
          rect.left += ghostRelativeParent.scrollLeft;
        } else {
          ghostRelativeParent = getWindowScrollingElement();
        }

        ghostRelativeParentInitialScroll = getRelativeScrollOffset(ghostRelativeParent);
      }

      ghostEl = dragEl.cloneNode(true);
      toggleClass(ghostEl, options.ghostClass, false);
      toggleClass(ghostEl, options.fallbackClass, true);
      toggleClass(ghostEl, options.dragClass, true);
      css(ghostEl, 'transition', '');
      css(ghostEl, 'transform', '');
      css(ghostEl, 'box-sizing', 'border-box');
      css(ghostEl, 'margin', 0);
      css(ghostEl, 'top', rect.top);
      css(ghostEl, 'left', rect.left);
      css(ghostEl, 'width', rect.width);
      css(ghostEl, 'height', rect.height);
      css(ghostEl, 'opacity', '0.8');
      css(ghostEl, 'position', PositionGhostAbsolutely ? 'absolute' : 'fixed');
      css(ghostEl, 'zIndex', '100000');
      css(ghostEl, 'pointerEvents', 'none');
      Sortable.ghost = ghostEl;
      container.appendChild(ghostEl); // Set transform-origin

      css(ghostEl, 'transform-origin', tapDistanceLeft / parseInt(ghostEl.style.width) * 100 + '% ' + tapDistanceTop / parseInt(ghostEl.style.height) * 100 + '%');
    }
  },
  _onDragStart: function _onDragStart(
  /**Event*/
  evt,
  /**boolean*/
  fallback) {
    var _this = this;

    var dataTransfer = evt.dataTransfer;
    var options = _this.options;
    pluginEvent('dragStart', this, {
      evt: evt
    });

    if (Sortable.eventCanceled) {
      this._onDrop();

      return;
    }

    pluginEvent('setupClone', this);

    if (!Sortable.eventCanceled) {
      cloneEl = clone(dragEl);
      cloneEl.draggable = false;
      cloneEl.style['will-change'] = '';

      this._hideClone();

      toggleClass(cloneEl, this.options.chosenClass, false);
      Sortable.clone = cloneEl;
    } // #1143: IFrame support workaround


    _this.cloneId = _nextTick(function () {
      pluginEvent('clone', _this);
      if (Sortable.eventCanceled) return;

      if (!_this.options.removeCloneOnHide) {
        rootEl.insertBefore(cloneEl, dragEl);
      }

      _this._hideClone();

      _dispatchEvent({
        sortable: _this,
        name: 'clone'
      });
    });
    !fallback && toggleClass(dragEl, options.dragClass, true); // Set proper drop events

    if (fallback) {
      ignoreNextClick = true;
      _this._loopId = setInterval(_this._emulateDragOver, 50);
    } else {
      // Undo what was set in _prepareDragStart before drag started
      off(document, 'mouseup', _this._onDrop);
      off(document, 'touchend', _this._onDrop);
      off(document, 'touchcancel', _this._onDrop);

      if (dataTransfer) {
        dataTransfer.effectAllowed = 'move';
        options.setData && options.setData.call(_this, dataTransfer, dragEl);
      }

      on(document, 'drop', _this); // #1276 fix:

      css(dragEl, 'transform', 'translateZ(0)');
    }

    awaitingDragStarted = true;
    _this._dragStartId = _nextTick(_this._dragStarted.bind(_this, fallback, evt));
    on(document, 'selectstart', _this);
    moved = true;

    if (Safari) {
      css(document.body, 'user-select', 'none');
    }
  },
  // Returns true - if no further action is needed (either inserted or another condition)
  _onDragOver: function _onDragOver(
  /**Event*/
  evt) {
    var el = this.el,
        target = evt.target,
        dragRect,
        targetRect,
        revert,
        options = this.options,
        group = options.group,
        activeSortable = Sortable.active,
        isOwner = activeGroup === group,
        canSort = options.sort,
        fromSortable = putSortable || activeSortable,
        vertical,
        _this = this,
        completedFired = false;

    if (_silent) return;

    function dragOverEvent(name, extra) {
      pluginEvent(name, _this, _objectSpread({
        evt: evt,
        isOwner: isOwner,
        axis: vertical ? 'vertical' : 'horizontal',
        revert: revert,
        dragRect: dragRect,
        targetRect: targetRect,
        canSort: canSort,
        fromSortable: fromSortable,
        target: target,
        completed: completed,
        onMove: function onMove(target, after) {
          return _onMove(rootEl, el, dragEl, dragRect, target, getRect(target), evt, after);
        },
        changed: changed
      }, extra));
    } // Capture animation state


    function capture() {
      dragOverEvent('dragOverAnimationCapture');

      _this.captureAnimationState();

      if (_this !== fromSortable) {
        fromSortable.captureAnimationState();
      }
    } // Return invocation when dragEl is inserted (or completed)


    function completed(insertion) {
      dragOverEvent('dragOverCompleted', {
        insertion: insertion
      });

      if (insertion) {
        // Clones must be hidden before folding animation to capture dragRectAbsolute properly
        if (isOwner) {
          activeSortable._hideClone();
        } else {
          activeSortable._showClone(_this);
        }

        if (_this !== fromSortable) {
          // Set ghost class to new sortable's ghost class
          toggleClass(dragEl, putSortable ? putSortable.options.ghostClass : activeSortable.options.ghostClass, false);
          toggleClass(dragEl, options.ghostClass, true);
        }

        if (putSortable !== _this && _this !== Sortable.active) {
          putSortable = _this;
        } else if (_this === Sortable.active && putSortable) {
          putSortable = null;
        } // Animation


        if (fromSortable === _this) {
          _this._ignoreWhileAnimating = target;
        }

        _this.animateAll(function () {
          dragOverEvent('dragOverAnimationComplete');
          _this._ignoreWhileAnimating = null;
        });

        if (_this !== fromSortable) {
          fromSortable.animateAll();
          fromSortable._ignoreWhileAnimating = null;
        }
      } // Null lastTarget if it is not inside a previously swapped element


      if (target === dragEl && !dragEl.animated || target === el && !target.animated) {
        lastTarget = null;
      } // no bubbling and not fallback


      if (!options.dragoverBubble && !evt.rootEl && target !== document) {
        dragEl.parentNode[expando]._isOutsideThisEl(evt.target); // Do not detect for empty insert if already inserted


        !insertion && nearestEmptyInsertDetectEvent(evt);
      }

      !options.dragoverBubble && evt.stopPropagation && evt.stopPropagation();
      return completedFired = true;
    } // Call when dragEl has been inserted


    function changed() {
      newIndex = index(dragEl);
      newDraggableIndex = index(dragEl, options.draggable);

      _dispatchEvent({
        sortable: _this,
        name: 'change',
        toEl: el,
        newIndex: newIndex,
        newDraggableIndex: newDraggableIndex,
        originalEvent: evt
      });
    }

    if (evt.preventDefault !== void 0) {
      evt.cancelable && evt.preventDefault();
    }

    target = closest(target, options.draggable, el, true);
    dragOverEvent('dragOver');
    if (Sortable.eventCanceled) return completedFired;

    if (dragEl.contains(evt.target) || target.animated && target.animatingX && target.animatingY || _this._ignoreWhileAnimating === target) {
      return completed(false);
    }

    ignoreNextClick = false;

    if (activeSortable && !options.disabled && (isOwner ? canSort || (revert = !rootEl.contains(dragEl)) // Reverting item into the original list
    : putSortable === this || (this.lastPutMode = activeGroup.checkPull(this, activeSortable, dragEl, evt)) && group.checkPut(this, activeSortable, dragEl, evt))) {
      vertical = this._getDirection(evt, target) === 'vertical';
      dragRect = getRect(dragEl);
      dragOverEvent('dragOverValid');
      if (Sortable.eventCanceled) return completedFired;

      if (revert) {
        parentEl = rootEl; // actualization

        capture();

        this._hideClone();

        dragOverEvent('revert');

        if (!Sortable.eventCanceled) {
          if (nextEl) {
            rootEl.insertBefore(dragEl, nextEl);
          } else {
            rootEl.appendChild(dragEl);
          }
        }

        return completed(true);
      }

      var elLastChild = lastChild(el, options.draggable);

      if (!elLastChild || _ghostIsLast(evt, vertical, this) && !elLastChild.animated) {
        // If already at end of list: Do not insert
        if (elLastChild === dragEl) {
          return completed(false);
        } // assign target only if condition is true


        if (elLastChild && el === evt.target) {
          target = elLastChild;
        }

        if (target) {
          targetRect = getRect(target);
        }

        if (_onMove(rootEl, el, dragEl, dragRect, target, targetRect, evt, !!target) !== false) {
          capture();
          el.appendChild(dragEl);
          parentEl = el; // actualization

          changed();
          return completed(true);
        }
      } else if (target.parentNode === el) {
        targetRect = getRect(target);
        var direction = 0,
            targetBeforeFirstSwap,
            differentLevel = dragEl.parentNode !== el,
            differentRowCol = !_dragElInRowColumn(dragEl.animated && dragEl.toRect || dragRect, target.animated && target.toRect || targetRect, vertical),
            side1 = vertical ? 'top' : 'left',
            scrolledPastTop = isScrolledPast(target, 'top', 'top') || isScrolledPast(dragEl, 'top', 'top'),
            scrollBefore = scrolledPastTop ? scrolledPastTop.scrollTop : void 0;

        if (lastTarget !== target) {
          targetBeforeFirstSwap = targetRect[side1];
          pastFirstInvertThresh = false;
          isCircumstantialInvert = !differentRowCol && options.invertSwap || differentLevel;
        }

        direction = _getSwapDirection(evt, target, targetRect, vertical, differentRowCol ? 1 : options.swapThreshold, options.invertedSwapThreshold == null ? options.swapThreshold : options.invertedSwapThreshold, isCircumstantialInvert, lastTarget === target);
        var sibling;

        if (direction !== 0) {
          // Check if target is beside dragEl in respective direction (ignoring hidden elements)
          var dragIndex = index(dragEl);

          do {
            dragIndex -= direction;
            sibling = parentEl.children[dragIndex];
          } while (sibling && (css(sibling, 'display') === 'none' || sibling === ghostEl));
        } // If dragEl is already beside target: Do not insert


        if (direction === 0 || sibling === target) {
          return completed(false);
        }

        lastTarget = target;
        lastDirection = direction;
        var nextSibling = target.nextElementSibling,
            after = false;
        after = direction === 1;

        var moveVector = _onMove(rootEl, el, dragEl, dragRect, target, targetRect, evt, after);

        if (moveVector !== false) {
          if (moveVector === 1 || moveVector === -1) {
            after = moveVector === 1;
          }

          _silent = true;
          setTimeout(_unsilent, 30);
          capture();

          if (after && !nextSibling) {
            el.appendChild(dragEl);
          } else {
            target.parentNode.insertBefore(dragEl, after ? nextSibling : target);
          } // Undo chrome's scroll adjustment (has no effect on other browsers)


          if (scrolledPastTop) {
            scrollBy(scrolledPastTop, 0, scrollBefore - scrolledPastTop.scrollTop);
          }

          parentEl = dragEl.parentNode; // actualization
          // must be done before animation

          if (targetBeforeFirstSwap !== undefined && !isCircumstantialInvert) {
            targetMoveDistance = Math.abs(targetBeforeFirstSwap - getRect(target)[side1]);
          }

          changed();
          return completed(true);
        }
      }

      if (el.contains(dragEl)) {
        return completed(false);
      }
    }

    return false;
  },
  _ignoreWhileAnimating: null,
  _offMoveEvents: function _offMoveEvents() {
    off(document, 'mousemove', this._onTouchMove);
    off(document, 'touchmove', this._onTouchMove);
    off(document, 'pointermove', this._onTouchMove);
    off(document, 'dragover', nearestEmptyInsertDetectEvent);
    off(document, 'mousemove', nearestEmptyInsertDetectEvent);
    off(document, 'touchmove', nearestEmptyInsertDetectEvent);
  },
  _offUpEvents: function _offUpEvents() {
    var ownerDocument = this.el.ownerDocument;
    off(ownerDocument, 'mouseup', this._onDrop);
    off(ownerDocument, 'touchend', this._onDrop);
    off(ownerDocument, 'pointerup', this._onDrop);
    off(ownerDocument, 'touchcancel', this._onDrop);
    off(document, 'selectstart', this);
  },
  _onDrop: function _onDrop(
  /**Event*/
  evt) {
    var el = this.el,
        options = this.options; // Get the index of the dragged element within its parent

    newIndex = index(dragEl);
    newDraggableIndex = index(dragEl, options.draggable);
    pluginEvent('drop', this, {
      evt: evt
    });
    parentEl = dragEl && dragEl.parentNode; // Get again after plugin event

    newIndex = index(dragEl);
    newDraggableIndex = index(dragEl, options.draggable);

    if (Sortable.eventCanceled) {
      this._nulling();

      return;
    }

    awaitingDragStarted = false;
    isCircumstantialInvert = false;
    pastFirstInvertThresh = false;
    clearInterval(this._loopId);
    clearTimeout(this._dragStartTimer);

    _cancelNextTick(this.cloneId);

    _cancelNextTick(this._dragStartId); // Unbind events


    if (this.nativeDraggable) {
      off(document, 'drop', this);
      off(el, 'dragstart', this._onDragStart);
    }

    this._offMoveEvents();

    this._offUpEvents();

    if (Safari) {
      css(document.body, 'user-select', '');
    }

    css(dragEl, 'transform', '');

    if (evt) {
      if (moved) {
        evt.cancelable && evt.preventDefault();
        !options.dropBubble && evt.stopPropagation();
      }

      ghostEl && ghostEl.parentNode && ghostEl.parentNode.removeChild(ghostEl);

      if (rootEl === parentEl || putSortable && putSortable.lastPutMode !== 'clone') {
        // Remove clone(s)
        cloneEl && cloneEl.parentNode && cloneEl.parentNode.removeChild(cloneEl);
      }

      if (dragEl) {
        if (this.nativeDraggable) {
          off(dragEl, 'dragend', this);
        }

        _disableDraggable(dragEl);

        dragEl.style['will-change'] = ''; // Remove classes
        // ghostClass is added in dragStarted

        if (moved && !awaitingDragStarted) {
          toggleClass(dragEl, putSortable ? putSortable.options.ghostClass : this.options.ghostClass, false);
        }

        toggleClass(dragEl, this.options.chosenClass, false); // Drag stop event

        _dispatchEvent({
          sortable: this,
          name: 'unchoose',
          toEl: parentEl,
          newIndex: null,
          newDraggableIndex: null,
          originalEvent: evt
        });

        if (rootEl !== parentEl) {
          if (newIndex >= 0) {
            // Add event
            _dispatchEvent({
              rootEl: parentEl,
              name: 'add',
              toEl: parentEl,
              fromEl: rootEl,
              originalEvent: evt
            }); // Remove event


            _dispatchEvent({
              sortable: this,
              name: 'remove',
              toEl: parentEl,
              originalEvent: evt
            }); // drag from one list and drop into another


            _dispatchEvent({
              rootEl: parentEl,
              name: 'sort',
              toEl: parentEl,
              fromEl: rootEl,
              originalEvent: evt
            });

            _dispatchEvent({
              sortable: this,
              name: 'sort',
              toEl: parentEl,
              originalEvent: evt
            });
          }

          putSortable && putSortable.save();
        } else {
          if (newIndex !== oldIndex) {
            if (newIndex >= 0) {
              // drag & drop within the same list
              _dispatchEvent({
                sortable: this,
                name: 'update',
                toEl: parentEl,
                originalEvent: evt
              });

              _dispatchEvent({
                sortable: this,
                name: 'sort',
                toEl: parentEl,
                originalEvent: evt
              });
            }
          }
        }

        if (Sortable.active) {
          /* jshint eqnull:true */
          if (newIndex == null || newIndex === -1) {
            newIndex = oldIndex;
            newDraggableIndex = oldDraggableIndex;
          }

          _dispatchEvent({
            sortable: this,
            name: 'end',
            toEl: parentEl,
            originalEvent: evt
          }); // Save sorting


          this.save();
        }
      }
    }

    this._nulling();
  },
  _nulling: function _nulling() {
    pluginEvent('nulling', this);
    rootEl = dragEl = parentEl = ghostEl = nextEl = cloneEl = lastDownEl = cloneHidden = tapEvt = touchEvt = moved = newIndex = newDraggableIndex = oldIndex = oldDraggableIndex = lastTarget = lastDirection = putSortable = activeGroup = Sortable.dragged = Sortable.ghost = Sortable.clone = Sortable.active = null;
    savedInputChecked.forEach(function (el) {
      el.checked = true;
    });
    savedInputChecked.length = lastDx = lastDy = 0;
  },
  handleEvent: function handleEvent(
  /**Event*/
  evt) {
    switch (evt.type) {
      case 'drop':
      case 'dragend':
        this._onDrop(evt);

        break;

      case 'dragenter':
      case 'dragover':
        if (dragEl) {
          this._onDragOver(evt);

          _globalDragOver(evt);
        }

        break;

      case 'selectstart':
        evt.preventDefault();
        break;
    }
  },

  /**
   * Serializes the item into an array of string.
   * @returns {String[]}
   */
  toArray: function toArray() {
    var order = [],
        el,
        children = this.el.children,
        i = 0,
        n = children.length,
        options = this.options;

    for (; i < n; i++) {
      el = children[i];

      if (closest(el, options.draggable, this.el, false)) {
        order.push(el.getAttribute(options.dataIdAttr) || _generateId(el));
      }
    }

    return order;
  },

  /**
   * Sorts the elements according to the array.
   * @param  {String[]}  order  order of the items
   */
  sort: function sort(order, useAnimation) {
    var items = {},
        rootEl = this.el;
    this.toArray().forEach(function (id, i) {
      var el = rootEl.children[i];

      if (closest(el, this.options.draggable, rootEl, false)) {
        items[id] = el;
      }
    }, this);
    useAnimation && this.captureAnimationState();
    order.forEach(function (id) {
      if (items[id]) {
        rootEl.removeChild(items[id]);
        rootEl.appendChild(items[id]);
      }
    });
    useAnimation && this.animateAll();
  },

  /**
   * Save the current sorting
   */
  save: function save() {
    var store = this.options.store;
    store && store.set && store.set(this);
  },

  /**
   * For each element in the set, get the first element that matches the selector by testing the element itself and traversing up through its ancestors in the DOM tree.
   * @param   {HTMLElement}  el
   * @param   {String}       [selector]  default: `options.draggable`
   * @returns {HTMLElement|null}
   */
  closest: function closest$1(el, selector) {
    return closest(el, selector || this.options.draggable, this.el, false);
  },

  /**
   * Set/get option
   * @param   {string} name
   * @param   {*}      [value]
   * @returns {*}
   */
  option: function option(name, value) {
    var options = this.options;

    if (value === void 0) {
      return options[name];
    } else {
      var modifiedValue = PluginManager.modifyOption(this, name, value);

      if (typeof modifiedValue !== 'undefined') {
        options[name] = modifiedValue;
      } else {
        options[name] = value;
      }

      if (name === 'group') {
        _prepareGroup(options);
      }
    }
  },

  /**
   * Destroy
   */
  destroy: function destroy() {
    pluginEvent('destroy', this);
    var el = this.el;
    el[expando] = null;
    off(el, 'mousedown', this._onTapStart);
    off(el, 'touchstart', this._onTapStart);
    off(el, 'pointerdown', this._onTapStart);

    if (this.nativeDraggable) {
      off(el, 'dragover', this);
      off(el, 'dragenter', this);
    } // Remove draggable attributes


    Array.prototype.forEach.call(el.querySelectorAll('[draggable]'), function (el) {
      el.removeAttribute('draggable');
    });

    this._onDrop();

    this._disableDelayedDragEvents();

    sortables.splice(sortables.indexOf(this.el), 1);
    this.el = el = null;
  },
  _hideClone: function _hideClone() {
    if (!cloneHidden) {
      pluginEvent('hideClone', this);
      if (Sortable.eventCanceled) return;
      css(cloneEl, 'display', 'none');

      if (this.options.removeCloneOnHide && cloneEl.parentNode) {
        cloneEl.parentNode.removeChild(cloneEl);
      }

      cloneHidden = true;
    }
  },
  _showClone: function _showClone(putSortable) {
    if (putSortable.lastPutMode !== 'clone') {
      this._hideClone();

      return;
    }

    if (cloneHidden) {
      pluginEvent('showClone', this);
      if (Sortable.eventCanceled) return; // show clone at dragEl or original position

      if (dragEl.parentNode == rootEl && !this.options.group.revertClone) {
        rootEl.insertBefore(cloneEl, dragEl);
      } else if (nextEl) {
        rootEl.insertBefore(cloneEl, nextEl);
      } else {
        rootEl.appendChild(cloneEl);
      }

      if (this.options.group.revertClone) {
        this.animate(dragEl, cloneEl);
      }

      css(cloneEl, 'display', '');
      cloneHidden = false;
    }
  }
};

function _globalDragOver(
/**Event*/
evt) {
  if (evt.dataTransfer) {
    evt.dataTransfer.dropEffect = 'move';
  }

  evt.cancelable && evt.preventDefault();
}

function _onMove(fromEl, toEl, dragEl, dragRect, targetEl, targetRect, originalEvent, willInsertAfter) {
  var evt,
      sortable = fromEl[expando],
      onMoveFn = sortable.options.onMove,
      retVal; // Support for new CustomEvent feature

  if (window.CustomEvent && !IE11OrLess && !Edge) {
    evt = new CustomEvent('move', {
      bubbles: true,
      cancelable: true
    });
  } else {
    evt = document.createEvent('Event');
    evt.initEvent('move', true, true);
  }

  evt.to = toEl;
  evt.from = fromEl;
  evt.dragged = dragEl;
  evt.draggedRect = dragRect;
  evt.related = targetEl || toEl;
  evt.relatedRect = targetRect || getRect(toEl);
  evt.willInsertAfter = willInsertAfter;
  evt.originalEvent = originalEvent;
  fromEl.dispatchEvent(evt);

  if (onMoveFn) {
    retVal = onMoveFn.call(sortable, evt, originalEvent);
  }

  return retVal;
}

function _disableDraggable(el) {
  el.draggable = false;
}

function _unsilent() {
  _silent = false;
}

function _ghostIsLast(evt, vertical, sortable) {
  var rect = getRect(lastChild(sortable.el, sortable.options.draggable));
  var spacer = 10;
  return vertical ? evt.clientX > rect.right + spacer || evt.clientX <= rect.right && evt.clientY > rect.bottom && evt.clientX >= rect.left : evt.clientX > rect.right && evt.clientY > rect.top || evt.clientX <= rect.right && evt.clientY > rect.bottom + spacer;
}

function _getSwapDirection(evt, target, targetRect, vertical, swapThreshold, invertedSwapThreshold, invertSwap, isLastTarget) {
  var mouseOnAxis = vertical ? evt.clientY : evt.clientX,
      targetLength = vertical ? targetRect.height : targetRect.width,
      targetS1 = vertical ? targetRect.top : targetRect.left,
      targetS2 = vertical ? targetRect.bottom : targetRect.right,
      invert = false;

  if (!invertSwap) {
    // Never invert or create dragEl shadow when target movemenet causes mouse to move past the end of regular swapThreshold
    if (isLastTarget && targetMoveDistance < targetLength * swapThreshold) {
      // multiplied only by swapThreshold because mouse will already be inside target by (1 - threshold) * targetLength / 2
      // check if past first invert threshold on side opposite of lastDirection
      if (!pastFirstInvertThresh && (lastDirection === 1 ? mouseOnAxis > targetS1 + targetLength * invertedSwapThreshold / 2 : mouseOnAxis < targetS2 - targetLength * invertedSwapThreshold / 2)) {
        // past first invert threshold, do not restrict inverted threshold to dragEl shadow
        pastFirstInvertThresh = true;
      }

      if (!pastFirstInvertThresh) {
        // dragEl shadow (target move distance shadow)
        if (lastDirection === 1 ? mouseOnAxis < targetS1 + targetMoveDistance // over dragEl shadow
        : mouseOnAxis > targetS2 - targetMoveDistance) {
          return -lastDirection;
        }
      } else {
        invert = true;
      }
    } else {
      // Regular
      if (mouseOnAxis > targetS1 + targetLength * (1 - swapThreshold) / 2 && mouseOnAxis < targetS2 - targetLength * (1 - swapThreshold) / 2) {
        return _getInsertDirection(target);
      }
    }
  }

  invert = invert || invertSwap;

  if (invert) {
    // Invert of regular
    if (mouseOnAxis < targetS1 + targetLength * invertedSwapThreshold / 2 || mouseOnAxis > targetS2 - targetLength * invertedSwapThreshold / 2) {
      return mouseOnAxis > targetS1 + targetLength / 2 ? 1 : -1;
    }
  }

  return 0;
}
/**
 * Gets the direction dragEl must be swapped relative to target in order to make it
 * seem that dragEl has been "inserted" into that element's position
 * @param  {HTMLElement} target       The target whose position dragEl is being inserted at
 * @return {Number}                   Direction dragEl must be swapped
 */


function _getInsertDirection(target) {
  if (index(dragEl) < index(target)) {
    return 1;
  } else {
    return -1;
  }
}
/**
 * Generate id
 * @param   {HTMLElement} el
 * @returns {String}
 * @private
 */


function _generateId(el) {
  var str = el.tagName + el.className + el.src + el.href + el.textContent,
      i = str.length,
      sum = 0;

  while (i--) {
    sum += str.charCodeAt(i);
  }

  return sum.toString(36);
}

function _saveInputCheckedState(root) {
  savedInputChecked.length = 0;
  var inputs = root.getElementsByTagName('input');
  var idx = inputs.length;

  while (idx--) {
    var el = inputs[idx];
    el.checked && savedInputChecked.push(el);
  }
}

function _nextTick(fn) {
  return setTimeout(fn, 0);
}

function _cancelNextTick(id) {
  return clearTimeout(id);
} // Fixed #973:


if (documentExists) {
  on(document, 'touchmove', function (evt) {
    if ((Sortable.active || awaitingDragStarted) && evt.cancelable) {
      evt.preventDefault();
    }
  });
} // Export utils


Sortable.utils = {
  on: on,
  off: off,
  css: css,
  find: find,
  is: function is(el, selector) {
    return !!closest(el, selector, el, false);
  },
  extend: extend,
  throttle: throttle,
  closest: closest,
  toggleClass: toggleClass,
  clone: clone,
  index: index,
  nextTick: _nextTick,
  cancelNextTick: _cancelNextTick,
  detectDirection: _detectDirection,
  getChild: getChild
};
/**
 * Get the Sortable instance of an element
 * @param  {HTMLElement} element The element
 * @return {Sortable|undefined}         The instance of Sortable
 */

Sortable.get = function (element) {
  return element[expando];
};
/**
 * Mount a plugin to Sortable
 * @param  {...SortablePlugin|SortablePlugin[]} plugins       Plugins being mounted
 */


Sortable.mount = function () {
  for (var _len = arguments.length, plugins = new Array(_len), _key = 0; _key < _len; _key++) {
    plugins[_key] = arguments[_key];
  }

  if (plugins[0].constructor === Array) plugins = plugins[0];
  plugins.forEach(function (plugin) {
    if (!plugin.prototype || !plugin.prototype.constructor) {
      throw "Sortable: Mounted plugin must be a constructor function, not ".concat({}.toString.call(plugin));
    }

    if (plugin.utils) Sortable.utils = _objectSpread({}, Sortable.utils, plugin.utils);
    PluginManager.mount(plugin);
  });
};
/**
 * Create sortable instance
 * @param {HTMLElement}  el
 * @param {Object}      [options]
 */


Sortable.create = function (el, options) {
  return new Sortable(el, options);
}; // Export


Sortable.version = version;

var autoScrolls = [],
    scrollEl,
    scrollRootEl,
    scrolling = false,
    lastAutoScrollX,
    lastAutoScrollY,
    touchEvt$1,
    pointerElemChangedInterval;

function AutoScrollPlugin() {
  function AutoScroll() {
    this.defaults = {
      scroll: true,
      scrollSensitivity: 30,
      scrollSpeed: 10,
      bubbleScroll: true
    }; // Bind all private methods

    for (var fn in this) {
      if (fn.charAt(0) === '_' && typeof this[fn] === 'function') {
        this[fn] = this[fn].bind(this);
      }
    }
  }

  AutoScroll.prototype = {
    dragStarted: function dragStarted(_ref) {
      var originalEvent = _ref.originalEvent;

      if (this.sortable.nativeDraggable) {
        on(document, 'dragover', this._handleAutoScroll);
      } else {
        if (this.options.supportPointer) {
          on(document, 'pointermove', this._handleFallbackAutoScroll);
        } else if (originalEvent.touches) {
          on(document, 'touchmove', this._handleFallbackAutoScroll);
        } else {
          on(document, 'mousemove', this._handleFallbackAutoScroll);
        }
      }
    },
    dragOverCompleted: function dragOverCompleted(_ref2) {
      var originalEvent = _ref2.originalEvent;

      // For when bubbling is canceled and using fallback (fallback 'touchmove' always reached)
      if (!this.options.dragOverBubble && !originalEvent.rootEl) {
        this._handleAutoScroll(originalEvent);
      }
    },
    drop: function drop() {
      if (this.sortable.nativeDraggable) {
        off(document, 'dragover', this._handleAutoScroll);
      } else {
        off(document, 'pointermove', this._handleFallbackAutoScroll);
        off(document, 'touchmove', this._handleFallbackAutoScroll);
        off(document, 'mousemove', this._handleFallbackAutoScroll);
      }

      clearPointerElemChangedInterval();
      clearAutoScrolls();
      cancelThrottle();
    },
    nulling: function nulling() {
      touchEvt$1 = scrollRootEl = scrollEl = scrolling = pointerElemChangedInterval = lastAutoScrollX = lastAutoScrollY = null;
      autoScrolls.length = 0;
    },
    _handleFallbackAutoScroll: function _handleFallbackAutoScroll(evt) {
      this._handleAutoScroll(evt, true);
    },
    _handleAutoScroll: function _handleAutoScroll(evt, fallback) {
      var _this = this;

      var x = (evt.touches ? evt.touches[0] : evt).clientX,
          y = (evt.touches ? evt.touches[0] : evt).clientY,
          elem = document.elementFromPoint(x, y);
      touchEvt$1 = evt; // IE does not seem to have native autoscroll,
      // Edge's autoscroll seems too conditional,
      // MACOS Safari does not have autoscroll,
      // Firefox and Chrome are good

      if (fallback || Edge || IE11OrLess || Safari) {
        autoScroll(evt, this.options, elem, fallback); // Listener for pointer element change

        var ogElemScroller = getParentAutoScrollElement(elem, true);

        if (scrolling && (!pointerElemChangedInterval || x !== lastAutoScrollX || y !== lastAutoScrollY)) {
          pointerElemChangedInterval && clearPointerElemChangedInterval(); // Detect for pointer elem change, emulating native DnD behaviour

          pointerElemChangedInterval = setInterval(function () {
            var newElem = getParentAutoScrollElement(document.elementFromPoint(x, y), true);

            if (newElem !== ogElemScroller) {
              ogElemScroller = newElem;
              clearAutoScrolls();
            }

            autoScroll(evt, _this.options, newElem, fallback);
          }, 10);
          lastAutoScrollX = x;
          lastAutoScrollY = y;
        }
      } else {
        // if DnD is enabled (and browser has good autoscrolling), first autoscroll will already scroll, so get parent autoscroll of first autoscroll
        if (!this.options.bubbleScroll || getParentAutoScrollElement(elem, true) === getWindowScrollingElement()) {
          clearAutoScrolls();
          return;
        }

        autoScroll(evt, this.options, getParentAutoScrollElement(elem, false), false);
      }
    }
  };
  return _extends(AutoScroll, {
    pluginName: 'scroll',
    initializeByDefault: true
  });
}

function clearAutoScrolls() {
  autoScrolls.forEach(function (autoScroll) {
    clearInterval(autoScroll.pid);
  });
  autoScrolls = [];
}

function clearPointerElemChangedInterval() {
  clearInterval(pointerElemChangedInterval);
}

var autoScroll = throttle(function (evt, options, rootEl, isFallback) {
  // Bug: https://bugzilla.mozilla.org/show_bug.cgi?id=505521
  if (!options.scroll) return;
  var x = (evt.touches ? evt.touches[0] : evt).clientX,
      y = (evt.touches ? evt.touches[0] : evt).clientY,
      sens = options.scrollSensitivity,
      speed = options.scrollSpeed,
      winScroller = getWindowScrollingElement();
  var scrollThisInstance = false,
      scrollCustomFn; // New scroll root, set scrollEl

  if (scrollRootEl !== rootEl) {
    scrollRootEl = rootEl;
    clearAutoScrolls();
    scrollEl = options.scroll;
    scrollCustomFn = options.scrollFn;

    if (scrollEl === true) {
      scrollEl = getParentAutoScrollElement(rootEl, true);
    }
  }

  var layersOut = 0;
  var currentParent = scrollEl;

  do {
    var el = currentParent,
        rect = getRect(el),
        top = rect.top,
        bottom = rect.bottom,
        left = rect.left,
        right = rect.right,
        width = rect.width,
        height = rect.height,
        canScrollX = void 0,
        canScrollY = void 0,
        scrollWidth = el.scrollWidth,
        scrollHeight = el.scrollHeight,
        elCSS = css(el),
        scrollPosX = el.scrollLeft,
        scrollPosY = el.scrollTop;

    if (el === winScroller) {
      canScrollX = width < scrollWidth && (elCSS.overflowX === 'auto' || elCSS.overflowX === 'scroll' || elCSS.overflowX === 'visible');
      canScrollY = height < scrollHeight && (elCSS.overflowY === 'auto' || elCSS.overflowY === 'scroll' || elCSS.overflowY === 'visible');
    } else {
      canScrollX = width < scrollWidth && (elCSS.overflowX === 'auto' || elCSS.overflowX === 'scroll');
      canScrollY = height < scrollHeight && (elCSS.overflowY === 'auto' || elCSS.overflowY === 'scroll');
    }

    var vx = canScrollX && (Math.abs(right - x) <= sens && scrollPosX + width < scrollWidth) - (Math.abs(left - x) <= sens && !!scrollPosX);
    var vy = canScrollY && (Math.abs(bottom - y) <= sens && scrollPosY + height < scrollHeight) - (Math.abs(top - y) <= sens && !!scrollPosY);

    if (!autoScrolls[layersOut]) {
      for (var i = 0; i <= layersOut; i++) {
        if (!autoScrolls[i]) {
          autoScrolls[i] = {};
        }
      }
    }

    if (autoScrolls[layersOut].vx != vx || autoScrolls[layersOut].vy != vy || autoScrolls[layersOut].el !== el) {
      autoScrolls[layersOut].el = el;
      autoScrolls[layersOut].vx = vx;
      autoScrolls[layersOut].vy = vy;
      clearInterval(autoScrolls[layersOut].pid);

      if (vx != 0 || vy != 0) {
        scrollThisInstance = true;
        /* jshint loopfunc:true */

        autoScrolls[layersOut].pid = setInterval(function () {
          // emulate drag over during autoscroll (fallback), emulating native DnD behaviour
          if (isFallback && this.layer === 0) {
            Sortable.active._onTouchMove(touchEvt$1); // To move ghost if it is positioned absolutely

          }

          var scrollOffsetY = autoScrolls[this.layer].vy ? autoScrolls[this.layer].vy * speed : 0;
          var scrollOffsetX = autoScrolls[this.layer].vx ? autoScrolls[this.layer].vx * speed : 0;

          if (typeof scrollCustomFn === 'function') {
            if (scrollCustomFn.call(Sortable.dragged.parentNode[expando], scrollOffsetX, scrollOffsetY, evt, touchEvt$1, autoScrolls[this.layer].el) !== 'continue') {
              return;
            }
          }

          scrollBy(autoScrolls[this.layer].el, scrollOffsetX, scrollOffsetY);
        }.bind({
          layer: layersOut
        }), 24);
      }
    }

    layersOut++;
  } while (options.bubbleScroll && currentParent !== winScroller && (currentParent = getParentAutoScrollElement(currentParent, false)));

  scrolling = scrollThisInstance; // in case another function catches scrolling as false in between when it is not
}, 30);

var drop = function drop(_ref) {
  var originalEvent = _ref.originalEvent,
      putSortable = _ref.putSortable,
      dragEl = _ref.dragEl,
      activeSortable = _ref.activeSortable,
      dispatchSortableEvent = _ref.dispatchSortableEvent,
      hideGhostForTarget = _ref.hideGhostForTarget,
      unhideGhostForTarget = _ref.unhideGhostForTarget;
  if (!originalEvent) return;
  var toSortable = putSortable || activeSortable;
  hideGhostForTarget();
  var touch = originalEvent.changedTouches && originalEvent.changedTouches.length ? originalEvent.changedTouches[0] : originalEvent;
  var target = document.elementFromPoint(touch.clientX, touch.clientY);
  unhideGhostForTarget();

  if (toSortable && !toSortable.el.contains(target)) {
    dispatchSortableEvent('spill');
    this.onSpill({
      dragEl: dragEl,
      putSortable: putSortable
    });
  }
};

function Revert() {}

Revert.prototype = {
  startIndex: null,
  dragStart: function dragStart(_ref2) {
    var oldDraggableIndex = _ref2.oldDraggableIndex;
    this.startIndex = oldDraggableIndex;
  },
  onSpill: function onSpill(_ref3) {
    var dragEl = _ref3.dragEl,
        putSortable = _ref3.putSortable;
    this.sortable.captureAnimationState();

    if (putSortable) {
      putSortable.captureAnimationState();
    }

    var nextSibling = getChild(this.sortable.el, this.startIndex, this.options);

    if (nextSibling) {
      this.sortable.el.insertBefore(dragEl, nextSibling);
    } else {
      this.sortable.el.appendChild(dragEl);
    }

    this.sortable.animateAll();

    if (putSortable) {
      putSortable.animateAll();
    }
  },
  drop: drop
};

_extends(Revert, {
  pluginName: 'revertOnSpill'
});

function Remove() {}

Remove.prototype = {
  onSpill: function onSpill(_ref4) {
    var dragEl = _ref4.dragEl,
        putSortable = _ref4.putSortable;
    var parentSortable = putSortable || this.sortable;
    parentSortable.captureAnimationState();
    dragEl.parentNode && dragEl.parentNode.removeChild(dragEl);
    parentSortable.animateAll();
  },
  drop: drop
};

_extends(Remove, {
  pluginName: 'removeOnSpill'
});

var lastSwapEl;

function SwapPlugin() {
  function Swap() {
    this.defaults = {
      swapClass: 'sortable-swap-highlight'
    };
  }

  Swap.prototype = {
    dragStart: function dragStart(_ref) {
      var dragEl = _ref.dragEl;
      lastSwapEl = dragEl;
    },
    dragOverValid: function dragOverValid(_ref2) {
      var completed = _ref2.completed,
          target = _ref2.target,
          onMove = _ref2.onMove,
          activeSortable = _ref2.activeSortable,
          changed = _ref2.changed,
          cancel = _ref2.cancel;
      if (!activeSortable.options.swap) return;
      var el = this.sortable.el,
          options = this.options;

      if (target && target !== el) {
        var prevSwapEl = lastSwapEl;

        if (onMove(target) !== false) {
          toggleClass(target, options.swapClass, true);
          lastSwapEl = target;
        } else {
          lastSwapEl = null;
        }

        if (prevSwapEl && prevSwapEl !== lastSwapEl) {
          toggleClass(prevSwapEl, options.swapClass, false);
        }
      }

      changed();
      completed(true);
      cancel();
    },
    drop: function drop(_ref3) {
      var activeSortable = _ref3.activeSortable,
          putSortable = _ref3.putSortable,
          dragEl = _ref3.dragEl;
      var toSortable = putSortable || this.sortable;
      var options = this.options;
      lastSwapEl && toggleClass(lastSwapEl, options.swapClass, false);

      if (lastSwapEl && (options.swap || putSortable && putSortable.options.swap)) {
        if (dragEl !== lastSwapEl) {
          toSortable.captureAnimationState();
          if (toSortable !== activeSortable) activeSortable.captureAnimationState();
          swapNodes(dragEl, lastSwapEl);
          toSortable.animateAll();
          if (toSortable !== activeSortable) activeSortable.animateAll();
        }
      }
    },
    nulling: function nulling() {
      lastSwapEl = null;
    }
  };
  return _extends(Swap, {
    pluginName: 'swap',
    eventProperties: function eventProperties() {
      return {
        swapItem: lastSwapEl
      };
    }
  });
}

function swapNodes(n1, n2) {
  var p1 = n1.parentNode,
      p2 = n2.parentNode,
      i1,
      i2;
  if (!p1 || !p2 || p1.isEqualNode(n2) || p2.isEqualNode(n1)) return;
  i1 = index(n1);
  i2 = index(n2);

  if (p1.isEqualNode(p2) && i1 < i2) {
    i2++;
  }

  p1.insertBefore(n2, p1.children[i1]);
  p2.insertBefore(n1, p2.children[i2]);
}

var multiDragElements = [],
    multiDragClones = [],
    lastMultiDragSelect,
    // for selection with modifier key down (SHIFT)
multiDragSortable,
    initialFolding = false,
    // Initial multi-drag fold when drag started
folding = false,
    // Folding any other time
dragStarted = false,
    dragEl$1,
    clonesFromRect,
    clonesHidden;

function MultiDragPlugin() {
  function MultiDrag(sortable) {
    // Bind all private methods
    for (var fn in this) {
      if (fn.charAt(0) === '_' && typeof this[fn] === 'function') {
        this[fn] = this[fn].bind(this);
      }
    }

    if (sortable.options.supportPointer) {
      on(document, 'pointerup', this._deselectMultiDrag);
    } else {
      on(document, 'mouseup', this._deselectMultiDrag);
      on(document, 'touchend', this._deselectMultiDrag);
    }

    on(document, 'keydown', this._checkKeyDown);
    on(document, 'keyup', this._checkKeyUp);
    this.defaults = {
      selectedClass: 'sortable-selected',
      multiDragKey: null,
      setData: function setData(dataTransfer, dragEl) {
        var data = '';

        if (multiDragElements.length && multiDragSortable === sortable) {
          multiDragElements.forEach(function (multiDragElement, i) {
            data += (!i ? '' : ', ') + multiDragElement.textContent;
          });
        } else {
          data = dragEl.textContent;
        }

        dataTransfer.setData('Text', data);
      }
    };
  }

  MultiDrag.prototype = {
    multiDragKeyDown: false,
    isMultiDrag: false,
    delayStartGlobal: function delayStartGlobal(_ref) {
      var dragged = _ref.dragEl;
      dragEl$1 = dragged;
    },
    delayEnded: function delayEnded() {
      this.isMultiDrag = ~multiDragElements.indexOf(dragEl$1);
    },
    setupClone: function setupClone(_ref2) {
      var sortable = _ref2.sortable,
          cancel = _ref2.cancel;
      if (!this.isMultiDrag) return;

      for (var i = 0; i < multiDragElements.length; i++) {
        multiDragClones.push(clone(multiDragElements[i]));
        multiDragClones[i].sortableIndex = multiDragElements[i].sortableIndex;
        multiDragClones[i].draggable = false;
        multiDragClones[i].style['will-change'] = '';
        toggleClass(multiDragClones[i], this.options.selectedClass, false);
        multiDragElements[i] === dragEl$1 && toggleClass(multiDragClones[i], this.options.chosenClass, false);
      }

      sortable._hideClone();

      cancel();
    },
    clone: function clone(_ref3) {
      var sortable = _ref3.sortable,
          rootEl = _ref3.rootEl,
          dispatchSortableEvent = _ref3.dispatchSortableEvent,
          cancel = _ref3.cancel;
      if (!this.isMultiDrag) return;

      if (!this.options.removeCloneOnHide) {
        if (multiDragElements.length && multiDragSortable === sortable) {
          insertMultiDragClones(true, rootEl);
          dispatchSortableEvent('clone');
          cancel();
        }
      }
    },
    showClone: function showClone(_ref4) {
      var cloneNowShown = _ref4.cloneNowShown,
          rootEl = _ref4.rootEl,
          cancel = _ref4.cancel;
      if (!this.isMultiDrag) return;
      insertMultiDragClones(false, rootEl);
      multiDragClones.forEach(function (clone) {
        css(clone, 'display', '');
      });
      cloneNowShown();
      clonesHidden = false;
      cancel();
    },
    hideClone: function hideClone(_ref5) {
      var _this = this;

      var sortable = _ref5.sortable,
          cloneNowHidden = _ref5.cloneNowHidden,
          cancel = _ref5.cancel;
      if (!this.isMultiDrag) return;
      multiDragClones.forEach(function (clone) {
        css(clone, 'display', 'none');

        if (_this.options.removeCloneOnHide && clone.parentNode) {
          clone.parentNode.removeChild(clone);
        }
      });
      cloneNowHidden();
      clonesHidden = true;
      cancel();
    },
    dragStartGlobal: function dragStartGlobal(_ref6) {
      var sortable = _ref6.sortable;

      if (!this.isMultiDrag && multiDragSortable) {
        multiDragSortable.multiDrag._deselectMultiDrag();
      }

      multiDragElements.forEach(function (multiDragElement) {
        multiDragElement.sortableIndex = index(multiDragElement);
      }); // Sort multi-drag elements

      multiDragElements = multiDragElements.sort(function (a, b) {
        return a.sortableIndex - b.sortableIndex;
      });
      dragStarted = true;
    },
    dragStarted: function dragStarted(_ref7) {
      var _this2 = this;

      var sortable = _ref7.sortable;
      if (!this.isMultiDrag) return;

      if (this.options.sort) {
        // Capture rects,
        // hide multi drag elements (by positioning them absolute),
        // set multi drag elements rects to dragRect,
        // show multi drag elements,
        // animate to rects,
        // unset rects & remove from DOM
        sortable.captureAnimationState();

        if (this.options.animation) {
          multiDragElements.forEach(function (multiDragElement) {
            if (multiDragElement === dragEl$1) return;
            css(multiDragElement, 'position', 'absolute');
          });
          var dragRect = getRect(dragEl$1, false, true, true);
          multiDragElements.forEach(function (multiDragElement) {
            if (multiDragElement === dragEl$1) return;
            setRect(multiDragElement, dragRect);
          });
          folding = true;
          initialFolding = true;
        }
      }

      sortable.animateAll(function () {
        folding = false;
        initialFolding = false;

        if (_this2.options.animation) {
          multiDragElements.forEach(function (multiDragElement) {
            unsetRect(multiDragElement);
          });
        } // Remove all auxiliary multidrag items from el, if sorting enabled


        if (_this2.options.sort) {
          removeMultiDragElements();
        }
      });
    },
    dragOver: function dragOver(_ref8) {
      var target = _ref8.target,
          completed = _ref8.completed,
          cancel = _ref8.cancel;

      if (folding && ~multiDragElements.indexOf(target)) {
        completed(false);
        cancel();
      }
    },
    revert: function revert(_ref9) {
      var fromSortable = _ref9.fromSortable,
          rootEl = _ref9.rootEl,
          sortable = _ref9.sortable,
          dragRect = _ref9.dragRect;

      if (multiDragElements.length > 1) {
        // Setup unfold animation
        multiDragElements.forEach(function (multiDragElement) {
          sortable.addAnimationState({
            target: multiDragElement,
            rect: folding ? getRect(multiDragElement) : dragRect
          });
          unsetRect(multiDragElement);
          multiDragElement.fromRect = dragRect;
          fromSortable.removeAnimationState(multiDragElement);
        });
        folding = false;
        insertMultiDragElements(!this.options.removeCloneOnHide, rootEl);
      }
    },
    dragOverCompleted: function dragOverCompleted(_ref10) {
      var sortable = _ref10.sortable,
          isOwner = _ref10.isOwner,
          insertion = _ref10.insertion,
          activeSortable = _ref10.activeSortable,
          parentEl = _ref10.parentEl,
          putSortable = _ref10.putSortable;
      var options = this.options;

      if (insertion) {
        // Clones must be hidden before folding animation to capture dragRectAbsolute properly
        if (isOwner) {
          activeSortable._hideClone();
        }

        initialFolding = false; // If leaving sort:false root, or already folding - Fold to new location

        if (options.animation && multiDragElements.length > 1 && (folding || !isOwner && !activeSortable.options.sort && !putSortable)) {
          // Fold: Set all multi drag elements's rects to dragEl's rect when multi-drag elements are invisible
          var dragRectAbsolute = getRect(dragEl$1, false, true, true);
          multiDragElements.forEach(function (multiDragElement) {
            if (multiDragElement === dragEl$1) return;
            setRect(multiDragElement, dragRectAbsolute); // Move element(s) to end of parentEl so that it does not interfere with multi-drag clones insertion if they are inserted
            // while folding, and so that we can capture them again because old sortable will no longer be fromSortable

            parentEl.appendChild(multiDragElement);
          });
          folding = true;
        } // Clones must be shown (and check to remove multi drags) after folding when interfering multiDragElements are moved out


        if (!isOwner) {
          // Only remove if not folding (folding will remove them anyways)
          if (!folding) {
            removeMultiDragElements();
          }

          if (multiDragElements.length > 1) {
            var clonesHiddenBefore = clonesHidden;

            activeSortable._showClone(sortable); // Unfold animation for clones if showing from hidden


            if (activeSortable.options.animation && !clonesHidden && clonesHiddenBefore) {
              multiDragClones.forEach(function (clone) {
                activeSortable.addAnimationState({
                  target: clone,
                  rect: clonesFromRect
                });
                clone.fromRect = clonesFromRect;
                clone.thisAnimationDuration = null;
              });
            }
          } else {
            activeSortable._showClone(sortable);
          }
        }
      }
    },
    dragOverAnimationCapture: function dragOverAnimationCapture(_ref11) {
      var dragRect = _ref11.dragRect,
          isOwner = _ref11.isOwner,
          activeSortable = _ref11.activeSortable;
      multiDragElements.forEach(function (multiDragElement) {
        multiDragElement.thisAnimationDuration = null;
      });

      if (activeSortable.options.animation && !isOwner && activeSortable.multiDrag.isMultiDrag) {
        clonesFromRect = _extends({}, dragRect);
        var dragMatrix = matrix(dragEl$1, true);
        clonesFromRect.top -= dragMatrix.f;
        clonesFromRect.left -= dragMatrix.e;
      }
    },
    dragOverAnimationComplete: function dragOverAnimationComplete() {
      if (folding) {
        folding = false;
        removeMultiDragElements();
      }
    },
    drop: function drop(_ref12) {
      var evt = _ref12.originalEvent,
          rootEl = _ref12.rootEl,
          parentEl = _ref12.parentEl,
          sortable = _ref12.sortable,
          dispatchSortableEvent = _ref12.dispatchSortableEvent,
          oldIndex = _ref12.oldIndex,
          putSortable = _ref12.putSortable;
      var toSortable = putSortable || this.sortable;
      if (!evt) return;
      var options = this.options,
          children = parentEl.children; // Multi-drag selection

      if (!dragStarted) {
        if (options.multiDragKey && !this.multiDragKeyDown) {
          this._deselectMultiDrag();
        }

        toggleClass(dragEl$1, options.selectedClass, !~multiDragElements.indexOf(dragEl$1));

        if (!~multiDragElements.indexOf(dragEl$1)) {
          multiDragElements.push(dragEl$1);
          dispatchEvent({
            sortable: sortable,
            rootEl: rootEl,
            name: 'select',
            targetEl: dragEl$1,
            originalEvt: evt
          }); // Modifier activated, select from last to dragEl

          if (evt.shiftKey && lastMultiDragSelect && sortable.el.contains(lastMultiDragSelect)) {
            var lastIndex = index(lastMultiDragSelect),
                currentIndex = index(dragEl$1);

            if (~lastIndex && ~currentIndex && lastIndex !== currentIndex) {
              // Must include lastMultiDragSelect (select it), in case modified selection from no selection
              // (but previous selection existed)
              var n, i;

              if (currentIndex > lastIndex) {
                i = lastIndex;
                n = currentIndex;
              } else {
                i = currentIndex;
                n = lastIndex + 1;
              }

              for (; i < n; i++) {
                if (~multiDragElements.indexOf(children[i])) continue;
                toggleClass(children[i], options.selectedClass, true);
                multiDragElements.push(children[i]);
                dispatchEvent({
                  sortable: sortable,
                  rootEl: rootEl,
                  name: 'select',
                  targetEl: children[i],
                  originalEvt: evt
                });
              }
            }
          } else {
            lastMultiDragSelect = dragEl$1;
          }

          multiDragSortable = toSortable;
        } else {
          multiDragElements.splice(multiDragElements.indexOf(dragEl$1), 1);
          lastMultiDragSelect = null;
          dispatchEvent({
            sortable: sortable,
            rootEl: rootEl,
            name: 'deselect',
            targetEl: dragEl$1,
            originalEvt: evt
          });
        }
      } // Multi-drag drop


      if (dragStarted && this.isMultiDrag) {
        // Do not "unfold" after around dragEl if reverted
        if ((parentEl[expando].options.sort || parentEl !== rootEl) && multiDragElements.length > 1) {
          var dragRect = getRect(dragEl$1),
              multiDragIndex = index(dragEl$1, ':not(.' + this.options.selectedClass + ')');
          if (!initialFolding && options.animation) dragEl$1.thisAnimationDuration = null;
          toSortable.captureAnimationState();

          if (!initialFolding) {
            if (options.animation) {
              dragEl$1.fromRect = dragRect;
              multiDragElements.forEach(function (multiDragElement) {
                multiDragElement.thisAnimationDuration = null;

                if (multiDragElement !== dragEl$1) {
                  var rect = folding ? getRect(multiDragElement) : dragRect;
                  multiDragElement.fromRect = rect; // Prepare unfold animation

                  toSortable.addAnimationState({
                    target: multiDragElement,
                    rect: rect
                  });
                }
              });
            } // Multi drag elements are not necessarily removed from the DOM on drop, so to reinsert
            // properly they must all be removed


            removeMultiDragElements();
            multiDragElements.forEach(function (multiDragElement) {
              if (children[multiDragIndex]) {
                parentEl.insertBefore(multiDragElement, children[multiDragIndex]);
              } else {
                parentEl.appendChild(multiDragElement);
              }

              multiDragIndex++;
            }); // If initial folding is done, the elements may have changed position because they are now
            // unfolding around dragEl, even though dragEl may not have his index changed, so update event
            // must be fired here as Sortable will not.

            if (oldIndex === index(dragEl$1)) {
              var update = false;
              multiDragElements.forEach(function (multiDragElement) {
                if (multiDragElement.sortableIndex !== index(multiDragElement)) {
                  update = true;
                  return;
                }
              });

              if (update) {
                dispatchSortableEvent('update');
              }
            }
          } // Must be done after capturing individual rects (scroll bar)


          multiDragElements.forEach(function (multiDragElement) {
            unsetRect(multiDragElement);
          });
          toSortable.animateAll();
        }

        multiDragSortable = toSortable;
      } // Remove clones if necessary


      if (rootEl === parentEl || putSortable && putSortable.lastPutMode !== 'clone') {
        multiDragClones.forEach(function (clone) {
          clone.parentNode && clone.parentNode.removeChild(clone);
        });
      }
    },
    nullingGlobal: function nullingGlobal() {
      this.isMultiDrag = dragStarted = false;
      multiDragClones.length = 0;
    },
    destroyGlobal: function destroyGlobal() {
      this._deselectMultiDrag();

      off(document, 'pointerup', this._deselectMultiDrag);
      off(document, 'mouseup', this._deselectMultiDrag);
      off(document, 'touchend', this._deselectMultiDrag);
      off(document, 'keydown', this._checkKeyDown);
      off(document, 'keyup', this._checkKeyUp);
    },
    _deselectMultiDrag: function _deselectMultiDrag(evt) {
      if (typeof dragStarted !== "undefined" && dragStarted) return; // Only deselect if selection is in this sortable

      if (multiDragSortable !== this.sortable) return; // Only deselect if target is not item in this sortable

      if (evt && closest(evt.target, this.options.draggable, this.sortable.el, false)) return; // Only deselect if left click

      if (evt && evt.button !== 0) return;

      while (multiDragElements.length) {
        var el = multiDragElements[0];
        toggleClass(el, this.options.selectedClass, false);
        multiDragElements.shift();
        dispatchEvent({
          sortable: this.sortable,
          rootEl: this.sortable.el,
          name: 'deselect',
          targetEl: el,
          originalEvt: evt
        });
      }
    },
    _checkKeyDown: function _checkKeyDown(evt) {
      if (evt.key === this.options.multiDragKey) {
        this.multiDragKeyDown = true;
      }
    },
    _checkKeyUp: function _checkKeyUp(evt) {
      if (evt.key === this.options.multiDragKey) {
        this.multiDragKeyDown = false;
      }
    }
  };
  return _extends(MultiDrag, {
    // Static methods & properties
    pluginName: 'multiDrag',
    utils: {
      /**
       * Selects the provided multi-drag item
       * @param  {HTMLElement} el    The element to be selected
       */
      select: function select(el) {
        var sortable = el.parentNode[expando];
        if (!sortable || !sortable.options.multiDrag || ~multiDragElements.indexOf(el)) return;

        if (multiDragSortable && multiDragSortable !== sortable) {
          multiDragSortable.multiDrag._deselectMultiDrag();

          multiDragSortable = sortable;
        }

        toggleClass(el, sortable.options.selectedClass, true);
        multiDragElements.push(el);
      },

      /**
       * Deselects the provided multi-drag item
       * @param  {HTMLElement} el    The element to be deselected
       */
      deselect: function deselect(el) {
        var sortable = el.parentNode[expando],
            index = multiDragElements.indexOf(el);
        if (!sortable || !sortable.options.multiDrag || !~index) return;
        toggleClass(el, sortable.options.selectedClass, false);
        multiDragElements.splice(index, 1);
      }
    },
    eventProperties: function eventProperties() {
      var _this3 = this;

      var oldIndicies = [],
          newIndicies = [];
      multiDragElements.forEach(function (multiDragElement) {
        oldIndicies.push({
          multiDragElement: multiDragElement,
          index: multiDragElement.sortableIndex
        }); // multiDragElements will already be sorted if folding

        var newIndex;

        if (folding && multiDragElement !== dragEl$1) {
          newIndex = -1;
        } else if (folding) {
          newIndex = index(multiDragElement, ':not(.' + _this3.options.selectedClass + ')');
        } else {
          newIndex = index(multiDragElement);
        }

        newIndicies.push({
          multiDragElement: multiDragElement,
          index: newIndex
        });
      });
      return {
        items: _toConsumableArray(multiDragElements),
        clones: [].concat(multiDragClones),
        oldIndicies: oldIndicies,
        newIndicies: newIndicies
      };
    },
    optionListeners: {
      multiDragKey: function multiDragKey(key) {
        key = key.toLowerCase();

        if (key === 'ctrl') {
          key = 'Control';
        } else if (key.length > 1) {
          key = key.charAt(0).toUpperCase() + key.substr(1);
        }

        return key;
      }
    }
  });
}

function insertMultiDragElements(clonesInserted, rootEl) {
  multiDragElements.forEach(function (multiDragElement, i) {
    var target = rootEl.children[multiDragElement.sortableIndex + (clonesInserted ? Number(i) : 0)];

    if (target) {
      rootEl.insertBefore(multiDragElement, target);
    } else {
      rootEl.appendChild(multiDragElement);
    }
  });
}
/**
 * Insert multi-drag clones
 * @param  {[Boolean]} elementsInserted  Whether the multi-drag elements are inserted
 * @param  {HTMLElement} rootEl
 */


function insertMultiDragClones(elementsInserted, rootEl) {
  multiDragClones.forEach(function (clone, i) {
    var target = rootEl.children[clone.sortableIndex + (elementsInserted ? Number(i) : 0)];

    if (target) {
      rootEl.insertBefore(clone, target);
    } else {
      rootEl.appendChild(clone);
    }
  });
}

function removeMultiDragElements() {
  multiDragElements.forEach(function (multiDragElement) {
    if (multiDragElement === dragEl$1) return;
    multiDragElement.parentNode && multiDragElement.parentNode.removeChild(multiDragElement);
  });
}

Sortable.mount(new AutoScrollPlugin());
Sortable.mount(Remove, Revert);

/* harmony default export */ __webpack_exports__["default"] = (Sortable);



/***/ }),

/***/ "./node_modules/webpack/buildin/global.js":
/*!***********************************!*\
  !*** (webpack)/buildin/global.js ***!
  \***********************************/
/*! no static exports found */
/***/ (function(module, exports) {

var g;

// This works in non-strict mode
g = (function() {
	return this;
})();

try {
	// This works if eval is allowed (see CSP)
	g = g || new Function("return this")();
} catch (e) {
	// This works if the window reference is available
	if (typeof window === "object") g = window;
}

// g can still be undefined, but nothing to do about it...
// We return undefined, instead of nothing here, so it's
// easier to handle this case. if(!global) { ...}

module.exports = g;


/***/ }),

/***/ "./src/actions/action.ts":
/*!*******************************!*\
  !*** ./src/actions/action.ts ***!
  \*******************************/
/*! exports provided: Action */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "Action", function() { return Action; });
/* harmony import */ var _base__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ../base */ "./src/base.ts");
/* harmony import */ var _jsonobject__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ../jsonobject */ "./src/jsonobject.ts");
/* harmony import */ var _utils_cssClassBuilder__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ../utils/cssClassBuilder */ "./src/utils/cssClassBuilder.ts");
var __extends = (undefined && undefined.__extends) || (function () {
    var extendStatics = function (d, b) {
        extendStatics = Object.setPrototypeOf ||
            ({ __proto__: [] } instanceof Array && function (d, b) { d.__proto__ = b; }) ||
            function (d, b) { for (var p in b) if (Object.prototype.hasOwnProperty.call(b, p)) d[p] = b[p]; };
        return extendStatics(d, b);
    };
    return function (d, b) {
        if (typeof b !== "function" && b !== null)
            throw new TypeError("Class extends value " + String(b) + " is not a constructor or null");
        extendStatics(d, b);
        function __() { this.constructor = d; }
        d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
    };
})();
var __decorate = (undefined && undefined.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};



var Action = /** @class */ (function (_super) {
    __extends(Action, _super);
    function Action(innerItem) {
        var _this = _super.call(this) || this;
        _this.innerItem = innerItem;
        _this.iconSize = 24;
        //Object.assign(this, item) to support IE11
        if (!!innerItem) {
            for (var key in innerItem) {
                _this[key] = innerItem[key];
            }
        }
        return _this;
    }
    Action.prototype.raiseUpdate = function () {
        this.updateCallback && this.updateCallback();
    };
    Object.defineProperty(Action.prototype, "disabled", {
        get: function () {
            return this.enabled !== undefined && !this.enabled;
        },
        enumerable: false,
        configurable: true
    });
    Object.defineProperty(Action.prototype, "hasTitle", {
        get: function () {
            return (((this.mode != "small" &&
                (this.showTitle || this.showTitle === undefined)) ||
                !this.iconName) &&
                !!this.title);
        },
        enumerable: false,
        configurable: true
    });
    Object.defineProperty(Action.prototype, "isVisible", {
        get: function () {
            return this.visible && this.mode !== "popup";
        },
        enumerable: false,
        configurable: true
    });
    Object.defineProperty(Action.prototype, "canShrink", {
        get: function () {
            return !!this.iconName;
        },
        enumerable: false,
        configurable: true
    });
    Action.prototype.getActionRootCss = function () {
        return new _utils_cssClassBuilder__WEBPACK_IMPORTED_MODULE_2__["CssClassBuilder"]()
            .append("sv-action")
            .append(this.css)
            .append("sv-action--hidden", !this.isVisible)
            .toString();
    };
    Action.prototype.getActionBarItemCss = function () {
        return new _utils_cssClassBuilder__WEBPACK_IMPORTED_MODULE_2__["CssClassBuilder"]()
            .append("sv-action-bar-item__title")
            .append("sv-action-bar-item__title--with-icon", !!this.iconName)
            .toString();
    };
    Action.prototype.getActionBarItemActiveCss = function () {
        return new _utils_cssClassBuilder__WEBPACK_IMPORTED_MODULE_2__["CssClassBuilder"]()
            .append("sv-action-bar-item")
            .append("sv-action-bar-item--active", !!this.active)
            .append("sv-action-bar-item--pressed", !!this.pressed)
            .append(this.innerCss)
            .toString();
    };
    __decorate([
        Object(_jsonobject__WEBPACK_IMPORTED_MODULE_1__["property"])()
    ], Action.prototype, "id", void 0);
    __decorate([
        Object(_jsonobject__WEBPACK_IMPORTED_MODULE_1__["property"])()
    ], Action.prototype, "iconName", void 0);
    __decorate([
        Object(_jsonobject__WEBPACK_IMPORTED_MODULE_1__["property"])()
    ], Action.prototype, "iconSize", void 0);
    __decorate([
        Object(_jsonobject__WEBPACK_IMPORTED_MODULE_1__["property"])({
            defaultValue: true, onSet: function (_, target) {
                target.raiseUpdate();
            }
        })
    ], Action.prototype, "visible", void 0);
    __decorate([
        Object(_jsonobject__WEBPACK_IMPORTED_MODULE_1__["property"])()
    ], Action.prototype, "title", void 0);
    __decorate([
        Object(_jsonobject__WEBPACK_IMPORTED_MODULE_1__["property"])()
    ], Action.prototype, "tooltip", void 0);
    __decorate([
        Object(_jsonobject__WEBPACK_IMPORTED_MODULE_1__["property"])()
    ], Action.prototype, "enabled", void 0);
    __decorate([
        Object(_jsonobject__WEBPACK_IMPORTED_MODULE_1__["property"])()
    ], Action.prototype, "showTitle", void 0);
    __decorate([
        Object(_jsonobject__WEBPACK_IMPORTED_MODULE_1__["property"])()
    ], Action.prototype, "action", void 0);
    __decorate([
        Object(_jsonobject__WEBPACK_IMPORTED_MODULE_1__["property"])()
    ], Action.prototype, "css", void 0);
    __decorate([
        Object(_jsonobject__WEBPACK_IMPORTED_MODULE_1__["property"])()
    ], Action.prototype, "innerCss", void 0);
    __decorate([
        Object(_jsonobject__WEBPACK_IMPORTED_MODULE_1__["property"])()
    ], Action.prototype, "data", void 0);
    __decorate([
        Object(_jsonobject__WEBPACK_IMPORTED_MODULE_1__["property"])()
    ], Action.prototype, "popupModel", void 0);
    __decorate([
        Object(_jsonobject__WEBPACK_IMPORTED_MODULE_1__["property"])()
    ], Action.prototype, "needSeparator", void 0);
    __decorate([
        Object(_jsonobject__WEBPACK_IMPORTED_MODULE_1__["property"])()
    ], Action.prototype, "active", void 0);
    __decorate([
        Object(_jsonobject__WEBPACK_IMPORTED_MODULE_1__["property"])()
    ], Action.prototype, "pressed", void 0);
    __decorate([
        Object(_jsonobject__WEBPACK_IMPORTED_MODULE_1__["property"])()
    ], Action.prototype, "template", void 0);
    __decorate([
        Object(_jsonobject__WEBPACK_IMPORTED_MODULE_1__["property"])()
    ], Action.prototype, "component", void 0);
    __decorate([
        Object(_jsonobject__WEBPACK_IMPORTED_MODULE_1__["property"])()
    ], Action.prototype, "items", void 0);
    __decorate([
        Object(_jsonobject__WEBPACK_IMPORTED_MODULE_1__["property"])()
    ], Action.prototype, "visibleIndex", void 0);
    __decorate([
        Object(_jsonobject__WEBPACK_IMPORTED_MODULE_1__["property"])({ defaultValue: "large" })
    ], Action.prototype, "mode", void 0);
    __decorate([
        Object(_jsonobject__WEBPACK_IMPORTED_MODULE_1__["property"])()
    ], Action.prototype, "disableTabStop", void 0);
    __decorate([
        Object(_jsonobject__WEBPACK_IMPORTED_MODULE_1__["property"])()
    ], Action.prototype, "disableShrink", void 0);
    return Action;
}(_base__WEBPACK_IMPORTED_MODULE_0__["Base"]));



/***/ }),

/***/ "./src/actions/adaptive-container.ts":
/*!*******************************************!*\
  !*** ./src/actions/adaptive-container.ts ***!
  \*******************************************/
/*! exports provided: AdaptiveActionContainer */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "AdaptiveActionContainer", function() { return AdaptiveActionContainer; });
/* harmony import */ var _utils_responsivity_manager__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ../utils/responsivity-manager */ "./src/utils/responsivity-manager.ts");
/* harmony import */ var _list__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ../list */ "./src/list.ts");
/* harmony import */ var _popup__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ../popup */ "./src/popup.ts");
/* harmony import */ var _action__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ./action */ "./src/actions/action.ts");
/* harmony import */ var _container__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! ./container */ "./src/actions/container.ts");
var __extends = (undefined && undefined.__extends) || (function () {
    var extendStatics = function (d, b) {
        extendStatics = Object.setPrototypeOf ||
            ({ __proto__: [] } instanceof Array && function (d, b) { d.__proto__ = b; }) ||
            function (d, b) { for (var p in b) if (Object.prototype.hasOwnProperty.call(b, p)) d[p] = b[p]; };
        return extendStatics(d, b);
    };
    return function (d, b) {
        if (typeof b !== "function" && b !== null)
            throw new TypeError("Class extends value " + String(b) + " is not a constructor or null");
        extendStatics(d, b);
        function __() { this.constructor = d; }
        d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
    };
})();





var AdaptiveActionContainer = /** @class */ (function (_super) {
    __extends(AdaptiveActionContainer, _super);
    function AdaptiveActionContainer() {
        var _this = _super.call(this) || this;
        _this.minVisibleItemsCount = 0;
        _this.invisibleItemsListModel = new _list__WEBPACK_IMPORTED_MODULE_1__["ListModel"]([], function (item) {
            _this.invisibleItemSelected(item);
            _this.dotsItemPopupModel.toggleVisibility();
        }, false);
        _this.dotsItemPopupModel = new _popup__WEBPACK_IMPORTED_MODULE_2__["PopupModel"]("sv-list", {
            model: _this.invisibleItemsListModel
        });
        _this.dotsItem = new _action__WEBPACK_IMPORTED_MODULE_3__["Action"]({
            id: "dotsItem-id",
            component: "sv-action-bar-item-dropdown",
            css: "sv-dots",
            innerCss: "sv-dots__item",
            iconName: "icon-more",
            visible: false,
            action: function (item) {
                _this.dotsItemPopupModel.toggleVisibility();
            },
            popupModel: _this.dotsItemPopupModel
        });
        _this.dotsItemPopupModel.onHide = function () {
            _this.dotsItem.pressed = false;
        };
        _this.dotsItemPopupModel.onShow = function () {
            _this.dotsItem.pressed = true;
        };
        return _this;
    }
    AdaptiveActionContainer.prototype.invisibleItemSelected = function (item) {
        if (!!item && typeof item.action === "function") {
            item.action();
        }
    };
    AdaptiveActionContainer.prototype.hideItemsGreaterN = function (visibleItemsCount) {
        visibleItemsCount = Math.max(visibleItemsCount, this.minVisibleItemsCount);
        var invisibleItems = [];
        this.visibleActions.forEach(function (item) {
            if (visibleItemsCount <= 0) {
                item.mode = "popup";
                invisibleItems.push(item.innerItem);
            }
            visibleItemsCount--;
        });
        this.invisibleItemsListModel.setItems(invisibleItems);
    };
    AdaptiveActionContainer.prototype.getVisibleItemsCount = function (availableSize) {
        var itemsSizes = this.visibleActions.map(function (item) { return item.minDimension; });
        var currSize = 0;
        for (var i = 0; i < itemsSizes.length; i++) {
            currSize += itemsSizes[i];
            if (currSize > availableSize)
                return i;
        }
        return i;
    };
    AdaptiveActionContainer.prototype.updateItemMode = function (availableSize, itemsSize) {
        var items = this.visibleActions;
        for (var index = items.length - 1; index >= 0; index--) {
            if (itemsSize > availableSize && !items[index].disableShrink) {
                itemsSize -= items[index].maxDimension - items[index].minDimension;
                items[index].mode = "small";
            }
            else {
                items[index].mode = "large";
            }
        }
    };
    AdaptiveActionContainer.prototype.onSet = function () {
        var _this = this;
        this.actions.forEach(function (action) { return action.updateCallback = function () { return _this.raiseUpdate(false); }; });
        _super.prototype.onSet.call(this);
    };
    AdaptiveActionContainer.prototype.onPush = function (item) {
        var _this = this;
        item.updateCallback = function () { return _this.raiseUpdate(false); };
        _super.prototype.onPush.call(this, item);
    };
    AdaptiveActionContainer.prototype.getRenderedActions = function () {
        return this.actions.concat([this.dotsItem]);
    };
    AdaptiveActionContainer.prototype.fit = function (dimension, dotsItemSize) {
        if (dimension <= 0)
            return;
        this.dotsItem.visible = false;
        var minSize = 0;
        var maxSize = 0;
        var items = this.visibleActions;
        items.forEach(function (item) {
            minSize += item.minDimension;
            maxSize += item.maxDimension;
        });
        if (dimension >= maxSize) {
            items.forEach(function (item) { return (item.mode = "large"); });
        }
        else if (dimension < minSize) {
            items.forEach(function (item) { return (item.mode = "small"); });
            this.hideItemsGreaterN(this.getVisibleItemsCount(dimension - dotsItemSize));
            this.dotsItem.visible = true;
        }
        else {
            this.updateItemMode(dimension, maxSize);
        }
    };
    AdaptiveActionContainer.prototype.initResponsivityManager = function (container) {
        this.responsivityManager = new _utils_responsivity_manager__WEBPACK_IMPORTED_MODULE_0__["ResponsivityManager"](container, this, ".sv-action:not(.sv-dots)>.sv-action__content");
    };
    AdaptiveActionContainer.prototype.resetResponsivityManager = function () {
        if (!!this.responsivityManager) {
            this.responsivityManager.dispose();
            this.responsivityManager = undefined;
        }
    };
    AdaptiveActionContainer.prototype.dispose = function () {
        _super.prototype.dispose.call(this);
        this.resetResponsivityManager();
    };
    return AdaptiveActionContainer;
}(_container__WEBPACK_IMPORTED_MODULE_4__["ActionContainer"]));



/***/ }),

/***/ "./src/actions/container.ts":
/*!**********************************!*\
  !*** ./src/actions/container.ts ***!
  \**********************************/
/*! exports provided: ActionContainer */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "ActionContainer", function() { return ActionContainer; });
/* harmony import */ var _jsonobject__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ../jsonobject */ "./src/jsonobject.ts");
/* harmony import */ var _base__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ../base */ "./src/base.ts");
/* harmony import */ var _action__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ./action */ "./src/actions/action.ts");
var __extends = (undefined && undefined.__extends) || (function () {
    var extendStatics = function (d, b) {
        extendStatics = Object.setPrototypeOf ||
            ({ __proto__: [] } instanceof Array && function (d, b) { d.__proto__ = b; }) ||
            function (d, b) { for (var p in b) if (Object.prototype.hasOwnProperty.call(b, p)) d[p] = b[p]; };
        return extendStatics(d, b);
    };
    return function (d, b) {
        if (typeof b !== "function" && b !== null)
            throw new TypeError("Class extends value " + String(b) + " is not a constructor or null");
        extendStatics(d, b);
        function __() { this.constructor = d; }
        d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
    };
})();
var __decorate = (undefined && undefined.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};



var ActionContainer = /** @class */ (function (_super) {
    __extends(ActionContainer, _super);
    function ActionContainer() {
        return _super !== null && _super.apply(this, arguments) || this;
    }
    ActionContainer.prototype.getRenderedActions = function () {
        return this.actions;
    };
    ActionContainer.prototype.raiseUpdate = function (isResetInitialized) {
        this.updateCallback && this.updateCallback(isResetInitialized);
    };
    ActionContainer.prototype.onSet = function () {
        this.raiseUpdate(true);
    };
    ActionContainer.prototype.onPush = function (item) {
        this.raiseUpdate(true);
    };
    ActionContainer.prototype.onRemove = function (item) {
        this.raiseUpdate(true);
    };
    Object.defineProperty(ActionContainer.prototype, "hasActions", {
        get: function () {
            return (this.actions || []).length > 0;
        },
        enumerable: false,
        configurable: true
    });
    Object.defineProperty(ActionContainer.prototype, "renderedActions", {
        get: function () {
            return this.getRenderedActions();
        },
        enumerable: false,
        configurable: true
    });
    Object.defineProperty(ActionContainer.prototype, "visibleActions", {
        get: function () {
            return this.actions.filter(function (action) { return action.visible !== false; });
        },
        enumerable: false,
        configurable: true
    });
    Object.defineProperty(ActionContainer.prototype, "css", {
        get: function () {
            return "sv-action-bar" + (!!this.containerCss ? " " + this.containerCss : "");
        },
        enumerable: false,
        configurable: true
    });
    ActionContainer.prototype.sortItems = function (items) {
        return []
            .concat(items.filter(function (item) { return item.visibleIndex >= 0 || item.visibleIndex === undefined; }))
            .sort(function (firstItem, secondItem) {
            return firstItem.visibleIndex - secondItem.visibleIndex;
        });
    };
    ActionContainer.prototype.setItems = function (items, sortByVisibleIndex) {
        if (sortByVisibleIndex === void 0) { sortByVisibleIndex = true; }
        var actions = items.map(function (item) { return (item instanceof _action__WEBPACK_IMPORTED_MODULE_2__["Action"] ? item : new _action__WEBPACK_IMPORTED_MODULE_2__["Action"](item)); });
        if (sortByVisibleIndex) {
            this.actions = this.sortItems(actions);
        }
        else {
            this.actions = actions;
        }
    };
    ActionContainer.prototype.initResponsivityManager = function (container) {
        return;
    };
    ActionContainer.prototype.resetResponsivityManager = function () { };
    __decorate([
        Object(_jsonobject__WEBPACK_IMPORTED_MODULE_0__["propertyArray"])({
            onSet: function (_, target) {
                target.onSet();
            },
            onPush: function (item, i, target) {
                target.onPush(item);
            },
            onRemove: function (item, i, target) {
                target.onRemove(item);
            }
        })
    ], ActionContainer.prototype, "actions", void 0);
    return ActionContainer;
}(_base__WEBPACK_IMPORTED_MODULE_1__["Base"]));



/***/ }),

/***/ "./src/base.ts":
/*!*********************!*\
  !*** ./src/base.ts ***!
  \*********************/
/*! exports provided: Bindings, Dependencies, ComputedUpdater, Base, ArrayChanges, Event, EventBase */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "Bindings", function() { return Bindings; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "Dependencies", function() { return Dependencies; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "ComputedUpdater", function() { return ComputedUpdater; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "Base", function() { return Base; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "ArrayChanges", function() { return ArrayChanges; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "Event", function() { return Event; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "EventBase", function() { return EventBase; });
/* harmony import */ var _localizablestring__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./localizablestring */ "./src/localizablestring.ts");
/* harmony import */ var _helpers__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ./helpers */ "./src/helpers.ts");
/* harmony import */ var _jsonobject__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ./jsonobject */ "./src/jsonobject.ts");
/* harmony import */ var _settings__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ./settings */ "./src/settings.ts");
var __extends = (undefined && undefined.__extends) || (function () {
    var extendStatics = function (d, b) {
        extendStatics = Object.setPrototypeOf ||
            ({ __proto__: [] } instanceof Array && function (d, b) { d.__proto__ = b; }) ||
            function (d, b) { for (var p in b) if (Object.prototype.hasOwnProperty.call(b, p)) d[p] = b[p]; };
        return extendStatics(d, b);
    };
    return function (d, b) {
        if (typeof b !== "function" && b !== null)
            throw new TypeError("Class extends value " + String(b) + " is not a constructor or null");
        extendStatics(d, b);
        function __() { this.constructor = d; }
        d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
    };
})();
var __spreadArray = (undefined && undefined.__spreadArray) || function (to, from, pack) {
    if (pack || arguments.length === 2) for (var i = 0, l = from.length, ar; i < l; i++) {
        if (ar || !(i in from)) {
            if (!ar) ar = Array.prototype.slice.call(from, 0, i);
            ar[i] = from[i];
        }
    }
    return to.concat(ar || Array.prototype.slice.call(from));
};




var Bindings = /** @class */ (function () {
    function Bindings(obj) {
        this.obj = obj;
        this.properties = null;
        this.values = null;
    }
    Bindings.prototype.getType = function () {
        return "bindings";
    };
    Bindings.prototype.getNames = function () {
        var res = [];
        this.fillProperties();
        for (var i = 0; i < this.properties.length; i++) {
            if (this.properties[i].isVisible("", this.obj)) {
                res.push(this.properties[i].name);
            }
        }
        return res;
    };
    Bindings.prototype.getProperties = function () {
        var res = [];
        this.fillProperties();
        for (var i = 0; i < this.properties.length; i++) {
            res.push(this.properties[i]);
        }
        return res;
    };
    Bindings.prototype.setBinding = function (propertyName, valueName) {
        if (!this.values)
            this.values = {};
        if (!!valueName) {
            this.values[propertyName] = valueName;
        }
        else {
            delete this.values[propertyName];
            if (Object.keys(this.values).length == 0) {
                this.values = null;
            }
        }
    };
    Bindings.prototype.clearBinding = function (propertyName) {
        this.setBinding(propertyName, "");
    };
    Bindings.prototype.isEmpty = function () {
        return !this.values;
    };
    Bindings.prototype.getValueNameByPropertyName = function (propertyName) {
        if (!this.values)
            return undefined;
        return this.values[propertyName];
    };
    Bindings.prototype.getPropertiesByValueName = function (valueName) {
        if (!this.values)
            return [];
        var res = [];
        for (var key in this.values) {
            if (this.values[key] == valueName) {
                res.push(key);
            }
        }
        return res;
    };
    Bindings.prototype.getJson = function () {
        if (this.isEmpty())
            return null;
        var res = {};
        for (var key in this.values) {
            res[key] = this.values[key];
        }
        return res;
    };
    Bindings.prototype.setJson = function (value) {
        this.values = null;
        if (!value)
            return;
        this.values = {};
        for (var key in value) {
            this.values[key] = value[key];
        }
    };
    Bindings.prototype.fillProperties = function () {
        if (this.properties !== null)
            return;
        this.properties = [];
        var objProperties = _jsonobject__WEBPACK_IMPORTED_MODULE_2__["Serializer"].getPropertiesByObj(this.obj);
        for (var i = 0; i < objProperties.length; i++) {
            if (objProperties[i].isBindable) {
                this.properties.push(objProperties[i]);
            }
        }
    };
    return Bindings;
}());

var Dependencies = /** @class */ (function () {
    function Dependencies(currentDependency, target, property) {
        this.currentDependency = currentDependency;
        this.target = target;
        this.property = property;
        this.dependencies = [];
        this.id = "" + (++Dependencies.DependenciesCount);
    }
    Dependencies.prototype.addDependency = function (target, property) {
        if (this.target === target && this.property === property)
            return;
        if (this.dependencies.some(function (dependency) { return dependency.obj === target && dependency.prop === property; }))
            return;
        this.dependencies.push({
            obj: target,
            prop: property,
            id: this.id
        });
        target.registerFunctionOnPropertiesValueChanged([property], this.currentDependency, this.id);
    };
    Dependencies.prototype.dispose = function () {
        this.dependencies.forEach(function (dependency) {
            dependency.obj.unRegisterFunctionOnPropertiesValueChanged([dependency.prop], dependency.id);
        });
    };
    Dependencies.DependenciesCount = 0;
    return Dependencies;
}());

var ComputedUpdater = /** @class */ (function () {
    function ComputedUpdater(_updater) {
        this._updater = _updater;
        this.dependencies = undefined;
        this.type = ComputedUpdater.ComputedUpdaterType;
    }
    Object.defineProperty(ComputedUpdater.prototype, "updater", {
        get: function () {
            return this._updater;
        },
        enumerable: false,
        configurable: true
    });
    ComputedUpdater.prototype.setDependencies = function (dependencies) {
        this.clearDependencies();
        this.dependencies = dependencies;
    };
    ComputedUpdater.prototype.getDependencies = function () {
        return this.dependencies;
    };
    ComputedUpdater.prototype.clearDependencies = function () {
        if (this.dependencies) {
            this.dependencies.dispose();
            this.dependencies = undefined;
        }
    };
    ComputedUpdater.prototype.dispose = function () {
        this.clearDependencies();
    };
    ComputedUpdater.ComputedUpdaterType = "__dependency_computed";
    return ComputedUpdater;
}());

/**
 * The base class for SurveyJS objects.
 */
var Base = /** @class */ (function () {
    function Base() {
        this.propertyHash = {};
        this.eventList = [];
        this.isLoadingFromJsonValue = false;
        this.loadingOwner = null;
        /**
         * Event that raise on property change of the sender object
         * sender - the object that owns the property
         * options.name - the property name that has been changed
         * options.oldValue - old value. Please note, it equals to options.newValue if property is an array
         * options.newValue - new value.
         */
        this.onPropertyChanged = this.addEvent();
        /**
         * Event that raised on changing property of the ItemValue object.
         * sender - the object that owns the property
         * options.propertyName - the property name to which ItemValue array is belong. It can be "choices" for dropdown question
         * options.obj - the instance of ItemValue object which property has been changed
         * options.name - the property of ItemObject that has been changed
         * options.oldValue - old value
         * options.newValue - new value
         */
        this.onItemValuePropertyChanged = this.addEvent();
        this.isCreating = true;
        this.bindingsValue = new Bindings(this);
        _jsonobject__WEBPACK_IMPORTED_MODULE_2__["CustomPropertiesCollection"].createProperties(this);
        this.onBaseCreating();
        this.isCreating = false;
    }
    Base.finishCollectDependencies = function () {
        var deps = Base.currentDependencis;
        Base.currentDependencis = undefined;
        return deps;
    };
    Base.startCollectDependencies = function (updater, target, property) {
        if (Base.currentDependencis !== undefined) {
            throw new Error("Attempt to collect nested dependencies. Nested dependencies are not supported.");
        }
        Base.currentDependencis = new Dependencies(updater, target, property);
    };
    Base.collectDependency = function (target, property) {
        if (Base.currentDependencis === undefined)
            return;
        Base.currentDependencis.addDependency(target, property);
    };
    Object.defineProperty(Base, "commentPrefix", {
        get: function () {
            return _settings__WEBPACK_IMPORTED_MODULE_3__["settings"].commentPrefix;
        },
        set: function (val) {
            _settings__WEBPACK_IMPORTED_MODULE_3__["settings"].commentPrefix = val;
        },
        enumerable: false,
        configurable: true
    });
    /**
     * Returns true if a value undefined, null, empty string or empty array.
     *
     * @param value
     * @param trimString a boolean parameter, default value true. If true then it trims the string and functions returns true for a string that contains white spaces only.
     */
    Base.prototype.isValueEmpty = function (value, trimString) {
        if (trimString === void 0) { trimString = true; }
        if (trimString) {
            value = this.trimValue(value);
        }
        return _helpers__WEBPACK_IMPORTED_MODULE_1__["Helpers"].isValueEmpty(value);
    };
    Base.prototype.trimValue = function (value) {
        if (!!value && (typeof value === "string" || value instanceof String))
            return value.trim();
        return value;
    };
    Base.prototype.IsPropertyEmpty = function (value) {
        return value !== "" && this.isValueEmpty(value);
    };
    Base.prototype.dispose = function () {
        for (var i = 0; i < this.eventList.length; i++) {
            this.eventList[i].clear();
        }
        this.onPropertyValueChangedCallback = undefined;
        this.isDisposedValue = true;
    };
    Object.defineProperty(Base.prototype, "isDisposed", {
        get: function () {
            return this.isDisposedValue === true;
        },
        enumerable: false,
        configurable: true
    });
    Base.prototype.addEvent = function () {
        var res = new EventBase();
        this.eventList.push(res);
        return res;
    };
    Base.prototype.onBaseCreating = function () { };
    /**
     * Returns the type of the object as a string as it represents in the json. It should be in lowcase.
     */
    Base.prototype.getType = function () {
        return "base";
    };
    Base.prototype.getSurvey = function (isLive) {
        if (isLive === void 0) { isLive = false; }
        return null;
    };
    Object.defineProperty(Base.prototype, "inSurvey", {
        /**
         * Returns true if the object is inluded into survey, otherwise returns false.
         */
        get: function () {
            return !!this.getSurvey(true);
        },
        enumerable: false,
        configurable: true
    });
    Object.defineProperty(Base.prototype, "bindings", {
        get: function () {
            return this.bindingsValue;
        },
        enumerable: false,
        configurable: true
    });
    Base.prototype.checkBindings = function (valueName, value) { };
    Base.prototype.updateBindings = function (propertyName, value) {
        var valueName = this.bindings.getValueNameByPropertyName(propertyName);
        if (!!valueName) {
            this.updateBindingValue(valueName, value);
        }
    };
    Base.prototype.updateBindingValue = function (valueName, value) { };
    /**
     * Returns the element template name without prefix. Typically it equals to getType().
     * @see getType
     */
    Base.prototype.getTemplate = function () {
        return this.getType();
    };
    Object.defineProperty(Base.prototype, "isLoadingFromJson", {
        /**
         * Returns true if the object is loading from Json at the current moment.
         */
        get: function () {
            return this.isLoadingFromJsonValue || this.getIsLoadingFromJson();
        },
        enumerable: false,
        configurable: true
    });
    Base.prototype.getIsLoadingFromJson = function () {
        if (!!this.loadingOwner && this.loadingOwner.isLoadingFromJson)
            return true;
        return this.isLoadingFromJsonValue;
    };
    Base.prototype.startLoadingFromJson = function () {
        this.isLoadingFromJsonValue = true;
    };
    Base.prototype.endLoadingFromJson = function () {
        this.isLoadingFromJsonValue = false;
    };
    /**
     * Deserialized the current object into JSON
     * @see fromJSON
     */
    Base.prototype.toJSON = function () {
        return new _jsonobject__WEBPACK_IMPORTED_MODULE_2__["JsonObject"]().toJsonObject(this);
    };
    /**
     * Load object properties and elements. It doesn't reset properties that was changed before and they are not defined in the json parameter.
     * @param json the object JSON definition
     * @see toJSON
     */
    Base.prototype.fromJSON = function (json) {
        new _jsonobject__WEBPACK_IMPORTED_MODULE_2__["JsonObject"]().toObject(json, this);
        this.onSurveyLoad();
    };
    Base.prototype.onSurveyLoad = function () { };
    /**
     * Make a clone of the existing object. Create a new object of the same type and load all properties into it.
     */
    Base.prototype.clone = function () {
        var clonedObj = _jsonobject__WEBPACK_IMPORTED_MODULE_2__["Serializer"].createClass(this.getType());
        clonedObj.fromJSON(this.toJSON());
        return clonedObj;
    };
    /**
     * Returns the serializable property that belongs to this instance by property name. It returns null if the property is not exists.
     * @param propName property name
     * @returns
     */
    Base.prototype.getPropertyByName = function (propName) {
        return _jsonobject__WEBPACK_IMPORTED_MODULE_2__["Serializer"].findProperty(this.getType(), propName);
    };
    Base.prototype.isPropertyVisible = function (propName) {
        var prop = this.getPropertyByName(propName);
        return !!prop ? prop.isVisible("", this) : false;
    };
    Base.createProgressInfo = function () {
        return {
            questionCount: 0,
            answeredQuestionCount: 0,
            requiredQuestionCount: 0,
            requiredAnsweredQuestionCount: 0,
        };
    };
    Base.prototype.getProgressInfo = function () {
        return Base.createProgressInfo();
    };
    Base.prototype.localeChanged = function () { };
    Base.prototype.locStrsChanged = function () {
        if (!!this.arraysInfo) {
            for (var key in this.arraysInfo) {
                var item = this.arraysInfo[key];
                if (item && item.isItemValues) {
                    var arr = this.getPropertyValue(key);
                    if (arr && !!Base.itemValueLocStrChanged)
                        Base.itemValueLocStrChanged(arr);
                }
            }
        }
        if (!!this.localizableStrings) {
            for (var key in this.localizableStrings) {
                var item = this.getLocalizableString(key);
                if (item)
                    item.strChanged();
            }
        }
    };
    /**
     * Returns the property value by name
     * @param name property name
     */
    Base.prototype.getPropertyValue = function (name, defaultValue) {
        if (defaultValue === void 0) { defaultValue = null; }
        var res = this.getPropertyValueCore(this.propertyHash, name);
        if (this.IsPropertyEmpty(res)) {
            if (defaultValue != null)
                return defaultValue;
            var prop = _jsonobject__WEBPACK_IMPORTED_MODULE_2__["Serializer"].findProperty(this.getType(), name);
            if (!!prop && (!prop.isCustom || !this.isCreating)) {
                if (!this.IsPropertyEmpty(prop.defaultValue) &&
                    !Array.isArray(prop.defaultValue))
                    return prop.defaultValue;
                if (prop.type == "boolean" || prop.type == "switch")
                    return false;
                if (prop.isCustom && !!prop.onGetValue)
                    return prop.onGetValue(this);
            }
        }
        return res;
    };
    Base.prototype.getPropertyValueCore = function (propertiesHash, name) {
        Base.collectDependency(this, name);
        if (this.getPropertyValueCoreHandler)
            return this.getPropertyValueCoreHandler(propertiesHash, name);
        else
            return propertiesHash[name];
    };
    Base.prototype.geValueFromHash = function () {
        return this.propertyHash["value"];
    };
    Base.prototype.setPropertyValueCore = function (propertiesHash, name, val) {
        if (this.setPropertyValueCoreHandler) {
            if (!this.isDisposedValue) {
                this.setPropertyValueCoreHandler(propertiesHash, name, val);
            }
            else {
                // eslint-disable-next-line no-console
                console.warn("Attempt to set property '" + name + "' of a disposed object '" + this.getType() + "'");
            }
        }
        else
            propertiesHash[name] = val;
    };
    Object.defineProperty(Base.prototype, "isEditingSurveyElement", {
        get: function () {
            var survey = this.getSurvey();
            return !!survey && survey.isEditingSurveyElement;
        },
        enumerable: false,
        configurable: true
    });
    Base.prototype.iteratePropertiesHash = function (func) {
        var _this = this;
        var keys = [];
        for (var key in this.propertyHash) {
            if (key === "value" &&
                this.isEditingSurveyElement &&
                Array.isArray(this.value))
                continue;
            keys.push(key);
        }
        keys.forEach(function (key) { return func(_this.propertyHash, key); });
    };
    /**
     * set property value
     * @param name property name
     * @param val new property value
     */
    Base.prototype.setPropertyValue = function (name, val) {
        var oldValue = this.getPropertyValue(name);
        if (oldValue &&
            Array.isArray(oldValue) &&
            !!this.arraysInfo &&
            (!val || Array.isArray(val))) {
            if (this.isTwoValueEquals(oldValue, val))
                return;
            this.setArrayPropertyDirectly(name, val);
        }
        else {
            this.setPropertyValueDirectly(name, val);
            if (!this.isDisposedValue && !this.isTwoValueEquals(oldValue, val)) {
                this.propertyValueChanged(name, oldValue, val);
            }
        }
    };
    Base.prototype.setArrayPropertyDirectly = function (name, val, sendNotification) {
        if (sendNotification === void 0) { sendNotification = true; }
        var arrayInfo = this.arraysInfo[name];
        this.setArray(name, this.getPropertyValue(name), val, arrayInfo ? arrayInfo.isItemValues : false, arrayInfo ? sendNotification && arrayInfo.onPush : null);
    };
    Base.prototype.setPropertyValueDirectly = function (name, val) {
        this.setPropertyValueCore(this.propertyHash, name, val);
    };
    Base.prototype.clearPropertyValue = function (name) {
        this.setPropertyValueCore(this.propertyHash, name, null);
        delete this.propertyHash[name];
    };
    Base.prototype.onPropertyValueChangedCallback = function (name, oldValue, newValue, sender, arrayChanges) { };
    Base.prototype.itemValuePropertyChanged = function (item, name, oldValue, newValue) {
        this.onItemValuePropertyChanged.fire(this, {
            obj: item,
            name: name,
            oldValue: oldValue,
            newValue: newValue,
            propertyName: item.ownerPropertyName,
        });
    };
    Base.prototype.onPropertyValueChanged = function (name, oldValue, newValue) { };
    Base.prototype.propertyValueChanged = function (name, oldValue, newValue, arrayChanges, target) {
        if (this.isLoadingFromJson)
            return;
        this.updateBindings(name, newValue);
        this.onPropertyValueChanged(name, oldValue, newValue);
        this.onPropertyChanged.fire(this, {
            name: name,
            oldValue: oldValue,
            newValue: newValue,
        });
        this.doPropertyValueChangedCallback(name, oldValue, newValue, arrayChanges, this);
        if (!this.onPropChangeFunctions)
            return;
        for (var i = 0; i < this.onPropChangeFunctions.length; i++) {
            if (this.onPropChangeFunctions[i].name == name)
                this.onPropChangeFunctions[i].func(newValue);
        }
    };
    Object.defineProperty(Base.prototype, "isInternal", {
        get: function () {
            return false;
        },
        enumerable: false,
        configurable: true
    });
    Base.prototype.doPropertyValueChangedCallback = function (name, oldValue, newValue, arrayChanges, target) {
        if (this.isInternal)
            return;
        if (!target)
            target = this;
        var notifier = this.getSurvey();
        if (!notifier)
            notifier = this;
        if (!!notifier.onPropertyValueChangedCallback) {
            notifier.onPropertyValueChangedCallback(name, oldValue, newValue, target, arrayChanges);
        }
        if (notifier !== this && !!this.onPropertyValueChangedCallback) {
            this.onPropertyValueChangedCallback(name, oldValue, newValue, target, arrayChanges);
        }
    };
    /**
     * Register a function that will be called on a property value changed.
     * @param name the property name
     * @param func the function with no parameters that will be called on property changed.
     * @param key an optional parameter. If there is already a registered function for this property with the same key, it will be overwritten.
     */
    Base.prototype.registerFunctionOnPropertyValueChanged = function (name, func, key) {
        if (key === void 0) { key = null; }
        if (!this.onPropChangeFunctions) {
            this.onPropChangeFunctions = [];
        }
        if (key) {
            for (var i = 0; i < this.onPropChangeFunctions.length; i++) {
                var item = this.onPropChangeFunctions[i];
                if (item.name == name && item.key == key) {
                    item.func = func;
                    return;
                }
            }
        }
        this.onPropChangeFunctions.push({ name: name, func: func, key: key });
    };
    /**
     * Register a function that will be called on a property value changed from the names list.
     * @param names the list of properties names
     * @param func the function with no parameters that will be called on property changed.
     * @param key an optional parameter. If there is already a registered function for this property with the same key, it will be overwritten.
     */
    Base.prototype.registerFunctionOnPropertiesValueChanged = function (names, func, key) {
        if (key === void 0) { key = null; }
        for (var i = 0; i < names.length; i++) {
            this.registerFunctionOnPropertyValueChanged(names[i], func, key);
        }
    };
    /**
     * Unregister notification on property value changed
     * @param name the property name
     * @param key the key with which you have registered the notification for this property. It can be null.
     */
    Base.prototype.unRegisterFunctionOnPropertyValueChanged = function (name, key) {
        if (key === void 0) { key = null; }
        if (!this.onPropChangeFunctions)
            return;
        for (var i = 0; i < this.onPropChangeFunctions.length; i++) {
            var item = this.onPropChangeFunctions[i];
            if (item.name == name && item.key == key) {
                this.onPropChangeFunctions.splice(i, 1);
                return;
            }
        }
    };
    /**
     * Unregister notification on property value changed for all properties in the names list.
     * @param names the list of properties names
     * @param key the key with which you have registered the notification for this property. It can be null.
     */
    Base.prototype.unRegisterFunctionOnPropertiesValueChanged = function (names, key) {
        if (key === void 0) { key = null; }
        for (var i = 0; i < names.length; i++) {
            this.unRegisterFunctionOnPropertyValueChanged(names[i], key);
        }
    };
    Base.prototype.createCustomLocalizableObj = function (name) {
        var locStr = this.getLocalizableString(name);
        if (locStr || !this.getLocale)
            return;
        this.createLocalizableString(name, this);
    };
    Base.prototype.createLocalizableString = function (name, owner, useMarkDown, defaultStr) {
        var _this = this;
        if (useMarkDown === void 0) { useMarkDown = false; }
        if (defaultStr === void 0) { defaultStr = false; }
        var locStr = new _localizablestring__WEBPACK_IMPORTED_MODULE_0__["LocalizableString"](owner, useMarkDown, name);
        if (defaultStr) {
            locStr.localizationName = defaultStr === true ? name : defaultStr;
        }
        locStr.onStrChanged = function (oldValue, newValue) {
            _this.propertyValueChanged(name, oldValue, newValue);
        };
        if (!this.localizableStrings) {
            this.localizableStrings = {};
        }
        this.localizableStrings[name] = locStr;
        return locStr;
    };
    Base.prototype.getLocalizableString = function (name) {
        return !!this.localizableStrings ? this.localizableStrings[name] : null;
    };
    Base.prototype.getLocalizableStringText = function (name, defaultStr) {
        if (defaultStr === void 0) { defaultStr = ""; }
        var locStr = this.getLocalizableString(name);
        if (!locStr)
            return "";
        var res = locStr.text;
        return res ? res : defaultStr;
    };
    Base.prototype.setLocalizableStringText = function (name, value) {
        var locStr = this.getLocalizableString(name);
        if (!locStr)
            return;
        locStr.text = value;
    };
    Base.prototype.addUsedLocales = function (locales) {
        if (!!this.localizableStrings) {
            for (var key in this.localizableStrings) {
                var item = this.getLocalizableString(key);
                if (item)
                    this.AddLocStringToUsedLocales(item, locales);
            }
        }
        if (!!this.arraysInfo) {
            for (var key in this.arraysInfo) {
                var items = this.getPropertyValue(key);
                if (!items || !items.length)
                    continue;
                for (var i = 0; i < items.length; i++) {
                    var item = items[i];
                    if (item && item.addUsedLocales) {
                        item.addUsedLocales(locales);
                    }
                }
            }
        }
    };
    Base.prototype.searchText = function (text, founded) {
        var strs = [];
        this.getSearchableLocalizedStrings(strs);
        for (var i = 0; i < strs.length; i++) {
            if (strs[i].setFindText(text)) {
                founded.push({ element: this, str: strs[i] });
            }
        }
    };
    Base.prototype.getSearchableLocalizedStrings = function (arr) {
        if (!!this.localizableStrings) {
            var keys_1 = [];
            this.getSearchableLocKeys(keys_1);
            for (var i = 0; i < keys_1.length; i++) {
                var item = this.getLocalizableString(keys_1[i]);
                if (item)
                    arr.push(item);
            }
        }
        if (!this.arraysInfo)
            return;
        var keys = [];
        this.getSearchableItemValueKeys(keys);
        for (var i = 0; i < keys.length; i++) {
            var items = this.getPropertyValue(keys[i]);
            if (!items)
                continue;
            for (var j = 0; j < items.length; j++) {
                arr.push(items[j].locText);
            }
        }
    };
    Base.prototype.getSearchableLocKeys = function (keys) { };
    Base.prototype.getSearchableItemValueKeys = function (keys) { };
    Base.prototype.AddLocStringToUsedLocales = function (locStr, locales) {
        var locs = locStr.getLocales();
        for (var i = 0; i < locs.length; i++) {
            if (locales.indexOf(locs[i]) < 0) {
                locales.push(locs[i]);
            }
        }
    };
    Base.prototype.createItemValues = function (name) {
        var self = this;
        var result = this.createNewArray(name, function (item) {
            item.locOwner = self;
            item.ownerPropertyName = name;
        });
        this.arraysInfo[name].isItemValues = true;
        return result;
    };
    Base.prototype.notifyArrayChanged = function (ar, arrayChanges) {
        !!ar.onArrayChanged && ar.onArrayChanged(arrayChanges);
    };
    Base.prototype.createNewArrayCore = function (name) {
        var res = null;
        if (!!this.createArrayCoreHandler) {
            res = this.createArrayCoreHandler(this.propertyHash, name);
        }
        if (!res) {
            res = new Array();
            this.setPropertyValueCore(this.propertyHash, name, res);
        }
        return res;
    };
    Base.prototype.ensureArray = function (name, onPush, onRemove) {
        if (onPush === void 0) { onPush = null; }
        if (onRemove === void 0) { onRemove = null; }
        if (this.arraysInfo && this.arraysInfo[name]) {
            return;
        }
        return this.createNewArray(name, onPush, onRemove);
    };
    Base.prototype.createNewArray = function (name, onPush, onRemove) {
        if (onPush === void 0) { onPush = null; }
        if (onRemove === void 0) { onRemove = null; }
        var newArray = this.createNewArrayCore(name);
        if (!this.arraysInfo) {
            this.arraysInfo = {};
        }
        this.arraysInfo[name] = { onPush: onPush, isItemValues: false };
        var self = this;
        newArray.push = function (value) {
            var result = Object.getPrototypeOf(newArray).push.call(newArray, value);
            if (!self.isDisposedValue) {
                if (onPush)
                    onPush(value, newArray.length - 1);
                var arrayChanges = new ArrayChanges(newArray.length - 1, 0, [value], []);
                self.propertyValueChanged(name, newArray, newArray, arrayChanges);
                self.notifyArrayChanged(newArray, arrayChanges);
            }
            return result;
        };
        newArray.shift = function () {
            var result = Object.getPrototypeOf(newArray).shift.call(newArray);
            if (!self.isDisposedValue && result) {
                if (onRemove)
                    onRemove(result);
                var arrayChanges = new ArrayChanges(newArray.length - 1, 1, [], []);
                self.propertyValueChanged(name, newArray, newArray, arrayChanges);
                self.notifyArrayChanged(newArray, arrayChanges);
            }
            return result;
        };
        newArray.unshift = function (value) {
            var result = Object.getPrototypeOf(newArray).unshift.call(newArray, value);
            if (!self.isDisposedValue) {
                if (onPush)
                    onPush(value, newArray.length - 1);
                var arrayChanges = new ArrayChanges(0, 0, [value], []);
                self.propertyValueChanged(name, newArray, newArray, arrayChanges);
                self.notifyArrayChanged(newArray, arrayChanges);
            }
            return result;
        };
        newArray.pop = function () {
            var result = Object.getPrototypeOf(newArray).pop.call(newArray);
            if (!self.isDisposedValue) {
                if (onRemove)
                    onRemove(result);
                var arrayChanges = new ArrayChanges(newArray.length - 1, 1, [], []);
                self.propertyValueChanged(name, newArray, newArray, arrayChanges);
                self.notifyArrayChanged(newArray, arrayChanges);
            }
            return result;
        };
        newArray.splice = function (start, deleteCount) {
            var _a;
            var items = [];
            for (var _i = 2; _i < arguments.length; _i++) {
                items[_i - 2] = arguments[_i];
            }
            if (!start)
                start = 0;
            if (!deleteCount)
                deleteCount = 0;
            var result = (_a = Object.getPrototypeOf(newArray).splice).call.apply(_a, __spreadArray([newArray,
                start,
                deleteCount], items, false));
            if (!items)
                items = [];
            if (!self.isDisposedValue) {
                if (onRemove && result) {
                    for (var i = 0; i < result.length; i++) {
                        onRemove(result[i]);
                    }
                }
                if (onPush) {
                    for (var i = 0; i < items.length; i++) {
                        onPush(items[i], start + i);
                    }
                }
                var arrayChanges = new ArrayChanges(start, deleteCount, items, result);
                self.propertyValueChanged(name, newArray, newArray, arrayChanges);
                self.notifyArrayChanged(newArray, arrayChanges);
            }
            return result;
        };
        return newArray;
    };
    Base.prototype.getItemValueType = function () {
        return undefined;
    };
    Base.prototype.setArray = function (name, src, dest, isItemValues, onPush) {
        var deletedItems = [].concat(src);
        Object.getPrototypeOf(src).splice.call(src, 0, src.length);
        if (!!dest) {
            for (var i = 0; i < dest.length; i++) {
                var item = dest[i];
                if (isItemValues) {
                    if (!!Base.createItemValue) {
                        item = Base.createItemValue(item, this.getItemValueType());
                    }
                }
                Object.getPrototypeOf(src).push.call(src, item);
                if (onPush)
                    onPush(src[i]);
            }
        }
        var arrayChanges = new ArrayChanges(0, deletedItems.length, src, deletedItems);
        this.propertyValueChanged(name, deletedItems, src, arrayChanges);
        this.notifyArrayChanged(src, arrayChanges);
    };
    Base.prototype.isTwoValueEquals = function (x, y, caseInSensitive, trimString) {
        if (caseInSensitive === void 0) { caseInSensitive = false; }
        if (trimString === void 0) { trimString = false; }
        return _helpers__WEBPACK_IMPORTED_MODULE_1__["Helpers"].isTwoValueEquals(x, y, false, !caseInSensitive, trimString);
    };
    Base.copyObject = function (dst, src) {
        for (var key in src) {
            var source = src[key];
            if (typeof source === "object") {
                source = {};
                this.copyObject(source, src[key]);
            }
            dst[key] = source;
        }
    };
    Base.prototype.copyCssClasses = function (dest, source) {
        if (!source)
            return;
        if (typeof source === "string" || source instanceof String) {
            dest["root"] = source;
        }
        else {
            Base.copyObject(dest, source);
        }
    };
    Base.prototype.getValueInLowCase = function (val) {
        if (!!val && typeof val == "string")
            return val.toLowerCase();
        return val;
    };
    Base.currentDependencis = undefined;
    return Base;
}());

var ArrayChanges = /** @class */ (function () {
    function ArrayChanges(index, deleteCount, itemsToAdd, deletedItems) {
        this.index = index;
        this.deleteCount = deleteCount;
        this.itemsToAdd = itemsToAdd;
        this.deletedItems = deletedItems;
    }
    return ArrayChanges;
}());

var Event = /** @class */ (function () {
    function Event() {
    }
    Object.defineProperty(Event.prototype, "isEmpty", {
        get: function () {
            return !this.callbacks || this.callbacks.length == 0;
        },
        enumerable: false,
        configurable: true
    });
    Event.prototype.fire = function (sender, options) {
        if (!this.callbacks)
            return;
        for (var i = 0; i < this.callbacks.length; i++) {
            this.callbacks[i](sender, options);
            if (!this.callbacks)
                return;
        }
    };
    Event.prototype.clear = function () {
        this.callbacks = undefined;
    };
    Event.prototype.add = function (func) {
        if (this.hasFunc(func))
            return;
        if (!this.callbacks) {
            this.callbacks = new Array();
        }
        this.callbacks.push(func);
        this.fireCallbackChanged();
    };
    Event.prototype.remove = function (func) {
        if (this.hasFunc(func)) {
            var index = this.callbacks.indexOf(func, 0);
            this.callbacks.splice(index, 1);
            this.fireCallbackChanged();
        }
    };
    Event.prototype.hasFunc = function (func) {
        if (this.callbacks == null)
            return false;
        return this.callbacks.indexOf(func, 0) > -1;
    };
    Event.prototype.fireCallbackChanged = function () {
        if (!!this.onCallbacksChanged) {
            this.onCallbacksChanged();
        }
    };
    return Event;
}());

var EventBase = /** @class */ (function (_super) {
    __extends(EventBase, _super);
    function EventBase() {
        return _super !== null && _super.apply(this, arguments) || this;
    }
    return EventBase;
}(Event));



/***/ }),

/***/ "./src/calculatedValue.ts":
/*!********************************!*\
  !*** ./src/calculatedValue.ts ***!
  \********************************/
/*! exports provided: CalculatedValue */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "CalculatedValue", function() { return CalculatedValue; });
/* harmony import */ var _helpers__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./helpers */ "./src/helpers.ts");
/* harmony import */ var _base__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ./base */ "./src/base.ts");
/* harmony import */ var _conditions__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ./conditions */ "./src/conditions.ts");
/* harmony import */ var _jsonobject__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ./jsonobject */ "./src/jsonobject.ts");
var __extends = (undefined && undefined.__extends) || (function () {
    var extendStatics = function (d, b) {
        extendStatics = Object.setPrototypeOf ||
            ({ __proto__: [] } instanceof Array && function (d, b) { d.__proto__ = b; }) ||
            function (d, b) { for (var p in b) if (Object.prototype.hasOwnProperty.call(b, p)) d[p] = b[p]; };
        return extendStatics(d, b);
    };
    return function (d, b) {
        if (typeof b !== "function" && b !== null)
            throw new TypeError("Class extends value " + String(b) + " is not a constructor or null");
        extendStatics(d, b);
        function __() { this.constructor = d; }
        d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
    };
})();




/**
 * The calculated value is a way to define the variable in Survey Creator.
 * It has two main properties: name and expression. Based on expression the value read-only property is automatically calculated.
 * The name property should be unique though all calculated values.
 * It uses survey.getVariable/seruvey.setVariable functions to get/set its value. The class do not store its value internally.
 * You may set includeIntoResult property to true to store this calculated value into survey result.
 */
var CalculatedValue = /** @class */ (function (_super) {
    __extends(CalculatedValue, _super);
    function CalculatedValue(name, expression) {
        if (name === void 0) { name = null; }
        if (expression === void 0) { expression = null; }
        var _this = _super.call(this) || this;
        _this.expressionIsRunning = false;
        _this.isCalculated = false;
        if (!!name) {
            _this.name = name;
        }
        if (!!expression) {
            _this.expression = expression;
        }
        return _this;
    }
    CalculatedValue.prototype.setOwner = function (data) {
        this.data = data;
        this.rerunExpression();
    };
    CalculatedValue.prototype.getType = function () {
        return "calculatedvalue";
    };
    CalculatedValue.prototype.getSurvey = function (live) {
        if (live === void 0) { live = false; }
        return !!this.data && !!this.data["getSurvey"]
            ? this.data.getSurvey()
            : null;
    };
    Object.defineProperty(CalculatedValue.prototype, "owner", {
        get: function () {
            return this.data;
        },
        enumerable: false,
        configurable: true
    });
    Object.defineProperty(CalculatedValue.prototype, "name", {
        /**
         * The calculated value name. It should be non empty and unique.
         */
        get: function () {
            return this.getPropertyValue("name", "");
        },
        set: function (val) {
            this.setPropertyValue("name", val);
        },
        enumerable: false,
        configurable: true
    });
    Object.defineProperty(CalculatedValue.prototype, "includeIntoResult", {
        /**
         * Set this property to true to include the non-empty calculated value into survey result, survey.data property.
         */
        get: function () {
            return this.getPropertyValue("includeIntoResult", false);
        },
        set: function (val) {
            this.setPropertyValue("includeIntoResult", val);
        },
        enumerable: false,
        configurable: true
    });
    Object.defineProperty(CalculatedValue.prototype, "expression", {
        /**
         * The Expression that used to calculate the value. You may use standard operators like +, -, * and /, squares (). Here is the example of accessing the question value {questionname}.
         * <br/>Example: "({quantity} * {price}) * (100 - {discount}) / 100"
         */
        get: function () {
            return this.getPropertyValue("expression", "");
        },
        set: function (val) {
            this.setPropertyValue("expression", val);
            this.rerunExpression();
        },
        enumerable: false,
        configurable: true
    });
    CalculatedValue.prototype.locCalculation = function () {
        this.expressionIsRunning = true;
    };
    CalculatedValue.prototype.unlocCalculation = function () {
        this.expressionIsRunning = false;
    };
    CalculatedValue.prototype.resetCalculation = function () {
        this.isCalculated = false;
    };
    CalculatedValue.prototype.doCalculation = function (calculatedValues, values, properties) {
        if (this.isCalculated)
            return;
        this.runExpressionCore(calculatedValues, values, properties);
        this.isCalculated = true;
    };
    CalculatedValue.prototype.runExpression = function (values, properties) {
        this.runExpressionCore(null, values, properties);
    };
    Object.defineProperty(CalculatedValue.prototype, "value", {
        get: function () {
            if (!this.data)
                return undefined;
            return this.data.getVariable(this.name);
        },
        enumerable: false,
        configurable: true
    });
    CalculatedValue.prototype.setValue = function (val) {
        if (!this.data)
            return;
        this.data.setVariable(this.name, val);
    };
    Object.defineProperty(CalculatedValue.prototype, "canRunExpression", {
        get: function () {
            return (!!this.data &&
                !this.isLoadingFromJson &&
                !!this.expression &&
                !this.expressionIsRunning &&
                !!this.name);
        },
        enumerable: false,
        configurable: true
    });
    CalculatedValue.prototype.rerunExpression = function () {
        if (!this.canRunExpression)
            return;
        this.runExpression(this.data.getFilteredValues(), this.data.getFilteredProperties());
    };
    CalculatedValue.prototype.runExpressionCore = function (calculatedValues, values, properties) {
        if (!this.canRunExpression)
            return;
        this.ensureExpression(values);
        this.locCalculation();
        if (!!calculatedValues) {
            this.runDependentExpressions(calculatedValues, values, properties);
        }
        this.expressionRunner.run(values, properties);
    };
    CalculatedValue.prototype.runDependentExpressions = function (calculatedValues, values, properties) {
        var variables = this.expressionRunner.getVariables();
        if (!variables)
            return;
        for (var i = 0; i < calculatedValues.length; i++) {
            var calcItem = calculatedValues[i];
            if (calcItem === this || variables.indexOf(calcItem.name) < 0)
                continue;
            calcItem.doCalculation(calculatedValues, values, properties);
            values[calcItem.name] = calcItem.value;
        }
    };
    CalculatedValue.prototype.ensureExpression = function (values) {
        var _this = this;
        if (!!this.expressionRunner)
            return;
        this.expressionRunner = new _conditions__WEBPACK_IMPORTED_MODULE_2__["ExpressionRunner"](this.expression);
        this.expressionRunner.onRunComplete = function (newValue) {
            if (!_helpers__WEBPACK_IMPORTED_MODULE_0__["Helpers"].isTwoValueEquals(newValue, _this.value)) {
                _this.setValue(newValue);
            }
            _this.unlocCalculation();
        };
    };
    return CalculatedValue;
}(_base__WEBPACK_IMPORTED_MODULE_1__["Base"]));

_jsonobject__WEBPACK_IMPORTED_MODULE_3__["Serializer"].addClass("calculatedvalue", [
    { name: "!name", isUnique: true },
    "expression:expression",
    "includeIntoResult:boolean",
], function () {
    return new CalculatedValue();
}, "base");


/***/ }),

/***/ "./src/choicesRestful.ts":
/*!*******************************!*\
  !*** ./src/choicesRestful.ts ***!
  \*******************************/
/*! exports provided: ChoicesRestful, ChoicesRestfull */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "ChoicesRestful", function() { return ChoicesRestful; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "ChoicesRestfull", function() { return ChoicesRestfull; });
/* harmony import */ var _base__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./base */ "./src/base.ts");
/* harmony import */ var _itemvalue__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ./itemvalue */ "./src/itemvalue.ts");
/* harmony import */ var _jsonobject__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ./jsonobject */ "./src/jsonobject.ts");
/* harmony import */ var _error__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ./error */ "./src/error.ts");
/* harmony import */ var _settings__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! ./settings */ "./src/settings.ts");
var __extends = (undefined && undefined.__extends) || (function () {
    var extendStatics = function (d, b) {
        extendStatics = Object.setPrototypeOf ||
            ({ __proto__: [] } instanceof Array && function (d, b) { d.__proto__ = b; }) ||
            function (d, b) { for (var p in b) if (Object.prototype.hasOwnProperty.call(b, p)) d[p] = b[p]; };
        return extendStatics(d, b);
    };
    return function (d, b) {
        if (typeof b !== "function" && b !== null)
            throw new TypeError("Class extends value " + String(b) + " is not a constructor or null");
        extendStatics(d, b);
        function __() { this.constructor = d; }
        d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
    };
})();





var XmlParser = /** @class */ (function () {
    function XmlParser() {
        this.parser = new DOMParser();
    }
    XmlParser.prototype.assignValue = function (target, name, value) {
        if (Array.isArray(target[name])) {
            target[name].push(value);
        }
        else if (target[name] !== undefined) {
            target[name] = [target[name]].concat(value);
        }
        else if (typeof value === "object" &&
            Object.keys(value).length === 1 &&
            Object.keys(value)[0] === name) {
            target[name] = value[name];
        }
        else {
            target[name] = value;
        }
    };
    XmlParser.prototype.xml2Json = function (xmlNode, result) {
        if (xmlNode.children && xmlNode.children.length > 0) {
            for (var i = 0; i < xmlNode.children.length; i++) {
                var childNode = xmlNode.children[i];
                var childObject = {};
                this.xml2Json(childNode, childObject);
                this.assignValue(result, childNode.nodeName, childObject);
            }
        }
        else {
            this.assignValue(result, xmlNode.nodeName, xmlNode.textContent);
        }
    };
    XmlParser.prototype.parseXmlString = function (xmlString) {
        var xmlRoot = this.parser.parseFromString(xmlString, "text/xml");
        var json = {};
        this.xml2Json(xmlRoot, json);
        return json;
    };
    return XmlParser;
}());
/**
 * A definition for filling choices for checkbox, dropdown and radiogroup questions from resfull services.
 * The run method call a restful service and results can be get on getResultCallback.
 */
var ChoicesRestful = /** @class */ (function (_super) {
    __extends(ChoicesRestful, _super);
    function ChoicesRestful() {
        var _this = _super.call(this) || this;
        _this.lastObjHash = "";
        _this.isRunningValue = false;
        _this.processedUrl = "";
        _this.processedPath = "";
        _this.isUsingCacheFromUrl = undefined;
        _this.error = null;
        _this.createItemValue = function (value) {
            return new _itemvalue__WEBPACK_IMPORTED_MODULE_1__["ItemValue"](value);
        };
        return _this;
    }
    Object.defineProperty(ChoicesRestful, "EncodeParameters", {
        get: function () {
            return _settings__WEBPACK_IMPORTED_MODULE_4__["settings"].webserviceEncodeParameters;
        },
        set: function (val) {
            _settings__WEBPACK_IMPORTED_MODULE_4__["settings"].webserviceEncodeParameters = val;
        },
        enumerable: false,
        configurable: true
    });
    ChoicesRestful.clearCache = function () {
        ChoicesRestful.itemsResult = {};
        ChoicesRestful.sendingSameRequests = {};
    };
    ChoicesRestful.addSameRequest = function (obj) {
        if (!obj.isUsingCache)
            return false;
        var hash = obj.objHash;
        var res = ChoicesRestful.sendingSameRequests[hash];
        if (!res) {
            ChoicesRestful.sendingSameRequests[obj.objHash] = [];
            return false;
        }
        res.push(obj);
        obj.isRunningValue = true;
        return true;
    };
    ChoicesRestful.unregisterSameRequests = function (obj, items) {
        if (!obj.isUsingCache)
            return;
        var res = ChoicesRestful.sendingSameRequests[obj.objHash];
        delete ChoicesRestful.sendingSameRequests[obj.objHash];
        if (!res)
            return;
        for (var i = 0; i < res.length; i++) {
            res[i].isRunningValue = false;
            if (!!res[i].getResultCallback) {
                res[i].getResultCallback(items);
            }
        }
    };
    ChoicesRestful.getCachedItemsResult = function (obj) {
        var hash = obj.objHash;
        var res = ChoicesRestful.itemsResult[hash];
        if (!res)
            return false;
        if (obj.getResultCallback) {
            obj.getResultCallback(res);
        }
        return true;
    };
    ChoicesRestful.prototype.getSurvey = function (live) {
        if (live === void 0) { live = false; }
        return !!this.owner ? this.owner.survey : null;
    };
    ChoicesRestful.prototype.run = function (textProcessor) {
        if (textProcessor === void 0) { textProcessor = null; }
        if (!this.url || !this.getResultCallback)
            return;
        this.processedText(textProcessor);
        if (!this.processedUrl) {
            this.doEmptyResultCallback({});
            this.lastObjHash = this.objHash;
            return;
        }
        if (this.lastObjHash === this.objHash)
            return;
        this.lastObjHash = this.objHash;
        this.error = null;
        if (this.useChangedItemsResults())
            return;
        if (ChoicesRestful.addSameRequest(this))
            return;
        this.sendRequest();
    };
    Object.defineProperty(ChoicesRestful.prototype, "isUsingCache", {
        get: function () {
            if (this.isUsingCacheFromUrl === true)
                return true;
            if (this.isUsingCacheFromUrl === false)
                return false;
            return _settings__WEBPACK_IMPORTED_MODULE_4__["settings"].useCachingForChoicesRestful;
        },
        enumerable: false,
        configurable: true
    });
    Object.defineProperty(ChoicesRestful.prototype, "isRunning", {
        get: function () {
            return this.getIsRunning();
        },
        enumerable: false,
        configurable: true
    });
    ChoicesRestful.prototype.getIsRunning = function () {
        return this.isRunningValue;
    };
    Object.defineProperty(ChoicesRestful.prototype, "isWaitingForParameters", {
        get: function () {
            return this.url && !this.processedUrl;
        },
        enumerable: false,
        configurable: true
    });
    ChoicesRestful.prototype.useChangedItemsResults = function () {
        return ChoicesRestful.getCachedItemsResult(this);
    };
    ChoicesRestful.prototype.doEmptyResultCallback = function (serverResult) {
        var items = [];
        if (this.updateResultCallback) {
            items = this.updateResultCallback(items, serverResult);
        }
        this.getResultCallback(items);
    };
    ChoicesRestful.prototype.processedText = function (textProcessor) {
        var urlText = this.url;
        if (!!urlText) {
            urlText = urlText
                .replace(ChoicesRestful.cacheText, "")
                .replace(ChoicesRestful.noCacheText, "");
        }
        if (textProcessor) {
            var pUrl = textProcessor.processTextEx(urlText, false, _settings__WEBPACK_IMPORTED_MODULE_4__["settings"].webserviceEncodeParameters);
            var pPath = textProcessor.processTextEx(this.path, false, _settings__WEBPACK_IMPORTED_MODULE_4__["settings"].webserviceEncodeParameters);
            if (!pUrl.hasAllValuesOnLastRun || !pPath.hasAllValuesOnLastRun) {
                this.processedUrl = "";
                this.processedPath = "";
            }
            else {
                this.processedUrl = pUrl.text;
                this.processedPath = pPath.text;
            }
        }
        else {
            this.processedUrl = urlText;
            this.processedPath = this.path;
        }
        if (this.onProcessedUrlCallback) {
            this.onProcessedUrlCallback(this.processedUrl, this.processedPath);
        }
    };
    ChoicesRestful.prototype.parseResponse = function (response) {
        var parsedResponse;
        if (!!response &&
            typeof response.indexOf === "function" &&
            response.indexOf("<") === 0) {
            var parser = new XmlParser();
            parsedResponse = parser.parseXmlString(response);
        }
        else {
            try {
                parsedResponse = JSON.parse(response);
            }
            catch (_a) {
                parsedResponse = (response || "")
                    .split("\n")
                    .map(function (s) { return s.trim(" "); })
                    .filter(function (s) { return !!s; });
            }
        }
        return parsedResponse;
    };
    ChoicesRestful.prototype.sendRequest = function () {
        var xhr = new XMLHttpRequest();
        xhr.open("GET", this.processedUrl);
        xhr.setRequestHeader("Content-Type", "application/x-www-form-urlencoded");
        var self = this;
        var loadingObjHash = this.objHash;
        xhr.onload = function () {
            self.beforeLoadRequest();
            if (xhr.status === 200) {
                self.onLoad(self.parseResponse(xhr.response), loadingObjHash);
            }
            else {
                self.onError(xhr.statusText, xhr.responseText);
            }
        };
        var options = { request: xhr };
        if (!!ChoicesRestful.onBeforeSendRequest) {
            ChoicesRestful.onBeforeSendRequest(this, options);
        }
        this.beforeSendRequest();
        options.request.send();
    };
    ChoicesRestful.prototype.getType = function () {
        return "choicesByUrl";
    };
    Object.defineProperty(ChoicesRestful.prototype, "isEmpty", {
        get: function () {
            return (!this.url &&
                !this.path &&
                !this.valueName &&
                !this.titleName &&
                !this.imageLinkName);
        },
        enumerable: false,
        configurable: true
    });
    ChoicesRestful.prototype.getCustomPropertiesNames = function () {
        var properties = this.getCustomProperties();
        var res = new Array();
        for (var i = 0; i < properties.length; i++) {
            res.push(this.getCustomPropertyName(properties[i].name));
        }
        return res;
    };
    ChoicesRestful.prototype.getCustomPropertyName = function (propertyName) {
        return propertyName + "Name";
    };
    ChoicesRestful.prototype.getCustomProperties = function () {
        var properties = _jsonobject__WEBPACK_IMPORTED_MODULE_2__["Serializer"].getProperties(this.itemValueType);
        var res = [];
        for (var i = 0; i < properties.length; i++) {
            if (properties[i].name === "value" ||
                properties[i].name === "text" ||
                properties[i].name === "visibleIf" ||
                properties[i].name === "enableIf")
                continue;
            res.push(properties[i]);
        }
        return res;
    };
    ChoicesRestful.prototype.setData = function (json) {
        this.clear();
        if (json.url)
            this.url = json.url;
        if (json.path)
            this.path = json.path;
        if (json.valueName)
            this.valueName = json.valueName;
        if (json.titleName)
            this.titleName = json.titleName;
        if (json.imageLinkName)
            this.imageLinkName = json.imageLinkName;
        if (json.allowEmptyResponse !== undefined)
            this.allowEmptyResponse = json.allowEmptyResponse;
        if (json.attachOriginalItems !== undefined)
            this.attachOriginalItems = json.attachOriginalItems;
        var properties = this.getCustomPropertiesNames();
        for (var i = 0; i < properties.length; i++) {
            if (json[properties[i]])
                this[properties[i]] = json[properties[i]];
        }
    };
    ChoicesRestful.prototype.getData = function () {
        if (this.isEmpty)
            return null;
        var res = {};
        if (this.url)
            res["url"] = this.url;
        if (this.path)
            res["path"] = this.path;
        if (this.valueName)
            res["valueName"] = this.valueName;
        if (this.titleName)
            res["titleName"] = this.titleName;
        if (this.imageLinkName)
            res["imageLinkName"] = this.imageLinkName;
        if (this.allowEmptyResponse)
            res["allowEmptyResponse"] = this.allowEmptyResponse;
        if (this.attachOriginalItems)
            res["attachOriginalItems"] = this.attachOriginalItems;
        var properties = this.getCustomPropertiesNames();
        for (var i = 0; i < properties.length; i++) {
            if (this[properties[i]])
                res[properties[i]] = this[properties[i]];
        }
        return res;
    };
    Object.defineProperty(ChoicesRestful.prototype, "url", {
        /**
         * Gets or sets a link to a web service. You can use text preprocessing here.
         * For example, the following url: _https://surveyjs.io/api/CountriesExample?region={region}_ is changed based on the _region_ question's value.
         * SurveyJS automatically gets data from the web service when the value of the _region_ question changes.
         * @see path
         * @see valueName
         * @see titleName
         * @see [Example: RESTful Dropdown](https://surveyjs.io/Examples/Library/?id=questiontype-dropdownrestfull)
         * @see [Docs: Fill Choices from a RESTful Service](https://surveyjs.io/Documentation/Library/?id=LibraryOverview#fill-the-choices-from-a-restful-service)
         */
        get: function () {
            return this.getPropertyValue("url", "");
        },
        set: function (val) {
            this.setPropertyValue("url", val);
            this.isUsingCacheFromUrl = undefined;
            if (!val)
                return;
            if (val.indexOf(ChoicesRestful.cacheText) > -1) {
                this.isUsingCacheFromUrl = true;
            }
            else {
                if (val.indexOf(ChoicesRestful.noCacheText) > -1) {
                    this.isUsingCacheFromUrl = false;
                }
            }
        },
        enumerable: false,
        configurable: true
    });
    Object.defineProperty(ChoicesRestful.prototype, "path", {
        /**
         * Use this property, if a web service returns a lot of information and you need only a part of it.
         * For example, a web service returns a list of countries and a list of capitals.
         * If you need a list of countries, set a correct path from which SurveyJS obtains the data, like: _DataList1\DataList2_
         * @see url
         * @see valueName
         * @see titleName
         * @see [Example: RESTful Dropdown](https://surveyjs.io/Examples/Library/?id=questiontype-dropdownrestfull)
         * @see [Docs: Fill Choices from a RESTful Service](https://surveyjs.io/Documentation/Library/?id=LibraryOverview#fill-the-choices-from-a-restful-service)
         */
        get: function () {
            return this.getPropertyValue("path", "");
        },
        set: function (val) {
            this.setPropertyValue("path", val);
        },
        enumerable: false,
        configurable: true
    });
    Object.defineProperty(ChoicesRestful.prototype, "valueName", {
        /**
         * Gets or sets the name of a property (in the obtained data object) to which SurveyJS binds to provide values for choice items.
         * @see url
         * @see path
         * @see titleName
         * @see [Example: RESTful Dropdown](https://surveyjs.io/Examples/Library/?id=questiontype-dropdownrestfull)
         * @see [Docs: Fill Choices from a RESTful Service](https://surveyjs.io/Documentation/Library/?id=LibraryOverview#fill-the-choices-from-a-restful-service)
         */
        get: function () {
            return this.getPropertyValue("valueName", "");
        },
        set: function (val) {
            this.setPropertyValue("valueName", val);
        },
        enumerable: false,
        configurable: true
    });
    Object.defineProperty(ChoicesRestful.prototype, "titleName", {
        /**
         * Gets or sets the name of a property (in the obtained data object) to which SurveyJS binds to provide display texts for choice items.
         * @see url
         * @see path
         * @see valueeName
         * @see [Example: RESTful Dropdown](https://surveyjs.io/Examples/Library/?id=questiontype-dropdownrestfull)
         * @see [Docs: Fill Choices from a RESTful Service](https://surveyjs.io/Documentation/Library/?id=LibraryOverview#fill-the-choices-from-a-restful-service)
         */
        get: function () {
            return this.getPropertyValue("titleName", "");
        },
        set: function (val) {
            this.setPropertyValue("titleName", val);
        },
        enumerable: false,
        configurable: true
    });
    Object.defineProperty(ChoicesRestful.prototype, "imageLinkName", {
        get: function () {
            return this.getPropertyValue("imageLinkName", "");
        },
        set: function (val) {
            this.setPropertyValue("imageLinkName", val);
        },
        enumerable: false,
        configurable: true
    });
    Object.defineProperty(ChoicesRestful.prototype, "allowEmptyResponse", {
        get: function () {
            return this.getPropertyValue("allowEmptyResponse", false);
        },
        set: function (val) {
            this.setPropertyValue("allowEmptyResponse", val);
        },
        enumerable: false,
        configurable: true
    });
    Object.defineProperty(ChoicesRestful.prototype, "attachOriginalItems", {
        get: function () {
            return this.getPropertyValue("attachOriginalItems", false);
        },
        set: function (val) {
            this.setPropertyValue("attachOriginalItems", val);
        },
        enumerable: false,
        configurable: true
    });
    Object.defineProperty(ChoicesRestful.prototype, "itemValueType", {
        get: function () {
            if (!this.owner)
                return "itemvalue";
            var prop = _jsonobject__WEBPACK_IMPORTED_MODULE_2__["Serializer"].findProperty(this.owner.getType(), "choices");
            if (!prop)
                return "itemvalue";
            if (prop.type == "itemvalue[]")
                return "itemvalue";
            return prop.type;
        },
        enumerable: false,
        configurable: true
    });
    ChoicesRestful.prototype.clear = function () {
        this.url = "";
        this.path = "";
        this.valueName = "";
        this.titleName = "";
        this.imageLinkName = "";
        var properties = this.getCustomPropertiesNames();
        for (var i = 0; i < properties.length; i++) {
            if (this[properties[i]])
                this[properties[i]] = "";
        }
    };
    ChoicesRestful.prototype.beforeSendRequest = function () {
        this.isRunningValue = true;
        if (!!this.beforeSendRequestCallback) {
            this.beforeSendRequestCallback();
        }
    };
    ChoicesRestful.prototype.beforeLoadRequest = function () {
        this.isRunningValue = false;
    };
    ChoicesRestful.prototype.onLoad = function (result, loadingObjHash) {
        if (loadingObjHash === void 0) { loadingObjHash = null; }
        if (!loadingObjHash) {
            loadingObjHash = this.objHash;
        }
        var items = new Array();
        var updatedResult = this.getResultAfterPath(result);
        if (updatedResult && updatedResult["length"]) {
            for (var i = 0; i < updatedResult.length; i++) {
                var itemValue = updatedResult[i];
                if (!itemValue)
                    continue;
                var value = !!this.getItemValueCallback
                    ? this.getItemValueCallback(itemValue)
                    : this.getValue(itemValue);
                var item = this.createItemValue(value);
                this.setTitle(item, itemValue);
                this.setCustomProperties(item, itemValue);
                if (this.attachOriginalItems) {
                    item.originalItem = itemValue;
                }
                var imageLink = this.getImageLink(itemValue);
                if (!!imageLink) {
                    item.imageLink = imageLink;
                }
                items.push(item);
            }
        }
        else {
            if (!this.allowEmptyResponse) {
                this.error = new _error__WEBPACK_IMPORTED_MODULE_3__["WebRequestEmptyError"](null, this.owner);
            }
        }
        if (this.updateResultCallback) {
            items = this.updateResultCallback(items, result);
        }
        if (this.isUsingCache) {
            ChoicesRestful.itemsResult[loadingObjHash] = items;
        }
        this.callResultCallback(items, loadingObjHash);
        ChoicesRestful.unregisterSameRequests(this, items);
    };
    ChoicesRestful.prototype.callResultCallback = function (items, loadingObjHash) {
        if (loadingObjHash != this.objHash)
            return;
        this.getResultCallback(items);
    };
    ChoicesRestful.prototype.setCustomProperties = function (item, itemValue) {
        var properties = this.getCustomProperties();
        for (var i = 0; i < properties.length; i++) {
            var prop = properties[i];
            var val = this.getValueCore(itemValue, this.getPropertyBinding(prop.name));
            if (!this.isValueEmpty(val)) {
                item[prop.name] = val;
            }
        }
    };
    ChoicesRestful.prototype.getPropertyBinding = function (propertyName) {
        if (this[this.getCustomPropertyName(propertyName)])
            return this[this.getCustomPropertyName(propertyName)];
        if (this[propertyName])
            return this[propertyName];
        return propertyName;
    };
    ChoicesRestful.prototype.onError = function (status, response) {
        this.error = new _error__WEBPACK_IMPORTED_MODULE_3__["WebRequestError"](status, response, this.owner);
        this.doEmptyResultCallback(response);
        ChoicesRestful.unregisterSameRequests(this, []);
    };
    ChoicesRestful.prototype.getResultAfterPath = function (result) {
        if (!result)
            return result;
        if (!this.processedPath)
            return result;
        var pathes = this.getPathes();
        for (var i = 0; i < pathes.length; i++) {
            result = result[pathes[i]];
            if (!result)
                return null;
        }
        return result;
    };
    ChoicesRestful.prototype.getPathes = function () {
        var pathes = [];
        if (this.processedPath.indexOf(";") > -1) {
            pathes = this.path.split(";");
        }
        else {
            pathes = this.processedPath.split(",");
        }
        if (pathes.length == 0)
            pathes.push(this.processedPath);
        return pathes;
    };
    ChoicesRestful.prototype.getValue = function (item) {
        if (!item)
            return null;
        if (this.valueName)
            return this.getValueCore(item, this.valueName);
        if (!(item instanceof Object))
            return item;
        var len = Object.keys(item).length;
        if (len < 1)
            return null;
        return item[Object.keys(item)[0]];
    };
    ChoicesRestful.prototype.setTitle = function (item, itemValue) {
        var title = this.titleName ? this.titleName : "title";
        var val = this.getValueCore(itemValue, title);
        if (!val)
            return;
        if (typeof val === "string") {
            item.text = val;
        }
        else {
            item.locText.setJson(val);
        }
    };
    ChoicesRestful.prototype.getImageLink = function (item) {
        var imageLink = this.imageLinkName ? this.imageLinkName : "imageLink";
        return this.getValueCore(item, imageLink);
    };
    ChoicesRestful.prototype.getValueCore = function (item, property) {
        if (!item)
            return null;
        if (property.indexOf(".") < 0)
            return item[property];
        var properties = property.split(".");
        for (var i = 0; i < properties.length; i++) {
            item = item[properties[i]];
            if (!item)
                return null;
        }
        return item;
    };
    Object.defineProperty(ChoicesRestful.prototype, "objHash", {
        get: function () {
            return (this.processedUrl +
                ";" +
                this.processedPath +
                ";" +
                this.valueName +
                ";" +
                this.titleName +
                ";" +
                this.imageLinkName);
        },
        enumerable: false,
        configurable: true
    });
    ChoicesRestful.cacheText = "{CACHE}";
    ChoicesRestful.noCacheText = "{NOCACHE}";
    ChoicesRestful.itemsResult = {};
    ChoicesRestful.sendingSameRequests = {};
    return ChoicesRestful;
}(_base__WEBPACK_IMPORTED_MODULE_0__["Base"]));

/**
 * Obsolete, please use ChoicesRestful
 */
var ChoicesRestfull = /** @class */ (function (_super) {
    __extends(ChoicesRestfull, _super);
    function ChoicesRestfull() {
        return _super !== null && _super.apply(this, arguments) || this;
    }
    Object.defineProperty(ChoicesRestfull, "EncodeParameters", {
        get: function () {
            return ChoicesRestful.EncodeParameters;
        },
        set: function (val) {
            ChoicesRestful.EncodeParameters = val;
        },
        enumerable: false,
        configurable: true
    });
    ChoicesRestfull.clearCache = function () {
        ChoicesRestful.clearCache();
    };
    Object.defineProperty(ChoicesRestfull, "onBeforeSendRequest", {
        get: function () {
            return ChoicesRestful.onBeforeSendRequest;
        },
        set: function (val) {
            ChoicesRestful.onBeforeSendRequest = val;
        },
        enumerable: false,
        configurable: true
    });
    return ChoicesRestfull;
}(ChoicesRestful));

_jsonobject__WEBPACK_IMPORTED_MODULE_2__["Serializer"].addClass("choicesByUrl", [
    "url",
    "path",
    "valueName",
    "titleName",
    {
        name: "imageLinkName",
        visibleIf: function (obj) {
            return !!obj && !!obj.owner && obj.owner.getType() == "imagepicker";
        },
    },
    { name: "allowEmptyResponse:boolean", default: false },
    { name: "attachOriginalItems:boolean", default: false, visible: false },
], function () {
    return new ChoicesRestful();
});


/***/ }),

/***/ "./src/conditionProcessValue.ts":
/*!**************************************!*\
  !*** ./src/conditionProcessValue.ts ***!
  \**************************************/
/*! exports provided: ProcessValue */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "ProcessValue", function() { return ProcessValue; });
/* harmony import */ var _helpers__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./helpers */ "./src/helpers.ts");

var ProcessValue = /** @class */ (function () {
    function ProcessValue() {
        this.values = null;
        this.properties = null;
    }
    ProcessValue.prototype.getFirstName = function (text, obj) {
        if (obj === void 0) { obj = null; }
        if (!text)
            return text;
        var res = "";
        if (!!obj) {
            res = this.getFirstPropertyName(text, obj);
            if (!!res)
                return res;
        }
        for (var i = 0; i < text.length; i++) {
            var ch = text[i];
            if (ch == "." || ch == "[")
                break;
            res += ch;
        }
        return res;
    };
    ProcessValue.prototype.hasValue = function (text, values) {
        if (values === void 0) { values = null; }
        if (!values)
            values = this.values;
        var res = this.getValueCore(text, values);
        return res.hasValue;
    };
    ProcessValue.prototype.getValue = function (text, values) {
        if (values === void 0) { values = null; }
        if (!values)
            values = this.values;
        var res = this.getValueCore(text, values);
        return res.value;
    };
    ProcessValue.prototype.setValue = function (obj, text, value) {
        if (!text)
            return;
        var nonNestedObj = this.getNonNestedObject(obj, text, true);
        if (!nonNestedObj)
            return;
        obj = nonNestedObj.value;
        text = nonNestedObj.text;
        if (!!obj && !!text) {
            obj[text] = value;
        }
    };
    ProcessValue.prototype.getValueInfo = function (valueInfo) {
        if (!!valueInfo.path) {
            valueInfo.value = this.getValueFromPath(valueInfo.path, this.values);
            valueInfo.hasValue =
                valueInfo.value !== null && !_helpers__WEBPACK_IMPORTED_MODULE_0__["Helpers"].isValueEmpty(valueInfo.value);
            if (!valueInfo.hasValue &&
                valueInfo.path.length > 1 &&
                valueInfo.path[valueInfo.path.length - 1] == "length") {
                valueInfo.hasValue = true;
                valueInfo.value = 0;
            }
            return;
        }
        var res = this.getValueCore(valueInfo.name, this.values);
        valueInfo.value = res.value;
        valueInfo.hasValue = res.hasValue;
        valueInfo.path = res.hasValue ? res.path : null;
    };
    ProcessValue.prototype.getValueFromPath = function (path, values) {
        var index = 0;
        while (!!values && index < path.length) {
            var ind_name = path[index];
            if (_helpers__WEBPACK_IMPORTED_MODULE_0__["Helpers"].isNumber(ind_name) &&
                Array.isArray(values) &&
                ind_name >= values.length)
                return null;
            values = values[ind_name];
            index++;
        }
        return values;
    };
    ProcessValue.prototype.getValueCore = function (text, values) {
        var res = { hasValue: false, value: null, path: null };
        var curValue = values;
        if (!curValue && curValue !== 0 && curValue !== false)
            return res;
        if (text &&
            text.lastIndexOf(".length") > -1 &&
            text.lastIndexOf(".length") === text.length - ".length".length) {
            res.value = 0;
            res.hasValue = true;
        }
        var nonNestedObj = this.getNonNestedObject(curValue, text, false);
        if (!nonNestedObj)
            return res;
        res.path = nonNestedObj.path;
        res.value = !!nonNestedObj.text
            ? this.getObjectValue(nonNestedObj.value, nonNestedObj.text)
            : nonNestedObj.value;
        res.hasValue = !_helpers__WEBPACK_IMPORTED_MODULE_0__["Helpers"].isValueEmpty(res.value);
        return res;
    };
    ProcessValue.prototype.getNonNestedObject = function (obj, text, createPath) {
        var curName = this.getFirstPropertyName(text, obj, createPath);
        var path = !!curName ? [curName] : null;
        while (text != curName && !!obj) {
            var isArray = text[0] == "[";
            if (!isArray) {
                if (!curName && text == this.getFirstName(text))
                    return { value: obj, text: text, path: path };
                obj = this.getObjectValue(obj, curName);
                if (_helpers__WEBPACK_IMPORTED_MODULE_0__["Helpers"].isValueEmpty(obj) && !createPath)
                    return null;
                text = text.substr(curName.length);
            }
            else {
                var objInArray = this.getObjInArray(obj, text);
                if (!objInArray)
                    return null;
                obj = objInArray.value;
                text = objInArray.text;
                path.push(objInArray.index);
            }
            if (!!text && text[0] == ".") {
                text = text.substr(1);
            }
            curName = this.getFirstPropertyName(text, obj, createPath);
            if (!!curName) {
                path.push(curName);
            }
        }
        return { value: obj, text: text, path: path };
    };
    ProcessValue.prototype.getObjInArray = function (curValue, text) {
        if (!Array.isArray(curValue))
            return null;
        var index = 1;
        var str = "";
        while (index < text.length && text[index] != "]") {
            str += text[index];
            index++;
        }
        text = index < text.length ? text.substr(index + 1) : "";
        index = this.getIntValue(str);
        if (index < 0 || index >= curValue.length)
            return null;
        return { value: curValue[index], text: text, index: index };
    };
    ProcessValue.prototype.getFirstPropertyName = function (name, obj, createProp) {
        if (createProp === void 0) { createProp = false; }
        if (!name)
            return name;
        if (!obj)
            obj = {};
        if (obj.hasOwnProperty(name))
            return name;
        var nameInLow = name.toLowerCase();
        var A = nameInLow[0];
        var a = A.toUpperCase();
        for (var key in obj) {
            var first = key[0];
            if (first === a || first === A) {
                var keyName = key.toLowerCase();
                if (keyName == nameInLow)
                    return key;
                if (nameInLow.length <= keyName.length)
                    continue;
                var ch = nameInLow[keyName.length];
                if (ch != "." && ch != "[")
                    continue;
                if (keyName == nameInLow.substr(0, keyName.length))
                    return key;
            }
        }
        if (createProp && name[0] !== "[") {
            var ind = name.indexOf(".");
            if (ind > -1) {
                name = name.substr(0, ind);
                obj[name] = {};
            }
            return name;
        }
        return "";
    };
    ProcessValue.prototype.getObjectValue = function (obj, name) {
        if (!name)
            return null;
        return obj[name];
    };
    ProcessValue.prototype.getIntValue = function (str) {
        if (str == "0" || ((str | 0) > 0 && str % 1 == 0))
            return Number(str);
        return -1;
    };
    return ProcessValue;
}());



/***/ }),

/***/ "./src/conditions.ts":
/*!***************************!*\
  !*** ./src/conditions.ts ***!
  \***************************/
/*! exports provided: ExpressionRunnerBase, ConditionRunner, ExpressionRunner */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "ExpressionRunnerBase", function() { return ExpressionRunnerBase; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "ConditionRunner", function() { return ConditionRunner; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "ExpressionRunner", function() { return ExpressionRunner; });
/* harmony import */ var _conditionProcessValue__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./conditionProcessValue */ "./src/conditionProcessValue.ts");
/* harmony import */ var _conditionsParser__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ./conditionsParser */ "./src/conditionsParser.ts");
var __extends = (undefined && undefined.__extends) || (function () {
    var extendStatics = function (d, b) {
        extendStatics = Object.setPrototypeOf ||
            ({ __proto__: [] } instanceof Array && function (d, b) { d.__proto__ = b; }) ||
            function (d, b) { for (var p in b) if (Object.prototype.hasOwnProperty.call(b, p)) d[p] = b[p]; };
        return extendStatics(d, b);
    };
    return function (d, b) {
        if (typeof b !== "function" && b !== null)
            throw new TypeError("Class extends value " + String(b) + " is not a constructor or null");
        extendStatics(d, b);
        function __() { this.constructor = d; }
        d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
    };
})();


var ExpressionRunnerBase = /** @class */ (function () {
    function ExpressionRunnerBase(expression) {
        this.processValue = new _conditionProcessValue__WEBPACK_IMPORTED_MODULE_0__["ProcessValue"]();
        this.parser = new _conditionsParser__WEBPACK_IMPORTED_MODULE_1__["ConditionsParser"]();
        this.isAsyncValue = false;
        this.hasFunctionValue = false;
        this.expression = expression;
    }
    Object.defineProperty(ExpressionRunnerBase.prototype, "expression", {
        get: function () {
            return this.expressionValue;
        },
        set: function (value) {
            if (this.expression === value)
                return;
            this.expressionValue = value;
            this.operand = this.parser.parseExpression(value);
            this.hasFunctionValue = this.canRun() ? this.operand.hasFunction() : false;
            this.isAsyncValue = this.hasFunction()
                ? this.operand.hasAsyncFunction()
                : false;
        },
        enumerable: false,
        configurable: true
    });
    ExpressionRunnerBase.prototype.getVariables = function () {
        if (!this.operand)
            return [];
        var variables = [];
        this.operand.setVariables(variables);
        return variables;
    };
    ExpressionRunnerBase.prototype.hasFunction = function () {
        return this.hasFunctionValue;
    };
    Object.defineProperty(ExpressionRunnerBase.prototype, "isAsync", {
        get: function () {
            return this.isAsyncValue;
        },
        enumerable: false,
        configurable: true
    });
    ExpressionRunnerBase.prototype.canRun = function () {
        return !!this.operand;
    };
    ExpressionRunnerBase.prototype.runCore = function (values, properties) {
        var _this = this;
        if (properties === void 0) { properties = null; }
        if (!this.operand)
            return null;
        this.processValue.values = values;
        this.processValue.properties = properties;
        if (!this.isAsync)
            return this.runValues();
        this.asyncFuncList = [];
        this.operand.addToAsyncList(this.asyncFuncList);
        for (var i = 0; i < this.asyncFuncList.length; i++) {
            this.asyncFuncList[i].onAsyncReady = function () {
                _this.doAsyncFunctionReady();
            };
        }
        for (var i = 0; i < this.asyncFuncList.length; i++) {
            this.asyncFuncList[i].evaluateAsync(this.processValue);
        }
        return false;
    };
    ExpressionRunnerBase.prototype.doAsyncFunctionReady = function () {
        for (var i = 0; i < this.asyncFuncList.length; i++) {
            if (!this.asyncFuncList[i].isReady)
                return;
        }
        this.runValues();
    };
    ExpressionRunnerBase.prototype.runValues = function () {
        var res = this.operand.evaluate(this.processValue);
        this.doOnComplete(res);
        return res;
    };
    ExpressionRunnerBase.prototype.doOnComplete = function (res) { };
    return ExpressionRunnerBase;
}());

var ConditionRunner = /** @class */ (function (_super) {
    __extends(ConditionRunner, _super);
    function ConditionRunner() {
        return _super !== null && _super.apply(this, arguments) || this;
    }
    ConditionRunner.prototype.run = function (values, properties) {
        if (properties === void 0) { properties = null; }
        return this.runCore(values, properties) == true;
    };
    ConditionRunner.prototype.doOnComplete = function (res) {
        if (!!this.onRunComplete)
            this.onRunComplete(res == true);
    };
    return ConditionRunner;
}(ExpressionRunnerBase));

var ExpressionRunner = /** @class */ (function (_super) {
    __extends(ExpressionRunner, _super);
    function ExpressionRunner() {
        return _super !== null && _super.apply(this, arguments) || this;
    }
    ExpressionRunner.prototype.run = function (values, properties) {
        if (properties === void 0) { properties = null; }
        return this.runCore(values, properties);
    };
    ExpressionRunner.prototype.doOnComplete = function (res) {
        if (!!this.onRunComplete)
            this.onRunComplete(res);
    };
    return ExpressionRunner;
}(ExpressionRunnerBase));



/***/ }),

/***/ "./src/conditionsParser.ts":
/*!*********************************!*\
  !*** ./src/conditionsParser.ts ***!
  \*********************************/
/*! exports provided: ConditionsParserError, ConditionsParser */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "ConditionsParserError", function() { return ConditionsParserError; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "ConditionsParser", function() { return ConditionsParser; });
/* harmony import */ var _expressions_expressionParser__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./expressions/expressionParser */ "./src/expressions/expressionParser.ts");

var ConditionsParserError = /** @class */ (function () {
    function ConditionsParserError(at, code) {
        this.at = at;
        this.code = code;
    }
    return ConditionsParserError;
}());

var ConditionsParser = /** @class */ (function () {
    function ConditionsParser() {
    }
    ConditionsParser.prototype.patchExpression = function (text) {
        return text
            .replace(/=>/g, ">=")
            .replace(/=</g, "<=")
            .replace(/<>/g, "!=")
            .replace(/==/g, "= ")
            .replace(/equals/g, "equal ")
            .replace(/notequals/g, "notequal ");
    };
    ConditionsParser.prototype.createCondition = function (text) {
        return this.parseExpression(text);
    };
    ConditionsParser.prototype.parseExpression = function (text) {
        try {
            var result = ConditionsParser.parserCache[text];
            if (result === undefined) {
                result = Object(_expressions_expressionParser__WEBPACK_IMPORTED_MODULE_0__["parse"])(this.patchExpression(text));
                if (!result.hasAsyncFunction()) {
                    ConditionsParser.parserCache[text] = result;
                }
            }
            return result;
        }
        catch (e) {
            if (e instanceof _expressions_expressionParser__WEBPACK_IMPORTED_MODULE_0__["SyntaxError"]) {
                this.conditionError = new ConditionsParserError(e.location.start.offset, e.message);
            }
        }
    };
    Object.defineProperty(ConditionsParser.prototype, "error", {
        get: function () {
            return this.conditionError;
        },
        enumerable: false,
        configurable: true
    });
    ConditionsParser.parserCache = {};
    return ConditionsParser;
}());



/***/ }),

/***/ "./src/defaultCss/cssbootstrap.ts":
/*!****************************************!*\
  !*** ./src/defaultCss/cssbootstrap.ts ***!
  \****************************************/
/*! exports provided: defaultBootstrapCss */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "defaultBootstrapCss", function() { return defaultBootstrapCss; });
/* harmony import */ var _cssstandard__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./cssstandard */ "./src/defaultCss/cssstandard.ts");

var defaultBootstrapCss = {
    root: "sv_main sv_bootstrap_css",
    container: "sv_container",
    header: "panel-heading card-header",
    body: "panel-body card-block mt-4",
    bodyEmpty: "panel-body card-block mt-4 sv_body_empty",
    footer: "panel-footer card-footer",
    title: "",
    description: "",
    logo: "sv_logo",
    logoImage: "sv_logo__image",
    headerText: "sv_header__text",
    navigationButton: "",
    completedPage: "",
    navigation: {
        complete: "btn sv_complete_btn",
        prev: "btn sv_prev_btn",
        next: "btn sv_next_btn",
        start: "btn sv_start_btn",
        preview: "btn sv_preview_btn",
        edit: "btn sv_edit_btn",
    },
    progress: "progress center-block mx-auto mb-4",
    progressBar: "progress-bar",
    progressTextUnderBar: "sv-hidden",
    progressButtonsContainerCenter: "sv_progress-buttons__container-center",
    progressButtonsContainer: "sv_progress-buttons__container",
    progressButtonsImageButtonLeft: "sv_progress-buttons__image-button-left",
    progressButtonsImageButtonRight: "sv_progress-buttons__image-button-right",
    progressButtonsImageButtonHidden: "sv_progress-buttons__image-button--hidden",
    progressButtonsListContainer: "sv_progress-buttons__list-container",
    progressButtonsList: "sv_progress-buttons__list",
    progressButtonsListElementPassed: "sv_progress-buttons__list-element--passed",
    progressButtonsListElementCurrent: "sv_progress-buttons__list-element--current",
    progressButtonsListElementNonClickable: "sv_progress-buttons__list-element--nonclickable",
    progressButtonsPageTitle: "sv_progress-buttons__page-title",
    progressButtonsPageDescription: "sv_progress-buttons__page-description",
    page: {
        root: "",
        title: "",
        description: "small",
    },
    pageTitle: "",
    pageDescription: "small",
    row: "sv_row",
    question: {
        mainRoot: "sv_qstn",
        flowRoot: "sv_q_flow sv_qstn",
        header: "",
        headerLeft: "title-left",
        content: "",
        contentLeft: "content-left",
        titleLeftRoot: "sv_qstn_left",
        title: "",
        titleExpandable: "sv_q_title_expandable",
        number: "sv_q_num",
        description: "small",
        descriptionUnderInput: "small",
        requiredText: "sv_q_required_text",
        comment: "form-control",
        required: "",
        titleRequired: "",
        hasError: "has-error",
        indent: 20,
        formGroup: "form-group",
    },
    panel: {
        title: "sv_p_title",
        titleExpandable: "sv_p_title_expandable",
        titleOnError: "",
        icon: "sv_panel_icon",
        iconExpanded: "sv_expanded",
        description: "small sv_p_description",
        container: "sv_p_container",
        footer: "sv_p_footer",
        number: "sv_q_num",
        requiredText: "sv_q_required_text",
    },
    error: {
        root: "alert alert-danger",
        icon: "glyphicon glyphicon-exclamation-sign",
        item: "",
        locationTop: "sv_qstn_error_top",
        locationBottom: "sv_qstn_error_bottom",
    },
    boolean: {
        root: "sv_qbln form-inline checkbox",
        item: "sv-boolean",
        control: "sv-visuallyhidden",
        itemChecked: "sv-boolean--checked checked",
        itemIndeterminate: "sv-boolean--indeterminate",
        itemDisabled: "sv-boolean--disabled",
        switch: "sv-boolean__switch",
        slider: "sv-boolean__slider",
        label: "sv-boolean__label ",
        disabledLabel: "sv-boolean__label--disabled",
        materialDecorator: "sv-item__decorator sv-boolean__decorator",
        itemDecorator: "sv-item__svg sv-boolean__svg",
        checkedPath: "sv-boolean__checked-path",
        uncheckedPath: "sv-boolean__unchecked-path",
        indeterminatePath: "sv-boolean__indeterminate-path",
    },
    checkbox: {
        root: "sv_qcbc sv_qcbx form-inline",
        item: "checkbox",
        itemChecked: "checked",
        itemSelectAll: "sv_q_checkbox_selectall",
        itemNone: "sv_q_checkbox_none",
        itemInline: "sv_q_checkbox_inline",
        itemControl: "",
        itemDecorator: "sv-hidden",
        label: "",
        labelChecked: "",
        controlLabel: "",
        materialDecorator: "checkbox-material",
        other: "sv_q_checkbox_other form-control",
        column: "sv_q_select_column",
    },
    ranking: {
        root: "sv-ranking",
        rootMobileMod: "sv-ranking--mobile",
        rootDragMod: "sv-ranking--drag",
        item: "sv-ranking-item",
        itemContent: "sv-ranking-item__content",
        itemIndex: "sv-ranking-item__index",
        // itemText: "sv-ranking-item__text",
        controlLabel: "sv-ranking-item__text",
        itemGhostNode: "sv-ranking-item__ghost",
        itemIconContainer: "sv-ranking-item__icon-container",
        itemIcon: "sv-ranking-item__icon",
        itemIconHoverMod: "sv-ranking-item__icon--hover",
        itemIconFocusMod: "sv-ranking-item__icon--focus",
        itemGhostMod: "sv-ranking-item--ghost",
        itemDragMod: "sv-ranking-item--drag",
    },
    comment: "form-control",
    dropdown: {
        root: "",
        control: "form-control",
        other: "sv_q_dd_other form-control",
    },
    html: { root: "" },
    image: { root: "sv_q_image", image: "sv_image_image" },
    matrix: {
        root: "table sv_q_matrix",
        label: "sv_q_m_label",
        itemChecked: "checked",
        itemDecorator: "sv-hidden",
        cellText: "sv_q_m_cell_text",
        cellTextSelected: "sv_q_m_cell_selected bg-primary",
        cellLabel: "sv_q_m_cell_label",
    },
    matrixdropdown: {
        root: "table",
        cell: "sv_matrix_cell",
        headerCell: "sv_matrix_cell_header",
        row: "sv_matrix_row",
        rowAdditional: "sv-matrix__row--additional",
        detailRow: "sv_matrix_detail_row",
        detailRowText: "sv_matrix_cell_detail_rowtext",
        detailCell: "sv_matrix_cell_detail",
        detailButton: "sv_matrix_cell_detail_button",
        detailButtonExpanded: "sv_matrix_cell_detail_button_expanded",
        detailIcon: "sv_detail_panel_icon",
        detailIconExpanded: "sv_detail_expanded",
        detailPanelCell: "sv_matrix_cell_detail_panel",
        actionsCell: "sv_matrix_cell sv_matrix_cell_actions",
    },
    matrixdynamic: {
        root: "table",
        button: "button",
        buttonAdd: "",
        buttonRemove: "",
        iconAdd: "",
        iconRemove: "",
        iconDrag: "sv-matrixdynamic__drag-icon",
        headerCell: "sv_matrix_cell_header",
        row: "sv_matrix_row",
        detailRow: "sv_matrix_detail_row",
        detailCell: "sv_matrix_cell_detail",
        detailButton: "sv_matrix_cell_detail_button",
        detailButtonExpanded: "sv_matrix_cell_detail_button_expanded",
        detailIcon: "sv_detail_panel_icon",
        detailIconExpanded: "sv_detail_expanded",
        detailPanelCell: "sv_matrix_cell_detail_panel",
        actionsCell: "sv_matrix_cell sv_matrix_cell_actions",
        emptyRowsSection: "sv_matrix_empty_rows_section",
        emptyRowsText: "sv_matrix_empty_rows_text",
        emptyRowsButton: "",
        dragDropGhostPositionTop: "sv-matrix__drag-drop-ghost-position-top",
        dragDropGhostPositionBottom: "sv-matrix__drag-drop-ghost-position-bottom",
    },
    paneldynamic: {
        root: "",
        navigation: "sv-paneldynamic__navigation",
        progressTop: "sv-paneldynamic__progress sv-paneldynamic__progress--top",
        progressBottom: "sv-paneldynamic__progress sv-paneldynamic__progress--bottom",
        title: "sv-title sv-question__title",
        button: "button",
        buttonAdd: "button sv-paneldynamic__add-btn",
        buttonRemove: "sv_p_remove_btn",
        buttonRemoveRight: "button sv-paneldynamic__remove-btn--right",
        buttonPrev: "sv-paneldynamic__prev-btn",
        buttonNext: "sv-paneldynamic__next-btn",
        progressContainer: "sv-paneldynamic__progress-container",
        progress: "sv-progress",
        progressBar: "sv-progress__bar",
        progressText: "sv-paneldynamic__progress-text",
        panelWrapper: "sv_p_wrapper",
        panelWrapperInRow: "sv_p_wrapper_in_row",
        footer: "",
        progressBtnIcon: "icon-progressbutton"
    },
    multipletext: {
        root: "sv_q_mt table",
        itemTitle: "sv_q_mt_title",
        item: "sv_q_mt_item",
        itemLabel: "sv_q_mt_label",
        row: "form-group bmd-form-group",
        itemValue: "sv_q_mt_item_value form-control",
    },
    radiogroup: {
        root: "sv_qcbc form-inline",
        item: "radio",
        itemChecked: "checked",
        itemInline: "sv_q_radiogroup_inline",
        label: "",
        labelChecked: "",
        itemControl: "",
        itemDecorator: "sv-hidden",
        controlLabel: "",
        materialDecorator: "circle",
        other: "sv_q_radiogroup_other form-control",
        clearButton: "sv_q_radiogroup_clear button",
        column: "sv_q_select_column",
    },
    buttongroup: {
        root: "sv-button-group",
        item: "sv-button-group__item",
        itemIcon: "sv-button-group__item-icon",
        itemDecorator: "sv-button-group__item-decorator",
        itemCaption: "sv-button-group__item-caption",
        itemHover: "sv-button-group__item--hover",
        itemSelected: "sv-button-group__item--selected",
        itemDisabled: "sv-button-group__item--disabled",
        itemControl: "sv-visuallyhidden",
    },
    imagepicker: {
        root: "sv_imgsel",
        item: "sv_q_imgsel",
        itemChecked: "checked",
        itemInline: "sv_q_imagepicker_inline",
        label: "sv_q_imgsel_label",
        itemControl: "sv_q_imgsel_control_item",
        image: "sv_q_imgsel_image",
        itemText: "sv_q_imgsel_text",
        clearButton: "sv_q_radiogroup_clear",
    },
    rating: {
        root: "btn-group",
        item: "btn btn-default btn-secondary",
        selected: "active",
        minText: "sv_q_rating_min_text",
        itemText: "sv_q_rating_item_text",
        maxText: "sv_q_rating_max_text",
        disabled: "",
    },
    text: "form-control",
    expression: "form-control",
    file: {
        root: "sv_q_file",
        placeholderInput: "sv_q_file_placeholder",
        preview: "sv_q_file_preview",
        removeButton: "sv_q_file_remove_button",
        fileInput: "sv_q_file_input",
        removeFile: "sv_q_file_remove",
        removeFileSvg: "sv-hidden",
        fileDecorator: "sv-hidden",
        fileSignBottom: "sv-hidden",
        removeButtonBottom: "sv-hidden",
        dragAreaPlaceholder: "sv-hidden",
        fileList: "",
        defaultImage: "sv-hidden"
    },
    signaturepad: {
        root: "sv_q_signaturepad sjs_sp_container",
        controls: "sjs_sp_controls",
        placeholder: "sjs_sp_placeholder",
        clearButton: "sjs_sp_clear",
    },
    saveData: {
        root: "",
        saving: "alert alert-info",
        error: "alert alert-danger",
        success: "alert alert-success",
        saveAgainButton: "",
    },
    window: {
        root: "modal-content",
        body: "modal-body",
        header: {
            root: "modal-header panel-title",
            title: "pull-left",
            button: "glyphicon pull-right",
            buttonExpanded: "glyphicon pull-right glyphicon-chevron-up",
            buttonCollapsed: "glyphicon pull-right glyphicon-chevron-down",
        },
    },
};
_cssstandard__WEBPACK_IMPORTED_MODULE_0__["surveyCss"]["bootstrap"] = defaultBootstrapCss;


/***/ }),

/***/ "./src/defaultCss/cssbootstrapmaterial.ts":
/*!************************************************!*\
  !*** ./src/defaultCss/cssbootstrapmaterial.ts ***!
  \************************************************/
/*! exports provided: defaultBootstrapMaterialCss */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "defaultBootstrapMaterialCss", function() { return defaultBootstrapMaterialCss; });
/* harmony import */ var _cssstandard__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./cssstandard */ "./src/defaultCss/cssstandard.ts");

var defaultBootstrapMaterialCss = {
    root: "sv_main sv_bootstrapmaterial_css",
    container: "sv_container",
    header: "card-heading",
    body: "card-body",
    bodyEmpty: "card-body sv_body_empty",
    footer: "card-footer",
    title: "",
    description: "",
    logo: "sv_logo",
    logoImage: "sv_logo__image",
    headerText: "sv_header__text",
    navigationButton: "",
    completedPage: "",
    navigation: {
        complete: "btn sv_complete_btn btn-primary",
        prev: "btn sv_prev_btn btn-primary",
        next: "btn sv_next_btn btn-primary",
        start: "btn sv_start_btn btn-primary",
        preview: "btn sv_preview_btn btn-primary",
        edit: "btn sv_edit_btn btn-primary",
    },
    progress: "progress center-block mx-auto mb-4",
    progressBar: "progress-bar",
    progressTextUnderBar: "sv-hidden",
    progressButtonsContainerCenter: "sv_progress-buttons__container-center",
    progressButtonsContainer: "sv_progress-buttons__container",
    progressButtonsImageButtonLeft: "sv_progress-buttons__image-button-left",
    progressButtonsImageButtonRight: "sv_progress-buttons__image-button-right",
    progressButtonsImageButtonHidden: "sv_progress-buttons__image-button--hidden",
    progressButtonsListContainer: "sv_progress-buttons__list-container",
    progressButtonsList: "sv_progress-buttons__list",
    progressButtonsListElementPassed: "sv_progress-buttons__list-element--passed",
    progressButtonsListElementCurrent: "sv_progress-buttons__list-element--current",
    progressButtonsListElementNonClickable: "sv_progress-buttons__list-element--nonclickable",
    progressButtonsPageTitle: "sv_progress-buttons__page-title",
    progressButtonsPageDescription: "sv_progress-buttons__page-description",
    page: {
        root: "",
        title: "",
        description: "small",
    },
    pageTitle: "",
    pageDescription: "small",
    row: "sv_row",
    question: {
        mainRoot: "sv_qstn form-group bmd-form-group",
        flowRoot: "sv_q_flow form-group bmd-form-group",
        header: "",
        headerLeft: "title-left",
        content: "",
        contentLeft: "content-left",
        titleLeftRoot: "sv_qstn_left",
        requiredText: "sv_q_required_text",
        title: "",
        titleExpandable: "sv_q_title_expandable",
        number: "sv_q_num",
        description: "small",
        descriptionUnderInput: "small",
        comment: "form-control",
        required: "",
        titleRequired: "",
        hasError: "has-error",
        indent: 20,
        formGroup: "form-group bmd-form-group",
    },
    panel: {
        title: "sv_p_title",
        titleExpandable: "sv_p_title_expandable",
        titleOnError: "",
        icon: "sv_panel_icon",
        iconExpanded: "sv_expanded",
        description: "small sv_p_description",
        container: "sv_p_container",
        footer: "sv_p_footer",
        number: "sv_q_num",
        requiredText: "sv_q_required_text",
    },
    error: {
        root: "alert alert-danger",
        icon: "glyphicon glyphicon-exclamation-sign",
        item: "",
        locationTop: "sv_qstn_error_top",
        locationBottom: "sv_qstn_error_bottom",
    },
    boolean: {
        root: "sv_qbln checkbox",
        item: "sv-boolean",
        control: "sv-visuallyhidden",
        itemChecked: "sv-boolean--checked checked",
        itemIndeterminate: "sv-boolean--indeterminate",
        itemDisabled: "sv-boolean--disabled",
        switch: "sv-boolean__switch",
        slider: "sv-boolean__slider",
        label: "sv-boolean__label ",
        disabledLabel: "sv-boolean__label--disabled",
        materialDecorator: "sv-item__decorator sv-boolean__decorator",
        itemDecorator: "sv-item__svg sv-boolean__svg",
        checkedPath: "sv-boolean__checked-path",
        uncheckedPath: "sv-boolean__unchecked-path",
        indeterminatePath: "sv-boolean__indeterminate-path",
    },
    checkbox: {
        root: "sv_qcbx",
        item: "checkbox",
        itemChecked: "checked",
        itemSelectAll: "sv_q_checkbox_selectall",
        itemNone: "sv_q_checkbox_none",
        itemInline: "sv_q_checkbox_inline",
        itemDecorator: "sv-hidden",
        itemControl: "",
        label: "",
        labelChecked: "",
        controlLabel: "",
        materialDecorator: "checkbox-decorator",
        other: "sv_q_checkbox_other form-control",
        column: "sv_q_select_column",
    },
    ranking: {
        root: "sv-ranking",
        rootMobileMod: "sv-ranking--mobile",
        rootDragMod: "sv-ranking--drag",
        item: "sv-ranking-item",
        itemContent: "sv-ranking-item__content",
        itemIndex: "sv-ranking-item__index",
        // itemText: "sv-ranking-item__text",
        controlLabel: "sv-ranking-item__text",
        itemGhostNode: "sv-ranking-item__ghost",
        itemIconContainer: "sv-ranking-item__icon-container",
        itemIcon: "sv-ranking-item__icon",
        itemIconHoverMod: "sv-ranking-item__icon--hover",
        itemIconFocusMod: "sv-ranking-item__icon--focus",
        itemGhostMod: "sv-ranking-item--ghost",
        itemDragMod: "sv-ranking-item--drag",
    },
    comment: "form-control",
    dropdown: {
        root: "",
        control: "form-control",
        other: "sv_q_dd_other form-control",
    },
    html: { root: "" },
    image: { root: "sv_q_image", image: "sv_image_image" },
    matrix: {
        root: "table sv_q_matrix",
        row: "form-group bmd-form-group",
        label: "sv_q_m_label radio-inline",
        cellText: "sv_q_m_cell_text",
        cellTextSelected: "sv_q_m_cell_selected bg-primary",
        cellLabel: "sv_q_m_cell_label",
        itemValue: "form-control",
        itemChecked: "checked",
        itemDecorator: "sv-hidden",
        materialDecorator: "bmd-radio",
    },
    matrixdropdown: {
        root: "table",
        itemValue: "form-group bmd-form-group",
        headerCell: "sv_matrix_cell_header",
        row: "sv_matrix_row",
        rowAdditional: "sv-matrix__row--additional",
        detailRow: "sv_matrix_detail_row",
        detailRowText: "sv_matrix_cell_detail_rowtext",
        detailCell: "sv_matrix_cell_detail",
        detailButton: "sv_matrix_cell_detail_button",
        detailButtonExpanded: "sv_matrix_cell_detail_button_expanded",
        detailIcon: "sv_detail_panel_icon",
        detailIconExpanded: "sv_detail_expanded",
        detailPanelCell: "sv_matrix_cell_detail_panel",
        actionsCell: "sv_matrix_cell sv_matrix_cell_actions",
    },
    matrixdynamic: {
        mainRoot: "sv_qstn",
        flowRoot: "sv_q_flow",
        root: "table",
        button: "btn btn-primary",
        itemValue: "form-group bmd-form-group",
        buttonAdd: "",
        buttonRemove: "",
        iconAdd: "",
        iconRemove: "",
        iconDrag: "sv-matrixdynamic__drag-icon",
        headerCell: "sv_matrix_cell_header",
        row: "sv_matrix_row",
        detailRow: "sv_matrix_detail_row",
        detailCell: "sv_matrix_cell_detail",
        detailButton: "sv_matrix_cell_detail_button",
        detailButtonExpanded: "sv_matrix_cell_detail_button_expanded",
        detailIcon: "sv_detail_panel_icon",
        detailIconExpanded: "sv_detail_expanded",
        detailPanelCell: "sv_matrix_cell_detail_panel",
        actionsCell: "sv_matrix_cell sv_matrix_cell_actions",
        emptyRowsSection: "sv_matrix_empty_rows_section",
        emptyRowsText: "sv_matrix_empty_rows_text",
        emptyRowsButton: "",
        dragDropGhostPositionTop: "sv-matrix__drag-drop-ghost-position-top",
        dragDropGhostPositionBottom: "sv-matrix__drag-drop-ghost-position-bottom",
    },
    paneldynamic: {
        root: "",
        navigation: "sv-paneldynamic__navigation",
        progressTop: "sv-paneldynamic__progress sv-paneldynamic__progress--top",
        progressBottom: "sv-paneldynamic__progress sv-paneldynamic__progress--bottom",
        title: "sv-title sv-question__title",
        button: "button",
        buttonAdd: "button sv-paneldynamic__add-btn btn btn-primary",
        buttonRemove: "button sv-paneldynamic__remove-btn btn btn-primary",
        buttonRemoveRight: "sv-paneldynamic__remove-btn--right",
        buttonPrev: "sv-paneldynamic__prev-btn",
        buttonNext: "sv-paneldynamic__next-btn",
        progressContainer: "sv-paneldynamic__progress-container",
        progress: "sv-progress",
        progressBar: "sv-progress__bar",
        progressText: "sv-paneldynamic__progress-text",
        panelWrapper: "sv_p_wrapper",
        panelWrapperInRow: "sv_p_wrapper_in_row",
        progressBtnIcon: "icon-progressbutton",
        footer: ""
    },
    multipletext: {
        root: "sv_q_mt table",
        itemTitle: "sv_q_mt_title",
        item: "sv_q_mt_item",
        itemLabel: "sv_q_mt_label",
        row: "form-group bmd-form-group",
        itemValue: "sv_q_mt_item_value form-control",
    },
    radiogroup: {
        root: "",
        item: "radio",
        itemChecked: "checked",
        itemInline: "sv_q_radiogroup_inline",
        itemDecorator: "sv-hidden",
        label: "",
        labelChecked: "",
        itemControl: "",
        controlLabel: "sv_q_radiogroup_control_label",
        materialDecorator: "bmd-radio",
        other: "sv_q_radiogroup_other form-control",
        clearButton: "sv_q_radiogroup_clear button btn btn-primary",
        column: "sv_q_select_column",
    },
    buttongroup: {
        root: "sv-button-group",
        item: "sv-button-group__item",
        itemIcon: "sv-button-group__item-icon",
        itemDecorator: "sv-button-group__item-decorator",
        itemCaption: "sv-button-group__item-caption",
        itemSelected: "sv-button-group__item--selected",
        itemHover: "sv-button-group__item--hover",
        itemDisabled: "sv-button-group__item--disabled",
        itemControl: "sv-visuallyhidden",
    },
    imagepicker: {
        root: "sv_imgsel",
        item: "sv_q_imgsel",
        itemChecked: "checked",
        itemInline: "sv_q_imagepicker_inline",
        label: "sv_q_imgsel_label",
        itemControl: "sv_q_imgsel_control_item",
        image: "sv_q_imgsel_image",
        itemText: "sv_q_imgsel_text",
        clearButton: "sv_q_radiogroup_clear",
    },
    rating: {
        root: "btn-group",
        item: "btn btn-default btn-secondary",
        selected: "active",
        minText: "sv_q_rating_min_text",
        itemText: "sv_q_rating_item_text",
        maxText: "sv_q_rating_max_text",
        disabled: "",
    },
    text: "form-control",
    expression: "form-control",
    file: {
        root: "form-group bmd-form-group is-fileinput sv_q_file",
        placeholderInput: "",
        preview: "sv_q_file_preview",
        removeButton: "sv_q_file_remove_button",
        fileInput: "sv_q_file_input",
        removeFile: "sv_q_file_remove",
        removeFileSvg: "sv-hidden",
        fileDecorator: "sv-hidden",
        fileSignBottom: "sv-hidden",
        removeButtonBottom: "sv-hidden",
        dragAreaPlaceholder: "sv-hidden",
        fileList: "",
        defaultImage: "sv-hidden"
    },
    signaturepad: {
        root: "sv_q_signaturepad sjs_sp_container",
        controls: "sjs_sp_controls",
        placeholder: "sjs_sp_placeholder",
        clearButton: "sjs_sp_clear",
    },
    saveData: {
        root: "",
        saving: "alert alert-info",
        error: "alert alert-danger",
        success: "alert alert-success",
        saveAgainButton: "",
    },
    window: {
        root: "modal-content",
        body: "modal-body",
        header: {
            root: "modal-header card-title",
            title: "pull-left",
            button: "glyphicon pull-right",
            buttonExpanded: "glyphicon pull-right glyphicon-chevron-up",
            buttonCollapsed: "glyphicon pull-right glyphicon-chevron-down",
        },
    },
};
_cssstandard__WEBPACK_IMPORTED_MODULE_0__["surveyCss"]["bootstrapmaterial"] = defaultBootstrapMaterialCss;


/***/ }),

/***/ "./src/defaultCss/cssmodern.ts":
/*!*************************************!*\
  !*** ./src/defaultCss/cssmodern.ts ***!
  \*************************************/
/*! exports provided: modernCss */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "modernCss", function() { return modernCss; });
/* harmony import */ var _cssstandard__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./cssstandard */ "./src/defaultCss/cssstandard.ts");

var modernCss = {
    root: "sv-root-modern",
    container: "sv-container-modern",
    header: "sv-title sv-container-modern__title",
    headerClose: "sv-container-modern__close",
    body: "sv-body",
    bodyEmpty: "sv-body sv-body--empty",
    footer: "sv-footer sv-body__footer sv-clearfix",
    title: "",
    description: "",
    logo: "sv-logo",
    logoImage: "sv-logo__image",
    headerText: "sv-header__text",
    navigationButton: "",
    completedPage: "sv-completedpage",
    navigation: {
        complete: "sv-btn sv-footer__complete-btn",
        prev: "sv-btn sv-footer__prev-btn",
        next: "sv-btn sv-footer__next-btn",
        start: "sv-btn sv-footer__start-btn",
        preview: "sv-btn sv-footer__preview-btn",
        edit: "sv-btn sv-footer__edit-btn",
    },
    panel: {
        title: "sv-title sv-panel__title",
        titleExpandable: "sv-panel__title--expandable",
        titleOnError: "sv-panel__title--error",
        description: "sv-description sv-panel__description",
        container: "sv-panel sv-row__panel",
        content: "sv-panel__content",
        icon: "sv-panel__icon",
        iconExpanded: "sv-panel__icon--expanded",
        footer: "sv-panel__footer",
        requiredText: "sv-panel__required-text",
        number: "sv-question__num",
    },
    paneldynamic: {
        root: "sv-paneldynamic",
        navigation: "sv-paneldynamic__navigation",
        title: "sv-title sv-question__title",
        button: "sv-btn",
        buttonRemove: "sv-paneldynamic__remove-btn",
        buttonRemoveRight: "sv-paneldynamic__remove-btn--right",
        buttonAdd: "sv-paneldynamic__add-btn",
        progressTop: "sv-paneldynamic__progress sv-paneldynamic__progress--top",
        progressBottom: "sv-paneldynamic__progress sv-paneldynamic__progress--bottom",
        buttonPrev: "sv-paneldynamic__prev-btn",
        buttonNext: "sv-paneldynamic__next-btn",
        progressContainer: "sv-paneldynamic__progress-container",
        progress: "sv-progress",
        progressBar: "sv-progress__bar",
        progressText: "sv-paneldynamic__progress-text",
        separator: "sv-paneldynamic__separator",
        panelWrapper: "sv-paneldynamic__panel-wrapper",
        panelWrapperInRow: "sv-paneldynamic__panel-wrapper--in-row",
        progressBtnIcon: "icon-progressbutton",
        footer: ""
    },
    progress: "sv-progress sv-body__progress",
    progressBar: "sv-progress__bar",
    progressText: "sv-progress__text",
    progressTextInBar: "sv-hidden",
    progressButtonsContainerCenter: "sv_progress-buttons__container-center",
    progressButtonsContainer: "sv_progress-buttons__container",
    progressButtonsImageButtonLeft: "sv_progress-buttons__image-button-left",
    progressButtonsImageButtonRight: "sv_progress-buttons__image-button-right",
    progressButtonsImageButtonHidden: "sv_progress-buttons__image-button--hidden",
    progressButtonsListContainer: "sv_progress-buttons__list-container",
    progressButtonsList: "sv_progress-buttons__list",
    progressButtonsListElementPassed: "sv_progress-buttons__list-element--passed",
    progressButtonsListElementCurrent: "sv_progress-buttons__list-element--current",
    progressButtonsListElementNonClickable: "sv_progress-buttons__list-element--nonclickable",
    progressButtonsPageTitle: "sv_progress-buttons__page-title",
    progressButtonsPageDescription: "sv_progress-buttons__page-description",
    page: {
        root: "sv-page sv-body__page",
        title: "sv-title sv-page__title",
        description: "sv-description sv-page__description",
    },
    pageTitle: "sv-title sv-page__title",
    pageDescription: "sv-description sv-page__description",
    row: "sv-row sv-clearfix",
    question: {
        mainRoot: "sv-question sv-row__question",
        flowRoot: "sv-question sv-row__question sv-row__question--flow",
        asCell: "sv-table__cell",
        header: "sv-question__header",
        headerLeft: "sv-question__header--location--left",
        headerTop: "sv-question__header--location--top",
        headerBottom: "sv-question__header--location--bottom",
        content: "sv-question__content",
        contentLeft: "sv-question__content--left",
        titleLeftRoot: "",
        answered: "sv-question--answered",
        titleOnAnswer: "sv-question__title--answer",
        titleOnError: "sv-question__title--error",
        title: "sv-title sv-question__title",
        titleExpandable: "sv-question__title--expandable",
        icon: "sv-question__icon",
        iconExpanded: "sv-question__icon--expanded",
        requiredText: "sv-question__required-text",
        number: "sv-question__num",
        description: "sv-description sv-question__description",
        descriptionUnderInput: "sv-description sv-question__description",
        comment: "sv-comment",
        required: "sv-question--required",
        titleRequired: "sv-question__title--required",
        indent: 20,
        footer: "sv-question__footer",
        formGroup: "sv-question__form-group",
        hasError: "",
        disabled: "sv-question--disabled",
    },
    image: { root: "sv-image", image: "sv_image_image" },
    error: {
        root: "sv-question__erbox",
        icon: "",
        item: "",
        locationTop: "sv-question__erbox--location--top",
        locationBottom: "sv-question__erbox--location--bottom",
    },
    checkbox: {
        root: "sv-selectbase",
        item: "sv-item sv-checkbox sv-selectbase__item",
        itemSelectAll: "sv-checkbox--selectall",
        itemNone: "sv-checkbox--none",
        itemDisabled: "sv-item--disabled sv-checkbox--disabled",
        itemChecked: "sv-checkbox--checked",
        itemHover: "sv-checkbox--allowhover",
        itemInline: "sv-selectbase__item--inline",
        label: "sv-selectbase__label",
        labelChecked: "",
        itemControl: "sv-visuallyhidden sv-item__control",
        itemDecorator: "sv-item__svg sv-checkbox__svg",
        itemSvgIconId: "#icon-moderncheck",
        controlLabel: "sv-item__control-label",
        materialDecorator: "sv-item__decorator sv-selectbase__decorator sv-checkbox__decorator",
        other: "sv-comment sv-question__other",
        column: "sv-selectbase__column",
    },
    ranking: {
        root: "sv-ranking",
        rootMobileMod: "sv-ranking--mobile",
        rootDragMod: "sv-ranking--drag",
        item: "sv-ranking-item",
        itemContent: "sv-ranking-item__content",
        itemIndex: "sv-ranking-item__index",
        // itemText: "sv-ranking-item__text",
        controlLabel: "sv-ranking-item__text",
        itemGhostNode: "sv-ranking-item__ghost",
        itemIconContainer: "sv-ranking-item__icon-container",
        itemIcon: "sv-ranking-item__icon",
        itemIconHoverMod: "sv-ranking-item__icon--hover",
        itemIconFocusMod: "sv-ranking-item__icon--focus",
        itemGhostMod: "sv-ranking-item--ghost",
        itemDragMod: "sv-ranking-item--drag",
    },
    radiogroup: {
        root: "sv-selectbase",
        item: "sv-item sv-radio sv-selectbase__item",
        itemInline: "sv-selectbase__item--inline",
        label: "sv-selectbase__label",
        labelChecked: "",
        itemDisabled: "sv-item--disabled sv-radio--disabled",
        itemChecked: "sv-radio--checked",
        itemHover: "sv-radio--allowhover",
        itemControl: "sv-visuallyhidden sv-item__control",
        itemDecorator: "sv-item__svg sv-radio__svg",
        itemSvgIconId: "#icon-modernradio",
        controlLabel: "sv-item__control-label",
        materialDecorator: "sv-item__decorator sv-selectbase__decorator sv-radio__decorator",
        other: "sv-comment sv-question__other",
        clearButton: "sv-btn sv-selectbase__clear-btn",
        column: "sv-selectbase__column",
    },
    buttongroup: {
        root: "sv-button-group",
        item: "sv-button-group__item",
        itemIcon: "sv-button-group__item-icon",
        itemDecorator: "sv-button-group__item-decorator",
        itemCaption: "sv-button-group__item-caption",
        itemSelected: "sv-button-group__item--selected",
        itemHover: "sv-button-group__item--hover",
        itemDisabled: "sv-button-group__item--disabled",
        itemControl: "sv-visuallyhidden",
    },
    boolean: {
        root: "sv_qbln",
        small: "sv-row__question--small",
        item: "sv-boolean sv-item",
        control: "sv-visuallyhidden",
        itemChecked: "sv-boolean--checked",
        itemIndeterminate: "sv-boolean--indeterminate",
        itemDisabled: "sv-item--disabled sv-boolean--disabled",
        switch: "sv-boolean__switch",
        slider: "sv-boolean__slider",
        label: "sv-boolean__label ",
        disabledLabel: "sv-boolean__label--disabled",
        materialDecorator: "sv-item__decorator sv-boolean__decorator ",
        itemDecorator: "sv-item__svg  sv-boolean__svg",
        checkedPath: "sv-boolean__checked-path",
        uncheckedPath: "sv-boolean__unchecked-path",
        indeterminatePath: "sv-boolean__indeterminate-path",
    },
    text: {
        root: "sv-text",
        small: "sv-row__question--small",
        onError: "sv-text--error",
    },
    multipletext: {
        root: "sv-multipletext",
        item: "sv-multipletext__item",
        itemLabel: "sv-multipletext__item-label",
        itemTitle: "sv-multipletext__item-title",
        row: "sv-multipletext__row",
        cell: "sv-multipletext__cell",
    },
    dropdown: {
        root: "",
        small: "sv-row__question--small",
        control: "sv-dropdown",
        selectWrapper: "",
        other: "sv-comment sv-question__other",
        onError: "sv-dropdown--error",
    },
    imagepicker: {
        root: "sv-imagepicker",
        item: "sv-imagepicker__item",
        itemInline: "sv-imagepicker__item--inline",
        itemChecked: "sv-imagepicker__item--checked",
        itemDisabled: "sv-imagepicker__item--disabled",
        itemHover: "sv-imagepicker__item--allowhover",
        label: "sv-imagepicker__label",
        itemControl: "sv-imagepicker__control",
        image: "sv-imagepicker__image",
        itemText: "sv-imagepicker__text",
        clearButton: "sv-btn",
        other: "sv-comment sv-question__other",
    },
    matrix: {
        tableWrapper: "sv-matrix",
        root: "sv-table sv-matrix-root",
        rowError: "sv-matrix__row--error",
        cell: "sv-table__cell sv-matrix__cell",
        headerCell: "sv-table__cell sv-table__cell--header",
        label: "sv-item sv-radio sv-matrix__label",
        itemValue: "sv-visuallyhidden sv-item__control sv-radio__control",
        itemChecked: "sv-radio--checked",
        itemDisabled: "sv-item--disabled sv-radio--disabled",
        itemHover: "sv-radio--allowhover",
        materialDecorator: "sv-item__decorator sv-radio__decorator",
        itemDecorator: "sv-item__svg sv-radio__svg",
        cellText: "sv-matrix__text",
        cellTextSelected: "sv-matrix__text--checked",
        cellTextDisabled: "sv-matrix__text--disabled",
    },
    matrixdropdown: {
        root: "sv-table sv-matrixdropdown",
        cell: "sv-table__cell",
        headerCell: "sv-table__cell sv-table__cell--header",
        row: "sv-table__row",
        rowAdditional: "sv-table__row--additional",
        detailRow: "sv-table__row--detail",
        detailRowText: "sv-table__cell--detail-rowtext",
        detailCell: "sv-table__cell--detail",
        choiceCell: "sv-table__cell--choice",
        detailButton: "sv-table__cell--detail-button",
        detailButtonExpanded: "sv-table__cell--detail-button--expanded",
        detailIcon: "sv-detail-panel__icon",
        detailIconExpanded: "sv-detail-panel__icon--expanded",
        detailPanelCell: "sv-table__cell--detail-panel",
        actionsCell: "sv-table__cell sv-table__cell--actions",
    },
    matrixdynamic: {
        root: "sv-table sv-matrixdynamic",
        cell: "sv-table__cell",
        headerCell: "sv-table__cell sv-table__cell--header",
        button: "sv-btn",
        buttonAdd: "sv-matrixdynamic__add-btn",
        buttonRemove: "sv-matrixdynamic__remove-btn",
        iconAdd: "",
        iconRemove: "",
        iconDrag: "sv-matrixdynamic__drag-icon",
        row: "sv-table__row",
        detailRow: "sv-table__row--detail",
        detailCell: "sv-table__cell--detail",
        choiceCell: "sv-table__cell--choice",
        detailButton: "sv-table__cell--detail-button",
        detailButtonExpanded: "sv-table__cell--detail-button--expanded",
        detailIcon: "sv-detail-panel__icon",
        detailIconExpanded: "sv-detail-panel__icon--expanded",
        detailPanelCell: "sv-table__cell--detail-panel",
        actionsCell: "sv-table__cell sv-table__cell--actions",
        emptyRowsSection: "sv-table__empty--rows--section",
        emptyRowsText: "sv-table__empty--rows--text",
        emptyRowsButton: "",
        dragDropGhostPositionTop: "sv-matrix__drag-drop-ghost-position-top",
        dragDropGhostPositionBottom: "sv-matrix__drag-drop-ghost-position-bottom",
    },
    rating: {
        root: "sv-rating",
        item: "sv-rating__item",
        selected: "sv-rating__item--selected",
        minText: "sv-rating__min-text",
        itemText: "sv-rating__item-text",
        maxText: "sv-rating__max-text",
        itemDisabled: "sv-rating--disabled",
    },
    comment: {
        root: "sv-comment",
        small: "sv-row__question--small",
    },
    expression: "",
    file: {
        root: "sv-file",
        other: "sv-comment sv-question__other",
        placeholderInput: "sv-visuallyhidden",
        preview: "sv-file__preview",
        fileSign: "sv-hidden",
        fileSignBottom: "sv-file__sign",
        fileDecorator: "sv-file__decorator",
        fileInput: "sv-visuallyhidden",
        noFileChosen: "sv-description sv-file__no-file-chosen",
        chooseFile: "sv-btn sv-file__choose-btn",
        controlDisabled: "sv-file__choose-btn--disabled",
        removeButton: "sv-hidden",
        removeButtonBottom: "sv-btn sv-file__clean-btn",
        removeFile: "sv-hidden",
        removeFileSvg: "sv-file__remove-svg",
        wrapper: "sv-file__wrapper",
        dragAreaPlaceholder: "sv-hidden",
        fileList: "",
        defaultImage: "sv-hidden"
    },
    signaturepad: {
        root: "sv-signaturepad sjs_sp_container",
        small: "sv-row__question--small",
        controls: "sjs_sp_controls",
        placeholder: "sjs_sp_placeholder",
        clearButton: "sjs_sp_clear",
    },
    saveData: {
        root: "",
        saving: "",
        error: "",
        success: "",
        saveAgainButton: "",
    },
    window: {
        root: "sv_window",
        body: "sv_window_content",
        header: {
            root: "sv_window_title",
            title: "",
            button: "",
            buttonExpanded: "",
            buttonCollapsed: "",
        },
    },
};
_cssstandard__WEBPACK_IMPORTED_MODULE_0__["surveyCss"]["modern"] = modernCss;


/***/ }),

/***/ "./src/defaultCss/cssstandard.ts":
/*!***************************************!*\
  !*** ./src/defaultCss/cssstandard.ts ***!
  \***************************************/
/*! exports provided: surveyCss, defaultStandardCss */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "surveyCss", function() { return surveyCss; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "defaultStandardCss", function() { return defaultStandardCss; });
var surveyCss = {
    currentType: "",
    getCss: function () {
        var loc = this.currentType ? this[this.currentType] : defaultStandardCss;
        if (!loc)
            loc = defaultStandardCss;
        return loc;
    }
};
var defaultStandardCss = {
    root: "sv_main sv_default_css",
    container: "sv_container",
    header: "sv_header",
    body: "sv_body",
    bodyEmpty: "sv_body sv_body_empty",
    footer: "sv_nav",
    title: "",
    description: "",
    logo: "sv_logo",
    logoImage: "sv_logo__image",
    headerText: "sv_header__text",
    navigationButton: "",
    completedPage: "sv_completed_page",
    navigation: {
        complete: "sv_complete_btn",
        prev: "sv_prev_btn",
        next: "sv_next_btn",
        start: "sv_start_btn",
        preview: "sv_preview_btn",
        edit: "sv_edit_btn",
    },
    progress: "sv_progress",
    progressBar: "sv_progress_bar",
    progressTextInBar: "sv-hidden",
    progressButtonsContainerCenter: "sv_progress-buttons__container-center",
    progressButtonsContainer: "sv_progress-buttons__container",
    progressButtonsImageButtonLeft: "sv_progress-buttons__image-button-left",
    progressButtonsImageButtonRight: "sv_progress-buttons__image-button-right",
    progressButtonsImageButtonHidden: "sv_progress-buttons__image-button--hidden",
    progressButtonsListContainer: "sv_progress-buttons__list-container",
    progressButtonsList: "sv_progress-buttons__list",
    progressButtonsListElementPassed: "sv_progress-buttons__list-element--passed",
    progressButtonsListElementCurrent: "sv_progress-buttons__list-element--current",
    progressButtonsListElementNonClickable: "sv_progress-buttons__list-element--nonclickable",
    progressButtonsPageTitle: "sv_progress-buttons__page-title",
    progressButtonsPageDescription: "sv_progress-buttons__page-description",
    page: {
        root: "sv_p_root",
        title: "sv_page_title",
        description: "",
    },
    // TODO: move to the page object
    pageTitle: "sv_page_title",
    pageDescription: "",
    row: "sv_row",
    question: {
        mainRoot: "sv_q sv_qstn",
        flowRoot: "sv_q_flow sv_qstn",
        header: "",
        headerLeft: "title-left",
        content: "",
        contentLeft: "content-left",
        titleLeftRoot: "sv_qstn_left",
        requiredText: "sv_q_required_text",
        title: "sv_q_title",
        titleExpandable: "sv_q_title_expandable",
        number: "sv_q_num",
        description: "sv_q_description",
        comment: "",
        required: "",
        titleRequired: "",
        hasError: "",
        indent: 20,
        footer: "sv_q_footer",
        formGroup: "form-group",
        asCell: "sv_matrix_cell",
        icon: "sv_question_icon",
        iconExpanded: "sv_expanded",
        disabled: "sv_q--disabled",
    },
    panel: {
        title: "sv_p_title",
        titleExpandable: "sv_p_title_expandable",
        titleOnError: "",
        icon: "sv_panel_icon",
        iconExpanded: "sv_expanded",
        description: "sv_p_description",
        container: "sv_p_container",
        footer: "sv_p_footer",
        number: "sv_q_num",
        requiredText: "sv_q_required_text",
    },
    error: {
        root: "sv_q_erbox",
        icon: "",
        item: "",
        locationTop: "sv_qstn_error_top",
        locationBottom: "sv_qstn_error_bottom",
    },
    boolean: {
        root: "sv_qcbc sv_qbln",
        item: "sv-boolean",
        control: "sv-visuallyhidden",
        itemChecked: "sv-boolean--checked checked",
        itemIndeterminate: "sv-boolean--indeterminate",
        itemDisabled: "sv-boolean--disabled",
        switch: "sv-boolean__switch",
        slider: "sv-boolean__slider",
        label: "sv-boolean__label ",
        disabledLabel: "sv-boolean__label--disabled",
        materialDecorator: "sv-item__decorator sv-boolean__decorator",
        itemDecorator: "sv-item__svg sv-boolean__svg",
        checkedPath: "sv-boolean__checked-path",
        uncheckedPath: "sv-boolean__unchecked-path",
        indeterminatePath: "sv-boolean__indeterminate-path",
    },
    checkbox: {
        root: "sv_qcbc sv_qcbx",
        item: "sv_q_checkbox",
        itemSelectAll: "sv_q_checkbox_selectall",
        itemNone: "sv_q_checkbox_none",
        itemChecked: "checked",
        itemInline: "sv_q_checkbox_inline",
        label: "sv_q_checkbox_label",
        labelChecked: "",
        itemControl: "sv_q_checkbox_control_item",
        itemDecorator: "sv-hidden",
        controlLabel: "sv_q_checkbox_control_label",
        other: "sv_q_other sv_q_checkbox_other",
        column: "sv_q_select_column",
    },
    ranking: {
        root: "sv-ranking",
        rootMobileMod: "sv-ranking--mobile",
        rootDragMod: "sv-ranking--drag",
        item: "sv-ranking-item",
        itemContent: "sv-ranking-item__content",
        itemIndex: "sv-ranking-item__index",
        // itemText: "sv-ranking-item__text",
        controlLabel: "sv-ranking-item__text",
        itemGhostNode: "sv-ranking-item__ghost",
        itemIconContainer: "sv-ranking-item__icon-container",
        itemIcon: "sv-ranking-item__icon",
        itemIconHoverMod: "sv-ranking-item__icon--hover",
        itemIconFocusMod: "sv-ranking-item__icon--focus",
        itemGhostMod: "sv-ranking-item--ghost",
        itemDragMod: "sv-ranking-item--drag",
    },
    comment: "",
    dropdown: {
        root: "",
        control: "sv_q_dropdown_control",
        selectWrapper: "sv_select_wrapper",
        other: "sv_q_dd_other",
    },
    html: { root: "" },
    image: { root: "sv_q_image", image: "sv_image_image" },
    matrix: {
        root: "sv_q_matrix",
        label: "sv_q_m_label",
        itemChecked: "checked",
        itemDecorator: "sv-hidden",
        cell: "sv_q_m_cell",
        cellText: "sv_q_m_cell_text",
        cellTextSelected: "sv_q_m_cell_selected",
        cellLabel: "sv_q_m_cell_label",
    },
    matrixdropdown: {
        root: "sv_q_matrix_dropdown",
        cell: "sv_matrix_cell",
        headerCell: "sv_matrix_cell_header",
        row: "sv_matrix_row",
        rowAdditional: "sv-matrix__row--additional",
        detailRow: "sv_matrix_detail_row",
        detailRowText: "sv_matrix_cell_detail_rowtext",
        detailCell: "sv_matrix_cell_detail",
        choiceCell: "sv-table__cell--choice",
        detailButton: "sv_matrix_cell_detail_button",
        detailButtonExpanded: "sv_matrix_cell_detail_button_expanded",
        detailIcon: "sv_detail_panel_icon",
        detailIconExpanded: "sv_detail_expanded",
        detailPanelCell: "sv_matrix_cell_detail_panel",
        actionsCell: "sv_matrix_cell sv_matrix_cell_actions",
    },
    matrixdynamic: {
        root: "sv_q_matrix_dynamic",
        button: "sv_matrix_dynamic_button",
        buttonAdd: "",
        buttonRemove: "",
        iconAdd: "",
        iconRemove: "",
        iconDrag: "sv-matrixdynamic__drag-icon",
        cell: "sv_matrix_cell",
        headerCell: "sv_matrix_cell_header",
        row: "sv_matrix_row",
        detailRow: "sv_matrix_detail_row",
        detailCell: "sv_matrix_cell_detail",
        choiceCell: "sv-table__cell--choice",
        detailButton: "sv_matrix_cell_detail_button",
        detailButtonExpanded: "sv_matrix_cell_detail_button_expanded",
        detailIcon: "sv_detail_panel_icon",
        detailIconExpanded: "sv_detail_expanded",
        detailPanelCell: "sv_matrix_cell_detail_panel",
        actionsCell: "sv_matrix_cell sv_matrix_cell_actions",
        emptyRowsSection: "sv_matrix_empty_rows_section",
        emptyRowsText: "sv_matrix_empty_rows_text",
        emptyRowsButton: "",
        dragDropGhostPositionTop: "sv-matrix__drag-drop-ghost-position-top",
        dragDropGhostPositionBottom: "sv-matrix__drag-drop-ghost-position-bottom",
    },
    paneldynamic: {
        root: "sv_panel_dynamic",
        title: "sv_p_title",
        button: "",
        buttonAdd: "sv-paneldynamic__add-btn",
        buttonRemove: "sv_p_remove_btn",
        buttonRemoveRight: "sv_p_remove_btn_right",
        buttonPrev: "sv-paneldynamic__prev-btn",
        buttonNext: "sv-paneldynamic__next-btn",
        progressContainer: "sv-paneldynamic__progress-container",
        progress: "sv-progress",
        progressBar: "sv-progress__bar",
        progressText: "sv-paneldynamic__progress-text",
        panelWrapper: "sv_p_wrapper",
        panelWrapperInRow: "sv_p_wrapper_in_row",
        footer: "",
        progressBtnIcon: "icon-progressbutton"
    },
    multipletext: {
        root: "sv_q_mt",
        itemTitle: "sv_q_mt_title",
        item: "sv_q_mt_item",
        row: "sv_q_mt_row",
        itemLabel: "sv_q_mt_label",
        itemValue: "sv_q_mt_item_value sv_q_text_root",
    },
    radiogroup: {
        root: "sv_qcbc",
        item: "sv_q_radiogroup",
        itemChecked: "checked",
        itemInline: "sv_q_radiogroup_inline",
        itemDecorator: "sv-hidden",
        label: "sv_q_radiogroup_label",
        labelChecked: "",
        itemControl: "sv_q_radiogroup_control_item",
        controlLabel: "",
        other: "sv_q_other sv_q_radiogroup_other",
        clearButton: "sv_q_radiogroup_clear",
        column: "sv_q_select_column",
    },
    buttongroup: {
        root: "sv-button-group",
        item: "sv-button-group__item",
        itemIcon: "sv-button-group__item-icon",
        itemDecorator: "sv-button-group__item-decorator",
        itemCaption: "sv-button-group__item-caption",
        itemHover: "sv-button-group__item--hover",
        itemSelected: "sv-button-group__item--selected",
        itemDisabled: "sv-button-group__item--disabled",
        itemControl: "sv-visuallyhidden",
    },
    imagepicker: {
        root: "sv_imgsel",
        item: "sv_q_imgsel",
        itemChecked: "checked",
        label: "sv_q_imgsel_label",
        itemControl: "sv_q_imgsel_control_item",
        image: "sv_q_imgsel_image",
        itemInline: "sv_q_imagepicker_inline",
        itemText: "sv_q_imgsel_text",
        clearButton: "sv_q_radiogroup_clear",
    },
    rating: {
        root: "sv_q_rating",
        item: "sv_q_rating_item",
        selected: "active",
        minText: "sv_q_rating_min_text",
        itemText: "sv_q_rating_item_text",
        maxText: "sv_q_rating_max_text",
    },
    text: "sv_q_text_root",
    expression: "",
    file: {
        root: "sv_q_file",
        placeholderInput: "sv-visuallyhidden",
        preview: "sv_q_file_preview",
        removeButton: "sv_q_file_remove_button",
        fileInput: "sv-visuallyhidden",
        removeFile: "sv_q_file_remove",
        removeFileSvg: "sv-hidden",
        fileDecorator: "sv-file__decorator",
        fileSignBottom: "sv-hidden",
        removeButtonBottom: "sv-hidden",
        chooseFile: "sv_q_file_choose_button",
        noFileChosen: "sv_q_file_placeholder",
        dragAreaPlaceholder: "sv-hidden",
        fileList: "",
        defaultImage: "sv-hidden",
    },
    signaturepad: {
        root: "sv_q_signaturepad sjs_sp_container",
        controls: "sjs_sp_controls",
        placeholder: "sjs_sp_placeholder",
        clearButton: "sjs_sp_clear",
    },
    saveData: {
        root: "",
        saving: "",
        error: "",
        success: "",
        saveAgainButton: "",
    },
    window: {
        root: "sv_window",
        body: "sv_window_content",
        header: {
            root: "sv_window_title",
            title: "",
            button: "",
            buttonExpanded: "",
            buttonCollapsed: "",
        },
    },
};
surveyCss["standard"] = defaultStandardCss;


/***/ }),

/***/ "./src/defaultCss/defaultV2Css.ts":
/*!****************************************!*\
  !*** ./src/defaultCss/defaultV2Css.ts ***!
  \****************************************/
/*! exports provided: defaultV2Css */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "defaultV2Css", function() { return defaultV2Css; });
/* harmony import */ var _cssstandard__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./cssstandard */ "./src/defaultCss/cssstandard.ts");

var defaultV2Css = {
    root: "sd-root-modern",
    container: "sd-container-modern",
    header: "sd-title sd-container-modern__title",
    body: "sd-body",
    bodyEmpty: "sd-body sd-body--empty",
    footer: "sd-footer sd-body__navigation sd-clearfix",
    title: "sd-title",
    description: "sd-description",
    logo: "sd-logo",
    logoImage: "sd-logo__image",
    headerText: "sd-header__text",
    navigationButton: "",
    completedPage: "sd-completedpage",
    navigation: {
        complete: "sd-btn sd-btn--action sd-navigation__complete-btn",
        prev: "sd-btn sd-navigation__prev-btn",
        next: "sd-btn sd-navigation__next-btn",
        start: "sd-btn sd-navigation__start-btn",
        preview: "sd-btn sd-navigation__preview-btn",
        edit: "sd-btn sd-navigation__edit-btn"
    },
    panel: {
        title: "sd-title sd-panel__title",
        titleExpandable: "sd-panel__title--expandable",
        titleOnExpand: "sd-panel__title--expanded",
        titleOnError: "sd-panel__title--error",
        description: "sd-description sd-panel__description",
        container: "sd-element sd-panel sd-row__panel",
        withFrame: "sd-element--with-frame",
        content: "sd-panel__content",
        icon: "sd-panel__icon",
        iconExpanded: "sd-panel__icon--expanded",
        footer: "sd-panel__footer",
        requiredText: "sd-panel__required-text"
    },
    paneldynamic: {
        mainRoot: "sd-element  sd-question sd-question--paneldynamic sd-question--complex sd-row__question",
        root: "sd-paneldynamic",
        navigation: "sd-paneldynamic__navigation",
        title: "sd-title sd-question__title",
        button: "sd-action sd-paneldynamic__btn",
        buttonRemove: "sd-action--negative sd-paneldynamic__remove-btn",
        buttonAdd: "sd-paneldynamic__add-btn",
        progressTop: "sd-paneldynamic__progress sd-paneldynamic__progress--top",
        progressBottom: "sd-paneldynamic__progress sd-paneldynamic__progress--bottom",
        buttonPrev: "sd-paneldynamic__prev-btn sd-action--icon sd-action",
        buttonNext: "sd-paneldynamic__next-btn sd-action--icon sd-action",
        progressContainer: "sd-paneldynamic__progress-container",
        progress: "sd-progress",
        progressBar: "sd-progress__bar",
        progressText: "sd-paneldynamic__progress-text",
        separator: "sd-paneldynamic__separator",
        panelWrapper: "sd-paneldynamic__panel-wrapper",
        footer: "sd-paneldynamic__footer",
        footerButtonsContainer: "sd-paneldynamic__buttons-container",
        panelWrapperInRow: "sd-paneldynamic__panel-wrapper--in-row",
        progressBtnIcon: "icon-progressbuttonv2",
    },
    progress: "sd-progress sd-body__progress",
    progressBar: "sd-progress__bar",
    progressText: "sd-progress__text",
    progressTextInBar: "sd-hidden",
    page: {
        root: "sd-page sd-body__page",
        title: "sd-title sd-page__title",
        description: "sd-description sd-page__description"
    },
    pageTitle: "sd-title sd-page__title",
    pageDescription: "sd-description sd-page__description",
    row: "sd-row sd-clearfix",
    rowMultiple: "sd-row--multiple",
    question: {
        mainRoot: "sd-element sd-question sd-row__question",
        flowRoot: "sd-element sd-question sd-row__question sd-row__question--flow",
        withFrame: "sd-element--with-frame",
        asCell: "sd-table__cell",
        answered: "sd-question--answered",
        header: "sd-question__header",
        headerLeft: "sd-question__header--location--left",
        headerTop: "sd-question__header--location--top",
        headerBottom: "sd-question__header--location--bottom",
        content: "sd-question__content",
        contentLeft: "sd-question__content--left",
        titleLeftRoot: "",
        titleOnAnswer: "sd-question__title--answer",
        titleOnError: "sd-question__title--error",
        title: "sd-title sd-question__title",
        requiredText: "sd-question__required-text",
        number: "sd-question__num",
        description: "sd-description sd-question__description",
        descriptionUnderInput: "sd-description sd-question__description",
        comment: "sd-input sd-comment",
        other: "sd-input sd-comment",
        required: "sd-question--required",
        titleRequired: "sd-question__title--required",
        indent: 20,
        footer: "sd-question__footer",
        formGroup: "sd-question__form-group",
        hasError: "sd-question--error",
        disabled: "sd-question--disabled"
    },
    image: { root: "sd-image", image: "sv_image_image" },
    error: {
        root: "sd-question__erbox",
        icon: "",
        item: "",
        tooltip: "sd-question__erbox--tooltip",
        aboveQuestion: "sd-question__erbox--above-question",
        locationTop: "sd-question__erbox--location--top",
        locationBottom: "sd-question__erbox--location--bottom"
    },
    checkbox: {
        root: "sd-selectbase",
        item: "sd-item sd-checkbox sd-selectbase__item",
        itemOnError: "sd-item--error",
        itemSelectAll: "sd-checkbox--selectall",
        itemNone: "sd-checkbox--none",
        itemDisabled: "sd-item--disabled sd-checkbox--disabled",
        itemChecked: "sd-item--checked sd-checkbox--checked",
        itemHover: "sd-item--allowhover sd-checkbox--allowhover",
        itemInline: "sd-selectbase__item--inline",
        label: "sd-selectbase__label",
        labelChecked: "",
        itemControl: "sd-visuallyhidden sd-item__control sd-checkbox__control",
        itemDecorator: "sd-item__svg sd-checkbox__svg",
        itemSvgIconId: "#icon-v2check",
        controlLabel: "sd-item__control-label",
        materialDecorator: "sd-item__decorator sd-checkbox__decorator",
        other: "sd-input sd-comment sd-selectbase__other",
        column: "sd-selectbase__column"
    },
    radiogroup: {
        root: "sd-selectbase",
        item: "sd-item sd-radio sd-selectbase__item",
        itemOnError: "sd-item--error",
        itemInline: "sd-selectbase__item--inline",
        label: "sd-selectbase__label",
        labelChecked: "",
        itemDisabled: "sd-item--disabled sd-radio--disabled",
        itemChecked: "sd-item--checked sd-radio--checked",
        itemHover: "sd-item--allowhover sd-radio--allowhover",
        itemControl: "sd-visuallyhidden sd-item__control sd-radio__control",
        itemDecorator: "sd-item__svg sd-radio__svg",
        controlLabel: "sd-item__control-label",
        materialDecorator: "sd-item__decorator sd-radio__decorator",
        other: "sd-input sd-comment sd-selectbase__other",
        clearButton: "sd-btn sd-selectbase__clear-btn",
        column: "sd-selectbase__column"
    },
    boolean: {
        mainRoot: "sd-element sd-question sd-row__question sd-question--boolean",
        root: "sv_qcbc sv_qbln",
        item: "sd-boolean",
        itemOnError: "sd-boolean--error",
        control: "sd-boolean__control sd-visuallyhidden",
        itemChecked: "sd-boolean--checked",
        itemIndeterminate: "sd-boolean--indeterminate",
        itemDisabled: "sd-boolean--disabled",
        label: "sd-boolean__label",
        switch: "sd-boolean__switch",
        disabledLabel: "sd-checkbox__label--disabled",
        itemDecorator: "sd-checkbox__hidden",
        materialDecorator: "sd-checkbox__rectangle",
        sliderText: "sd-boolean__thumb-text",
        slider: "sd-boolean__thumb"
    },
    text: {
        root: "sd-input sd-text",
        small: "sd-row__question--small",
        controlDisabled: "sd-input--disabled",
        onError: "sd-input--error"
    },
    multipletext: {
        root: "sd-multipletext",
        itemLabel: "sd-multipletext__item-container sd-input",
        itemLabelOnError: "sd-multipletext__item-container--error",
        item: "sd-multipletext__item",
        itemTitle: "sd-multipletext__item-title",
        row: "sd-multipletext__row",
        cell: "sd-multipletext__cell"
    },
    dropdown: {
        root: "sd-selectbase",
        small: "sd-row__question--small",
        control: "sd-input sd-dropdown",
        selectWrapper: "",
        other: "sd-input sd-comment sd-selectbase__other",
        onError: "sd-input--error",
        label: "sd-selectbase__label",
        item: "sd-item sd-radio sd-selectbase__item",
        itemDisabled: "sd-item--disabled sd-radio--disabled",
        itemChecked: "sd-item--checked sd-radio--checked",
        itemHover: "sd-item--allowhover sd-radio--allowhover",
        itemControl: "sd-visuallyhidden sd-item__control sd-radio__control",
        itemDecorator: "sd-item__svg sd-radio__svg",
        controlDisabled: "sd-input--disabled",
        controlLabel: "sd-item__control-label",
        materialDecorator: "sd-item__decorator sd-radio__decorator"
    },
    imagepicker: {
        mainRoot: "sd-element sd-question sd-row__question",
        root: "sd-imagepicker",
        item: "sd-imagepicker__item",
        itemOnError: "sd-imagepicker__item--error",
        itemInline: "sd-imagepicker__item--inline",
        itemChecked: "sd-imagepicker__item--checked",
        itemDisabled: "sd-imagepicker__item--disabled",
        itemHover: "sd-imagepicker__item--allowhover",
        label: "sd-imagepicker__label",
        itemDecorator: "sd-imagepicker__item-decorator",
        imageContainer: "sd-imagepicker__image-container",
        itemControl: "sd-imagepicker__control",
        image: "sd-imagepicker__image",
        itemText: "sd-imagepicker__text",
        clearButton: "sd-btn",
        other: "sd-input sd-comment"
    },
    matrix: {
        mainRoot: "sd-element sd-question sd-row__question sd-question--complex sd-question--table",
        tableWrapper: "sd-matrix",
        root: "sd-table",
        rowError: "sd-matrix__row--error",
        cell: "sd-table__cell sd-matrix__cell",
        headerCell: "sd-table__cell sd-table__cell--header",
        label: "sd-item sd-radio sd-matrix__label",
        itemOnError: "sd-item--error",
        itemValue: "sd-visuallyhidden sd-item__control sd-radio__control",
        itemChecked: "sd-item--checked sd-radio--checked",
        itemDisabled: "sd-item--disabled sd-radio--disabled",
        itemHover: "sd-radio--allowhover",
        materialDecorator: "sd-item__decorator sd-radio__decorator",
        itemDecorator: "sd-item__svg sd-radio__svg",
        cellText: "sd-matrix__text",
        cellTextSelected: "sd-matrix__text--checked",
        cellTextDisabled: "sd-matrix__text--disabled"
    },
    matrixdropdown: {
        mainRoot: "sd-element sd-question sd-row__question sd-question--complex sd-question--table",
        root: "sd-table",
        cell: "sd-table__cell",
        headerCell: "sd-table__cell sd-table__cell--header",
        rowTextCell: "sd-table__cell sd-table__cell--row-text"
    },
    matrixdynamic: {
        mainRoot: "sd-element sd-question sd-row__question sd-question--complex sd-question--table",
        root: "sd-table sd-matrixdynamic",
        cell: "sd-table__cell",
        headerCell: "sd-table__cell sd-table__cell--header",
        rowTextCell: "sd-table__cell sd-table__cell--row-text",
        button: "sd-action sd-matrixdynamic__btn",
        detailRow: "sd-table__row sd-table__row--detail",
        detailButton: "sd-table__cell--detail-button",
        detailButtonExpanded: "sd-table__cell--detail-button--expanded",
        detailIcon: "sd-detail-panel__icon",
        detailIconExpanded: "sd-detail-panel__icon--expanded",
        detailPanelCell: "sd-table__cell--detail-panel",
        actionsCell: "sd-table__cell sd-table__cell--actions",
        buttonAdd: "sd-matrixdynamic__add-btn",
        buttonRemove: "sd-action--icon sd-action--negative sd-matrixdynamic__remove-btn",
        iconAdd: "",
        iconRemove: "",
        footer: "sd-matrixdynamic__footer"
    },
    rating: {
        root: "sd-rating",
        item: "sd-rating__item",
        itemOnError: "sd-rating__item--error",
        itemHover: "sd-rating__item--allowhover",
        selected: "sd-rating__item--selected",
        minText: "sd-rating__item-text sd-rating__min-text",
        itemText: "sd-rating__item-text",
        maxText: "sd-rating__item-text sd-rating__max-text",
        itemDisabled: "sd-rating__item--disabled"
    },
    comment: {
        root: "sd-input sd-comment",
        small: "sd-row__question--small",
        controlDisabled: "sd-input--disabled",
        onError: "sd-input--error"
    },
    expression: "",
    file: {
        root: "sd-file",
        other: "sd-input sd-comment",
        placeholderInput: "sd-visuallyhidden",
        preview: "sd-file__preview",
        fileSign: "sd-hidden",
        fileList: "sd-file__list",
        fileSignBottom: "sd-file__sign",
        fileDecorator: "sd-file__decorator",
        onError: "sd-file__decorator--error",
        fileDecoratorDrag: "sd-file__decorator--drag",
        fileInput: "sd-visuallyhidden",
        noFileChosen: "sd-description sd-file__no-file-chosen",
        chooseFile: "sd-file__btn sd-file__choose-btn sd-action",
        disabled: "sd-file__choose-btn--disabled",
        removeButton: "sd-hidden",
        removeButtonBottom: "sd-file__btn sd-file__clean-btn",
        removeFile: "sd-hidden",
        removeFileSvg: "sd-hidden",
        wrapper: "sd-file__wrapper",
        defaultImage: "sd-file__default-image",
        removeFileButton: "sd-file__remove-file-button",
        dragAreaPlaceholder: "sd-file__drag-area-placeholder",
    },
    signaturepad: {
        root: "sd-signaturepad sjs_sp_container",
        small: "sd-row__question--small",
        controls: "sjs_sp_controls",
        placeholder: "sjs_sp_placeholder",
        clearButton: "sjs_sp_clear"
    },
    saveData: {
        root: "",
        saving: "",
        error: "",
        success: "",
        saveAgainButton: ""
    },
    window: {
        root: "sv_window",
        body: "sv_window_content",
        header: {
            root: "sv_window_title",
            title: "",
            button: "",
            buttonExpanded: "",
            buttonCollapsed: ""
        }
    },
    ranking: {
        root: "sv-ranking",
        rootMobileMod: "sv-ranking--mobile",
        rootDragMod: "sv-ranking--drag",
        item: "sv-ranking-item",
        itemContent: "sv-ranking-item__content",
        itemIndex: "sv-ranking-item__index",
        // itemText: "sv-ranking-item__text",
        controlLabel: "sv-ranking-item__text",
        itemGhostNode: "sv-ranking-item__ghost",
        itemIconContainer: "sv-ranking-item__icon-container",
        itemIcon: "sv-ranking-item__icon",
        itemIconHoverMod: "sv-ranking-item__icon--hover",
        itemIconFocusMod: "sv-ranking-item__icon--focus",
        itemGhostMod: "sv-ranking-item--ghost",
        itemDragMod: "sv-ranking-item--drag",
    },
};
_cssstandard__WEBPACK_IMPORTED_MODULE_0__["surveyCss"]["defaultV2"] = defaultV2Css;


/***/ }),

/***/ "./src/defaultTitle.ts":
/*!*****************************!*\
  !*** ./src/defaultTitle.ts ***!
  \*****************************/
/*! exports provided: DefaultTitleModel */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "DefaultTitleModel", function() { return DefaultTitleModel; });
/* harmony import */ var _utils_cssClassBuilder__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./utils/cssClassBuilder */ "./src/utils/cssClassBuilder.ts");

var DefaultTitleModel = /** @class */ (function () {
    function DefaultTitleModel() {
    }
    DefaultTitleModel.getIconCss = function (cssClasses, isCollapsed) {
        return new _utils_cssClassBuilder__WEBPACK_IMPORTED_MODULE_0__["CssClassBuilder"]()
            .append(cssClasses.icon)
            .append(cssClasses.iconExpanded, !isCollapsed)
            .toString();
    };
    return DefaultTitleModel;
}());



/***/ }),

/***/ "./src/dragdrop/choices.ts":
/*!*********************************!*\
  !*** ./src/dragdrop/choices.ts ***!
  \*********************************/
/*! exports provided: DragDropChoices */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "DragDropChoices", function() { return DragDropChoices; });
/* harmony import */ var _core__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./core */ "./src/dragdrop/core.ts");
var __extends = (undefined && undefined.__extends) || (function () {
    var extendStatics = function (d, b) {
        extendStatics = Object.setPrototypeOf ||
            ({ __proto__: [] } instanceof Array && function (d, b) { d.__proto__ = b; }) ||
            function (d, b) { for (var p in b) if (Object.prototype.hasOwnProperty.call(b, p)) d[p] = b[p]; };
        return extendStatics(d, b);
    };
    return function (d, b) {
        if (typeof b !== "function" && b !== null)
            throw new TypeError("Class extends value " + String(b) + " is not a constructor or null");
        extendStatics(d, b);
        function __() { this.constructor = d; }
        d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
    };
})();

var DragDropChoices = /** @class */ (function (_super) {
    __extends(DragDropChoices, _super);
    function DragDropChoices() {
        return _super !== null && _super.apply(this, arguments) || this;
    }
    Object.defineProperty(DragDropChoices.prototype, "draggedElementType", {
        get: function () {
            return "item-value";
        },
        enumerable: false,
        configurable: true
    });
    DragDropChoices.prototype.createDraggedElementShortcut = function (text, draggedElementNode, event) {
        if (this.parentElement.getType() === "imagepicker") {
            return _super.prototype.createDraggedElementShortcut.call(this, text, draggedElementNode);
        }
        var draggedElementShortcut = document.createElement("div");
        // draggedElementShortcut.innerText = text;
        draggedElementShortcut.style.cssText = " \n          cursor: grabbing;\n          position: absolute;\n          z-index: 1000;\n          border-radius: 36px;\n          min-width: 100px;\n          box-shadow: 0px 8px 16px rgba(0, 0, 0, 0.1);\n          background-color: white;\n          padding-right: 16px;\n          font-family: \"Open Sans\";\n        ";
        var isDeepClone = true;
        var clone = (draggedElementNode
            .closest("[data-sv-drop-target-item-value]")
            .cloneNode(isDeepClone));
        var controlsNode = clone.querySelector(".svc-item-value-controls");
        controlsNode.style.display = "block";
        clone.classList.remove("svc-item-value--moveup");
        clone.classList.remove("svc-item-value--movedown");
        this.draggedElement.isDragDropMoveDown = false;
        this.draggedElement.isDragDropMoveUp = false;
        draggedElementShortcut.appendChild(clone);
        var rect = draggedElementNode.getBoundingClientRect();
        draggedElementShortcut.shortcutXOffset = event.clientX - rect.x;
        draggedElementShortcut.shortcutYOffset = event.clientY - rect.y;
        this.isBottom = null;
        return draggedElementShortcut;
    };
    DragDropChoices.prototype.findDropTargetNodeByDragOverNode = function (dragOverNode) {
        var result = dragOverNode.closest(this.dropTargetDataAttributeName);
        return result;
    };
    DragDropChoices.prototype.getDropTargetByDataAttributeValue = function (dataAttributeValue) {
        var dragOverChoice;
        dragOverChoice = this.parentElement.choices.filter(function (choice) { return "" + choice.value == dataAttributeValue; })[0];
        return dragOverChoice;
    };
    DragDropChoices.prototype.getVisibleChoices = function () {
        var parent = this.parentElement;
        if (parent.getType() === "ranking")
            return parent.rankingChoices;
        return parent.visibleChoices;
    };
    DragDropChoices.prototype.isDropTargetValid = function (dropTarget) {
        var choices = this.getVisibleChoices();
        if (this.parentElement.getType() !== "imagepicker") {
            var dropTargetIndex = choices.indexOf(this.dropTarget);
            var draggedElementIndex = choices.indexOf(this.draggedElement);
            if (draggedElementIndex > dropTargetIndex && this.dropTarget.isDragDropMoveUp) {
                this.dropTarget.isDragDropMoveUp = false;
                return false;
            }
            if (draggedElementIndex < dropTargetIndex && this.dropTarget.isDragDropMoveDown) {
                this.dropTarget.isDragDropMoveDown = false;
                return false;
            }
        }
        // shouldn't allow to drop on "adorners" (selectall, none, other)
        if (choices.indexOf(dropTarget) === -1)
            return false;
        return true;
    };
    DragDropChoices.prototype.calculateIsBottom = function (clientY) {
        var choices = this.getVisibleChoices();
        return (choices.indexOf(this.dropTarget) - choices.indexOf(this.draggedElement) >
            0);
    };
    DragDropChoices.prototype.afterDragOver = function (dropTargetNode) {
        if (this.isDropTargetDoesntChanged(this.isBottom))
            return;
        if (this.dropTarget === this.draggedElement)
            return;
        var choices = this.getVisibleChoices();
        var dropTargetIndex = choices.indexOf(this.dropTarget);
        var draggedElementIndex = choices.indexOf(this.draggedElement);
        choices.splice(draggedElementIndex, 1);
        choices.splice(dropTargetIndex, 0, this.draggedElement);
        if (this.parentElement.getType() === "imagepicker")
            return;
        if (draggedElementIndex !== dropTargetIndex) {
            dropTargetNode.classList.remove("svc-item-value--moveup");
            dropTargetNode.classList.remove("svc-item-value--movedown");
            this.dropTarget.isDragDropMoveDown = false;
            this.dropTarget.isDragDropMoveUp = false;
        }
        if (draggedElementIndex > dropTargetIndex) {
            this.dropTarget.isDragDropMoveDown = true;
        }
        if (draggedElementIndex < dropTargetIndex) {
            this.dropTarget.isDragDropMoveUp = true;
        }
        _super.prototype.ghostPositionChanged.call(this);
    };
    DragDropChoices.prototype.doDrop = function () {
        var choices = this.parentElement.choices;
        var filteredChoices = this.getVisibleChoices().filter(function (item) {
            return choices.indexOf(item) !== -1;
        });
        var oldIndex = choices.indexOf(this.draggedElement);
        var newIndex = filteredChoices.indexOf(this.draggedElement);
        choices.splice(oldIndex, 1);
        choices.splice(newIndex, 0, this.draggedElement);
        return this.parentElement;
    };
    DragDropChoices.prototype.doClear = function () {
        this.updateVisibleChoices();
    };
    DragDropChoices.prototype.updateVisibleChoices = function () {
        var parent = this.parentElement;
        this.parentElement.getType() === "ranking" ?
            parent.updateRankingChoices() :
            parent["updateVisibleChoices"]();
    };
    return DragDropChoices;
}(_core__WEBPACK_IMPORTED_MODULE_0__["DragDropCore"]));



/***/ }),

/***/ "./src/dragdrop/core.ts":
/*!******************************!*\
  !*** ./src/dragdrop/core.ts ***!
  \******************************/
/*! exports provided: DragDropCore */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "DragDropCore", function() { return DragDropCore; });
/* harmony import */ var _base__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ../base */ "./src/base.ts");
/* harmony import */ var _jsonobject__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ../jsonobject */ "./src/jsonobject.ts");
/* harmony import */ var _utils_utils__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ../utils/utils */ "./src/utils/utils.ts");
var __extends = (undefined && undefined.__extends) || (function () {
    var extendStatics = function (d, b) {
        extendStatics = Object.setPrototypeOf ||
            ({ __proto__: [] } instanceof Array && function (d, b) { d.__proto__ = b; }) ||
            function (d, b) { for (var p in b) if (Object.prototype.hasOwnProperty.call(b, p)) d[p] = b[p]; };
        return extendStatics(d, b);
    };
    return function (d, b) {
        if (typeof b !== "function" && b !== null)
            throw new TypeError("Class extends value " + String(b) + " is not a constructor or null");
        extendStatics(d, b);
        function __() { this.constructor = d; }
        d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
    };
})();
var __decorate = (undefined && undefined.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};



var DragDropCore = /** @class */ (function (_super) {
    __extends(DragDropCore, _super);
    function DragDropCore(surveyValue, creator) {
        var _this = _super.call(this) || this;
        _this.surveyValue = surveyValue;
        _this.creator = creator;
        _this.onGhostPositionChanged = new _base__WEBPACK_IMPORTED_MODULE_0__["EventBase"]();
        _this.onBeforeDrop = new _base__WEBPACK_IMPORTED_MODULE_0__["EventBase"]();
        _this.onAfterDrop = new _base__WEBPACK_IMPORTED_MODULE_0__["EventBase"]();
        _this.draggedElement = null;
        _this.dropTarget = null;
        _this.prevDropTarget = null;
        _this.draggedElementShortcut = null;
        _this.scrollIntervalId = null;
        _this.allowDropHere = false;
        _this.dragOver = function (event) {
            _this.moveShortcutElement(event);
            _this.draggedElementShortcut.style.cursor = "grabbing";
            var dropTargetNode = _this.findDropTargetNodeFromPoint(event.clientX, event.clientY);
            if (!dropTargetNode) {
                _this.banDropHere();
                return;
            }
            _this.dropTarget = _this.getDropTargetByNode(dropTargetNode, event);
            var isDropTargetValid = _this.isDropTargetValid(_this.dropTarget, dropTargetNode);
            _this.doDragOver(dropTargetNode);
            if (!isDropTargetValid) {
                _this.banDropHere();
                return;
            }
            var isBottom = _this.calculateIsBottom(event.clientY, dropTargetNode);
            _this.allowDropHere = true;
            if (_this.isDropTargetDoesntChanged(isBottom))
                return;
            _this.isBottom = null; //TODO need for property change trigger with guarantee but it would be better not to watch on isBottom property but have some event like onValidTargetDragOver
            _this.isBottom = isBottom;
            _this.afterDragOver(dropTargetNode);
            _this.prevDropTarget = _this.dropTarget;
        };
        _this.drop = function () {
            if (_this.allowDropHere) {
                _this.onBeforeDrop.fire(_this, null);
                var newElement = _this.doDrop();
                _this.onAfterDrop.fire(_this, { draggedElement: newElement });
            }
            _this.clear();
        };
        _this.handlePointerCancel = function (event) {
            _this.clear();
        };
        _this.handleEscapeButton = function (event) {
            if (event.keyCode == 27) {
                _this.clear();
            }
        };
        _this.banDropHere = function () {
            _this.allowDropHere = false;
            _this.doBanDropHere();
            _this.dropTarget = null;
            _this.draggedElementShortcut.style.cursor = "not-allowed";
            _this.isBottom = null;
        };
        _this.doBanDropHere = function () { };
        _this.clear = function () {
            cancelAnimationFrame(_this.scrollIntervalId);
            document.removeEventListener("pointermove", _this.dragOver);
            document.removeEventListener("pointercancel", _this.handlePointerCancel);
            document.removeEventListener("keydown", _this.handleEscapeButton);
            document.removeEventListener("pointerup", _this.drop);
            _this.draggedElementShortcut.removeEventListener("pointerup", _this.drop);
            document.body.removeChild(_this.draggedElementShortcut);
            _this.doClear();
            _this.dropTarget = null;
            _this.draggedElementShortcut = null;
            _this.draggedElement = null;
            _this.isBottom = null;
            _this.parentElement = null;
            _this.scrollIntervalId = null;
        };
        return _this;
    }
    DragDropCore.prototype.ghostPositionChanged = function () {
        this.onGhostPositionChanged.fire({}, {});
    };
    Object.defineProperty(DragDropCore.prototype, "dropTargetDataAttributeName", {
        get: function () {
            return "[data-sv-drop-target-".concat(this.draggedElementType, "]");
        },
        enumerable: false,
        configurable: true
    });
    Object.defineProperty(DragDropCore.prototype, "survey", {
        get: function () {
            return this.surveyValue || this.creator.survey;
        },
        enumerable: false,
        configurable: true
    });
    DragDropCore.prototype.startDrag = function (event, draggedElement, parentElement, draggedElementNode) {
        if (event.which === 3)
            return; //right mouse btn
        this.draggedElement = draggedElement;
        this.parentElement = parentElement;
        this.doStartDrag();
        var shortcutText = this.getShortcutText(this.draggedElement);
        this.draggedElementShortcut = this.createDraggedElementShortcut(shortcutText, draggedElementNode, event);
        document.body.append(this.draggedElementShortcut);
        this.moveShortcutElement(event);
        document.addEventListener("pointermove", this.dragOver);
        document.addEventListener("pointercancel", this.handlePointerCancel);
        document.addEventListener("keydown", this.handleEscapeButton);
        document.addEventListener("pointerup", this.drop);
        this.draggedElementShortcut.addEventListener("pointerup", this.drop);
    };
    DragDropCore.prototype.isDropTargetDoesntChanged = function (newIsBottom) {
        return (this.dropTarget === this.prevDropTarget && newIsBottom === this.isBottom);
    };
    DragDropCore.prototype.doStartDrag = function () { };
    DragDropCore.prototype.getShortcutText = function (draggedElement) {
        return draggedElement.shortcutText;
    };
    DragDropCore.prototype.createDraggedElementShortcut = function (text, draggedElementNode, event) {
        var draggedElementShortcut = document.createElement("div");
        draggedElementShortcut.innerText = text;
        draggedElementShortcut.className = this.getDraggedElementClass();
        return draggedElementShortcut;
    };
    DragDropCore.prototype.getDraggedElementClass = function () {
        return "sv-dragged-element-shortcut";
    };
    DragDropCore.prototype.doDragOver = function (dropTargetNode) { };
    DragDropCore.prototype.afterDragOver = function (dropTargetNode) { };
    DragDropCore.prototype.getGhostPosition = function (item) {
        if (this.dropTarget !== item)
            return null;
        if (this.isBottom)
            return "bottom";
        return "top";
    };
    DragDropCore.prototype.moveShortcutElement = function (event) {
        this.doScroll(event.clientY, event.clientX);
        var shortcutHeight = this.draggedElementShortcut.offsetHeight;
        var shortcutWidth = this.draggedElementShortcut.offsetWidth;
        var shortcutXOffset;
        var shortcutYOffset;
        if (!!this.draggedElementShortcut.shortcutXOffset) {
            shortcutXOffset = this.draggedElementShortcut.shortcutXOffset;
            shortcutYOffset = this.draggedElementShortcut.shortcutYOffset;
        }
        else {
            shortcutXOffset = shortcutWidth / 2;
            shortcutYOffset = shortcutHeight / 2;
        }
        var documentClientHeight = document.documentElement.clientHeight;
        var documentClientWidth = document.documentElement.clientWidth;
        if (event.clientX + shortcutXOffset >= documentClientWidth) {
            this.draggedElementShortcut.style.left =
                event.pageX -
                    event.clientX +
                    documentClientWidth -
                    shortcutWidth +
                    "px";
            this.draggedElementShortcut.style.top =
                event.pageY - shortcutYOffset + "px";
            return;
        }
        if (event.clientX - shortcutXOffset <= 0) {
            this.draggedElementShortcut.style.left =
                event.pageX - event.clientX + "px";
            this.draggedElementShortcut.style.top =
                event.pageY - shortcutYOffset + "px";
            return;
        }
        if (event.clientY + shortcutYOffset >= documentClientHeight) {
            this.draggedElementShortcut.style.left =
                event.pageX - shortcutXOffset + "px";
            this.draggedElementShortcut.style.top =
                event.pageY -
                    event.clientY +
                    documentClientHeight -
                    shortcutHeight +
                    "px";
            return;
        }
        if (event.clientY - shortcutYOffset <= 0) {
            this.draggedElementShortcut.style.left =
                event.pageX - shortcutXOffset + "px";
            this.draggedElementShortcut.style.top =
                event.pageY - event.clientY + "px";
            return;
        }
        this.draggedElementShortcut.style.left =
            event.pageX - shortcutXOffset + "px";
        this.draggedElementShortcut.style.top =
            event.pageY - shortcutYOffset + "px";
    };
    DragDropCore.prototype.doScroll = function (clientY, clientX) {
        var _this = this;
        cancelAnimationFrame(this.scrollIntervalId);
        var startScrollBoundary = 50;
        this.draggedElementShortcut.hidden = true;
        var dragOverNode = document.elementFromPoint(clientX, clientY);
        this.draggedElementShortcut.hidden = false;
        var scrollableParentNode = Object(_utils_utils__WEBPACK_IMPORTED_MODULE_2__["findScrollableParent"])(dragOverNode);
        var top = scrollableParentNode.getBoundingClientRect().top;
        var bottom = scrollableParentNode.getBoundingClientRect().bottom;
        var left = scrollableParentNode.getBoundingClientRect().left;
        var right = scrollableParentNode.getBoundingClientRect().right;
        var repeat = function () {
            if (clientY - top <= startScrollBoundary) {
                scrollableParentNode.scrollTop -= 15;
            }
            else if (bottom - clientY <= startScrollBoundary) {
                scrollableParentNode.scrollTop += 15;
            }
            else if (right - clientX <= startScrollBoundary) {
                scrollableParentNode.scrollLeft += 15;
            }
            else if (clientX - left <= startScrollBoundary) {
                scrollableParentNode.scrollLeft -= 15;
            }
            _this.scrollIntervalId = requestAnimationFrame(repeat);
        };
        this.scrollIntervalId = requestAnimationFrame(repeat);
    };
    DragDropCore.prototype.getDataAttributeValueByNode = function (node) {
        var _this = this;
        var datasetName = "svDropTarget";
        var words = this.draggedElementType.split("-");
        words.forEach(function (word) {
            datasetName += _this.capitalizeFirstLetter(word);
        });
        return node.dataset[datasetName];
    };
    DragDropCore.prototype.getDropTargetByNode = function (dropTargetNode, event) {
        var dataAttributeValue = this.getDataAttributeValueByNode(dropTargetNode);
        return this.getDropTargetByDataAttributeValue(dataAttributeValue, dropTargetNode, event);
    };
    DragDropCore.prototype.capitalizeFirstLetter = function (string) {
        return string.charAt(0).toUpperCase() + string.slice(1);
    };
    DragDropCore.prototype.calculateMiddleOfHTMLElement = function (HTMLElement) {
        var rect = HTMLElement.getBoundingClientRect();
        return rect.y + rect.height / 2;
    };
    DragDropCore.prototype.findDropTargetNodeFromPoint = function (clientX, clientY) {
        this.draggedElementShortcut.hidden = true;
        var dragOverNode = document.elementFromPoint(clientX, clientY);
        this.draggedElementShortcut.hidden = false;
        if (!dragOverNode)
            return null;
        return this.findDropTargetNodeByDragOverNode(dragOverNode);
    };
    DragDropCore.prototype.findDropTargetNodeByDragOverNode = function (dragOverNode) {
        var result = dragOverNode.querySelector(this.dropTargetDataAttributeName) ||
            dragOverNode.closest(this.dropTargetDataAttributeName);
        return result;
    };
    DragDropCore.prototype.doClear = function () { };
    __decorate([
        Object(_jsonobject__WEBPACK_IMPORTED_MODULE_1__["property"])({
            defaultValue: null,
            onSet: function (val, target) {
                target.ghostPositionChanged();
            },
        })
    ], DragDropCore.prototype, "isBottom", void 0);
    return DragDropCore;
}(_base__WEBPACK_IMPORTED_MODULE_0__["Base"]));



/***/ }),

/***/ "./src/dragdrop/matrix-rows.ts":
/*!*************************************!*\
  !*** ./src/dragdrop/matrix-rows.ts ***!
  \*************************************/
/*! exports provided: DragDropMatrixRows */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "DragDropMatrixRows", function() { return DragDropMatrixRows; });
/* harmony import */ var _core__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./core */ "./src/dragdrop/core.ts");
var __extends = (undefined && undefined.__extends) || (function () {
    var extendStatics = function (d, b) {
        extendStatics = Object.setPrototypeOf ||
            ({ __proto__: [] } instanceof Array && function (d, b) { d.__proto__ = b; }) ||
            function (d, b) { for (var p in b) if (Object.prototype.hasOwnProperty.call(b, p)) d[p] = b[p]; };
        return extendStatics(d, b);
    };
    return function (d, b) {
        if (typeof b !== "function" && b !== null)
            throw new TypeError("Class extends value " + String(b) + " is not a constructor or null");
        extendStatics(d, b);
        function __() { this.constructor = d; }
        d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
    };
})();

var DragDropMatrixRows = /** @class */ (function (_super) {
    __extends(DragDropMatrixRows, _super);
    function DragDropMatrixRows() {
        var _this = _super !== null && _super.apply(this, arguments) || this;
        _this.doDrop = function () {
            var matrix = _this.parentElement;
            var fromIndex = matrix.visibleRows.indexOf(_this.draggedElement);
            var toIndex = matrix.visibleRows.indexOf(_this.dropTarget);
            matrix.moveRowByIndex(fromIndex, toIndex);
            return matrix;
        };
        return _this;
    }
    Object.defineProperty(DragDropMatrixRows.prototype, "draggedElementType", {
        get: function () {
            return "matrix-row";
        },
        enumerable: false,
        configurable: true
    });
    DragDropMatrixRows.prototype.ghostPositionChanged = function () {
        var _this = this;
        this.parentElement.renderedTable.rows.forEach(function (renderedRow) {
            renderedRow.ghostPosition = _this.getGhostPosition(renderedRow.row);
        });
        _super.prototype.ghostPositionChanged.call(this);
    };
    DragDropMatrixRows.prototype.getDropTargetByDataAttributeValue = function (dataAttributeValue) {
        var matrix = this.parentElement;
        var dropTargetRow;
        dropTargetRow = matrix.visibleRows.filter(function (row) { return row.id === dataAttributeValue; })[0];
        return dropTargetRow;
    };
    DragDropMatrixRows.prototype.isDropTargetValid = function (dropTarget) {
        if (this.dropTarget === this.draggedElement)
            return false;
        var rows = this.parentElement.visibleRows;
        return rows.indexOf(dropTarget) !== -1;
    };
    DragDropMatrixRows.prototype.findDropTargetNodeByDragOverNode = function (dragOverNode) {
        var result = dragOverNode.closest(this.dropTargetDataAttributeName);
        return result;
    };
    DragDropMatrixRows.prototype.calculateIsBottom = function (clientY) {
        var rows = this.parentElement.visibleRows;
        return (rows.indexOf(this.dropTarget) - rows.indexOf(this.draggedElement) > 0);
    };
    return DragDropMatrixRows;
}(_core__WEBPACK_IMPORTED_MODULE_0__["DragDropCore"]));



/***/ }),

/***/ "./src/dragdrop/ranking-choices.ts":
/*!*****************************************!*\
  !*** ./src/dragdrop/ranking-choices.ts ***!
  \*****************************************/
/*! exports provided: DragDropRankingChoices */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "DragDropRankingChoices", function() { return DragDropRankingChoices; });
/* harmony import */ var _choices__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./choices */ "./src/dragdrop/choices.ts");
/* harmony import */ var _utils_cssClassBuilder__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ../utils/cssClassBuilder */ "./src/utils/cssClassBuilder.ts");
/* harmony import */ var _utils_is_mobile__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ../utils/is-mobile */ "./src/utils/is-mobile.ts");
var __extends = (undefined && undefined.__extends) || (function () {
    var extendStatics = function (d, b) {
        extendStatics = Object.setPrototypeOf ||
            ({ __proto__: [] } instanceof Array && function (d, b) { d.__proto__ = b; }) ||
            function (d, b) { for (var p in b) if (Object.prototype.hasOwnProperty.call(b, p)) d[p] = b[p]; };
        return extendStatics(d, b);
    };
    return function (d, b) {
        if (typeof b !== "function" && b !== null)
            throw new TypeError("Class extends value " + String(b) + " is not a constructor or null");
        extendStatics(d, b);
        function __() { this.constructor = d; }
        d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
    };
})();



var DragDropRankingChoices = /** @class */ (function (_super) {
    __extends(DragDropRankingChoices, _super);
    function DragDropRankingChoices() {
        var _this = _super !== null && _super.apply(this, arguments) || this;
        _this.isDragOverRootNode = false;
        _this.doDragOver = function () {
            var node = _this.draggedElementShortcut.querySelector(".sv-ranking-item");
            node.style.cursor = "grabbing";
        };
        _this.doBanDropHere = function () {
            if (_this.isDragOverRootNode) {
                _this.allowDropHere = true;
                return;
            }
            var node = _this.draggedElementShortcut.querySelector(".sv-ranking-item");
            node.style.cursor = "not-allowed";
        };
        _this.doDrop = function () {
            _this.parentElement.setValue();
            return _this.parentElement;
        };
        _this.doClear = function () {
            _this.parentElement.dropTargetNodeMove = null;
            _this.parentElement.updateRankingChoices();
        };
        return _this;
    }
    Object.defineProperty(DragDropRankingChoices.prototype, "draggedElementType", {
        get: function () {
            return "ranking-item";
        },
        enumerable: false,
        configurable: true
    });
    DragDropRankingChoices.prototype.createDraggedElementShortcut = function (text, draggedElementNode) {
        var draggedElementShortcut = document.createElement("div");
        draggedElementShortcut.className = this.shortcutClass;
        draggedElementShortcut.style.cssText = " \n          cursor: grabbing;\n          position: absolute;\n          z-index: 1000;\n          border-radius: 36px;\n          min-width: 100px;\n          box-shadow: 0px 8px 16px rgba(0, 0, 0, 0.1);\n          background-color: white;\n          padding-right: 16px;\n          padding-left: 20px;\n          font-family: \"Open Sans\";\n        ";
        var isDeepClone = true;
        var clone = draggedElementNode.cloneNode(isDeepClone);
        draggedElementShortcut.appendChild(clone);
        return draggedElementShortcut;
    };
    Object.defineProperty(DragDropRankingChoices.prototype, "shortcutClass", {
        get: function () {
            return new _utils_cssClassBuilder__WEBPACK_IMPORTED_MODULE_1__["CssClassBuilder"]()
                .append(this.parentElement.cssClasses.root)
                .append(this.parentElement.cssClasses.rootMobileMod, _utils_is_mobile__WEBPACK_IMPORTED_MODULE_2__["IsMobile"])
                .toString();
        },
        enumerable: false,
        configurable: true
    });
    DragDropRankingChoices.prototype.getDropTargetByDataAttributeValue = function (dataAttributeValue) {
        return this.parentElement.rankingChoices[dataAttributeValue];
    };
    DragDropRankingChoices.prototype.findDropTargetNodeByDragOverNode = function (dragOverNode) {
        this.isDragOverRootNode = dragOverNode.className.indexOf("sv-ranking") !== -1;
        return dragOverNode.closest(this.dropTargetDataAttributeName);
    };
    DragDropRankingChoices.prototype.isDropTargetValid = function (dropTarget, dropTargetNode) {
        var choices = this.parentElement.rankingChoices;
        var dropTargetIndex = choices.indexOf(this.dropTarget);
        var draggedElementIndex = choices.indexOf(this.draggedElement);
        if (draggedElementIndex > dropTargetIndex && dropTargetNode.classList.contains("sv-dragdrop-moveup")) {
            this.parentElement.dropTargetNodeMove = null;
            return false;
        }
        if (draggedElementIndex < dropTargetIndex && dropTargetNode.classList.contains("sv-dragdrop-movedown")) {
            this.parentElement.dropTargetNodeMove = null;
            return false;
        }
        if (choices.indexOf(dropTarget) === -1)
            // shouldn't allow to drop on "adorners" (selectall, none, other)
            return false;
        return true;
    };
    DragDropRankingChoices.prototype.calculateIsBottom = function (clientY) {
        var choices = this.parentElement.rankingChoices;
        return (choices.indexOf(this.dropTarget) - choices.indexOf(this.draggedElement) >
            0);
    };
    DragDropRankingChoices.prototype.afterDragOver = function (dropTargetNode) {
        var choices = this.parentElement.rankingChoices;
        var dropTargetIndex = choices.indexOf(this.dropTarget);
        var draggedElementIndex = choices.indexOf(this.draggedElement);
        choices.splice(draggedElementIndex, 1);
        choices.splice(dropTargetIndex, 0, this.draggedElement);
        this.parentElement.setPropertyValue("rankingChoices", choices);
        this.updateDraggedElementShortcut(dropTargetIndex + 1);
        if (draggedElementIndex !== dropTargetIndex) {
            dropTargetNode.classList.remove("sv-dragdrop-moveup");
            dropTargetNode.classList.remove("sv-dragdrop-movedown");
            this.parentElement.dropTargetNodeMove = null;
        }
        if (draggedElementIndex > dropTargetIndex) {
            this.parentElement.dropTargetNodeMove = "down";
        }
        if (draggedElementIndex < dropTargetIndex) {
            this.parentElement.dropTargetNodeMove = "up";
        }
    };
    DragDropRankingChoices.prototype.updateDraggedElementShortcut = function (newIndex) {
        var newIndexText = newIndex + "";
        // TODO should avoid direct DOM manipulation, do through the frameworks instead
        var indexNode = this.draggedElementShortcut.querySelector(".sv-ranking-item__index");
        indexNode.innerText = newIndexText;
    };
    DragDropRankingChoices.prototype.ghostPositionChanged = function () {
        this.parentElement.currentDropTarget = this.draggedElement;
        _super.prototype.ghostPositionChanged.call(this);
    };
    return DragDropRankingChoices;
}(_choices__WEBPACK_IMPORTED_MODULE_0__["DragDropChoices"]));



/***/ }),

/***/ "./src/dragdrop/survey-elements.ts":
/*!*****************************************!*\
  !*** ./src/dragdrop/survey-elements.ts ***!
  \*****************************************/
/*! exports provided: DragDropSurveyElements */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "DragDropSurveyElements", function() { return DragDropSurveyElements; });
/* harmony import */ var _survey_element__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ../survey-element */ "./src/survey-element.ts");
/* harmony import */ var _jsonobject__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ../jsonobject */ "./src/jsonobject.ts");
/* harmony import */ var _core__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ./core */ "./src/dragdrop/core.ts");
var __extends = (undefined && undefined.__extends) || (function () {
    var extendStatics = function (d, b) {
        extendStatics = Object.setPrototypeOf ||
            ({ __proto__: [] } instanceof Array && function (d, b) { d.__proto__ = b; }) ||
            function (d, b) { for (var p in b) if (Object.prototype.hasOwnProperty.call(b, p)) d[p] = b[p]; };
        return extendStatics(d, b);
    };
    return function (d, b) {
        if (typeof b !== "function" && b !== null)
            throw new TypeError("Class extends value " + String(b) + " is not a constructor or null");
        extendStatics(d, b);
        function __() { this.constructor = d; }
        d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
    };
})();



var DragDropSurveyElements = /** @class */ (function (_super) {
    __extends(DragDropSurveyElements, _super);
    function DragDropSurveyElements() {
        var _this = _super !== null && _super.apply(this, arguments) || this;
        _this.isEdge = false;
        _this.prevIsEdge = null;
        _this.ghostSurveyElement = null;
        _this.isDraggedElementSelected = false;
        _this.doBanDropHere = function () {
            _this.removeGhostElementFromSurvey();
            _this.isEdge = null;
        };
        _this.doDrop = function () {
            if (_this.dropTarget) {
                return _this.insertRealElementIntoSurvey();
            }
            return null;
        };
        _this.doClear = function () {
            _this.removeGhostElementFromSurvey();
            _this.isEdge = null;
            _this.ghostSurveyElement = null;
            if (!!_this.draggedElement) {
                _this.draggedElement.isDragMe = false;
            }
        };
        return _this;
    }
    Object.defineProperty(DragDropSurveyElements.prototype, "draggedElementType", {
        get: function () {
            return "survey-element";
        },
        enumerable: false,
        configurable: true
    });
    DragDropSurveyElements.prototype.startDragToolboxItem = function (event, draggedElementJson) {
        var draggedElement = this.createElementFromJson(draggedElementJson);
        this.startDrag(event, draggedElement);
    };
    DragDropSurveyElements.prototype.startDragSurveyElement = function (event, draggedElement, isElementSelected) {
        this.isDraggedElementSelected = isElementSelected;
        draggedElement.isDragMe = true;
        this.startDrag(event, draggedElement);
    };
    DragDropSurveyElements.prototype.createDraggedElementShortcut = function (text, draggedElementNode, event) {
        var draggedElementShortcut = document.createElement("div");
        var textSpan = document.createElement("span");
        textSpan.className = "svc-dragged-element-shortcut__text";
        textSpan.innerText = text;
        draggedElementShortcut.appendChild(this.createDraggedElementIcon());
        draggedElementShortcut.appendChild(textSpan);
        draggedElementShortcut.className = this.getDraggedElementClass();
        return draggedElementShortcut;
    };
    DragDropSurveyElements.prototype.createDraggedElementIcon = function () {
        var span = document.createElement("span");
        var type = this.draggedElement.getType();
        var svgString = "<svg class=\"sv-svg-icon\" role=\"img\" style=\"width: 24px; height: 24px;\"><use xlink:href=\"#icon-".concat(type, "\"></use></svg>");
        span.className = "svc-dragged-element-shortcut__icon";
        span.innerHTML = svgString;
        return span;
    };
    DragDropSurveyElements.prototype.getDraggedElementClass = function () {
        var result = "svc-dragged-element-shortcut";
        if (this.isDraggedElementSelected)
            result += " svc-dragged-element-shortcut--selected";
        return result;
    };
    DragDropSurveyElements.prototype.createElementFromJson = function (json) {
        var element = this.createNewElement(json);
        if (element["setSurveyImpl"]) {
            element["setSurveyImpl"](this.survey);
        }
        else {
            element["setData"](this.survey);
        }
        element.renderWidth = "100%";
        return element;
    };
    DragDropSurveyElements.prototype.createNewElement = function (json) {
        var newElement = _jsonobject__WEBPACK_IMPORTED_MODULE_1__["Serializer"].createClass(json["type"]);
        new _jsonobject__WEBPACK_IMPORTED_MODULE_1__["JsonObject"]().toObject(json, newElement);
        return newElement;
    };
    DragDropSurveyElements.prototype.getDropTargetByDataAttributeValue = function (dataAttributeValue, dropTargetNode, event) {
        this.isEdge = this.calculateIsEdge(dropTargetNode, event.clientY);
        if (!dataAttributeValue) {
            // panel dynamic
            var nearestDropTargetElement = dropTargetNode.parentElement.closest(this.dropTargetDataAttributeName);
            dataAttributeValue = this.getDataAttributeValueByNode(nearestDropTargetElement);
        }
        if (!dataAttributeValue) {
            throw new Error("Can't find drop target survey element name");
        }
        if (dataAttributeValue === DragDropSurveyElements.ghostSurveyElementName) {
            return this.prevDropTarget;
        }
        // drop to new page
        if (dataAttributeValue === "newGhostPage") {
            return DragDropSurveyElements.newGhostPage;
        }
        // drop to page
        var page = this.survey.getPageByName(dataAttributeValue);
        if (page) {
            if (
            // TODO we can't drop on not empty page directly for now
            page.elements.length !== 0) {
                return null;
            }
            return page;
        }
        // drop to question or panel
        var dropTarget;
        var question;
        this.survey.pages.forEach(function (page) {
            question = page.getElementByName(dataAttributeValue);
            if (question)
                dropTarget = question;
        });
        // drop to paneldynamic
        if (dropTarget.getType() === "paneldynamic" && !this.isEdge) {
            dropTarget = dropTarget.template;
        }
        // drop to panel
        else if (dropTarget.isPanel) {
            var panelDragInfo = this.getPanelDragInfo(dropTargetNode, dropTarget, event);
            dropTarget = panelDragInfo.dropTarget;
            this.isEdge = panelDragInfo.isEdge;
        }
        // drop to question
        //question inside paneldymanic
        if (!dropTarget.page) {
            var nearestDropTargetPageElement = dropTargetNode.parentElement.closest("[data-sv-drop-target-page]");
            dataAttributeValue = nearestDropTargetPageElement.dataset.svDropTargetPage;
            var page_1 = this.survey.getPageByName(dataAttributeValue);
            dropTarget.__page = page_1;
        }
        return dropTarget;
        // EO drop to question or panel
    };
    DragDropSurveyElements.prototype.isDropTargetValid = function (dropTarget) {
        if (!dropTarget)
            return false;
        if (this.dropTarget === this.draggedElement)
            return false;
        if (DragDropSurveyElements.restrictDragQuestionBetweenPages &&
            this.shouldRestricDragQuestionBetweenPages(dropTarget)) {
            return false;
        }
        return true;
    };
    DragDropSurveyElements.prototype.calculateIsBottom = function (clientY, dropTargetNode) {
        // we shouldn't reculc isBottom if drag over ghost survey element
        if (this.getDataAttributeValueByNode(dropTargetNode) === DragDropSurveyElements.ghostSurveyElementName) {
            return this.isBottom;
        }
        var middle = this.calculateMiddleOfHTMLElement(dropTargetNode);
        return clientY >= middle;
    };
    DragDropSurveyElements.prototype.isDropTargetDoesntChanged = function (newIsBottom) {
        if (this.dropTarget === this.ghostSurveyElement)
            return true;
        return (this.dropTarget === this.prevDropTarget && newIsBottom === this.isBottom
            && this.isEdge === this.prevIsEdge);
    };
    DragDropSurveyElements.prototype.shouldRestricDragQuestionBetweenPages = function (dropTarget) {
        var oldPage = this.draggedElement["page"];
        var newPage = dropTarget.isPage ? dropTarget : dropTarget["page"];
        // if oldPage === null then it is drom the toolbox
        return oldPage && oldPage !== newPage;
    };
    DragDropSurveyElements.prototype.getPanelDragInfo = function (HTMLElement, dropTarget, event) {
        var isEdge = this.isEdge;
        if (!isEdge && dropTarget.questions.length !== 0) {
            HTMLElement = this.findDeepestDropTargetChild(HTMLElement);
            dropTarget = this.getDropTargetByNode(HTMLElement, event);
        }
        return { dropTarget: dropTarget, isEdge: isEdge };
    };
    DragDropSurveyElements.prototype.findDeepestDropTargetChild = function (parent) {
        var selector = this.dropTargetDataAttributeName;
        var result = parent;
        while (!!parent) {
            result = parent;
            parent = parent.querySelector(selector);
        }
        return result;
    };
    DragDropSurveyElements.prototype.calculateIsEdge = function (HTMLElement, clientY) {
        var middle = this.calculateMiddleOfHTMLElement(HTMLElement);
        return Math.abs(clientY - middle) >= DragDropSurveyElements.edgeHeight;
    };
    DragDropSurveyElements.prototype.calculateIsRight = function () {
        var pageOrPanel = this.dropTarget.parent;
        var srcIndex = pageOrPanel.elements.indexOf(this.draggedElement);
        var destIndex = pageOrPanel.elements.indexOf(this.dropTarget);
        return srcIndex < destIndex;
    };
    DragDropSurveyElements.prototype.afterDragOver = function () {
        this.prevIsEdge = this.isEdge;
        this.insertGhostElementIntoSurvey();
    };
    DragDropSurveyElements.prototype.doStartDrag = function () {
        this.ghostSurveyElement = this.createGhostSurveyElement();
    };
    DragDropSurveyElements.prototype.insertGhostElementIntoSurvey = function () {
        this.removeGhostElementFromSurvey();
        var isTargetRowMultiple = this.calcTargetRowMultiple();
        this.ghostSurveyElement = this.createGhostSurveyElement(isTargetRowMultiple);
        this.ghostSurveyElement.name =
            DragDropSurveyElements.ghostSurveyElementName; // TODO why do we need setup it manually see createGhostSurveyElement method
        this.parentElement = this.dropTarget.isPage
            ? this.dropTarget
            : (this.dropTarget.page || this.dropTarget.__page);
        if (this.isDragOverInsideEmptyPanel()) {
            this.dropTarget.dragTypeOverMe = _survey_element__WEBPACK_IMPORTED_MODULE_0__["DragTypeOverMeEnum"].InsideEmptyPanel;
            return;
        }
        if (!this.isEdge && isTargetRowMultiple) {
            this.dropTarget.dragTypeOverMe = this.calculateIsRight() ?
                _survey_element__WEBPACK_IMPORTED_MODULE_0__["DragTypeOverMeEnum"].MultilineRight :
                _survey_element__WEBPACK_IMPORTED_MODULE_0__["DragTypeOverMeEnum"].MultilineLeft;
            return;
        }
        this.parentElement.dragDropStart(this.draggedElement, this.ghostSurveyElement, DragDropSurveyElements.nestedPanelDepth);
        var result = this.parentElement.dragDropMoveTo(this.dropTarget, isTargetRowMultiple ? this.calculateIsRight() : this.isBottom, this.isEdge);
        return result;
    };
    DragDropSurveyElements.prototype.calcTargetRowMultiple = function () {
        var _this = this;
        var targetParent = this.dropTarget.isPage || this.dropTarget.isPanel ? this.dropTarget : this.dropTarget.parent;
        if (this.dropTarget.getType() === "paneldynamic") {
            targetParent = this.dropTarget.templateValue;
        }
        var targetRow;
        targetParent.rows.forEach(function (row) {
            if (row.elements.indexOf(_this.dropTarget) !== -1) {
                targetRow = row;
            }
        });
        var isTargetRowMultiple = targetRow && targetRow.elements.length > 1;
        if (this.isEdge && isTargetRowMultiple) {
            targetParent.__page = this.dropTarget.page;
            this.dropTarget = targetParent;
            return false;
        }
        return isTargetRowMultiple;
    };
    DragDropSurveyElements.prototype.isDragOverInsideEmptyPanel = function () {
        var isEmptyPanel = this.dropTarget.isPanel && this.dropTarget.questions.length === 0;
        var isDragOverInside = !this.isEdge;
        return isEmptyPanel && isDragOverInside;
    };
    DragDropSurveyElements.prototype.removeGhostElementFromSurvey = function () {
        var dropTarget = this.prevDropTarget || this.dropTarget;
        if (!!dropTarget) {
            dropTarget.dragTypeOverMe = null;
        }
        if (!!this.parentElement)
            this.parentElement.dragDropFinish(true);
    };
    DragDropSurveyElements.prototype.insertRealElementIntoSurvey = function () {
        this.removeGhostElementFromSurvey();
        var isTargetRowMultiple = this.calcTargetRowMultiple();
        // ghost new page
        if (this.dropTarget.isPage && this.dropTarget["_isGhost"]) {
            this.dropTarget["_addGhostPageViewModel"]();
        }
        // EO ghost new page
        // fake target element (need only for "startWithNewLine:false" feature)
        //TODO need for dragDrop helper in library
        var json = new _jsonobject__WEBPACK_IMPORTED_MODULE_1__["JsonObject"]().toJsonObject(this.draggedElement);
        json["type"] = this.draggedElement.getType();
        var fakeTargetElement = this.createFakeTargetElement(this.draggedElement.name, json);
        // EO fake target element
        this.parentElement.dragDropStart(this.draggedElement, fakeTargetElement, DragDropSurveyElements.nestedPanelDepth);
        this.parentElement.dragDropMoveTo(this.dropTarget, isTargetRowMultiple ? this.calculateIsRight() : this.isBottom, this.isEdge);
        var newElement = this.parentElement.dragDropFinish();
        return newElement;
    };
    DragDropSurveyElements.prototype.createFakeTargetElement = function (elementName, json) {
        if (!elementName || !json)
            return null;
        var targetElement = null;
        targetElement = _jsonobject__WEBPACK_IMPORTED_MODULE_1__["Serializer"].createClass(json["type"]);
        new _jsonobject__WEBPACK_IMPORTED_MODULE_1__["JsonObject"]().toObject(json, targetElement);
        targetElement.name = elementName;
        if (targetElement["setSurveyImpl"]) {
            targetElement["setSurveyImpl"](this.survey);
        }
        else {
            targetElement["setData"](this.survey);
        }
        targetElement.renderWidth = "100%";
        return targetElement;
    };
    DragDropSurveyElements.prototype.createGhostSurveyElement = function (isMultipleRowDrag) {
        if (isMultipleRowDrag === void 0) { isMultipleRowDrag = false; }
        var className = "sv-drag-drop-ghost";
        var minWidth = "300px";
        if (isMultipleRowDrag) {
            minWidth = "4px";
            className += " sv-drag-drop-ghost--vertical";
        }
        var json = {
            type: "html",
            minWidth: minWidth,
            name: DragDropSurveyElements.ghostSurveyElementName,
            html: "<div class=\"".concat(className, "\"></div>"),
        };
        var element = this.createElementFromJson(json);
        element.startWithNewLine = !isMultipleRowDrag;
        if (isMultipleRowDrag) {
            element.maxWidth = "4px";
            element.renderWidth = "0px";
            element.paddingRight = "0px";
            element.paddingLeft = "0px";
        }
        return element;
    };
    DragDropSurveyElements.newGhostPage = null;
    DragDropSurveyElements.restrictDragQuestionBetweenPages = false;
    DragDropSurveyElements.edgeHeight = 30;
    DragDropSurveyElements.nestedPanelDepth = -1;
    DragDropSurveyElements.ghostSurveyElementName = "sv-drag-drop-ghost-survey-element-name"; // before renaming use globa search (we have also css selectors)
    return DragDropSurveyElements;
}(_core__WEBPACK_IMPORTED_MODULE_2__["DragDropCore"]));



/***/ }),

/***/ "./src/dxSurveyService.ts":
/*!********************************!*\
  !*** ./src/dxSurveyService.ts ***!
  \********************************/
/*! exports provided: dxSurveyService */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "dxSurveyService", function() { return dxSurveyService; });
/* harmony import */ var _settings__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./settings */ "./src/settings.ts");

/**
 * The class contains methods to work with api.surveyjs.io service.
 */
var dxSurveyService = /** @class */ (function () {
    function dxSurveyService() {
    }
    Object.defineProperty(dxSurveyService, "serviceUrl", {
        get: function () {
            return _settings__WEBPACK_IMPORTED_MODULE_0__["settings"].surveyServiceUrl;
        },
        set: function (val) {
            _settings__WEBPACK_IMPORTED_MODULE_0__["settings"].surveyServiceUrl = val;
        },
        enumerable: false,
        configurable: true
    });
    dxSurveyService.prototype.loadSurvey = function (surveyId, onLoad) {
        var xhr = new XMLHttpRequest();
        xhr.open("GET", dxSurveyService.serviceUrl + "/getSurvey?surveyId=" + surveyId);
        xhr.setRequestHeader("Content-Type", "application/x-www-form-urlencoded");
        xhr.onload = function () {
            var result = JSON.parse(xhr.response);
            onLoad(xhr.status == 200, result, xhr.response);
        };
        xhr.send();
    };
    dxSurveyService.prototype.getSurveyJsonAndIsCompleted = function (surveyId, clientId, onLoad) {
        var xhr = new XMLHttpRequest();
        xhr.open("GET", dxSurveyService.serviceUrl +
            "/getSurveyAndIsCompleted?surveyId=" +
            surveyId +
            "&clientId=" +
            clientId);
        xhr.setRequestHeader("Content-Type", "application/x-www-form-urlencoded");
        xhr.onload = function () {
            var result = JSON.parse(xhr.response);
            var surveyJson = result ? result.survey : null;
            var isCompleted = result ? result.isCompleted : null;
            onLoad(xhr.status == 200, surveyJson, isCompleted, xhr.response);
        };
        xhr.send();
    };
    dxSurveyService.prototype.sendResult = function (postId, result, onSendResult, clientId, isPartialCompleted) {
        if (clientId === void 0) { clientId = null; }
        if (isPartialCompleted === void 0) { isPartialCompleted = false; }
        var xhr = new XMLHttpRequest();
        xhr.open("POST", dxSurveyService.serviceUrl + "/post/");
        xhr.setRequestHeader("Content-Type", "application/json; charset=utf-8");
        var data = { postId: postId, surveyResult: JSON.stringify(result) };
        if (clientId)
            data["clientId"] = clientId;
        if (isPartialCompleted)
            data["isPartialCompleted"] = true;
        var dataStringify = JSON.stringify(data);
        var self = this;
        xhr.onload = xhr.onerror = function () {
            if (!onSendResult)
                return;
            onSendResult(xhr.status === 200, xhr.response, xhr);
        };
        xhr.send(dataStringify);
    };
    dxSurveyService.prototype.sendFile = function (postId, file, onSendFile) {
        var xhr = new XMLHttpRequest();
        xhr.onload = xhr.onerror = function () {
            if (!onSendFile)
                return;
            onSendFile(xhr.status == 200, JSON.parse(xhr.response));
        };
        xhr.open("POST", dxSurveyService.serviceUrl + "/upload/", true);
        var formData = new FormData();
        formData.append("file", file);
        formData.append("postId", postId);
        xhr.send(formData);
    };
    dxSurveyService.prototype.getResult = function (resultId, name, onGetResult) {
        var xhr = new XMLHttpRequest();
        var data = "resultId=" + resultId + "&name=" + name;
        xhr.open("GET", dxSurveyService.serviceUrl + "/getResult?" + data);
        xhr.setRequestHeader("Content-Type", "application/x-www-form-urlencoded");
        var self = this;
        xhr.onload = function () {
            var result = null;
            var list = null;
            if (xhr.status == 200) {
                result = JSON.parse(xhr.response);
                list = [];
                for (var key in result.QuestionResult) {
                    var el = { name: key, value: result.QuestionResult[key] };
                    list.push(el);
                }
            }
            onGetResult(xhr.status == 200, result, list, xhr.response);
        };
        xhr.send();
    };
    dxSurveyService.prototype.isCompleted = function (resultId, clientId, onIsCompleted) {
        var xhr = new XMLHttpRequest();
        var data = "resultId=" + resultId + "&clientId=" + clientId;
        xhr.open("GET", dxSurveyService.serviceUrl + "/isCompleted?" + data);
        xhr.setRequestHeader("Content-Type", "application/x-www-form-urlencoded");
        var self = this;
        xhr.onload = function () {
            var result = null;
            if (xhr.status == 200) {
                result = JSON.parse(xhr.response);
            }
            onIsCompleted(xhr.status == 200, result, xhr.response);
        };
        xhr.send();
    };
    return dxSurveyService;
}());



/***/ }),

/***/ "./src/entries/chunks/localization.ts":
/*!********************************************!*\
  !*** ./src/entries/chunks/localization.ts ***!
  \********************************************/
/*! no exports provided */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony import */ var _localization_arabic__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ../../localization/arabic */ "./src/localization/arabic.ts");
/* harmony import */ var _localization_basque__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ../../localization/basque */ "./src/localization/basque.ts");
/* harmony import */ var _localization_bulgarian__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ../../localization/bulgarian */ "./src/localization/bulgarian.ts");
/* harmony import */ var _localization_catalan__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ../../localization/catalan */ "./src/localization/catalan.ts");
/* harmony import */ var _localization_croatian__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! ../../localization/croatian */ "./src/localization/croatian.ts");
/* harmony import */ var _localization_czech__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! ../../localization/czech */ "./src/localization/czech.ts");
/* harmony import */ var _localization_danish__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(/*! ../../localization/danish */ "./src/localization/danish.ts");
/* harmony import */ var _localization_dutch__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__(/*! ../../localization/dutch */ "./src/localization/dutch.ts");
/* harmony import */ var _localization_estonian__WEBPACK_IMPORTED_MODULE_8__ = __webpack_require__(/*! ../../localization/estonian */ "./src/localization/estonian.ts");
/* harmony import */ var _localization_finnish__WEBPACK_IMPORTED_MODULE_9__ = __webpack_require__(/*! ../../localization/finnish */ "./src/localization/finnish.ts");
/* harmony import */ var _localization_french__WEBPACK_IMPORTED_MODULE_10__ = __webpack_require__(/*! ../../localization/french */ "./src/localization/french.ts");
/* harmony import */ var _localization_georgian__WEBPACK_IMPORTED_MODULE_11__ = __webpack_require__(/*! ../../localization/georgian */ "./src/localization/georgian.ts");
/* harmony import */ var _localization_german__WEBPACK_IMPORTED_MODULE_12__ = __webpack_require__(/*! ../../localization/german */ "./src/localization/german.ts");
/* harmony import */ var _localization_greek__WEBPACK_IMPORTED_MODULE_13__ = __webpack_require__(/*! ../../localization/greek */ "./src/localization/greek.ts");
/* harmony import */ var _localization_hebrew__WEBPACK_IMPORTED_MODULE_14__ = __webpack_require__(/*! ../../localization/hebrew */ "./src/localization/hebrew.ts");
/* harmony import */ var _localization_hindi__WEBPACK_IMPORTED_MODULE_15__ = __webpack_require__(/*! ../../localization/hindi */ "./src/localization/hindi.ts");
/* harmony import */ var _localization_hungarian__WEBPACK_IMPORTED_MODULE_16__ = __webpack_require__(/*! ../../localization/hungarian */ "./src/localization/hungarian.ts");
/* harmony import */ var _localization_icelandic__WEBPACK_IMPORTED_MODULE_17__ = __webpack_require__(/*! ../../localization/icelandic */ "./src/localization/icelandic.ts");
/* harmony import */ var _localization_indonesian__WEBPACK_IMPORTED_MODULE_18__ = __webpack_require__(/*! ../../localization/indonesian */ "./src/localization/indonesian.ts");
/* harmony import */ var _localization_italian__WEBPACK_IMPORTED_MODULE_19__ = __webpack_require__(/*! ../../localization/italian */ "./src/localization/italian.ts");
/* harmony import */ var _localization_japanese__WEBPACK_IMPORTED_MODULE_20__ = __webpack_require__(/*! ../../localization/japanese */ "./src/localization/japanese.ts");
/* harmony import */ var _localization_kazakh__WEBPACK_IMPORTED_MODULE_21__ = __webpack_require__(/*! ../../localization/kazakh */ "./src/localization/kazakh.ts");
/* harmony import */ var _localization_korean__WEBPACK_IMPORTED_MODULE_22__ = __webpack_require__(/*! ../../localization/korean */ "./src/localization/korean.ts");
/* harmony import */ var _localization_latvian__WEBPACK_IMPORTED_MODULE_23__ = __webpack_require__(/*! ../../localization/latvian */ "./src/localization/latvian.ts");
/* harmony import */ var _localization_lithuanian__WEBPACK_IMPORTED_MODULE_24__ = __webpack_require__(/*! ../../localization/lithuanian */ "./src/localization/lithuanian.ts");
/* harmony import */ var _localization_macedonian__WEBPACK_IMPORTED_MODULE_25__ = __webpack_require__(/*! ../../localization/macedonian */ "./src/localization/macedonian.ts");
/* harmony import */ var _localization_norwegian__WEBPACK_IMPORTED_MODULE_26__ = __webpack_require__(/*! ../../localization/norwegian */ "./src/localization/norwegian.ts");
/* harmony import */ var _localization_persian__WEBPACK_IMPORTED_MODULE_27__ = __webpack_require__(/*! ../../localization/persian */ "./src/localization/persian.ts");
/* harmony import */ var _localization_polish__WEBPACK_IMPORTED_MODULE_28__ = __webpack_require__(/*! ../../localization/polish */ "./src/localization/polish.ts");
/* harmony import */ var _localization_portuguese__WEBPACK_IMPORTED_MODULE_29__ = __webpack_require__(/*! ../../localization/portuguese */ "./src/localization/portuguese.ts");
/* harmony import */ var _localization_portuguese_br__WEBPACK_IMPORTED_MODULE_30__ = __webpack_require__(/*! ../../localization/portuguese-br */ "./src/localization/portuguese-br.ts");
/* harmony import */ var _localization_romanian__WEBPACK_IMPORTED_MODULE_31__ = __webpack_require__(/*! ../../localization/romanian */ "./src/localization/romanian.ts");
/* harmony import */ var _localization_russian__WEBPACK_IMPORTED_MODULE_32__ = __webpack_require__(/*! ../../localization/russian */ "./src/localization/russian.ts");
/* harmony import */ var _localization_serbian__WEBPACK_IMPORTED_MODULE_33__ = __webpack_require__(/*! ../../localization/serbian */ "./src/localization/serbian.ts");
/* harmony import */ var _localization_simplified_chinese__WEBPACK_IMPORTED_MODULE_34__ = __webpack_require__(/*! ../../localization/simplified-chinese */ "./src/localization/simplified-chinese.ts");
/* harmony import */ var _localization_spanish__WEBPACK_IMPORTED_MODULE_35__ = __webpack_require__(/*! ../../localization/spanish */ "./src/localization/spanish.ts");
/* harmony import */ var _localization_swahili__WEBPACK_IMPORTED_MODULE_36__ = __webpack_require__(/*! ../../localization/swahili */ "./src/localization/swahili.ts");
/* harmony import */ var _localization_swedish__WEBPACK_IMPORTED_MODULE_37__ = __webpack_require__(/*! ../../localization/swedish */ "./src/localization/swedish.ts");
/* harmony import */ var _localization_tajik__WEBPACK_IMPORTED_MODULE_38__ = __webpack_require__(/*! ../../localization/tajik */ "./src/localization/tajik.ts");
/* harmony import */ var _localization_thai__WEBPACK_IMPORTED_MODULE_39__ = __webpack_require__(/*! ../../localization/thai */ "./src/localization/thai.ts");
/* harmony import */ var _localization_traditional_chinese__WEBPACK_IMPORTED_MODULE_40__ = __webpack_require__(/*! ../../localization/traditional-chinese */ "./src/localization/traditional-chinese.ts");
/* harmony import */ var _localization_turkish__WEBPACK_IMPORTED_MODULE_41__ = __webpack_require__(/*! ../../localization/turkish */ "./src/localization/turkish.ts");
/* harmony import */ var _localization_ukrainian__WEBPACK_IMPORTED_MODULE_42__ = __webpack_require__(/*! ../../localization/ukrainian */ "./src/localization/ukrainian.ts");
/* harmony import */ var _localization_vietnamese__WEBPACK_IMPORTED_MODULE_43__ = __webpack_require__(/*! ../../localization/vietnamese */ "./src/localization/vietnamese.ts");
/* harmony import */ var _localization_welsh__WEBPACK_IMPORTED_MODULE_44__ = __webpack_require__(/*! ../../localization/welsh */ "./src/localization/welsh.ts");















































/***/ }),

/***/ "./src/entries/chunks/model.ts":
/*!*************************************!*\
  !*** ./src/entries/chunks/model.ts ***!
  \*************************************/
/*! exports provided: Version, settings, Helpers, AnswerCountValidator, EmailValidator, NumericValidator, RegexValidator, SurveyValidator, TextValidator, ValidatorResult, ExpressionValidator, ValidatorRunner, ItemValue, Base, Event, ArrayChanges, ComputedUpdater, SurveyError, SurveyElementCore, SurveyElement, DragTypeOverMeEnum, CalculatedValue, CustomError, AnswerRequiredError, OneAnswerRequiredError, RequreNumericError, ExceedSizeError, LocalizableString, LocalizableStrings, HtmlConditionItem, UrlConditionItem, ChoicesRestful, ChoicesRestfull, FunctionFactory, registerFunction, ConditionRunner, ExpressionRunner, Operand, Const, BinaryOperand, Variable, FunctionOperand, ArrayOperand, ConditionsParser, ProcessValue, JsonError, JsonIncorrectTypeError, JsonMetadata, JsonMetadataClass, JsonMissingTypeError, JsonMissingTypeErrorBase, JsonObject, JsonObjectProperty, JsonRequiredPropertyError, JsonUnknownPropertyError, Serializer, property, propertyArray, MatrixDropdownCell, MatrixDropdownRowModelBase, QuestionMatrixDropdownModelBase, MatrixDropdownColumn, matrixDropdownColumnTypes, QuestionMatrixDropdownRenderedCell, QuestionMatrixDropdownRenderedRow, QuestionMatrixDropdownRenderedTable, MatrixDropdownRowModel, QuestionMatrixDropdownModel, MatrixDynamicRowModel, QuestionMatrixDynamicModel, MatrixRowModel, MatrixCells, QuestionMatrixModel, MultipleTextItemModel, QuestionMultipleTextModel, PanelModel, PanelModelBase, QuestionRowModel, FlowPanelModel, PageModel, DefaultTitleModel, Question, QuestionNonValue, QuestionEmptyModel, QuestionCheckboxBase, QuestionSelectBase, QuestionCheckboxModel, QuestionRankingModel, QuestionCommentModel, QuestionDropdownModel, QuestionFactory, ElementFactory, QuestionFileModel, QuestionHtmlModel, QuestionRadiogroupModel, QuestionRatingModel, QuestionExpressionModel, QuestionTextModel, QuestionBooleanModel, QuestionImagePickerModel, ImageItemValue, QuestionImageModel, QuestionSignaturePadModel, QuestionPanelDynamicModel, QuestionPanelDynamicItem, SurveyTimer, SurveyProgressModel, SurveyProgressButtonsModel, SurveyModel, SurveyTrigger, SurveyTriggerComplete, SurveyTriggerSetValue, SurveyTriggerVisible, SurveyTriggerCopyValue, SurveyTriggerRunExpression, Trigger, SurveyWindowModel, TextPreProcessor, dxSurveyService, englishStrings, surveyLocalization, surveyStrings, QuestionCustomWidget, CustomWidgetCollection, QuestionCustomModel, QuestionCompositeModel, ComponentQuestionJSON, ComponentCollection, StylesManager, ListModel, PopupModel, PopupBaseViewModel, createPopupModalViewModel, QuestionButtonGroupModel, ButtonGroupItemModel, ButtonGroupItemValue, IsMobile, confirmAction, detectIEOrEdge, doKey2ClickUp, doKey2ClickDown, loadFileFromBase64, increaseHeightByContent, createSvg, CssClassBuilder, surveyCss, DragDropSurveyElements, DragDropChoices */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "Version", function() { return Version; });
/* harmony import */ var _main_scss__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ../../main.scss */ "./src/main.scss");
/* harmony import */ var _main_scss__WEBPACK_IMPORTED_MODULE_0___default = /*#__PURE__*/__webpack_require__.n(_main_scss__WEBPACK_IMPORTED_MODULE_0__);
/* harmony import */ var _settings__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ../../settings */ "./src/settings.ts");
/* harmony reexport (safe) */ __webpack_require__.d(__webpack_exports__, "settings", function() { return _settings__WEBPACK_IMPORTED_MODULE_1__["settings"]; });

/* harmony import */ var _helpers__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ../../helpers */ "./src/helpers.ts");
/* harmony reexport (safe) */ __webpack_require__.d(__webpack_exports__, "Helpers", function() { return _helpers__WEBPACK_IMPORTED_MODULE_2__["Helpers"]; });

/* harmony import */ var _validator__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ../../validator */ "./src/validator.ts");
/* harmony reexport (safe) */ __webpack_require__.d(__webpack_exports__, "AnswerCountValidator", function() { return _validator__WEBPACK_IMPORTED_MODULE_3__["AnswerCountValidator"]; });

/* harmony reexport (safe) */ __webpack_require__.d(__webpack_exports__, "EmailValidator", function() { return _validator__WEBPACK_IMPORTED_MODULE_3__["EmailValidator"]; });

/* harmony reexport (safe) */ __webpack_require__.d(__webpack_exports__, "NumericValidator", function() { return _validator__WEBPACK_IMPORTED_MODULE_3__["NumericValidator"]; });

/* harmony reexport (safe) */ __webpack_require__.d(__webpack_exports__, "RegexValidator", function() { return _validator__WEBPACK_IMPORTED_MODULE_3__["RegexValidator"]; });

/* harmony reexport (safe) */ __webpack_require__.d(__webpack_exports__, "SurveyValidator", function() { return _validator__WEBPACK_IMPORTED_MODULE_3__["SurveyValidator"]; });

/* harmony reexport (safe) */ __webpack_require__.d(__webpack_exports__, "TextValidator", function() { return _validator__WEBPACK_IMPORTED_MODULE_3__["TextValidator"]; });

/* harmony reexport (safe) */ __webpack_require__.d(__webpack_exports__, "ValidatorResult", function() { return _validator__WEBPACK_IMPORTED_MODULE_3__["ValidatorResult"]; });

/* harmony reexport (safe) */ __webpack_require__.d(__webpack_exports__, "ExpressionValidator", function() { return _validator__WEBPACK_IMPORTED_MODULE_3__["ExpressionValidator"]; });

/* harmony reexport (safe) */ __webpack_require__.d(__webpack_exports__, "ValidatorRunner", function() { return _validator__WEBPACK_IMPORTED_MODULE_3__["ValidatorRunner"]; });

/* harmony import */ var _itemvalue__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! ../../itemvalue */ "./src/itemvalue.ts");
/* harmony reexport (safe) */ __webpack_require__.d(__webpack_exports__, "ItemValue", function() { return _itemvalue__WEBPACK_IMPORTED_MODULE_4__["ItemValue"]; });

/* harmony import */ var _base__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! ../../base */ "./src/base.ts");
/* harmony reexport (safe) */ __webpack_require__.d(__webpack_exports__, "Base", function() { return _base__WEBPACK_IMPORTED_MODULE_5__["Base"]; });

/* harmony reexport (safe) */ __webpack_require__.d(__webpack_exports__, "Event", function() { return _base__WEBPACK_IMPORTED_MODULE_5__["Event"]; });

/* harmony reexport (safe) */ __webpack_require__.d(__webpack_exports__, "ArrayChanges", function() { return _base__WEBPACK_IMPORTED_MODULE_5__["ArrayChanges"]; });

/* harmony reexport (safe) */ __webpack_require__.d(__webpack_exports__, "ComputedUpdater", function() { return _base__WEBPACK_IMPORTED_MODULE_5__["ComputedUpdater"]; });

/* harmony import */ var _survey_error__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(/*! ../../survey-error */ "./src/survey-error.ts");
/* harmony reexport (safe) */ __webpack_require__.d(__webpack_exports__, "SurveyError", function() { return _survey_error__WEBPACK_IMPORTED_MODULE_6__["SurveyError"]; });

/* harmony import */ var _survey_element__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__(/*! ../../survey-element */ "./src/survey-element.ts");
/* harmony reexport (safe) */ __webpack_require__.d(__webpack_exports__, "SurveyElementCore", function() { return _survey_element__WEBPACK_IMPORTED_MODULE_7__["SurveyElementCore"]; });

/* harmony reexport (safe) */ __webpack_require__.d(__webpack_exports__, "SurveyElement", function() { return _survey_element__WEBPACK_IMPORTED_MODULE_7__["SurveyElement"]; });

/* harmony reexport (safe) */ __webpack_require__.d(__webpack_exports__, "DragTypeOverMeEnum", function() { return _survey_element__WEBPACK_IMPORTED_MODULE_7__["DragTypeOverMeEnum"]; });

/* harmony import */ var _calculatedValue__WEBPACK_IMPORTED_MODULE_8__ = __webpack_require__(/*! ../../calculatedValue */ "./src/calculatedValue.ts");
/* harmony reexport (safe) */ __webpack_require__.d(__webpack_exports__, "CalculatedValue", function() { return _calculatedValue__WEBPACK_IMPORTED_MODULE_8__["CalculatedValue"]; });

/* harmony import */ var _error__WEBPACK_IMPORTED_MODULE_9__ = __webpack_require__(/*! ../../error */ "./src/error.ts");
/* harmony reexport (safe) */ __webpack_require__.d(__webpack_exports__, "CustomError", function() { return _error__WEBPACK_IMPORTED_MODULE_9__["CustomError"]; });

/* harmony reexport (safe) */ __webpack_require__.d(__webpack_exports__, "AnswerRequiredError", function() { return _error__WEBPACK_IMPORTED_MODULE_9__["AnswerRequiredError"]; });

/* harmony reexport (safe) */ __webpack_require__.d(__webpack_exports__, "OneAnswerRequiredError", function() { return _error__WEBPACK_IMPORTED_MODULE_9__["OneAnswerRequiredError"]; });

/* harmony reexport (safe) */ __webpack_require__.d(__webpack_exports__, "RequreNumericError", function() { return _error__WEBPACK_IMPORTED_MODULE_9__["RequreNumericError"]; });

/* harmony reexport (safe) */ __webpack_require__.d(__webpack_exports__, "ExceedSizeError", function() { return _error__WEBPACK_IMPORTED_MODULE_9__["ExceedSizeError"]; });

/* harmony import */ var _localizablestring__WEBPACK_IMPORTED_MODULE_10__ = __webpack_require__(/*! ../../localizablestring */ "./src/localizablestring.ts");
/* harmony reexport (safe) */ __webpack_require__.d(__webpack_exports__, "LocalizableString", function() { return _localizablestring__WEBPACK_IMPORTED_MODULE_10__["LocalizableString"]; });

/* harmony reexport (safe) */ __webpack_require__.d(__webpack_exports__, "LocalizableStrings", function() { return _localizablestring__WEBPACK_IMPORTED_MODULE_10__["LocalizableStrings"]; });

/* harmony import */ var _expressionItems__WEBPACK_IMPORTED_MODULE_11__ = __webpack_require__(/*! ../../expressionItems */ "./src/expressionItems.ts");
/* harmony reexport (safe) */ __webpack_require__.d(__webpack_exports__, "HtmlConditionItem", function() { return _expressionItems__WEBPACK_IMPORTED_MODULE_11__["HtmlConditionItem"]; });

/* harmony reexport (safe) */ __webpack_require__.d(__webpack_exports__, "UrlConditionItem", function() { return _expressionItems__WEBPACK_IMPORTED_MODULE_11__["UrlConditionItem"]; });

/* harmony import */ var _choicesRestful__WEBPACK_IMPORTED_MODULE_12__ = __webpack_require__(/*! ../../choicesRestful */ "./src/choicesRestful.ts");
/* harmony reexport (safe) */ __webpack_require__.d(__webpack_exports__, "ChoicesRestful", function() { return _choicesRestful__WEBPACK_IMPORTED_MODULE_12__["ChoicesRestful"]; });

/* harmony reexport (safe) */ __webpack_require__.d(__webpack_exports__, "ChoicesRestfull", function() { return _choicesRestful__WEBPACK_IMPORTED_MODULE_12__["ChoicesRestfull"]; });

/* harmony import */ var _functionsfactory__WEBPACK_IMPORTED_MODULE_13__ = __webpack_require__(/*! ../../functionsfactory */ "./src/functionsfactory.ts");
/* harmony reexport (safe) */ __webpack_require__.d(__webpack_exports__, "FunctionFactory", function() { return _functionsfactory__WEBPACK_IMPORTED_MODULE_13__["FunctionFactory"]; });

/* harmony reexport (safe) */ __webpack_require__.d(__webpack_exports__, "registerFunction", function() { return _functionsfactory__WEBPACK_IMPORTED_MODULE_13__["registerFunction"]; });

/* harmony import */ var _conditions__WEBPACK_IMPORTED_MODULE_14__ = __webpack_require__(/*! ../../conditions */ "./src/conditions.ts");
/* harmony reexport (safe) */ __webpack_require__.d(__webpack_exports__, "ConditionRunner", function() { return _conditions__WEBPACK_IMPORTED_MODULE_14__["ConditionRunner"]; });

/* harmony reexport (safe) */ __webpack_require__.d(__webpack_exports__, "ExpressionRunner", function() { return _conditions__WEBPACK_IMPORTED_MODULE_14__["ExpressionRunner"]; });

/* harmony import */ var _expressions_expressions__WEBPACK_IMPORTED_MODULE_15__ = __webpack_require__(/*! ../../expressions/expressions */ "./src/expressions/expressions.ts");
/* harmony reexport (safe) */ __webpack_require__.d(__webpack_exports__, "Operand", function() { return _expressions_expressions__WEBPACK_IMPORTED_MODULE_15__["Operand"]; });

/* harmony reexport (safe) */ __webpack_require__.d(__webpack_exports__, "Const", function() { return _expressions_expressions__WEBPACK_IMPORTED_MODULE_15__["Const"]; });

/* harmony reexport (safe) */ __webpack_require__.d(__webpack_exports__, "BinaryOperand", function() { return _expressions_expressions__WEBPACK_IMPORTED_MODULE_15__["BinaryOperand"]; });

/* harmony reexport (safe) */ __webpack_require__.d(__webpack_exports__, "Variable", function() { return _expressions_expressions__WEBPACK_IMPORTED_MODULE_15__["Variable"]; });

/* harmony reexport (safe) */ __webpack_require__.d(__webpack_exports__, "FunctionOperand", function() { return _expressions_expressions__WEBPACK_IMPORTED_MODULE_15__["FunctionOperand"]; });

/* harmony reexport (safe) */ __webpack_require__.d(__webpack_exports__, "ArrayOperand", function() { return _expressions_expressions__WEBPACK_IMPORTED_MODULE_15__["ArrayOperand"]; });

/* harmony import */ var _conditionsParser__WEBPACK_IMPORTED_MODULE_16__ = __webpack_require__(/*! ../../conditionsParser */ "./src/conditionsParser.ts");
/* harmony reexport (safe) */ __webpack_require__.d(__webpack_exports__, "ConditionsParser", function() { return _conditionsParser__WEBPACK_IMPORTED_MODULE_16__["ConditionsParser"]; });

/* harmony import */ var _conditionProcessValue__WEBPACK_IMPORTED_MODULE_17__ = __webpack_require__(/*! ../../conditionProcessValue */ "./src/conditionProcessValue.ts");
/* harmony reexport (safe) */ __webpack_require__.d(__webpack_exports__, "ProcessValue", function() { return _conditionProcessValue__WEBPACK_IMPORTED_MODULE_17__["ProcessValue"]; });

/* harmony import */ var _jsonobject__WEBPACK_IMPORTED_MODULE_18__ = __webpack_require__(/*! ../../jsonobject */ "./src/jsonobject.ts");
/* harmony reexport (safe) */ __webpack_require__.d(__webpack_exports__, "JsonError", function() { return _jsonobject__WEBPACK_IMPORTED_MODULE_18__["JsonError"]; });

/* harmony reexport (safe) */ __webpack_require__.d(__webpack_exports__, "JsonIncorrectTypeError", function() { return _jsonobject__WEBPACK_IMPORTED_MODULE_18__["JsonIncorrectTypeError"]; });

/* harmony reexport (safe) */ __webpack_require__.d(__webpack_exports__, "JsonMetadata", function() { return _jsonobject__WEBPACK_IMPORTED_MODULE_18__["JsonMetadata"]; });

/* harmony reexport (safe) */ __webpack_require__.d(__webpack_exports__, "JsonMetadataClass", function() { return _jsonobject__WEBPACK_IMPORTED_MODULE_18__["JsonMetadataClass"]; });

/* harmony reexport (safe) */ __webpack_require__.d(__webpack_exports__, "JsonMissingTypeError", function() { return _jsonobject__WEBPACK_IMPORTED_MODULE_18__["JsonMissingTypeError"]; });

/* harmony reexport (safe) */ __webpack_require__.d(__webpack_exports__, "JsonMissingTypeErrorBase", function() { return _jsonobject__WEBPACK_IMPORTED_MODULE_18__["JsonMissingTypeErrorBase"]; });

/* harmony reexport (safe) */ __webpack_require__.d(__webpack_exports__, "JsonObject", function() { return _jsonobject__WEBPACK_IMPORTED_MODULE_18__["JsonObject"]; });

/* harmony reexport (safe) */ __webpack_require__.d(__webpack_exports__, "JsonObjectProperty", function() { return _jsonobject__WEBPACK_IMPORTED_MODULE_18__["JsonObjectProperty"]; });

/* harmony reexport (safe) */ __webpack_require__.d(__webpack_exports__, "JsonRequiredPropertyError", function() { return _jsonobject__WEBPACK_IMPORTED_MODULE_18__["JsonRequiredPropertyError"]; });

/* harmony reexport (safe) */ __webpack_require__.d(__webpack_exports__, "JsonUnknownPropertyError", function() { return _jsonobject__WEBPACK_IMPORTED_MODULE_18__["JsonUnknownPropertyError"]; });

/* harmony reexport (safe) */ __webpack_require__.d(__webpack_exports__, "Serializer", function() { return _jsonobject__WEBPACK_IMPORTED_MODULE_18__["Serializer"]; });

/* harmony reexport (safe) */ __webpack_require__.d(__webpack_exports__, "property", function() { return _jsonobject__WEBPACK_IMPORTED_MODULE_18__["property"]; });

/* harmony reexport (safe) */ __webpack_require__.d(__webpack_exports__, "propertyArray", function() { return _jsonobject__WEBPACK_IMPORTED_MODULE_18__["propertyArray"]; });

/* harmony import */ var _question_matrixdropdownbase__WEBPACK_IMPORTED_MODULE_19__ = __webpack_require__(/*! ../../question_matrixdropdownbase */ "./src/question_matrixdropdownbase.ts");
/* harmony reexport (safe) */ __webpack_require__.d(__webpack_exports__, "MatrixDropdownCell", function() { return _question_matrixdropdownbase__WEBPACK_IMPORTED_MODULE_19__["MatrixDropdownCell"]; });

/* harmony reexport (safe) */ __webpack_require__.d(__webpack_exports__, "MatrixDropdownRowModelBase", function() { return _question_matrixdropdownbase__WEBPACK_IMPORTED_MODULE_19__["MatrixDropdownRowModelBase"]; });

/* harmony reexport (safe) */ __webpack_require__.d(__webpack_exports__, "QuestionMatrixDropdownModelBase", function() { return _question_matrixdropdownbase__WEBPACK_IMPORTED_MODULE_19__["QuestionMatrixDropdownModelBase"]; });

/* harmony import */ var _question_matrixdropdowncolumn__WEBPACK_IMPORTED_MODULE_20__ = __webpack_require__(/*! ../../question_matrixdropdowncolumn */ "./src/question_matrixdropdowncolumn.ts");
/* harmony reexport (safe) */ __webpack_require__.d(__webpack_exports__, "MatrixDropdownColumn", function() { return _question_matrixdropdowncolumn__WEBPACK_IMPORTED_MODULE_20__["MatrixDropdownColumn"]; });

/* harmony reexport (safe) */ __webpack_require__.d(__webpack_exports__, "matrixDropdownColumnTypes", function() { return _question_matrixdropdowncolumn__WEBPACK_IMPORTED_MODULE_20__["matrixDropdownColumnTypes"]; });

/* harmony import */ var _question_matrixdropdownrendered__WEBPACK_IMPORTED_MODULE_21__ = __webpack_require__(/*! ../../question_matrixdropdownrendered */ "./src/question_matrixdropdownrendered.ts");
/* harmony reexport (safe) */ __webpack_require__.d(__webpack_exports__, "QuestionMatrixDropdownRenderedCell", function() { return _question_matrixdropdownrendered__WEBPACK_IMPORTED_MODULE_21__["QuestionMatrixDropdownRenderedCell"]; });

/* harmony reexport (safe) */ __webpack_require__.d(__webpack_exports__, "QuestionMatrixDropdownRenderedRow", function() { return _question_matrixdropdownrendered__WEBPACK_IMPORTED_MODULE_21__["QuestionMatrixDropdownRenderedRow"]; });

/* harmony reexport (safe) */ __webpack_require__.d(__webpack_exports__, "QuestionMatrixDropdownRenderedTable", function() { return _question_matrixdropdownrendered__WEBPACK_IMPORTED_MODULE_21__["QuestionMatrixDropdownRenderedTable"]; });

/* harmony import */ var _question_matrixdropdown__WEBPACK_IMPORTED_MODULE_22__ = __webpack_require__(/*! ../../question_matrixdropdown */ "./src/question_matrixdropdown.ts");
/* harmony reexport (safe) */ __webpack_require__.d(__webpack_exports__, "MatrixDropdownRowModel", function() { return _question_matrixdropdown__WEBPACK_IMPORTED_MODULE_22__["MatrixDropdownRowModel"]; });

/* harmony reexport (safe) */ __webpack_require__.d(__webpack_exports__, "QuestionMatrixDropdownModel", function() { return _question_matrixdropdown__WEBPACK_IMPORTED_MODULE_22__["QuestionMatrixDropdownModel"]; });

/* harmony import */ var _question_matrixdynamic__WEBPACK_IMPORTED_MODULE_23__ = __webpack_require__(/*! ../../question_matrixdynamic */ "./src/question_matrixdynamic.ts");
/* harmony reexport (safe) */ __webpack_require__.d(__webpack_exports__, "MatrixDynamicRowModel", function() { return _question_matrixdynamic__WEBPACK_IMPORTED_MODULE_23__["MatrixDynamicRowModel"]; });

/* harmony reexport (safe) */ __webpack_require__.d(__webpack_exports__, "QuestionMatrixDynamicModel", function() { return _question_matrixdynamic__WEBPACK_IMPORTED_MODULE_23__["QuestionMatrixDynamicModel"]; });

/* harmony import */ var _question_matrix__WEBPACK_IMPORTED_MODULE_24__ = __webpack_require__(/*! ../../question_matrix */ "./src/question_matrix.ts");
/* harmony reexport (safe) */ __webpack_require__.d(__webpack_exports__, "MatrixRowModel", function() { return _question_matrix__WEBPACK_IMPORTED_MODULE_24__["MatrixRowModel"]; });

/* harmony reexport (safe) */ __webpack_require__.d(__webpack_exports__, "MatrixCells", function() { return _question_matrix__WEBPACK_IMPORTED_MODULE_24__["MatrixCells"]; });

/* harmony reexport (safe) */ __webpack_require__.d(__webpack_exports__, "QuestionMatrixModel", function() { return _question_matrix__WEBPACK_IMPORTED_MODULE_24__["QuestionMatrixModel"]; });

/* harmony import */ var _question_multipletext__WEBPACK_IMPORTED_MODULE_25__ = __webpack_require__(/*! ../../question_multipletext */ "./src/question_multipletext.ts");
/* harmony reexport (safe) */ __webpack_require__.d(__webpack_exports__, "MultipleTextItemModel", function() { return _question_multipletext__WEBPACK_IMPORTED_MODULE_25__["MultipleTextItemModel"]; });

/* harmony reexport (safe) */ __webpack_require__.d(__webpack_exports__, "QuestionMultipleTextModel", function() { return _question_multipletext__WEBPACK_IMPORTED_MODULE_25__["QuestionMultipleTextModel"]; });

/* harmony import */ var _panel__WEBPACK_IMPORTED_MODULE_26__ = __webpack_require__(/*! ../../panel */ "./src/panel.ts");
/* harmony reexport (safe) */ __webpack_require__.d(__webpack_exports__, "PanelModel", function() { return _panel__WEBPACK_IMPORTED_MODULE_26__["PanelModel"]; });

/* harmony reexport (safe) */ __webpack_require__.d(__webpack_exports__, "PanelModelBase", function() { return _panel__WEBPACK_IMPORTED_MODULE_26__["PanelModelBase"]; });

/* harmony reexport (safe) */ __webpack_require__.d(__webpack_exports__, "QuestionRowModel", function() { return _panel__WEBPACK_IMPORTED_MODULE_26__["QuestionRowModel"]; });

/* harmony import */ var _flowpanel__WEBPACK_IMPORTED_MODULE_27__ = __webpack_require__(/*! ../../flowpanel */ "./src/flowpanel.ts");
/* harmony reexport (safe) */ __webpack_require__.d(__webpack_exports__, "FlowPanelModel", function() { return _flowpanel__WEBPACK_IMPORTED_MODULE_27__["FlowPanelModel"]; });

/* harmony import */ var _page__WEBPACK_IMPORTED_MODULE_28__ = __webpack_require__(/*! ../../page */ "./src/page.ts");
/* harmony reexport (safe) */ __webpack_require__.d(__webpack_exports__, "PageModel", function() { return _page__WEBPACK_IMPORTED_MODULE_28__["PageModel"]; });

/* harmony import */ var _template_renderer__WEBPACK_IMPORTED_MODULE_29__ = __webpack_require__(/*! ../../template-renderer */ "./src/template-renderer.ts");
/* empty/unused harmony star reexport *//* harmony import */ var _defaultTitle__WEBPACK_IMPORTED_MODULE_30__ = __webpack_require__(/*! ../../defaultTitle */ "./src/defaultTitle.ts");
/* harmony reexport (safe) */ __webpack_require__.d(__webpack_exports__, "DefaultTitleModel", function() { return _defaultTitle__WEBPACK_IMPORTED_MODULE_30__["DefaultTitleModel"]; });

/* harmony import */ var _question__WEBPACK_IMPORTED_MODULE_31__ = __webpack_require__(/*! ../../question */ "./src/question.ts");
/* harmony reexport (safe) */ __webpack_require__.d(__webpack_exports__, "Question", function() { return _question__WEBPACK_IMPORTED_MODULE_31__["Question"]; });

/* harmony import */ var _questionnonvalue__WEBPACK_IMPORTED_MODULE_32__ = __webpack_require__(/*! ../../questionnonvalue */ "./src/questionnonvalue.ts");
/* harmony reexport (safe) */ __webpack_require__.d(__webpack_exports__, "QuestionNonValue", function() { return _questionnonvalue__WEBPACK_IMPORTED_MODULE_32__["QuestionNonValue"]; });

/* harmony import */ var _question_empty__WEBPACK_IMPORTED_MODULE_33__ = __webpack_require__(/*! ../../question_empty */ "./src/question_empty.ts");
/* harmony reexport (safe) */ __webpack_require__.d(__webpack_exports__, "QuestionEmptyModel", function() { return _question_empty__WEBPACK_IMPORTED_MODULE_33__["QuestionEmptyModel"]; });

/* harmony import */ var _question_baseselect__WEBPACK_IMPORTED_MODULE_34__ = __webpack_require__(/*! ../../question_baseselect */ "./src/question_baseselect.ts");
/* harmony reexport (safe) */ __webpack_require__.d(__webpack_exports__, "QuestionCheckboxBase", function() { return _question_baseselect__WEBPACK_IMPORTED_MODULE_34__["QuestionCheckboxBase"]; });

/* harmony reexport (safe) */ __webpack_require__.d(__webpack_exports__, "QuestionSelectBase", function() { return _question_baseselect__WEBPACK_IMPORTED_MODULE_34__["QuestionSelectBase"]; });

/* harmony import */ var _question_checkbox__WEBPACK_IMPORTED_MODULE_35__ = __webpack_require__(/*! ../../question_checkbox */ "./src/question_checkbox.ts");
/* harmony reexport (safe) */ __webpack_require__.d(__webpack_exports__, "QuestionCheckboxModel", function() { return _question_checkbox__WEBPACK_IMPORTED_MODULE_35__["QuestionCheckboxModel"]; });

/* harmony import */ var _question_ranking__WEBPACK_IMPORTED_MODULE_36__ = __webpack_require__(/*! ../../question_ranking */ "./src/question_ranking.ts");
/* harmony reexport (safe) */ __webpack_require__.d(__webpack_exports__, "QuestionRankingModel", function() { return _question_ranking__WEBPACK_IMPORTED_MODULE_36__["QuestionRankingModel"]; });

/* harmony import */ var _question_comment__WEBPACK_IMPORTED_MODULE_37__ = __webpack_require__(/*! ../../question_comment */ "./src/question_comment.ts");
/* harmony reexport (safe) */ __webpack_require__.d(__webpack_exports__, "QuestionCommentModel", function() { return _question_comment__WEBPACK_IMPORTED_MODULE_37__["QuestionCommentModel"]; });

/* harmony import */ var _question_dropdown__WEBPACK_IMPORTED_MODULE_38__ = __webpack_require__(/*! ../../question_dropdown */ "./src/question_dropdown.ts");
/* harmony reexport (safe) */ __webpack_require__.d(__webpack_exports__, "QuestionDropdownModel", function() { return _question_dropdown__WEBPACK_IMPORTED_MODULE_38__["QuestionDropdownModel"]; });

/* harmony import */ var _questionfactory__WEBPACK_IMPORTED_MODULE_39__ = __webpack_require__(/*! ../../questionfactory */ "./src/questionfactory.ts");
/* harmony reexport (safe) */ __webpack_require__.d(__webpack_exports__, "QuestionFactory", function() { return _questionfactory__WEBPACK_IMPORTED_MODULE_39__["QuestionFactory"]; });

/* harmony reexport (safe) */ __webpack_require__.d(__webpack_exports__, "ElementFactory", function() { return _questionfactory__WEBPACK_IMPORTED_MODULE_39__["ElementFactory"]; });

/* harmony import */ var _question_file__WEBPACK_IMPORTED_MODULE_40__ = __webpack_require__(/*! ../../question_file */ "./src/question_file.ts");
/* harmony reexport (safe) */ __webpack_require__.d(__webpack_exports__, "QuestionFileModel", function() { return _question_file__WEBPACK_IMPORTED_MODULE_40__["QuestionFileModel"]; });

/* harmony import */ var _question_html__WEBPACK_IMPORTED_MODULE_41__ = __webpack_require__(/*! ../../question_html */ "./src/question_html.ts");
/* harmony reexport (safe) */ __webpack_require__.d(__webpack_exports__, "QuestionHtmlModel", function() { return _question_html__WEBPACK_IMPORTED_MODULE_41__["QuestionHtmlModel"]; });

/* harmony import */ var _question_radiogroup__WEBPACK_IMPORTED_MODULE_42__ = __webpack_require__(/*! ../../question_radiogroup */ "./src/question_radiogroup.ts");
/* harmony reexport (safe) */ __webpack_require__.d(__webpack_exports__, "QuestionRadiogroupModel", function() { return _question_radiogroup__WEBPACK_IMPORTED_MODULE_42__["QuestionRadiogroupModel"]; });

/* harmony import */ var _question_rating__WEBPACK_IMPORTED_MODULE_43__ = __webpack_require__(/*! ../../question_rating */ "./src/question_rating.ts");
/* harmony reexport (safe) */ __webpack_require__.d(__webpack_exports__, "QuestionRatingModel", function() { return _question_rating__WEBPACK_IMPORTED_MODULE_43__["QuestionRatingModel"]; });

/* harmony import */ var _question_expression__WEBPACK_IMPORTED_MODULE_44__ = __webpack_require__(/*! ../../question_expression */ "./src/question_expression.ts");
/* harmony reexport (safe) */ __webpack_require__.d(__webpack_exports__, "QuestionExpressionModel", function() { return _question_expression__WEBPACK_IMPORTED_MODULE_44__["QuestionExpressionModel"]; });

/* harmony import */ var _question_text__WEBPACK_IMPORTED_MODULE_45__ = __webpack_require__(/*! ../../question_text */ "./src/question_text.ts");
/* harmony reexport (safe) */ __webpack_require__.d(__webpack_exports__, "QuestionTextModel", function() { return _question_text__WEBPACK_IMPORTED_MODULE_45__["QuestionTextModel"]; });

/* harmony import */ var _question_boolean__WEBPACK_IMPORTED_MODULE_46__ = __webpack_require__(/*! ../../question_boolean */ "./src/question_boolean.ts");
/* harmony reexport (safe) */ __webpack_require__.d(__webpack_exports__, "QuestionBooleanModel", function() { return _question_boolean__WEBPACK_IMPORTED_MODULE_46__["QuestionBooleanModel"]; });

/* harmony import */ var _question_imagepicker__WEBPACK_IMPORTED_MODULE_47__ = __webpack_require__(/*! ../../question_imagepicker */ "./src/question_imagepicker.ts");
/* harmony reexport (safe) */ __webpack_require__.d(__webpack_exports__, "QuestionImagePickerModel", function() { return _question_imagepicker__WEBPACK_IMPORTED_MODULE_47__["QuestionImagePickerModel"]; });

/* harmony reexport (safe) */ __webpack_require__.d(__webpack_exports__, "ImageItemValue", function() { return _question_imagepicker__WEBPACK_IMPORTED_MODULE_47__["ImageItemValue"]; });

/* harmony import */ var _question_image__WEBPACK_IMPORTED_MODULE_48__ = __webpack_require__(/*! ../../question_image */ "./src/question_image.ts");
/* harmony reexport (safe) */ __webpack_require__.d(__webpack_exports__, "QuestionImageModel", function() { return _question_image__WEBPACK_IMPORTED_MODULE_48__["QuestionImageModel"]; });

/* harmony import */ var _question_signaturepad__WEBPACK_IMPORTED_MODULE_49__ = __webpack_require__(/*! ../../question_signaturepad */ "./src/question_signaturepad.ts");
/* harmony reexport (safe) */ __webpack_require__.d(__webpack_exports__, "QuestionSignaturePadModel", function() { return _question_signaturepad__WEBPACK_IMPORTED_MODULE_49__["QuestionSignaturePadModel"]; });

/* harmony import */ var _question_paneldynamic__WEBPACK_IMPORTED_MODULE_50__ = __webpack_require__(/*! ../../question_paneldynamic */ "./src/question_paneldynamic.ts");
/* harmony reexport (safe) */ __webpack_require__.d(__webpack_exports__, "QuestionPanelDynamicModel", function() { return _question_paneldynamic__WEBPACK_IMPORTED_MODULE_50__["QuestionPanelDynamicModel"]; });

/* harmony reexport (safe) */ __webpack_require__.d(__webpack_exports__, "QuestionPanelDynamicItem", function() { return _question_paneldynamic__WEBPACK_IMPORTED_MODULE_50__["QuestionPanelDynamicItem"]; });

/* harmony import */ var _surveytimer__WEBPACK_IMPORTED_MODULE_51__ = __webpack_require__(/*! ../../surveytimer */ "./src/surveytimer.ts");
/* harmony reexport (safe) */ __webpack_require__.d(__webpack_exports__, "SurveyTimer", function() { return _surveytimer__WEBPACK_IMPORTED_MODULE_51__["SurveyTimer"]; });

/* harmony import */ var _surveyProgress__WEBPACK_IMPORTED_MODULE_52__ = __webpack_require__(/*! ../../surveyProgress */ "./src/surveyProgress.ts");
/* harmony reexport (safe) */ __webpack_require__.d(__webpack_exports__, "SurveyProgressModel", function() { return _surveyProgress__WEBPACK_IMPORTED_MODULE_52__["SurveyProgressModel"]; });

/* harmony import */ var _surveyProgressButtons__WEBPACK_IMPORTED_MODULE_53__ = __webpack_require__(/*! ../../surveyProgressButtons */ "./src/surveyProgressButtons.ts");
/* harmony reexport (safe) */ __webpack_require__.d(__webpack_exports__, "SurveyProgressButtonsModel", function() { return _surveyProgressButtons__WEBPACK_IMPORTED_MODULE_53__["SurveyProgressButtonsModel"]; });

/* harmony import */ var _survey__WEBPACK_IMPORTED_MODULE_54__ = __webpack_require__(/*! ../../survey */ "./src/survey.ts");
/* harmony reexport (safe) */ __webpack_require__.d(__webpack_exports__, "SurveyModel", function() { return _survey__WEBPACK_IMPORTED_MODULE_54__["SurveyModel"]; });

/* harmony import */ var _trigger__WEBPACK_IMPORTED_MODULE_55__ = __webpack_require__(/*! ../../trigger */ "./src/trigger.ts");
/* harmony reexport (safe) */ __webpack_require__.d(__webpack_exports__, "SurveyTrigger", function() { return _trigger__WEBPACK_IMPORTED_MODULE_55__["SurveyTrigger"]; });

/* harmony reexport (safe) */ __webpack_require__.d(__webpack_exports__, "SurveyTriggerComplete", function() { return _trigger__WEBPACK_IMPORTED_MODULE_55__["SurveyTriggerComplete"]; });

/* harmony reexport (safe) */ __webpack_require__.d(__webpack_exports__, "SurveyTriggerSetValue", function() { return _trigger__WEBPACK_IMPORTED_MODULE_55__["SurveyTriggerSetValue"]; });

/* harmony reexport (safe) */ __webpack_require__.d(__webpack_exports__, "SurveyTriggerVisible", function() { return _trigger__WEBPACK_IMPORTED_MODULE_55__["SurveyTriggerVisible"]; });

/* harmony reexport (safe) */ __webpack_require__.d(__webpack_exports__, "SurveyTriggerCopyValue", function() { return _trigger__WEBPACK_IMPORTED_MODULE_55__["SurveyTriggerCopyValue"]; });

/* harmony reexport (safe) */ __webpack_require__.d(__webpack_exports__, "SurveyTriggerRunExpression", function() { return _trigger__WEBPACK_IMPORTED_MODULE_55__["SurveyTriggerRunExpression"]; });

/* harmony reexport (safe) */ __webpack_require__.d(__webpack_exports__, "Trigger", function() { return _trigger__WEBPACK_IMPORTED_MODULE_55__["Trigger"]; });

/* harmony import */ var _surveyWindow__WEBPACK_IMPORTED_MODULE_56__ = __webpack_require__(/*! ../../surveyWindow */ "./src/surveyWindow.ts");
/* harmony reexport (safe) */ __webpack_require__.d(__webpack_exports__, "SurveyWindowModel", function() { return _surveyWindow__WEBPACK_IMPORTED_MODULE_56__["SurveyWindowModel"]; });

/* harmony import */ var _textPreProcessor__WEBPACK_IMPORTED_MODULE_57__ = __webpack_require__(/*! ../../textPreProcessor */ "./src/textPreProcessor.ts");
/* harmony reexport (safe) */ __webpack_require__.d(__webpack_exports__, "TextPreProcessor", function() { return _textPreProcessor__WEBPACK_IMPORTED_MODULE_57__["TextPreProcessor"]; });

/* harmony import */ var _dxSurveyService__WEBPACK_IMPORTED_MODULE_58__ = __webpack_require__(/*! ../../dxSurveyService */ "./src/dxSurveyService.ts");
/* harmony reexport (safe) */ __webpack_require__.d(__webpack_exports__, "dxSurveyService", function() { return _dxSurveyService__WEBPACK_IMPORTED_MODULE_58__["dxSurveyService"]; });

/* harmony import */ var _localization_english__WEBPACK_IMPORTED_MODULE_59__ = __webpack_require__(/*! ../../localization/english */ "./src/localization/english.ts");
/* harmony reexport (safe) */ __webpack_require__.d(__webpack_exports__, "englishStrings", function() { return _localization_english__WEBPACK_IMPORTED_MODULE_59__["englishStrings"]; });

/* harmony import */ var _surveyStrings__WEBPACK_IMPORTED_MODULE_60__ = __webpack_require__(/*! ../../surveyStrings */ "./src/surveyStrings.ts");
/* harmony reexport (safe) */ __webpack_require__.d(__webpack_exports__, "surveyLocalization", function() { return _surveyStrings__WEBPACK_IMPORTED_MODULE_60__["surveyLocalization"]; });

/* harmony reexport (safe) */ __webpack_require__.d(__webpack_exports__, "surveyStrings", function() { return _surveyStrings__WEBPACK_IMPORTED_MODULE_60__["surveyStrings"]; });

/* harmony import */ var _questionCustomWidgets__WEBPACK_IMPORTED_MODULE_61__ = __webpack_require__(/*! ../../questionCustomWidgets */ "./src/questionCustomWidgets.ts");
/* harmony reexport (safe) */ __webpack_require__.d(__webpack_exports__, "QuestionCustomWidget", function() { return _questionCustomWidgets__WEBPACK_IMPORTED_MODULE_61__["QuestionCustomWidget"]; });

/* harmony reexport (safe) */ __webpack_require__.d(__webpack_exports__, "CustomWidgetCollection", function() { return _questionCustomWidgets__WEBPACK_IMPORTED_MODULE_61__["CustomWidgetCollection"]; });

/* harmony import */ var _question_custom__WEBPACK_IMPORTED_MODULE_62__ = __webpack_require__(/*! ../../question_custom */ "./src/question_custom.ts");
/* harmony reexport (safe) */ __webpack_require__.d(__webpack_exports__, "QuestionCustomModel", function() { return _question_custom__WEBPACK_IMPORTED_MODULE_62__["QuestionCustomModel"]; });

/* harmony reexport (safe) */ __webpack_require__.d(__webpack_exports__, "QuestionCompositeModel", function() { return _question_custom__WEBPACK_IMPORTED_MODULE_62__["QuestionCompositeModel"]; });

/* harmony reexport (safe) */ __webpack_require__.d(__webpack_exports__, "ComponentQuestionJSON", function() { return _question_custom__WEBPACK_IMPORTED_MODULE_62__["ComponentQuestionJSON"]; });

/* harmony reexport (safe) */ __webpack_require__.d(__webpack_exports__, "ComponentCollection", function() { return _question_custom__WEBPACK_IMPORTED_MODULE_62__["ComponentCollection"]; });

/* harmony import */ var _stylesmanager__WEBPACK_IMPORTED_MODULE_63__ = __webpack_require__(/*! ../../stylesmanager */ "./src/stylesmanager.ts");
/* harmony reexport (safe) */ __webpack_require__.d(__webpack_exports__, "StylesManager", function() { return _stylesmanager__WEBPACK_IMPORTED_MODULE_63__["StylesManager"]; });

/* harmony import */ var _list__WEBPACK_IMPORTED_MODULE_64__ = __webpack_require__(/*! ../../list */ "./src/list.ts");
/* harmony reexport (safe) */ __webpack_require__.d(__webpack_exports__, "ListModel", function() { return _list__WEBPACK_IMPORTED_MODULE_64__["ListModel"]; });

/* harmony import */ var _popup__WEBPACK_IMPORTED_MODULE_65__ = __webpack_require__(/*! ../../popup */ "./src/popup.ts");
/* harmony reexport (safe) */ __webpack_require__.d(__webpack_exports__, "PopupModel", function() { return _popup__WEBPACK_IMPORTED_MODULE_65__["PopupModel"]; });

/* harmony reexport (safe) */ __webpack_require__.d(__webpack_exports__, "PopupBaseViewModel", function() { return _popup__WEBPACK_IMPORTED_MODULE_65__["PopupBaseViewModel"]; });

/* harmony reexport (safe) */ __webpack_require__.d(__webpack_exports__, "createPopupModalViewModel", function() { return _popup__WEBPACK_IMPORTED_MODULE_65__["createPopupModalViewModel"]; });

/* harmony import */ var _question_buttongroup__WEBPACK_IMPORTED_MODULE_66__ = __webpack_require__(/*! ../../question_buttongroup */ "./src/question_buttongroup.ts");
/* harmony reexport (safe) */ __webpack_require__.d(__webpack_exports__, "QuestionButtonGroupModel", function() { return _question_buttongroup__WEBPACK_IMPORTED_MODULE_66__["QuestionButtonGroupModel"]; });

/* harmony reexport (safe) */ __webpack_require__.d(__webpack_exports__, "ButtonGroupItemModel", function() { return _question_buttongroup__WEBPACK_IMPORTED_MODULE_66__["ButtonGroupItemModel"]; });

/* harmony reexport (safe) */ __webpack_require__.d(__webpack_exports__, "ButtonGroupItemValue", function() { return _question_buttongroup__WEBPACK_IMPORTED_MODULE_66__["ButtonGroupItemValue"]; });

/* harmony import */ var _utils_is_mobile__WEBPACK_IMPORTED_MODULE_67__ = __webpack_require__(/*! ../../utils/is-mobile */ "./src/utils/is-mobile.ts");
/* harmony reexport (safe) */ __webpack_require__.d(__webpack_exports__, "IsMobile", function() { return _utils_is_mobile__WEBPACK_IMPORTED_MODULE_67__["IsMobile"]; });

/* harmony import */ var _utils_utils__WEBPACK_IMPORTED_MODULE_68__ = __webpack_require__(/*! ../../utils/utils */ "./src/utils/utils.ts");
/* harmony reexport (safe) */ __webpack_require__.d(__webpack_exports__, "confirmAction", function() { return _utils_utils__WEBPACK_IMPORTED_MODULE_68__["confirmAction"]; });

/* harmony reexport (safe) */ __webpack_require__.d(__webpack_exports__, "detectIEOrEdge", function() { return _utils_utils__WEBPACK_IMPORTED_MODULE_68__["detectIEOrEdge"]; });

/* harmony reexport (safe) */ __webpack_require__.d(__webpack_exports__, "doKey2ClickUp", function() { return _utils_utils__WEBPACK_IMPORTED_MODULE_68__["doKey2ClickUp"]; });

/* harmony reexport (safe) */ __webpack_require__.d(__webpack_exports__, "doKey2ClickDown", function() { return _utils_utils__WEBPACK_IMPORTED_MODULE_68__["doKey2ClickDown"]; });

/* harmony reexport (safe) */ __webpack_require__.d(__webpack_exports__, "loadFileFromBase64", function() { return _utils_utils__WEBPACK_IMPORTED_MODULE_68__["loadFileFromBase64"]; });

/* harmony reexport (safe) */ __webpack_require__.d(__webpack_exports__, "increaseHeightByContent", function() { return _utils_utils__WEBPACK_IMPORTED_MODULE_68__["increaseHeightByContent"]; });

/* harmony reexport (safe) */ __webpack_require__.d(__webpack_exports__, "createSvg", function() { return _utils_utils__WEBPACK_IMPORTED_MODULE_68__["createSvg"]; });

/* harmony import */ var _utils_cssClassBuilder__WEBPACK_IMPORTED_MODULE_69__ = __webpack_require__(/*! ../../utils/cssClassBuilder */ "./src/utils/cssClassBuilder.ts");
/* harmony reexport (safe) */ __webpack_require__.d(__webpack_exports__, "CssClassBuilder", function() { return _utils_cssClassBuilder__WEBPACK_IMPORTED_MODULE_69__["CssClassBuilder"]; });

/* harmony import */ var _defaultCss_cssstandard__WEBPACK_IMPORTED_MODULE_70__ = __webpack_require__(/*! ../../defaultCss/cssstandard */ "./src/defaultCss/cssstandard.ts");
/* harmony reexport (safe) */ __webpack_require__.d(__webpack_exports__, "surveyCss", function() { return _defaultCss_cssstandard__WEBPACK_IMPORTED_MODULE_70__["surveyCss"]; });

/* harmony import */ var _dragdrop_survey_elements__WEBPACK_IMPORTED_MODULE_71__ = __webpack_require__(/*! ../../dragdrop/survey-elements */ "./src/dragdrop/survey-elements.ts");
/* harmony reexport (safe) */ __webpack_require__.d(__webpack_exports__, "DragDropSurveyElements", function() { return _dragdrop_survey_elements__WEBPACK_IMPORTED_MODULE_71__["DragDropSurveyElements"]; });

/* harmony import */ var _dragdrop_choices__WEBPACK_IMPORTED_MODULE_72__ = __webpack_require__(/*! ../../dragdrop/choices */ "./src/dragdrop/choices.ts");
/* harmony reexport (safe) */ __webpack_require__.d(__webpack_exports__, "DragDropChoices", function() { return _dragdrop_choices__WEBPACK_IMPORTED_MODULE_72__["DragDropChoices"]; });

// styles

//import "../../modern.scss";
var Version;
Version = "".concat("1.9.1");




























































// export { cultureInfo } from "../../cultureInfo";










//Uncomment to include the "date" question type.
//export {default as QuestionDateModel} from "../../plugins/question_date";




/***/ }),

/***/ "./src/entries/core.ts":
/*!*****************************!*\
  !*** ./src/entries/core.ts ***!
  \*****************************/
/*! exports provided: Version, settings, Helpers, AnswerCountValidator, EmailValidator, NumericValidator, RegexValidator, SurveyValidator, TextValidator, ValidatorResult, ExpressionValidator, ValidatorRunner, ItemValue, Base, Event, ArrayChanges, ComputedUpdater, SurveyError, SurveyElementCore, SurveyElement, DragTypeOverMeEnum, CalculatedValue, CustomError, AnswerRequiredError, OneAnswerRequiredError, RequreNumericError, ExceedSizeError, LocalizableString, LocalizableStrings, HtmlConditionItem, UrlConditionItem, ChoicesRestful, ChoicesRestfull, FunctionFactory, registerFunction, ConditionRunner, ExpressionRunner, Operand, Const, BinaryOperand, Variable, FunctionOperand, ArrayOperand, ConditionsParser, ProcessValue, JsonError, JsonIncorrectTypeError, JsonMetadata, JsonMetadataClass, JsonMissingTypeError, JsonMissingTypeErrorBase, JsonObject, JsonObjectProperty, JsonRequiredPropertyError, JsonUnknownPropertyError, Serializer, property, propertyArray, MatrixDropdownCell, MatrixDropdownRowModelBase, QuestionMatrixDropdownModelBase, MatrixDropdownColumn, matrixDropdownColumnTypes, QuestionMatrixDropdownRenderedCell, QuestionMatrixDropdownRenderedRow, QuestionMatrixDropdownRenderedTable, MatrixDropdownRowModel, QuestionMatrixDropdownModel, MatrixDynamicRowModel, QuestionMatrixDynamicModel, MatrixRowModel, MatrixCells, QuestionMatrixModel, MultipleTextItemModel, QuestionMultipleTextModel, PanelModel, PanelModelBase, QuestionRowModel, FlowPanelModel, PageModel, DefaultTitleModel, Question, QuestionNonValue, QuestionEmptyModel, QuestionCheckboxBase, QuestionSelectBase, QuestionCheckboxModel, QuestionRankingModel, QuestionCommentModel, QuestionDropdownModel, QuestionFactory, ElementFactory, QuestionFileModel, QuestionHtmlModel, QuestionRadiogroupModel, QuestionRatingModel, QuestionExpressionModel, QuestionTextModel, QuestionBooleanModel, QuestionImagePickerModel, ImageItemValue, QuestionImageModel, QuestionSignaturePadModel, QuestionPanelDynamicModel, QuestionPanelDynamicItem, SurveyTimer, SurveyProgressModel, SurveyProgressButtonsModel, SurveyModel, SurveyTrigger, SurveyTriggerComplete, SurveyTriggerSetValue, SurveyTriggerVisible, SurveyTriggerCopyValue, SurveyTriggerRunExpression, Trigger, SurveyWindowModel, TextPreProcessor, dxSurveyService, englishStrings, surveyLocalization, surveyStrings, QuestionCustomWidget, CustomWidgetCollection, QuestionCustomModel, QuestionCompositeModel, ComponentQuestionJSON, ComponentCollection, StylesManager, ListModel, PopupModel, PopupBaseViewModel, createPopupModalViewModel, QuestionButtonGroupModel, ButtonGroupItemModel, ButtonGroupItemValue, IsMobile, confirmAction, detectIEOrEdge, doKey2ClickUp, doKey2ClickDown, loadFileFromBase64, increaseHeightByContent, createSvg, CssClassBuilder, surveyCss, DragDropSurveyElements, DragDropChoices, defaultStandardCss, defaultBootstrapCss, defaultBootstrapMaterialCss, defaultV2Css, modernCss, SvgBundleViewModel, RendererFactory, ResponsivityManager, VerticalResponsivityManager, unwrap, Action, AdaptiveActionContainer, ActionContainer, TooltipManager */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony import */ var _chunks_model__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./chunks/model */ "./src/entries/chunks/model.ts");
/* harmony reexport (safe) */ __webpack_require__.d(__webpack_exports__, "Version", function() { return _chunks_model__WEBPACK_IMPORTED_MODULE_0__["Version"]; });

/* harmony reexport (safe) */ __webpack_require__.d(__webpack_exports__, "settings", function() { return _chunks_model__WEBPACK_IMPORTED_MODULE_0__["settings"]; });

/* harmony reexport (safe) */ __webpack_require__.d(__webpack_exports__, "Helpers", function() { return _chunks_model__WEBPACK_IMPORTED_MODULE_0__["Helpers"]; });

/* harmony reexport (safe) */ __webpack_require__.d(__webpack_exports__, "AnswerCountValidator", function() { return _chunks_model__WEBPACK_IMPORTED_MODULE_0__["AnswerCountValidator"]; });

/* harmony reexport (safe) */ __webpack_require__.d(__webpack_exports__, "EmailValidator", function() { return _chunks_model__WEBPACK_IMPORTED_MODULE_0__["EmailValidator"]; });

/* harmony reexport (safe) */ __webpack_require__.d(__webpack_exports__, "NumericValidator", function() { return _chunks_model__WEBPACK_IMPORTED_MODULE_0__["NumericValidator"]; });

/* harmony reexport (safe) */ __webpack_require__.d(__webpack_exports__, "RegexValidator", function() { return _chunks_model__WEBPACK_IMPORTED_MODULE_0__["RegexValidator"]; });

/* harmony reexport (safe) */ __webpack_require__.d(__webpack_exports__, "SurveyValidator", function() { return _chunks_model__WEBPACK_IMPORTED_MODULE_0__["SurveyValidator"]; });

/* harmony reexport (safe) */ __webpack_require__.d(__webpack_exports__, "TextValidator", function() { return _chunks_model__WEBPACK_IMPORTED_MODULE_0__["TextValidator"]; });

/* harmony reexport (safe) */ __webpack_require__.d(__webpack_exports__, "ValidatorResult", function() { return _chunks_model__WEBPACK_IMPORTED_MODULE_0__["ValidatorResult"]; });

/* harmony reexport (safe) */ __webpack_require__.d(__webpack_exports__, "ExpressionValidator", function() { return _chunks_model__WEBPACK_IMPORTED_MODULE_0__["ExpressionValidator"]; });

/* harmony reexport (safe) */ __webpack_require__.d(__webpack_exports__, "ValidatorRunner", function() { return _chunks_model__WEBPACK_IMPORTED_MODULE_0__["ValidatorRunner"]; });

/* harmony reexport (safe) */ __webpack_require__.d(__webpack_exports__, "ItemValue", function() { return _chunks_model__WEBPACK_IMPORTED_MODULE_0__["ItemValue"]; });

/* harmony reexport (safe) */ __webpack_require__.d(__webpack_exports__, "Base", function() { return _chunks_model__WEBPACK_IMPORTED_MODULE_0__["Base"]; });

/* harmony reexport (safe) */ __webpack_require__.d(__webpack_exports__, "Event", function() { return _chunks_model__WEBPACK_IMPORTED_MODULE_0__["Event"]; });

/* harmony reexport (safe) */ __webpack_require__.d(__webpack_exports__, "ArrayChanges", function() { return _chunks_model__WEBPACK_IMPORTED_MODULE_0__["ArrayChanges"]; });

/* harmony reexport (safe) */ __webpack_require__.d(__webpack_exports__, "ComputedUpdater", function() { return _chunks_model__WEBPACK_IMPORTED_MODULE_0__["ComputedUpdater"]; });

/* harmony reexport (safe) */ __webpack_require__.d(__webpack_exports__, "SurveyError", function() { return _chunks_model__WEBPACK_IMPORTED_MODULE_0__["SurveyError"]; });

/* harmony reexport (safe) */ __webpack_require__.d(__webpack_exports__, "SurveyElementCore", function() { return _chunks_model__WEBPACK_IMPORTED_MODULE_0__["SurveyElementCore"]; });

/* harmony reexport (safe) */ __webpack_require__.d(__webpack_exports__, "SurveyElement", function() { return _chunks_model__WEBPACK_IMPORTED_MODULE_0__["SurveyElement"]; });

/* harmony reexport (safe) */ __webpack_require__.d(__webpack_exports__, "DragTypeOverMeEnum", function() { return _chunks_model__WEBPACK_IMPORTED_MODULE_0__["DragTypeOverMeEnum"]; });

/* harmony reexport (safe) */ __webpack_require__.d(__webpack_exports__, "CalculatedValue", function() { return _chunks_model__WEBPACK_IMPORTED_MODULE_0__["CalculatedValue"]; });

/* harmony reexport (safe) */ __webpack_require__.d(__webpack_exports__, "CustomError", function() { return _chunks_model__WEBPACK_IMPORTED_MODULE_0__["CustomError"]; });

/* harmony reexport (safe) */ __webpack_require__.d(__webpack_exports__, "AnswerRequiredError", function() { return _chunks_model__WEBPACK_IMPORTED_MODULE_0__["AnswerRequiredError"]; });

/* harmony reexport (safe) */ __webpack_require__.d(__webpack_exports__, "OneAnswerRequiredError", function() { return _chunks_model__WEBPACK_IMPORTED_MODULE_0__["OneAnswerRequiredError"]; });

/* harmony reexport (safe) */ __webpack_require__.d(__webpack_exports__, "RequreNumericError", function() { return _chunks_model__WEBPACK_IMPORTED_MODULE_0__["RequreNumericError"]; });

/* harmony reexport (safe) */ __webpack_require__.d(__webpack_exports__, "ExceedSizeError", function() { return _chunks_model__WEBPACK_IMPORTED_MODULE_0__["ExceedSizeError"]; });

/* harmony reexport (safe) */ __webpack_require__.d(__webpack_exports__, "LocalizableString", function() { return _chunks_model__WEBPACK_IMPORTED_MODULE_0__["LocalizableString"]; });

/* harmony reexport (safe) */ __webpack_require__.d(__webpack_exports__, "LocalizableStrings", function() { return _chunks_model__WEBPACK_IMPORTED_MODULE_0__["LocalizableStrings"]; });

/* harmony reexport (safe) */ __webpack_require__.d(__webpack_exports__, "HtmlConditionItem", function() { return _chunks_model__WEBPACK_IMPORTED_MODULE_0__["HtmlConditionItem"]; });

/* harmony reexport (safe) */ __webpack_require__.d(__webpack_exports__, "UrlConditionItem", function() { return _chunks_model__WEBPACK_IMPORTED_MODULE_0__["UrlConditionItem"]; });

/* harmony reexport (safe) */ __webpack_require__.d(__webpack_exports__, "ChoicesRestful", function() { return _chunks_model__WEBPACK_IMPORTED_MODULE_0__["ChoicesRestful"]; });

/* harmony reexport (safe) */ __webpack_require__.d(__webpack_exports__, "ChoicesRestfull", function() { return _chunks_model__WEBPACK_IMPORTED_MODULE_0__["ChoicesRestfull"]; });

/* harmony reexport (safe) */ __webpack_require__.d(__webpack_exports__, "FunctionFactory", function() { return _chunks_model__WEBPACK_IMPORTED_MODULE_0__["FunctionFactory"]; });

/* harmony reexport (safe) */ __webpack_require__.d(__webpack_exports__, "registerFunction", function() { return _chunks_model__WEBPACK_IMPORTED_MODULE_0__["registerFunction"]; });

/* harmony reexport (safe) */ __webpack_require__.d(__webpack_exports__, "ConditionRunner", function() { return _chunks_model__WEBPACK_IMPORTED_MODULE_0__["ConditionRunner"]; });

/* harmony reexport (safe) */ __webpack_require__.d(__webpack_exports__, "ExpressionRunner", function() { return _chunks_model__WEBPACK_IMPORTED_MODULE_0__["ExpressionRunner"]; });

/* harmony reexport (safe) */ __webpack_require__.d(__webpack_exports__, "Operand", function() { return _chunks_model__WEBPACK_IMPORTED_MODULE_0__["Operand"]; });

/* harmony reexport (safe) */ __webpack_require__.d(__webpack_exports__, "Const", function() { return _chunks_model__WEBPACK_IMPORTED_MODULE_0__["Const"]; });

/* harmony reexport (safe) */ __webpack_require__.d(__webpack_exports__, "BinaryOperand", function() { return _chunks_model__WEBPACK_IMPORTED_MODULE_0__["BinaryOperand"]; });

/* harmony reexport (safe) */ __webpack_require__.d(__webpack_exports__, "Variable", function() { return _chunks_model__WEBPACK_IMPORTED_MODULE_0__["Variable"]; });

/* harmony reexport (safe) */ __webpack_require__.d(__webpack_exports__, "FunctionOperand", function() { return _chunks_model__WEBPACK_IMPORTED_MODULE_0__["FunctionOperand"]; });

/* harmony reexport (safe) */ __webpack_require__.d(__webpack_exports__, "ArrayOperand", function() { return _chunks_model__WEBPACK_IMPORTED_MODULE_0__["ArrayOperand"]; });

/* harmony reexport (safe) */ __webpack_require__.d(__webpack_exports__, "ConditionsParser", function() { return _chunks_model__WEBPACK_IMPORTED_MODULE_0__["ConditionsParser"]; });

/* harmony reexport (safe) */ __webpack_require__.d(__webpack_exports__, "ProcessValue", function() { return _chunks_model__WEBPACK_IMPORTED_MODULE_0__["ProcessValue"]; });

/* harmony reexport (safe) */ __webpack_require__.d(__webpack_exports__, "JsonError", function() { return _chunks_model__WEBPACK_IMPORTED_MODULE_0__["JsonError"]; });

/* harmony reexport (safe) */ __webpack_require__.d(__webpack_exports__, "JsonIncorrectTypeError", function() { return _chunks_model__WEBPACK_IMPORTED_MODULE_0__["JsonIncorrectTypeError"]; });

/* harmony reexport (safe) */ __webpack_require__.d(__webpack_exports__, "JsonMetadata", function() { return _chunks_model__WEBPACK_IMPORTED_MODULE_0__["JsonMetadata"]; });

/* harmony reexport (safe) */ __webpack_require__.d(__webpack_exports__, "JsonMetadataClass", function() { return _chunks_model__WEBPACK_IMPORTED_MODULE_0__["JsonMetadataClass"]; });

/* harmony reexport (safe) */ __webpack_require__.d(__webpack_exports__, "JsonMissingTypeError", function() { return _chunks_model__WEBPACK_IMPORTED_MODULE_0__["JsonMissingTypeError"]; });

/* harmony reexport (safe) */ __webpack_require__.d(__webpack_exports__, "JsonMissingTypeErrorBase", function() { return _chunks_model__WEBPACK_IMPORTED_MODULE_0__["JsonMissingTypeErrorBase"]; });

/* harmony reexport (safe) */ __webpack_require__.d(__webpack_exports__, "JsonObject", function() { return _chunks_model__WEBPACK_IMPORTED_MODULE_0__["JsonObject"]; });

/* harmony reexport (safe) */ __webpack_require__.d(__webpack_exports__, "JsonObjectProperty", function() { return _chunks_model__WEBPACK_IMPORTED_MODULE_0__["JsonObjectProperty"]; });

/* harmony reexport (safe) */ __webpack_require__.d(__webpack_exports__, "JsonRequiredPropertyError", function() { return _chunks_model__WEBPACK_IMPORTED_MODULE_0__["JsonRequiredPropertyError"]; });

/* harmony reexport (safe) */ __webpack_require__.d(__webpack_exports__, "JsonUnknownPropertyError", function() { return _chunks_model__WEBPACK_IMPORTED_MODULE_0__["JsonUnknownPropertyError"]; });

/* harmony reexport (safe) */ __webpack_require__.d(__webpack_exports__, "Serializer", function() { return _chunks_model__WEBPACK_IMPORTED_MODULE_0__["Serializer"]; });

/* harmony reexport (safe) */ __webpack_require__.d(__webpack_exports__, "property", function() { return _chunks_model__WEBPACK_IMPORTED_MODULE_0__["property"]; });

/* harmony reexport (safe) */ __webpack_require__.d(__webpack_exports__, "propertyArray", function() { return _chunks_model__WEBPACK_IMPORTED_MODULE_0__["propertyArray"]; });

/* harmony reexport (safe) */ __webpack_require__.d(__webpack_exports__, "MatrixDropdownCell", function() { return _chunks_model__WEBPACK_IMPORTED_MODULE_0__["MatrixDropdownCell"]; });

/* harmony reexport (safe) */ __webpack_require__.d(__webpack_exports__, "MatrixDropdownRowModelBase", function() { return _chunks_model__WEBPACK_IMPORTED_MODULE_0__["MatrixDropdownRowModelBase"]; });

/* harmony reexport (safe) */ __webpack_require__.d(__webpack_exports__, "QuestionMatrixDropdownModelBase", function() { return _chunks_model__WEBPACK_IMPORTED_MODULE_0__["QuestionMatrixDropdownModelBase"]; });

/* harmony reexport (safe) */ __webpack_require__.d(__webpack_exports__, "MatrixDropdownColumn", function() { return _chunks_model__WEBPACK_IMPORTED_MODULE_0__["MatrixDropdownColumn"]; });

/* harmony reexport (safe) */ __webpack_require__.d(__webpack_exports__, "matrixDropdownColumnTypes", function() { return _chunks_model__WEBPACK_IMPORTED_MODULE_0__["matrixDropdownColumnTypes"]; });

/* harmony reexport (safe) */ __webpack_require__.d(__webpack_exports__, "QuestionMatrixDropdownRenderedCell", function() { return _chunks_model__WEBPACK_IMPORTED_MODULE_0__["QuestionMatrixDropdownRenderedCell"]; });

/* harmony reexport (safe) */ __webpack_require__.d(__webpack_exports__, "QuestionMatrixDropdownRenderedRow", function() { return _chunks_model__WEBPACK_IMPORTED_MODULE_0__["QuestionMatrixDropdownRenderedRow"]; });

/* harmony reexport (safe) */ __webpack_require__.d(__webpack_exports__, "QuestionMatrixDropdownRenderedTable", function() { return _chunks_model__WEBPACK_IMPORTED_MODULE_0__["QuestionMatrixDropdownRenderedTable"]; });

/* harmony reexport (safe) */ __webpack_require__.d(__webpack_exports__, "MatrixDropdownRowModel", function() { return _chunks_model__WEBPACK_IMPORTED_MODULE_0__["MatrixDropdownRowModel"]; });

/* harmony reexport (safe) */ __webpack_require__.d(__webpack_exports__, "QuestionMatrixDropdownModel", function() { return _chunks_model__WEBPACK_IMPORTED_MODULE_0__["QuestionMatrixDropdownModel"]; });

/* harmony reexport (safe) */ __webpack_require__.d(__webpack_exports__, "MatrixDynamicRowModel", function() { return _chunks_model__WEBPACK_IMPORTED_MODULE_0__["MatrixDynamicRowModel"]; });

/* harmony reexport (safe) */ __webpack_require__.d(__webpack_exports__, "QuestionMatrixDynamicModel", function() { return _chunks_model__WEBPACK_IMPORTED_MODULE_0__["QuestionMatrixDynamicModel"]; });

/* harmony reexport (safe) */ __webpack_require__.d(__webpack_exports__, "MatrixRowModel", function() { return _chunks_model__WEBPACK_IMPORTED_MODULE_0__["MatrixRowModel"]; });

/* harmony reexport (safe) */ __webpack_require__.d(__webpack_exports__, "MatrixCells", function() { return _chunks_model__WEBPACK_IMPORTED_MODULE_0__["MatrixCells"]; });

/* harmony reexport (safe) */ __webpack_require__.d(__webpack_exports__, "QuestionMatrixModel", function() { return _chunks_model__WEBPACK_IMPORTED_MODULE_0__["QuestionMatrixModel"]; });

/* harmony reexport (safe) */ __webpack_require__.d(__webpack_exports__, "MultipleTextItemModel", function() { return _chunks_model__WEBPACK_IMPORTED_MODULE_0__["MultipleTextItemModel"]; });

/* harmony reexport (safe) */ __webpack_require__.d(__webpack_exports__, "QuestionMultipleTextModel", function() { return _chunks_model__WEBPACK_IMPORTED_MODULE_0__["QuestionMultipleTextModel"]; });

/* harmony reexport (safe) */ __webpack_require__.d(__webpack_exports__, "PanelModel", function() { return _chunks_model__WEBPACK_IMPORTED_MODULE_0__["PanelModel"]; });

/* harmony reexport (safe) */ __webpack_require__.d(__webpack_exports__, "PanelModelBase", function() { return _chunks_model__WEBPACK_IMPORTED_MODULE_0__["PanelModelBase"]; });

/* harmony reexport (safe) */ __webpack_require__.d(__webpack_exports__, "QuestionRowModel", function() { return _chunks_model__WEBPACK_IMPORTED_MODULE_0__["QuestionRowModel"]; });

/* harmony reexport (safe) */ __webpack_require__.d(__webpack_exports__, "FlowPanelModel", function() { return _chunks_model__WEBPACK_IMPORTED_MODULE_0__["FlowPanelModel"]; });

/* harmony reexport (safe) */ __webpack_require__.d(__webpack_exports__, "PageModel", function() { return _chunks_model__WEBPACK_IMPORTED_MODULE_0__["PageModel"]; });

/* harmony reexport (safe) */ __webpack_require__.d(__webpack_exports__, "DefaultTitleModel", function() { return _chunks_model__WEBPACK_IMPORTED_MODULE_0__["DefaultTitleModel"]; });

/* harmony reexport (safe) */ __webpack_require__.d(__webpack_exports__, "Question", function() { return _chunks_model__WEBPACK_IMPORTED_MODULE_0__["Question"]; });

/* harmony reexport (safe) */ __webpack_require__.d(__webpack_exports__, "QuestionNonValue", function() { return _chunks_model__WEBPACK_IMPORTED_MODULE_0__["QuestionNonValue"]; });

/* harmony reexport (safe) */ __webpack_require__.d(__webpack_exports__, "QuestionEmptyModel", function() { return _chunks_model__WEBPACK_IMPORTED_MODULE_0__["QuestionEmptyModel"]; });

/* harmony reexport (safe) */ __webpack_require__.d(__webpack_exports__, "QuestionCheckboxBase", function() { return _chunks_model__WEBPACK_IMPORTED_MODULE_0__["QuestionCheckboxBase"]; });

/* harmony reexport (safe) */ __webpack_require__.d(__webpack_exports__, "QuestionSelectBase", function() { return _chunks_model__WEBPACK_IMPORTED_MODULE_0__["QuestionSelectBase"]; });

/* harmony reexport (safe) */ __webpack_require__.d(__webpack_exports__, "QuestionCheckboxModel", function() { return _chunks_model__WEBPACK_IMPORTED_MODULE_0__["QuestionCheckboxModel"]; });

/* harmony reexport (safe) */ __webpack_require__.d(__webpack_exports__, "QuestionRankingModel", function() { return _chunks_model__WEBPACK_IMPORTED_MODULE_0__["QuestionRankingModel"]; });

/* harmony reexport (safe) */ __webpack_require__.d(__webpack_exports__, "QuestionCommentModel", function() { return _chunks_model__WEBPACK_IMPORTED_MODULE_0__["QuestionCommentModel"]; });

/* harmony reexport (safe) */ __webpack_require__.d(__webpack_exports__, "QuestionDropdownModel", function() { return _chunks_model__WEBPACK_IMPORTED_MODULE_0__["QuestionDropdownModel"]; });

/* harmony reexport (safe) */ __webpack_require__.d(__webpack_exports__, "QuestionFactory", function() { return _chunks_model__WEBPACK_IMPORTED_MODULE_0__["QuestionFactory"]; });

/* harmony reexport (safe) */ __webpack_require__.d(__webpack_exports__, "ElementFactory", function() { return _chunks_model__WEBPACK_IMPORTED_MODULE_0__["ElementFactory"]; });

/* harmony reexport (safe) */ __webpack_require__.d(__webpack_exports__, "QuestionFileModel", function() { return _chunks_model__WEBPACK_IMPORTED_MODULE_0__["QuestionFileModel"]; });

/* harmony reexport (safe) */ __webpack_require__.d(__webpack_exports__, "QuestionHtmlModel", function() { return _chunks_model__WEBPACK_IMPORTED_MODULE_0__["QuestionHtmlModel"]; });

/* harmony reexport (safe) */ __webpack_require__.d(__webpack_exports__, "QuestionRadiogroupModel", function() { return _chunks_model__WEBPACK_IMPORTED_MODULE_0__["QuestionRadiogroupModel"]; });

/* harmony reexport (safe) */ __webpack_require__.d(__webpack_exports__, "QuestionRatingModel", function() { return _chunks_model__WEBPACK_IMPORTED_MODULE_0__["QuestionRatingModel"]; });

/* harmony reexport (safe) */ __webpack_require__.d(__webpack_exports__, "QuestionExpressionModel", function() { return _chunks_model__WEBPACK_IMPORTED_MODULE_0__["QuestionExpressionModel"]; });

/* harmony reexport (safe) */ __webpack_require__.d(__webpack_exports__, "QuestionTextModel", function() { return _chunks_model__WEBPACK_IMPORTED_MODULE_0__["QuestionTextModel"]; });

/* harmony reexport (safe) */ __webpack_require__.d(__webpack_exports__, "QuestionBooleanModel", function() { return _chunks_model__WEBPACK_IMPORTED_MODULE_0__["QuestionBooleanModel"]; });

/* harmony reexport (safe) */ __webpack_require__.d(__webpack_exports__, "QuestionImagePickerModel", function() { return _chunks_model__WEBPACK_IMPORTED_MODULE_0__["QuestionImagePickerModel"]; });

/* harmony reexport (safe) */ __webpack_require__.d(__webpack_exports__, "ImageItemValue", function() { return _chunks_model__WEBPACK_IMPORTED_MODULE_0__["ImageItemValue"]; });

/* harmony reexport (safe) */ __webpack_require__.d(__webpack_exports__, "QuestionImageModel", function() { return _chunks_model__WEBPACK_IMPORTED_MODULE_0__["QuestionImageModel"]; });

/* harmony reexport (safe) */ __webpack_require__.d(__webpack_exports__, "QuestionSignaturePadModel", function() { return _chunks_model__WEBPACK_IMPORTED_MODULE_0__["QuestionSignaturePadModel"]; });

/* harmony reexport (safe) */ __webpack_require__.d(__webpack_exports__, "QuestionPanelDynamicModel", function() { return _chunks_model__WEBPACK_IMPORTED_MODULE_0__["QuestionPanelDynamicModel"]; });

/* harmony reexport (safe) */ __webpack_require__.d(__webpack_exports__, "QuestionPanelDynamicItem", function() { return _chunks_model__WEBPACK_IMPORTED_MODULE_0__["QuestionPanelDynamicItem"]; });

/* harmony reexport (safe) */ __webpack_require__.d(__webpack_exports__, "SurveyTimer", function() { return _chunks_model__WEBPACK_IMPORTED_MODULE_0__["SurveyTimer"]; });

/* harmony reexport (safe) */ __webpack_require__.d(__webpack_exports__, "SurveyProgressModel", function() { return _chunks_model__WEBPACK_IMPORTED_MODULE_0__["SurveyProgressModel"]; });

/* harmony reexport (safe) */ __webpack_require__.d(__webpack_exports__, "SurveyProgressButtonsModel", function() { return _chunks_model__WEBPACK_IMPORTED_MODULE_0__["SurveyProgressButtonsModel"]; });

/* harmony reexport (safe) */ __webpack_require__.d(__webpack_exports__, "SurveyModel", function() { return _chunks_model__WEBPACK_IMPORTED_MODULE_0__["SurveyModel"]; });

/* harmony reexport (safe) */ __webpack_require__.d(__webpack_exports__, "SurveyTrigger", function() { return _chunks_model__WEBPACK_IMPORTED_MODULE_0__["SurveyTrigger"]; });

/* harmony reexport (safe) */ __webpack_require__.d(__webpack_exports__, "SurveyTriggerComplete", function() { return _chunks_model__WEBPACK_IMPORTED_MODULE_0__["SurveyTriggerComplete"]; });

/* harmony reexport (safe) */ __webpack_require__.d(__webpack_exports__, "SurveyTriggerSetValue", function() { return _chunks_model__WEBPACK_IMPORTED_MODULE_0__["SurveyTriggerSetValue"]; });

/* harmony reexport (safe) */ __webpack_require__.d(__webpack_exports__, "SurveyTriggerVisible", function() { return _chunks_model__WEBPACK_IMPORTED_MODULE_0__["SurveyTriggerVisible"]; });

/* harmony reexport (safe) */ __webpack_require__.d(__webpack_exports__, "SurveyTriggerCopyValue", function() { return _chunks_model__WEBPACK_IMPORTED_MODULE_0__["SurveyTriggerCopyValue"]; });

/* harmony reexport (safe) */ __webpack_require__.d(__webpack_exports__, "SurveyTriggerRunExpression", function() { return _chunks_model__WEBPACK_IMPORTED_MODULE_0__["SurveyTriggerRunExpression"]; });

/* harmony reexport (safe) */ __webpack_require__.d(__webpack_exports__, "Trigger", function() { return _chunks_model__WEBPACK_IMPORTED_MODULE_0__["Trigger"]; });

/* harmony reexport (safe) */ __webpack_require__.d(__webpack_exports__, "SurveyWindowModel", function() { return _chunks_model__WEBPACK_IMPORTED_MODULE_0__["SurveyWindowModel"]; });

/* harmony reexport (safe) */ __webpack_require__.d(__webpack_exports__, "TextPreProcessor", function() { return _chunks_model__WEBPACK_IMPORTED_MODULE_0__["TextPreProcessor"]; });

/* harmony reexport (safe) */ __webpack_require__.d(__webpack_exports__, "dxSurveyService", function() { return _chunks_model__WEBPACK_IMPORTED_MODULE_0__["dxSurveyService"]; });

/* harmony reexport (safe) */ __webpack_require__.d(__webpack_exports__, "englishStrings", function() { return _chunks_model__WEBPACK_IMPORTED_MODULE_0__["englishStrings"]; });

/* harmony reexport (safe) */ __webpack_require__.d(__webpack_exports__, "surveyLocalization", function() { return _chunks_model__WEBPACK_IMPORTED_MODULE_0__["surveyLocalization"]; });

/* harmony reexport (safe) */ __webpack_require__.d(__webpack_exports__, "surveyStrings", function() { return _chunks_model__WEBPACK_IMPORTED_MODULE_0__["surveyStrings"]; });

/* harmony reexport (safe) */ __webpack_require__.d(__webpack_exports__, "QuestionCustomWidget", function() { return _chunks_model__WEBPACK_IMPORTED_MODULE_0__["QuestionCustomWidget"]; });

/* harmony reexport (safe) */ __webpack_require__.d(__webpack_exports__, "CustomWidgetCollection", function() { return _chunks_model__WEBPACK_IMPORTED_MODULE_0__["CustomWidgetCollection"]; });

/* harmony reexport (safe) */ __webpack_require__.d(__webpack_exports__, "QuestionCustomModel", function() { return _chunks_model__WEBPACK_IMPORTED_MODULE_0__["QuestionCustomModel"]; });

/* harmony reexport (safe) */ __webpack_require__.d(__webpack_exports__, "QuestionCompositeModel", function() { return _chunks_model__WEBPACK_IMPORTED_MODULE_0__["QuestionCompositeModel"]; });

/* harmony reexport (safe) */ __webpack_require__.d(__webpack_exports__, "ComponentQuestionJSON", function() { return _chunks_model__WEBPACK_IMPORTED_MODULE_0__["ComponentQuestionJSON"]; });

/* harmony reexport (safe) */ __webpack_require__.d(__webpack_exports__, "ComponentCollection", function() { return _chunks_model__WEBPACK_IMPORTED_MODULE_0__["ComponentCollection"]; });

/* harmony reexport (safe) */ __webpack_require__.d(__webpack_exports__, "StylesManager", function() { return _chunks_model__WEBPACK_IMPORTED_MODULE_0__["StylesManager"]; });

/* harmony reexport (safe) */ __webpack_require__.d(__webpack_exports__, "ListModel", function() { return _chunks_model__WEBPACK_IMPORTED_MODULE_0__["ListModel"]; });

/* harmony reexport (safe) */ __webpack_require__.d(__webpack_exports__, "PopupModel", function() { return _chunks_model__WEBPACK_IMPORTED_MODULE_0__["PopupModel"]; });

/* harmony reexport (safe) */ __webpack_require__.d(__webpack_exports__, "PopupBaseViewModel", function() { return _chunks_model__WEBPACK_IMPORTED_MODULE_0__["PopupBaseViewModel"]; });

/* harmony reexport (safe) */ __webpack_require__.d(__webpack_exports__, "createPopupModalViewModel", function() { return _chunks_model__WEBPACK_IMPORTED_MODULE_0__["createPopupModalViewModel"]; });

/* harmony reexport (safe) */ __webpack_require__.d(__webpack_exports__, "QuestionButtonGroupModel", function() { return _chunks_model__WEBPACK_IMPORTED_MODULE_0__["QuestionButtonGroupModel"]; });

/* harmony reexport (safe) */ __webpack_require__.d(__webpack_exports__, "ButtonGroupItemModel", function() { return _chunks_model__WEBPACK_IMPORTED_MODULE_0__["ButtonGroupItemModel"]; });

/* harmony reexport (safe) */ __webpack_require__.d(__webpack_exports__, "ButtonGroupItemValue", function() { return _chunks_model__WEBPACK_IMPORTED_MODULE_0__["ButtonGroupItemValue"]; });

/* harmony reexport (safe) */ __webpack_require__.d(__webpack_exports__, "IsMobile", function() { return _chunks_model__WEBPACK_IMPORTED_MODULE_0__["IsMobile"]; });

/* harmony reexport (safe) */ __webpack_require__.d(__webpack_exports__, "confirmAction", function() { return _chunks_model__WEBPACK_IMPORTED_MODULE_0__["confirmAction"]; });

/* harmony reexport (safe) */ __webpack_require__.d(__webpack_exports__, "detectIEOrEdge", function() { return _chunks_model__WEBPACK_IMPORTED_MODULE_0__["detectIEOrEdge"]; });

/* harmony reexport (safe) */ __webpack_require__.d(__webpack_exports__, "doKey2ClickUp", function() { return _chunks_model__WEBPACK_IMPORTED_MODULE_0__["doKey2ClickUp"]; });

/* harmony reexport (safe) */ __webpack_require__.d(__webpack_exports__, "doKey2ClickDown", function() { return _chunks_model__WEBPACK_IMPORTED_MODULE_0__["doKey2ClickDown"]; });

/* harmony reexport (safe) */ __webpack_require__.d(__webpack_exports__, "loadFileFromBase64", function() { return _chunks_model__WEBPACK_IMPORTED_MODULE_0__["loadFileFromBase64"]; });

/* harmony reexport (safe) */ __webpack_require__.d(__webpack_exports__, "increaseHeightByContent", function() { return _chunks_model__WEBPACK_IMPORTED_MODULE_0__["increaseHeightByContent"]; });

/* harmony reexport (safe) */ __webpack_require__.d(__webpack_exports__, "createSvg", function() { return _chunks_model__WEBPACK_IMPORTED_MODULE_0__["createSvg"]; });

/* harmony reexport (safe) */ __webpack_require__.d(__webpack_exports__, "CssClassBuilder", function() { return _chunks_model__WEBPACK_IMPORTED_MODULE_0__["CssClassBuilder"]; });

/* harmony reexport (safe) */ __webpack_require__.d(__webpack_exports__, "surveyCss", function() { return _chunks_model__WEBPACK_IMPORTED_MODULE_0__["surveyCss"]; });

/* harmony reexport (safe) */ __webpack_require__.d(__webpack_exports__, "DragDropSurveyElements", function() { return _chunks_model__WEBPACK_IMPORTED_MODULE_0__["DragDropSurveyElements"]; });

/* harmony reexport (safe) */ __webpack_require__.d(__webpack_exports__, "DragDropChoices", function() { return _chunks_model__WEBPACK_IMPORTED_MODULE_0__["DragDropChoices"]; });

/* harmony import */ var _chunks_localization__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ./chunks/localization */ "./src/entries/chunks/localization.ts");
/* harmony import */ var _defaultCss_cssstandard__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ../defaultCss/cssstandard */ "./src/defaultCss/cssstandard.ts");
/* harmony reexport (safe) */ __webpack_require__.d(__webpack_exports__, "defaultStandardCss", function() { return _defaultCss_cssstandard__WEBPACK_IMPORTED_MODULE_2__["defaultStandardCss"]; });

/* harmony import */ var _defaultCss_cssbootstrap__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ../defaultCss/cssbootstrap */ "./src/defaultCss/cssbootstrap.ts");
/* harmony reexport (safe) */ __webpack_require__.d(__webpack_exports__, "defaultBootstrapCss", function() { return _defaultCss_cssbootstrap__WEBPACK_IMPORTED_MODULE_3__["defaultBootstrapCss"]; });

/* harmony import */ var _defaultCss_cssbootstrapmaterial__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! ../defaultCss/cssbootstrapmaterial */ "./src/defaultCss/cssbootstrapmaterial.ts");
/* harmony reexport (safe) */ __webpack_require__.d(__webpack_exports__, "defaultBootstrapMaterialCss", function() { return _defaultCss_cssbootstrapmaterial__WEBPACK_IMPORTED_MODULE_4__["defaultBootstrapMaterialCss"]; });

/* harmony import */ var _defaultCss_defaultV2Css__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! ../defaultCss/defaultV2Css */ "./src/defaultCss/defaultV2Css.ts");
/* harmony reexport (safe) */ __webpack_require__.d(__webpack_exports__, "defaultV2Css", function() { return _defaultCss_defaultV2Css__WEBPACK_IMPORTED_MODULE_5__["defaultV2Css"]; });

/* harmony import */ var _defaultCss_cssmodern__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(/*! ../defaultCss/cssmodern */ "./src/defaultCss/cssmodern.ts");
/* harmony reexport (safe) */ __webpack_require__.d(__webpack_exports__, "modernCss", function() { return _defaultCss_cssmodern__WEBPACK_IMPORTED_MODULE_6__["modernCss"]; });

/* harmony import */ var _svgbundle__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__(/*! ../svgbundle */ "./src/svgbundle.ts");
/* harmony reexport (safe) */ __webpack_require__.d(__webpack_exports__, "SvgBundleViewModel", function() { return _svgbundle__WEBPACK_IMPORTED_MODULE_7__["SvgBundleViewModel"]; });

/* harmony import */ var _rendererFactory__WEBPACK_IMPORTED_MODULE_8__ = __webpack_require__(/*! ../rendererFactory */ "./src/rendererFactory.ts");
/* harmony reexport (safe) */ __webpack_require__.d(__webpack_exports__, "RendererFactory", function() { return _rendererFactory__WEBPACK_IMPORTED_MODULE_8__["RendererFactory"]; });

/* harmony import */ var _utils_responsivity_manager__WEBPACK_IMPORTED_MODULE_9__ = __webpack_require__(/*! ../utils/responsivity-manager */ "./src/utils/responsivity-manager.ts");
/* harmony reexport (safe) */ __webpack_require__.d(__webpack_exports__, "ResponsivityManager", function() { return _utils_responsivity_manager__WEBPACK_IMPORTED_MODULE_9__["ResponsivityManager"]; });

/* harmony reexport (safe) */ __webpack_require__.d(__webpack_exports__, "VerticalResponsivityManager", function() { return _utils_responsivity_manager__WEBPACK_IMPORTED_MODULE_9__["VerticalResponsivityManager"]; });

/* harmony import */ var _utils_utils__WEBPACK_IMPORTED_MODULE_10__ = __webpack_require__(/*! ../utils/utils */ "./src/utils/utils.ts");
/* harmony reexport (safe) */ __webpack_require__.d(__webpack_exports__, "unwrap", function() { return _utils_utils__WEBPACK_IMPORTED_MODULE_10__["unwrap"]; });

/* harmony import */ var _actions_action__WEBPACK_IMPORTED_MODULE_11__ = __webpack_require__(/*! ../actions/action */ "./src/actions/action.ts");
/* harmony reexport (safe) */ __webpack_require__.d(__webpack_exports__, "Action", function() { return _actions_action__WEBPACK_IMPORTED_MODULE_11__["Action"]; });

/* harmony import */ var _actions_adaptive_container__WEBPACK_IMPORTED_MODULE_12__ = __webpack_require__(/*! ../actions/adaptive-container */ "./src/actions/adaptive-container.ts");
/* harmony reexport (safe) */ __webpack_require__.d(__webpack_exports__, "AdaptiveActionContainer", function() { return _actions_adaptive_container__WEBPACK_IMPORTED_MODULE_12__["AdaptiveActionContainer"]; });

/* harmony import */ var _actions_container__WEBPACK_IMPORTED_MODULE_13__ = __webpack_require__(/*! ../actions/container */ "./src/actions/container.ts");
/* harmony reexport (safe) */ __webpack_require__.d(__webpack_exports__, "ActionContainer", function() { return _actions_container__WEBPACK_IMPORTED_MODULE_13__["ActionContainer"]; });

/* harmony import */ var _utils_tooltip__WEBPACK_IMPORTED_MODULE_14__ = __webpack_require__(/*! ../utils/tooltip */ "./src/utils/tooltip.ts");
/* harmony reexport (safe) */ __webpack_require__.d(__webpack_exports__, "TooltipManager", function() { return _utils_tooltip__WEBPACK_IMPORTED_MODULE_14__["TooltipManager"]; });

// model

// localization

// css standard classes

// css bootstrap classes

// css bootstrap + material classes


// css modern classes


// utils









/***/ }),

/***/ "./src/entries/react-ui.ts":
/*!*********************************!*\
  !*** ./src/entries/react-ui.ts ***!
  \*********************************/
/*! exports provided: Survey, attachKey2click, Model, WindowModel, SurveyNavigationBase, SurveyTimerPanel, SurveyNavigation, SurveyPage, SurveyRow, SurveyPanel, SurveyFlowPanel, SurveyQuestion, SurveyElementErrors, SurveyQuestionAndErrorsCell, SurveyElementBase, SurveyQuestionElementBase, SurveyQuestionCommentItem, SurveyQuestionComment, SurveyQuestionCheckbox, SurveyQuestionCheckboxItem, SurveyQuestionRanking, SurveyQuestionRankingItem, SurveyQuestionDropdown, SurveyQuestionMatrix, SurveyQuestionMatrixRow, SurveyQuestionHtml, SurveyQuestionFile, SurveyQuestionMultipleText, SurveyQuestionRadiogroup, SurveyQuestionText, SurveyQuestionBoolean, SurveyQuestionBooleanCheckbox, SurveyQuestionEmpty, SurveyQuestionMatrixDropdownCell, SurveyQuestionMatrixDropdown, SurveyQuestionMatrixDynamic, SurveyQuestionPanelDynamic, SurveyProgress, SurveyProgressButtons, SurveyQuestionRating, SurveyQuestionExpression, SurveyWindow, ReactQuestionFactory, ReactElementFactory, SurveyQuestionImagePicker, SurveyQuestionImage, SurveyQuestionSignaturePad, SurveyQuestionButtonGroup, SurveyQuestionCustom, SurveyQuestionComposite, DefaultTitle, Popup, List, TitleActions, TitleElement, SurveyActionBar, LogoImage, SurveyHeader, SvgIcon, SurveyQuestionMatrixDynamicRemoveButton, SurveyQuestionMatrixDetailButton, SurveyQuestionMatrixDynamicDragDropIcon, MatrixRow, Skeleton, SurveyLocStringViewer, SurveyLocStringEditor, ResponsivityManager, VerticalResponsivityManager, unwrap */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony import */ var _react_reactSurvey__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ../react/reactSurvey */ "./src/react/reactSurvey.tsx");
/* harmony reexport (safe) */ __webpack_require__.d(__webpack_exports__, "Survey", function() { return _react_reactSurvey__WEBPACK_IMPORTED_MODULE_0__["Survey"]; });

/* harmony reexport (safe) */ __webpack_require__.d(__webpack_exports__, "attachKey2click", function() { return _react_reactSurvey__WEBPACK_IMPORTED_MODULE_0__["attachKey2click"]; });

/* harmony import */ var _react_reactsurveymodel__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ../react/reactsurveymodel */ "./src/react/reactsurveymodel.tsx");
/* harmony reexport (safe) */ __webpack_require__.d(__webpack_exports__, "Model", function() { return _react_reactsurveymodel__WEBPACK_IMPORTED_MODULE_1__["ReactSurveyModel"]; });

/* harmony reexport (safe) */ __webpack_require__.d(__webpack_exports__, "WindowModel", function() { return _react_reactsurveymodel__WEBPACK_IMPORTED_MODULE_1__["ReactWindowModel"]; });

/* harmony import */ var _react_reactSurveyNavigationBase__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ../react/reactSurveyNavigationBase */ "./src/react/reactSurveyNavigationBase.tsx");
/* harmony reexport (safe) */ __webpack_require__.d(__webpack_exports__, "SurveyNavigationBase", function() { return _react_reactSurveyNavigationBase__WEBPACK_IMPORTED_MODULE_2__["SurveyNavigationBase"]; });

/* harmony import */ var _react_reacttimerpanel__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ../react/reacttimerpanel */ "./src/react/reacttimerpanel.tsx");
/* harmony reexport (safe) */ __webpack_require__.d(__webpack_exports__, "SurveyTimerPanel", function() { return _react_reacttimerpanel__WEBPACK_IMPORTED_MODULE_3__["SurveyTimerPanel"]; });

/* harmony import */ var _react_reactSurveyNavigation__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! ../react/reactSurveyNavigation */ "./src/react/reactSurveyNavigation.tsx");
/* harmony reexport (safe) */ __webpack_require__.d(__webpack_exports__, "SurveyNavigation", function() { return _react_reactSurveyNavigation__WEBPACK_IMPORTED_MODULE_4__["SurveyNavigation"]; });

/* harmony import */ var _react_page__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! ../react/page */ "./src/react/page.tsx");
/* harmony reexport (safe) */ __webpack_require__.d(__webpack_exports__, "SurveyPage", function() { return _react_page__WEBPACK_IMPORTED_MODULE_5__["SurveyPage"]; });

/* harmony import */ var _react_row__WEBPACK_IMPORTED_MODULE_6__ = __webpack_require__(/*! ../react/row */ "./src/react/row.tsx");
/* harmony reexport (safe) */ __webpack_require__.d(__webpack_exports__, "SurveyRow", function() { return _react_row__WEBPACK_IMPORTED_MODULE_6__["SurveyRow"]; });

/* harmony import */ var _react_panel__WEBPACK_IMPORTED_MODULE_7__ = __webpack_require__(/*! ../react/panel */ "./src/react/panel.tsx");
/* harmony reexport (safe) */ __webpack_require__.d(__webpack_exports__, "SurveyPanel", function() { return _react_panel__WEBPACK_IMPORTED_MODULE_7__["SurveyPanel"]; });

/* harmony import */ var _react_flow_panel__WEBPACK_IMPORTED_MODULE_8__ = __webpack_require__(/*! ../react/flow-panel */ "./src/react/flow-panel.tsx");
/* harmony reexport (safe) */ __webpack_require__.d(__webpack_exports__, "SurveyFlowPanel", function() { return _react_flow_panel__WEBPACK_IMPORTED_MODULE_8__["SurveyFlowPanel"]; });

/* harmony import */ var _react_reactquestion__WEBPACK_IMPORTED_MODULE_9__ = __webpack_require__(/*! ../react/reactquestion */ "./src/react/reactquestion.tsx");
/* harmony reexport (safe) */ __webpack_require__.d(__webpack_exports__, "SurveyQuestion", function() { return _react_reactquestion__WEBPACK_IMPORTED_MODULE_9__["SurveyQuestion"]; });

/* harmony reexport (safe) */ __webpack_require__.d(__webpack_exports__, "SurveyElementErrors", function() { return _react_reactquestion__WEBPACK_IMPORTED_MODULE_9__["SurveyElementErrors"]; });

/* harmony reexport (safe) */ __webpack_require__.d(__webpack_exports__, "SurveyQuestionAndErrorsCell", function() { return _react_reactquestion__WEBPACK_IMPORTED_MODULE_9__["SurveyQuestionAndErrorsCell"]; });

/* harmony import */ var _react_reactquestion_element__WEBPACK_IMPORTED_MODULE_10__ = __webpack_require__(/*! ../react/reactquestion_element */ "./src/react/reactquestion_element.tsx");
/* harmony reexport (safe) */ __webpack_require__.d(__webpack_exports__, "SurveyElementBase", function() { return _react_reactquestion_element__WEBPACK_IMPORTED_MODULE_10__["SurveyElementBase"]; });

/* harmony reexport (safe) */ __webpack_require__.d(__webpack_exports__, "SurveyQuestionElementBase", function() { return _react_reactquestion_element__WEBPACK_IMPORTED_MODULE_10__["SurveyQuestionElementBase"]; });

/* harmony import */ var _react_reactquestion_comment__WEBPACK_IMPORTED_MODULE_11__ = __webpack_require__(/*! ../react/reactquestion_comment */ "./src/react/reactquestion_comment.tsx");
/* harmony reexport (safe) */ __webpack_require__.d(__webpack_exports__, "SurveyQuestionCommentItem", function() { return _react_reactquestion_comment__WEBPACK_IMPORTED_MODULE_11__["SurveyQuestionCommentItem"]; });

/* harmony reexport (safe) */ __webpack_require__.d(__webpack_exports__, "SurveyQuestionComment", function() { return _react_reactquestion_comment__WEBPACK_IMPORTED_MODULE_11__["SurveyQuestionComment"]; });

/* harmony import */ var _react_reactquestion_checkbox__WEBPACK_IMPORTED_MODULE_12__ = __webpack_require__(/*! ../react/reactquestion_checkbox */ "./src/react/reactquestion_checkbox.tsx");
/* harmony reexport (safe) */ __webpack_require__.d(__webpack_exports__, "SurveyQuestionCheckbox", function() { return _react_reactquestion_checkbox__WEBPACK_IMPORTED_MODULE_12__["SurveyQuestionCheckbox"]; });

/* harmony reexport (safe) */ __webpack_require__.d(__webpack_exports__, "SurveyQuestionCheckboxItem", function() { return _react_reactquestion_checkbox__WEBPACK_IMPORTED_MODULE_12__["SurveyQuestionCheckboxItem"]; });

/* harmony import */ var _react_reactquestion_ranking__WEBPACK_IMPORTED_MODULE_13__ = __webpack_require__(/*! ../react/reactquestion_ranking */ "./src/react/reactquestion_ranking.tsx");
/* harmony reexport (safe) */ __webpack_require__.d(__webpack_exports__, "SurveyQuestionRanking", function() { return _react_reactquestion_ranking__WEBPACK_IMPORTED_MODULE_13__["SurveyQuestionRanking"]; });

/* harmony reexport (safe) */ __webpack_require__.d(__webpack_exports__, "SurveyQuestionRankingItem", function() { return _react_reactquestion_ranking__WEBPACK_IMPORTED_MODULE_13__["SurveyQuestionRankingItem"]; });

/* harmony import */ var _react_reactquestion_dropdown__WEBPACK_IMPORTED_MODULE_14__ = __webpack_require__(/*! ../react/reactquestion_dropdown */ "./src/react/reactquestion_dropdown.tsx");
/* harmony reexport (safe) */ __webpack_require__.d(__webpack_exports__, "SurveyQuestionDropdown", function() { return _react_reactquestion_dropdown__WEBPACK_IMPORTED_MODULE_14__["SurveyQuestionDropdown"]; });

/* harmony import */ var _react_reactquestion_matrix__WEBPACK_IMPORTED_MODULE_15__ = __webpack_require__(/*! ../react/reactquestion_matrix */ "./src/react/reactquestion_matrix.tsx");
/* harmony reexport (safe) */ __webpack_require__.d(__webpack_exports__, "SurveyQuestionMatrix", function() { return _react_reactquestion_matrix__WEBPACK_IMPORTED_MODULE_15__["SurveyQuestionMatrix"]; });

/* harmony reexport (safe) */ __webpack_require__.d(__webpack_exports__, "SurveyQuestionMatrixRow", function() { return _react_reactquestion_matrix__WEBPACK_IMPORTED_MODULE_15__["SurveyQuestionMatrixRow"]; });

/* harmony import */ var _react_reactquestion_html__WEBPACK_IMPORTED_MODULE_16__ = __webpack_require__(/*! ../react/reactquestion_html */ "./src/react/reactquestion_html.tsx");
/* harmony reexport (safe) */ __webpack_require__.d(__webpack_exports__, "SurveyQuestionHtml", function() { return _react_reactquestion_html__WEBPACK_IMPORTED_MODULE_16__["SurveyQuestionHtml"]; });

/* harmony import */ var _react_reactquestion_file__WEBPACK_IMPORTED_MODULE_17__ = __webpack_require__(/*! ../react/reactquestion_file */ "./src/react/reactquestion_file.tsx");
/* harmony reexport (safe) */ __webpack_require__.d(__webpack_exports__, "SurveyQuestionFile", function() { return _react_reactquestion_file__WEBPACK_IMPORTED_MODULE_17__["SurveyQuestionFile"]; });

/* harmony import */ var _react_reactquestion_multipletext__WEBPACK_IMPORTED_MODULE_18__ = __webpack_require__(/*! ../react/reactquestion_multipletext */ "./src/react/reactquestion_multipletext.tsx");
/* harmony reexport (safe) */ __webpack_require__.d(__webpack_exports__, "SurveyQuestionMultipleText", function() { return _react_reactquestion_multipletext__WEBPACK_IMPORTED_MODULE_18__["SurveyQuestionMultipleText"]; });

/* harmony import */ var _react_reactquestion_radiogroup__WEBPACK_IMPORTED_MODULE_19__ = __webpack_require__(/*! ../react/reactquestion_radiogroup */ "./src/react/reactquestion_radiogroup.tsx");
/* harmony reexport (safe) */ __webpack_require__.d(__webpack_exports__, "SurveyQuestionRadiogroup", function() { return _react_reactquestion_radiogroup__WEBPACK_IMPORTED_MODULE_19__["SurveyQuestionRadiogroup"]; });

/* harmony import */ var _react_reactquestion_text__WEBPACK_IMPORTED_MODULE_20__ = __webpack_require__(/*! ../react/reactquestion_text */ "./src/react/reactquestion_text.tsx");
/* harmony reexport (safe) */ __webpack_require__.d(__webpack_exports__, "SurveyQuestionText", function() { return _react_reactquestion_text__WEBPACK_IMPORTED_MODULE_20__["SurveyQuestionText"]; });

/* harmony import */ var _react_boolean__WEBPACK_IMPORTED_MODULE_21__ = __webpack_require__(/*! ../react/boolean */ "./src/react/boolean.tsx");
/* harmony reexport (safe) */ __webpack_require__.d(__webpack_exports__, "SurveyQuestionBoolean", function() { return _react_boolean__WEBPACK_IMPORTED_MODULE_21__["SurveyQuestionBoolean"]; });

/* harmony import */ var _react_boolean_checkbox__WEBPACK_IMPORTED_MODULE_22__ = __webpack_require__(/*! ../react/boolean-checkbox */ "./src/react/boolean-checkbox.tsx");
/* harmony reexport (safe) */ __webpack_require__.d(__webpack_exports__, "SurveyQuestionBooleanCheckbox", function() { return _react_boolean_checkbox__WEBPACK_IMPORTED_MODULE_22__["SurveyQuestionBooleanCheckbox"]; });

/* harmony import */ var _react_reactquestion_empty__WEBPACK_IMPORTED_MODULE_23__ = __webpack_require__(/*! ../react/reactquestion_empty */ "./src/react/reactquestion_empty.tsx");
/* harmony reexport (safe) */ __webpack_require__.d(__webpack_exports__, "SurveyQuestionEmpty", function() { return _react_reactquestion_empty__WEBPACK_IMPORTED_MODULE_23__["SurveyQuestionEmpty"]; });

/* harmony import */ var _react_reactquestion_matrixdropdownbase__WEBPACK_IMPORTED_MODULE_24__ = __webpack_require__(/*! ../react/reactquestion_matrixdropdownbase */ "./src/react/reactquestion_matrixdropdownbase.tsx");
/* harmony reexport (safe) */ __webpack_require__.d(__webpack_exports__, "SurveyQuestionMatrixDropdownCell", function() { return _react_reactquestion_matrixdropdownbase__WEBPACK_IMPORTED_MODULE_24__["SurveyQuestionMatrixDropdownCell"]; });

/* harmony import */ var _react_reactquestion_matrixdropdown__WEBPACK_IMPORTED_MODULE_25__ = __webpack_require__(/*! ../react/reactquestion_matrixdropdown */ "./src/react/reactquestion_matrixdropdown.tsx");
/* harmony reexport (safe) */ __webpack_require__.d(__webpack_exports__, "SurveyQuestionMatrixDropdown", function() { return _react_reactquestion_matrixdropdown__WEBPACK_IMPORTED_MODULE_25__["SurveyQuestionMatrixDropdown"]; });

/* harmony import */ var _react_reactquestion_matrixdynamic__WEBPACK_IMPORTED_MODULE_26__ = __webpack_require__(/*! ../react/reactquestion_matrixdynamic */ "./src/react/reactquestion_matrixdynamic.tsx");
/* harmony reexport (safe) */ __webpack_require__.d(__webpack_exports__, "SurveyQuestionMatrixDynamic", function() { return _react_reactquestion_matrixdynamic__WEBPACK_IMPORTED_MODULE_26__["SurveyQuestionMatrixDynamic"]; });

/* harmony import */ var _react_reactquestion_paneldynamic__WEBPACK_IMPORTED_MODULE_27__ = __webpack_require__(/*! ../react/reactquestion_paneldynamic */ "./src/react/reactquestion_paneldynamic.tsx");
/* harmony reexport (safe) */ __webpack_require__.d(__webpack_exports__, "SurveyQuestionPanelDynamic", function() { return _react_reactquestion_paneldynamic__WEBPACK_IMPORTED_MODULE_27__["SurveyQuestionPanelDynamic"]; });

/* harmony import */ var _react_reactSurveyProgress__WEBPACK_IMPORTED_MODULE_28__ = __webpack_require__(/*! ../react/reactSurveyProgress */ "./src/react/reactSurveyProgress.tsx");
/* harmony reexport (safe) */ __webpack_require__.d(__webpack_exports__, "SurveyProgress", function() { return _react_reactSurveyProgress__WEBPACK_IMPORTED_MODULE_28__["SurveyProgress"]; });

/* harmony import */ var _react_reactSurveyProgressButtons__WEBPACK_IMPORTED_MODULE_29__ = __webpack_require__(/*! ../react/reactSurveyProgressButtons */ "./src/react/reactSurveyProgressButtons.tsx");
/* harmony reexport (safe) */ __webpack_require__.d(__webpack_exports__, "SurveyProgressButtons", function() { return _react_reactSurveyProgressButtons__WEBPACK_IMPORTED_MODULE_29__["SurveyProgressButtons"]; });

/* harmony import */ var _react_reactquestion_rating__WEBPACK_IMPORTED_MODULE_30__ = __webpack_require__(/*! ../react/reactquestion_rating */ "./src/react/reactquestion_rating.tsx");
/* harmony reexport (safe) */ __webpack_require__.d(__webpack_exports__, "SurveyQuestionRating", function() { return _react_reactquestion_rating__WEBPACK_IMPORTED_MODULE_30__["SurveyQuestionRating"]; });

/* harmony import */ var _react_reactquestion_expression__WEBPACK_IMPORTED_MODULE_31__ = __webpack_require__(/*! ../react/reactquestion_expression */ "./src/react/reactquestion_expression.tsx");
/* harmony reexport (safe) */ __webpack_require__.d(__webpack_exports__, "SurveyQuestionExpression", function() { return _react_reactquestion_expression__WEBPACK_IMPORTED_MODULE_31__["SurveyQuestionExpression"]; });

/* harmony import */ var _react_reactSurveyWindow__WEBPACK_IMPORTED_MODULE_32__ = __webpack_require__(/*! ../react/reactSurveyWindow */ "./src/react/reactSurveyWindow.tsx");
/* harmony reexport (safe) */ __webpack_require__.d(__webpack_exports__, "SurveyWindow", function() { return _react_reactSurveyWindow__WEBPACK_IMPORTED_MODULE_32__["SurveyWindow"]; });

/* harmony import */ var _react_reactquestion_factory__WEBPACK_IMPORTED_MODULE_33__ = __webpack_require__(/*! ../react/reactquestion_factory */ "./src/react/reactquestion_factory.tsx");
/* harmony reexport (safe) */ __webpack_require__.d(__webpack_exports__, "ReactQuestionFactory", function() { return _react_reactquestion_factory__WEBPACK_IMPORTED_MODULE_33__["ReactQuestionFactory"]; });

/* harmony import */ var _react_element_factory__WEBPACK_IMPORTED_MODULE_34__ = __webpack_require__(/*! ../react/element-factory */ "./src/react/element-factory.tsx");
/* harmony reexport (safe) */ __webpack_require__.d(__webpack_exports__, "ReactElementFactory", function() { return _react_element_factory__WEBPACK_IMPORTED_MODULE_34__["ReactElementFactory"]; });

/* harmony import */ var _react_imagepicker__WEBPACK_IMPORTED_MODULE_35__ = __webpack_require__(/*! ../react/imagepicker */ "./src/react/imagepicker.tsx");
/* harmony reexport (safe) */ __webpack_require__.d(__webpack_exports__, "SurveyQuestionImagePicker", function() { return _react_imagepicker__WEBPACK_IMPORTED_MODULE_35__["SurveyQuestionImagePicker"]; });

/* harmony import */ var _react_image__WEBPACK_IMPORTED_MODULE_36__ = __webpack_require__(/*! ../react/image */ "./src/react/image.tsx");
/* harmony reexport (safe) */ __webpack_require__.d(__webpack_exports__, "SurveyQuestionImage", function() { return _react_image__WEBPACK_IMPORTED_MODULE_36__["SurveyQuestionImage"]; });

/* harmony import */ var _react_signaturepad__WEBPACK_IMPORTED_MODULE_37__ = __webpack_require__(/*! ../react/signaturepad */ "./src/react/signaturepad.tsx");
/* harmony reexport (safe) */ __webpack_require__.d(__webpack_exports__, "SurveyQuestionSignaturePad", function() { return _react_signaturepad__WEBPACK_IMPORTED_MODULE_37__["SurveyQuestionSignaturePad"]; });

/* harmony import */ var _react_reactquestion_buttongroup__WEBPACK_IMPORTED_MODULE_38__ = __webpack_require__(/*! ../react/reactquestion_buttongroup */ "./src/react/reactquestion_buttongroup.tsx");
/* harmony reexport (safe) */ __webpack_require__.d(__webpack_exports__, "SurveyQuestionButtonGroup", function() { return _react_reactquestion_buttongroup__WEBPACK_IMPORTED_MODULE_38__["SurveyQuestionButtonGroup"]; });

/* harmony import */ var _react_reactquestion_custom__WEBPACK_IMPORTED_MODULE_39__ = __webpack_require__(/*! ../react/reactquestion_custom */ "./src/react/reactquestion_custom.tsx");
/* harmony reexport (safe) */ __webpack_require__.d(__webpack_exports__, "SurveyQuestionCustom", function() { return _react_reactquestion_custom__WEBPACK_IMPORTED_MODULE_39__["SurveyQuestionCustom"]; });

/* harmony reexport (safe) */ __webpack_require__.d(__webpack_exports__, "SurveyQuestionComposite", function() { return _react_reactquestion_custom__WEBPACK_IMPORTED_MODULE_39__["SurveyQuestionComposite"]; });

/* harmony import */ var _react_components_title_default_title__WEBPACK_IMPORTED_MODULE_40__ = __webpack_require__(/*! ../react/components/title/default-title */ "./src/react/components/title/default-title.tsx");
/* harmony reexport (safe) */ __webpack_require__.d(__webpack_exports__, "DefaultTitle", function() { return _react_components_title_default_title__WEBPACK_IMPORTED_MODULE_40__["DefaultTitle"]; });

/* harmony import */ var _react_components_popup_popup__WEBPACK_IMPORTED_MODULE_41__ = __webpack_require__(/*! ../react/components/popup/popup */ "./src/react/components/popup/popup.tsx");
/* harmony reexport (safe) */ __webpack_require__.d(__webpack_exports__, "Popup", function() { return _react_components_popup_popup__WEBPACK_IMPORTED_MODULE_41__["Popup"]; });

/* harmony import */ var _react_components_list_list__WEBPACK_IMPORTED_MODULE_42__ = __webpack_require__(/*! ../react/components/list/list */ "./src/react/components/list/list.tsx");
/* harmony reexport (safe) */ __webpack_require__.d(__webpack_exports__, "List", function() { return _react_components_list_list__WEBPACK_IMPORTED_MODULE_42__["List"]; });

/* harmony import */ var _react_components_title_title_actions__WEBPACK_IMPORTED_MODULE_43__ = __webpack_require__(/*! ../react/components/title/title-actions */ "./src/react/components/title/title-actions.tsx");
/* harmony reexport (safe) */ __webpack_require__.d(__webpack_exports__, "TitleActions", function() { return _react_components_title_title_actions__WEBPACK_IMPORTED_MODULE_43__["TitleActions"]; });

/* harmony import */ var _react_components_title_title_element__WEBPACK_IMPORTED_MODULE_44__ = __webpack_require__(/*! ../react/components/title/title-element */ "./src/react/components/title/title-element.tsx");
/* harmony reexport (safe) */ __webpack_require__.d(__webpack_exports__, "TitleElement", function() { return _react_components_title_title_element__WEBPACK_IMPORTED_MODULE_44__["TitleElement"]; });

/* harmony import */ var _react_components_action_bar_action_bar__WEBPACK_IMPORTED_MODULE_45__ = __webpack_require__(/*! ../react/components/action-bar/action-bar */ "./src/react/components/action-bar/action-bar.tsx");
/* harmony reexport (safe) */ __webpack_require__.d(__webpack_exports__, "SurveyActionBar", function() { return _react_components_action_bar_action_bar__WEBPACK_IMPORTED_MODULE_45__["SurveyActionBar"]; });

/* harmony import */ var _react_components_survey_header_logo_image__WEBPACK_IMPORTED_MODULE_46__ = __webpack_require__(/*! ../react/components/survey-header/logo-image */ "./src/react/components/survey-header/logo-image.tsx");
/* harmony reexport (safe) */ __webpack_require__.d(__webpack_exports__, "LogoImage", function() { return _react_components_survey_header_logo_image__WEBPACK_IMPORTED_MODULE_46__["LogoImage"]; });

/* harmony import */ var _react_components_survey_header_survey_header__WEBPACK_IMPORTED_MODULE_47__ = __webpack_require__(/*! ../react/components/survey-header/survey-header */ "./src/react/components/survey-header/survey-header.tsx");
/* harmony reexport (safe) */ __webpack_require__.d(__webpack_exports__, "SurveyHeader", function() { return _react_components_survey_header_survey_header__WEBPACK_IMPORTED_MODULE_47__["SurveyHeader"]; });

/* harmony import */ var _react_components_svg_icon_svg_icon__WEBPACK_IMPORTED_MODULE_48__ = __webpack_require__(/*! ../react/components/svg-icon/svg-icon */ "./src/react/components/svg-icon/svg-icon.tsx");
/* harmony reexport (safe) */ __webpack_require__.d(__webpack_exports__, "SvgIcon", function() { return _react_components_svg_icon_svg_icon__WEBPACK_IMPORTED_MODULE_48__["SvgIcon"]; });

/* harmony import */ var _react_components_matrix_actions_remove_button_remove_button__WEBPACK_IMPORTED_MODULE_49__ = __webpack_require__(/*! ../react/components/matrix-actions/remove-button/remove-button */ "./src/react/components/matrix-actions/remove-button/remove-button.tsx");
/* harmony reexport (safe) */ __webpack_require__.d(__webpack_exports__, "SurveyQuestionMatrixDynamicRemoveButton", function() { return _react_components_matrix_actions_remove_button_remove_button__WEBPACK_IMPORTED_MODULE_49__["SurveyQuestionMatrixDynamicRemoveButton"]; });

/* harmony import */ var _react_components_matrix_actions_detail_button_detail_button__WEBPACK_IMPORTED_MODULE_50__ = __webpack_require__(/*! ../react/components/matrix-actions/detail-button/detail-button */ "./src/react/components/matrix-actions/detail-button/detail-button.tsx");
/* harmony reexport (safe) */ __webpack_require__.d(__webpack_exports__, "SurveyQuestionMatrixDetailButton", function() { return _react_components_matrix_actions_detail_button_detail_button__WEBPACK_IMPORTED_MODULE_50__["SurveyQuestionMatrixDetailButton"]; });

/* harmony import */ var _react_components_matrix_actions_drag_drop_icon_drag_drop_icon__WEBPACK_IMPORTED_MODULE_51__ = __webpack_require__(/*! ../react/components/matrix-actions/drag-drop-icon/drag-drop-icon */ "./src/react/components/matrix-actions/drag-drop-icon/drag-drop-icon.tsx");
/* harmony reexport (safe) */ __webpack_require__.d(__webpack_exports__, "SurveyQuestionMatrixDynamicDragDropIcon", function() { return _react_components_matrix_actions_drag_drop_icon_drag_drop_icon__WEBPACK_IMPORTED_MODULE_51__["SurveyQuestionMatrixDynamicDragDropIcon"]; });

/* harmony import */ var _react_components_matrix_row__WEBPACK_IMPORTED_MODULE_52__ = __webpack_require__(/*! ../react/components/matrix/row */ "./src/react/components/matrix/row.tsx");
/* harmony reexport (safe) */ __webpack_require__.d(__webpack_exports__, "MatrixRow", function() { return _react_components_matrix_row__WEBPACK_IMPORTED_MODULE_52__["MatrixRow"]; });

/* harmony import */ var _react_components_skeleton__WEBPACK_IMPORTED_MODULE_53__ = __webpack_require__(/*! ../react/components/skeleton */ "./src/react/components/skeleton.tsx");
/* harmony reexport (safe) */ __webpack_require__.d(__webpack_exports__, "Skeleton", function() { return _react_components_skeleton__WEBPACK_IMPORTED_MODULE_53__["Skeleton"]; });

/* harmony import */ var _react_string_viewer__WEBPACK_IMPORTED_MODULE_54__ = __webpack_require__(/*! ../react/string-viewer */ "./src/react/string-viewer.tsx");
/* harmony reexport (safe) */ __webpack_require__.d(__webpack_exports__, "SurveyLocStringViewer", function() { return _react_string_viewer__WEBPACK_IMPORTED_MODULE_54__["SurveyLocStringViewer"]; });

/* harmony import */ var _react_string_editor__WEBPACK_IMPORTED_MODULE_55__ = __webpack_require__(/*! ../react/string-editor */ "./src/react/string-editor.tsx");
/* harmony reexport (safe) */ __webpack_require__.d(__webpack_exports__, "SurveyLocStringEditor", function() { return _react_string_editor__WEBPACK_IMPORTED_MODULE_55__["SurveyLocStringEditor"]; });

/* harmony import */ var _utils_responsivity_manager__WEBPACK_IMPORTED_MODULE_56__ = __webpack_require__(/*! ../utils/responsivity-manager */ "./src/utils/responsivity-manager.ts");
/* harmony reexport (safe) */ __webpack_require__.d(__webpack_exports__, "ResponsivityManager", function() { return _utils_responsivity_manager__WEBPACK_IMPORTED_MODULE_56__["ResponsivityManager"]; });

/* harmony reexport (safe) */ __webpack_require__.d(__webpack_exports__, "VerticalResponsivityManager", function() { return _utils_responsivity_manager__WEBPACK_IMPORTED_MODULE_56__["VerticalResponsivityManager"]; });

/* harmony import */ var _utils_utils__WEBPACK_IMPORTED_MODULE_57__ = __webpack_require__(/*! ../utils/utils */ "./src/utils/utils.ts");
/* harmony reexport (safe) */ __webpack_require__.d(__webpack_exports__, "unwrap", function() { return _utils_utils__WEBPACK_IMPORTED_MODULE_57__["unwrap"]; });

// react




























































//Uncomment to include the "date" question type.
//export {default as SurveyQuestionDate} from "../plugins/react/reactquestiondate";


/***/ }),

/***/ "./src/entries/react.ts":
/*!******************************!*\
  !*** ./src/entries/react.ts ***!
  \******************************/
/*! exports provided: Version, settings, Helpers, AnswerCountValidator, EmailValidator, NumericValidator, RegexValidator, SurveyValidator, TextValidator, ValidatorResult, ExpressionValidator, ValidatorRunner, ItemValue, Base, Event, ArrayChanges, ComputedUpdater, SurveyError, SurveyElementCore, SurveyElement, DragTypeOverMeEnum, CalculatedValue, CustomError, AnswerRequiredError, OneAnswerRequiredError, RequreNumericError, ExceedSizeError, LocalizableString, LocalizableStrings, HtmlConditionItem, UrlConditionItem, ChoicesRestful, ChoicesRestfull, FunctionFactory, registerFunction, ConditionRunner, ExpressionRunner, Operand, Const, BinaryOperand, Variable, FunctionOperand, ArrayOperand, ConditionsParser, ProcessValue, JsonError, JsonIncorrectTypeError, JsonMetadata, JsonMetadataClass, JsonMissingTypeError, JsonMissingTypeErrorBase, JsonObject, JsonObjectProperty, JsonRequiredPropertyError, JsonUnknownPropertyError, Serializer, property, propertyArray, MatrixDropdownCell, MatrixDropdownRowModelBase, QuestionMatrixDropdownModelBase, MatrixDropdownColumn, matrixDropdownColumnTypes, QuestionMatrixDropdownRenderedCell, QuestionMatrixDropdownRenderedRow, QuestionMatrixDropdownRenderedTable, MatrixDropdownRowModel, QuestionMatrixDropdownModel, MatrixDynamicRowModel, QuestionMatrixDynamicModel, MatrixRowModel, MatrixCells, QuestionMatrixModel, MultipleTextItemModel, QuestionMultipleTextModel, PanelModel, PanelModelBase, QuestionRowModel, FlowPanelModel, PageModel, DefaultTitleModel, Question, QuestionNonValue, QuestionEmptyModel, QuestionCheckboxBase, QuestionSelectBase, QuestionCheckboxModel, QuestionRankingModel, QuestionCommentModel, QuestionDropdownModel, QuestionFactory, ElementFactory, QuestionFileModel, QuestionHtmlModel, QuestionRadiogroupModel, QuestionRatingModel, QuestionExpressionModel, QuestionTextModel, QuestionBooleanModel, QuestionImagePickerModel, ImageItemValue, QuestionImageModel, QuestionSignaturePadModel, QuestionPanelDynamicModel, QuestionPanelDynamicItem, SurveyTimer, SurveyProgressModel, SurveyProgressButtonsModel, SurveyModel, SurveyTrigger, SurveyTriggerComplete, SurveyTriggerSetValue, SurveyTriggerVisible, SurveyTriggerCopyValue, SurveyTriggerRunExpression, Trigger, SurveyWindowModel, TextPreProcessor, dxSurveyService, englishStrings, surveyLocalization, surveyStrings, QuestionCustomWidget, CustomWidgetCollection, QuestionCustomModel, QuestionCompositeModel, ComponentQuestionJSON, ComponentCollection, StylesManager, ListModel, PopupModel, PopupBaseViewModel, createPopupModalViewModel, QuestionButtonGroupModel, ButtonGroupItemModel, ButtonGroupItemValue, IsMobile, confirmAction, detectIEOrEdge, doKey2ClickUp, doKey2ClickDown, loadFileFromBase64, increaseHeightByContent, createSvg, CssClassBuilder, surveyCss, DragDropSurveyElements, DragDropChoices, defaultStandardCss, defaultBootstrapCss, defaultBootstrapMaterialCss, defaultV2Css, modernCss, SvgBundleViewModel, RendererFactory, ResponsivityManager, VerticalResponsivityManager, unwrap, Action, AdaptiveActionContainer, ActionContainer, TooltipManager, Survey, attachKey2click, Model, WindowModel, SurveyNavigationBase, SurveyTimerPanel, SurveyNavigation, SurveyPage, SurveyRow, SurveyPanel, SurveyFlowPanel, SurveyQuestion, SurveyElementErrors, SurveyQuestionAndErrorsCell, SurveyElementBase, SurveyQuestionElementBase, SurveyQuestionCommentItem, SurveyQuestionComment, SurveyQuestionCheckbox, SurveyQuestionCheckboxItem, SurveyQuestionRanking, SurveyQuestionRankingItem, SurveyQuestionDropdown, SurveyQuestionMatrix, SurveyQuestionMatrixRow, SurveyQuestionHtml, SurveyQuestionFile, SurveyQuestionMultipleText, SurveyQuestionRadiogroup, SurveyQuestionText, SurveyQuestionBoolean, SurveyQuestionBooleanCheckbox, SurveyQuestionEmpty, SurveyQuestionMatrixDropdownCell, SurveyQuestionMatrixDropdown, SurveyQuestionMatrixDynamic, SurveyQuestionPanelDynamic, SurveyProgress, SurveyProgressButtons, SurveyQuestionRating, SurveyQuestionExpression, SurveyWindow, ReactQuestionFactory, ReactElementFactory, SurveyQuestionImagePicker, SurveyQuestionImage, SurveyQuestionSignaturePad, SurveyQuestionButtonGroup, SurveyQuestionCustom, SurveyQuestionComposite, DefaultTitle, Popup, List, TitleActions, TitleElement, SurveyActionBar, LogoImage, SurveyHeader, SvgIcon, SurveyQuestionMatrixDynamicRemoveButton, SurveyQuestionMatrixDetailButton, SurveyQuestionMatrixDynamicDragDropIcon, MatrixRow, Skeleton, SurveyLocStringViewer, SurveyLocStringEditor */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony import */ var _core__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./core */ "./src/entries/core.ts");
/* harmony reexport (safe) */ __webpack_require__.d(__webpack_exports__, "Version", function() { return _core__WEBPACK_IMPORTED_MODULE_0__["Version"]; });

/* harmony reexport (safe) */ __webpack_require__.d(__webpack_exports__, "settings", function() { return _core__WEBPACK_IMPORTED_MODULE_0__["settings"]; });

/* harmony reexport (safe) */ __webpack_require__.d(__webpack_exports__, "Helpers", function() { return _core__WEBPACK_IMPORTED_MODULE_0__["Helpers"]; });

/* harmony reexport (safe) */ __webpack_require__.d(__webpack_exports__, "AnswerCountValidator", function() { return _core__WEBPACK_IMPORTED_MODULE_0__["AnswerCountValidator"]; });

/* harmony reexport (safe) */ __webpack_require__.d(__webpack_exports__, "EmailValidator", function() { return _core__WEBPACK_IMPORTED_MODULE_0__["EmailValidator"]; });

/* harmony reexport (safe) */ __webpack_require__.d(__webpack_exports__, "NumericValidator", function() { return _core__WEBPACK_IMPORTED_MODULE_0__["NumericValidator"]; });

/* harmony reexport (safe) */ __webpack_require__.d(__webpack_exports__, "RegexValidator", function() { return _core__WEBPACK_IMPORTED_MODULE_0__["RegexValidator"]; });

/* harmony reexport (safe) */ __webpack_require__.d(__webpack_exports__, "SurveyValidator", function() { return _core__WEBPACK_IMPORTED_MODULE_0__["SurveyValidator"]; });

/* harmony reexport (safe) */ __webpack_require__.d(__webpack_exports__, "TextValidator", function() { return _core__WEBPACK_IMPORTED_MODULE_0__["TextValidator"]; });

/* harmony reexport (safe) */ __webpack_require__.d(__webpack_exports__, "ValidatorResult", function() { return _core__WEBPACK_IMPORTED_MODULE_0__["ValidatorResult"]; });

/* harmony reexport (safe) */ __webpack_require__.d(__webpack_exports__, "ExpressionValidator", function() { return _core__WEBPACK_IMPORTED_MODULE_0__["ExpressionValidator"]; });

/* harmony reexport (safe) */ __webpack_require__.d(__webpack_exports__, "ValidatorRunner", function() { return _core__WEBPACK_IMPORTED_MODULE_0__["ValidatorRunner"]; });

/* harmony reexport (safe) */ __webpack_require__.d(__webpack_exports__, "ItemValue", function() { return _core__WEBPACK_IMPORTED_MODULE_0__["ItemValue"]; });

/* harmony reexport (safe) */ __webpack_require__.d(__webpack_exports__, "Base", function() { return _core__WEBPACK_IMPORTED_MODULE_0__["Base"]; });

/* harmony reexport (safe) */ __webpack_require__.d(__webpack_exports__, "Event", function() { return _core__WEBPACK_IMPORTED_MODULE_0__["Event"]; });

/* harmony reexport (safe) */ __webpack_require__.d(__webpack_exports__, "ArrayChanges", function() { return _core__WEBPACK_IMPORTED_MODULE_0__["ArrayChanges"]; });

/* harmony reexport (safe) */ __webpack_require__.d(__webpack_exports__, "ComputedUpdater", function() { return _core__WEBPACK_IMPORTED_MODULE_0__["ComputedUpdater"]; });

/* harmony reexport (safe) */ __webpack_require__.d(__webpack_exports__, "SurveyError", function() { return _core__WEBPACK_IMPORTED_MODULE_0__["SurveyError"]; });

/* harmony reexport (safe) */ __webpack_require__.d(__webpack_exports__, "SurveyElementCore", function() { return _core__WEBPACK_IMPORTED_MODULE_0__["SurveyElementCore"]; });

/* harmony reexport (safe) */ __webpack_require__.d(__webpack_exports__, "SurveyElement", function() { return _core__WEBPACK_IMPORTED_MODULE_0__["SurveyElement"]; });

/* harmony reexport (safe) */ __webpack_require__.d(__webpack_exports__, "DragTypeOverMeEnum", function() { return _core__WEBPACK_IMPORTED_MODULE_0__["DragTypeOverMeEnum"]; });

/* harmony reexport (safe) */ __webpack_require__.d(__webpack_exports__, "CalculatedValue", function() { return _core__WEBPACK_IMPORTED_MODULE_0__["CalculatedValue"]; });

/* harmony reexport (safe) */ __webpack_require__.d(__webpack_exports__, "CustomError", function() { return _core__WEBPACK_IMPORTED_MODULE_0__["CustomError"]; });

/* harmony reexport (safe) */ __webpack_require__.d(__webpack_exports__, "AnswerRequiredError", function() { return _core__WEBPACK_IMPORTED_MODULE_0__["AnswerRequiredError"]; });

/* harmony reexport (safe) */ __webpack_require__.d(__webpack_exports__, "OneAnswerRequiredError", function() { return _core__WEBPACK_IMPORTED_MODULE_0__["OneAnswerRequiredError"]; });

/* harmony reexport (safe) */ __webpack_require__.d(__webpack_exports__, "RequreNumericError", function() { return _core__WEBPACK_IMPORTED_MODULE_0__["RequreNumericError"]; });

/* harmony reexport (safe) */ __webpack_require__.d(__webpack_exports__, "ExceedSizeError", function() { return _core__WEBPACK_IMPORTED_MODULE_0__["ExceedSizeError"]; });

/* harmony reexport (safe) */ __webpack_require__.d(__webpack_exports__, "LocalizableString", function() { return _core__WEBPACK_IMPORTED_MODULE_0__["LocalizableString"]; });

/* harmony reexport (safe) */ __webpack_require__.d(__webpack_exports__, "LocalizableStrings", function() { return _core__WEBPACK_IMPORTED_MODULE_0__["LocalizableStrings"]; });

/* harmony reexport (safe) */ __webpack_require__.d(__webpack_exports__, "HtmlConditionItem", function() { return _core__WEBPACK_IMPORTED_MODULE_0__["HtmlConditionItem"]; });

/* harmony reexport (safe) */ __webpack_require__.d(__webpack_exports__, "UrlConditionItem", function() { return _core__WEBPACK_IMPORTED_MODULE_0__["UrlConditionItem"]; });

/* harmony reexport (safe) */ __webpack_require__.d(__webpack_exports__, "ChoicesRestful", function() { return _core__WEBPACK_IMPORTED_MODULE_0__["ChoicesRestful"]; });

/* harmony reexport (safe) */ __webpack_require__.d(__webpack_exports__, "ChoicesRestfull", function() { return _core__WEBPACK_IMPORTED_MODULE_0__["ChoicesRestfull"]; });

/* harmony reexport (safe) */ __webpack_require__.d(__webpack_exports__, "FunctionFactory", function() { return _core__WEBPACK_IMPORTED_MODULE_0__["FunctionFactory"]; });

/* harmony reexport (safe) */ __webpack_require__.d(__webpack_exports__, "registerFunction", function() { return _core__WEBPACK_IMPORTED_MODULE_0__["registerFunction"]; });

/* harmony reexport (safe) */ __webpack_require__.d(__webpack_exports__, "ConditionRunner", function() { return _core__WEBPACK_IMPORTED_MODULE_0__["ConditionRunner"]; });

/* harmony reexport (safe) */ __webpack_require__.d(__webpack_exports__, "ExpressionRunner", function() { return _core__WEBPACK_IMPORTED_MODULE_0__["ExpressionRunner"]; });

/* harmony reexport (safe) */ __webpack_require__.d(__webpack_exports__, "Operand", function() { return _core__WEBPACK_IMPORTED_MODULE_0__["Operand"]; });

/* harmony reexport (safe) */ __webpack_require__.d(__webpack_exports__, "Const", function() { return _core__WEBPACK_IMPORTED_MODULE_0__["Const"]; });

/* harmony reexport (safe) */ __webpack_require__.d(__webpack_exports__, "BinaryOperand", function() { return _core__WEBPACK_IMPORTED_MODULE_0__["BinaryOperand"]; });

/* harmony reexport (safe) */ __webpack_require__.d(__webpack_exports__, "Variable", function() { return _core__WEBPACK_IMPORTED_MODULE_0__["Variable"]; });

/* harmony reexport (safe) */ __webpack_require__.d(__webpack_exports__, "FunctionOperand", function() { return _core__WEBPACK_IMPORTED_MODULE_0__["FunctionOperand"]; });

/* harmony reexport (safe) */ __webpack_require__.d(__webpack_exports__, "ArrayOperand", function() { return _core__WEBPACK_IMPORTED_MODULE_0__["ArrayOperand"]; });

/* harmony reexport (safe) */ __webpack_require__.d(__webpack_exports__, "ConditionsParser", function() { return _core__WEBPACK_IMPORTED_MODULE_0__["ConditionsParser"]; });

/* harmony reexport (safe) */ __webpack_require__.d(__webpack_exports__, "ProcessValue", function() { return _core__WEBPACK_IMPORTED_MODULE_0__["ProcessValue"]; });

/* harmony reexport (safe) */ __webpack_require__.d(__webpack_exports__, "JsonError", function() { return _core__WEBPACK_IMPORTED_MODULE_0__["JsonError"]; });

/* harmony reexport (safe) */ __webpack_require__.d(__webpack_exports__, "JsonIncorrectTypeError", function() { return _core__WEBPACK_IMPORTED_MODULE_0__["JsonIncorrectTypeError"]; });

/* harmony reexport (safe) */ __webpack_require__.d(__webpack_exports__, "JsonMetadata", function() { return _core__WEBPACK_IMPORTED_MODULE_0__["JsonMetadata"]; });

/* harmony reexport (safe) */ __webpack_require__.d(__webpack_exports__, "JsonMetadataClass", function() { return _core__WEBPACK_IMPORTED_MODULE_0__["JsonMetadataClass"]; });

/* harmony reexport (safe) */ __webpack_require__.d(__webpack_exports__, "JsonMissingTypeError", function() { return _core__WEBPACK_IMPORTED_MODULE_0__["JsonMissingTypeError"]; });

/* harmony reexport (safe) */ __webpack_require__.d(__webpack_exports__, "JsonMissingTypeErrorBase", function() { return _core__WEBPACK_IMPORTED_MODULE_0__["JsonMissingTypeErrorBase"]; });

/* harmony reexport (safe) */ __webpack_require__.d(__webpack_exports__, "JsonObject", function() { return _core__WEBPACK_IMPORTED_MODULE_0__["JsonObject"]; });

/* harmony reexport (safe) */ __webpack_require__.d(__webpack_exports__, "JsonObjectProperty", function() { return _core__WEBPACK_IMPORTED_MODULE_0__["JsonObjectProperty"]; });

/* harmony reexport (safe) */ __webpack_require__.d(__webpack_exports__, "JsonRequiredPropertyError", function() { return _core__WEBPACK_IMPORTED_MODULE_0__["JsonRequiredPropertyError"]; });

/* harmony reexport (safe) */ __webpack_require__.d(__webpack_exports__, "JsonUnknownPropertyError", function() { return _core__WEBPACK_IMPORTED_MODULE_0__["JsonUnknownPropertyError"]; });

/* harmony reexport (safe) */ __webpack_require__.d(__webpack_exports__, "Serializer", function() { return _core__WEBPACK_IMPORTED_MODULE_0__["Serializer"]; });

/* harmony reexport (safe) */ __webpack_require__.d(__webpack_exports__, "property", function() { return _core__WEBPACK_IMPORTED_MODULE_0__["property"]; });

/* harmony reexport (safe) */ __webpack_require__.d(__webpack_exports__, "propertyArray", function() { return _core__WEBPACK_IMPORTED_MODULE_0__["propertyArray"]; });

/* harmony reexport (safe) */ __webpack_require__.d(__webpack_exports__, "MatrixDropdownCell", function() { return _core__WEBPACK_IMPORTED_MODULE_0__["MatrixDropdownCell"]; });

/* harmony reexport (safe) */ __webpack_require__.d(__webpack_exports__, "MatrixDropdownRowModelBase", function() { return _core__WEBPACK_IMPORTED_MODULE_0__["MatrixDropdownRowModelBase"]; });

/* harmony reexport (safe) */ __webpack_require__.d(__webpack_exports__, "QuestionMatrixDropdownModelBase", function() { return _core__WEBPACK_IMPORTED_MODULE_0__["QuestionMatrixDropdownModelBase"]; });

/* harmony reexport (safe) */ __webpack_require__.d(__webpack_exports__, "MatrixDropdownColumn", function() { return _core__WEBPACK_IMPORTED_MODULE_0__["MatrixDropdownColumn"]; });

/* harmony reexport (safe) */ __webpack_require__.d(__webpack_exports__, "matrixDropdownColumnTypes", function() { return _core__WEBPACK_IMPORTED_MODULE_0__["matrixDropdownColumnTypes"]; });

/* harmony reexport (safe) */ __webpack_require__.d(__webpack_exports__, "QuestionMatrixDropdownRenderedCell", function() { return _core__WEBPACK_IMPORTED_MODULE_0__["QuestionMatrixDropdownRenderedCell"]; });

/* harmony reexport (safe) */ __webpack_require__.d(__webpack_exports__, "QuestionMatrixDropdownRenderedRow", function() { return _core__WEBPACK_IMPORTED_MODULE_0__["QuestionMatrixDropdownRenderedRow"]; });

/* harmony reexport (safe) */ __webpack_require__.d(__webpack_exports__, "QuestionMatrixDropdownRenderedTable", function() { return _core__WEBPACK_IMPORTED_MODULE_0__["QuestionMatrixDropdownRenderedTable"]; });

/* harmony reexport (safe) */ __webpack_require__.d(__webpack_exports__, "MatrixDropdownRowModel", function() { return _core__WEBPACK_IMPORTED_MODULE_0__["MatrixDropdownRowModel"]; });

/* harmony reexport (safe) */ __webpack_require__.d(__webpack_exports__, "QuestionMatrixDropdownModel", function() { return _core__WEBPACK_IMPORTED_MODULE_0__["QuestionMatrixDropdownModel"]; });

/* harmony reexport (safe) */ __webpack_require__.d(__webpack_exports__, "MatrixDynamicRowModel", function() { return _core__WEBPACK_IMPORTED_MODULE_0__["MatrixDynamicRowModel"]; });

/* harmony reexport (safe) */ __webpack_require__.d(__webpack_exports__, "QuestionMatrixDynamicModel", function() { return _core__WEBPACK_IMPORTED_MODULE_0__["QuestionMatrixDynamicModel"]; });

/* harmony reexport (safe) */ __webpack_require__.d(__webpack_exports__, "MatrixRowModel", function() { return _core__WEBPACK_IMPORTED_MODULE_0__["MatrixRowModel"]; });

/* harmony reexport (safe) */ __webpack_require__.d(__webpack_exports__, "MatrixCells", function() { return _core__WEBPACK_IMPORTED_MODULE_0__["MatrixCells"]; });

/* harmony reexport (safe) */ __webpack_require__.d(__webpack_exports__, "QuestionMatrixModel", function() { return _core__WEBPACK_IMPORTED_MODULE_0__["QuestionMatrixModel"]; });

/* harmony reexport (safe) */ __webpack_require__.d(__webpack_exports__, "MultipleTextItemModel", function() { return _core__WEBPACK_IMPORTED_MODULE_0__["MultipleTextItemModel"]; });

/* harmony reexport (safe) */ __webpack_require__.d(__webpack_exports__, "QuestionMultipleTextModel", function() { return _core__WEBPACK_IMPORTED_MODULE_0__["QuestionMultipleTextModel"]; });

/* harmony reexport (safe) */ __webpack_require__.d(__webpack_exports__, "PanelModel", function() { return _core__WEBPACK_IMPORTED_MODULE_0__["PanelModel"]; });

/* harmony reexport (safe) */ __webpack_require__.d(__webpack_exports__, "PanelModelBase", function() { return _core__WEBPACK_IMPORTED_MODULE_0__["PanelModelBase"]; });

/* harmony reexport (safe) */ __webpack_require__.d(__webpack_exports__, "QuestionRowModel", function() { return _core__WEBPACK_IMPORTED_MODULE_0__["QuestionRowModel"]; });

/* harmony reexport (safe) */ __webpack_require__.d(__webpack_exports__, "FlowPanelModel", function() { return _core__WEBPACK_IMPORTED_MODULE_0__["FlowPanelModel"]; });

/* harmony reexport (safe) */ __webpack_require__.d(__webpack_exports__, "PageModel", function() { return _core__WEBPACK_IMPORTED_MODULE_0__["PageModel"]; });

/* harmony reexport (safe) */ __webpack_require__.d(__webpack_exports__, "DefaultTitleModel", function() { return _core__WEBPACK_IMPORTED_MODULE_0__["DefaultTitleModel"]; });

/* harmony reexport (safe) */ __webpack_require__.d(__webpack_exports__, "Question", function() { return _core__WEBPACK_IMPORTED_MODULE_0__["Question"]; });

/* harmony reexport (safe) */ __webpack_require__.d(__webpack_exports__, "QuestionNonValue", function() { return _core__WEBPACK_IMPORTED_MODULE_0__["QuestionNonValue"]; });

/* harmony reexport (safe) */ __webpack_require__.d(__webpack_exports__, "QuestionEmptyModel", function() { return _core__WEBPACK_IMPORTED_MODULE_0__["QuestionEmptyModel"]; });

/* harmony reexport (safe) */ __webpack_require__.d(__webpack_exports__, "QuestionCheckboxBase", function() { return _core__WEBPACK_IMPORTED_MODULE_0__["QuestionCheckboxBase"]; });

/* harmony reexport (safe) */ __webpack_require__.d(__webpack_exports__, "QuestionSelectBase", function() { return _core__WEBPACK_IMPORTED_MODULE_0__["QuestionSelectBase"]; });

/* harmony reexport (safe) */ __webpack_require__.d(__webpack_exports__, "QuestionCheckboxModel", function() { return _core__WEBPACK_IMPORTED_MODULE_0__["QuestionCheckboxModel"]; });

/* harmony reexport (safe) */ __webpack_require__.d(__webpack_exports__, "QuestionRankingModel", function() { return _core__WEBPACK_IMPORTED_MODULE_0__["QuestionRankingModel"]; });

/* harmony reexport (safe) */ __webpack_require__.d(__webpack_exports__, "QuestionCommentModel", function() { return _core__WEBPACK_IMPORTED_MODULE_0__["QuestionCommentModel"]; });

/* harmony reexport (safe) */ __webpack_require__.d(__webpack_exports__, "QuestionDropdownModel", function() { return _core__WEBPACK_IMPORTED_MODULE_0__["QuestionDropdownModel"]; });

/* harmony reexport (safe) */ __webpack_require__.d(__webpack_exports__, "QuestionFactory", function() { return _core__WEBPACK_IMPORTED_MODULE_0__["QuestionFactory"]; });

/* harmony reexport (safe) */ __webpack_require__.d(__webpack_exports__, "ElementFactory", function() { return _core__WEBPACK_IMPORTED_MODULE_0__["ElementFactory"]; });

/* harmony reexport (safe) */ __webpack_require__.d(__webpack_exports__, "QuestionFileModel", function() { return _core__WEBPACK_IMPORTED_MODULE_0__["QuestionFileModel"]; });

/* harmony reexport (safe) */ __webpack_require__.d(__webpack_exports__, "QuestionHtmlModel", function() { return _core__WEBPACK_IMPORTED_MODULE_0__["QuestionHtmlModel"]; });

/* harmony reexport (safe) */ __webpack_require__.d(__webpack_exports__, "QuestionRadiogroupModel", function() { return _core__WEBPACK_IMPORTED_MODULE_0__["QuestionRadiogroupModel"]; });

/* harmony reexport (safe) */ __webpack_require__.d(__webpack_exports__, "QuestionRatingModel", function() { return _core__WEBPACK_IMPORTED_MODULE_0__["QuestionRatingModel"]; });

/* harmony reexport (safe) */ __webpack_require__.d(__webpack_exports__, "QuestionExpressionModel", function() { return _core__WEBPACK_IMPORTED_MODULE_0__["QuestionExpressionModel"]; });

/* harmony reexport (safe) */ __webpack_require__.d(__webpack_exports__, "QuestionTextModel", function() { return _core__WEBPACK_IMPORTED_MODULE_0__["QuestionTextModel"]; });

/* harmony reexport (safe) */ __webpack_require__.d(__webpack_exports__, "QuestionBooleanModel", function() { return _core__WEBPACK_IMPORTED_MODULE_0__["QuestionBooleanModel"]; });

/* harmony reexport (safe) */ __webpack_require__.d(__webpack_exports__, "QuestionImagePickerModel", function() { return _core__WEBPACK_IMPORTED_MODULE_0__["QuestionImagePickerModel"]; });

/* harmony reexport (safe) */ __webpack_require__.d(__webpack_exports__, "ImageItemValue", function() { return _core__WEBPACK_IMPORTED_MODULE_0__["ImageItemValue"]; });

/* harmony reexport (safe) */ __webpack_require__.d(__webpack_exports__, "QuestionImageModel", function() { return _core__WEBPACK_IMPORTED_MODULE_0__["QuestionImageModel"]; });

/* harmony reexport (safe) */ __webpack_require__.d(__webpack_exports__, "QuestionSignaturePadModel", function() { return _core__WEBPACK_IMPORTED_MODULE_0__["QuestionSignaturePadModel"]; });

/* harmony reexport (safe) */ __webpack_require__.d(__webpack_exports__, "QuestionPanelDynamicModel", function() { return _core__WEBPACK_IMPORTED_MODULE_0__["QuestionPanelDynamicModel"]; });

/* harmony reexport (safe) */ __webpack_require__.d(__webpack_exports__, "QuestionPanelDynamicItem", function() { return _core__WEBPACK_IMPORTED_MODULE_0__["QuestionPanelDynamicItem"]; });

/* harmony reexport (safe) */ __webpack_require__.d(__webpack_exports__, "SurveyTimer", function() { return _core__WEBPACK_IMPORTED_MODULE_0__["SurveyTimer"]; });

/* harmony reexport (safe) */ __webpack_require__.d(__webpack_exports__, "SurveyProgressModel", function() { return _core__WEBPACK_IMPORTED_MODULE_0__["SurveyProgressModel"]; });

/* harmony reexport (safe) */ __webpack_require__.d(__webpack_exports__, "SurveyProgressButtonsModel", function() { return _core__WEBPACK_IMPORTED_MODULE_0__["SurveyProgressButtonsModel"]; });

/* harmony reexport (safe) */ __webpack_require__.d(__webpack_exports__, "SurveyModel", function() { return _core__WEBPACK_IMPORTED_MODULE_0__["SurveyModel"]; });

/* harmony reexport (safe) */ __webpack_require__.d(__webpack_exports__, "SurveyTrigger", function() { return _core__WEBPACK_IMPORTED_MODULE_0__["SurveyTrigger"]; });

/* harmony reexport (safe) */ __webpack_require__.d(__webpack_exports__, "SurveyTriggerComplete", function() { return _core__WEBPACK_IMPORTED_MODULE_0__["SurveyTriggerComplete"]; });

/* harmony reexport (safe) */ __webpack_require__.d(__webpack_exports__, "SurveyTriggerSetValue", function() { return _core__WEBPACK_IMPORTED_MODULE_0__["SurveyTriggerSetValue"]; });

/* harmony reexport (safe) */ __webpack_require__.d(__webpack_exports__, "SurveyTriggerVisible", function() { return _core__WEBPACK_IMPORTED_MODULE_0__["SurveyTriggerVisible"]; });

/* harmony reexport (safe) */ __webpack_require__.d(__webpack_exports__, "SurveyTriggerCopyValue", function() { return _core__WEBPACK_IMPORTED_MODULE_0__["SurveyTriggerCopyValue"]; });

/* harmony reexport (safe) */ __webpack_require__.d(__webpack_exports__, "SurveyTriggerRunExpression", function() { return _core__WEBPACK_IMPORTED_MODULE_0__["SurveyTriggerRunExpression"]; });

/* harmony reexport (safe) */ __webpack_require__.d(__webpack_exports__, "Trigger", function() { return _core__WEBPACK_IMPORTED_MODULE_0__["Trigger"]; });

/* harmony reexport (safe) */ __webpack_require__.d(__webpack_exports__, "SurveyWindowModel", function() { return _core__WEBPACK_IMPORTED_MODULE_0__["SurveyWindowModel"]; });

/* harmony reexport (safe) */ __webpack_require__.d(__webpack_exports__, "TextPreProcessor", function() { return _core__WEBPACK_IMPORTED_MODULE_0__["TextPreProcessor"]; });

/* harmony reexport (safe) */ __webpack_require__.d(__webpack_exports__, "dxSurveyService", function() { return _core__WEBPACK_IMPORTED_MODULE_0__["dxSurveyService"]; });

/* harmony reexport (safe) */ __webpack_require__.d(__webpack_exports__, "englishStrings", function() { return _core__WEBPACK_IMPORTED_MODULE_0__["englishStrings"]; });

/* harmony reexport (safe) */ __webpack_require__.d(__webpack_exports__, "surveyLocalization", function() { return _core__WEBPACK_IMPORTED_MODULE_0__["surveyLocalization"]; });

/* harmony reexport (safe) */ __webpack_require__.d(__webpack_exports__, "surveyStrings", function() { return _core__WEBPACK_IMPORTED_MODULE_0__["surveyStrings"]; });

/* harmony reexport (safe) */ __webpack_require__.d(__webpack_exports__, "QuestionCustomWidget", function() { return _core__WEBPACK_IMPORTED_MODULE_0__["QuestionCustomWidget"]; });

/* harmony reexport (safe) */ __webpack_require__.d(__webpack_exports__, "CustomWidgetCollection", function() { return _core__WEBPACK_IMPORTED_MODULE_0__["CustomWidgetCollection"]; });

/* harmony reexport (safe) */ __webpack_require__.d(__webpack_exports__, "QuestionCustomModel", function() { return _core__WEBPACK_IMPORTED_MODULE_0__["QuestionCustomModel"]; });

/* harmony reexport (safe) */ __webpack_require__.d(__webpack_exports__, "QuestionCompositeModel", function() { return _core__WEBPACK_IMPORTED_MODULE_0__["QuestionCompositeModel"]; });

/* harmony reexport (safe) */ __webpack_require__.d(__webpack_exports__, "ComponentQuestionJSON", function() { return _core__WEBPACK_IMPORTED_MODULE_0__["ComponentQuestionJSON"]; });

/* harmony reexport (safe) */ __webpack_require__.d(__webpack_exports__, "ComponentCollection", function() { return _core__WEBPACK_IMPORTED_MODULE_0__["ComponentCollection"]; });

/* harmony reexport (safe) */ __webpack_require__.d(__webpack_exports__, "StylesManager", function() { return _core__WEBPACK_IMPORTED_MODULE_0__["StylesManager"]; });

/* harmony reexport (safe) */ __webpack_require__.d(__webpack_exports__, "ListModel", function() { return _core__WEBPACK_IMPORTED_MODULE_0__["ListModel"]; });

/* harmony reexport (safe) */ __webpack_require__.d(__webpack_exports__, "PopupModel", function() { return _core__WEBPACK_IMPORTED_MODULE_0__["PopupModel"]; });

/* harmony reexport (safe) */ __webpack_require__.d(__webpack_exports__, "PopupBaseViewModel", function() { return _core__WEBPACK_IMPORTED_MODULE_0__["PopupBaseViewModel"]; });

/* harmony reexport (safe) */ __webpack_require__.d(__webpack_exports__, "createPopupModalViewModel", function() { return _core__WEBPACK_IMPORTED_MODULE_0__["createPopupModalViewModel"]; });

/* harmony reexport (safe) */ __webpack_require__.d(__webpack_exports__, "QuestionButtonGroupModel", function() { return _core__WEBPACK_IMPORTED_MODULE_0__["QuestionButtonGroupModel"]; });

/* harmony reexport (safe) */ __webpack_require__.d(__webpack_exports__, "ButtonGroupItemModel", function() { return _core__WEBPACK_IMPORTED_MODULE_0__["ButtonGroupItemModel"]; });

/* harmony reexport (safe) */ __webpack_require__.d(__webpack_exports__, "ButtonGroupItemValue", function() { return _core__WEBPACK_IMPORTED_MODULE_0__["ButtonGroupItemValue"]; });

/* harmony reexport (safe) */ __webpack_require__.d(__webpack_exports__, "IsMobile", function() { return _core__WEBPACK_IMPORTED_MODULE_0__["IsMobile"]; });

/* harmony reexport (safe) */ __webpack_require__.d(__webpack_exports__, "confirmAction", function() { return _core__WEBPACK_IMPORTED_MODULE_0__["confirmAction"]; });

/* harmony reexport (safe) */ __webpack_require__.d(__webpack_exports__, "detectIEOrEdge", function() { return _core__WEBPACK_IMPORTED_MODULE_0__["detectIEOrEdge"]; });

/* harmony reexport (safe) */ __webpack_require__.d(__webpack_exports__, "doKey2ClickUp", function() { return _core__WEBPACK_IMPORTED_MODULE_0__["doKey2ClickUp"]; });

/* harmony reexport (safe) */ __webpack_require__.d(__webpack_exports__, "doKey2ClickDown", function() { return _core__WEBPACK_IMPORTED_MODULE_0__["doKey2ClickDown"]; });

/* harmony reexport (safe) */ __webpack_require__.d(__webpack_exports__, "loadFileFromBase64", function() { return _core__WEBPACK_IMPORTED_MODULE_0__["loadFileFromBase64"]; });

/* harmony reexport (safe) */ __webpack_require__.d(__webpack_exports__, "increaseHeightByContent", function() { return _core__WEBPACK_IMPORTED_MODULE_0__["increaseHeightByContent"]; });

/* harmony reexport (safe) */ __webpack_require__.d(__webpack_exports__, "createSvg", function() { return _core__WEBPACK_IMPORTED_MODULE_0__["createSvg"]; });

/* harmony reexport (safe) */ __webpack_require__.d(__webpack_exports__, "CssClassBuilder", function() { return _core__WEBPACK_IMPORTED_MODULE_0__["CssClassBuilder"]; });

/* harmony reexport (safe) */ __webpack_require__.d(__webpack_exports__, "surveyCss", function() { return _core__WEBPACK_IMPORTED_MODULE_0__["surveyCss"]; });

/* harmony reexport (safe) */ __webpack_require__.d(__webpack_exports__, "DragDropSurveyElements", function() { return _core__WEBPACK_IMPORTED_MODULE_0__["DragDropSurveyElements"]; });

/* harmony reexport (safe) */ __webpack_require__.d(__webpack_exports__, "DragDropChoices", function() { return _core__WEBPACK_IMPORTED_MODULE_0__["DragDropChoices"]; });

/* harmony reexport (safe) */ __webpack_require__.d(__webpack_exports__, "defaultStandardCss", function() { return _core__WEBPACK_IMPORTED_MODULE_0__["defaultStandardCss"]; });

/* harmony reexport (safe) */ __webpack_require__.d(__webpack_exports__, "defaultBootstrapCss", function() { return _core__WEBPACK_IMPORTED_MODULE_0__["defaultBootstrapCss"]; });

/* harmony reexport (safe) */ __webpack_require__.d(__webpack_exports__, "defaultBootstrapMaterialCss", function() { return _core__WEBPACK_IMPORTED_MODULE_0__["defaultBootstrapMaterialCss"]; });

/* harmony reexport (safe) */ __webpack_require__.d(__webpack_exports__, "defaultV2Css", function() { return _core__WEBPACK_IMPORTED_MODULE_0__["defaultV2Css"]; });

/* harmony reexport (safe) */ __webpack_require__.d(__webpack_exports__, "modernCss", function() { return _core__WEBPACK_IMPORTED_MODULE_0__["modernCss"]; });

/* harmony reexport (safe) */ __webpack_require__.d(__webpack_exports__, "SvgBundleViewModel", function() { return _core__WEBPACK_IMPORTED_MODULE_0__["SvgBundleViewModel"]; });

/* harmony reexport (safe) */ __webpack_require__.d(__webpack_exports__, "RendererFactory", function() { return _core__WEBPACK_IMPORTED_MODULE_0__["RendererFactory"]; });

/* harmony reexport (safe) */ __webpack_require__.d(__webpack_exports__, "ResponsivityManager", function() { return _core__WEBPACK_IMPORTED_MODULE_0__["ResponsivityManager"]; });

/* harmony reexport (safe) */ __webpack_require__.d(__webpack_exports__, "VerticalResponsivityManager", function() { return _core__WEBPACK_IMPORTED_MODULE_0__["VerticalResponsivityManager"]; });

/* harmony reexport (safe) */ __webpack_require__.d(__webpack_exports__, "unwrap", function() { return _core__WEBPACK_IMPORTED_MODULE_0__["unwrap"]; });

/* harmony reexport (safe) */ __webpack_require__.d(__webpack_exports__, "Action", function() { return _core__WEBPACK_IMPORTED_MODULE_0__["Action"]; });

/* harmony reexport (safe) */ __webpack_require__.d(__webpack_exports__, "AdaptiveActionContainer", function() { return _core__WEBPACK_IMPORTED_MODULE_0__["AdaptiveActionContainer"]; });

/* harmony reexport (safe) */ __webpack_require__.d(__webpack_exports__, "ActionContainer", function() { return _core__WEBPACK_IMPORTED_MODULE_0__["ActionContainer"]; });

/* harmony reexport (safe) */ __webpack_require__.d(__webpack_exports__, "TooltipManager", function() { return _core__WEBPACK_IMPORTED_MODULE_0__["TooltipManager"]; });

/* harmony import */ var _react_ui__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ./react-ui */ "./src/entries/react-ui.ts");
/* harmony reexport (safe) */ __webpack_require__.d(__webpack_exports__, "Survey", function() { return _react_ui__WEBPACK_IMPORTED_MODULE_1__["Survey"]; });

/* harmony reexport (safe) */ __webpack_require__.d(__webpack_exports__, "attachKey2click", function() { return _react_ui__WEBPACK_IMPORTED_MODULE_1__["attachKey2click"]; });

/* harmony reexport (safe) */ __webpack_require__.d(__webpack_exports__, "Model", function() { return _react_ui__WEBPACK_IMPORTED_MODULE_1__["Model"]; });

/* harmony reexport (safe) */ __webpack_require__.d(__webpack_exports__, "WindowModel", function() { return _react_ui__WEBPACK_IMPORTED_MODULE_1__["WindowModel"]; });

/* harmony reexport (safe) */ __webpack_require__.d(__webpack_exports__, "SurveyNavigationBase", function() { return _react_ui__WEBPACK_IMPORTED_MODULE_1__["SurveyNavigationBase"]; });

/* harmony reexport (safe) */ __webpack_require__.d(__webpack_exports__, "SurveyTimerPanel", function() { return _react_ui__WEBPACK_IMPORTED_MODULE_1__["SurveyTimerPanel"]; });

/* harmony reexport (safe) */ __webpack_require__.d(__webpack_exports__, "SurveyNavigation", function() { return _react_ui__WEBPACK_IMPORTED_MODULE_1__["SurveyNavigation"]; });

/* harmony reexport (safe) */ __webpack_require__.d(__webpack_exports__, "SurveyPage", function() { return _react_ui__WEBPACK_IMPORTED_MODULE_1__["SurveyPage"]; });

/* harmony reexport (safe) */ __webpack_require__.d(__webpack_exports__, "SurveyRow", function() { return _react_ui__WEBPACK_IMPORTED_MODULE_1__["SurveyRow"]; });

/* harmony reexport (safe) */ __webpack_require__.d(__webpack_exports__, "SurveyPanel", function() { return _react_ui__WEBPACK_IMPORTED_MODULE_1__["SurveyPanel"]; });

/* harmony reexport (safe) */ __webpack_require__.d(__webpack_exports__, "SurveyFlowPanel", function() { return _react_ui__WEBPACK_IMPORTED_MODULE_1__["SurveyFlowPanel"]; });

/* harmony reexport (safe) */ __webpack_require__.d(__webpack_exports__, "SurveyQuestion", function() { return _react_ui__WEBPACK_IMPORTED_MODULE_1__["SurveyQuestion"]; });

/* harmony reexport (safe) */ __webpack_require__.d(__webpack_exports__, "SurveyElementErrors", function() { return _react_ui__WEBPACK_IMPORTED_MODULE_1__["SurveyElementErrors"]; });

/* harmony reexport (safe) */ __webpack_require__.d(__webpack_exports__, "SurveyQuestionAndErrorsCell", function() { return _react_ui__WEBPACK_IMPORTED_MODULE_1__["SurveyQuestionAndErrorsCell"]; });

/* harmony reexport (safe) */ __webpack_require__.d(__webpack_exports__, "SurveyElementBase", function() { return _react_ui__WEBPACK_IMPORTED_MODULE_1__["SurveyElementBase"]; });

/* harmony reexport (safe) */ __webpack_require__.d(__webpack_exports__, "SurveyQuestionElementBase", function() { return _react_ui__WEBPACK_IMPORTED_MODULE_1__["SurveyQuestionElementBase"]; });

/* harmony reexport (safe) */ __webpack_require__.d(__webpack_exports__, "SurveyQuestionCommentItem", function() { return _react_ui__WEBPACK_IMPORTED_MODULE_1__["SurveyQuestionCommentItem"]; });

/* harmony reexport (safe) */ __webpack_require__.d(__webpack_exports__, "SurveyQuestionComment", function() { return _react_ui__WEBPACK_IMPORTED_MODULE_1__["SurveyQuestionComment"]; });

/* harmony reexport (safe) */ __webpack_require__.d(__webpack_exports__, "SurveyQuestionCheckbox", function() { return _react_ui__WEBPACK_IMPORTED_MODULE_1__["SurveyQuestionCheckbox"]; });

/* harmony reexport (safe) */ __webpack_require__.d(__webpack_exports__, "SurveyQuestionCheckboxItem", function() { return _react_ui__WEBPACK_IMPORTED_MODULE_1__["SurveyQuestionCheckboxItem"]; });

/* harmony reexport (safe) */ __webpack_require__.d(__webpack_exports__, "SurveyQuestionRanking", function() { return _react_ui__WEBPACK_IMPORTED_MODULE_1__["SurveyQuestionRanking"]; });

/* harmony reexport (safe) */ __webpack_require__.d(__webpack_exports__, "SurveyQuestionRankingItem", function() { return _react_ui__WEBPACK_IMPORTED_MODULE_1__["SurveyQuestionRankingItem"]; });

/* harmony reexport (safe) */ __webpack_require__.d(__webpack_exports__, "SurveyQuestionDropdown", function() { return _react_ui__WEBPACK_IMPORTED_MODULE_1__["SurveyQuestionDropdown"]; });

/* harmony reexport (safe) */ __webpack_require__.d(__webpack_exports__, "SurveyQuestionMatrix", function() { return _react_ui__WEBPACK_IMPORTED_MODULE_1__["SurveyQuestionMatrix"]; });

/* harmony reexport (safe) */ __webpack_require__.d(__webpack_exports__, "SurveyQuestionMatrixRow", function() { return _react_ui__WEBPACK_IMPORTED_MODULE_1__["SurveyQuestionMatrixRow"]; });

/* harmony reexport (safe) */ __webpack_require__.d(__webpack_exports__, "SurveyQuestionHtml", function() { return _react_ui__WEBPACK_IMPORTED_MODULE_1__["SurveyQuestionHtml"]; });

/* harmony reexport (safe) */ __webpack_require__.d(__webpack_exports__, "SurveyQuestionFile", function() { return _react_ui__WEBPACK_IMPORTED_MODULE_1__["SurveyQuestionFile"]; });

/* harmony reexport (safe) */ __webpack_require__.d(__webpack_exports__, "SurveyQuestionMultipleText", function() { return _react_ui__WEBPACK_IMPORTED_MODULE_1__["SurveyQuestionMultipleText"]; });

/* harmony reexport (safe) */ __webpack_require__.d(__webpack_exports__, "SurveyQuestionRadiogroup", function() { return _react_ui__WEBPACK_IMPORTED_MODULE_1__["SurveyQuestionRadiogroup"]; });

/* harmony reexport (safe) */ __webpack_require__.d(__webpack_exports__, "SurveyQuestionText", function() { return _react_ui__WEBPACK_IMPORTED_MODULE_1__["SurveyQuestionText"]; });

/* harmony reexport (safe) */ __webpack_require__.d(__webpack_exports__, "SurveyQuestionBoolean", function() { return _react_ui__WEBPACK_IMPORTED_MODULE_1__["SurveyQuestionBoolean"]; });

/* harmony reexport (safe) */ __webpack_require__.d(__webpack_exports__, "SurveyQuestionBooleanCheckbox", function() { return _react_ui__WEBPACK_IMPORTED_MODULE_1__["SurveyQuestionBooleanCheckbox"]; });

/* harmony reexport (safe) */ __webpack_require__.d(__webpack_exports__, "SurveyQuestionEmpty", function() { return _react_ui__WEBPACK_IMPORTED_MODULE_1__["SurveyQuestionEmpty"]; });

/* harmony reexport (safe) */ __webpack_require__.d(__webpack_exports__, "SurveyQuestionMatrixDropdownCell", function() { return _react_ui__WEBPACK_IMPORTED_MODULE_1__["SurveyQuestionMatrixDropdownCell"]; });

/* harmony reexport (safe) */ __webpack_require__.d(__webpack_exports__, "SurveyQuestionMatrixDropdown", function() { return _react_ui__WEBPACK_IMPORTED_MODULE_1__["SurveyQuestionMatrixDropdown"]; });

/* harmony reexport (safe) */ __webpack_require__.d(__webpack_exports__, "SurveyQuestionMatrixDynamic", function() { return _react_ui__WEBPACK_IMPORTED_MODULE_1__["SurveyQuestionMatrixDynamic"]; });

/* harmony reexport (safe) */ __webpack_require__.d(__webpack_exports__, "SurveyQuestionPanelDynamic", function() { return _react_ui__WEBPACK_IMPORTED_MODULE_1__["SurveyQuestionPanelDynamic"]; });

/* harmony reexport (safe) */ __webpack_require__.d(__webpack_exports__, "SurveyProgress", function() { return _react_ui__WEBPACK_IMPORTED_MODULE_1__["SurveyProgress"]; });

/* harmony reexport (safe) */ __webpack_require__.d(__webpack_exports__, "SurveyProgressButtons", function() { return _react_ui__WEBPACK_IMPORTED_MODULE_1__["SurveyProgressButtons"]; });

/* harmony reexport (safe) */ __webpack_require__.d(__webpack_exports__, "SurveyQuestionRating", function() { return _react_ui__WEBPACK_IMPORTED_MODULE_1__["SurveyQuestionRating"]; });

/* harmony reexport (safe) */ __webpack_require__.d(__webpack_exports__, "SurveyQuestionExpression", function() { return _react_ui__WEBPACK_IMPORTED_MODULE_1__["SurveyQuestionExpression"]; });

/* harmony reexport (safe) */ __webpack_require__.d(__webpack_exports__, "SurveyWindow", function() { return _react_ui__WEBPACK_IMPORTED_MODULE_1__["SurveyWindow"]; });

/* harmony reexport (safe) */ __webpack_require__.d(__webpack_exports__, "ReactQuestionFactory", function() { return _react_ui__WEBPACK_IMPORTED_MODULE_1__["ReactQuestionFactory"]; });

/* harmony reexport (safe) */ __webpack_require__.d(__webpack_exports__, "ReactElementFactory", function() { return _react_ui__WEBPACK_IMPORTED_MODULE_1__["ReactElementFactory"]; });

/* harmony reexport (safe) */ __webpack_require__.d(__webpack_exports__, "SurveyQuestionImagePicker", function() { return _react_ui__WEBPACK_IMPORTED_MODULE_1__["SurveyQuestionImagePicker"]; });

/* harmony reexport (safe) */ __webpack_require__.d(__webpack_exports__, "SurveyQuestionImage", function() { return _react_ui__WEBPACK_IMPORTED_MODULE_1__["SurveyQuestionImage"]; });

/* harmony reexport (safe) */ __webpack_require__.d(__webpack_exports__, "SurveyQuestionSignaturePad", function() { return _react_ui__WEBPACK_IMPORTED_MODULE_1__["SurveyQuestionSignaturePad"]; });

/* harmony reexport (safe) */ __webpack_require__.d(__webpack_exports__, "SurveyQuestionButtonGroup", function() { return _react_ui__WEBPACK_IMPORTED_MODULE_1__["SurveyQuestionButtonGroup"]; });

/* harmony reexport (safe) */ __webpack_require__.d(__webpack_exports__, "SurveyQuestionCustom", function() { return _react_ui__WEBPACK_IMPORTED_MODULE_1__["SurveyQuestionCustom"]; });

/* harmony reexport (safe) */ __webpack_require__.d(__webpack_exports__, "SurveyQuestionComposite", function() { return _react_ui__WEBPACK_IMPORTED_MODULE_1__["SurveyQuestionComposite"]; });

/* harmony reexport (safe) */ __webpack_require__.d(__webpack_exports__, "DefaultTitle", function() { return _react_ui__WEBPACK_IMPORTED_MODULE_1__["DefaultTitle"]; });

/* harmony reexport (safe) */ __webpack_require__.d(__webpack_exports__, "Popup", function() { return _react_ui__WEBPACK_IMPORTED_MODULE_1__["Popup"]; });

/* harmony reexport (safe) */ __webpack_require__.d(__webpack_exports__, "List", function() { return _react_ui__WEBPACK_IMPORTED_MODULE_1__["List"]; });

/* harmony reexport (safe) */ __webpack_require__.d(__webpack_exports__, "TitleActions", function() { return _react_ui__WEBPACK_IMPORTED_MODULE_1__["TitleActions"]; });

/* harmony reexport (safe) */ __webpack_require__.d(__webpack_exports__, "TitleElement", function() { return _react_ui__WEBPACK_IMPORTED_MODULE_1__["TitleElement"]; });

/* harmony reexport (safe) */ __webpack_require__.d(__webpack_exports__, "SurveyActionBar", function() { return _react_ui__WEBPACK_IMPORTED_MODULE_1__["SurveyActionBar"]; });

/* harmony reexport (safe) */ __webpack_require__.d(__webpack_exports__, "LogoImage", function() { return _react_ui__WEBPACK_IMPORTED_MODULE_1__["LogoImage"]; });

/* harmony reexport (safe) */ __webpack_require__.d(__webpack_exports__, "SurveyHeader", function() { return _react_ui__WEBPACK_IMPORTED_MODULE_1__["SurveyHeader"]; });

/* harmony reexport (safe) */ __webpack_require__.d(__webpack_exports__, "SvgIcon", function() { return _react_ui__WEBPACK_IMPORTED_MODULE_1__["SvgIcon"]; });

/* harmony reexport (safe) */ __webpack_require__.d(__webpack_exports__, "SurveyQuestionMatrixDynamicRemoveButton", function() { return _react_ui__WEBPACK_IMPORTED_MODULE_1__["SurveyQuestionMatrixDynamicRemoveButton"]; });

/* harmony reexport (safe) */ __webpack_require__.d(__webpack_exports__, "SurveyQuestionMatrixDetailButton", function() { return _react_ui__WEBPACK_IMPORTED_MODULE_1__["SurveyQuestionMatrixDetailButton"]; });

/* harmony reexport (safe) */ __webpack_require__.d(__webpack_exports__, "SurveyQuestionMatrixDynamicDragDropIcon", function() { return _react_ui__WEBPACK_IMPORTED_MODULE_1__["SurveyQuestionMatrixDynamicDragDropIcon"]; });

/* harmony reexport (safe) */ __webpack_require__.d(__webpack_exports__, "MatrixRow", function() { return _react_ui__WEBPACK_IMPORTED_MODULE_1__["MatrixRow"]; });

/* harmony reexport (safe) */ __webpack_require__.d(__webpack_exports__, "Skeleton", function() { return _react_ui__WEBPACK_IMPORTED_MODULE_1__["Skeleton"]; });

/* harmony reexport (safe) */ __webpack_require__.d(__webpack_exports__, "SurveyLocStringViewer", function() { return _react_ui__WEBPACK_IMPORTED_MODULE_1__["SurveyLocStringViewer"]; });

/* harmony reexport (safe) */ __webpack_require__.d(__webpack_exports__, "SurveyLocStringEditor", function() { return _react_ui__WEBPACK_IMPORTED_MODULE_1__["SurveyLocStringEditor"]; });





/***/ }),

/***/ "./src/error.ts":
/*!**********************!*\
  !*** ./src/error.ts ***!
  \**********************/
/*! exports provided: AnswerRequiredError, OneAnswerRequiredError, RequreNumericError, ExceedSizeError, WebRequestError, WebRequestEmptyError, OtherEmptyError, UploadingFileError, RequiredInAllRowsError, MinRowCountError, KeyDuplicationError, CustomError */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "AnswerRequiredError", function() { return AnswerRequiredError; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "OneAnswerRequiredError", function() { return OneAnswerRequiredError; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "RequreNumericError", function() { return RequreNumericError; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "ExceedSizeError", function() { return ExceedSizeError; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "WebRequestError", function() { return WebRequestError; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "WebRequestEmptyError", function() { return WebRequestEmptyError; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "OtherEmptyError", function() { return OtherEmptyError; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "UploadingFileError", function() { return UploadingFileError; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "RequiredInAllRowsError", function() { return RequiredInAllRowsError; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "MinRowCountError", function() { return MinRowCountError; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "KeyDuplicationError", function() { return KeyDuplicationError; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "CustomError", function() { return CustomError; });
/* harmony import */ var _surveyStrings__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./surveyStrings */ "./src/surveyStrings.ts");
/* harmony import */ var _survey_error__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ./survey-error */ "./src/survey-error.ts");
var __extends = (undefined && undefined.__extends) || (function () {
    var extendStatics = function (d, b) {
        extendStatics = Object.setPrototypeOf ||
            ({ __proto__: [] } instanceof Array && function (d, b) { d.__proto__ = b; }) ||
            function (d, b) { for (var p in b) if (Object.prototype.hasOwnProperty.call(b, p)) d[p] = b[p]; };
        return extendStatics(d, b);
    };
    return function (d, b) {
        if (typeof b !== "function" && b !== null)
            throw new TypeError("Class extends value " + String(b) + " is not a constructor or null");
        extendStatics(d, b);
        function __() { this.constructor = d; }
        d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
    };
})();


var AnswerRequiredError = /** @class */ (function (_super) {
    __extends(AnswerRequiredError, _super);
    function AnswerRequiredError(text, errorOwner) {
        if (text === void 0) { text = null; }
        if (errorOwner === void 0) { errorOwner = null; }
        var _this = _super.call(this, text, errorOwner) || this;
        _this.text = text;
        return _this;
    }
    AnswerRequiredError.prototype.getErrorType = function () {
        return "required";
    };
    AnswerRequiredError.prototype.getDefaultText = function () {
        return _surveyStrings__WEBPACK_IMPORTED_MODULE_0__["surveyLocalization"].getString("requiredError");
    };
    return AnswerRequiredError;
}(_survey_error__WEBPACK_IMPORTED_MODULE_1__["SurveyError"]));

var OneAnswerRequiredError = /** @class */ (function (_super) {
    __extends(OneAnswerRequiredError, _super);
    function OneAnswerRequiredError(text, errorOwner) {
        if (text === void 0) { text = null; }
        if (errorOwner === void 0) { errorOwner = null; }
        var _this = _super.call(this, text, errorOwner) || this;
        _this.text = text;
        return _this;
    }
    OneAnswerRequiredError.prototype.getErrorType = function () {
        return "requireoneanswer";
    };
    OneAnswerRequiredError.prototype.getDefaultText = function () {
        return _surveyStrings__WEBPACK_IMPORTED_MODULE_0__["surveyLocalization"].getString("requiredErrorInPanel");
    };
    return OneAnswerRequiredError;
}(_survey_error__WEBPACK_IMPORTED_MODULE_1__["SurveyError"]));

var RequreNumericError = /** @class */ (function (_super) {
    __extends(RequreNumericError, _super);
    function RequreNumericError(text, errorOwner) {
        if (text === void 0) { text = null; }
        if (errorOwner === void 0) { errorOwner = null; }
        var _this = _super.call(this, text, errorOwner) || this;
        _this.text = text;
        return _this;
    }
    RequreNumericError.prototype.getErrorType = function () {
        return "requirenumeric";
    };
    RequreNumericError.prototype.getDefaultText = function () {
        return _surveyStrings__WEBPACK_IMPORTED_MODULE_0__["surveyLocalization"].getString("numericError");
    };
    return RequreNumericError;
}(_survey_error__WEBPACK_IMPORTED_MODULE_1__["SurveyError"]));

var ExceedSizeError = /** @class */ (function (_super) {
    __extends(ExceedSizeError, _super);
    function ExceedSizeError(maxSize, errorOwner) {
        if (errorOwner === void 0) { errorOwner = null; }
        var _this = _super.call(this, null, errorOwner) || this;
        _this.maxSize = maxSize;
        _this.locText.text = _this.getText();
        return _this;
    }
    ExceedSizeError.prototype.getErrorType = function () {
        return "exceedsize";
    };
    ExceedSizeError.prototype.getDefaultText = function () {
        return _surveyStrings__WEBPACK_IMPORTED_MODULE_0__["surveyLocalization"]
            .getString("exceedMaxSize")["format"](this.getTextSize());
    };
    ExceedSizeError.prototype.getTextSize = function () {
        var sizes = ["Bytes", "KB", "MB", "GB", "TB"];
        var fixed = [0, 0, 2, 3, 3];
        if (this.maxSize === 0) {
            return "0 Byte";
        }
        var i = Math.floor(Math.log(this.maxSize) / Math.log(1024));
        var value = this.maxSize / Math.pow(1024, i);
        return value.toFixed(fixed[i]) + " " + sizes[i];
    };
    return ExceedSizeError;
}(_survey_error__WEBPACK_IMPORTED_MODULE_1__["SurveyError"]));

var WebRequestError = /** @class */ (function (_super) {
    __extends(WebRequestError, _super);
    function WebRequestError(status, response, errorOwner) {
        if (errorOwner === void 0) { errorOwner = null; }
        var _this = _super.call(this, null, errorOwner) || this;
        _this.status = status;
        _this.response = response;
        return _this;
    }
    WebRequestError.prototype.getErrorType = function () {
        return "webrequest";
    };
    WebRequestError.prototype.getDefaultText = function () {
        return _surveyStrings__WEBPACK_IMPORTED_MODULE_0__["surveyLocalization"]
            .getString("urlRequestError")["format"](this.status, this.response);
    };
    return WebRequestError;
}(_survey_error__WEBPACK_IMPORTED_MODULE_1__["SurveyError"]));

var WebRequestEmptyError = /** @class */ (function (_super) {
    __extends(WebRequestEmptyError, _super);
    function WebRequestEmptyError(text, errorOwner) {
        if (errorOwner === void 0) { errorOwner = null; }
        var _this = _super.call(this, text, errorOwner) || this;
        _this.text = text;
        return _this;
    }
    WebRequestEmptyError.prototype.getErrorType = function () {
        return "webrequestempty";
    };
    WebRequestEmptyError.prototype.getDefaultText = function () {
        return _surveyStrings__WEBPACK_IMPORTED_MODULE_0__["surveyLocalization"].getString("urlGetChoicesError");
    };
    return WebRequestEmptyError;
}(_survey_error__WEBPACK_IMPORTED_MODULE_1__["SurveyError"]));

var OtherEmptyError = /** @class */ (function (_super) {
    __extends(OtherEmptyError, _super);
    function OtherEmptyError(text, errorOwner) {
        if (errorOwner === void 0) { errorOwner = null; }
        var _this = _super.call(this, text, errorOwner) || this;
        _this.text = text;
        return _this;
    }
    OtherEmptyError.prototype.getErrorType = function () {
        return "otherempty";
    };
    OtherEmptyError.prototype.getDefaultText = function () {
        return _surveyStrings__WEBPACK_IMPORTED_MODULE_0__["surveyLocalization"].getString("otherRequiredError");
    };
    return OtherEmptyError;
}(_survey_error__WEBPACK_IMPORTED_MODULE_1__["SurveyError"]));

var UploadingFileError = /** @class */ (function (_super) {
    __extends(UploadingFileError, _super);
    function UploadingFileError(text, errorOwner) {
        if (errorOwner === void 0) { errorOwner = null; }
        var _this = _super.call(this, text, errorOwner) || this;
        _this.text = text;
        return _this;
    }
    UploadingFileError.prototype.getErrorType = function () {
        return "uploadingfile";
    };
    UploadingFileError.prototype.getDefaultText = function () {
        return _surveyStrings__WEBPACK_IMPORTED_MODULE_0__["surveyLocalization"].getString("uploadingFile");
    };
    return UploadingFileError;
}(_survey_error__WEBPACK_IMPORTED_MODULE_1__["SurveyError"]));

var RequiredInAllRowsError = /** @class */ (function (_super) {
    __extends(RequiredInAllRowsError, _super);
    function RequiredInAllRowsError(text, errorOwner) {
        if (errorOwner === void 0) { errorOwner = null; }
        var _this = _super.call(this, text, errorOwner) || this;
        _this.text = text;
        return _this;
    }
    RequiredInAllRowsError.prototype.getErrorType = function () {
        return "requiredinallrowserror";
    };
    RequiredInAllRowsError.prototype.getDefaultText = function () {
        return _surveyStrings__WEBPACK_IMPORTED_MODULE_0__["surveyLocalization"].getString("requiredInAllRowsError");
    };
    return RequiredInAllRowsError;
}(_survey_error__WEBPACK_IMPORTED_MODULE_1__["SurveyError"]));

var MinRowCountError = /** @class */ (function (_super) {
    __extends(MinRowCountError, _super);
    function MinRowCountError(minRowCount, errorOwner) {
        if (errorOwner === void 0) { errorOwner = null; }
        var _this = _super.call(this, null, errorOwner) || this;
        _this.minRowCount = minRowCount;
        return _this;
    }
    MinRowCountError.prototype.getErrorType = function () {
        return "minrowcounterror";
    };
    MinRowCountError.prototype.getDefaultText = function () {
        return _surveyStrings__WEBPACK_IMPORTED_MODULE_0__["surveyLocalization"]
            .getString("minRowCountError")["format"](this.minRowCount);
    };
    return MinRowCountError;
}(_survey_error__WEBPACK_IMPORTED_MODULE_1__["SurveyError"]));

var KeyDuplicationError = /** @class */ (function (_super) {
    __extends(KeyDuplicationError, _super);
    function KeyDuplicationError(text, errorOwner) {
        if (errorOwner === void 0) { errorOwner = null; }
        var _this = _super.call(this, text, errorOwner) || this;
        _this.text = text;
        return _this;
    }
    KeyDuplicationError.prototype.getErrorType = function () {
        return "keyduplicationerror";
    };
    KeyDuplicationError.prototype.getDefaultText = function () {
        return _surveyStrings__WEBPACK_IMPORTED_MODULE_0__["surveyLocalization"].getString("keyDuplicationError");
    };
    return KeyDuplicationError;
}(_survey_error__WEBPACK_IMPORTED_MODULE_1__["SurveyError"]));

var CustomError = /** @class */ (function (_super) {
    __extends(CustomError, _super);
    function CustomError(text, errorOwner) {
        if (errorOwner === void 0) { errorOwner = null; }
        var _this = _super.call(this, text, errorOwner) || this;
        _this.text = text;
        return _this;
    }
    CustomError.prototype.getErrorType = function () {
        return "custom";
    };
    return CustomError;
}(_survey_error__WEBPACK_IMPORTED_MODULE_1__["SurveyError"]));



/***/ }),

/***/ "./src/expressionItems.ts":
/*!********************************!*\
  !*** ./src/expressionItems.ts ***!
  \********************************/
/*! exports provided: ExpressionItem, HtmlConditionItem, UrlConditionItem */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "ExpressionItem", function() { return ExpressionItem; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "HtmlConditionItem", function() { return HtmlConditionItem; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "UrlConditionItem", function() { return UrlConditionItem; });
/* harmony import */ var _jsonobject__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./jsonobject */ "./src/jsonobject.ts");
/* harmony import */ var _base__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ./base */ "./src/base.ts");
/* harmony import */ var _conditions__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ./conditions */ "./src/conditions.ts");
var __extends = (undefined && undefined.__extends) || (function () {
    var extendStatics = function (d, b) {
        extendStatics = Object.setPrototypeOf ||
            ({ __proto__: [] } instanceof Array && function (d, b) { d.__proto__ = b; }) ||
            function (d, b) { for (var p in b) if (Object.prototype.hasOwnProperty.call(b, p)) d[p] = b[p]; };
        return extendStatics(d, b);
    };
    return function (d, b) {
        if (typeof b !== "function" && b !== null)
            throw new TypeError("Class extends value " + String(b) + " is not a constructor or null");
        extendStatics(d, b);
        function __() { this.constructor = d; }
        d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
    };
})();



var ExpressionItem = /** @class */ (function (_super) {
    __extends(ExpressionItem, _super);
    function ExpressionItem(expression) {
        if (expression === void 0) { expression = null; }
        var _this = _super.call(this) || this;
        _this.createLocalizableString("html", _this);
        _this.expression = expression;
        return _this;
    }
    ExpressionItem.prototype.getType = function () {
        return "expressionitem";
    };
    ExpressionItem.prototype.runCondition = function (values, properties) {
        if (!this.expression)
            return false;
        return new _conditions__WEBPACK_IMPORTED_MODULE_2__["ConditionRunner"](this.expression).run(values, properties);
    };
    Object.defineProperty(ExpressionItem.prototype, "expression", {
        /**
         * The expression property. If this expression returns true, then survey will use html property to show on complete page.
         */
        get: function () {
            return this.getPropertyValue("expression", "");
        },
        set: function (val) {
            this.setPropertyValue("expression", val);
        },
        enumerable: false,
        configurable: true
    });
    Object.defineProperty(ExpressionItem.prototype, "locHtml", {
        get: function () {
            return this.getLocalizableString("html");
        },
        enumerable: false,
        configurable: true
    });
    ExpressionItem.prototype.getLocale = function () {
        return !!this.locOwner ? this.locOwner.getLocale() : "";
    };
    ExpressionItem.prototype.getMarkdownHtml = function (text, name) {
        return !!this.locOwner ? this.locOwner.getMarkdownHtml(text, name) : null;
    };
    ExpressionItem.prototype.getRenderer = function (name) {
        return !!this.locOwner ? this.locOwner.getRenderer(name) : null;
    };
    ExpressionItem.prototype.getRendererContext = function (locStr) {
        return !!this.locOwner ? this.locOwner.getRendererContext(locStr) : locStr;
    };
    ExpressionItem.prototype.getProcessedText = function (text) {
        return this.locOwner ? this.locOwner.getProcessedText(text) : text;
    };
    return ExpressionItem;
}(_base__WEBPACK_IMPORTED_MODULE_1__["Base"]));

/**
 * A class that contains expression and html propeties. It uses in survey.completedHtmlOnCondition array.
 * If the expression returns true then html of this item uses instead of survey.completedHtml property
 * @see SurveyModel.completedHtmlOnCondition
 * @see SurveyModel.completedHtml
 */
var HtmlConditionItem = /** @class */ (function (_super) {
    __extends(HtmlConditionItem, _super);
    function HtmlConditionItem(expression, html) {
        if (expression === void 0) { expression = null; }
        if (html === void 0) { html = null; }
        var _this = _super.call(this, expression) || this;
        _this.createLocalizableString("html", _this);
        _this.html = html;
        return _this;
    }
    HtmlConditionItem.prototype.getType = function () {
        return "htmlconditionitem";
    };
    Object.defineProperty(HtmlConditionItem.prototype, "html", {
        /**
         * The html that shows on completed ('Thank you') page. The expression should return true
         * @see expression
         */
        get: function () {
            return this.getLocalizableStringText("html");
        },
        set: function (value) {
            this.setLocalizableStringText("html", value);
        },
        enumerable: false,
        configurable: true
    });
    Object.defineProperty(HtmlConditionItem.prototype, "locHtml", {
        get: function () {
            return this.getLocalizableString("html");
        },
        enumerable: false,
        configurable: true
    });
    return HtmlConditionItem;
}(ExpressionItem));

/**
 * A class that contains expression and url propeties. It uses in survey.navigateToUrlOnCondition array.
 * If the expression returns true then url of this item uses instead of survey.navigateToUrl property
 * @see SurveyModel.navigateToUrl
 */
var UrlConditionItem = /** @class */ (function (_super) {
    __extends(UrlConditionItem, _super);
    function UrlConditionItem(expression, url) {
        if (expression === void 0) { expression = null; }
        if (url === void 0) { url = null; }
        var _this = _super.call(this, expression) || this;
        _this.createLocalizableString("url", _this);
        _this.url = url;
        return _this;
    }
    UrlConditionItem.prototype.getType = function () {
        return "urlconditionitem";
    };
    Object.defineProperty(UrlConditionItem.prototype, "url", {
        /**
         * The url that survey navigates to on completing the survey. The expression should return true
         * @see expression
         */
        get: function () {
            return this.getLocalizableStringText("url");
        },
        set: function (value) {
            this.setLocalizableStringText("url", value);
        },
        enumerable: false,
        configurable: true
    });
    Object.defineProperty(UrlConditionItem.prototype, "locUrl", {
        get: function () {
            return this.getLocalizableString("url");
        },
        enumerable: false,
        configurable: true
    });
    return UrlConditionItem;
}(ExpressionItem));

_jsonobject__WEBPACK_IMPORTED_MODULE_0__["Serializer"].addClass("expressionitem", ["expression:condition"], function () {
    return new ExpressionItem();
}, "base");
_jsonobject__WEBPACK_IMPORTED_MODULE_0__["Serializer"].addClass("htmlconditionitem", [{ name: "html:html", serializationProperty: "locHtml" }], function () {
    return new HtmlConditionItem();
}, "expressionitem");
_jsonobject__WEBPACK_IMPORTED_MODULE_0__["Serializer"].addClass("urlconditionitem", [{ name: "url:string", serializationProperty: "locUrl" }], function () {
    return new UrlConditionItem();
}, "expressionitem");


/***/ }),

/***/ "./src/expressions/expressionParser.ts":
/*!*********************************************!*\
  !*** ./src/expressions/expressionParser.ts ***!
  \*********************************************/
/*! exports provided: SyntaxError, parse */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "SyntaxError", function() { return SyntaxError; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "parse", function() { return parse; });
/* harmony import */ var _expressions__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./expressions */ "./src/expressions/expressions.ts");
var __extends = (undefined && undefined.__extends) || (function () {
    var extendStatics = function (d, b) {
        extendStatics = Object.setPrototypeOf ||
            ({ __proto__: [] } instanceof Array && function (d, b) { d.__proto__ = b; }) ||
            function (d, b) { for (var p in b) if (Object.prototype.hasOwnProperty.call(b, p)) d[p] = b[p]; };
        return extendStatics(d, b);
    };
    return function (d, b) {
        if (typeof b !== "function" && b !== null)
            throw new TypeError("Class extends value " + String(b) + " is not a constructor or null");
        extendStatics(d, b);
        function __() { this.constructor = d; }
        d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
    };
})();

// Generated by PEG.js v. 0.10.0 (ts-pegjs plugin v. 0.3.1 )
//
// https://pegjs.org/   https://github.com/metadevpro/ts-pegjs
"use strict";
var SyntaxError = /** @class */ (function (_super) {
    __extends(SyntaxError, _super);
    function SyntaxError(message, expected, found, location) {
        var _this = _super.call(this) || this;
        _this.message = message;
        _this.expected = expected;
        _this.found = found;
        _this.location = location;
        _this.name = "SyntaxError";
        if (typeof Error.captureStackTrace === "function") {
            Error.captureStackTrace(_this, SyntaxError);
        }
        return _this;
    }
    SyntaxError.buildMessage = function (expected, found) {
        function hex(ch) {
            return ch.charCodeAt(0).toString(16).toUpperCase();
        }
        function literalEscape(s) {
            return s
                .replace(/\\/g, "\\\\")
                .replace(/"/g, "\\\"")
                .replace(/\0/g, "\\0")
                .replace(/\t/g, "\\t")
                .replace(/\n/g, "\\n")
                .replace(/\r/g, "\\r")
                // eslint-disable-next-line no-control-regex
                .replace(/[\x00-\x0F]/g, function (ch) { return "\\x0" + hex(ch); })
                // eslint-disable-next-line no-control-regex
                .replace(/[\x10-\x1F\x7F-\x9F]/g, function (ch) { return "\\x" + hex(ch); });
        }
        function classEscape(s) {
            return s
                .replace(/\\/g, "\\\\")
                .replace(/\]/g, "\\]")
                .replace(/\^/g, "\\^")
                .replace(/-/g, "\\-")
                .replace(/\0/g, "\\0")
                .replace(/\t/g, "\\t")
                .replace(/\n/g, "\\n")
                .replace(/\r/g, "\\r")
                // eslint-disable-next-line no-control-regex
                .replace(/[\x00-\x0F]/g, function (ch) { return "\\x0" + hex(ch); })
                // eslint-disable-next-line no-control-regex
                .replace(/[\x10-\x1F\x7F-\x9F]/g, function (ch) { return "\\x" + hex(ch); });
        }
        function describeExpectation(expectation) {
            switch (expectation.type) {
                case "literal":
                    return "\"" + literalEscape(expectation.text) + "\"";
                case "class":
                    var escapedParts = expectation.parts.map(function (part) {
                        return Array.isArray(part)
                            ? classEscape(part[0]) + "-" + classEscape(part[1])
                            : classEscape(part);
                    });
                    return "[" + (expectation.inverted ? "^" : "") + escapedParts + "]";
                case "any":
                    return "any character";
                case "end":
                    return "end of input";
                case "other":
                    return expectation.description;
            }
        }
        function describeExpected(expected1) {
            var descriptions = expected1.map(describeExpectation);
            var i;
            var j;
            descriptions.sort();
            if (descriptions.length > 0) {
                for (i = 1, j = 1; i < descriptions.length; i++) {
                    if (descriptions[i - 1] !== descriptions[i]) {
                        descriptions[j] = descriptions[i];
                        j++;
                    }
                }
                descriptions.length = j;
            }
            switch (descriptions.length) {
                case 1:
                    return descriptions[0];
                case 2:
                    return descriptions[0] + " or " + descriptions[1];
                default:
                    return descriptions.slice(0, -1).join(", ")
                        + ", or "
                        + descriptions[descriptions.length - 1];
            }
        }
        function describeFound(found1) {
            return found1 ? "\"" + literalEscape(found1) + "\"" : "end of input";
        }
        return "Expected " + describeExpected(expected) + " but " + describeFound(found) + " found.";
    };
    return SyntaxError;
}(Error));

function peg$parse(input, options) {
    options = options !== undefined ? options : {};
    var peg$FAILED = {};
    var peg$startRuleFunctions = { Expression: peg$parseExpression };
    var peg$startRuleFunction = peg$parseExpression;
    var peg$c0 = function (head, tail) {
        return buildBinaryOperand(head, tail, true);
    };
    var peg$c1 = "||";
    var peg$c2 = peg$literalExpectation("||", false);
    var peg$c3 = "or";
    var peg$c4 = peg$literalExpectation("or", true);
    var peg$c5 = function () { return "or"; };
    var peg$c6 = "&&";
    var peg$c7 = peg$literalExpectation("&&", false);
    var peg$c8 = "and";
    var peg$c9 = peg$literalExpectation("and", true);
    var peg$c10 = function () { return "and"; };
    var peg$c11 = function (head, tail) {
        return buildBinaryOperand(head, tail);
    };
    var peg$c12 = "<=";
    var peg$c13 = peg$literalExpectation("<=", false);
    var peg$c14 = "lessorequal";
    var peg$c15 = peg$literalExpectation("lessorequal", true);
    var peg$c16 = function () { return "lessorequal"; };
    var peg$c17 = ">=";
    var peg$c18 = peg$literalExpectation(">=", false);
    var peg$c19 = "greaterorequal";
    var peg$c20 = peg$literalExpectation("greaterorequal", true);
    var peg$c21 = function () { return "greaterorequal"; };
    var peg$c22 = "=";
    var peg$c23 = peg$literalExpectation("=", false);
    var peg$c24 = "equal";
    var peg$c25 = peg$literalExpectation("equal", true);
    var peg$c26 = function () { return "equal"; };
    var peg$c27 = "!=";
    var peg$c28 = peg$literalExpectation("!=", false);
    var peg$c29 = "notequal";
    var peg$c30 = peg$literalExpectation("notequal", true);
    var peg$c31 = function () { return "notequal"; };
    var peg$c32 = "<";
    var peg$c33 = peg$literalExpectation("<", false);
    var peg$c34 = "less";
    var peg$c35 = peg$literalExpectation("less", true);
    var peg$c36 = function () { return "less"; };
    var peg$c37 = ">";
    var peg$c38 = peg$literalExpectation(">", false);
    var peg$c39 = "greater";
    var peg$c40 = peg$literalExpectation("greater", true);
    var peg$c41 = function () { return "greater"; };
    var peg$c42 = "+";
    var peg$c43 = peg$literalExpectation("+", false);
    var peg$c44 = function () { return "plus"; };
    var peg$c45 = "-";
    var peg$c46 = peg$literalExpectation("-", false);
    var peg$c47 = function () { return "minus"; };
    var peg$c48 = "*";
    var peg$c49 = peg$literalExpectation("*", false);
    var peg$c50 = function () { return "mul"; };
    var peg$c51 = "/";
    var peg$c52 = peg$literalExpectation("/", false);
    var peg$c53 = function () { return "div"; };
    var peg$c54 = "%";
    var peg$c55 = peg$literalExpectation("%", false);
    var peg$c56 = function () { return "mod"; };
    var peg$c57 = "^";
    var peg$c58 = peg$literalExpectation("^", false);
    var peg$c59 = "power";
    var peg$c60 = peg$literalExpectation("power", true);
    var peg$c61 = function () { return "power"; };
    var peg$c62 = "*=";
    var peg$c63 = peg$literalExpectation("*=", false);
    var peg$c64 = "contains";
    var peg$c65 = peg$literalExpectation("contains", true);
    var peg$c66 = "contain";
    var peg$c67 = peg$literalExpectation("contain", true);
    var peg$c68 = function () { return "contains"; };
    var peg$c69 = "notcontains";
    var peg$c70 = peg$literalExpectation("notcontains", true);
    var peg$c71 = "notcontain";
    var peg$c72 = peg$literalExpectation("notcontain", true);
    var peg$c73 = function () { return "notcontains"; };
    var peg$c74 = "anyof";
    var peg$c75 = peg$literalExpectation("anyof", true);
    var peg$c76 = function () { return "anyof"; };
    var peg$c77 = "allof";
    var peg$c78 = peg$literalExpectation("allof", true);
    var peg$c79 = function () { return "allof"; };
    var peg$c80 = "(";
    var peg$c81 = peg$literalExpectation("(", false);
    var peg$c82 = ")";
    var peg$c83 = peg$literalExpectation(")", false);
    var peg$c84 = function (expr) { return expr; };
    var peg$c85 = function (name, params) { return new _expressions__WEBPACK_IMPORTED_MODULE_0__["FunctionOperand"](name, params); };
    var peg$c86 = "!";
    var peg$c87 = peg$literalExpectation("!", false);
    var peg$c88 = "negate";
    var peg$c89 = peg$literalExpectation("negate", true);
    var peg$c90 = function (expr) { return new _expressions__WEBPACK_IMPORTED_MODULE_0__["UnaryOperand"](expr, "negate"); };
    var peg$c91 = function (expr, op) { return new _expressions__WEBPACK_IMPORTED_MODULE_0__["UnaryOperand"](expr, op); };
    var peg$c92 = "empty";
    var peg$c93 = peg$literalExpectation("empty", true);
    var peg$c94 = function () { return "empty"; };
    var peg$c95 = "notempty";
    var peg$c96 = peg$literalExpectation("notempty", true);
    var peg$c97 = function () { return "notempty"; };
    var peg$c98 = "undefined";
    var peg$c99 = peg$literalExpectation("undefined", false);
    var peg$c100 = "null";
    var peg$c101 = peg$literalExpectation("null", false);
    var peg$c102 = function () { return null; };
    var peg$c103 = function (value) { return new _expressions__WEBPACK_IMPORTED_MODULE_0__["Const"](value); };
    var peg$c104 = "{";
    var peg$c105 = peg$literalExpectation("{", false);
    var peg$c106 = "}";
    var peg$c107 = peg$literalExpectation("}", false);
    var peg$c108 = function (value) { return new _expressions__WEBPACK_IMPORTED_MODULE_0__["Variable"](value); };
    var peg$c109 = function (value) { return value; };
    var peg$c110 = "''";
    var peg$c111 = peg$literalExpectation("''", false);
    var peg$c112 = function () { return ""; };
    var peg$c113 = "\"\"";
    var peg$c114 = peg$literalExpectation("\"\"", false);
    var peg$c115 = "'";
    var peg$c116 = peg$literalExpectation("'", false);
    var peg$c117 = function (value) { return "'" + value + "'"; };
    var peg$c118 = "\"";
    var peg$c119 = peg$literalExpectation("\"", false);
    var peg$c120 = "[";
    var peg$c121 = peg$literalExpectation("[", false);
    var peg$c122 = "]";
    var peg$c123 = peg$literalExpectation("]", false);
    var peg$c124 = function (sequence) { return sequence; };
    var peg$c125 = ",";
    var peg$c126 = peg$literalExpectation(",", false);
    var peg$c127 = function (expr, tail) {
        if (expr == null)
            return new _expressions__WEBPACK_IMPORTED_MODULE_0__["ArrayOperand"]([]);
        var array = [expr];
        if (Array.isArray(tail)) {
            var flatten = flattenArray(tail);
            for (var i = 3; i < flatten.length; i += 4) {
                array.push(flatten[i]);
            }
        }
        return new _expressions__WEBPACK_IMPORTED_MODULE_0__["ArrayOperand"](array);
    };
    var peg$c128 = "true";
    var peg$c129 = peg$literalExpectation("true", true);
    var peg$c130 = function () { return true; };
    var peg$c131 = "false";
    var peg$c132 = peg$literalExpectation("false", true);
    var peg$c133 = function () { return false; };
    var peg$c134 = "0x";
    var peg$c135 = peg$literalExpectation("0x", false);
    var peg$c136 = function () { return parseInt(text(), 16); };
    var peg$c137 = /^[\-]/;
    var peg$c138 = peg$classExpectation(["-"], false, false);
    var peg$c139 = function (sign, num) { return sign == null ? num : -num; };
    var peg$c140 = ".";
    var peg$c141 = peg$literalExpectation(".", false);
    var peg$c142 = function () { return parseFloat(text()); };
    var peg$c143 = function () { return parseInt(text(), 10); };
    var peg$c144 = "0";
    var peg$c145 = peg$literalExpectation("0", false);
    var peg$c146 = function () { return 0; };
    var peg$c147 = function (chars) { return chars.join(""); };
    var peg$c148 = "\\'";
    var peg$c149 = peg$literalExpectation("\\'", false);
    var peg$c150 = function () { return "'"; };
    var peg$c151 = "\\\"";
    var peg$c152 = peg$literalExpectation("\\\"", false);
    var peg$c153 = function () { return "\""; };
    var peg$c154 = /^[^"']/;
    var peg$c155 = peg$classExpectation(["\"", "'"], true, false);
    var peg$c156 = function () { return text(); };
    var peg$c157 = /^[^{}]/;
    var peg$c158 = peg$classExpectation(["{", "}"], true, false);
    var peg$c159 = /^[0-9]/;
    var peg$c160 = peg$classExpectation([["0", "9"]], false, false);
    var peg$c161 = /^[1-9]/;
    var peg$c162 = peg$classExpectation([["1", "9"]], false, false);
    var peg$c163 = /^[a-zA-Z]/;
    var peg$c164 = peg$classExpectation([["a", "z"], ["A", "Z"]], false, false);
    var peg$c165 = peg$otherExpectation("whitespace");
    var peg$c166 = /^[ \t\n\r]/;
    var peg$c167 = peg$classExpectation([" ", "\t", "\n", "\r"], false, false);
    var peg$currPos = 0;
    var peg$savedPos = 0;
    var peg$posDetailsCache = [{ line: 1, column: 1 }];
    var peg$maxFailPos = 0;
    var peg$maxFailExpected = [];
    var peg$silentFails = 0;
    var peg$resultsCache = {};
    var peg$result;
    if (options.startRule !== undefined) {
        if (!(options.startRule in peg$startRuleFunctions)) {
            throw new Error("Can't start parsing from rule \"" + options.startRule + "\".");
        }
        peg$startRuleFunction = peg$startRuleFunctions[options.startRule];
    }
    function text() {
        return input.substring(peg$savedPos, peg$currPos);
    }
    function location() {
        return peg$computeLocation(peg$savedPos, peg$currPos);
    }
    function expected(description, location1) {
        location1 = location1 !== undefined
            ? location1
            : peg$computeLocation(peg$savedPos, peg$currPos);
        throw peg$buildStructuredError([peg$otherExpectation(description)], input.substring(peg$savedPos, peg$currPos), location1);
    }
    function error(message, location1) {
        location1 = location1 !== undefined
            ? location1
            : peg$computeLocation(peg$savedPos, peg$currPos);
        throw peg$buildSimpleError(message, location1);
    }
    function peg$literalExpectation(text1, ignoreCase) {
        return { type: "literal", text: text1, ignoreCase: ignoreCase };
    }
    function peg$classExpectation(parts, inverted, ignoreCase) {
        return { type: "class", parts: parts, inverted: inverted, ignoreCase: ignoreCase };
    }
    function peg$anyExpectation() {
        return { type: "any" };
    }
    function peg$endExpectation() {
        return { type: "end" };
    }
    function peg$otherExpectation(description) {
        return { type: "other", description: description };
    }
    function peg$computePosDetails(pos) {
        var details = peg$posDetailsCache[pos];
        var p;
        if (details) {
            return details;
        }
        else {
            p = pos - 1;
            while (!peg$posDetailsCache[p]) {
                p--;
            }
            details = peg$posDetailsCache[p];
            details = {
                line: details.line,
                column: details.column
            };
            while (p < pos) {
                if (input.charCodeAt(p) === 10) {
                    details.line++;
                    details.column = 1;
                }
                else {
                    details.column++;
                }
                p++;
            }
            peg$posDetailsCache[pos] = details;
            return details;
        }
    }
    function peg$computeLocation(startPos, endPos) {
        var startPosDetails = peg$computePosDetails(startPos);
        var endPosDetails = peg$computePosDetails(endPos);
        return {
            start: {
                offset: startPos,
                line: startPosDetails.line,
                column: startPosDetails.column
            },
            end: {
                offset: endPos,
                line: endPosDetails.line,
                column: endPosDetails.column
            }
        };
    }
    function peg$fail(expected1) {
        if (peg$currPos < peg$maxFailPos) {
            return;
        }
        if (peg$currPos > peg$maxFailPos) {
            peg$maxFailPos = peg$currPos;
            peg$maxFailExpected = [];
        }
        peg$maxFailExpected.push(expected1);
    }
    function peg$buildSimpleError(message, location1) {
        return new SyntaxError(message, [], "", location1);
    }
    function peg$buildStructuredError(expected1, found, location1) {
        return new SyntaxError(SyntaxError.buildMessage(expected1, found), expected1, found, location1);
    }
    function peg$parseExpression() {
        var s0, s1, s2, s3, s4, s5, s6, s7, s8;
        var key = peg$currPos * 34 + 0;
        var cached = peg$resultsCache[key];
        if (cached) {
            peg$currPos = cached.nextPos;
            return cached.result;
        }
        s0 = peg$currPos;
        s1 = peg$parse_();
        if (s1 !== peg$FAILED) {
            s2 = peg$parseLogicOr();
            if (s2 !== peg$FAILED) {
                s3 = [];
                s4 = peg$currPos;
                s5 = peg$parse_();
                if (s5 !== peg$FAILED) {
                    s6 = peg$parseOrSign();
                    if (s6 !== peg$FAILED) {
                        s7 = peg$parse_();
                        if (s7 !== peg$FAILED) {
                            s8 = peg$parseLogicOr();
                            if (s8 !== peg$FAILED) {
                                s5 = [s5, s6, s7, s8];
                                s4 = s5;
                            }
                            else {
                                peg$currPos = s4;
                                s4 = peg$FAILED;
                            }
                        }
                        else {
                            peg$currPos = s4;
                            s4 = peg$FAILED;
                        }
                    }
                    else {
                        peg$currPos = s4;
                        s4 = peg$FAILED;
                    }
                }
                else {
                    peg$currPos = s4;
                    s4 = peg$FAILED;
                }
                while (s4 !== peg$FAILED) {
                    s3.push(s4);
                    s4 = peg$currPos;
                    s5 = peg$parse_();
                    if (s5 !== peg$FAILED) {
                        s6 = peg$parseOrSign();
                        if (s6 !== peg$FAILED) {
                            s7 = peg$parse_();
                            if (s7 !== peg$FAILED) {
                                s8 = peg$parseLogicOr();
                                if (s8 !== peg$FAILED) {
                                    s5 = [s5, s6, s7, s8];
                                    s4 = s5;
                                }
                                else {
                                    peg$currPos = s4;
                                    s4 = peg$FAILED;
                                }
                            }
                            else {
                                peg$currPos = s4;
                                s4 = peg$FAILED;
                            }
                        }
                        else {
                            peg$currPos = s4;
                            s4 = peg$FAILED;
                        }
                    }
                    else {
                        peg$currPos = s4;
                        s4 = peg$FAILED;
                    }
                }
                if (s3 !== peg$FAILED) {
                    s4 = peg$parse_();
                    if (s4 !== peg$FAILED) {
                        peg$savedPos = s0;
                        s1 = peg$c0(s2, s3);
                        s0 = s1;
                    }
                    else {
                        peg$currPos = s0;
                        s0 = peg$FAILED;
                    }
                }
                else {
                    peg$currPos = s0;
                    s0 = peg$FAILED;
                }
            }
            else {
                peg$currPos = s0;
                s0 = peg$FAILED;
            }
        }
        else {
            peg$currPos = s0;
            s0 = peg$FAILED;
        }
        peg$resultsCache[key] = { nextPos: peg$currPos, result: s0 };
        return s0;
    }
    function peg$parseOrSign() {
        var s0, s1;
        var key = peg$currPos * 34 + 1;
        var cached = peg$resultsCache[key];
        if (cached) {
            peg$currPos = cached.nextPos;
            return cached.result;
        }
        s0 = peg$currPos;
        if (input.substr(peg$currPos, 2) === peg$c1) {
            s1 = peg$c1;
            peg$currPos += 2;
        }
        else {
            s1 = peg$FAILED;
            if (peg$silentFails === 0) {
                peg$fail(peg$c2);
            }
        }
        if (s1 === peg$FAILED) {
            if (input.substr(peg$currPos, 2).toLowerCase() === peg$c3) {
                s1 = input.substr(peg$currPos, 2);
                peg$currPos += 2;
            }
            else {
                s1 = peg$FAILED;
                if (peg$silentFails === 0) {
                    peg$fail(peg$c4);
                }
            }
        }
        if (s1 !== peg$FAILED) {
            peg$savedPos = s0;
            s1 = peg$c5();
        }
        s0 = s1;
        peg$resultsCache[key] = { nextPos: peg$currPos, result: s0 };
        return s0;
    }
    function peg$parseLogicOr() {
        var s0, s1, s2, s3, s4, s5, s6, s7;
        var key = peg$currPos * 34 + 2;
        var cached = peg$resultsCache[key];
        if (cached) {
            peg$currPos = cached.nextPos;
            return cached.result;
        }
        s0 = peg$currPos;
        s1 = peg$parseLogicAnd();
        if (s1 !== peg$FAILED) {
            s2 = [];
            s3 = peg$currPos;
            s4 = peg$parse_();
            if (s4 !== peg$FAILED) {
                s5 = peg$parseAndSign();
                if (s5 !== peg$FAILED) {
                    s6 = peg$parse_();
                    if (s6 !== peg$FAILED) {
                        s7 = peg$parseLogicAnd();
                        if (s7 !== peg$FAILED) {
                            s4 = [s4, s5, s6, s7];
                            s3 = s4;
                        }
                        else {
                            peg$currPos = s3;
                            s3 = peg$FAILED;
                        }
                    }
                    else {
                        peg$currPos = s3;
                        s3 = peg$FAILED;
                    }
                }
                else {
                    peg$currPos = s3;
                    s3 = peg$FAILED;
                }
            }
            else {
                peg$currPos = s3;
                s3 = peg$FAILED;
            }
            while (s3 !== peg$FAILED) {
                s2.push(s3);
                s3 = peg$currPos;
                s4 = peg$parse_();
                if (s4 !== peg$FAILED) {
                    s5 = peg$parseAndSign();
                    if (s5 !== peg$FAILED) {
                        s6 = peg$parse_();
                        if (s6 !== peg$FAILED) {
                            s7 = peg$parseLogicAnd();
                            if (s7 !== peg$FAILED) {
                                s4 = [s4, s5, s6, s7];
                                s3 = s4;
                            }
                            else {
                                peg$currPos = s3;
                                s3 = peg$FAILED;
                            }
                        }
                        else {
                            peg$currPos = s3;
                            s3 = peg$FAILED;
                        }
                    }
                    else {
                        peg$currPos = s3;
                        s3 = peg$FAILED;
                    }
                }
                else {
                    peg$currPos = s3;
                    s3 = peg$FAILED;
                }
            }
            if (s2 !== peg$FAILED) {
                peg$savedPos = s0;
                s1 = peg$c0(s1, s2);
                s0 = s1;
            }
            else {
                peg$currPos = s0;
                s0 = peg$FAILED;
            }
        }
        else {
            peg$currPos = s0;
            s0 = peg$FAILED;
        }
        peg$resultsCache[key] = { nextPos: peg$currPos, result: s0 };
        return s0;
    }
    function peg$parseAndSign() {
        var s0, s1;
        var key = peg$currPos * 34 + 3;
        var cached = peg$resultsCache[key];
        if (cached) {
            peg$currPos = cached.nextPos;
            return cached.result;
        }
        s0 = peg$currPos;
        if (input.substr(peg$currPos, 2) === peg$c6) {
            s1 = peg$c6;
            peg$currPos += 2;
        }
        else {
            s1 = peg$FAILED;
            if (peg$silentFails === 0) {
                peg$fail(peg$c7);
            }
        }
        if (s1 === peg$FAILED) {
            if (input.substr(peg$currPos, 3).toLowerCase() === peg$c8) {
                s1 = input.substr(peg$currPos, 3);
                peg$currPos += 3;
            }
            else {
                s1 = peg$FAILED;
                if (peg$silentFails === 0) {
                    peg$fail(peg$c9);
                }
            }
        }
        if (s1 !== peg$FAILED) {
            peg$savedPos = s0;
            s1 = peg$c10();
        }
        s0 = s1;
        peg$resultsCache[key] = { nextPos: peg$currPos, result: s0 };
        return s0;
    }
    function peg$parseLogicAnd() {
        var s0, s1, s2, s3, s4, s5, s6, s7;
        var key = peg$currPos * 34 + 4;
        var cached = peg$resultsCache[key];
        if (cached) {
            peg$currPos = cached.nextPos;
            return cached.result;
        }
        s0 = peg$currPos;
        s1 = peg$parseCompOps();
        if (s1 !== peg$FAILED) {
            s2 = [];
            s3 = peg$currPos;
            s4 = peg$parse_();
            if (s4 !== peg$FAILED) {
                s5 = peg$parseComparableOperators();
                if (s5 !== peg$FAILED) {
                    s6 = peg$parse_();
                    if (s6 !== peg$FAILED) {
                        s7 = peg$parseCompOps();
                        if (s7 !== peg$FAILED) {
                            s4 = [s4, s5, s6, s7];
                            s3 = s4;
                        }
                        else {
                            peg$currPos = s3;
                            s3 = peg$FAILED;
                        }
                    }
                    else {
                        peg$currPos = s3;
                        s3 = peg$FAILED;
                    }
                }
                else {
                    peg$currPos = s3;
                    s3 = peg$FAILED;
                }
            }
            else {
                peg$currPos = s3;
                s3 = peg$FAILED;
            }
            while (s3 !== peg$FAILED) {
                s2.push(s3);
                s3 = peg$currPos;
                s4 = peg$parse_();
                if (s4 !== peg$FAILED) {
                    s5 = peg$parseComparableOperators();
                    if (s5 !== peg$FAILED) {
                        s6 = peg$parse_();
                        if (s6 !== peg$FAILED) {
                            s7 = peg$parseCompOps();
                            if (s7 !== peg$FAILED) {
                                s4 = [s4, s5, s6, s7];
                                s3 = s4;
                            }
                            else {
                                peg$currPos = s3;
                                s3 = peg$FAILED;
                            }
                        }
                        else {
                            peg$currPos = s3;
                            s3 = peg$FAILED;
                        }
                    }
                    else {
                        peg$currPos = s3;
                        s3 = peg$FAILED;
                    }
                }
                else {
                    peg$currPos = s3;
                    s3 = peg$FAILED;
                }
            }
            if (s2 !== peg$FAILED) {
                peg$savedPos = s0;
                s1 = peg$c11(s1, s2);
                s0 = s1;
            }
            else {
                peg$currPos = s0;
                s0 = peg$FAILED;
            }
        }
        else {
            peg$currPos = s0;
            s0 = peg$FAILED;
        }
        peg$resultsCache[key] = { nextPos: peg$currPos, result: s0 };
        return s0;
    }
    function peg$parseComparableOperators() {
        var s0, s1;
        var key = peg$currPos * 34 + 5;
        var cached = peg$resultsCache[key];
        if (cached) {
            peg$currPos = cached.nextPos;
            return cached.result;
        }
        s0 = peg$currPos;
        if (input.substr(peg$currPos, 2) === peg$c12) {
            s1 = peg$c12;
            peg$currPos += 2;
        }
        else {
            s1 = peg$FAILED;
            if (peg$silentFails === 0) {
                peg$fail(peg$c13);
            }
        }
        if (s1 === peg$FAILED) {
            if (input.substr(peg$currPos, 11).toLowerCase() === peg$c14) {
                s1 = input.substr(peg$currPos, 11);
                peg$currPos += 11;
            }
            else {
                s1 = peg$FAILED;
                if (peg$silentFails === 0) {
                    peg$fail(peg$c15);
                }
            }
        }
        if (s1 !== peg$FAILED) {
            peg$savedPos = s0;
            s1 = peg$c16();
        }
        s0 = s1;
        if (s0 === peg$FAILED) {
            s0 = peg$currPos;
            if (input.substr(peg$currPos, 2) === peg$c17) {
                s1 = peg$c17;
                peg$currPos += 2;
            }
            else {
                s1 = peg$FAILED;
                if (peg$silentFails === 0) {
                    peg$fail(peg$c18);
                }
            }
            if (s1 === peg$FAILED) {
                if (input.substr(peg$currPos, 14).toLowerCase() === peg$c19) {
                    s1 = input.substr(peg$currPos, 14);
                    peg$currPos += 14;
                }
                else {
                    s1 = peg$FAILED;
                    if (peg$silentFails === 0) {
                        peg$fail(peg$c20);
                    }
                }
            }
            if (s1 !== peg$FAILED) {
                peg$savedPos = s0;
                s1 = peg$c21();
            }
            s0 = s1;
            if (s0 === peg$FAILED) {
                s0 = peg$currPos;
                if (input.charCodeAt(peg$currPos) === 61) {
                    s1 = peg$c22;
                    peg$currPos++;
                }
                else {
                    s1 = peg$FAILED;
                    if (peg$silentFails === 0) {
                        peg$fail(peg$c23);
                    }
                }
                if (s1 === peg$FAILED) {
                    if (input.substr(peg$currPos, 5).toLowerCase() === peg$c24) {
                        s1 = input.substr(peg$currPos, 5);
                        peg$currPos += 5;
                    }
                    else {
                        s1 = peg$FAILED;
                        if (peg$silentFails === 0) {
                            peg$fail(peg$c25);
                        }
                    }
                }
                if (s1 !== peg$FAILED) {
                    peg$savedPos = s0;
                    s1 = peg$c26();
                }
                s0 = s1;
                if (s0 === peg$FAILED) {
                    s0 = peg$currPos;
                    if (input.substr(peg$currPos, 2) === peg$c27) {
                        s1 = peg$c27;
                        peg$currPos += 2;
                    }
                    else {
                        s1 = peg$FAILED;
                        if (peg$silentFails === 0) {
                            peg$fail(peg$c28);
                        }
                    }
                    if (s1 === peg$FAILED) {
                        if (input.substr(peg$currPos, 8).toLowerCase() === peg$c29) {
                            s1 = input.substr(peg$currPos, 8);
                            peg$currPos += 8;
                        }
                        else {
                            s1 = peg$FAILED;
                            if (peg$silentFails === 0) {
                                peg$fail(peg$c30);
                            }
                        }
                    }
                    if (s1 !== peg$FAILED) {
                        peg$savedPos = s0;
                        s1 = peg$c31();
                    }
                    s0 = s1;
                    if (s0 === peg$FAILED) {
                        s0 = peg$currPos;
                        if (input.charCodeAt(peg$currPos) === 60) {
                            s1 = peg$c32;
                            peg$currPos++;
                        }
                        else {
                            s1 = peg$FAILED;
                            if (peg$silentFails === 0) {
                                peg$fail(peg$c33);
                            }
                        }
                        if (s1 === peg$FAILED) {
                            if (input.substr(peg$currPos, 4).toLowerCase() === peg$c34) {
                                s1 = input.substr(peg$currPos, 4);
                                peg$currPos += 4;
                            }
                            else {
                                s1 = peg$FAILED;
                                if (peg$silentFails === 0) {
                                    peg$fail(peg$c35);
                                }
                            }
                        }
                        if (s1 !== peg$FAILED) {
                            peg$savedPos = s0;
                            s1 = peg$c36();
                        }
                        s0 = s1;
                        if (s0 === peg$FAILED) {
                            s0 = peg$currPos;
                            if (input.charCodeAt(peg$currPos) === 62) {
                                s1 = peg$c37;
                                peg$currPos++;
                            }
                            else {
                                s1 = peg$FAILED;
                                if (peg$silentFails === 0) {
                                    peg$fail(peg$c38);
                                }
                            }
                            if (s1 === peg$FAILED) {
                                if (input.substr(peg$currPos, 7).toLowerCase() === peg$c39) {
                                    s1 = input.substr(peg$currPos, 7);
                                    peg$currPos += 7;
                                }
                                else {
                                    s1 = peg$FAILED;
                                    if (peg$silentFails === 0) {
                                        peg$fail(peg$c40);
                                    }
                                }
                            }
                            if (s1 !== peg$FAILED) {
                                peg$savedPos = s0;
                                s1 = peg$c41();
                            }
                            s0 = s1;
                        }
                    }
                }
            }
        }
        peg$resultsCache[key] = { nextPos: peg$currPos, result: s0 };
        return s0;
    }
    function peg$parseCompOps() {
        var s0, s1, s2, s3, s4, s5, s6, s7;
        var key = peg$currPos * 34 + 6;
        var cached = peg$resultsCache[key];
        if (cached) {
            peg$currPos = cached.nextPos;
            return cached.result;
        }
        s0 = peg$currPos;
        s1 = peg$parsePlusMinusOps();
        if (s1 !== peg$FAILED) {
            s2 = [];
            s3 = peg$currPos;
            s4 = peg$parse_();
            if (s4 !== peg$FAILED) {
                s5 = peg$parsePlusMinusSigns();
                if (s5 !== peg$FAILED) {
                    s6 = peg$parse_();
                    if (s6 !== peg$FAILED) {
                        s7 = peg$parsePlusMinusOps();
                        if (s7 !== peg$FAILED) {
                            s4 = [s4, s5, s6, s7];
                            s3 = s4;
                        }
                        else {
                            peg$currPos = s3;
                            s3 = peg$FAILED;
                        }
                    }
                    else {
                        peg$currPos = s3;
                        s3 = peg$FAILED;
                    }
                }
                else {
                    peg$currPos = s3;
                    s3 = peg$FAILED;
                }
            }
            else {
                peg$currPos = s3;
                s3 = peg$FAILED;
            }
            while (s3 !== peg$FAILED) {
                s2.push(s3);
                s3 = peg$currPos;
                s4 = peg$parse_();
                if (s4 !== peg$FAILED) {
                    s5 = peg$parsePlusMinusSigns();
                    if (s5 !== peg$FAILED) {
                        s6 = peg$parse_();
                        if (s6 !== peg$FAILED) {
                            s7 = peg$parsePlusMinusOps();
                            if (s7 !== peg$FAILED) {
                                s4 = [s4, s5, s6, s7];
                                s3 = s4;
                            }
                            else {
                                peg$currPos = s3;
                                s3 = peg$FAILED;
                            }
                        }
                        else {
                            peg$currPos = s3;
                            s3 = peg$FAILED;
                        }
                    }
                    else {
                        peg$currPos = s3;
                        s3 = peg$FAILED;
                    }
                }
                else {
                    peg$currPos = s3;
                    s3 = peg$FAILED;
                }
            }
            if (s2 !== peg$FAILED) {
                peg$savedPos = s0;
                s1 = peg$c0(s1, s2);
                s0 = s1;
            }
            else {
                peg$currPos = s0;
                s0 = peg$FAILED;
            }
        }
        else {
            peg$currPos = s0;
            s0 = peg$FAILED;
        }
        peg$resultsCache[key] = { nextPos: peg$currPos, result: s0 };
        return s0;
    }
    function peg$parsePlusMinusSigns() {
        var s0, s1;
        var key = peg$currPos * 34 + 7;
        var cached = peg$resultsCache[key];
        if (cached) {
            peg$currPos = cached.nextPos;
            return cached.result;
        }
        s0 = peg$currPos;
        if (input.charCodeAt(peg$currPos) === 43) {
            s1 = peg$c42;
            peg$currPos++;
        }
        else {
            s1 = peg$FAILED;
            if (peg$silentFails === 0) {
                peg$fail(peg$c43);
            }
        }
        if (s1 !== peg$FAILED) {
            peg$savedPos = s0;
            s1 = peg$c44();
        }
        s0 = s1;
        if (s0 === peg$FAILED) {
            s0 = peg$currPos;
            if (input.charCodeAt(peg$currPos) === 45) {
                s1 = peg$c45;
                peg$currPos++;
            }
            else {
                s1 = peg$FAILED;
                if (peg$silentFails === 0) {
                    peg$fail(peg$c46);
                }
            }
            if (s1 !== peg$FAILED) {
                peg$savedPos = s0;
                s1 = peg$c47();
            }
            s0 = s1;
        }
        peg$resultsCache[key] = { nextPos: peg$currPos, result: s0 };
        return s0;
    }
    function peg$parsePlusMinusOps() {
        var s0, s1, s2, s3, s4, s5, s6, s7;
        var key = peg$currPos * 34 + 8;
        var cached = peg$resultsCache[key];
        if (cached) {
            peg$currPos = cached.nextPos;
            return cached.result;
        }
        s0 = peg$currPos;
        s1 = peg$parseMulDivOps();
        if (s1 !== peg$FAILED) {
            s2 = [];
            s3 = peg$currPos;
            s4 = peg$parse_();
            if (s4 !== peg$FAILED) {
                s5 = peg$parseMulDivSigns();
                if (s5 !== peg$FAILED) {
                    s6 = peg$parse_();
                    if (s6 !== peg$FAILED) {
                        s7 = peg$parseMulDivOps();
                        if (s7 !== peg$FAILED) {
                            s4 = [s4, s5, s6, s7];
                            s3 = s4;
                        }
                        else {
                            peg$currPos = s3;
                            s3 = peg$FAILED;
                        }
                    }
                    else {
                        peg$currPos = s3;
                        s3 = peg$FAILED;
                    }
                }
                else {
                    peg$currPos = s3;
                    s3 = peg$FAILED;
                }
            }
            else {
                peg$currPos = s3;
                s3 = peg$FAILED;
            }
            while (s3 !== peg$FAILED) {
                s2.push(s3);
                s3 = peg$currPos;
                s4 = peg$parse_();
                if (s4 !== peg$FAILED) {
                    s5 = peg$parseMulDivSigns();
                    if (s5 !== peg$FAILED) {
                        s6 = peg$parse_();
                        if (s6 !== peg$FAILED) {
                            s7 = peg$parseMulDivOps();
                            if (s7 !== peg$FAILED) {
                                s4 = [s4, s5, s6, s7];
                                s3 = s4;
                            }
                            else {
                                peg$currPos = s3;
                                s3 = peg$FAILED;
                            }
                        }
                        else {
                            peg$currPos = s3;
                            s3 = peg$FAILED;
                        }
                    }
                    else {
                        peg$currPos = s3;
                        s3 = peg$FAILED;
                    }
                }
                else {
                    peg$currPos = s3;
                    s3 = peg$FAILED;
                }
            }
            if (s2 !== peg$FAILED) {
                peg$savedPos = s0;
                s1 = peg$c0(s1, s2);
                s0 = s1;
            }
            else {
                peg$currPos = s0;
                s0 = peg$FAILED;
            }
        }
        else {
            peg$currPos = s0;
            s0 = peg$FAILED;
        }
        peg$resultsCache[key] = { nextPos: peg$currPos, result: s0 };
        return s0;
    }
    function peg$parseMulDivSigns() {
        var s0, s1;
        var key = peg$currPos * 34 + 9;
        var cached = peg$resultsCache[key];
        if (cached) {
            peg$currPos = cached.nextPos;
            return cached.result;
        }
        s0 = peg$currPos;
        if (input.charCodeAt(peg$currPos) === 42) {
            s1 = peg$c48;
            peg$currPos++;
        }
        else {
            s1 = peg$FAILED;
            if (peg$silentFails === 0) {
                peg$fail(peg$c49);
            }
        }
        if (s1 !== peg$FAILED) {
            peg$savedPos = s0;
            s1 = peg$c50();
        }
        s0 = s1;
        if (s0 === peg$FAILED) {
            s0 = peg$currPos;
            if (input.charCodeAt(peg$currPos) === 47) {
                s1 = peg$c51;
                peg$currPos++;
            }
            else {
                s1 = peg$FAILED;
                if (peg$silentFails === 0) {
                    peg$fail(peg$c52);
                }
            }
            if (s1 !== peg$FAILED) {
                peg$savedPos = s0;
                s1 = peg$c53();
            }
            s0 = s1;
            if (s0 === peg$FAILED) {
                s0 = peg$currPos;
                if (input.charCodeAt(peg$currPos) === 37) {
                    s1 = peg$c54;
                    peg$currPos++;
                }
                else {
                    s1 = peg$FAILED;
                    if (peg$silentFails === 0) {
                        peg$fail(peg$c55);
                    }
                }
                if (s1 !== peg$FAILED) {
                    peg$savedPos = s0;
                    s1 = peg$c56();
                }
                s0 = s1;
            }
        }
        peg$resultsCache[key] = { nextPos: peg$currPos, result: s0 };
        return s0;
    }
    function peg$parseMulDivOps() {
        var s0, s1, s2, s3, s4, s5, s6, s7;
        var key = peg$currPos * 34 + 10;
        var cached = peg$resultsCache[key];
        if (cached) {
            peg$currPos = cached.nextPos;
            return cached.result;
        }
        s0 = peg$currPos;
        s1 = peg$parseBinaryFuncOp();
        if (s1 !== peg$FAILED) {
            s2 = [];
            s3 = peg$currPos;
            s4 = peg$parse_();
            if (s4 !== peg$FAILED) {
                s5 = peg$parsePowerSigns();
                if (s5 !== peg$FAILED) {
                    s6 = peg$parse_();
                    if (s6 !== peg$FAILED) {
                        s7 = peg$parseBinaryFuncOp();
                        if (s7 !== peg$FAILED) {
                            s4 = [s4, s5, s6, s7];
                            s3 = s4;
                        }
                        else {
                            peg$currPos = s3;
                            s3 = peg$FAILED;
                        }
                    }
                    else {
                        peg$currPos = s3;
                        s3 = peg$FAILED;
                    }
                }
                else {
                    peg$currPos = s3;
                    s3 = peg$FAILED;
                }
            }
            else {
                peg$currPos = s3;
                s3 = peg$FAILED;
            }
            while (s3 !== peg$FAILED) {
                s2.push(s3);
                s3 = peg$currPos;
                s4 = peg$parse_();
                if (s4 !== peg$FAILED) {
                    s5 = peg$parsePowerSigns();
                    if (s5 !== peg$FAILED) {
                        s6 = peg$parse_();
                        if (s6 !== peg$FAILED) {
                            s7 = peg$parseBinaryFuncOp();
                            if (s7 !== peg$FAILED) {
                                s4 = [s4, s5, s6, s7];
                                s3 = s4;
                            }
                            else {
                                peg$currPos = s3;
                                s3 = peg$FAILED;
                            }
                        }
                        else {
                            peg$currPos = s3;
                            s3 = peg$FAILED;
                        }
                    }
                    else {
                        peg$currPos = s3;
                        s3 = peg$FAILED;
                    }
                }
                else {
                    peg$currPos = s3;
                    s3 = peg$FAILED;
                }
            }
            if (s2 !== peg$FAILED) {
                peg$savedPos = s0;
                s1 = peg$c0(s1, s2);
                s0 = s1;
            }
            else {
                peg$currPos = s0;
                s0 = peg$FAILED;
            }
        }
        else {
            peg$currPos = s0;
            s0 = peg$FAILED;
        }
        peg$resultsCache[key] = { nextPos: peg$currPos, result: s0 };
        return s0;
    }
    function peg$parsePowerSigns() {
        var s0, s1;
        var key = peg$currPos * 34 + 11;
        var cached = peg$resultsCache[key];
        if (cached) {
            peg$currPos = cached.nextPos;
            return cached.result;
        }
        s0 = peg$currPos;
        if (input.charCodeAt(peg$currPos) === 94) {
            s1 = peg$c57;
            peg$currPos++;
        }
        else {
            s1 = peg$FAILED;
            if (peg$silentFails === 0) {
                peg$fail(peg$c58);
            }
        }
        if (s1 === peg$FAILED) {
            if (input.substr(peg$currPos, 5).toLowerCase() === peg$c59) {
                s1 = input.substr(peg$currPos, 5);
                peg$currPos += 5;
            }
            else {
                s1 = peg$FAILED;
                if (peg$silentFails === 0) {
                    peg$fail(peg$c60);
                }
            }
        }
        if (s1 !== peg$FAILED) {
            peg$savedPos = s0;
            s1 = peg$c61();
        }
        s0 = s1;
        peg$resultsCache[key] = { nextPos: peg$currPos, result: s0 };
        return s0;
    }
    function peg$parseBinaryFuncOp() {
        var s0, s1, s2, s3, s4, s5, s6, s7;
        var key = peg$currPos * 34 + 12;
        var cached = peg$resultsCache[key];
        if (cached) {
            peg$currPos = cached.nextPos;
            return cached.result;
        }
        s0 = peg$currPos;
        s1 = peg$parseFactor();
        if (s1 !== peg$FAILED) {
            s2 = [];
            s3 = peg$currPos;
            s4 = peg$parse_();
            if (s4 !== peg$FAILED) {
                s5 = peg$parseBinFunctions();
                if (s5 !== peg$FAILED) {
                    s6 = peg$parse_();
                    if (s6 !== peg$FAILED) {
                        s7 = peg$parseFactor();
                        if (s7 === peg$FAILED) {
                            s7 = null;
                        }
                        if (s7 !== peg$FAILED) {
                            s4 = [s4, s5, s6, s7];
                            s3 = s4;
                        }
                        else {
                            peg$currPos = s3;
                            s3 = peg$FAILED;
                        }
                    }
                    else {
                        peg$currPos = s3;
                        s3 = peg$FAILED;
                    }
                }
                else {
                    peg$currPos = s3;
                    s3 = peg$FAILED;
                }
            }
            else {
                peg$currPos = s3;
                s3 = peg$FAILED;
            }
            while (s3 !== peg$FAILED) {
                s2.push(s3);
                s3 = peg$currPos;
                s4 = peg$parse_();
                if (s4 !== peg$FAILED) {
                    s5 = peg$parseBinFunctions();
                    if (s5 !== peg$FAILED) {
                        s6 = peg$parse_();
                        if (s6 !== peg$FAILED) {
                            s7 = peg$parseFactor();
                            if (s7 === peg$FAILED) {
                                s7 = null;
                            }
                            if (s7 !== peg$FAILED) {
                                s4 = [s4, s5, s6, s7];
                                s3 = s4;
                            }
                            else {
                                peg$currPos = s3;
                                s3 = peg$FAILED;
                            }
                        }
                        else {
                            peg$currPos = s3;
                            s3 = peg$FAILED;
                        }
                    }
                    else {
                        peg$currPos = s3;
                        s3 = peg$FAILED;
                    }
                }
                else {
                    peg$currPos = s3;
                    s3 = peg$FAILED;
                }
            }
            if (s2 !== peg$FAILED) {
                peg$savedPos = s0;
                s1 = peg$c11(s1, s2);
                s0 = s1;
            }
            else {
                peg$currPos = s0;
                s0 = peg$FAILED;
            }
        }
        else {
            peg$currPos = s0;
            s0 = peg$FAILED;
        }
        peg$resultsCache[key] = { nextPos: peg$currPos, result: s0 };
        return s0;
    }
    function peg$parseBinFunctions() {
        var s0, s1;
        var key = peg$currPos * 34 + 13;
        var cached = peg$resultsCache[key];
        if (cached) {
            peg$currPos = cached.nextPos;
            return cached.result;
        }
        s0 = peg$currPos;
        if (input.substr(peg$currPos, 2) === peg$c62) {
            s1 = peg$c62;
            peg$currPos += 2;
        }
        else {
            s1 = peg$FAILED;
            if (peg$silentFails === 0) {
                peg$fail(peg$c63);
            }
        }
        if (s1 === peg$FAILED) {
            if (input.substr(peg$currPos, 8).toLowerCase() === peg$c64) {
                s1 = input.substr(peg$currPos, 8);
                peg$currPos += 8;
            }
            else {
                s1 = peg$FAILED;
                if (peg$silentFails === 0) {
                    peg$fail(peg$c65);
                }
            }
            if (s1 === peg$FAILED) {
                if (input.substr(peg$currPos, 7).toLowerCase() === peg$c66) {
                    s1 = input.substr(peg$currPos, 7);
                    peg$currPos += 7;
                }
                else {
                    s1 = peg$FAILED;
                    if (peg$silentFails === 0) {
                        peg$fail(peg$c67);
                    }
                }
            }
        }
        if (s1 !== peg$FAILED) {
            peg$savedPos = s0;
            s1 = peg$c68();
        }
        s0 = s1;
        if (s0 === peg$FAILED) {
            s0 = peg$currPos;
            if (input.substr(peg$currPos, 11).toLowerCase() === peg$c69) {
                s1 = input.substr(peg$currPos, 11);
                peg$currPos += 11;
            }
            else {
                s1 = peg$FAILED;
                if (peg$silentFails === 0) {
                    peg$fail(peg$c70);
                }
            }
            if (s1 === peg$FAILED) {
                if (input.substr(peg$currPos, 10).toLowerCase() === peg$c71) {
                    s1 = input.substr(peg$currPos, 10);
                    peg$currPos += 10;
                }
                else {
                    s1 = peg$FAILED;
                    if (peg$silentFails === 0) {
                        peg$fail(peg$c72);
                    }
                }
            }
            if (s1 !== peg$FAILED) {
                peg$savedPos = s0;
                s1 = peg$c73();
            }
            s0 = s1;
            if (s0 === peg$FAILED) {
                s0 = peg$currPos;
                if (input.substr(peg$currPos, 5).toLowerCase() === peg$c74) {
                    s1 = input.substr(peg$currPos, 5);
                    peg$currPos += 5;
                }
                else {
                    s1 = peg$FAILED;
                    if (peg$silentFails === 0) {
                        peg$fail(peg$c75);
                    }
                }
                if (s1 !== peg$FAILED) {
                    peg$savedPos = s0;
                    s1 = peg$c76();
                }
                s0 = s1;
                if (s0 === peg$FAILED) {
                    s0 = peg$currPos;
                    if (input.substr(peg$currPos, 5).toLowerCase() === peg$c77) {
                        s1 = input.substr(peg$currPos, 5);
                        peg$currPos += 5;
                    }
                    else {
                        s1 = peg$FAILED;
                        if (peg$silentFails === 0) {
                            peg$fail(peg$c78);
                        }
                    }
                    if (s1 !== peg$FAILED) {
                        peg$savedPos = s0;
                        s1 = peg$c79();
                    }
                    s0 = s1;
                }
            }
        }
        peg$resultsCache[key] = { nextPos: peg$currPos, result: s0 };
        return s0;
    }
    function peg$parseFactor() {
        var s0, s1, s2, s3, s4, s5;
        var key = peg$currPos * 34 + 14;
        var cached = peg$resultsCache[key];
        if (cached) {
            peg$currPos = cached.nextPos;
            return cached.result;
        }
        s0 = peg$currPos;
        if (input.charCodeAt(peg$currPos) === 40) {
            s1 = peg$c80;
            peg$currPos++;
        }
        else {
            s1 = peg$FAILED;
            if (peg$silentFails === 0) {
                peg$fail(peg$c81);
            }
        }
        if (s1 !== peg$FAILED) {
            s2 = peg$parse_();
            if (s2 !== peg$FAILED) {
                s3 = peg$parseExpression();
                if (s3 !== peg$FAILED) {
                    s4 = peg$parse_();
                    if (s4 !== peg$FAILED) {
                        if (input.charCodeAt(peg$currPos) === 41) {
                            s5 = peg$c82;
                            peg$currPos++;
                        }
                        else {
                            s5 = peg$FAILED;
                            if (peg$silentFails === 0) {
                                peg$fail(peg$c83);
                            }
                        }
                        if (s5 === peg$FAILED) {
                            s5 = null;
                        }
                        if (s5 !== peg$FAILED) {
                            peg$savedPos = s0;
                            s1 = peg$c84(s3);
                            s0 = s1;
                        }
                        else {
                            peg$currPos = s0;
                            s0 = peg$FAILED;
                        }
                    }
                    else {
                        peg$currPos = s0;
                        s0 = peg$FAILED;
                    }
                }
                else {
                    peg$currPos = s0;
                    s0 = peg$FAILED;
                }
            }
            else {
                peg$currPos = s0;
                s0 = peg$FAILED;
            }
        }
        else {
            peg$currPos = s0;
            s0 = peg$FAILED;
        }
        if (s0 === peg$FAILED) {
            s0 = peg$parseFunctionOp();
            if (s0 === peg$FAILED) {
                s0 = peg$parseUnaryFunctionOp();
                if (s0 === peg$FAILED) {
                    s0 = peg$parseAtom();
                    if (s0 === peg$FAILED) {
                        s0 = peg$parseArrayOp();
                    }
                }
            }
        }
        peg$resultsCache[key] = { nextPos: peg$currPos, result: s0 };
        return s0;
    }
    function peg$parseFunctionOp() {
        var s0, s1, s2, s3, s4;
        var key = peg$currPos * 34 + 15;
        var cached = peg$resultsCache[key];
        if (cached) {
            peg$currPos = cached.nextPos;
            return cached.result;
        }
        s0 = peg$currPos;
        s1 = peg$parseLettersAndDigits();
        if (s1 !== peg$FAILED) {
            if (input.charCodeAt(peg$currPos) === 40) {
                s2 = peg$c80;
                peg$currPos++;
            }
            else {
                s2 = peg$FAILED;
                if (peg$silentFails === 0) {
                    peg$fail(peg$c81);
                }
            }
            if (s2 !== peg$FAILED) {
                s3 = peg$parseSequence();
                if (s3 !== peg$FAILED) {
                    if (input.charCodeAt(peg$currPos) === 41) {
                        s4 = peg$c82;
                        peg$currPos++;
                    }
                    else {
                        s4 = peg$FAILED;
                        if (peg$silentFails === 0) {
                            peg$fail(peg$c83);
                        }
                    }
                    if (s4 === peg$FAILED) {
                        s4 = null;
                    }
                    if (s4 !== peg$FAILED) {
                        peg$savedPos = s0;
                        s1 = peg$c85(s1, s3);
                        s0 = s1;
                    }
                    else {
                        peg$currPos = s0;
                        s0 = peg$FAILED;
                    }
                }
                else {
                    peg$currPos = s0;
                    s0 = peg$FAILED;
                }
            }
            else {
                peg$currPos = s0;
                s0 = peg$FAILED;
            }
        }
        else {
            peg$currPos = s0;
            s0 = peg$FAILED;
        }
        peg$resultsCache[key] = { nextPos: peg$currPos, result: s0 };
        return s0;
    }
    function peg$parseUnaryFunctionOp() {
        var s0, s1, s2, s3;
        var key = peg$currPos * 34 + 16;
        var cached = peg$resultsCache[key];
        if (cached) {
            peg$currPos = cached.nextPos;
            return cached.result;
        }
        s0 = peg$currPos;
        if (input.charCodeAt(peg$currPos) === 33) {
            s1 = peg$c86;
            peg$currPos++;
        }
        else {
            s1 = peg$FAILED;
            if (peg$silentFails === 0) {
                peg$fail(peg$c87);
            }
        }
        if (s1 === peg$FAILED) {
            if (input.substr(peg$currPos, 6).toLowerCase() === peg$c88) {
                s1 = input.substr(peg$currPos, 6);
                peg$currPos += 6;
            }
            else {
                s1 = peg$FAILED;
                if (peg$silentFails === 0) {
                    peg$fail(peg$c89);
                }
            }
        }
        if (s1 !== peg$FAILED) {
            s2 = peg$parse_();
            if (s2 !== peg$FAILED) {
                s3 = peg$parseExpression();
                if (s3 !== peg$FAILED) {
                    peg$savedPos = s0;
                    s1 = peg$c90(s3);
                    s0 = s1;
                }
                else {
                    peg$currPos = s0;
                    s0 = peg$FAILED;
                }
            }
            else {
                peg$currPos = s0;
                s0 = peg$FAILED;
            }
        }
        else {
            peg$currPos = s0;
            s0 = peg$FAILED;
        }
        if (s0 === peg$FAILED) {
            s0 = peg$currPos;
            s1 = peg$parseAtom();
            if (s1 !== peg$FAILED) {
                s2 = peg$parse_();
                if (s2 !== peg$FAILED) {
                    s3 = peg$parseUnFunctions();
                    if (s3 !== peg$FAILED) {
                        peg$savedPos = s0;
                        s1 = peg$c91(s1, s3);
                        s0 = s1;
                    }
                    else {
                        peg$currPos = s0;
                        s0 = peg$FAILED;
                    }
                }
                else {
                    peg$currPos = s0;
                    s0 = peg$FAILED;
                }
            }
            else {
                peg$currPos = s0;
                s0 = peg$FAILED;
            }
        }
        peg$resultsCache[key] = { nextPos: peg$currPos, result: s0 };
        return s0;
    }
    function peg$parseUnFunctions() {
        var s0, s1;
        var key = peg$currPos * 34 + 17;
        var cached = peg$resultsCache[key];
        if (cached) {
            peg$currPos = cached.nextPos;
            return cached.result;
        }
        s0 = peg$currPos;
        if (input.substr(peg$currPos, 5).toLowerCase() === peg$c92) {
            s1 = input.substr(peg$currPos, 5);
            peg$currPos += 5;
        }
        else {
            s1 = peg$FAILED;
            if (peg$silentFails === 0) {
                peg$fail(peg$c93);
            }
        }
        if (s1 !== peg$FAILED) {
            peg$savedPos = s0;
            s1 = peg$c94();
        }
        s0 = s1;
        if (s0 === peg$FAILED) {
            s0 = peg$currPos;
            if (input.substr(peg$currPos, 8).toLowerCase() === peg$c95) {
                s1 = input.substr(peg$currPos, 8);
                peg$currPos += 8;
            }
            else {
                s1 = peg$FAILED;
                if (peg$silentFails === 0) {
                    peg$fail(peg$c96);
                }
            }
            if (s1 !== peg$FAILED) {
                peg$savedPos = s0;
                s1 = peg$c97();
            }
            s0 = s1;
        }
        peg$resultsCache[key] = { nextPos: peg$currPos, result: s0 };
        return s0;
    }
    function peg$parseAtom() {
        var s0, s1, s2, s3, s4;
        var key = peg$currPos * 34 + 18;
        var cached = peg$resultsCache[key];
        if (cached) {
            peg$currPos = cached.nextPos;
            return cached.result;
        }
        s0 = peg$currPos;
        s1 = peg$parse_();
        if (s1 !== peg$FAILED) {
            if (input.substr(peg$currPos, 9) === peg$c98) {
                s2 = peg$c98;
                peg$currPos += 9;
            }
            else {
                s2 = peg$FAILED;
                if (peg$silentFails === 0) {
                    peg$fail(peg$c99);
                }
            }
            if (s2 === peg$FAILED) {
                if (input.substr(peg$currPos, 4) === peg$c100) {
                    s2 = peg$c100;
                    peg$currPos += 4;
                }
                else {
                    s2 = peg$FAILED;
                    if (peg$silentFails === 0) {
                        peg$fail(peg$c101);
                    }
                }
            }
            if (s2 !== peg$FAILED) {
                peg$savedPos = s0;
                s1 = peg$c102();
                s0 = s1;
            }
            else {
                peg$currPos = s0;
                s0 = peg$FAILED;
            }
        }
        else {
            peg$currPos = s0;
            s0 = peg$FAILED;
        }
        if (s0 === peg$FAILED) {
            s0 = peg$currPos;
            s1 = peg$parse_();
            if (s1 !== peg$FAILED) {
                s2 = peg$parseConstValue();
                if (s2 !== peg$FAILED) {
                    peg$savedPos = s0;
                    s1 = peg$c103(s2);
                    s0 = s1;
                }
                else {
                    peg$currPos = s0;
                    s0 = peg$FAILED;
                }
            }
            else {
                peg$currPos = s0;
                s0 = peg$FAILED;
            }
            if (s0 === peg$FAILED) {
                s0 = peg$currPos;
                s1 = peg$parse_();
                if (s1 !== peg$FAILED) {
                    if (input.charCodeAt(peg$currPos) === 123) {
                        s2 = peg$c104;
                        peg$currPos++;
                    }
                    else {
                        s2 = peg$FAILED;
                        if (peg$silentFails === 0) {
                            peg$fail(peg$c105);
                        }
                    }
                    if (s2 !== peg$FAILED) {
                        s3 = peg$parseValueInput();
                        if (s3 !== peg$FAILED) {
                            if (input.charCodeAt(peg$currPos) === 125) {
                                s4 = peg$c106;
                                peg$currPos++;
                            }
                            else {
                                s4 = peg$FAILED;
                                if (peg$silentFails === 0) {
                                    peg$fail(peg$c107);
                                }
                            }
                            if (s4 !== peg$FAILED) {
                                peg$savedPos = s0;
                                s1 = peg$c108(s3);
                                s0 = s1;
                            }
                            else {
                                peg$currPos = s0;
                                s0 = peg$FAILED;
                            }
                        }
                        else {
                            peg$currPos = s0;
                            s0 = peg$FAILED;
                        }
                    }
                    else {
                        peg$currPos = s0;
                        s0 = peg$FAILED;
                    }
                }
                else {
                    peg$currPos = s0;
                    s0 = peg$FAILED;
                }
            }
        }
        peg$resultsCache[key] = { nextPos: peg$currPos, result: s0 };
        return s0;
    }
    function peg$parseConstValue() {
        var s0, s1, s2, s3;
        var key = peg$currPos * 34 + 19;
        var cached = peg$resultsCache[key];
        if (cached) {
            peg$currPos = cached.nextPos;
            return cached.result;
        }
        s0 = peg$currPos;
        s1 = peg$parseLogicValue();
        if (s1 !== peg$FAILED) {
            peg$savedPos = s0;
            s1 = peg$c109(s1);
        }
        s0 = s1;
        if (s0 === peg$FAILED) {
            s0 = peg$currPos;
            s1 = peg$parseArithmeticValue();
            if (s1 !== peg$FAILED) {
                peg$savedPos = s0;
                s1 = peg$c109(s1);
            }
            s0 = s1;
            if (s0 === peg$FAILED) {
                s0 = peg$currPos;
                s1 = peg$parseLettersAndDigits();
                if (s1 !== peg$FAILED) {
                    peg$savedPos = s0;
                    s1 = peg$c109(s1);
                }
                s0 = s1;
                if (s0 === peg$FAILED) {
                    s0 = peg$currPos;
                    if (input.substr(peg$currPos, 2) === peg$c110) {
                        s1 = peg$c110;
                        peg$currPos += 2;
                    }
                    else {
                        s1 = peg$FAILED;
                        if (peg$silentFails === 0) {
                            peg$fail(peg$c111);
                        }
                    }
                    if (s1 !== peg$FAILED) {
                        peg$savedPos = s0;
                        s1 = peg$c112();
                    }
                    s0 = s1;
                    if (s0 === peg$FAILED) {
                        s0 = peg$currPos;
                        if (input.substr(peg$currPos, 2) === peg$c113) {
                            s1 = peg$c113;
                            peg$currPos += 2;
                        }
                        else {
                            s1 = peg$FAILED;
                            if (peg$silentFails === 0) {
                                peg$fail(peg$c114);
                            }
                        }
                        if (s1 !== peg$FAILED) {
                            peg$savedPos = s0;
                            s1 = peg$c112();
                        }
                        s0 = s1;
                        if (s0 === peg$FAILED) {
                            s0 = peg$currPos;
                            if (input.charCodeAt(peg$currPos) === 39) {
                                s1 = peg$c115;
                                peg$currPos++;
                            }
                            else {
                                s1 = peg$FAILED;
                                if (peg$silentFails === 0) {
                                    peg$fail(peg$c116);
                                }
                            }
                            if (s1 !== peg$FAILED) {
                                s2 = peg$parseAnyInput();
                                if (s2 !== peg$FAILED) {
                                    if (input.charCodeAt(peg$currPos) === 39) {
                                        s3 = peg$c115;
                                        peg$currPos++;
                                    }
                                    else {
                                        s3 = peg$FAILED;
                                        if (peg$silentFails === 0) {
                                            peg$fail(peg$c116);
                                        }
                                    }
                                    if (s3 !== peg$FAILED) {
                                        peg$savedPos = s0;
                                        s1 = peg$c117(s2);
                                        s0 = s1;
                                    }
                                    else {
                                        peg$currPos = s0;
                                        s0 = peg$FAILED;
                                    }
                                }
                                else {
                                    peg$currPos = s0;
                                    s0 = peg$FAILED;
                                }
                            }
                            else {
                                peg$currPos = s0;
                                s0 = peg$FAILED;
                            }
                            if (s0 === peg$FAILED) {
                                s0 = peg$currPos;
                                if (input.charCodeAt(peg$currPos) === 34) {
                                    s1 = peg$c118;
                                    peg$currPos++;
                                }
                                else {
                                    s1 = peg$FAILED;
                                    if (peg$silentFails === 0) {
                                        peg$fail(peg$c119);
                                    }
                                }
                                if (s1 !== peg$FAILED) {
                                    s2 = peg$parseAnyInput();
                                    if (s2 !== peg$FAILED) {
                                        if (input.charCodeAt(peg$currPos) === 34) {
                                            s3 = peg$c118;
                                            peg$currPos++;
                                        }
                                        else {
                                            s3 = peg$FAILED;
                                            if (peg$silentFails === 0) {
                                                peg$fail(peg$c119);
                                            }
                                        }
                                        if (s3 !== peg$FAILED) {
                                            peg$savedPos = s0;
                                            s1 = peg$c117(s2);
                                            s0 = s1;
                                        }
                                        else {
                                            peg$currPos = s0;
                                            s0 = peg$FAILED;
                                        }
                                    }
                                    else {
                                        peg$currPos = s0;
                                        s0 = peg$FAILED;
                                    }
                                }
                                else {
                                    peg$currPos = s0;
                                    s0 = peg$FAILED;
                                }
                            }
                        }
                    }
                }
            }
        }
        peg$resultsCache[key] = { nextPos: peg$currPos, result: s0 };
        return s0;
    }
    function peg$parseArrayOp() {
        var s0, s1, s2, s3;
        var key = peg$currPos * 34 + 20;
        var cached = peg$resultsCache[key];
        if (cached) {
            peg$currPos = cached.nextPos;
            return cached.result;
        }
        s0 = peg$currPos;
        if (input.charCodeAt(peg$currPos) === 91) {
            s1 = peg$c120;
            peg$currPos++;
        }
        else {
            s1 = peg$FAILED;
            if (peg$silentFails === 0) {
                peg$fail(peg$c121);
            }
        }
        if (s1 !== peg$FAILED) {
            s2 = peg$parseSequence();
            if (s2 !== peg$FAILED) {
                if (input.charCodeAt(peg$currPos) === 93) {
                    s3 = peg$c122;
                    peg$currPos++;
                }
                else {
                    s3 = peg$FAILED;
                    if (peg$silentFails === 0) {
                        peg$fail(peg$c123);
                    }
                }
                if (s3 !== peg$FAILED) {
                    peg$savedPos = s0;
                    s1 = peg$c124(s2);
                    s0 = s1;
                }
                else {
                    peg$currPos = s0;
                    s0 = peg$FAILED;
                }
            }
            else {
                peg$currPos = s0;
                s0 = peg$FAILED;
            }
        }
        else {
            peg$currPos = s0;
            s0 = peg$FAILED;
        }
        peg$resultsCache[key] = { nextPos: peg$currPos, result: s0 };
        return s0;
    }
    function peg$parseSequence() {
        var s0, s1, s2, s3, s4, s5, s6, s7;
        var key = peg$currPos * 34 + 21;
        var cached = peg$resultsCache[key];
        if (cached) {
            peg$currPos = cached.nextPos;
            return cached.result;
        }
        s0 = peg$currPos;
        s1 = peg$parseExpression();
        if (s1 === peg$FAILED) {
            s1 = null;
        }
        if (s1 !== peg$FAILED) {
            s2 = [];
            s3 = peg$currPos;
            s4 = peg$parse_();
            if (s4 !== peg$FAILED) {
                if (input.charCodeAt(peg$currPos) === 44) {
                    s5 = peg$c125;
                    peg$currPos++;
                }
                else {
                    s5 = peg$FAILED;
                    if (peg$silentFails === 0) {
                        peg$fail(peg$c126);
                    }
                }
                if (s5 !== peg$FAILED) {
                    s6 = peg$parse_();
                    if (s6 !== peg$FAILED) {
                        s7 = peg$parseExpression();
                        if (s7 !== peg$FAILED) {
                            s4 = [s4, s5, s6, s7];
                            s3 = s4;
                        }
                        else {
                            peg$currPos = s3;
                            s3 = peg$FAILED;
                        }
                    }
                    else {
                        peg$currPos = s3;
                        s3 = peg$FAILED;
                    }
                }
                else {
                    peg$currPos = s3;
                    s3 = peg$FAILED;
                }
            }
            else {
                peg$currPos = s3;
                s3 = peg$FAILED;
            }
            while (s3 !== peg$FAILED) {
                s2.push(s3);
                s3 = peg$currPos;
                s4 = peg$parse_();
                if (s4 !== peg$FAILED) {
                    if (input.charCodeAt(peg$currPos) === 44) {
                        s5 = peg$c125;
                        peg$currPos++;
                    }
                    else {
                        s5 = peg$FAILED;
                        if (peg$silentFails === 0) {
                            peg$fail(peg$c126);
                        }
                    }
                    if (s5 !== peg$FAILED) {
                        s6 = peg$parse_();
                        if (s6 !== peg$FAILED) {
                            s7 = peg$parseExpression();
                            if (s7 !== peg$FAILED) {
                                s4 = [s4, s5, s6, s7];
                                s3 = s4;
                            }
                            else {
                                peg$currPos = s3;
                                s3 = peg$FAILED;
                            }
                        }
                        else {
                            peg$currPos = s3;
                            s3 = peg$FAILED;
                        }
                    }
                    else {
                        peg$currPos = s3;
                        s3 = peg$FAILED;
                    }
                }
                else {
                    peg$currPos = s3;
                    s3 = peg$FAILED;
                }
            }
            if (s2 !== peg$FAILED) {
                peg$savedPos = s0;
                s1 = peg$c127(s1, s2);
                s0 = s1;
            }
            else {
                peg$currPos = s0;
                s0 = peg$FAILED;
            }
        }
        else {
            peg$currPos = s0;
            s0 = peg$FAILED;
        }
        peg$resultsCache[key] = { nextPos: peg$currPos, result: s0 };
        return s0;
    }
    function peg$parseLogicValue() {
        var s0, s1;
        var key = peg$currPos * 34 + 22;
        var cached = peg$resultsCache[key];
        if (cached) {
            peg$currPos = cached.nextPos;
            return cached.result;
        }
        s0 = peg$currPos;
        if (input.substr(peg$currPos, 4).toLowerCase() === peg$c128) {
            s1 = input.substr(peg$currPos, 4);
            peg$currPos += 4;
        }
        else {
            s1 = peg$FAILED;
            if (peg$silentFails === 0) {
                peg$fail(peg$c129);
            }
        }
        if (s1 !== peg$FAILED) {
            peg$savedPos = s0;
            s1 = peg$c130();
        }
        s0 = s1;
        if (s0 === peg$FAILED) {
            s0 = peg$currPos;
            if (input.substr(peg$currPos, 5).toLowerCase() === peg$c131) {
                s1 = input.substr(peg$currPos, 5);
                peg$currPos += 5;
            }
            else {
                s1 = peg$FAILED;
                if (peg$silentFails === 0) {
                    peg$fail(peg$c132);
                }
            }
            if (s1 !== peg$FAILED) {
                peg$savedPos = s0;
                s1 = peg$c133();
            }
            s0 = s1;
        }
        peg$resultsCache[key] = { nextPos: peg$currPos, result: s0 };
        return s0;
    }
    function peg$parseArithmeticValue() {
        var s0, s1, s2;
        var key = peg$currPos * 34 + 23;
        var cached = peg$resultsCache[key];
        if (cached) {
            peg$currPos = cached.nextPos;
            return cached.result;
        }
        s0 = peg$currPos;
        if (input.substr(peg$currPos, 2) === peg$c134) {
            s1 = peg$c134;
            peg$currPos += 2;
        }
        else {
            s1 = peg$FAILED;
            if (peg$silentFails === 0) {
                peg$fail(peg$c135);
            }
        }
        if (s1 !== peg$FAILED) {
            s2 = peg$parseDigits();
            if (s2 !== peg$FAILED) {
                peg$savedPos = s0;
                s1 = peg$c136();
                s0 = s1;
            }
            else {
                peg$currPos = s0;
                s0 = peg$FAILED;
            }
        }
        else {
            peg$currPos = s0;
            s0 = peg$FAILED;
        }
        if (s0 === peg$FAILED) {
            s0 = peg$currPos;
            if (peg$c137.test(input.charAt(peg$currPos))) {
                s1 = input.charAt(peg$currPos);
                peg$currPos++;
            }
            else {
                s1 = peg$FAILED;
                if (peg$silentFails === 0) {
                    peg$fail(peg$c138);
                }
            }
            if (s1 === peg$FAILED) {
                s1 = null;
            }
            if (s1 !== peg$FAILED) {
                s2 = peg$parseNumber();
                if (s2 !== peg$FAILED) {
                    peg$savedPos = s0;
                    s1 = peg$c139(s1, s2);
                    s0 = s1;
                }
                else {
                    peg$currPos = s0;
                    s0 = peg$FAILED;
                }
            }
            else {
                peg$currPos = s0;
                s0 = peg$FAILED;
            }
        }
        peg$resultsCache[key] = { nextPos: peg$currPos, result: s0 };
        return s0;
    }
    function peg$parseNumber() {
        var s0, s1, s2, s3;
        var key = peg$currPos * 34 + 24;
        var cached = peg$resultsCache[key];
        if (cached) {
            peg$currPos = cached.nextPos;
            return cached.result;
        }
        s0 = peg$currPos;
        s1 = peg$parseDigits();
        if (s1 !== peg$FAILED) {
            if (input.charCodeAt(peg$currPos) === 46) {
                s2 = peg$c140;
                peg$currPos++;
            }
            else {
                s2 = peg$FAILED;
                if (peg$silentFails === 0) {
                    peg$fail(peg$c141);
                }
            }
            if (s2 !== peg$FAILED) {
                s3 = peg$parseDigits();
                if (s3 !== peg$FAILED) {
                    peg$savedPos = s0;
                    s1 = peg$c142();
                    s0 = s1;
                }
                else {
                    peg$currPos = s0;
                    s0 = peg$FAILED;
                }
            }
            else {
                peg$currPos = s0;
                s0 = peg$FAILED;
            }
        }
        else {
            peg$currPos = s0;
            s0 = peg$FAILED;
        }
        if (s0 === peg$FAILED) {
            s0 = peg$currPos;
            s1 = peg$parseNonZeroDigits();
            if (s1 !== peg$FAILED) {
                s2 = peg$parseDigits();
                if (s2 === peg$FAILED) {
                    s2 = null;
                }
                if (s2 !== peg$FAILED) {
                    peg$savedPos = s0;
                    s1 = peg$c143();
                    s0 = s1;
                }
                else {
                    peg$currPos = s0;
                    s0 = peg$FAILED;
                }
            }
            else {
                peg$currPos = s0;
                s0 = peg$FAILED;
            }
            if (s0 === peg$FAILED) {
                s0 = peg$currPos;
                if (input.charCodeAt(peg$currPos) === 48) {
                    s1 = peg$c144;
                    peg$currPos++;
                }
                else {
                    s1 = peg$FAILED;
                    if (peg$silentFails === 0) {
                        peg$fail(peg$c145);
                    }
                }
                if (s1 !== peg$FAILED) {
                    peg$savedPos = s0;
                    s1 = peg$c146();
                }
                s0 = s1;
            }
        }
        peg$resultsCache[key] = { nextPos: peg$currPos, result: s0 };
        return s0;
    }
    function peg$parseValueInput() {
        var s0, s1, s2;
        var key = peg$currPos * 34 + 25;
        var cached = peg$resultsCache[key];
        if (cached) {
            peg$currPos = cached.nextPos;
            return cached.result;
        }
        s0 = peg$currPos;
        s1 = [];
        s2 = peg$parseValueCharacters();
        if (s2 !== peg$FAILED) {
            while (s2 !== peg$FAILED) {
                s1.push(s2);
                s2 = peg$parseValueCharacters();
            }
        }
        else {
            s1 = peg$FAILED;
        }
        if (s1 !== peg$FAILED) {
            peg$savedPos = s0;
            s1 = peg$c147(s1);
        }
        s0 = s1;
        peg$resultsCache[key] = { nextPos: peg$currPos, result: s0 };
        return s0;
    }
    function peg$parseAnyInput() {
        var s0, s1, s2;
        var key = peg$currPos * 34 + 26;
        var cached = peg$resultsCache[key];
        if (cached) {
            peg$currPos = cached.nextPos;
            return cached.result;
        }
        s0 = peg$currPos;
        s1 = [];
        s2 = peg$parseAnyCharacters();
        if (s2 !== peg$FAILED) {
            while (s2 !== peg$FAILED) {
                s1.push(s2);
                s2 = peg$parseAnyCharacters();
            }
        }
        else {
            s1 = peg$FAILED;
        }
        if (s1 !== peg$FAILED) {
            peg$savedPos = s0;
            s1 = peg$c147(s1);
        }
        s0 = s1;
        peg$resultsCache[key] = { nextPos: peg$currPos, result: s0 };
        return s0;
    }
    function peg$parseAnyCharacters() {
        var s0, s1;
        var key = peg$currPos * 34 + 27;
        var cached = peg$resultsCache[key];
        if (cached) {
            peg$currPos = cached.nextPos;
            return cached.result;
        }
        s0 = peg$currPos;
        if (input.substr(peg$currPos, 2) === peg$c148) {
            s1 = peg$c148;
            peg$currPos += 2;
        }
        else {
            s1 = peg$FAILED;
            if (peg$silentFails === 0) {
                peg$fail(peg$c149);
            }
        }
        if (s1 !== peg$FAILED) {
            peg$savedPos = s0;
            s1 = peg$c150();
        }
        s0 = s1;
        if (s0 === peg$FAILED) {
            s0 = peg$currPos;
            if (input.substr(peg$currPos, 2) === peg$c151) {
                s1 = peg$c151;
                peg$currPos += 2;
            }
            else {
                s1 = peg$FAILED;
                if (peg$silentFails === 0) {
                    peg$fail(peg$c152);
                }
            }
            if (s1 !== peg$FAILED) {
                peg$savedPos = s0;
                s1 = peg$c153();
            }
            s0 = s1;
            if (s0 === peg$FAILED) {
                s0 = peg$currPos;
                if (peg$c154.test(input.charAt(peg$currPos))) {
                    s1 = input.charAt(peg$currPos);
                    peg$currPos++;
                }
                else {
                    s1 = peg$FAILED;
                    if (peg$silentFails === 0) {
                        peg$fail(peg$c155);
                    }
                }
                if (s1 !== peg$FAILED) {
                    peg$savedPos = s0;
                    s1 = peg$c156();
                }
                s0 = s1;
            }
        }
        peg$resultsCache[key] = { nextPos: peg$currPos, result: s0 };
        return s0;
    }
    function peg$parseValueCharacters() {
        var s0, s1;
        var key = peg$currPos * 34 + 28;
        var cached = peg$resultsCache[key];
        if (cached) {
            peg$currPos = cached.nextPos;
            return cached.result;
        }
        s0 = peg$currPos;
        if (peg$c157.test(input.charAt(peg$currPos))) {
            s1 = input.charAt(peg$currPos);
            peg$currPos++;
        }
        else {
            s1 = peg$FAILED;
            if (peg$silentFails === 0) {
                peg$fail(peg$c158);
            }
        }
        if (s1 !== peg$FAILED) {
            peg$savedPos = s0;
            s1 = peg$c156();
        }
        s0 = s1;
        peg$resultsCache[key] = { nextPos: peg$currPos, result: s0 };
        return s0;
    }
    function peg$parseLettersAndDigits() {
        var s0, s1, s2, s3, s4, s5, s6;
        var key = peg$currPos * 34 + 29;
        var cached = peg$resultsCache[key];
        if (cached) {
            peg$currPos = cached.nextPos;
            return cached.result;
        }
        s0 = peg$currPos;
        s1 = peg$parseLetters();
        if (s1 !== peg$FAILED) {
            s2 = [];
            s3 = peg$currPos;
            s4 = peg$parseDigits();
            if (s4 !== peg$FAILED) {
                s5 = [];
                s6 = peg$parseLetters();
                while (s6 !== peg$FAILED) {
                    s5.push(s6);
                    s6 = peg$parseLetters();
                }
                if (s5 !== peg$FAILED) {
                    s4 = [s4, s5];
                    s3 = s4;
                }
                else {
                    peg$currPos = s3;
                    s3 = peg$FAILED;
                }
            }
            else {
                peg$currPos = s3;
                s3 = peg$FAILED;
            }
            while (s3 !== peg$FAILED) {
                s2.push(s3);
                s3 = peg$currPos;
                s4 = peg$parseDigits();
                if (s4 !== peg$FAILED) {
                    s5 = [];
                    s6 = peg$parseLetters();
                    while (s6 !== peg$FAILED) {
                        s5.push(s6);
                        s6 = peg$parseLetters();
                    }
                    if (s5 !== peg$FAILED) {
                        s4 = [s4, s5];
                        s3 = s4;
                    }
                    else {
                        peg$currPos = s3;
                        s3 = peg$FAILED;
                    }
                }
                else {
                    peg$currPos = s3;
                    s3 = peg$FAILED;
                }
            }
            if (s2 !== peg$FAILED) {
                peg$savedPos = s0;
                s1 = peg$c156();
                s0 = s1;
            }
            else {
                peg$currPos = s0;
                s0 = peg$FAILED;
            }
        }
        else {
            peg$currPos = s0;
            s0 = peg$FAILED;
        }
        peg$resultsCache[key] = { nextPos: peg$currPos, result: s0 };
        return s0;
    }
    function peg$parseDigits() {
        var s0, s1;
        var key = peg$currPos * 34 + 30;
        var cached = peg$resultsCache[key];
        if (cached) {
            peg$currPos = cached.nextPos;
            return cached.result;
        }
        s0 = [];
        if (peg$c159.test(input.charAt(peg$currPos))) {
            s1 = input.charAt(peg$currPos);
            peg$currPos++;
        }
        else {
            s1 = peg$FAILED;
            if (peg$silentFails === 0) {
                peg$fail(peg$c160);
            }
        }
        if (s1 !== peg$FAILED) {
            while (s1 !== peg$FAILED) {
                s0.push(s1);
                if (peg$c159.test(input.charAt(peg$currPos))) {
                    s1 = input.charAt(peg$currPos);
                    peg$currPos++;
                }
                else {
                    s1 = peg$FAILED;
                    if (peg$silentFails === 0) {
                        peg$fail(peg$c160);
                    }
                }
            }
        }
        else {
            s0 = peg$FAILED;
        }
        peg$resultsCache[key] = { nextPos: peg$currPos, result: s0 };
        return s0;
    }
    function peg$parseNonZeroDigits() {
        var s0, s1;
        var key = peg$currPos * 34 + 31;
        var cached = peg$resultsCache[key];
        if (cached) {
            peg$currPos = cached.nextPos;
            return cached.result;
        }
        s0 = [];
        if (peg$c161.test(input.charAt(peg$currPos))) {
            s1 = input.charAt(peg$currPos);
            peg$currPos++;
        }
        else {
            s1 = peg$FAILED;
            if (peg$silentFails === 0) {
                peg$fail(peg$c162);
            }
        }
        if (s1 !== peg$FAILED) {
            while (s1 !== peg$FAILED) {
                s0.push(s1);
                if (peg$c161.test(input.charAt(peg$currPos))) {
                    s1 = input.charAt(peg$currPos);
                    peg$currPos++;
                }
                else {
                    s1 = peg$FAILED;
                    if (peg$silentFails === 0) {
                        peg$fail(peg$c162);
                    }
                }
            }
        }
        else {
            s0 = peg$FAILED;
        }
        peg$resultsCache[key] = { nextPos: peg$currPos, result: s0 };
        return s0;
    }
    function peg$parseLetters() {
        var s0, s1;
        var key = peg$currPos * 34 + 32;
        var cached = peg$resultsCache[key];
        if (cached) {
            peg$currPos = cached.nextPos;
            return cached.result;
        }
        s0 = [];
        if (peg$c163.test(input.charAt(peg$currPos))) {
            s1 = input.charAt(peg$currPos);
            peg$currPos++;
        }
        else {
            s1 = peg$FAILED;
            if (peg$silentFails === 0) {
                peg$fail(peg$c164);
            }
        }
        if (s1 !== peg$FAILED) {
            while (s1 !== peg$FAILED) {
                s0.push(s1);
                if (peg$c163.test(input.charAt(peg$currPos))) {
                    s1 = input.charAt(peg$currPos);
                    peg$currPos++;
                }
                else {
                    s1 = peg$FAILED;
                    if (peg$silentFails === 0) {
                        peg$fail(peg$c164);
                    }
                }
            }
        }
        else {
            s0 = peg$FAILED;
        }
        peg$resultsCache[key] = { nextPos: peg$currPos, result: s0 };
        return s0;
    }
    function peg$parse_() {
        var s0, s1;
        var key = peg$currPos * 34 + 33;
        var cached = peg$resultsCache[key];
        if (cached) {
            peg$currPos = cached.nextPos;
            return cached.result;
        }
        peg$silentFails++;
        s0 = [];
        if (peg$c166.test(input.charAt(peg$currPos))) {
            s1 = input.charAt(peg$currPos);
            peg$currPos++;
        }
        else {
            s1 = peg$FAILED;
            if (peg$silentFails === 0) {
                peg$fail(peg$c167);
            }
        }
        while (s1 !== peg$FAILED) {
            s0.push(s1);
            if (peg$c166.test(input.charAt(peg$currPos))) {
                s1 = input.charAt(peg$currPos);
                peg$currPos++;
            }
            else {
                s1 = peg$FAILED;
                if (peg$silentFails === 0) {
                    peg$fail(peg$c167);
                }
            }
        }
        peg$silentFails--;
        if (s0 === peg$FAILED) {
            s1 = peg$FAILED;
            if (peg$silentFails === 0) {
                peg$fail(peg$c165);
            }
        }
        peg$resultsCache[key] = { nextPos: peg$currPos, result: s0 };
        return s0;
    }
    function buildBinaryOperand(head, tail, isArithmeticOp) {
        if (isArithmeticOp === void 0) { isArithmeticOp = false; }
        return tail.reduce(function (result, elements) {
            return new _expressions__WEBPACK_IMPORTED_MODULE_0__["BinaryOperand"](elements[1], result, elements[3], isArithmeticOp);
        }, head);
    }
    function flattenArray(array) {
        return [].concat.apply([], array);
    }
    peg$result = peg$startRuleFunction();
    if (peg$result !== peg$FAILED && peg$currPos === input.length) {
        return peg$result;
    }
    else {
        if (peg$result !== peg$FAILED && peg$currPos < input.length) {
            peg$fail(peg$endExpectation());
        }
        throw peg$buildStructuredError(peg$maxFailExpected, peg$maxFailPos < input.length ? input.charAt(peg$maxFailPos) : null, peg$maxFailPos < input.length
            ? peg$computeLocation(peg$maxFailPos, peg$maxFailPos + 1)
            : peg$computeLocation(peg$maxFailPos, peg$maxFailPos));
    }
}
var parse = peg$parse;


/***/ }),

/***/ "./src/expressions/expressions.ts":
/*!****************************************!*\
  !*** ./src/expressions/expressions.ts ***!
  \****************************************/
/*! exports provided: Operand, BinaryOperand, UnaryOperand, ArrayOperand, Const, Variable, FunctionOperand, OperandMaker */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "Operand", function() { return Operand; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "BinaryOperand", function() { return BinaryOperand; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "UnaryOperand", function() { return UnaryOperand; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "ArrayOperand", function() { return ArrayOperand; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "Const", function() { return Const; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "Variable", function() { return Variable; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "FunctionOperand", function() { return FunctionOperand; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "OperandMaker", function() { return OperandMaker; });
/* harmony import */ var _helpers__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ../helpers */ "./src/helpers.ts");
/* harmony import */ var _functionsfactory__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ../functionsfactory */ "./src/functionsfactory.ts");
/* harmony import */ var _conditionProcessValue__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ../conditionProcessValue */ "./src/conditionProcessValue.ts");
var __extends = (undefined && undefined.__extends) || (function () {
    var extendStatics = function (d, b) {
        extendStatics = Object.setPrototypeOf ||
            ({ __proto__: [] } instanceof Array && function (d, b) { d.__proto__ = b; }) ||
            function (d, b) { for (var p in b) if (Object.prototype.hasOwnProperty.call(b, p)) d[p] = b[p]; };
        return extendStatics(d, b);
    };
    return function (d, b) {
        if (typeof b !== "function" && b !== null)
            throw new TypeError("Class extends value " + String(b) + " is not a constructor or null");
        extendStatics(d, b);
        function __() { this.constructor = d; }
        d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
    };
})();



var Operand = /** @class */ (function () {
    function Operand() {
    }
    Operand.prototype.toString = function (func) {
        if (func === void 0) { func = undefined; }
        return "";
    };
    Operand.prototype.hasFunction = function () {
        return false;
    };
    Operand.prototype.hasAsyncFunction = function () {
        return false;
    };
    Operand.prototype.addToAsyncList = function (list) { };
    Operand.prototype.isEqual = function (op) {
        return !!op && op.getType() === this.getType() && this.isContentEqual(op);
    };
    Operand.prototype.areOperatorsEquals = function (op1, op2) {
        return !op1 && !op2 || !!op1 && op1.isEqual(op2);
    };
    return Operand;
}());

var BinaryOperand = /** @class */ (function (_super) {
    __extends(BinaryOperand, _super);
    function BinaryOperand(operatorName, left, right, isArithmeticOp) {
        if (left === void 0) { left = null; }
        if (right === void 0) { right = null; }
        if (isArithmeticOp === void 0) { isArithmeticOp = false; }
        var _this = _super.call(this) || this;
        _this.operatorName = operatorName;
        _this.left = left;
        _this.right = right;
        _this.isArithmeticValue = isArithmeticOp;
        if (isArithmeticOp) {
            _this.consumer = OperandMaker.binaryFunctions["arithmeticOp"](operatorName);
        }
        else {
            _this.consumer = OperandMaker.binaryFunctions[operatorName];
        }
        if (_this.consumer == null) {
            OperandMaker.throwInvalidOperatorError(operatorName);
        }
        return _this;
    }
    BinaryOperand.prototype.getType = function () {
        return "binary";
    };
    Object.defineProperty(BinaryOperand.prototype, "isArithmetic", {
        get: function () {
            return this.isArithmeticValue;
        },
        enumerable: false,
        configurable: true
    });
    Object.defineProperty(BinaryOperand.prototype, "isConjunction", {
        get: function () {
            return this.operatorName == "or" || this.operatorName == "and";
        },
        enumerable: false,
        configurable: true
    });
    Object.defineProperty(BinaryOperand.prototype, "conjunction", {
        get: function () {
            return this.isConjunction ? this.operatorName : "";
        },
        enumerable: false,
        configurable: true
    });
    Object.defineProperty(BinaryOperand.prototype, "operator", {
        get: function () {
            return this.operatorName;
        },
        enumerable: false,
        configurable: true
    });
    Object.defineProperty(BinaryOperand.prototype, "leftOperand", {
        get: function () {
            return this.left;
        },
        enumerable: false,
        configurable: true
    });
    Object.defineProperty(BinaryOperand.prototype, "rightOperand", {
        get: function () {
            return this.right;
        },
        enumerable: false,
        configurable: true
    });
    BinaryOperand.prototype.isContentEqual = function (op) {
        var bOp = op;
        return bOp.operator === this.operator &&
            this.areOperatorsEquals(this.left, bOp.left) &&
            this.areOperatorsEquals(this.right, bOp.right);
    };
    BinaryOperand.prototype.evaluateParam = function (x, processValue) {
        return x == null ? null : x.evaluate(processValue);
    };
    BinaryOperand.prototype.evaluate = function (processValue) {
        return this.consumer.call(this, this.evaluateParam(this.left, processValue), this.evaluateParam(this.right, processValue));
    };
    BinaryOperand.prototype.toString = function (func) {
        if (func === void 0) { func = undefined; }
        if (!!func) {
            var res = func(this);
            if (!!res)
                return res;
        }
        return ("(" +
            OperandMaker.safeToString(this.left, func) +
            " " +
            OperandMaker.operatorToString(this.operatorName) +
            " " +
            OperandMaker.safeToString(this.right, func) +
            ")");
    };
    BinaryOperand.prototype.setVariables = function (variables) {
        if (this.left != null)
            this.left.setVariables(variables);
        if (this.right != null)
            this.right.setVariables(variables);
    };
    BinaryOperand.prototype.hasFunction = function () {
        return ((!!this.left && this.left.hasFunction()) ||
            (!!this.right && this.right.hasFunction()));
    };
    BinaryOperand.prototype.hasAsyncFunction = function () {
        return ((!!this.left && this.left.hasAsyncFunction()) ||
            (!!this.right && this.right.hasAsyncFunction()));
    };
    BinaryOperand.prototype.addToAsyncList = function (list) {
        if (!!this.left)
            this.left.addToAsyncList(list);
        if (!!this.right)
            this.right.addToAsyncList(list);
    };
    return BinaryOperand;
}(Operand));

var UnaryOperand = /** @class */ (function (_super) {
    __extends(UnaryOperand, _super);
    function UnaryOperand(expressionValue, operatorName) {
        var _this = _super.call(this) || this;
        _this.expressionValue = expressionValue;
        _this.operatorName = operatorName;
        _this.consumer = OperandMaker.unaryFunctions[operatorName];
        if (_this.consumer == null) {
            OperandMaker.throwInvalidOperatorError(operatorName);
        }
        return _this;
    }
    Object.defineProperty(UnaryOperand.prototype, "operator", {
        get: function () {
            return this.operatorName;
        },
        enumerable: false,
        configurable: true
    });
    Object.defineProperty(UnaryOperand.prototype, "expression", {
        get: function () {
            return this.expressionValue;
        },
        enumerable: false,
        configurable: true
    });
    UnaryOperand.prototype.getType = function () {
        return "unary";
    };
    UnaryOperand.prototype.toString = function (func) {
        if (func === void 0) { func = undefined; }
        if (!!func) {
            var res = func(this);
            if (!!res)
                return res;
        }
        return (OperandMaker.operatorToString(this.operatorName) +
            " " +
            this.expression.toString(func));
    };
    UnaryOperand.prototype.isContentEqual = function (op) {
        var uOp = op;
        return uOp.operator == this.operator && this.areOperatorsEquals(this.expression, uOp.expression);
    };
    UnaryOperand.prototype.evaluate = function (processValue) {
        var value = this.expression.evaluate(processValue);
        return this.consumer.call(this, value);
    };
    UnaryOperand.prototype.setVariables = function (variables) {
        this.expression.setVariables(variables);
    };
    return UnaryOperand;
}(Operand));

var ArrayOperand = /** @class */ (function (_super) {
    __extends(ArrayOperand, _super);
    function ArrayOperand(values) {
        var _this = _super.call(this) || this;
        _this.values = values;
        return _this;
    }
    ArrayOperand.prototype.getType = function () {
        return "array";
    };
    ArrayOperand.prototype.toString = function (func) {
        if (func === void 0) { func = undefined; }
        if (!!func) {
            var res = func(this);
            if (!!res)
                return res;
        }
        return ("[" +
            this.values
                .map(function (el) {
                return el.toString(func);
            })
                .join(", ") +
            "]");
    };
    ArrayOperand.prototype.evaluate = function (processValue) {
        return this.values.map(function (el) {
            return el.evaluate(processValue);
        });
    };
    ArrayOperand.prototype.setVariables = function (variables) {
        this.values.forEach(function (el) {
            el.setVariables(variables);
        });
    };
    ArrayOperand.prototype.hasFunction = function () {
        return this.values.some(function (operand) { return operand.hasFunction(); });
    };
    ArrayOperand.prototype.hasAsyncFunction = function () {
        return this.values.some(function (operand) { return operand.hasAsyncFunction(); });
    };
    ArrayOperand.prototype.addToAsyncList = function (list) {
        this.values.forEach(function (operand) { return operand.addToAsyncList(list); });
    };
    ArrayOperand.prototype.isContentEqual = function (op) {
        var aOp = op;
        if (aOp.values.length !== this.values.length)
            return false;
        for (var i = 0; i < this.values.length; i++) {
            if (!aOp.values[i].isEqual(this.values[i]))
                return false;
        }
        return true;
    };
    return ArrayOperand;
}(Operand));

var Const = /** @class */ (function (_super) {
    __extends(Const, _super);
    function Const(value) {
        var _this = _super.call(this) || this;
        _this.value = value;
        return _this;
    }
    Const.prototype.getType = function () {
        return "const";
    };
    Const.prototype.toString = function (func) {
        if (func === void 0) { func = undefined; }
        if (!!func) {
            var res = func(this);
            if (!!res)
                return res;
        }
        return this.value.toString();
    };
    Object.defineProperty(Const.prototype, "correctValue", {
        get: function () {
            return this.getCorrectValue(this.value);
        },
        enumerable: false,
        configurable: true
    });
    Const.prototype.evaluate = function () {
        return this.getCorrectValue(this.value);
    };
    Const.prototype.setVariables = function (variables) { };
    Const.prototype.getCorrectValue = function (value) {
        if (!value || typeof value != "string")
            return value;
        if (this.isBooleanValue(value))
            return value.toLowerCase() === "true";
        if (value.length > 1 &&
            this.isQuote(value[0]) &&
            this.isQuote(value[value.length - 1]))
            return value.substr(1, value.length - 2);
        if (OperandMaker.isNumeric(value)) {
            if (value.indexOf("0x") == 0)
                return parseInt(value);
            if (value.length > 1 && value[0] == "0")
                return value;
            return parseFloat(value);
        }
        return value;
    };
    Const.prototype.isContentEqual = function (op) {
        var cOp = op;
        return cOp.value == this.value;
    };
    Const.prototype.isQuote = function (ch) {
        return ch == "'" || ch == '"';
    };
    Const.prototype.isBooleanValue = function (value) {
        return (value &&
            (value.toLowerCase() === "true" || value.toLowerCase() === "false"));
    };
    return Const;
}(Operand));

var Variable = /** @class */ (function (_super) {
    __extends(Variable, _super);
    function Variable(variableName) {
        var _this = _super.call(this, variableName) || this;
        _this.variableName = variableName;
        _this.valueInfo = {};
        _this.useValueAsItIs = false;
        if (!!_this.variableName &&
            _this.variableName.length > 1 &&
            _this.variableName[0] === Variable.DisableConversionChar) {
            _this.variableName = _this.variableName.substr(1);
            _this.useValueAsItIs = true;
        }
        return _this;
    }
    Variable.prototype.getType = function () {
        return "variable";
    };
    Variable.prototype.toString = function (func) {
        if (func === void 0) { func = undefined; }
        if (!!func) {
            var res = func(this);
            if (!!res)
                return res;
        }
        var prefix = this.useValueAsItIs ? Variable.DisableConversionChar : "";
        return "{" + prefix + this.variableName + "}";
    };
    Object.defineProperty(Variable.prototype, "variable", {
        get: function () {
            return this.variableName;
        },
        enumerable: false,
        configurable: true
    });
    Variable.prototype.evaluate = function (processValue) {
        this.valueInfo.name = this.variableName;
        processValue.getValueInfo(this.valueInfo);
        return this.valueInfo.hasValue
            ? this.getCorrectValue(this.valueInfo.value)
            : null;
    };
    Variable.prototype.setVariables = function (variables) {
        variables.push(this.variableName);
    };
    Variable.prototype.getCorrectValue = function (value) {
        if (this.useValueAsItIs)
            return value;
        return _super.prototype.getCorrectValue.call(this, value);
    };
    Variable.prototype.isContentEqual = function (op) {
        var vOp = op;
        return vOp.variable == this.variable;
    };
    Variable.DisableConversionChar = "#";
    return Variable;
}(Const));

var FunctionOperand = /** @class */ (function (_super) {
    __extends(FunctionOperand, _super);
    function FunctionOperand(originalValue, parameters) {
        var _this = _super.call(this) || this;
        _this.originalValue = originalValue;
        _this.parameters = parameters;
        _this.isReadyValue = false;
        if (Array.isArray(parameters) && parameters.length === 0) {
            _this.parameters = new ArrayOperand([]);
        }
        return _this;
    }
    FunctionOperand.prototype.getType = function () {
        return "function";
    };
    FunctionOperand.prototype.evaluateAsync = function (processValue) {
        var _this = this;
        this.isReadyValue = false;
        var asyncProcessValue = new _conditionProcessValue__WEBPACK_IMPORTED_MODULE_2__["ProcessValue"]();
        asyncProcessValue.values = _helpers__WEBPACK_IMPORTED_MODULE_0__["Helpers"].createCopy(processValue.values);
        asyncProcessValue.properties = _helpers__WEBPACK_IMPORTED_MODULE_0__["Helpers"].createCopy(processValue.properties);
        asyncProcessValue.properties.returnResult = function (result) {
            _this.asynResult = result;
            _this.isReadyValue = true;
            _this.onAsyncReady();
        };
        this.evaluateCore(asyncProcessValue);
    };
    FunctionOperand.prototype.evaluate = function (processValue) {
        if (this.isReady)
            return this.asynResult;
        return this.evaluateCore(processValue);
    };
    FunctionOperand.prototype.evaluateCore = function (processValue) {
        return _functionsfactory__WEBPACK_IMPORTED_MODULE_1__["FunctionFactory"].Instance.run(this.originalValue, this.parameters.evaluate(processValue), processValue.properties);
    };
    FunctionOperand.prototype.toString = function (func) {
        if (func === void 0) { func = undefined; }
        if (!!func) {
            var res = func(this);
            if (!!res)
                return res;
        }
        return this.originalValue + "(" + this.parameters.toString(func) + ")";
    };
    FunctionOperand.prototype.setVariables = function (variables) {
        this.parameters.setVariables(variables);
    };
    Object.defineProperty(FunctionOperand.prototype, "isReady", {
        get: function () {
            return this.isReadyValue;
        },
        enumerable: false,
        configurable: true
    });
    FunctionOperand.prototype.hasFunction = function () {
        return true;
    };
    FunctionOperand.prototype.hasAsyncFunction = function () {
        return _functionsfactory__WEBPACK_IMPORTED_MODULE_1__["FunctionFactory"].Instance.isAsyncFunction(this.originalValue);
    };
    FunctionOperand.prototype.addToAsyncList = function (list) {
        if (this.hasAsyncFunction()) {
            list.push(this);
        }
    };
    FunctionOperand.prototype.isContentEqual = function (op) {
        var fOp = op;
        return fOp.originalValue == this.originalValue && this.areOperatorsEquals(fOp.parameters, this.parameters);
    };
    return FunctionOperand;
}(Operand));

var OperandMaker = /** @class */ (function () {
    function OperandMaker() {
    }
    OperandMaker.throwInvalidOperatorError = function (op) {
        throw new Error("Invalid operator: '" + op + "'");
    };
    OperandMaker.safeToString = function (operand, func) {
        return operand == null ? "" : operand.toString(func);
    };
    OperandMaker.toOperandString = function (value) {
        if (!!value &&
            !OperandMaker.isNumeric(value) &&
            !OperandMaker.isBooleanValue(value))
            value = "'" + value + "'";
        return value;
    };
    OperandMaker.isSpaceString = function (str) {
        return !!str && !str.replace(" ", "");
    };
    OperandMaker.isNumeric = function (value) {
        if (!!value &&
            (value.indexOf("-") > -1 ||
                value.indexOf("+") > 1 ||
                value.indexOf("*") > -1 ||
                value.indexOf("^") > -1 ||
                value.indexOf("/") > -1 ||
                value.indexOf("%") > -1))
            return false;
        if (OperandMaker.isSpaceString(value))
            return false;
        return _helpers__WEBPACK_IMPORTED_MODULE_0__["Helpers"].isNumber(value);
    };
    OperandMaker.isBooleanValue = function (value) {
        return (!!value &&
            (value.toLowerCase() === "true" || value.toLowerCase() === "false"));
    };
    OperandMaker.countDecimals = function (value) {
        if (_helpers__WEBPACK_IMPORTED_MODULE_0__["Helpers"].isNumber(value) && Math.floor(value) !== value) {
            var strs = value.toString().split(".");
            return strs.length > 1 && strs[1].length || 0;
        }
        return 0;
    };
    OperandMaker.plusMinus = function (a, b, res) {
        var digitsA = OperandMaker.countDecimals(a);
        var digitsB = OperandMaker.countDecimals(b);
        if (digitsA > 0 || digitsB > 0) {
            var digits = Math.max(digitsA, digitsB);
            res = parseFloat(res.toFixed(digits));
        }
        return res;
    };
    OperandMaker.isTwoValueEquals = function (x, y) {
        if (x === "undefined")
            x = undefined;
        if (y === "undefined")
            y = undefined;
        return _helpers__WEBPACK_IMPORTED_MODULE_0__["Helpers"].isTwoValueEquals(x, y, true);
    };
    OperandMaker.operatorToString = function (operatorName) {
        var opStr = OperandMaker.signs[operatorName];
        return opStr == null ? operatorName : opStr;
    };
    OperandMaker.unaryFunctions = {
        empty: function (value) {
            return _helpers__WEBPACK_IMPORTED_MODULE_0__["Helpers"].isValueEmpty(value);
        },
        notempty: function (value) {
            return !OperandMaker.unaryFunctions.empty(value);
        },
        negate: function (value) {
            return !value;
        },
    };
    OperandMaker.binaryFunctions = {
        arithmeticOp: function (operatorName) {
            return function (a, b) {
                if (_helpers__WEBPACK_IMPORTED_MODULE_0__["Helpers"].isValueEmpty(a) && !OperandMaker.isSpaceString(a)) {
                    a = typeof b === "string" ? "" : 0;
                }
                if (_helpers__WEBPACK_IMPORTED_MODULE_0__["Helpers"].isValueEmpty(b) && !OperandMaker.isSpaceString(b)) {
                    b = typeof a === "string" ? "" : 0;
                }
                var consumer = OperandMaker.binaryFunctions[operatorName];
                return consumer == null ? null : consumer.call(this, a, b);
            };
        },
        and: function (a, b) {
            return a && b;
        },
        or: function (a, b) {
            return a || b;
        },
        plus: function (a, b) {
            return _helpers__WEBPACK_IMPORTED_MODULE_0__["Helpers"].correctAfterPlusMinis(a, b, a + b);
        },
        minus: function (a, b) {
            return _helpers__WEBPACK_IMPORTED_MODULE_0__["Helpers"].correctAfterPlusMinis(a, b, a - b);
        },
        mul: function (a, b) {
            return _helpers__WEBPACK_IMPORTED_MODULE_0__["Helpers"].correctAfterMultiple(a, b, a * b);
        },
        div: function (a, b) {
            if (!b)
                return null;
            return a / b;
        },
        mod: function (a, b) {
            if (!b)
                return null;
            return a % b;
        },
        power: function (a, b) {
            return Math.pow(a, b);
        },
        greater: function (left, right) {
            if (left == null || right == null)
                return false;
            return left > right;
        },
        less: function (left, right) {
            if (left == null || right == null)
                return false;
            return left < right;
        },
        greaterorequal: function (left, right) {
            if (OperandMaker.binaryFunctions.equal(left, right))
                return true;
            return OperandMaker.binaryFunctions.greater(left, right);
        },
        lessorequal: function (left, right) {
            if (OperandMaker.binaryFunctions.equal(left, right))
                return true;
            return OperandMaker.binaryFunctions.less(left, right);
        },
        equal: function (left, right) {
            return OperandMaker.isTwoValueEquals(left, right);
        },
        notequal: function (left, right) {
            return !OperandMaker.binaryFunctions.equal(left, right);
        },
        contains: function (left, right) {
            return OperandMaker.binaryFunctions.containsCore(left, right, true);
        },
        notcontains: function (left, right) {
            if (!left && !_helpers__WEBPACK_IMPORTED_MODULE_0__["Helpers"].isValueEmpty(right))
                return true;
            return OperandMaker.binaryFunctions.containsCore(left, right, false);
        },
        anyof: function (left, right) {
            if (_helpers__WEBPACK_IMPORTED_MODULE_0__["Helpers"].isValueEmpty(left) && _helpers__WEBPACK_IMPORTED_MODULE_0__["Helpers"].isValueEmpty(right))
                return true;
            if (_helpers__WEBPACK_IMPORTED_MODULE_0__["Helpers"].isValueEmpty(left) ||
                (!Array.isArray(left) && left.length === 0))
                return false;
            if (_helpers__WEBPACK_IMPORTED_MODULE_0__["Helpers"].isValueEmpty(right))
                return true;
            if (!Array.isArray(left))
                return OperandMaker.binaryFunctions.contains(right, left);
            if (!Array.isArray(right))
                return OperandMaker.binaryFunctions.contains(left, right);
            for (var i = 0; i < right.length; i++) {
                if (OperandMaker.binaryFunctions.contains(left, right[i]))
                    return true;
            }
            return false;
        },
        allof: function (left, right) {
            if (!left && !_helpers__WEBPACK_IMPORTED_MODULE_0__["Helpers"].isValueEmpty(right))
                return false;
            if (!Array.isArray(right))
                return OperandMaker.binaryFunctions.contains(left, right);
            for (var i = 0; i < right.length; i++) {
                if (!OperandMaker.binaryFunctions.contains(left, right[i]))
                    return false;
            }
            return true;
        },
        containsCore: function (left, right, isContains) {
            if (!left && left !== 0 && left !== false)
                return false;
            if (!left.length) {
                left = left.toString();
                if (typeof right === "string" || right instanceof String) {
                    left = left.toUpperCase();
                    right = right.toUpperCase();
                }
            }
            if (typeof left === "string" || left instanceof String) {
                if (!right)
                    return false;
                right = right.toString();
                var found = left.indexOf(right) > -1;
                return isContains ? found : !found;
            }
            var rightArray = Array.isArray(right) ? right : [right];
            for (var rIndex = 0; rIndex < rightArray.length; rIndex++) {
                var i = 0;
                right = rightArray[rIndex];
                for (; i < left.length; i++) {
                    if (OperandMaker.isTwoValueEquals(left[i], right))
                        break;
                }
                if (i == left.length)
                    return !isContains;
            }
            return isContains;
        },
    };
    OperandMaker.signs = {
        less: "<",
        lessorequal: "<=",
        greater: ">",
        greaterorequal: ">=",
        equal: "==",
        notequal: "!=",
        plus: "+",
        minus: "-",
        mul: "*",
        div: "/",
        and: "and",
        or: "or",
        power: "^",
        mod: "%",
        negate: "!",
    };
    return OperandMaker;
}());



/***/ }),

/***/ "./src/flowpanel.ts":
/*!**************************!*\
  !*** ./src/flowpanel.ts ***!
  \**************************/
/*! exports provided: FlowPanelModel */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "FlowPanelModel", function() { return FlowPanelModel; });
/* harmony import */ var _jsonobject__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./jsonobject */ "./src/jsonobject.ts");
/* harmony import */ var _panel__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ./panel */ "./src/panel.ts");
var __extends = (undefined && undefined.__extends) || (function () {
    var extendStatics = function (d, b) {
        extendStatics = Object.setPrototypeOf ||
            ({ __proto__: [] } instanceof Array && function (d, b) { d.__proto__ = b; }) ||
            function (d, b) { for (var p in b) if (Object.prototype.hasOwnProperty.call(b, p)) d[p] = b[p]; };
        return extendStatics(d, b);
    };
    return function (d, b) {
        if (typeof b !== "function" && b !== null)
            throw new TypeError("Class extends value " + String(b) + " is not a constructor or null");
        extendStatics(d, b);
        function __() { this.constructor = d; }
        d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
    };
})();


/**
 * The flow panel object. It is a container with flow layout where you can mix questions with markdown text.
 *
 */
var FlowPanelModel = /** @class */ (function (_super) {
    __extends(FlowPanelModel, _super);
    function FlowPanelModel(name) {
        if (name === void 0) { name = ""; }
        var _this = _super.call(this, name) || this;
        _this.createLocalizableString("content", _this, true);
        var self = _this;
        _this.registerFunctionOnPropertyValueChanged("content", function () {
            self.onContentChanged();
        });
        return _this;
    }
    FlowPanelModel.prototype.getType = function () {
        return "flowpanel";
    };
    FlowPanelModel.prototype.getChildrenLayoutType = function () {
        return "flow";
    };
    FlowPanelModel.prototype.onSurveyLoad = function () {
        _super.prototype.onSurveyLoad.call(this);
        this.onContentChanged();
    };
    Object.defineProperty(FlowPanelModel.prototype, "content", {
        get: function () {
            return this.getLocalizableStringText("content");
        },
        set: function (val) {
            this.setLocalizableStringText("content", val);
        },
        enumerable: false,
        configurable: true
    });
    Object.defineProperty(FlowPanelModel.prototype, "locContent", {
        get: function () {
            return this.getLocalizableString("content");
        },
        enumerable: false,
        configurable: true
    });
    Object.defineProperty(FlowPanelModel.prototype, "html", {
        get: function () {
            return this.getPropertyValue("html", "");
        },
        set: function (val) {
            this.setPropertyValue("html", val);
        },
        enumerable: false,
        configurable: true
    });
    FlowPanelModel.prototype.onContentChanged = function () {
        var html = "";
        if (!!this.onCustomHtmlProducing) {
            html = this.onCustomHtmlProducing();
        }
        else {
            html = this.produceHtml();
        }
        this.html = html;
        if (!!this.contentChangedCallback)
            this.contentChangedCallback();
    };
    FlowPanelModel.prototype.produceHtml = function () {
        var html = [];
        //contentElementNamePrefix
        var regEx = /{(.*?(element:)[^$].*?)}/g;
        var str = this.content;
        var startIndex = 0;
        var res = null;
        while ((res = regEx.exec(str)) !== null) {
            if (res.index > startIndex) {
                html.push(str.substr(startIndex, res.index - startIndex));
                startIndex = res.index;
            }
            var question = this.getQuestionFromText(res[0]);
            if (!!question) {
                html.push(this.getHtmlForQuestion(question));
            }
            else {
                html.push(str.substr(startIndex, res.index + res[0].length - startIndex));
            }
            startIndex = res.index + res[0].length;
        }
        if (startIndex < str.length) {
            html.push(str.substr(startIndex, str.length - startIndex));
        }
        return html.join("").replace(new RegExp("<br>", "g"), "<br/>");
    };
    FlowPanelModel.prototype.getQuestionFromText = function (str) {
        str = str.substr(1, str.length - 2);
        str = str.replace(FlowPanelModel.contentElementNamePrefix, "").trim();
        return this.getQuestionByName(str);
    };
    FlowPanelModel.prototype.getHtmlForQuestion = function (question) {
        if (!!this.onGetHtmlForQuestion)
            return this.onGetHtmlForQuestion(question);
        return "";
    };
    FlowPanelModel.prototype.getQuestionHtmlId = function (question) {
        return this.name + "_" + question.id;
    };
    FlowPanelModel.prototype.onAddElement = function (element, index) {
        _super.prototype.onAddElement.call(this, element, index);
        this.addElementToContent(element);
        element.renderWidth = "";
    };
    FlowPanelModel.prototype.onRemoveElement = function (element) {
        var searchStr = this.getElementContentText(element);
        this.content = this.content.replace(searchStr, "");
        _super.prototype.onRemoveElement.call(this, element);
    };
    FlowPanelModel.prototype.dragDropMoveElement = function (src, target, targetIndex) { };
    FlowPanelModel.prototype.addElementToContent = function (element) {
        if (this.isLoadingFromJson)
            return;
        var text = this.getElementContentText(element);
        if (!this.insertTextAtCursor(text)) {
            this.content = this.content + text;
        }
    };
    FlowPanelModel.prototype.insertTextAtCursor = function (text, prevName) {
        if (prevName === void 0) { prevName = null; }
        if (!this.isDesignMode ||
            typeof document === "undefined" ||
            !window.getSelection)
            return false;
        var sel = window.getSelection();
        if (sel.getRangeAt && sel.rangeCount) {
            var range = sel.getRangeAt(0);
            range.deleteContents();
            range.insertNode(document.createTextNode(text));
            var self = this;
            if (self.getContent) {
                var str = self.getContent(prevName);
                this.content = str;
            }
            return true;
        }
        return false;
    };
    FlowPanelModel.prototype.getElementContentText = function (element) {
        return "{" + FlowPanelModel.contentElementNamePrefix + element.name + "}";
    };
    FlowPanelModel.contentElementNamePrefix = "element:";
    return FlowPanelModel;
}(_panel__WEBPACK_IMPORTED_MODULE_1__["PanelModel"]));

_jsonobject__WEBPACK_IMPORTED_MODULE_0__["Serializer"].addClass("flowpanel", [{ name: "content:html", serializationProperty: "locContent" }], function () {
    return new FlowPanelModel();
}, "panel");


/***/ }),

/***/ "./src/functionsfactory.ts":
/*!*********************************!*\
  !*** ./src/functionsfactory.ts ***!
  \*********************************/
/*! exports provided: FunctionFactory, registerFunction */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "FunctionFactory", function() { return FunctionFactory; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "registerFunction", function() { return registerFunction; });
/* harmony import */ var _helpers__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./helpers */ "./src/helpers.ts");

var FunctionFactory = /** @class */ (function () {
    function FunctionFactory() {
        this.functionHash = {};
        this.isAsyncHash = {};
    }
    FunctionFactory.prototype.register = function (name, func, isAsync) {
        if (isAsync === void 0) { isAsync = false; }
        this.functionHash[name] = func;
        if (isAsync)
            this.isAsyncHash[name] = true;
    };
    FunctionFactory.prototype.unregister = function (name) {
        delete this.functionHash[name];
        delete this.isAsyncHash[name];
    };
    FunctionFactory.prototype.hasFunction = function (name) {
        return !!this.functionHash[name];
    };
    FunctionFactory.prototype.isAsyncFunction = function (name) {
        return !!this.isAsyncHash[name];
    };
    FunctionFactory.prototype.clear = function () {
        this.functionHash = {};
    };
    FunctionFactory.prototype.getAll = function () {
        var result = [];
        for (var key in this.functionHash) {
            result.push(key);
        }
        return result.sort();
    };
    FunctionFactory.prototype.run = function (name, params, properties) {
        if (properties === void 0) { properties = null; }
        var func = this.functionHash[name];
        if (!func)
            return null;
        var classRunner = {
            func: func,
        };
        if (properties) {
            for (var key in properties) {
                classRunner[key] = properties[key];
            }
        }
        return classRunner.func(params);
    };
    FunctionFactory.Instance = new FunctionFactory();
    return FunctionFactory;
}());

var registerFunction = FunctionFactory.Instance.register;
function getParamsAsArray(value, arr) {
    if (value === undefined || value === null)
        return;
    if (Array.isArray(value)) {
        for (var i = 0; i < value.length; i++) {
            getParamsAsArray(value[i], arr);
        }
    }
    else {
        if (_helpers__WEBPACK_IMPORTED_MODULE_0__["Helpers"].isNumber(value)) {
            value = parseFloat(value);
        }
        arr.push(value);
    }
}
function sum(params) {
    var arr = [];
    getParamsAsArray(params, arr);
    var res = 0;
    for (var i = 0; i < arr.length; i++) {
        res = _helpers__WEBPACK_IMPORTED_MODULE_0__["Helpers"].correctAfterPlusMinis(res, arr[i], res + arr[i]);
    }
    return res;
}
FunctionFactory.Instance.register("sum", sum);
function min_max(params, isMin) {
    var arr = [];
    getParamsAsArray(params, arr);
    var res = undefined;
    for (var i = 0; i < arr.length; i++) {
        if (res === undefined) {
            res = arr[i];
        }
        if (isMin) {
            if (res > arr[i])
                res = arr[i];
        }
        else {
            if (res < arr[i])
                res = arr[i];
        }
    }
    return res;
}
function min(params) {
    return min_max(params, true);
}
FunctionFactory.Instance.register("min", min);
function max(params) {
    return min_max(params, false);
}
FunctionFactory.Instance.register("max", max);
function count(params) {
    var arr = [];
    getParamsAsArray(params, arr);
    return arr.length;
}
FunctionFactory.Instance.register("count", count);
function avg(params) {
    var arr = [];
    getParamsAsArray(params, arr);
    var res = sum(params);
    return arr.length > 0 ? res / arr.length : 0;
}
FunctionFactory.Instance.register("avg", avg);
function getInArrayParams(params) {
    if (params.length != 2)
        return null;
    var arr = params[0];
    if (!arr)
        return null;
    if (!Array.isArray(arr) && !Array.isArray(Object.keys(arr)))
        return null;
    var name = params[1];
    if (typeof name !== "string" && !(name instanceof String))
        return null;
    return { data: arr, name: name };
}
function calcInArray(params, func) {
    var v = getInArrayParams(params);
    if (!v)
        return undefined;
    var res = undefined;
    if (Array.isArray(v.data)) {
        for (var i = 0; i < v.data.length; i++) {
            var item = v.data[i];
            if (!!item && item[v.name]) {
                res = func(res, item[v.name]);
            }
        }
    }
    else {
        for (var key in v.data) {
            var item = v.data[key];
            if (!!item && item[v.name]) {
                res = func(res, item[v.name]);
            }
        }
    }
    return res;
}
function sumInArray(params) {
    var res = calcInArray(params, function (res, val) {
        if (res == undefined)
            res = 0;
        if (val == undefined || val == null)
            return res;
        return _helpers__WEBPACK_IMPORTED_MODULE_0__["Helpers"].correctAfterPlusMinis(res, val, res + val);
    });
    return res !== undefined ? res : 0;
}
FunctionFactory.Instance.register("sumInArray", sumInArray);
function minInArray(params) {
    return calcInArray(params, function (res, val) {
        if (res == undefined)
            return val;
        return res < val ? res : val;
    });
}
FunctionFactory.Instance.register("minInArray", minInArray);
function maxInArray(params) {
    return calcInArray(params, function (res, val) {
        if (res == undefined)
            return val;
        return res > val ? res : val;
    });
}
FunctionFactory.Instance.register("maxInArray", maxInArray);
function countInArray(params) {
    var res = calcInArray(params, function (res, val) {
        if (res == undefined)
            res = 0;
        return res + 1;
    });
    return res !== undefined ? res : 0;
}
FunctionFactory.Instance.register("countInArray", countInArray);
function avgInArray(params) {
    var count = countInArray(params);
    if (count == 0)
        return 0;
    return sumInArray(params) / count;
}
FunctionFactory.Instance.register("avgInArray", avgInArray);
function iif(params) {
    if (!params && params.length !== 3)
        return "";
    return params[0] ? params[1] : params[2];
}
FunctionFactory.Instance.register("iif", iif);
function getDate(params) {
    if (!params && params.length < 1)
        return null;
    if (!params[0])
        return null;
    return new Date(params[0]);
}
FunctionFactory.Instance.register("getDate", getDate);
function age(params) {
    if (!params && params.length < 1)
        return null;
    if (!params[0])
        return null;
    var birthDate = new Date(params[0]);
    var today = new Date();
    var age = today.getFullYear() - birthDate.getFullYear();
    var m = today.getMonth() - birthDate.getMonth();
    if (m < 0 || (m === 0 && today.getDate() < birthDate.getDate())) {
        age -= age > 0 ? 1 : 0;
    }
    return age;
}
FunctionFactory.Instance.register("age", age);
function isContainerReadyCore(container) {
    if (!container)
        return false;
    var questions = container.questions;
    for (var i = 0; i < questions.length; i++) {
        if (questions[i].hasErrors(false))
            return false;
    }
    return true;
}
function isContainerReady(params) {
    if (!params && params.length < 1)
        return false;
    if (!params[0] || !this.survey)
        return false;
    var name = params[0];
    var container = this.survey.getPageByName(name);
    if (!container)
        container = this.survey.getPanelByName(name);
    if (!container) {
        var question = this.survey.getQuestionByName(name);
        if (!question || !Array.isArray(question.panels))
            return false;
        if (params.length > 1) {
            if (params[1] < question.panels.length) {
                container = question.panels[params[1]];
            }
        }
        else {
            for (var i = 0; i < question.panels.length; i++) {
                if (!isContainerReadyCore(question.panels[i]))
                    return false;
            }
            return true;
        }
    }
    return isContainerReadyCore(container);
}
FunctionFactory.Instance.register("isContainerReady", isContainerReady);
function isDisplayMode() {
    return this.survey && this.survey.isDisplayMode;
}
FunctionFactory.Instance.register("isDisplayMode", isDisplayMode);
function currentDate() {
    return new Date();
}
FunctionFactory.Instance.register("currentDate", currentDate);
function today(params) {
    var res = new Date();
    res.setUTCHours(0, 0, 0, 0);
    if (Array.isArray(params) && params.length == 1) {
        res.setDate(res.getDate() + params[0]);
    }
    return res;
}
FunctionFactory.Instance.register("today", today);
function getYear(params) {
    if (params.length !== 1 || !params[0])
        return undefined;
    return new Date(params[0]).getFullYear();
}
FunctionFactory.Instance.register("getYear", getYear);
function currentYear() {
    return new Date().getFullYear();
}
FunctionFactory.Instance.register("currentYear", currentYear);
function diffDays(params) {
    if (!Array.isArray(params) || params.length !== 2)
        return 0;
    if (!params[0] || !params[1])
        return 0;
    var date1 = new Date(params[0]);
    var date2 = new Date(params[1]);
    var diffTime = Math.abs(date2 - date1);
    return Math.ceil(diffTime / (1000 * 60 * 60 * 24));
}
FunctionFactory.Instance.register("diffDays", diffDays);


/***/ }),

/***/ "./src/helpers.ts":
/*!************************!*\
  !*** ./src/helpers.ts ***!
  \************************/
/*! exports provided: Helpers */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "Helpers", function() { return Helpers; });
/* harmony import */ var _settings__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./settings */ "./src/settings.ts");

var Helpers = /** @class */ (function () {
    function Helpers() {
    }
    /**
     * A static methods that returns true if a value undefined, null, empty string or empty array.
     * @param value
     */
    Helpers.isValueEmpty = function (value) {
        if (Array.isArray(value) && value.length === 0)
            return true;
        if (!!value && typeof value === "object" && value.constructor === Object) {
            for (var key in value) {
                if (!Helpers.isValueEmpty(value[key]))
                    return false;
            }
            return true;
        }
        return !value && value !== 0 && value !== false;
    };
    Helpers.isArrayContainsEqual = function (x, y) {
        if (!Array.isArray(x) || !Array.isArray(y))
            return false;
        if (x.length !== y.length)
            return false;
        for (var i = 0; i < x.length; i++) {
            var j = 0;
            for (; j < y.length; j++) {
                if (Helpers.isTwoValueEquals(x[i], y[j]))
                    break;
            }
            if (j === y.length)
                return false;
        }
        return true;
    };
    Helpers.isArraysEqual = function (x, y, ignoreOrder, caseSensitive, trimStrings) {
        if (ignoreOrder === void 0) { ignoreOrder = false; }
        if (!Array.isArray(x) || !Array.isArray(y))
            return false;
        if (x.length !== y.length)
            return false;
        if (ignoreOrder) {
            var xSorted = [];
            var ySorted = [];
            for (var i = 0; i < x.length; i++) {
                xSorted.push(x[i]);
                ySorted.push(y[i]);
            }
            xSorted.sort();
            ySorted.sort();
            x = xSorted;
            y = ySorted;
        }
        for (var i = 0; i < x.length; i++) {
            if (!Helpers.isTwoValueEquals(x[i], y[i], ignoreOrder, caseSensitive, trimStrings))
                return false;
        }
        return true;
    };
    Helpers.isTwoValueEquals = function (x, y, ignoreOrder, caseSensitive, trimStrings) {
        if (ignoreOrder === void 0) { ignoreOrder = false; }
        if (x === y)
            return true;
        if (Array.isArray(x) && x.length === 0 && typeof y === "undefined")
            return true;
        if (Array.isArray(y) && y.length === 0 && typeof x === "undefined")
            return true;
        if ((x === undefined || x === null) && y === "")
            return true;
        if ((y === undefined || y === null) && x === "")
            return true;
        if (trimStrings === undefined)
            trimStrings = _settings__WEBPACK_IMPORTED_MODULE_0__["settings"].comparator.trimStrings;
        if (caseSensitive === undefined)
            caseSensitive = _settings__WEBPACK_IMPORTED_MODULE_0__["settings"].comparator.caseSensitive;
        if (typeof x === "string" && typeof y === "string") {
            if (trimStrings) {
                x = x.trim();
                y = y.trim();
            }
            if (!caseSensitive) {
                x = x.toLowerCase();
                y = y.toLowerCase();
            }
            return x === y;
        }
        if (x instanceof Date && y instanceof Date)
            return x.getTime() == y.getTime();
        if (Helpers.isConvertibleToNumber(x) && Helpers.isConvertibleToNumber(y)) {
            if (parseInt(x) === parseInt(y) && parseFloat(x) === parseFloat(y)) {
                return true;
            }
        }
        if ((!Helpers.isValueEmpty(x) && Helpers.isValueEmpty(y)) ||
            (Helpers.isValueEmpty(x) && !Helpers.isValueEmpty(y)))
            return false;
        if ((x === true || x === false) && typeof y == "string") {
            return x.toString() === y.toLocaleLowerCase();
        }
        if ((y === true || y === false) && typeof x == "string") {
            return y.toString() === x.toLocaleLowerCase();
        }
        if (!(x instanceof Object) && !(y instanceof Object))
            return x == y;
        if (!(x instanceof Object) || !(y instanceof Object))
            return false;
        if (x["equals"])
            return x.equals(y);
        if (!!x.toJSON && !!y.toJSON && !!x.getType && !!y.getType) {
            if (x.isDiposed || y.isDiposed)
                return false;
            if (x.getType() !== y.getType())
                return false;
            if (!!x.name && x.name !== y.name)
                return false;
            return this.isTwoValueEquals(x.toJSON(), y.toJSON(), ignoreOrder, caseSensitive, trimStrings);
        }
        if (Array.isArray(x) && Array.isArray(y))
            return Helpers.isArraysEqual(x, y, ignoreOrder, caseSensitive, trimStrings);
        for (var p in x) {
            if (!x.hasOwnProperty(p))
                continue;
            if (!y.hasOwnProperty(p))
                return false;
            if (x[p] === y[p])
                continue;
            if (typeof x[p] !== "object")
                return false;
            if (!this.isTwoValueEquals(x[p], y[p]))
                return false;
        }
        for (p in y) {
            if (y.hasOwnProperty(p) && !x.hasOwnProperty(p))
                return false;
        }
        return true;
    };
    Helpers.randomizeArray = function (array) {
        for (var i = array.length - 1; i > 0; i--) {
            var j = Math.floor(Math.random() * (i + 1));
            var temp = array[i];
            array[i] = array[j];
            array[j] = temp;
        }
        return array;
    };
    Helpers.getUnbindValue = function (value) {
        if (!!value && value instanceof Object) {
            //do not return the same object instance!!!
            return JSON.parse(JSON.stringify(value));
        }
        return value;
    };
    Helpers.createCopy = function (obj) {
        var res = {};
        if (!obj)
            return res;
        for (var key in obj) {
            res[key] = obj[key];
        }
        return res;
    };
    Helpers.isConvertibleToNumber = function (value) {
        return (value !== undefined &&
            value !== null &&
            !Array.isArray(value) &&
            !isNaN(value));
    };
    Helpers.isNumber = function (value) {
        if (typeof value == "string" &&
            !!value &&
            value.indexOf("0x") == 0 &&
            value.length > 32)
            return false;
        return !isNaN(parseFloat(value)) && isFinite(value);
    };
    Helpers.getMaxLength = function (maxLength, surveyLength) {
        if (maxLength < 0) {
            maxLength = surveyLength;
        }
        return maxLength > 0 ? maxLength : null;
    };
    Helpers.getNumberByIndex = function (index, startIndexStr) {
        if (index < 0)
            return "";
        var startIndex = 1;
        var prefix = "";
        var postfix = ".";
        var isNumeric = true;
        var strIndex = "A";
        var str = "";
        if (!!startIndexStr) {
            str = startIndexStr;
            var ind = str.length - 1;
            var hasDigit = false;
            for (var i = 0; i < str.length; i++) {
                if (Helpers.isCharDigit(str[i])) {
                    hasDigit = true;
                    break;
                }
            }
            var checkLetter = function () {
                return ((hasDigit && !Helpers.isCharDigit(str[ind])) ||
                    Helpers.isCharNotLetterAndDigit(str[ind]));
            };
            while (ind >= 0 && checkLetter())
                ind--;
            var newPostfix = "";
            if (ind < str.length - 1) {
                newPostfix = str.substr(ind + 1);
                str = str.substr(0, ind + 1);
            }
            ind = str.length - 1;
            while (ind >= 0) {
                if (checkLetter())
                    break;
                ind--;
                if (!hasDigit)
                    break;
            }
            strIndex = str.substr(ind + 1);
            prefix = str.substr(0, ind + 1);
            if (parseInt(strIndex))
                startIndex = parseInt(strIndex);
            else if (strIndex.length == 1)
                isNumeric = false;
            if (!!newPostfix || !!prefix) {
                postfix = newPostfix;
            }
        }
        if (isNumeric)
            return prefix + (index + startIndex).toString() + postfix;
        return (prefix + String.fromCharCode(strIndex.charCodeAt(0) + index) + postfix);
    };
    Helpers.isCharNotLetterAndDigit = function (ch) {
        return ch.toUpperCase() == ch.toLowerCase() && !Helpers.isCharDigit(ch);
    };
    Helpers.isCharDigit = function (ch) {
        return ch >= "0" && ch <= "9";
    };
    Helpers.countDecimals = function (value) {
        if (Helpers.isNumber(value) && Math.floor(value) !== value) {
            var strs = value.toString().split(".");
            return strs.length > 1 && strs[1].length || 0;
        }
        return 0;
    };
    Helpers.correctAfterPlusMinis = function (a, b, res) {
        var digitsA = Helpers.countDecimals(a);
        var digitsB = Helpers.countDecimals(b);
        if (digitsA > 0 || digitsB > 0) {
            var digits = Math.max(digitsA, digitsB);
            res = parseFloat(res.toFixed(digits));
        }
        return res;
    };
    Helpers.correctAfterMultiple = function (a, b, res) {
        var digits = Helpers.countDecimals(a) + Helpers.countDecimals(b);
        if (digits > 0) {
            res = parseFloat(res.toFixed(digits));
        }
        return res;
    };
    return Helpers;
}());

if (!String.prototype["format"]) {
    String.prototype["format"] = function () {
        var args = arguments;
        return this.replace(/{(\d+)}/g, function (match, number) {
            return typeof args[number] != "undefined" ? args[number] : match;
        });
    };
}


/***/ }),

/***/ "./src/itemvalue.ts":
/*!**************************!*\
  !*** ./src/itemvalue.ts ***!
  \**************************/
/*! exports provided: ItemValue */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "ItemValue", function() { return ItemValue; });
/* harmony import */ var _localizablestring__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./localizablestring */ "./src/localizablestring.ts");
/* harmony import */ var _jsonobject__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ./jsonobject */ "./src/jsonobject.ts");
/* harmony import */ var _helpers__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ./helpers */ "./src/helpers.ts");
/* harmony import */ var _conditions__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ./conditions */ "./src/conditions.ts");
/* harmony import */ var _base__WEBPACK_IMPORTED_MODULE_4__ = __webpack_require__(/*! ./base */ "./src/base.ts");
/* harmony import */ var _settings__WEBPACK_IMPORTED_MODULE_5__ = __webpack_require__(/*! ./settings */ "./src/settings.ts");
var __extends = (undefined && undefined.__extends) || (function () {
    var extendStatics = function (d, b) {
        extendStatics = Object.setPrototypeOf ||
            ({ __proto__: [] } instanceof Array && function (d, b) { d.__proto__ = b; }) ||
            function (d, b) { for (var p in b) if (Object.prototype.hasOwnProperty.call(b, p)) d[p] = b[p]; };
        return extendStatics(d, b);
    };
    return function (d, b) {
        if (typeof b !== "function" && b !== null)
            throw new TypeError("Class extends value " + String(b) + " is not a constructor or null");
        extendStatics(d, b);
        function __() { this.constructor = d; }
        d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
    };
})();
var __spreadArray = (undefined && undefined.__spreadArray) || function (to, from, pack) {
    if (pack || arguments.length === 2) for (var i = 0, l = from.length, ar; i < l; i++) {
        if (ar || !(i in from)) {
            if (!ar) ar = Array.prototype.slice.call(from, 0, i);
            ar[i] = from[i];
        }
    }
    return to.concat(ar || Array.prototype.slice.call(from));
};






/**
 * Array of ItemValue is used in checkox, dropdown and radiogroup choices, matrix columns and rows.
 * It has two main properties: value and text. If text is empty, value is used for displaying.
 * The text property is localizable and support markdown.
 */
var ItemValue = /** @class */ (function (_super) {
    __extends(ItemValue, _super);
    function ItemValue(value, text, typeName) {
        if (text === void 0) { text = null; }
        if (typeName === void 0) { typeName = "itemvalue"; }
        var _this = _super.call(this) || this;
        _this.typeName = typeName;
        _this.ownerPropertyName = "";
        _this.isVisibleValue = true;
        _this.locTextValue = new _localizablestring__WEBPACK_IMPORTED_MODULE_0__["LocalizableString"](null, true);
        _this.locTextValue.onStrChanged = function (oldValue, newValue) {
            if (newValue == _this.value) {
                newValue = undefined;
            }
            _this.propertyValueChanged("text", oldValue, newValue);
        };
        _this.locTextValue.onGetTextCallback = function (txt) {
            return txt
                ? txt
                : !_helpers__WEBPACK_IMPORTED_MODULE_2__["Helpers"].isValueEmpty(_this.value)
                    ? _this.value.toString()
                    : null;
        };
        if (text)
            _this.locText.text = text;
        if (!!value && typeof value === "object") {
            _this.setData(value);
        }
        else {
            _this.value = value;
        }
        if (_this.getType() != "itemvalue") {
            _jsonobject__WEBPACK_IMPORTED_MODULE_1__["CustomPropertiesCollection"].createProperties(_this);
        }
        _this.onCreating();
        return _this;
    }
    Object.defineProperty(ItemValue, "Separator", {
        get: function () {
            return _settings__WEBPACK_IMPORTED_MODULE_5__["settings"].itemValueSeparator;
        },
        set: function (val) {
            _settings__WEBPACK_IMPORTED_MODULE_5__["settings"].itemValueSeparator = val;
        },
        enumerable: false,
        configurable: true
    });
    ItemValue.createArray = function (locOwner) {
        var items = [];
        ItemValue.setupArray(items, locOwner);
        return items;
    };
    ItemValue.setupArray = function (items, locOwner) {
        items.push = function (value) {
            var result = Array.prototype.push.call(this, value);
            value.locOwner = locOwner;
            return result;
        };
        items.unshift = function (value) {
            var result = Array.prototype.unshift.call(this, value);
            value.locOwner = locOwner;
            return result;
        };
        items.splice = function (start, deleteCount) {
            var _a;
            var items = [];
            for (var _i = 2; _i < arguments.length; _i++) {
                items[_i - 2] = arguments[_i];
            }
            var result = (_a = Array.prototype.splice).call.apply(_a, __spreadArray([this,
                start,
                deleteCount], items, false));
            if (!items)
                items = [];
            for (var i = 0; i < items.length; i++) {
                items[i].locOwner = locOwner;
            }
            return result;
        };
    };
    ItemValue.setData = function (items, values) {
        items.length = 0;
        for (var i = 0; i < values.length; i++) {
            var value = values[i];
            var item;
            if (typeof value.getType === "function") {
                item = _jsonobject__WEBPACK_IMPORTED_MODULE_1__["Serializer"].createClass(value.getType());
            }
            else {
                item = new ItemValue(null);
            }
            item.setData(value);
            if (!!value.originalItem) {
                item.originalItem = value.originalItem;
            }
            items.push(item);
        }
    };
    ItemValue.getData = function (items) {
        var result = [];
        for (var i = 0; i < items.length; i++) {
            result.push(items[i].getData());
        }
        return result;
    };
    ItemValue.getItemByValue = function (items, val) {
        if (!Array.isArray(items))
            return null;
        var valIsEmpty = _helpers__WEBPACK_IMPORTED_MODULE_2__["Helpers"].isValueEmpty(val);
        for (var i = 0; i < items.length; i++) {
            if (valIsEmpty && _helpers__WEBPACK_IMPORTED_MODULE_2__["Helpers"].isValueEmpty(items[i].value))
                return items[i];
            if (_helpers__WEBPACK_IMPORTED_MODULE_2__["Helpers"].isTwoValueEquals(items[i].value, val, false, true, false))
                return items[i];
        }
        return null;
    };
    ItemValue.getTextOrHtmlByValue = function (items, val) {
        var item = ItemValue.getItemByValue(items, val);
        return item !== null ? item.locText.textOrHtml : "";
    };
    ItemValue.locStrsChanged = function (items) {
        for (var i = 0; i < items.length; i++) {
            items[i].locStrsChanged();
        }
    };
    ItemValue.runConditionsForItems = function (items, filteredItems, runner, values, properties, useItemExpression) {
        if (useItemExpression === void 0) { useItemExpression = true; }
        return ItemValue.runConditionsForItemsCore(items, filteredItems, runner, values, properties, true, useItemExpression);
    };
    ItemValue.runEnabledConditionsForItems = function (items, runner, values, properties, onItemCallBack) {
        return ItemValue.runConditionsForItemsCore(items, null, runner, values, properties, false, true, onItemCallBack);
    };
    ItemValue.runConditionsForItemsCore = function (items, filteredItems, runner, values, properties, isVisible, useItemExpression, onItemCallBack) {
        if (useItemExpression === void 0) { useItemExpression = true; }
        if (!values) {
            values = {};
        }
        var itemValue = values["item"];
        var choiceValue = values["choice"];
        var hasChanded = false;
        for (var i = 0; i < items.length; i++) {
            var item = items[i];
            values["item"] = item.value;
            values["choice"] = item.value;
            var itemRunner = useItemExpression && !!item.getConditionRunner
                ? item.getConditionRunner(isVisible)
                : false;
            if (!itemRunner) {
                itemRunner = runner;
            }
            var newValue = true;
            if (itemRunner) {
                newValue = itemRunner.run(values, properties);
            }
            if (newValue && !!onItemCallBack) {
                newValue = onItemCallBack(item);
            }
            if (!!filteredItems && newValue) {
                filteredItems.push(item);
            }
            var oldValue = isVisible ? item.isVisible : item.isEnabled;
            if (newValue != oldValue) {
                hasChanded = true;
                if (isVisible) {
                    if (!!item.setIsVisible)
                        item.setIsVisible(newValue);
                }
                else {
                    if (!!item.setIsEnabled)
                        item.setIsEnabled(newValue);
                }
            }
        }
        if (itemValue) {
            values["item"] = itemValue;
        }
        else {
            delete values["item"];
        }
        if (choiceValue) {
            values["choice"] = choiceValue;
        }
        else {
            delete values["choice"];
        }
        return hasChanded;
    };
    ItemValue.prototype.onCreating = function () { };
    ItemValue.prototype.getType = function () {
        return !!this.typeName ? this.typeName : "itemvalue";
    };
    ItemValue.prototype.getSurvey = function (live) {
        if (live === void 0) { live = false; }
        return !!this.locOwner && !!this.locOwner["getSurvey"]
            ? this.locOwner.getSurvey()
            : null;
    };
    ItemValue.prototype.getLocale = function () {
        return (this.locText && this.locText.locale) || "";
    };
    Object.defineProperty(ItemValue.prototype, "locText", {
        get: function () {
            return this.locTextValue;
        },
        enumerable: false,
        configurable: true
    });
    ItemValue.prototype.setLocText = function (locText) {
        this.locTextValue = locText;
    };
    Object.defineProperty(ItemValue.prototype, "locOwner", {
        get: function () {
            return this.locText.owner;
        },
        set: function (value) {
            this.locText.owner = value;
        },
        enumerable: false,
        configurable: true
    });
    Object.defineProperty(ItemValue.prototype, "value", {
        get: function () {
            return this.getPropertyValue("value");
        },
        set: function (newValue) {
            var text = undefined;
            if (!_helpers__WEBPACK_IMPORTED_MODULE_2__["Helpers"].isValueEmpty(newValue)) {
                var str = newValue.toString();
                var index = str.indexOf(_settings__WEBPACK_IMPORTED_MODULE_5__["settings"].itemValueSeparator);
                if (index > -1) {
                    newValue = str.slice(0, index);
                    text = str.slice(index + 1);
                }
            }
            this.setPropertyValue("value", newValue);
            if (!!text) {
                this.text = text;
            }
        },
        enumerable: false,
        configurable: true
    });
    Object.defineProperty(ItemValue.prototype, "hasText", {
        get: function () {
            return this.locText.pureText ? true : false;
        },
        enumerable: false,
        configurable: true
    });
    Object.defineProperty(ItemValue.prototype, "pureText", {
        get: function () {
            return this.locText.pureText;
        },
        set: function (val) {
            this.text = val;
        },
        enumerable: false,
        configurable: true
    });
    Object.defineProperty(ItemValue.prototype, "text", {
        get: function () {
            return this.locText.calculatedText; //TODO: it will be correct to use this.locText.text, however it would require a lot of rewriting in Creator
        },
        set: function (newText) {
            this.locText.text = newText;
        },
        enumerable: false,
        configurable: true
    });
    Object.defineProperty(ItemValue.prototype, "calculatedText", {
        get: function () {
            return this.locText.calculatedText;
        },
        enumerable: false,
        configurable: true
    });
    Object.defineProperty(ItemValue.prototype, "shortcutText", {
        get: function () {
            return this.text;
        },
        enumerable: false,
        configurable: true
    });
    ItemValue.prototype.getData = function () {
        var json = this.toJSON();
        if (!!json["value"] && !!json["value"]["pos"]) {
            delete json["value"]["pos"];
        }
        if (!_settings__WEBPACK_IMPORTED_MODULE_5__["settings"].itemValueAlwaysSerializeAsObject && Object.keys(json).length == 1 && !_helpers__WEBPACK_IMPORTED_MODULE_2__["Helpers"].isValueEmpty(json["value"]))
            return this.value;
        return json;
    };
    ItemValue.prototype.toJSON = function () {
        var res = {};
        var properties = _jsonobject__WEBPACK_IMPORTED_MODULE_1__["Serializer"].getProperties(this.getType());
        if (!properties || properties.length == 0) {
            properties = _jsonobject__WEBPACK_IMPORTED_MODULE_1__["Serializer"].getProperties("itemvalue");
        }
        var jsoObj = new _jsonobject__WEBPACK_IMPORTED_MODULE_1__["JsonObject"]();
        for (var i = 0; i < properties.length; i++) {
            jsoObj.valueToJson(this, res, properties[i]);
        }
        return res;
    };
    ItemValue.prototype.setData = function (value) {
        if (_helpers__WEBPACK_IMPORTED_MODULE_2__["Helpers"].isValueEmpty(value))
            return;
        if (typeof value.value !== "undefined") {
            var json = value;
            if (typeof value.toJSON === "function") {
                json = value.toJSON();
            }
            new _jsonobject__WEBPACK_IMPORTED_MODULE_1__["JsonObject"]().toObject(json, this);
        }
        else {
            this.value = value;
        }
        this.locText.strChanged();
    };
    Object.defineProperty(ItemValue.prototype, "visibleIf", {
        get: function () {
            return this.getPropertyValue("visibleIf", "");
        },
        set: function (val) {
            this.setPropertyValue("visibleIf", val);
        },
        enumerable: false,
        configurable: true
    });
    Object.defineProperty(ItemValue.prototype, "enableIf", {
        get: function () {
            return this.getPropertyValue("enableIf", "");
        },
        set: function (val) {
            this.setPropertyValue("enableIf", val);
        },
        enumerable: false,
        configurable: true
    });
    Object.defineProperty(ItemValue.prototype, "isVisible", {
        get: function () {
            return this.isVisibleValue;
        },
        enumerable: false,
        configurable: true
    });
    ItemValue.prototype.setIsVisible = function (val) {
        this.isVisibleValue = val;
    };
    Object.defineProperty(ItemValue.prototype, "isEnabled", {
        get: function () {
            return this.getPropertyValue("isEnabled", true);
        },
        enumerable: false,
        configurable: true
    });
    ItemValue.prototype.setIsEnabled = function (val) {
        this.setPropertyValue("isEnabled", val);
    };
    ItemValue.prototype.addUsedLocales = function (locales) {
        this.AddLocStringToUsedLocales(this.locTextValue, locales);
    };
    ItemValue.prototype.locStrsChanged = function () {
        _super.prototype.locStrsChanged.call(this);
        this.locText.strChanged();
    };
    ItemValue.prototype.onPropertyValueChanged = function (name, oldValue, newValue) {
        if (name === "value" && !this.hasText) {
            this.locText.onChanged();
        }
        var funcName = "itemValuePropertyChanged";
        if (!this.locOwner || !this.locOwner[funcName])
            return;
        this.locOwner[funcName](this, name, oldValue, newValue);
    };
    ItemValue.prototype.getConditionRunner = function (isVisible) {
        if (isVisible)
            return this.getVisibleConditionRunner();
        return this.getEnableConditionRunner();
    };
    ItemValue.prototype.getVisibleConditionRunner = function () {
        if (!this.visibleIf)
            return null;
        if (!this.visibleConditionRunner)
            this.visibleConditionRunner = new _conditions__WEBPACK_IMPORTED_MODULE_3__["ConditionRunner"](this.visibleIf);
        this.visibleConditionRunner.expression = this.visibleIf;
        return this.visibleConditionRunner;
    };
    ItemValue.prototype.getEnableConditionRunner = function () {
        if (!this.enableIf)
            return null;
        if (!this.enableConditionRunner)
            this.enableConditionRunner = new _conditions__WEBPACK_IMPORTED_MODULE_3__["ConditionRunner"](this.enableIf);
        this.enableConditionRunner.expression = this.enableIf;
        return this.enableConditionRunner;
    };
    return ItemValue;
}(_base__WEBPACK_IMPORTED_MODULE_4__["Base"]));

_base__WEBPACK_IMPORTED_MODULE_4__["Base"].createItemValue = function (source, type) {
    var item = null;
    if (!!type) {
        item = _jsonobject__WEBPACK_IMPORTED_MODULE_1__["JsonObject"].metaData.createClass(type, {});
    }
    else if (typeof source.getType === "function") {
        item = new ItemValue(null, undefined, source.getType());
    }
    else {
        item = new ItemValue(null);
    }
    item.setData(source);
    return item;
};
_base__WEBPACK_IMPORTED_MODULE_4__["Base"].itemValueLocStrChanged = function (arr) {
    ItemValue.locStrsChanged(arr);
};
_jsonobject__WEBPACK_IMPORTED_MODULE_1__["JsonObjectProperty"].getItemValuesDefaultValue = function (val) {
    var res = new Array();
    ItemValue.setData(res, val || []);
    return res;
};
_jsonobject__WEBPACK_IMPORTED_MODULE_1__["Serializer"].addClass("itemvalue", [
    "!value",
    {
        name: "text",
        serializationProperty: "locText",
    },
    { name: "visibleIf:condition", showMode: "form" },
    {
        name: "enableIf:condition",
        showMode: "form",
        visibleIf: function (obj) {
            return !obj || obj.ownerPropertyName !== "rateValues";
        },
    },
], function (value) { return new ItemValue(value); });


/***/ }),

/***/ "./src/jsonobject.ts":
/*!***************************!*\
  !*** ./src/jsonobject.ts ***!
  \***************************/
/*! exports provided: property, propertyArray, JsonObjectProperty, CustomPropertiesCollection, JsonMetadataClass, JsonMetadata, JsonError, JsonUnknownPropertyError, JsonMissingTypeErrorBase, JsonMissingTypeError, JsonIncorrectTypeError, JsonRequiredPropertyError, JsonObject, Serializer */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "property", function() { return property; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "propertyArray", function() { return propertyArray; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "JsonObjectProperty", function() { return JsonObjectProperty; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "CustomPropertiesCollection", function() { return CustomPropertiesCollection; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "JsonMetadataClass", function() { return JsonMetadataClass; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "JsonMetadata", function() { return JsonMetadata; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "JsonError", function() { return JsonError; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "JsonUnknownPropertyError", function() { return JsonUnknownPropertyError; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "JsonMissingTypeErrorBase", function() { return JsonMissingTypeErrorBase; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "JsonMissingTypeError", function() { return JsonMissingTypeError; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "JsonIncorrectTypeError", function() { return JsonIncorrectTypeError; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "JsonRequiredPropertyError", function() { return JsonRequiredPropertyError; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "JsonObject", function() { return JsonObject; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "Serializer", function() { return Serializer; });
/* harmony import */ var _surveyStrings__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./surveyStrings */ "./src/surveyStrings.ts");
/* harmony import */ var _base__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ./base */ "./src/base.ts");
/* harmony import */ var _helpers__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ./helpers */ "./src/helpers.ts");
var __extends = (undefined && undefined.__extends) || (function () {
    var extendStatics = function (d, b) {
        extendStatics = Object.setPrototypeOf ||
            ({ __proto__: [] } instanceof Array && function (d, b) { d.__proto__ = b; }) ||
            function (d, b) { for (var p in b) if (Object.prototype.hasOwnProperty.call(b, p)) d[p] = b[p]; };
        return extendStatics(d, b);
    };
    return function (d, b) {
        if (typeof b !== "function" && b !== null)
            throw new TypeError("Class extends value " + String(b) + " is not a constructor or null");
        extendStatics(d, b);
        function __() { this.constructor = d; }
        d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
    };
})();
var __spreadArray = (undefined && undefined.__spreadArray) || function (to, from, pack) {
    if (pack || arguments.length === 2) for (var i = 0, l = from.length, ar; i < l; i++) {
        if (ar || !(i in from)) {
            if (!ar) ar = Array.prototype.slice.call(from, 0, i);
            ar[i] = from[i];
        }
    }
    return to.concat(ar || Array.prototype.slice.call(from));
};



function ensureLocString(target, options, key) {
    var locString = target.getLocalizableString(key);
    if (!locString) {
        locString = target.createLocalizableString(key, target, true);
        if (typeof options.localizable === "object" &&
            typeof options.localizable.onGetTextCallback === "function") {
            locString.onGetTextCallback = options.localizable.onGetTextCallback;
        }
    }
}
function getLocStringValue(target, options, key) {
    ensureLocString(target, options, key);
    var res = target.getLocalizableStringText(key);
    if (!!res)
        return res;
    if (typeof options.localizable === "object" && options.localizable.defaultStr)
        return _surveyStrings__WEBPACK_IMPORTED_MODULE_0__["surveyLocalization"].getString(options.localizable.defaultStr);
    return "";
}
function property(options) {
    return function (target, key) {
        var processComputedUpdater = function (obj, val) {
            if (!!val && typeof val === "object" && val.type === _base__WEBPACK_IMPORTED_MODULE_1__["ComputedUpdater"].ComputedUpdaterType) {
                _base__WEBPACK_IMPORTED_MODULE_1__["Base"].startCollectDependencies(function () { return obj[key] = val.updater(); }, obj, key);
                var result = val.updater();
                var dependencies = _base__WEBPACK_IMPORTED_MODULE_1__["Base"].finishCollectDependencies();
                val.setDependencies(dependencies);
                return result;
            }
            return val;
        };
        if (!options || !options.localizable) {
            Object.defineProperty(target, key, {
                get: function () {
                    var value = this.getPropertyValue(key);
                    if (value !== undefined) {
                        return value;
                    }
                    if (!!options) {
                        if (options.defaultValue !== undefined) {
                            return options.defaultValue;
                        }
                        if (options.defaultSource !== undefined) {
                            return this[options.defaultSource];
                        }
                    }
                    return undefined;
                },
                set: function (val) {
                    var newValue = processComputedUpdater(this, val);
                    this.setPropertyValue(key, newValue);
                    if (!!options && options.onSet) {
                        options.onSet(newValue, this);
                    }
                },
            });
        }
        else {
            Object.defineProperty(target, key, {
                get: function () {
                    return getLocStringValue(this, options, key);
                },
                set: function (val) {
                    ensureLocString(this, options, key);
                    var newValue = processComputedUpdater(this, val);
                    this.setLocalizableStringText(key, newValue);
                    if (!!options && options.onSet) {
                        options.onSet(newValue, this);
                    }
                },
            });
            Object.defineProperty(target, typeof options.localizable === "object" && !!options.localizable.name ?
                options.localizable.name : "loc" + key.charAt(0).toUpperCase() + key.slice(1), {
                get: function () {
                    ensureLocString(this, options, key);
                    return this.getLocalizableString(key);
                },
            });
        }
    };
}
function ensureArray(target, options, key) {
    target.ensureArray(key, function (item, index) {
        var handler = !!options ? options.onPush : null;
        handler && handler(item, index, target);
    }, function (item, index) {
        var handler = !!options ? options.onRemove : null;
        handler && handler(item, index, target);
    });
}
function propertyArray(options) {
    return function (target, key) {
        Object.defineProperty(target, key, {
            get: function () {
                ensureArray(this, options, key);
                return this.getPropertyValue(key);
            },
            set: function (val) {
                ensureArray(this, options, key);
                var arr = this.getPropertyValue(key);
                if (val === arr) {
                    return;
                }
                if (arr) {
                    arr.splice.apply(arr, __spreadArray([0, arr.length], (val || []), false));
                }
                else {
                    this.setPropertyValue(key, val);
                }
                if (!!options && options.onSet) {
                    options.onSet(val, this);
                }
            },
        });
    };
}
/**
 * Contains information about a property of a survey element (page, panel, questions, and etc).
 * @see addProperty
 * @see removeProperty
 * @see [Add Properties](https://surveyjs.io/Documentation/Survey-Creator#addproperties)
 * @see [Remove Properties](https://surveyjs.io/Documentation/Survey-Creator#removeproperties)
 */
var JsonObjectProperty = /** @class */ (function () {
    function JsonObjectProperty(classInfo, name, isRequired) {
        if (isRequired === void 0) { isRequired = false; }
        this.name = name;
        this.typeValue = null;
        this.choicesValue = null;
        this.baseValue = null;
        this.isRequiredValue = false;
        this.isUniqueValue = false;
        this.readOnlyValue = null;
        this.visibleValue = null;
        this.isLocalizableValue = null;
        this.choicesfunc = null;
        this.dependedProperties = null;
        this.isSerializable = true;
        this.isLightSerializable = true;
        this.isCustom = false;
        this.isDynamicChoices = false; //TODO obsolete, use dependsOn attribute
        this.isBindable = false;
        this.className = null;
        this.alternativeName = null;
        this.classNamePart = null;
        this.baseClassName = null;
        this.defaultValueValue = null;
        this.serializationProperty = null;
        this.displayName = null;
        this.category = "";
        this.categoryIndex = -1;
        this.visibleIndex = -1;
        this.nextToProperty = null;
        this.showMode = null;
        this.maxLength = -1;
        this.layout = null;
        this.onGetValue = null;
        this.onSetValue = null;
        this.visibleIf = null;
        this.isArray = false;
        this.classInfoValue = classInfo;
        this.isRequiredValue = isRequired;
        this.idValue = JsonObjectProperty.Index++;
    }
    Object.defineProperty(JsonObjectProperty.prototype, "id", {
        get: function () {
            return this.idValue;
        },
        enumerable: false,
        configurable: true
    });
    Object.defineProperty(JsonObjectProperty.prototype, "classInfo", {
        get: function () {
            return this.classInfoValue;
        },
        enumerable: false,
        configurable: true
    });
    Object.defineProperty(JsonObjectProperty.prototype, "type", {
        get: function () {
            return this.typeValue ? this.typeValue : "string";
        },
        set: function (value) {
            if (value === "itemvalues")
                value = "itemvalue[]";
            this.typeValue = value;
            if (this.typeValue.indexOf("[]") === this.typeValue.length - 2) {
                this.isArray = true;
                this.className = this.typeValue.substr(0, this.typeValue.length - 2);
            }
        },
        enumerable: false,
        configurable: true
    });
    Object.defineProperty(JsonObjectProperty.prototype, "isRequired", {
        get: function () {
            return this.isRequiredValue;
        },
        set: function (val) {
            this.isRequiredValue = val;
        },
        enumerable: false,
        configurable: true
    });
    Object.defineProperty(JsonObjectProperty.prototype, "isUnique", {
        get: function () {
            return this.isUniqueValue;
        },
        set: function (val) {
            this.isUniqueValue = val;
        },
        enumerable: false,
        configurable: true
    });
    Object.defineProperty(JsonObjectProperty.prototype, "hasToUseGetValue", {
        get: function () {
            return this.onGetValue || this.serializationProperty;
        },
        enumerable: false,
        configurable: true
    });
    Object.defineProperty(JsonObjectProperty.prototype, "defaultValue", {
        get: function () {
            var result = this.defaultValueValue;
            if (!!JsonObjectProperty.getItemValuesDefaultValue &&
                JsonObject.metaData.isDescendantOf(this.className, "itemvalue")) {
                result = JsonObjectProperty.getItemValuesDefaultValue(this.defaultValueValue || []);
            }
            return result;
        },
        set: function (newValue) {
            this.defaultValueValue = newValue;
        },
        enumerable: false,
        configurable: true
    });
    JsonObjectProperty.prototype.isDefaultValue = function (value) {
        if (!_helpers__WEBPACK_IMPORTED_MODULE_2__["Helpers"].isValueEmpty(this.defaultValue))
            return this.defaultValue == value;
        return ((value === false && (this.type == "boolean" || this.type == "switch")) ||
            value === "" ||
            _helpers__WEBPACK_IMPORTED_MODULE_2__["Helpers"].isValueEmpty(value));
    };
    JsonObjectProperty.prototype.getValue = function (obj) {
        if (this.onGetValue)
            return this.onGetValue(obj);
        if (this.serializationProperty && !!obj[this.serializationProperty])
            return obj[this.serializationProperty].getJson();
        return obj[this.name];
    };
    JsonObjectProperty.prototype.getPropertyValue = function (obj) {
        if (this.isLocalizable) {
            return !!obj[this.serializationProperty]
                ? obj[this.serializationProperty].text
                : null;
        }
        return this.getValue(obj);
    };
    Object.defineProperty(JsonObjectProperty.prototype, "hasToUseSetValue", {
        get: function () {
            return this.onSetValue || this.serializationProperty;
        },
        enumerable: false,
        configurable: true
    });
    JsonObjectProperty.prototype.setValue = function (obj, value, jsonConv) {
        if (this.onSetValue) {
            this.onSetValue(obj, value, jsonConv);
        }
        else {
            if (this.serializationProperty && !!obj[this.serializationProperty])
                obj[this.serializationProperty].setJson(value);
            else {
                if (value && typeof value === "string") {
                    if (this.type == "number") {
                        value = parseInt(value);
                    }
                    if (this.type == "boolean" || this.type == "switch") {
                        value = value.toLowerCase() === "true";
                    }
                }
                obj[this.name] = value;
            }
        }
    };
    JsonObjectProperty.prototype.getObjType = function (objType) {
        if (!this.classNamePart)
            return objType;
        return objType.replace(this.classNamePart, "");
    };
    JsonObjectProperty.prototype.getClassName = function (className) {
        if (className)
            className = className.toLowerCase();
        return this.classNamePart && className.indexOf(this.classNamePart) < 0
            ? className + this.classNamePart
            : className;
    };
    Object.defineProperty(JsonObjectProperty.prototype, "choices", {
        /**
         * Depricated, please use getChoices
         */
        get: function () {
            return this.getChoices(null);
        },
        enumerable: false,
        configurable: true
    });
    Object.defineProperty(JsonObjectProperty.prototype, "hasChoices", {
        get: function () {
            return !!this.choicesValue || !!this.choicesfunc;
        },
        enumerable: false,
        configurable: true
    });
    JsonObjectProperty.prototype.getChoices = function (obj, choicesCallback) {
        if (choicesCallback === void 0) { choicesCallback = null; }
        if (this.choicesValue != null)
            return this.choicesValue;
        if (this.choicesfunc != null)
            return this.choicesfunc(obj, choicesCallback);
        return null;
    };
    JsonObjectProperty.prototype.setChoices = function (value, valueFunc) {
        if (valueFunc === void 0) { valueFunc = null; }
        this.choicesValue = value;
        this.choicesfunc = valueFunc;
    };
    JsonObjectProperty.prototype.getBaseValue = function () {
        if (!this.baseValue)
            return "";
        if (typeof this.baseValue == "function")
            return this.baseValue();
        return this.baseValue;
    };
    JsonObjectProperty.prototype.setBaseValue = function (val) {
        this.baseValue = val;
    };
    Object.defineProperty(JsonObjectProperty.prototype, "readOnly", {
        get: function () {
            return this.readOnlyValue != null ? this.readOnlyValue : false;
        },
        set: function (val) {
            this.readOnlyValue = val;
        },
        enumerable: false,
        configurable: true
    });
    JsonObjectProperty.prototype.isVisible = function (layout, obj) {
        if (obj === void 0) { obj = null; }
        var isLayout = !this.layout || this.layout == layout;
        if (!this.visible || !isLayout)
            return false;
        if (!!this.visibleIf && !!obj)
            return this.visibleIf(obj);
        return true;
    };
    Object.defineProperty(JsonObjectProperty.prototype, "visible", {
        get: function () {
            return this.visibleValue != null ? this.visibleValue : true;
        },
        set: function (val) {
            this.visibleValue = val;
        },
        enumerable: false,
        configurable: true
    });
    Object.defineProperty(JsonObjectProperty.prototype, "isLocalizable", {
        get: function () {
            return this.isLocalizableValue != null ? this.isLocalizableValue : false;
        },
        set: function (val) {
            this.isLocalizableValue = val;
        },
        enumerable: false,
        configurable: true
    });
    Object.defineProperty(JsonObjectProperty.prototype, "dataList", {
        get: function () {
            return Array.isArray(this.dataListValue) ? this.dataListValue : [];
        },
        set: function (val) {
            this.dataListValue = val;
        },
        enumerable: false,
        configurable: true
    });
    JsonObjectProperty.prototype.mergeWith = function (prop) {
        var valuesNames = JsonObjectProperty.mergableValues;
        for (var i = 0; i < valuesNames.length; i++) {
            this.mergeValue(prop, valuesNames[i]);
        }
    };
    JsonObjectProperty.prototype.addDependedProperty = function (name) {
        if (!this.dependedProperties) {
            this.dependedProperties = [];
        }
        if (this.dependedProperties.indexOf(name) < 0) {
            this.dependedProperties.push(name);
        }
    };
    JsonObjectProperty.prototype.getDependedProperties = function () {
        return !!this.dependedProperties ? this.dependedProperties : [];
    };
    JsonObjectProperty.prototype.schemaType = function () {
        if (!!this.className)
            return "array";
        if (!!this.baseClassName)
            return "array";
        if (this.type == "boolean" || this.type == "number")
            return this.type;
        return "string";
    };
    JsonObjectProperty.prototype.mergeValue = function (prop, valueName) {
        if (this[valueName] == null && prop[valueName] != null) {
            this[valueName] = prop[valueName];
        }
    };
    JsonObjectProperty.Index = 1;
    JsonObjectProperty.mergableValues = [
        "typeValue",
        "choicesValue",
        "baseValue",
        "readOnlyValue",
        "visibleValue",
        "isSerializable",
        "isLightSerializable",
        "isCustom",
        "isBindable",
        "isUnique",
        "isDynamicChoices",
        "isLocalizableValue",
        "className",
        "alternativeName",
        "layout",
        "classNamePart",
        "baseClassName",
        "defaultValue",
        "serializationProperty",
        "onGetValue",
        "onSetValue",
        "displayName",
        "category",
        "categoryIndex",
        "visibleIndex",
        "nextToProperty",
        "showMode",
        "dependedProperties",
        "visibleIf",
        "onPropertyEditorUpdate",
        "maxLength",
        "maxValue",
        "minValue",
        "dataListValue",
    ];
    return JsonObjectProperty;
}());

var CustomPropertiesCollection = /** @class */ (function () {
    function CustomPropertiesCollection() {
    }
    CustomPropertiesCollection.addProperty = function (className, property) {
        className = className.toLowerCase();
        var props = CustomPropertiesCollection.properties;
        if (!props[className]) {
            props[className] = [];
        }
        props[className].push(property);
    };
    CustomPropertiesCollection.removeProperty = function (className, propertyName) {
        className = className.toLowerCase();
        var props = CustomPropertiesCollection.properties;
        if (!props[className])
            return;
        var properties = props[className];
        for (var i = 0; i < properties.length; i++) {
            if (properties[i].name == propertyName) {
                props[className].splice(i, 1);
                break;
            }
        }
    };
    CustomPropertiesCollection.addClass = function (className, parentClassName) {
        className = className.toLowerCase();
        if (parentClassName) {
            parentClassName = parentClassName.toLowerCase();
        }
        CustomPropertiesCollection.parentClasses[className] = parentClassName;
    };
    CustomPropertiesCollection.getProperties = function (className) {
        className = className.toLowerCase();
        var res = [];
        var props = CustomPropertiesCollection.properties;
        while (className) {
            var properties = props[className];
            if (properties) {
                for (var i = 0; i < properties.length; i++) {
                    res.push(properties[i]);
                }
            }
            className = CustomPropertiesCollection.parentClasses[className];
        }
        return res;
    };
    CustomPropertiesCollection.createProperties = function (obj) {
        if (!obj || !obj.getType)
            return;
        CustomPropertiesCollection.createPropertiesCore(obj, obj.getType());
    };
    CustomPropertiesCollection.createPropertiesCore = function (obj, className) {
        var props = CustomPropertiesCollection.properties;
        if (props[className]) {
            CustomPropertiesCollection.createPropertiesInObj(obj, props[className]);
        }
        var parentClass = CustomPropertiesCollection.parentClasses[className];
        if (parentClass) {
            CustomPropertiesCollection.createPropertiesCore(obj, parentClass);
        }
    };
    CustomPropertiesCollection.createPropertiesInObj = function (obj, properties) {
        for (var i = 0; i < properties.length; i++) {
            CustomPropertiesCollection.createPropertyInObj(obj, properties[i]);
        }
    };
    CustomPropertiesCollection.createPropertyInObj = function (obj, prop) {
        if (obj[prop.name] || obj.hasOwnProperty(prop.name))
            return;
        if (prop.isLocalizable &&
            prop.serializationProperty &&
            !obj[prop.serializationProperty] &&
            obj.createCustomLocalizableObj) {
            obj.createCustomLocalizableObj(prop.name);
            var locDesc = {
                get: function () {
                    return obj.getLocalizableString(prop.name);
                },
            };
            Object.defineProperty(obj, prop.serializationProperty, locDesc);
            var desc = {
                get: function () {
                    return obj.getLocalizableStringText(prop.name, prop.defaultValue);
                },
                set: function (v) {
                    obj.setLocalizableStringText(prop.name, v);
                },
            };
            Object.defineProperty(obj, prop.name, desc);
        }
        else {
            var defaultValue = prop.defaultValue;
            var isArrayProp = false;
            if (typeof obj.createNewArray === "function") {
                if (JsonObject.metaData.isDescendantOf(prop.className, "itemvalue")) {
                    obj.createNewArray(prop.name, function (item) {
                        item.locOwner = obj;
                        item.ownerPropertyName = prop.name;
                    });
                    isArrayProp = true;
                }
                //It is a simple array property
                if (prop.type === "multiplevalues") {
                    obj.createNewArray(prop.name);
                    isArrayProp = true;
                }
                if (isArrayProp) {
                    if (Array.isArray(defaultValue)) {
                        obj.setPropertyValue(prop.name, defaultValue);
                    }
                    defaultValue = null;
                }
            }
            if (!!obj.getPropertyValue && !!obj.setPropertyValue) {
                var desc = {
                    get: function () {
                        if (!!prop.onGetValue) {
                            return prop.onGetValue(obj);
                        }
                        return obj.getPropertyValue(prop.name, defaultValue);
                    },
                    set: function (v) {
                        if (!!prop.onSetValue) {
                            prop.onSetValue(obj, v, null);
                        }
                        else {
                            obj.setPropertyValue(prop.name, v);
                        }
                    },
                };
                Object.defineProperty(obj, prop.name, desc);
            }
        }
    };
    CustomPropertiesCollection.properties = {};
    CustomPropertiesCollection.parentClasses = {};
    return CustomPropertiesCollection;
}());

var JsonMetadataClass = /** @class */ (function () {
    function JsonMetadataClass(name, properties, creator, parentName) {
        if (creator === void 0) { creator = null; }
        if (parentName === void 0) { parentName = null; }
        this.name = name;
        this.creator = creator;
        this.parentName = parentName;
        this.properties = null;
        name = name.toLowerCase();
        if (this.parentName) {
            this.parentName = this.parentName.toLowerCase();
            CustomPropertiesCollection.addClass(name, this.parentName);
        }
        this.properties = new Array();
        for (var i = 0; i < properties.length; i++) {
            var prop = this.createProperty(properties[i]);
            if (prop) {
                this.properties.push(prop);
            }
        }
    }
    JsonMetadataClass.prototype.find = function (name) {
        for (var i = 0; i < this.properties.length; i++) {
            if (this.properties[i].name == name)
                return this.properties[i];
        }
        return null;
    };
    JsonMetadataClass.prototype.createProperty = function (propInfo) {
        var propertyName = typeof propInfo === "string" ? propInfo : propInfo.name;
        if (!propertyName)
            return;
        var propertyType = null;
        var typeIndex = propertyName.indexOf(JsonMetadataClass.typeSymbol);
        if (typeIndex > -1) {
            propertyType = propertyName.substring(typeIndex + 1);
            propertyName = propertyName.substring(0, typeIndex);
        }
        var isRequired = this.getIsPropertyNameRequired(propertyName) || !!propInfo.isRequired;
        propertyName = this.getPropertyName(propertyName);
        var prop = new JsonObjectProperty(this, propertyName, isRequired);
        if (propertyType) {
            prop.type = propertyType;
        }
        if (typeof propInfo === "object") {
            if (propInfo.type) {
                prop.type = propInfo.type;
            }
            if (!_helpers__WEBPACK_IMPORTED_MODULE_2__["Helpers"].isValueEmpty(propInfo.default)) {
                prop.defaultValue = propInfo.default;
            }
            if (!_helpers__WEBPACK_IMPORTED_MODULE_2__["Helpers"].isValueEmpty(propInfo.isSerializable)) {
                prop.isSerializable = propInfo.isSerializable;
            }
            if (!_helpers__WEBPACK_IMPORTED_MODULE_2__["Helpers"].isValueEmpty(propInfo.isLightSerializable)) {
                prop.isLightSerializable = propInfo.isLightSerializable;
            }
            if (!_helpers__WEBPACK_IMPORTED_MODULE_2__["Helpers"].isValueEmpty(propInfo.maxLength)) {
                prop.maxLength = propInfo.maxLength;
            }
            if (!_helpers__WEBPACK_IMPORTED_MODULE_2__["Helpers"].isValueEmpty(propInfo.displayName)) {
                prop.displayName = propInfo.displayName;
            }
            if (!_helpers__WEBPACK_IMPORTED_MODULE_2__["Helpers"].isValueEmpty(propInfo.category)) {
                prop.category = propInfo.category;
            }
            if (!_helpers__WEBPACK_IMPORTED_MODULE_2__["Helpers"].isValueEmpty(propInfo.categoryIndex)) {
                prop.categoryIndex = propInfo.categoryIndex;
            }
            if (!_helpers__WEBPACK_IMPORTED_MODULE_2__["Helpers"].isValueEmpty(propInfo.nextToProperty)) {
                prop.nextToProperty = propInfo.nextToProperty;
            }
            if (!_helpers__WEBPACK_IMPORTED_MODULE_2__["Helpers"].isValueEmpty(propInfo.visibleIndex)) {
                prop.visibleIndex = propInfo.visibleIndex;
            }
            if (!_helpers__WEBPACK_IMPORTED_MODULE_2__["Helpers"].isValueEmpty(propInfo.showMode)) {
                prop.showMode = propInfo.showMode;
            }
            if (!_helpers__WEBPACK_IMPORTED_MODULE_2__["Helpers"].isValueEmpty(propInfo.maxValue)) {
                prop.maxValue = propInfo.maxValue;
            }
            if (!_helpers__WEBPACK_IMPORTED_MODULE_2__["Helpers"].isValueEmpty(propInfo.minValue)) {
                prop.minValue = propInfo.minValue;
            }
            if (!_helpers__WEBPACK_IMPORTED_MODULE_2__["Helpers"].isValueEmpty(propInfo.dataList)) {
                prop.dataList = propInfo.dataList;
            }
            if (!_helpers__WEBPACK_IMPORTED_MODULE_2__["Helpers"].isValueEmpty(propInfo.isDynamicChoices)) {
                prop.isDynamicChoices = propInfo.isDynamicChoices;
            }
            if (!_helpers__WEBPACK_IMPORTED_MODULE_2__["Helpers"].isValueEmpty(propInfo.isBindable)) {
                prop.isBindable = propInfo.isBindable;
            }
            if (!_helpers__WEBPACK_IMPORTED_MODULE_2__["Helpers"].isValueEmpty(propInfo.isUnique)) {
                prop.isUnique = propInfo.isUnique;
            }
            if (propInfo.visible === true || propInfo.visible === false) {
                prop.visible = propInfo.visible;
            }
            if (!!propInfo.visibleIf) {
                prop.visibleIf = propInfo.visibleIf;
            }
            if (!!propInfo.onPropertyEditorUpdate) {
                prop.onPropertyEditorUpdate = propInfo.onPropertyEditorUpdate;
            }
            if (propInfo.readOnly === true) {
                prop.readOnly = true;
            }
            if (propInfo.choices) {
                var choicesFunc = typeof propInfo.choices === "function" ? propInfo.choices : null;
                var choicesValue = typeof propInfo.choices !== "function" ? propInfo.choices : null;
                prop.setChoices(choicesValue, choicesFunc);
            }
            if (!!propInfo.baseValue) {
                prop.setBaseValue(propInfo.baseValue);
            }
            if (propInfo.onGetValue) {
                prop.onGetValue = propInfo.onGetValue;
            }
            if (propInfo.onSetValue) {
                prop.onSetValue = propInfo.onSetValue;
            }
            if (propInfo.isLocalizable) {
                propInfo.serializationProperty = "loc" + prop.name;
            }
            if (propInfo.serializationProperty) {
                prop.serializationProperty = propInfo.serializationProperty;
                var s;
                if (prop.serializationProperty &&
                    prop.serializationProperty.indexOf("loc") == 0) {
                    prop.isLocalizable = true;
                }
            }
            if (propInfo.isLocalizable) {
                prop.isLocalizable = propInfo.isLocalizable;
            }
            if (propInfo.className) {
                prop.className = propInfo.className;
            }
            if (propInfo.baseClassName) {
                prop.baseClassName = propInfo.baseClassName;
            }
            if (propInfo.classNamePart) {
                prop.classNamePart = propInfo.classNamePart;
            }
            if (propInfo.alternativeName) {
                prop.alternativeName = propInfo.alternativeName;
            }
            if (propInfo.layout) {
                prop.layout = propInfo.layout;
            }
            if (propInfo.dependsOn) {
                this.addDependsOnProperties(prop, propInfo.dependsOn);
            }
        }
        return prop;
    };
    JsonMetadataClass.prototype.addDependsOnProperties = function (prop, dependsOn) {
        if (Array.isArray(dependsOn)) {
            for (var i = 0; i < dependsOn.length; i++) {
                this.addDependsOnProperty(prop, dependsOn[i]);
            }
        }
        else {
            this.addDependsOnProperty(prop, dependsOn);
        }
    };
    JsonMetadataClass.prototype.addDependsOnProperty = function (prop, dependsOn) {
        var property = this.find(dependsOn);
        if (!property) {
            property = Serializer.findProperty(this.parentName, dependsOn);
        }
        if (!property)
            return;
        property.addDependedProperty(prop.name);
    };
    JsonMetadataClass.prototype.getIsPropertyNameRequired = function (propertyName) {
        return (propertyName.length > 0 &&
            propertyName[0] == JsonMetadataClass.requiredSymbol);
    };
    JsonMetadataClass.prototype.getPropertyName = function (propertyName) {
        if (!this.getIsPropertyNameRequired(propertyName))
            return propertyName;
        propertyName = propertyName.slice(1);
        return propertyName;
    };
    JsonMetadataClass.requiredSymbol = "!";
    JsonMetadataClass.typeSymbol = ":";
    return JsonMetadataClass;
}());

/**
 * The metadata object. It contains object properties' runtime information and allows you to modify it.
 */
var JsonMetadata = /** @class */ (function () {
    function JsonMetadata() {
        this.classes = {};
        this.alternativeNames = {};
        this.childrenClasses = {};
        this.classProperties = {};
        this.classHashProperties = {};
    }
    JsonMetadata.prototype.getObjPropertyValue = function (obj, name) {
        if (this.isObjWrapper(obj)) {
            var orignalObj = obj.getOriginalObj();
            var prop = Serializer.findProperty(orignalObj.getType(), name);
            if (!!prop)
                return this.getObjPropertyValueCore(orignalObj, prop);
        }
        var prop = Serializer.findProperty(obj.getType(), name);
        if (!prop)
            return obj[name];
        return this.getObjPropertyValueCore(obj, prop);
    };
    JsonMetadata.prototype.setObjPropertyValue = function (obj, name, val) {
        if (obj[name] === val)
            return;
        if (!!obj[name] && !!obj[name].setJson) {
            obj[name].setJson(val);
        }
        else {
            obj[name] = val;
        }
    };
    JsonMetadata.prototype.getObjPropertyValueCore = function (obj, prop) {
        if (!prop.isSerializable)
            return obj[prop.name];
        if (prop.isLocalizable) {
            if (prop.isArray)
                return obj[prop.name];
            if (!!prop.serializationProperty)
                return obj[prop.serializationProperty].text;
        }
        return obj.getPropertyValue(prop.name);
    };
    JsonMetadata.prototype.isObjWrapper = function (obj) {
        return !!obj.getOriginalObj && !!obj.getOriginalObj();
    };
    JsonMetadata.prototype.addClass = function (name, properties, creator, parentName) {
        if (creator === void 0) { creator = null; }
        if (parentName === void 0) { parentName = null; }
        name = name.toLowerCase();
        var metaDataClass = new JsonMetadataClass(name, properties, creator, parentName);
        this.classes[name] = metaDataClass;
        if (parentName) {
            parentName = parentName.toLowerCase();
            var children = this.childrenClasses[parentName];
            if (!children) {
                this.childrenClasses[parentName] = [];
            }
            this.childrenClasses[parentName].push(metaDataClass);
        }
        return metaDataClass;
    };
    JsonMetadata.prototype.removeClass = function (name) {
        var metaClass = this.findClass(name);
        if (!metaClass)
            return;
        delete this.classes[metaClass.name];
        if (!!metaClass.parentName) {
            var index = this.childrenClasses[metaClass.parentName].indexOf(metaClass);
            if (index > -1) {
                this.childrenClasses[metaClass.parentName].splice(index, 1);
            }
        }
    };
    JsonMetadata.prototype.overrideClassCreatore = function (name, creator) {
        this.overrideClassCreator(name, creator);
    };
    JsonMetadata.prototype.overrideClassCreator = function (name, creator) {
        name = name.toLowerCase();
        var metaDataClass = this.findClass(name);
        if (metaDataClass) {
            metaDataClass.creator = creator;
        }
    };
    JsonMetadata.prototype.getProperties = function (className) {
        var metaClass = this.findClass(className);
        if (!metaClass)
            return [];
        var properties = this.classProperties[metaClass.name];
        if (!!properties)
            return properties;
        this.fillPropertiesForClass(metaClass.name);
        return this.classProperties[metaClass.name];
    };
    JsonMetadata.prototype.getHashProperties = function (className) {
        var metaClass = this.findClass(className);
        if (!metaClass)
            return {};
        var properties = this.classHashProperties[metaClass.name];
        if (!!properties)
            return properties;
        this.fillPropertiesForClass(metaClass.name);
        return this.classHashProperties[metaClass.name];
    };
    JsonMetadata.prototype.fillPropertiesForClass = function (className) {
        var properties = new Array();
        var hashProperties = {};
        this.fillProperties(className, properties, hashProperties);
        this.classProperties[className] = properties;
        this.classHashProperties[className] = hashProperties;
    };
    JsonMetadata.prototype.getPropertiesByObj = function (obj) {
        if (!obj || !obj.getType)
            return [];
        var res = {};
        var props = this.getProperties(obj.getType());
        for (var i = 0; i < props.length; i++) {
            res[props[i].name] = props[i];
        }
        var dynamicProps = !!obj.getDynamicType
            ? this.getProperties(obj.getDynamicType())
            : null;
        if (dynamicProps && dynamicProps.length > 0) {
            for (var i = 0; i < dynamicProps.length; i++) {
                var dProp = dynamicProps[i];
                if (!!res[dProp.name])
                    continue;
                res[dProp.name] = dProp;
            }
        }
        return Object.keys(res).map(function (key) { return res[key]; });
    };
    JsonMetadata.prototype.getDynamicPropertiesByObj = function (obj, dynamicType) {
        if (dynamicType === void 0) { dynamicType = null; }
        if (!obj || !obj.getType || (!obj.getDynamicType && !dynamicType))
            return [];
        var dType = !!dynamicType ? dynamicType : obj.getDynamicType();
        if (!dType)
            return [];
        var dynamicProps = this.getProperties(dType);
        if (!dynamicProps || dynamicProps.length == 0)
            return [];
        var hash = {};
        var props = this.getProperties(obj.getType());
        for (var i = 0; i < props.length; i++) {
            hash[props[i].name] = props[i];
        }
        var res = [];
        for (var i = 0; i < dynamicProps.length; i++) {
            var dProp = dynamicProps[i];
            if (!hash[dProp.name]) {
                res.push(dProp);
            }
        }
        return res;
    };
    JsonMetadata.prototype.hasOriginalProperty = function (obj, propName) {
        return !!this.getOriginalProperty(obj, propName);
    };
    JsonMetadata.prototype.getOriginalProperty = function (obj, propName) {
        var res = this.findProperty(obj.getType(), propName);
        if (!!res)
            return res;
        if (this.isObjWrapper(obj))
            return this.findProperty(obj.getOriginalObj().getType(), propName);
        return null;
    };
    JsonMetadata.prototype.getProperty = function (className, propertyName) {
        var prop = this.findProperty(className, propertyName);
        if (!prop)
            return prop;
        var classInfo = this.findClass(className);
        if (prop.classInfo === classInfo)
            return prop;
        var newProp = new JsonObjectProperty(classInfo, propertyName, prop.isRequired);
        newProp.mergeWith(prop);
        classInfo.properties.push(newProp);
        this.emptyClassPropertiesHash(classInfo);
        return newProp;
    };
    JsonMetadata.prototype.findProperty = function (className, propertyName) {
        var hash = this.getHashProperties(className);
        var res = hash[propertyName];
        return !!res ? res : null;
    };
    JsonMetadata.prototype.findProperties = function (className, propertyNames) {
        var result = [];
        var hash = this.getHashProperties(className);
        for (var i = 0; i < propertyNames.length; i++) {
            var prop = hash[propertyNames[i]];
            if (prop) {
                result.push(prop);
            }
        }
        return result;
    };
    JsonMetadata.prototype.getAllPropertiesByName = function (propertyName) {
        var res = new Array();
        var classes = this.getAllClasses();
        for (var i = 0; i < classes.length; i++) {
            var classInfo = this.findClass(classes[i]);
            for (var j = 0; j < classInfo.properties.length; j++) {
                if (classInfo.properties[j].name == propertyName) {
                    res.push(classInfo.properties[j]);
                    break;
                }
            }
        }
        return res;
    };
    JsonMetadata.prototype.getAllClasses = function () {
        var res = new Array();
        for (var name in this.classes) {
            res.push(name);
        }
        return res;
    };
    JsonMetadata.prototype.createClass = function (name, json) {
        if (json === void 0) { json = undefined; }
        name = name.toLowerCase();
        var metaDataClass = this.findClass(name);
        if (!metaDataClass)
            return null;
        if (metaDataClass.creator)
            return metaDataClass.creator(json);
        var parentName = metaDataClass.parentName;
        while (parentName) {
            metaDataClass = this.findClass(parentName);
            if (!metaDataClass)
                return null;
            parentName = metaDataClass.parentName;
            if (metaDataClass.creator)
                return this.createCustomType(name, metaDataClass.creator, json);
        }
        return null;
    };
    JsonMetadata.prototype.createCustomType = function (name, creator, json) {
        if (json === void 0) { json = undefined; }
        name = name.toLowerCase();
        var res = creator(json);
        var customTypeName = name;
        var customTemplateName = res.getTemplate
            ? res.getTemplate()
            : res.getType();
        res.getType = function () {
            return customTypeName;
        };
        res.getTemplate = function () {
            return customTemplateName;
        };
        CustomPropertiesCollection.createProperties(res);
        return res;
    };
    JsonMetadata.prototype.getChildrenClasses = function (name, canBeCreated) {
        if (canBeCreated === void 0) { canBeCreated = false; }
        name = name.toLowerCase();
        var result = [];
        this.fillChildrenClasses(name, canBeCreated, result);
        return result;
    };
    JsonMetadata.prototype.getRequiredProperties = function (name) {
        var properties = this.getProperties(name);
        var res = [];
        for (var i = 0; i < properties.length; i++) {
            if (properties[i].isRequired) {
                res.push(properties[i].name);
            }
        }
        return res;
    };
    JsonMetadata.prototype.addProperties = function (className, propertiesInfos) {
        className = className.toLowerCase();
        var metaDataClass = this.findClass(className);
        for (var i = 0; i < propertiesInfos.length; i++) {
            this.addCustomPropertyCore(metaDataClass, propertiesInfos[i]);
        }
    };
    JsonMetadata.prototype.addProperty = function (className, propertyInfo) {
        return this.addCustomPropertyCore(this.findClass(className), propertyInfo);
    };
    JsonMetadata.prototype.addCustomPropertyCore = function (metaDataClass, propertyInfo) {
        if (!metaDataClass)
            return null;
        var property = metaDataClass.createProperty(propertyInfo);
        if (property) {
            property.isCustom = true;
            this.addPropertyToClass(metaDataClass, property);
            this.emptyClassPropertiesHash(metaDataClass);
            CustomPropertiesCollection.addProperty(metaDataClass.name, property);
        }
        return property;
    };
    JsonMetadata.prototype.removeProperty = function (className, propertyName) {
        var metaDataClass = this.findClass(className);
        if (!metaDataClass)
            return false;
        var property = metaDataClass.find(propertyName);
        if (property) {
            this.removePropertyFromClass(metaDataClass, property);
            this.emptyClassPropertiesHash(metaDataClass);
            CustomPropertiesCollection.removeProperty(metaDataClass.name, propertyName);
        }
    };
    JsonMetadata.prototype.addPropertyToClass = function (metaDataClass, property) {
        if (metaDataClass.find(property.name) != null)
            return;
        metaDataClass.properties.push(property);
    };
    JsonMetadata.prototype.removePropertyFromClass = function (metaDataClass, property) {
        var index = metaDataClass.properties.indexOf(property);
        if (index < 0)
            return;
        metaDataClass.properties.splice(index, 1);
    };
    JsonMetadata.prototype.emptyClassPropertiesHash = function (metaDataClass) {
        this.classProperties[metaDataClass.name] = null;
        this.classHashProperties[metaDataClass.name] = null;
        var childClasses = this.getChildrenClasses(metaDataClass.name);
        for (var i = 0; i < childClasses.length; i++) {
            this.classProperties[childClasses[i].name] = null;
            this.classHashProperties[childClasses[i].name] = null;
        }
    };
    JsonMetadata.prototype.fillChildrenClasses = function (name, canBeCreated, result) {
        var children = this.childrenClasses[name];
        if (!children)
            return;
        for (var i = 0; i < children.length; i++) {
            if (!canBeCreated || children[i].creator) {
                result.push(children[i]);
            }
            this.fillChildrenClasses(children[i].name, canBeCreated, result);
        }
    };
    JsonMetadata.prototype.findClass = function (name) {
        name = name.toLowerCase();
        var res = this.classes[name];
        if (!res) {
            var newName = this.alternativeNames[name];
            if (!!newName && newName != name)
                return this.findClass(newName);
        }
        return res;
    };
    JsonMetadata.prototype.isDescendantOf = function (className, ancestorClassName) {
        if (!className || !ancestorClassName) {
            return false;
        }
        className = className.toLowerCase();
        ancestorClassName = ancestorClassName.toLowerCase();
        var class_ = this.findClass(className);
        if (!class_) {
            return false;
        }
        var parentClass = class_;
        do {
            if (parentClass.name === ancestorClassName) {
                return true;
            }
            parentClass = this.classes[parentClass.parentName];
        } while (!!parentClass);
        return false;
    };
    JsonMetadata.prototype.addAlterNativeClassName = function (name, alternativeName) {
        this.alternativeNames[alternativeName.toLowerCase()] = name.toLowerCase();
    };
    JsonMetadata.prototype.generateSchema = function (className) {
        if (className === void 0) { className = undefined; }
        if (!className)
            className = "survey";
        var classInfo = this.findClass(className);
        if (!classInfo)
            return null;
        var res = {
            $schema: "http://json-schema.org/draft-07/schema#",
            title: "SurveyJS Library json schema",
            type: "object",
            properties: {},
            definitions: {},
        };
        this.generateSchemaProperties(classInfo, res.properties, res.definitions);
        return res;
    };
    JsonMetadata.prototype.generateSchemaProperties = function (classInfo, schemaProperties, schemaDef) {
        if (!classInfo)
            return;
        for (var i = 0; i < classInfo.properties.length; i++) {
            var prop = classInfo.properties[i];
            schemaProperties[prop.name] = this.generateSchemaProperty(prop, schemaDef);
        }
    };
    JsonMetadata.prototype.generateSchemaProperty = function (prop, schemaDef) {
        var res = { type: prop.schemaType() };
        if (prop.hasChoices) {
            res.enum = prop.getChoices(null);
        }
        if (!!prop.className) {
            res.items = { $ref: "#" + prop.className };
            this.generateChemaClass(prop.className, schemaDef);
        }
        if (!!prop.baseClassName) {
            var usedClasses = this.getChildrenClasses(prop.baseClassName, true);
            if (prop.baseClassName == "question") {
                usedClasses.push(this.findClass("panel"));
            }
            res.items = [];
            for (var i = 0; i < usedClasses.length; i++) {
                var className = usedClasses[i].name;
                res.items.push({ $ref: "#" + className });
                this.generateChemaClass(className, schemaDef);
            }
        }
        return res;
    };
    JsonMetadata.prototype.generateChemaClass = function (className, schemaDef) {
        if (!!schemaDef[className])
            return;
        var classInfo = this.findClass(className);
        if (!classInfo)
            return;
        var hasParent = !!classInfo.parentName && classInfo.parentName != "base";
        if (hasParent) {
            this.generateChemaClass(classInfo.parentName, schemaDef);
        }
        var res = { type: "object", $id: "#" + className };
        schemaDef[className] = res;
        var props = {};
        this.generateSchemaProperties(classInfo, props, schemaDef);
        if (hasParent) {
            res.allOff = [
                { $ref: "#" + classInfo.parentName },
                { properties: props },
            ];
        }
        else {
            res.properties = props;
        }
    };
    JsonMetadata.prototype.fillProperties = function (name, list, hash) {
        var metaDataClass = this.findClass(name);
        if (!metaDataClass)
            return;
        if (metaDataClass.parentName) {
            this.fillProperties(metaDataClass.parentName, list, hash);
        }
        for (var i = 0; i < metaDataClass.properties.length; i++) {
            var prop = metaDataClass.properties[i];
            this.addPropertyCore(prop, list, hash);
            hash[prop.name] = prop;
        }
    };
    JsonMetadata.prototype.addPropertyCore = function (property, list, hash) {
        if (!hash[property.name]) {
            list.push(property);
            return;
        }
        var index = -1;
        for (var i = 0; i < list.length; i++) {
            if (list[i].name == property.name) {
                index = i;
                break;
            }
        }
        property.mergeWith(list[index]);
        list[index] = property;
    };
    return JsonMetadata;
}());

var JsonError = /** @class */ (function () {
    function JsonError(type, message) {
        this.type = type;
        this.message = message;
        this.description = "";
        this.at = -1;
    }
    JsonError.prototype.getFullDescription = function () {
        return this.message + (this.description ? "\n" + this.description : "");
    };
    return JsonError;
}());

var JsonUnknownPropertyError = /** @class */ (function (_super) {
    __extends(JsonUnknownPropertyError, _super);
    function JsonUnknownPropertyError(propertyName, className) {
        var _this = _super.call(this, "unknownproperty", "The property '" +
            propertyName +
            "' in class '" +
            className +
            "' is unknown.") || this;
        _this.propertyName = propertyName;
        _this.className = className;
        var properties = JsonObject.metaData.getProperties(className);
        if (properties) {
            _this.description = "The list of available properties are: ";
            for (var i = 0; i < properties.length; i++) {
                if (i > 0)
                    _this.description += ", ";
                _this.description += properties[i].name;
            }
            _this.description += ".";
        }
        return _this;
    }
    return JsonUnknownPropertyError;
}(JsonError));

var JsonMissingTypeErrorBase = /** @class */ (function (_super) {
    __extends(JsonMissingTypeErrorBase, _super);
    function JsonMissingTypeErrorBase(baseClassName, type, message) {
        var _this = _super.call(this, type, message) || this;
        _this.baseClassName = baseClassName;
        _this.type = type;
        _this.message = message;
        _this.description = "The following types are available: ";
        var types = JsonObject.metaData.getChildrenClasses(baseClassName, true);
        for (var i = 0; i < types.length; i++) {
            if (i > 0)
                _this.description += ", ";
            _this.description += "'" + types[i].name + "'";
        }
        _this.description += ".";
        return _this;
    }
    return JsonMissingTypeErrorBase;
}(JsonError));

var JsonMissingTypeError = /** @class */ (function (_super) {
    __extends(JsonMissingTypeError, _super);
    function JsonMissingTypeError(propertyName, baseClassName) {
        var _this = _super.call(this, baseClassName, "missingtypeproperty", "The property type is missing in the object. Please take a look at property: '" +
            propertyName +
            "'.") || this;
        _this.propertyName = propertyName;
        _this.baseClassName = baseClassName;
        return _this;
    }
    return JsonMissingTypeError;
}(JsonMissingTypeErrorBase));

var JsonIncorrectTypeError = /** @class */ (function (_super) {
    __extends(JsonIncorrectTypeError, _super);
    function JsonIncorrectTypeError(propertyName, baseClassName) {
        var _this = _super.call(this, baseClassName, "incorrecttypeproperty", "The property type is incorrect in the object. Please take a look at property: '" +
            propertyName +
            "'.") || this;
        _this.propertyName = propertyName;
        _this.baseClassName = baseClassName;
        return _this;
    }
    return JsonIncorrectTypeError;
}(JsonMissingTypeErrorBase));

var JsonRequiredPropertyError = /** @class */ (function (_super) {
    __extends(JsonRequiredPropertyError, _super);
    function JsonRequiredPropertyError(propertyName, className) {
        var _this = _super.call(this, "requiredproperty", "The property '" +
            propertyName +
            "' is required in class '" +
            className +
            "'.") || this;
        _this.propertyName = propertyName;
        _this.className = className;
        return _this;
    }
    return JsonRequiredPropertyError;
}(JsonError));

var JsonObject = /** @class */ (function () {
    function JsonObject() {
        this.errors = new Array();
        this.lightSerializing = false;
    }
    Object.defineProperty(JsonObject, "metaData", {
        get: function () {
            return JsonObject.metaDataValue;
        },
        enumerable: false,
        configurable: true
    });
    JsonObject.prototype.toJsonObject = function (obj, storeDefaults) {
        if (storeDefaults === void 0) { storeDefaults = false; }
        return this.toJsonObjectCore(obj, null, storeDefaults);
    };
    JsonObject.prototype.toObject = function (jsonObj, obj) {
        this.toObjectCore(jsonObj, obj);
        var error = this.getRequiredError(obj, jsonObj);
        if (!!error) {
            this.addNewError(error, jsonObj);
        }
    };
    JsonObject.prototype.toObjectCore = function (jsonObj, obj) {
        if (!jsonObj)
            return;
        var properties = null;
        var objType = undefined;
        var needAddErrors = true;
        if (obj.getType) {
            objType = obj.getType();
            properties = JsonObject.metaData.getProperties(objType);
            needAddErrors =
                !!objType && !JsonObject.metaData.isDescendantOf(objType, "itemvalue");
        }
        if (!properties)
            return;
        if (obj.startLoadingFromJson) {
            obj.startLoadingFromJson();
        }
        properties = this.addDynamicProperties(obj, jsonObj, properties);
        for (var key in jsonObj) {
            if (key === JsonObject.typePropertyName)
                continue;
            if (key === JsonObject.positionPropertyName) {
                obj[key] = jsonObj[key];
                continue;
            }
            var property = this.findProperty(properties, key);
            if (!property) {
                if (needAddErrors) {
                    this.addNewError(new JsonUnknownPropertyError(key.toString(), objType), jsonObj);
                }
                continue;
            }
            this.valueToObj(jsonObj[key], obj, property);
        }
        if (obj.endLoadingFromJson) {
            obj.endLoadingFromJson();
        }
    };
    JsonObject.prototype.toJsonObjectCore = function (obj, property, storeDefaults) {
        if (storeDefaults === void 0) { storeDefaults = false; }
        if (!obj || !obj.getType)
            return obj;
        if (typeof obj.getData === "function")
            return obj.getData();
        var result = {};
        if (property != null && !property.className) {
            result[JsonObject.typePropertyName] = property.getObjType(obj.getType());
        }
        this.propertiesToJson(obj, JsonObject.metaData.getProperties(obj.getType()), result, storeDefaults);
        this.propertiesToJson(obj, this.getDynamicProperties(obj), result, storeDefaults);
        return result;
    };
    JsonObject.prototype.getDynamicProperties = function (obj) {
        return Serializer.getDynamicPropertiesByObj(obj);
    };
    JsonObject.prototype.addDynamicProperties = function (obj, jsonObj, properties) {
        if (!obj.getDynamicPropertyName)
            return properties;
        var dynamicPropName = obj.getDynamicPropertyName();
        if (!dynamicPropName)
            return properties;
        if (jsonObj[dynamicPropName]) {
            obj[dynamicPropName] = jsonObj[dynamicPropName];
        }
        var dynamicProperties = this.getDynamicProperties(obj);
        var res = [];
        for (var i = 0; i < properties.length; i++) {
            res.push(properties[i]);
        }
        for (var i = 0; i < dynamicProperties.length; i++) {
            res.push(dynamicProperties[i]);
        }
        return res;
    };
    JsonObject.prototype.propertiesToJson = function (obj, properties, json, storeDefaults) {
        if (storeDefaults === void 0) { storeDefaults = false; }
        for (var i = 0; i < properties.length; i++) {
            this.valueToJson(obj, json, properties[i], storeDefaults);
        }
    };
    JsonObject.prototype.valueToJson = function (obj, result, property, storeDefaults) {
        if (storeDefaults === void 0) { storeDefaults = false; }
        if (property.isSerializable === false ||
            (property.isLightSerializable === false && this.lightSerializing))
            return;
        var value = property.getValue(obj);
        if (!storeDefaults && property.isDefaultValue(value))
            return;
        if (this.isValueArray(value)) {
            var arrValue = [];
            for (var i = 0; i < value.length; i++) {
                arrValue.push(this.toJsonObjectCore(value[i], property, storeDefaults));
            }
            value = arrValue.length > 0 ? arrValue : null;
        }
        else {
            value = this.toJsonObjectCore(value, property, storeDefaults);
        }
        var hasValue = typeof obj["getPropertyValue"] === "function" &&
            obj["getPropertyValue"](property.name, null) !== null;
        if ((storeDefaults && hasValue) || !property.isDefaultValue(value)) {
            result[property.name] = value;
        }
    };
    JsonObject.prototype.valueToObj = function (value, obj, property) {
        if (value == null)
            return;
        this.removePos(property, value);
        if (property != null && property.hasToUseSetValue) {
            property.setValue(obj, value, this);
            return;
        }
        if (this.isValueArray(value)) {
            this.valueToArray(value, obj, property.name, property);
            return;
        }
        var newObj = this.createNewObj(value, property);
        if (newObj.newObj) {
            this.toObjectCore(value, newObj.newObj);
            value = newObj.newObj;
        }
        if (!newObj.error) {
            if (property != null) {
                property.setValue(obj, value, this);
            }
            else {
                obj[property.name] = value;
            }
        }
    };
    JsonObject.prototype.removePos = function (property, value) {
        if (!property || !property.type || property.type.indexOf("value") < 0)
            return;
        this.removePosFromObj(value);
    };
    JsonObject.prototype.removePosFromObj = function (obj) {
        if (!obj)
            return;
        if (Array.isArray(obj)) {
            for (var i = 0; i < obj.length; i++) {
                this.removePosFromObj(obj[i]);
            }
        }
        if (!!obj[JsonObject.positionPropertyName]) {
            delete obj[JsonObject.positionPropertyName];
        }
    };
    JsonObject.prototype.isValueArray = function (value) {
        return value && Array.isArray(value);
    };
    JsonObject.prototype.createNewObj = function (value, property) {
        var result = { newObj: null, error: null };
        var className = value[JsonObject.typePropertyName];
        if (!className && property != null && property.className) {
            className = property.className;
        }
        className = property.getClassName(className);
        result.newObj = className
            ? JsonObject.metaData.createClass(className, value)
            : null;
        result.error = this.checkNewObjectOnErrors(result.newObj, value, property, className);
        return result;
    };
    JsonObject.prototype.checkNewObjectOnErrors = function (newObj, value, property, className) {
        var error = null;
        if (newObj) {
            error = this.getRequiredError(newObj, value);
        }
        else {
            if (property.baseClassName) {
                if (!className) {
                    error = new JsonMissingTypeError(property.name, property.baseClassName);
                }
                else {
                    error = new JsonIncorrectTypeError(property.name, property.baseClassName);
                }
            }
        }
        if (error) {
            this.addNewError(error, value);
        }
        return error;
    };
    JsonObject.prototype.getRequiredError = function (obj, jsonValue) {
        if (!obj.getType || typeof obj.getData === "function")
            return null;
        var className = obj.getType();
        var requiredProperties = JsonObject.metaData.getRequiredProperties(className);
        if (!requiredProperties)
            return null;
        for (var i = 0; i < requiredProperties.length; i++) {
            if (!jsonValue[requiredProperties[i]]) {
                return new JsonRequiredPropertyError(requiredProperties[i], className);
            }
        }
        return null;
    };
    JsonObject.prototype.addNewError = function (error, jsonObj) {
        if (jsonObj && jsonObj[JsonObject.positionPropertyName]) {
            error.at = jsonObj[JsonObject.positionPropertyName].start;
        }
        this.errors.push(error);
    };
    JsonObject.prototype.valueToArray = function (value, obj, key, property) {
        if (obj[key] && value.length > 0)
            obj[key].splice(0, obj[key].length);
        var valueRes = obj[key] ? obj[key] : [];
        this.addValuesIntoArray(value, valueRes, property);
        if (!obj[key])
            obj[key] = valueRes;
    };
    JsonObject.prototype.addValuesIntoArray = function (value, result, property) {
        for (var i = 0; i < value.length; i++) {
            var newValue = this.createNewObj(value[i], property);
            if (newValue.newObj) {
                if (!!value[i].name) {
                    newValue.newObj.name = value[i].name;
                }
                result.push(newValue.newObj);
                this.toObjectCore(value[i], newValue.newObj);
            }
            else {
                if (!newValue.error) {
                    result.push(value[i]);
                }
            }
        }
    };
    JsonObject.prototype.findProperty = function (properties, key) {
        if (!properties)
            return null;
        for (var i = 0; i < properties.length; i++) {
            var prop = properties[i];
            if (prop.name == key || prop.alternativeName == key)
                return prop;
        }
        return null;
    };
    JsonObject.typePropertyName = "type";
    JsonObject.positionPropertyName = "pos";
    JsonObject.metaDataValue = new JsonMetadata();
    return JsonObject;
}());

/**
 * An alias for the metadata object. It contains object properties' runtime information and allows you to modify it.
 * @see JsonMetadata
 */
var Serializer = JsonObject.metaData;


/***/ }),

/***/ "./src/list.ts":
/*!*********************!*\
  !*** ./src/list.ts ***!
  \*********************/
/*! exports provided: ListModel */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "ListModel", function() { return ListModel; });
/* harmony import */ var _jsonobject__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./jsonobject */ "./src/jsonobject.ts");
/* harmony import */ var _actions_container__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ./actions/container */ "./src/actions/container.ts");
/* harmony import */ var _utils_cssClassBuilder__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ./utils/cssClassBuilder */ "./src/utils/cssClassBuilder.ts");
/* harmony import */ var _surveyStrings__WEBPACK_IMPORTED_MODULE_3__ = __webpack_require__(/*! ./surveyStrings */ "./src/surveyStrings.ts");
var __extends = (undefined && undefined.__extends) || (function () {
    var extendStatics = function (d, b) {
        extendStatics = Object.setPrototypeOf ||
            ({ __proto__: [] } instanceof Array && function (d, b) { d.__proto__ = b; }) ||
            function (d, b) { for (var p in b) if (Object.prototype.hasOwnProperty.call(b, p)) d[p] = b[p]; };
        return extendStatics(d, b);
    };
    return function (d, b) {
        if (typeof b !== "function" && b !== null)
            throw new TypeError("Class extends value " + String(b) + " is not a constructor or null");
        extendStatics(d, b);
        function __() { this.constructor = d; }
        d.prototype = b === null ? Object.create(b) : (__.prototype = b.prototype, new __());
    };
})();
var __decorate = (undefined && undefined.__decorate) || function (decorators, target, key, desc) {
    var c = arguments.length, r = c < 3 ? target : desc === null ? desc = Object.getOwnPropertyDescriptor(target, key) : desc, d;
    if (typeof Reflect === "object" && typeof Reflect.decorate === "function") r = Reflect.decorate(decorators, target, key, desc);
    else for (var i = decorators.length - 1; i >= 0; i--) if (d = decorators[i]) r = (c < 3 ? d(r) : c > 3 ? d(target, key, r) : d(target, key)) || r;
    return c > 3 && r && Object.defineProperty(target, key, r), r;
};




var ListModel = /** @class */ (function (_super) {
    __extends(ListModel, _super);
    function ListModel(items, onItemSelect, allowSelection, selectedItem, onFilteredTextChange) {
        var _this = _super.call(this) || this;
        _this.onItemSelect = onItemSelect;
        _this.allowSelection = allowSelection;
        _this.onFilteredTextChange = onFilteredTextChange;
        _this.selectItem = function (itemValue) {
            _this.isExpanded = false;
            if (_this.allowSelection) {
                _this.selectedItem = itemValue;
            }
            if (!!_this.onItemSelect) {
                _this.onItemSelect(itemValue);
            }
        };
        _this.isItemDisabled = function (itemValue) {
            return itemValue.enabled !== undefined && !itemValue.enabled;
        };
        _this.isItemSelected = function (itemValue) {
            return !!_this.allowSelection && !!_this.selectedItem && _this.selectedItem.id == itemValue.id;
        };
        _this.getItemClass = function (itemValue) {
            return new _utils_cssClassBuilder__WEBPACK_IMPORTED_MODULE_2__["CssClassBuilder"]()
                .append("sv-list__item")
                .append("sv-list__item--disabled", _this.isItemDisabled(itemValue))
                .append("sv-list__item--selected", _this.isItemSelected(itemValue))
                .toString();
        };
        _this.getItemIndent = function (itemValue) {
            var level = itemValue.level || 0;
            return (level + 1) * ListModel.INDENT + "px";
        };
        _this.setItems(items);
        _this.selectedItem = selectedItem;
        return _this;
    }
    ListModel.prototype.hasText = function (item, filteredTextInLow) {
        if (!filteredTextInLow)
            return true;
        var textInLow = (item.title || "").toLocaleLowerCase();
        return textInLow.indexOf(filteredTextInLow.toLocaleLowerCase()) > -1;
    };
    ListModel.prototype.updateItemVisible = function (text) {
        var _this = this;
        this.actions.forEach(function (item) {
            item.visible = _this.hasText(item, text);
        });
    };
    ListModel.prototype.filterByText = function (text) {
        if (!this.needFilter)
            return;
        if (!!this.onFilteredTextChange) {
            this.onFilteredTextChange(text);
        }
        else {
            this.updateItemVisible(text);
        }
    };
    ListModel.prototype.onSet = function () {
        this.needFilter = (this.actions || []).length > ListModel.MINELEMENTCOUNT;
        _super.prototype.onSet.call(this);
    };
    Object.defineProperty(ListModel.prototype, "filteredTextPlaceholder", {
        get: function () {
            return _surveyStrings__WEBPACK_IMPORTED_MODULE_3__["surveyLocalization"].getString("filteredTextPlaceholder");
        },
        enumerable: false,
        configurable: true
    });
    ListModel.prototype.onKeyDown = function (event) {
        var currentElement = event.target;
        if (event.key === "ArrowDown" || event.keyCode === 40) {
            if (!!currentElement.nextElementSibling) {
                currentElement.nextElementSibling.focus();
            }
            else {
                currentElement.parentElement.firstElementChild && currentElement.parentElement.firstElementChild.focus();
            }
            event.preventDefault();
        }
        else if (event.key === "ArrowUp" || event.keyCode === 38) {
            if (!!currentElement.previousElementSibling) {
                currentElement.previousElementSibling.focus();
            }
            else {
                currentElement.parentElement.lastElementChild && currentElement.parentElement.lastElementChild.focus();
            }
            event.preventDefault();
        }
    };
    ListModel.prototype.onPointerDown = function (event, item) { };
    ListModel.prototype.refresh = function () {
        this.filteredText = "";
    };
    ListModel.INDENT = 16;
    ListModel.MINELEMENTCOUNT = 10;
    __decorate([
        Object(_jsonobject__WEBPACK_IMPORTED_MODULE_0__["property"])({ defaultValue: false })
    ], ListModel.prototype, "needFilter", void 0);
    __decorate([
        Object(_jsonobject__WEBPACK_IMPORTED_MODULE_0__["property"])({ defaultValue: false })
    ], ListModel.prototype, "isExpanded", void 0);
    __decorate([
        Object(_jsonobject__WEBPACK_IMPORTED_MODULE_0__["property"])()
    ], ListModel.prototype, "selectedItem", void 0);
    __decorate([
        Object(_jsonobject__WEBPACK_IMPORTED_MODULE_0__["property"])({
            onSet: function (_, target) {
                target.filterByText(target.filteredText);
            }
        })
    ], ListModel.prototype, "filteredText", void 0);
    return ListModel;
}(_actions_container__WEBPACK_IMPORTED_MODULE_1__["ActionContainer"]));



/***/ }),

/***/ "./src/localizablestring.ts":
/*!**********************************!*\
  !*** ./src/localizablestring.ts ***!
  \**********************************/
/*! exports provided: LocalizableString, LocalizableStrings */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "LocalizableString", function() { return LocalizableString; });
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "LocalizableStrings", function() { return LocalizableStrings; });
/* harmony import */ var _helpers__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ./helpers */ "./src/helpers.ts");
/* harmony import */ var _surveyStrings__WEBPACK_IMPORTED_MODULE_1__ = __webpack_require__(/*! ./surveyStrings */ "./src/surveyStrings.ts");
/* harmony import */ var _settings__WEBPACK_IMPORTED_MODULE_2__ = __webpack_require__(/*! ./settings */ "./src/settings.ts");



/**
 * The class represents the string that supports multi-languages and markdown.
 * It uses in all objects where support for multi-languages and markdown is required.
 */
var LocalizableString = /** @class */ (function () {
    function LocalizableString(owner, useMarkdown, name) {
        if (useMarkdown === void 0) { useMarkdown = false; }
        this.owner = owner;
        this.useMarkdown = useMarkdown;
        this.name = name;
        this.values = {};
        this.htmlValues = {};
        this.onCreating();
    }
    Object.defineProperty(LocalizableString, "defaultLocale", {
        get: function () {
            return _settings__WEBPACK_IMPORTED_MODULE_2__["settings"].defaultLocaleName;
        },
        set: function (val) {
            _settings__WEBPACK_IMPORTED_MODULE_2__["settings"].defaultLocaleName = val;
        },
        enumerable: false,
        configurable: true
    });
    LocalizableString.prototype.getIsMultiple = function () { return false; };
    Object.defineProperty(LocalizableString.prototype, "locale", {
        get: function () {
            return this.owner && this.owner.getLocale ? this.owner.getLocale() : "";
        },
        enumerable: false,
        configurable: true
    });
    LocalizableString.prototype.strChanged = function () {
        this.searchableText = undefined;
        if (this.renderedText === undefined)
            return;
        this.calculatedTextValue = this.calcText();
        if (this.renderedText !== this.calculatedTextValue) {
            this.renderedText = undefined;
            this.calculatedTextValue = undefined;
        }
        this.onChanged();
    };
    Object.defineProperty(LocalizableString.prototype, "text", {
        get: function () {
            return this.pureText;
        },
        set: function (value) {
            this.setLocaleText(this.locale, value);
        },
        enumerable: false,
        configurable: true
    });
    Object.defineProperty(LocalizableString.prototype, "calculatedText", {
        get: function () {
            this.renderedText =
                this.calculatedTextValue !== undefined
                    ? this.calculatedTextValue
                    : this.calcText();
            this.calculatedTextValue = undefined;
            return this.renderedText;
        },
        enumerable: false,
        configurable: true
    });
    LocalizableString.prototype.calcText = function () {
        var res = this.pureText;
        if (res &&
            this.owner &&
            this.owner.getProcessedText &&
            res.indexOf("{") > -1) {
            res = this.owner.getProcessedText(res);
        }
        if (this.onGetTextCallback)
            res = this.onGetTextCallback(res);
        return res;
    };
    Object.defineProperty(LocalizableString.prototype, "pureText", {
        get: function () {
            var loc = this.locale;
            if (!loc)
                loc = _settings__WEBPACK_IMPORTED_MODULE_2__["settings"].defaultLocaleName;
            var res = this.getValue(loc);
            if (!res && loc == _settings__WEBPACK_IMPORTED_MODULE_2__["settings"].defaultLocaleName) {
                res = this.getValue(_surveyStrings__WEBPACK_IMPORTED_MODULE_1__["surveyLocalization"].defaultLocale);
            }
            if (!res && loc !== _settings__WEBPACK_IMPORTED_MODULE_2__["settings"].defaultLocaleName) {
                res = this.getValue(_settings__WEBPACK_IMPORTED_MODULE_2__["settings"].defaultLocaleName);
            }
            if (!res && !!this.localizationName) {
                res = this.getLocalizationStr();
            }
            if (!res)
                res = "";
            return res;
        },
        enumerable: false,
        configurable: true
    });
    LocalizableString.prototype.getLocalizationStr = function () {
        return !!this.localizationName ? _surveyStrings__WEBPACK_IMPORTED_MODULE_1__["surveyLocalization"].getString(this.localizationName) : "";
    };
    Object.defineProperty(LocalizableString.prototype, "hasHtml", {
        get: function () {
            return this.hasHtmlValue();
        },
        enumerable: false,
        configurable: true
    });
    Object.defineProperty(LocalizableString.prototype, "html", {
        get: function () {
            if (!this.hasHtml)
                return "";
            return this.getHtmlValue();
        },
        enumerable: false,
        configurable: true
    });
    Object.defineProperty(LocalizableString.prototype, "isEmpty", {
        get: function () {
            return this.getValuesKeys().length == 0;
        },
        enumerable: false,
        configurable: true
    });
    Object.defineProperty(LocalizableString.prototype, "textOrHtml", {
        get: function () {
            return this.hasHtml ? this.getHtmlValue() : this.calculatedText;
        },
        enumerable: false,
        configurable: true
    });
    Object.defineProperty(LocalizableString.prototype, "renderedHtml", {
        get: function () {
            return this.textOrHtml;
        },
        enumerable: false,
        configurable: true
    });
    LocalizableString.prototype.getLocaleText = function (loc) {
        if (!loc)
            loc = _settings__WEBPACK_IMPORTED_MODULE_2__["settings"].defaultLocaleName;
        var res = this.getValue(loc);
        return res ? res : "";
    };
    LocalizableString.prototype.getLocaleTextWithDefault = function (loc) {
        var res = this.getLocaleText(loc);
        if (!res && this.onGetDefaultTextCallback) {
            return this.onGetDefaultTextCallback();
        }
        return res;
    };
    LocalizableString.prototype.setLocaleText = function (loc, value) {
        if (value == this.getLocaleTextWithDefault(loc))
            return;
        if (value &&
            loc &&
            loc != _settings__WEBPACK_IMPORTED_MODULE_2__["settings"].defaultLocaleName &&
            !this.getValue(loc) &&
            value == this.getLocaleText(_settings__WEBPACK_IMPORTED_MODULE_2__["settings"].defaultLocaleName))
            return;
        var curLoc = this.locale;
        if (!loc)
            loc = _settings__WEBPACK_IMPORTED_MODULE_2__["settings"].defaultLocaleName;
        if (!curLoc)
            curLoc = _settings__WEBPACK_IMPORTED_MODULE_2__["settings"].defaultLocaleName;
        var hasOnStrChanged = this.onStrChanged && loc === curLoc;
        var oldValue = hasOnStrChanged ? this.pureText : undefined;
        delete this.htmlValues[loc];
        if (!value) {
            if (this.getValue(loc))
                this.deleteValue(loc);
        }
        else {
            if (typeof value === "string") {
                if (loc != _settings__WEBPACK_IMPORTED_MODULE_2__["settings"].defaultLocaleName &&
                    value == this.getLocaleText(_settings__WEBPACK_IMPORTED_MODULE_2__["settings"].defaultLocaleName)) {
                    this.setLocaleText(loc, null);
                }
                else {
                    this.setValue(loc, value);
                    if (loc == _settings__WEBPACK_IMPORTED_MODULE_2__["settings"].defaultLocaleName) {
                        this.deleteValuesEqualsToDefault(value);
                    }
                }
            }
        }
        this.strChanged();
        if (hasOnStrChanged) {
            this.onStrChanged(oldValue, value);
        }
    };
    LocalizableString.prototype.hasNonDefaultText = function () {
        var keys = this.getValuesKeys();
        if (keys.length == 0)
            return false;
        return keys.length > 1 || keys[0] != _settings__WEBPACK_IMPORTED_MODULE_2__["settings"].defaultLocaleName;
    };
    LocalizableString.prototype.getLocales = function () {
        var keys = this.getValuesKeys();
        if (keys.length == 0)
            return [];
        return keys;
    };
    LocalizableString.prototype.getJson = function () {
        if (!!this.sharedData)
            return this.sharedData.getJson();
        var keys = this.getValuesKeys();
        if (keys.length == 0)
            return null;
        if (keys.length == 1 &&
            keys[0] == _settings__WEBPACK_IMPORTED_MODULE_2__["settings"].defaultLocaleName &&
            !_settings__WEBPACK_IMPORTED_MODULE_2__["settings"].serializeLocalizableStringAsObject)
            return this.values[keys[0]];
        return this.values;
    };
    LocalizableString.prototype.setJson = function (value) {
        if (!!this.sharedData) {
            this.sharedData.setJson(value);
            return;
        }
        this.values = {};
        this.htmlValues = {};
        if (!value)
            return;
        if (typeof value === "string") {
            this.setLocaleText(null, value);
        }
        else {
            for (var key in value) {
                this.setLocaleText(key, value[key]);
            }
        }
        this.strChanged();
    };
    Object.defineProperty(LocalizableString.prototype, "renderAs", {
        get: function () {
            if (!this.owner || typeof this.owner.getRenderer !== "function") {
                return LocalizableString.defaultRenderer;
            }
            return this.owner.getRenderer(this.name) || LocalizableString.defaultRenderer;
        },
        enumerable: false,
        configurable: true
    });
    Object.defineProperty(LocalizableString.prototype, "renderAsData", {
        get: function () {
            if (!this.owner || typeof this.owner.getRendererContext !== "function") {
                return this;
            }
            return this.owner.getRendererContext(this) || this;
        },
        enumerable: false,
        configurable: true
    });
    LocalizableString.prototype.equals = function (obj) {
        if (!!this.sharedData)
            return this.sharedData.equals(obj);
        if (!obj || !obj.values)
            return false;
        return _helpers__WEBPACK_IMPORTED_MODULE_0__["Helpers"].isTwoValueEquals(this.values, obj.values, false, true, false);
    };
    LocalizableString.prototype.setFindText = function (text) {
        if (this.searchText == text)
            return;
        this.searchText = text;
        if (!this.searchableText) {
            var textOrHtml = this.textOrHtml;
            this.searchableText = !!textOrHtml ? textOrHtml.toLowerCase() : "";
        }
        var str = this.searchableText;
        var index = !!str && !!text ? str.indexOf(text) : undefined;
        if (index < 0)
            index = undefined;
        if (index != undefined || this.searchIndex != index) {
            this.searchIndex = index;
            if (!!this.onSearchChanged) {
                this.onSearchChanged();
            }
        }
        return this.searchIndex != undefined;
    };
    LocalizableString.prototype.onChanged = function () { };
    LocalizableString.prototype.onCreating = function () { };
    LocalizableString.prototype.hasHtmlValue = function () {
        if (!this.owner || !this.useMarkdown)
            return false;
        var renderedText = this.calculatedText;
        if (!renderedText)
            return false;
        if (!!this.localizationName && renderedText === this.getLocalizationStr())
            return false;
        var loc = this.locale;
        if (!loc)
            loc = _settings__WEBPACK_IMPORTED_MODULE_2__["settings"].defaultLocaleName;
        this.htmlValues[loc] = this.owner.getMarkdownHtml(renderedText, this.name);
        return this.htmlValues[loc] ? true : false;
    };
    LocalizableString.prototype.getHtmlValue = function () {
        var loc = this.locale;
        if (!loc)
            loc = _settings__WEBPACK_IMPORTED_MODULE_2__["settings"].defaultLocaleName;
        return this.htmlValues[loc];
    };
    LocalizableString.prototype.deleteValuesEqualsToDefault = function (defaultValue) {
        var keys = this.getValuesKeys();
        for (var i = 0; i < keys.length; i++) {
            if (keys[i] == _settings__WEBPACK_IMPORTED_MODULE_2__["settings"].defaultLocaleName)
                continue;
            if (this.getValue(keys[i]) == defaultValue) {
                this.deleteValue(keys[i]);
            }
        }
    };
    LocalizableString.prototype.getValue = function (loc) {
        if (!!this.sharedData)
            return this.sharedData.getValue(loc);
        return this.values[loc];
    };
    LocalizableString.prototype.setValue = function (loc, value) {
        if (!!this.sharedData)
            this.sharedData.setValue(loc, value);
        else
            this.values[loc] = value;
    };
    LocalizableString.prototype.deleteValue = function (loc) {
        if (!!this.sharedData)
            this.sharedData.deleteValue(loc);
        else
            delete this.values[loc];
    };
    LocalizableString.prototype.getValuesKeys = function () {
        if (!!this.sharedData)
            return this.sharedData.getValuesKeys();
        return Object.keys(this.values);
    };
    LocalizableString.SerializeAsObject = false;
    LocalizableString.defaultRenderer = "sv-string-viewer";
    LocalizableString.editableRenderer = "sv-string-editor";
    return LocalizableString;
}());

/**
 * The class represents the list of strings that supports multi-languages.
 */
var LocalizableStrings = /** @class */ (function () {
    function LocalizableStrings(owner) {
        this.owner = owner;
        this.values = {};
    }
    LocalizableStrings.prototype.getIsMultiple = function () { return true; };
    Object.defineProperty(LocalizableStrings.prototype, "locale", {
        get: function () {
            return this.owner && this.owner.getLocale ? this.owner.getLocale() : "";
        },
        enumerable: false,
        configurable: true
    });
    Object.defineProperty(LocalizableStrings.prototype, "value", {
        get: function () {
            return this.getValue("");
        },
        set: function (val) {
            this.setValue("", val);
        },
        enumerable: false,
        configurable: true
    });
    Object.defineProperty(LocalizableStrings.prototype, "text", {
        get: function () {
            return Array.isArray(this.value) ? this.value.join("\n") : "";
        },
        set: function (val) {
            this.value = !!val ? val.split("\n") : [];
        },
        enumerable: false,
        configurable: true
    });
    LocalizableStrings.prototype.getLocaleText = function (loc) {
        var res = this.getValueCore(loc, !loc || loc === this.locale);
        if (!res || !Array.isArray(res) || res.length == 0)
            return "";
        return res.join("\n");
    };
    LocalizableStrings.prototype.setLocaleText = function (loc, newValue) {
        var val = !!newValue ? newValue.split("\n") : null;
        this.setValue(loc, val);
    };
    LocalizableStrings.prototype.getValue = function (loc) {
        return this.getValueCore(loc);
    };
    LocalizableStrings.prototype.getValueCore = function (loc, useDefault) {
        if (useDefault === void 0) { useDefault = true; }
        loc = this.getLocale(loc);
        if (this.values[loc])
            return this.values[loc];
        if (useDefault) {
            var defLoc = _settings__WEBPACK_IMPORTED_MODULE_2__["settings"].defaultLocaleName;
            if (loc !== defLoc && this.values[defLoc])
                return this.values[defLoc];
        }
        return [];
    };
    LocalizableStrings.prototype.setValue = function (loc, val) {
        loc = this.getLocale(loc);
        var oldValue = _helpers__WEBPACK_IMPORTED_MODULE_0__["Helpers"].createCopy(this.values);
        if (!val || val.length == 0) {
            delete this.values[loc];
        }
        else {
            this.values[loc] = val;
        }
        if (!!this.onValueChanged) {
            this.onValueChanged(oldValue, this.values);
        }
    };
    LocalizableStrings.prototype.hasValue = function (loc) {
        if (loc === void 0) { loc = ""; }
        return !this.isEmpty && this.getValue(loc).length > 0;
    };
    Object.defineProperty(LocalizableStrings.prototype, "isEmpty", {
        get: function () {
            return this.getValuesKeys().length == 0;
        },
        enumerable: false,
        configurable: true
    });
    LocalizableStrings.prototype.getLocale = function (loc) {
        if (!!loc)
            return loc;
        loc = this.locale;
        return !!loc ? loc : _settings__WEBPACK_IMPORTED_MODULE_2__["settings"].defaultLocaleName;
    };
    LocalizableStrings.prototype.getLocales = function () {
        var keys = this.getValuesKeys();
        if (keys.length == 0)
            return [];
        return keys;
    };
    LocalizableStrings.prototype.getJson = function () {
        var keys = this.getValuesKeys();
        if (keys.length == 0)
            return null;
        if (keys.length == 1 &&
            keys[0] == _settings__WEBPACK_IMPORTED_MODULE_2__["settings"].defaultLocaleName &&
            !_settings__WEBPACK_IMPORTED_MODULE_2__["settings"].serializeLocalizableStringAsObject)
            return this.values[keys[0]];
        return _helpers__WEBPACK_IMPORTED_MODULE_0__["Helpers"].createCopy(this.values);
    };
    LocalizableStrings.prototype.setJson = function (value) {
        this.values = {};
        if (!value)
            return;
        if (Array.isArray(value)) {
            this.setValue(null, value);
        }
        else {
            for (var key in value) {
                this.setValue(key, value[key]);
            }
        }
    };
    LocalizableStrings.prototype.getValuesKeys = function () {
        return Object.keys(this.values);
    };
    return LocalizableStrings;
}());



/***/ }),

/***/ "./src/localization/arabic.ts":
/*!************************************!*\
  !*** ./src/localization/arabic.ts ***!
  \************************************/
/*! exports provided: arabicSurveyStrings */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "arabicSurveyStrings", function() { return arabicSurveyStrings; });
/* harmony import */ var _surveyStrings__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ../surveyStrings */ "./src/surveyStrings.ts");

var arabicSurveyStrings = {
    pagePrevText: "السابق",
    pageNextText: "التالي",
    completeText: "إرسال البيانات",
    previewText: "معاينة",
    editText: "تعديل",
    startSurveyText: "بداية",
    otherItemText: "نص آخر",
    noneItemText: "لا شيء",
    selectAllItemText: "اختر الكل",
    progressText: "{1} صفحة {0} من",
    panelDynamicProgressText: "سجل {0} من {1}",
    questionsProgressText: "تمت الإجابة على أسئلة {0} / {1}",
    emptySurvey: "لا توجد صفحة مرئية أو سؤال في النموذج",
    completingSurvey: "شكرا لكم لاستكمال النموذج!",
    completingSurveyBefore: "تظهر سجلاتنا أنك قد أكملت هذا الاستطلاع بالفعل.",
    loadingSurvey: "...يتم تحميل النموذج",
    optionsCaption: "...اختر",
    value: "القيمة",
    requiredError: ".يرجى الإجابة على السؤال",
    requiredErrorInPanel: "الرجاء الإجابة على سؤال واحد على الأقل.",
    requiredInAllRowsError: "يرجى الإجابة على الأسئلة في جميع الصفوف",
    numericError: "يجب أن تكون القيمة رقمية.",
    textMinLength: "الرجاء إدخال ما لا يقل عن {0} حروف",
    textMaxLength: "الرجاء إدخال أقل من {0} حروف",
    textMinMaxLength: "يرجى إدخال أكثر من {0} وأقل من {1} حروف",
    minRowCountError: "يرجى ملء ما لا يقل عن {0} الصفوف",
    minSelectError: "يرجى تحديد ما لا يقل عن {0} المتغيرات",
    maxSelectError: "يرجى تحديد ما لا يزيد عن {0} المتغيرات",
    numericMinMax: "و'{0}' يجب أن تكون مساوية أو أكثر من {1} وتساوي أو أقل من {2}ا",
    numericMin: "و'{0}' يجب أن تكون مساوية أو أكثر من {1}ا",
    numericMax: "و'{0}' يجب أن تكون مساوية أو أقل من {1}ا",
    invalidEmail: "الرجاء إدخال بريد الكتروني صحيح",
    invalidExpression: "يجب أن يعرض التعبير: {0} 'صواب'.",
    urlRequestError: "طلب إرجاع خطأ '{0}'. {1}ا",
    urlGetChoicesError: "عاد طلب البيانات فارغ أو 'المسار' غير صحيح ",
    exceedMaxSize: "ينبغي ألا يتجاوز حجم الملف {0}ا",
    otherRequiredError: "الرجاء إدخال قيمة أخرى",
    uploadingFile: "تحميل الملف الخاص بك. يرجى الانتظار عدة ثوان والمحاولة لاحقًا",
    loadingFile: "جار التحميل...",
    chooseFile: "اختر الملفات...",
    noFileChosen: "لم تقم باختيار ملف",
    confirmDelete: "هل تريد حذف السجل؟",
    keyDuplicationError: "يجب أن تكون هذه القيمة فريدة.",
    addColumn: "أضف العمود",
    addRow: "اضافة صف",
    removeRow: "إزالة صف",
    addPanel: "اضف جديد",
    removePanel: "إزالة",
    choices_Item: "بند",
    matrix_column: "عمود",
    matrix_row: "صف",
    savingData: "يتم حفظ النتائج على الخادم ...",
    savingDataError: "حدث خطأ ولم نتمكن من حفظ النتائج.",
    savingDataSuccess: "تم حفظ النتائج بنجاح!",
    saveAgainButton: "حاول مجددا",
    timerMin: "دقيقة",
    timerSec: "ثانية",
    timerSpentAll: "لقد أنفقت {0} على هذه الصفحة و {1} إجمالاً.",
    timerSpentPage: "لقد أنفقت {0} على هذه الصفحة.",
    timerSpentSurvey: "لقد أنفقت {0} إجمالاً.",
    timerLimitAll: "لقد أنفقت {0} من {1} في هذه الصفحة و {2} من إجمالي {3}.",
    timerLimitPage: "لقد أنفقت {0} من {1} في هذه الصفحة.",
    timerLimitSurvey: "لقد أنفقت {0} من إجمالي {1}.",
    cleanCaption: "نظيف",
    clearCaption: "واضح",
    chooseFileCaption: "اختر ملف",
    removeFileCaption: "قم بإزالة هذا الملف",
    booleanCheckedLabel: "نعم",
    booleanUncheckedLabel: "لا",
    confirmRemoveFile: "هل أنت متأكد أنك تريد إزالة هذا الملف: {0}؟",
    confirmRemoveAllFiles: "هل أنت متأكد أنك تريد إزالة كافة الملفات؟",
    questionTitlePatternText: "عنوان السؤال",
};
_surveyStrings__WEBPACK_IMPORTED_MODULE_0__["surveyLocalization"].locales["ar"] = arabicSurveyStrings;
_surveyStrings__WEBPACK_IMPORTED_MODULE_0__["surveyLocalization"].localeNames["ar"] = "العربية";


/***/ }),

/***/ "./src/localization/basque.ts":
/*!************************************!*\
  !*** ./src/localization/basque.ts ***!
  \************************************/
/*! exports provided: basqueSurveyStrings */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "basqueSurveyStrings", function() { return basqueSurveyStrings; });
/* harmony import */ var _surveyStrings__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ../surveyStrings */ "./src/surveyStrings.ts");

var basqueSurveyStrings = {
    pagePrevText: "Aurrekoa",
    pageNextText: "Hurrengoa",
    completeText: "Bukatu",
    previewText: "Aurrebista",
    editText: "Editatu",
    startSurveyText: "Hasi",
    otherItemText: "Beste bat (zehaztu)",
    noneItemText: "Bat ere ez",
    selectAllItemText: "Guztia hautatu",
    progressText: "{1}-(e)tik {0} orrialde",
    panelDynamicProgressText: "{0} errigistro {1}-(e)tik",
    questionsProgressText: "Erantzundako galderak {0}/{1}",
    emptySurvey: "Ez dago orrialde bistaragarririk edo ez dago galderarik.",
    completingSurvey: "Eskerrik asko galdetegia erantzuteagatik!",
    completingSurveyBefore: "Gure datuek diote dagoeneko galdetegia erantzun duzula.",
    loadingSurvey: "Galdetegia kargatzen...",
    optionsCaption: "Hautatu...",
    value: "balioa",
    requiredError: "Mesedez, galdera erantzun.",
    requiredErrorInPanel: "Mesedez, gutxienez galdera bat erantzun.",
    requiredInAllRowsError: "Mesedez, errenkadako galdera guztiak erantzun.",
    numericError: "Estimazioa zenbakizkoa izan behar du.",
    minError: "Balioa ez da {0} baino txikiagoa izan behar",
    maxError: "Balioa ez da {0} baino handiagoa izan behar",
    textMinLength: "Mesedez, gutxienez {0} karaktere erabili behar dira.",
    textMaxLength: "Mesedez, gehienez {0} karaktere erabili behar dira.",
    textMinMaxLength: "Mesedez, gehienez {0} eta gutxienez {1} karaktere erabili behar dira.",
    minRowCountError: "Mesedez, gutxienez {0} errenkada bete.",
    minSelectError: "Mesedez, gutxienez {0} aukera hautatu.",
    maxSelectError: "Mesedez, {0} aukera baino gehiago ez hautatu.",
    numericMinMax: "El '{0}' debe de ser igual o más de {1} y igual o menos de {2}",
    numericMin: "'{0}' {1} baino handiagoa edo berdin izan behar da",
    numericMax: "'{0}' {1} baino txikiago edo berdin izan behar da",
    invalidEmail: "Mesedez, baliozko emaila idatz ezazu.",
    invalidExpression: "{0} adierazpenak 'egiazkoa' itzuli beharko luke.",
    urlRequestError: "Eskaerak '{0}' errorea itzuli du. {1}",
    urlGetChoicesError: "La solicitud regresó vacío de data o la propiedad 'trayectoria' no es correcta",
    exceedMaxSize: "Fitxategiaren tamaina ez da {0} baino handiagoa izan behar.",
    otherRequiredError: "Mesedez, beste estimazioa gehitu.",
    uploadingFile: "Zure fitxategia igotzen ari da. Mesedez, segundo batzuk itxaron eta saiatu berriro.",
    loadingFile: "Kargatzen...",
    chooseFile: "Fitxategia(k) hautatu...",
    noFileChosen: "Ez da inolako fitxategirik hautatu",
    confirmDelete: "¿Erregistroa borratu nahi al duzu?",
    keyDuplicationError: "Balio hau bakarra izan behar du.",
    addColumn: "Zutabe bat gehitu",
    addRow: "Errenkada bat gehitu",
    removeRow: "Errenkada bat kendu",
    emptyRowsText: "Ez dago errenkadarik.",
    addPanel: "Berria gehitu",
    removePanel: "Kendu",
    choices_Item: "artikulua",
    matrix_column: "Zutabea",
    matrix_row: "Errenkada",
    multipletext_itemname: "testua",
    savingData: "Erantzunak zerbitzarian gordetzen ari dira...",
    savingDataError: "Erroreren bat gertatu eta erantzunak ez dira zerbitzarian gorde ahal izan.",
    savingDataSuccess: "Erantzunak egoki gorde dira!",
    saveAgainButton: "Berriro saiatu.",
    timerMin: "min",
    timerSec: "seg",
    timerSpentAll: "{0} erabili duzu orrialde honetan eta orotara {1}.",
    timerSpentPage: "Zuk {0} erabili duzu.",
    timerSpentSurvey: "Orotara gastatu duzu.",
    timerLimitAll: "{0} gastatu duzu {1}-(e)tik orrialde honetan eta orotara {2} {3}-(e)tik.",
    timerLimitPage: "{0} gastatu duzu orrialde honetan {1}-(e)tik.",
    timerLimitSurvey: "Zuk orotara {0} gastatu duzu {1}-(e)tik.",
    cleanCaption: "Garbitu",
    clearCaption: "Hustu",
    signaturePlaceHolder: "Sinatu hemen",
    chooseFileCaption: "Fitxategia hautatu",
    removeFileCaption: "Fitxategi hau ezabatu",
    booleanCheckedLabel: "Bai",
    booleanUncheckedLabel: "Ez",
    confirmRemoveFile: "Ziur zaude hurrengo fitxategia ezabatu nahi duzula: {0}?",
    confirmRemoveAllFiles: "Ziur al zaude fitxategi guztiak ezabatu nahi dituzula?",
    questionTitlePatternText: "Galderaren izenburua",
    modalCancelButtonText: "Ezeztatu",
    modalApplyButtonText: "Ezarri",
};
_surveyStrings__WEBPACK_IMPORTED_MODULE_0__["surveyLocalization"].locales["eu"] = basqueSurveyStrings;
_surveyStrings__WEBPACK_IMPORTED_MODULE_0__["surveyLocalization"].localeNames["eu"] = "Euskara";


/***/ }),

/***/ "./src/localization/bulgarian.ts":
/*!***************************************!*\
  !*** ./src/localization/bulgarian.ts ***!
  \***************************************/
/*! exports provided: bulgarianStrings */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "bulgarianStrings", function() { return bulgarianStrings; });
/* harmony import */ var _surveyStrings__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ../surveyStrings */ "./src/surveyStrings.ts");

var bulgarianStrings = {
    pagePrevText: "Назад",
    pageNextText: "Напред",
    completeText: "Край",
    previewText: "Визуализация",
    editText: "редактиране",
    startSurveyText: "Начало",
    otherItemText: "Друго (опишете)",
    noneItemText: "Нито един",
    selectAllItemText: "Всички",
    progressText: "стр. {0}, общо стр. {1}",
    panelDynamicProgressText: "Запис {0} от {1}",
    questionsProgressText: "Отговорени на {0} / {1} въпроса",
    emptySurvey: "Анкетата не съдържа видими страници или въпроси.",
    completingSurvey: "Благодарим ви за участието в анкетата!",
    completingSurveyBefore: "Изглежда, че вие вече сте попълнили анкетата.",
    loadingSurvey: "Зареждане на анкетата...",
    optionsCaption: "Изберете...",
    value: "value",
    requiredError: "Моля, отговорете на следния въпрос.",
    requiredErrorInPanel: "Моля, отговорете поне на един от въпросите.",
    requiredInAllRowsError: "Моля, отговорете на въпросите на всички редове.",
    numericError: "Стойността следва да бъде число.",
    textMinLength: "Моля, използвайте поне {0} символа.",
    textMaxLength: "Моля, използвайте не повече от {0} символа.",
    textMinMaxLength: "Моля, използвайте повече от {0} и по-малко от {1} символа.",
    minRowCountError: "Моля, попълнете поне {0} реда.",
    minSelectError: "Моля, изберете поне {0} варианта.",
    maxSelectError: "Моля, изберете не повече от {0} варианта.",
    numericMinMax: "Стойността '{0}' следва да бъде равна или по-голяма от {1} и равна или по-малка от {2}",
    numericMin: "Стойността '{0}' следва да бъде равна или по-голяма от {1}",
    numericMax: "Стойността '{0}' следва да бъде равна или по-малка от {1}",
    invalidEmail: "Моля, въведете валиден адрес на електронна поща.",
    invalidExpression: "Изразът: {0} трябва да дава резултат 'true' (истина).",
    urlRequestError: "Заявката води до грешка '{0}'. {1}",
    urlGetChoicesError: "Заявката не връща данни или частта 'path' (път до търсения ресурс на сървъра) е неправилно зададена",
    exceedMaxSize: "Размерът на файла следва да не превишава {0}.",
    otherRequiredError: "Моля, въведете другата стойност.",
    uploadingFile: "Вашит файл се зарежда на сървъра. Моля, изчакайте няколко секунди и тогава опитвайте отново.",
    loadingFile: "Зареждане...",
    chooseFile: "Изберете файл(ове)...",
    noFileChosen: "Няма избран файл",
    confirmDelete: "Желаете ли да изтриете записа?",
    keyDuplicationError: "Стойността следва да бъде уникална.",
    addColumn: "Добавяне на колона",
    addRow: "Добавяне на ред",
    removeRow: "Премахване на ред",
    addPanel: "Добавяне на панел",
    removePanel: "Премахване на панел",
    choices_Item: "елемент",
    matrix_column: "Колона",
    matrix_row: "Ред",
    savingData: "Резултатите се запазват на сървъра...",
    savingDataError: "Поради възникнала грешка резултатите не можаха да бъдат запазени.",
    savingDataSuccess: "Резултатите бяха запазени успешно!",
    saveAgainButton: "Нов опит",
    timerMin: "мин",
    timerSec: "сек",
    timerSpentAll: "Вие използвахте {0} на тази страница и общо {1}.",
    timerSpentPage: "Вие използвахте {0} на тази страница.",
    timerSpentSurvey: "Вие използвахте общо {0}.",
    timerLimitAll: "Вие изпозвахте {0} от {1} на тази страница и общо {2} от {3}.",
    timerLimitPage: "Вие използвахте {0} от {1} на тази страница.",
    timerLimitSurvey: "Вие използвахте общо {0} от {1}.",
    cleanCaption: "Изчистване",
    clearCaption: "Начално състояние",
    chooseFileCaption: "Изберете файл",
    removeFileCaption: "Премахване на файла",
    booleanCheckedLabel: "Да",
    booleanUncheckedLabel: "Не",
    confirmRemoveFile: "Наистина ли искате да премахнете този файл: {0}?",
    confirmRemoveAllFiles: "Наистина ли искате да премахнете всички файлове?",
    questionTitlePatternText: "Заглавие на въпроса",
};
_surveyStrings__WEBPACK_IMPORTED_MODULE_0__["surveyLocalization"].locales["bg"] = bulgarianStrings;
_surveyStrings__WEBPACK_IMPORTED_MODULE_0__["surveyLocalization"].localeNames["bg"] = "български";


/***/ }),

/***/ "./src/localization/catalan.ts":
/*!*************************************!*\
  !*** ./src/localization/catalan.ts ***!
  \*************************************/
/*! exports provided: catalanSurveyStrings */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "catalanSurveyStrings", function() { return catalanSurveyStrings; });
/* harmony import */ var _surveyStrings__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ../surveyStrings */ "./src/surveyStrings.ts");

var catalanSurveyStrings = {
    pagePrevText: "Anterior",
    pageNextText: "Següent",
    completeText: "Complet",
    otherItemText: "Un altre (descrigui)",
    progressText: "Pàgina {0} de {1}",
    emptySurvey: "No hi ha cap pàgina visible o pregunta a l'enquesta.",
    completingSurvey: "Gràcies per completar l'enquesta!",
    loadingSurvey: "L'enquesta s'està carregant ...",
    optionsCaption: "Selecciona ...",
    requiredError: "Si us plau contesti la pregunta.",
    requiredInAllRowsError: "Si us plau contesti les preguntes de cada filera.",
    numericError: "L'estimació ha de ser numèrica.",
    textMinLength: "Si us plau entre almenys {0} símbols.",
    textMaxLength: "Si us plau entre menys de {0} símbols.",
    textMinMaxLength: "Si us plau entre més de {0} i menys de {1} símbols.",
    minRowCountError: "Si us plau ompli almenys {0} fileres.",
    minSelectError: "Si us plau seleccioni almenys {0} variants.",
    maxSelectError: "Si us plau seleccioni no més de {0} variants.",
    numericMinMax: "El '{0}' deu ser igual o més de {1} i igual o menys de {2}",
    numericMin: "El '{0}' ha de ser igual o més de {1}",
    numericMax: "El '{0}' ha de ser igual o menys de {1}",
    invalidEmail: "Si us plau afegiu un correu electrònic vàlid.",
    urlRequestError: "La sol·licitud va tornar error '{0}'. {1}",
    urlGetChoicesError: "La sol·licitud va tornar buida de dates o la propietat 'trajectòria' no és correcta",
    exceedMaxSize: "La mida de l'arxiu no pot excedir {0}.",
    otherRequiredError: "Si us plau afegiu l'altra estimació.",
    uploadingFile: "El seu arxiu s'està pujant. Si us plau esperi uns segons i intenteu-ho de nou.",
    addRow: "Afegiu una filera",
    removeRow: "Eliminar una filera",
    choices_firstItem: "primer article",
    choices_secondItem: "segon article",
    choices_thirdItem: "tercer article",
    matrix_column: "Columna",
    matrix_row: "Filera"
};
_surveyStrings__WEBPACK_IMPORTED_MODULE_0__["surveyLocalization"].locales["ca"] = catalanSurveyStrings;
_surveyStrings__WEBPACK_IMPORTED_MODULE_0__["surveyLocalization"].localeNames["ca"] = "català";


/***/ }),

/***/ "./src/localization/croatian.ts":
/*!**************************************!*\
  !*** ./src/localization/croatian.ts ***!
  \**************************************/
/*! exports provided: croatianStrings */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "croatianStrings", function() { return croatianStrings; });
/* harmony import */ var _surveyStrings__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ../surveyStrings */ "./src/surveyStrings.ts");

var croatianStrings = {
    pagePrevText: "Prethodni",
    pageNextText: "Sljedeći",
    completeText: "Kompletan",
    previewText: "Pregled",
    editText: "Uređivanje",
    startSurveyText: "Početak",
    otherItemText: "Ostali (opis)",
    noneItemText: "Nitko",
    selectAllItemText: "Select All",
    progressText: "Stranica {0} od {1}",
    panelDynamicProgressText: "Zapisa {0} od {1}",
    questionsProgressText: "Odgovorio na {0}/{1} pitanja",
    emptySurvey: "U anketi nema vidljive stranice ili pitanja.",
    completingSurvey: "Hvala vam što ste završili anketu!",
    completingSurveyBefore: "Naši zapisi pokazuju da ste već završili ovu anketu.",
    loadingSurvey: "Anketa o učitavanje...",
    optionsCaption: "Odaberite...",
    value: "vrijednost",
    requiredError: "Molim vas odgovorite na pitanje.",
    requiredErrorInPanel: "Molim vas odgovorite na barem jedno pitanje.",
    requiredInAllRowsError: "Odgovorite na pitanja u svim redovima.",
    numericError: "Vrijednost bi trebala biti brojčana.",
    textMinLength: "Unesite najmanje {0} znak(ova).",
    textMaxLength: "Unesite manje od {0} znak(ova).",
    textMinMaxLength: "Unesite više od {0} i manje od {1} znakova.",
    minRowCountError: "Molimo ispunite najmanje {0} redaka.",
    minSelectError: "Odaberite barem {0} varijante.",
    maxSelectError: "Odaberite ne više od {0} varijanti.",
    numericMinMax: "'{0}'bi trebao biti jednak ili više od {1} i jednak ili manji od {2}.",
    numericMin: "'{0}' bi trebao biti jednak ili više od {1}.",
    numericMax: "'{0}' bi trebao biti jednak ili manji od {1}",
    invalidEmail: "Unesite valjanu e-mail adresu.",
    invalidExpression: "Izraz: {0} treba vratiti 'true'.",
    urlRequestError: "Zahtjev vratio pogrešku '{0}'. {1}",
    urlGetChoicesError: "Zahtjev je vratio prazne podatke ili je 'path' svojstvo netočna.",
    exceedMaxSize: "Veličina datoteke ne smije prelaziti {0}.",
    otherRequiredError: "Unesite drugu vrijednost.",
    uploadingFile: "Vaša datoteka se prenosi. Pričekajte nekoliko sekundi i pokušajte ponovno.",
    loadingFile: "Učitavanje...",
    chooseFile: "Odaberite datoteku...",
    noFileChosen: "Nije odabrana datoteka",
    confirmDelete: "Želite li izbrisati zapis?",
    keyDuplicationError: "Ta bi vrijednost trebala biti jedinstvena.",
    addColumn: "Dodavanje stupca",
    addRow: "Dodavanje redaka",
    removeRow: "Ukloniti",
    addPanel: "Dodavanje novih",
    removePanel: "Ukloniti",
    choices_Item: "stavku",
    matrix_column: "Stupca",
    matrix_row: "Redak",
    savingData: "Rezultati se spremaju na poslužitelju...",
    savingDataError: "Došlo je do pogreške i nismo mogli spremiti rezultate.",
    savingDataSuccess: "Rezultati su uspješno spremljeni!",
    saveAgainButton: "Pokušaj ponovo",
    timerMin: "min",
    timerSec: "sec",
    timerSpentAll: "Vi ste proveli {0} na ovoj stranici i {1} ukupno.",
    timerSpentPage: "Potrošili ste {0} na ovu stranicu.",
    timerSpentSurvey: "You have spent {0} in total. {0}.",
    timerLimitAll: "Vi ste proveli {0} od {1} na ovoj stranici i {2} od {3} ukupno.",
    timerLimitPage: "Potrošio si {0} od {1} na ovoj stranici.",
    timerLimitSurvey: "Ukupno ste potrošili {0} od {1}.",
    cleanCaption: "Očistiti",
    clearCaption: "Očistiti",
    chooseFileCaption: "Odaberite datoteku",
    removeFileCaption: "Uklonite ovu datoteku",
    booleanCheckedLabel: "Da",
    booleanUncheckedLabel: "Ne",
    confirmRemoveFile: "Jeste li sigurni da želite ukloniti ovu datoteku: {0}?",
    confirmRemoveAllFiles: "Jeste li sigurni da želite ukloniti sve datoteke?",
    questionTitlePatternText: "Naslov pitanja",
    modalCancelButtonText: "Otkazati",
    modalApplyButtonText: "Primijeniti",
};
_surveyStrings__WEBPACK_IMPORTED_MODULE_0__["surveyLocalization"].locales["hr"] = croatianStrings;
_surveyStrings__WEBPACK_IMPORTED_MODULE_0__["surveyLocalization"].localeNames["hr"] = "hrvatski";


/***/ }),

/***/ "./src/localization/czech.ts":
/*!***********************************!*\
  !*** ./src/localization/czech.ts ***!
  \***********************************/
/*! exports provided: czechSurveyStrings */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "czechSurveyStrings", function() { return czechSurveyStrings; });
/* harmony import */ var _surveyStrings__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ../surveyStrings */ "./src/surveyStrings.ts");

var czechSurveyStrings = {
    pagePrevText: "Předchozí",
    pageNextText: "Další",
    completeText: "Hotovo",
    previewText: "Náhled",
    editText: "Upravit",
    startSurveyText: "Start",
    otherItemText: "Jiná odpověď (napište)",
    noneItemText: "Žádný",
    selectAllItemText: "Vybrat vše",
    progressText: "Strana {0} z {1}",
    panelDynamicProgressText: "Záznam {0} z {1}",
    questionsProgressText: "Zodpovězené otázky: {0} / {1}",
    emptySurvey: "Průzkumu neobsahuje žádné otázky.",
    completingSurvey: "Děkujeme za vyplnění průzkumu!",
    completingSurveyBefore: "Naše záznamy ukazují, že jste tento průzkum již dokončili.",
    loadingSurvey: "Probíhá načítání průzkumu...",
    optionsCaption: "Vyber...",
    value: "hodnota",
    requiredError: "Odpovězte prosím na otázku.",
    requiredErrorInPanel: "Please answer at least one question.",
    requiredInAllRowsError: "Odpovězte prosím na všechny otázky.",
    numericError: "V tomto poli lze zadat pouze čísla.",
    textMinLength: "Zadejte prosím alespoň {0} znaků.",
    textMaxLength: "Zadejte prosím méně než {0} znaků.",
    textMinMaxLength: "Zadejte prosím více než {0} a méně než {1} znaků.",
    minRowCountError: "Vyplňte prosím alespoň {0} řádků.",
    minSelectError: "Vyberte prosím alespoň {0} varianty.",
    maxSelectError: "Nevybírejte prosím více než {0} variant.",
    numericMinMax: "Odpověď '{0}' by mělo být větší nebo rovno {1} a menší nebo rovno {2}",
    numericMin: "Odpověď '{0}' by mělo být větší nebo rovno {1}",
    numericMax: "Odpověď '{0}' by mělo být menší nebo rovno {1}",
    invalidEmail: "Zadejte prosím platnou e-mailovou adresu.",
    invalidExpression: "Výraz: {0} by měl vrátit hodnotu „true“.",
    urlRequestError: "Požadavek vrátil chybu '{0}'. {1}",
    urlGetChoicesError: "Požadavek nevrátil data nebo cesta je neplatná",
    exceedMaxSize: "Velikost souboru by neměla být větší než {0}.",
    otherRequiredError: "Zadejte prosím jinou hodnotu.",
    uploadingFile: "Váš soubor se nahrává. Zkuste to prosím za několik sekund.",
    loadingFile: "Načítání...",
    chooseFile: "Vyberte soubory ...",
    noFileChosen: "Není zvolený žádný soubor",
    confirmDelete: "Chcete smazat záznam?",
    keyDuplicationError: "Tato hodnota by měla být jedinečná.",
    addColumn: "Přidat sloupec",
    addRow: "Přidat řádek",
    removeRow: "Odstranit",
    addPanel: "Přidat nový",
    removePanel: "Odstranit",
    choices_Item: "položka",
    matrix_column: "Sloupec",
    matrix_row: "Řádek",
    savingData: "Výsledky se ukládají na server ...",
    savingDataError: "Došlo k chybě a výsledky jsme nemohli uložit.",
    savingDataSuccess: "Výsledky byly úspěšně uloženy!",
    saveAgainButton: "Zkus to znovu",
    timerMin: "min",
    timerSec: "sek",
    timerSpentAll: "Na této stránce jste utratili celkem {0} a celkem {1}.",
    timerSpentPage: "Na této stránce jste utratili {0}.",
    timerSpentSurvey: "Celkem jste utratili {0}.",
    timerLimitAll: "Na této stránce jste utratili {0} z {1} a celkem {2} z {3}.",
    timerLimitPage: "Na této stránce jste strávili {0} z {1}.",
    timerLimitSurvey: "Celkově jste utratili {0} z {1}.",
    cleanCaption: "Čistý",
    clearCaption: "Průhledná",
    chooseFileCaption: "Vyberte soubor",
    removeFileCaption: "Odeberte tento soubor",
    booleanCheckedLabel: "Ano",
    booleanUncheckedLabel: "Ne",
    confirmRemoveFile: "Opravdu chcete odebrat tento soubor: {0}?",
    confirmRemoveAllFiles: "Opravdu chcete odstranit všechny soubory?",
    questionTitlePatternText: "Název otázky",
};
_surveyStrings__WEBPACK_IMPORTED_MODULE_0__["surveyLocalization"].locales["cs"] = czechSurveyStrings;
_surveyStrings__WEBPACK_IMPORTED_MODULE_0__["surveyLocalization"].localeNames["cs"] = "čeština";


/***/ }),

/***/ "./src/localization/danish.ts":
/*!************************************!*\
  !*** ./src/localization/danish.ts ***!
  \************************************/
/*! exports provided: danishSurveyStrings */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "danishSurveyStrings", function() { return danishSurveyStrings; });
/* harmony import */ var _surveyStrings__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ../surveyStrings */ "./src/surveyStrings.ts");

var danishSurveyStrings = {
    pagePrevText: "Tilbage",
    pageNextText: "Videre",
    completeText: "Færdig",
    previewText: "Forpremiere",
    editText: "Redigér",
    startSurveyText: "Start",
    otherItemText: "Valgfrit svar...",
    noneItemText: "Ingen",
    selectAllItemText: "Vælg alle",
    progressText: "Side {0} af {1}",
    panelDynamicProgressText: "Optag {0} af {1}",
    questionsProgressText: "Besvarede {0} / {1} spørgsmål",
    emptySurvey: "Der er ingen synlige spørgsmål.",
    completingSurvey: "Mange tak for din besvarelse!",
    completingSurveyBefore: "Vores data viser at du allerede har gennemført dette spørgeskema.",
    loadingSurvey: "Spørgeskemaet hentes fra serveren...",
    optionsCaption: "Vælg...",
    value: "værdi",
    requiredError: "Besvar venligst spørgsmålet.",
    requiredErrorInPanel: "Besvar venligst mindst ét spørgsmål.",
    requiredInAllRowsError: "Besvar venligst spørgsmål i alle rækker.",
    numericError: "Angiv et tal.",
    textMinLength: "Angiv mindst {0} tegn.",
    textMaxLength: "Please enter less than {0} characters.",
    textMinMaxLength: "Angiv mere end {0} og mindre end {1} tegn.",
    minRowCountError: "Udfyld mindst {0} rækker.",
    minSelectError: "Vælg venligst mindst {0} svarmulighed(er).",
    maxSelectError: "Vælg venligst færre {0} svarmuligheder(er).",
    numericMinMax: "'{0}' skal være lig med eller større end {1} og lig med eller mindre end {2}",
    numericMin: "'{0}' skal være lig med eller større end {1}",
    numericMax: "'{0}' skal være lig med eller mindre end {1}",
    invalidEmail: "Angiv venligst en gyldig e-mail adresse.",
    invalidExpression: "Udtrykket: {0} skal returnere 'true'.",
    urlRequestError: "Forespørgslen returnerede fejlen '{0}'. {1}",
    urlGetChoicesError: "Forespørgslen returnerede ingen data eller 'path' parameteren er forkert",
    exceedMaxSize: "Filstørrelsen må ikke overstige {0}.",
    otherRequiredError: "Angiv en værdi for dit valgfrie svar.",
    uploadingFile: "Din fil bliver uploadet. Vent nogle sekunder og prøv eventuelt igen.",
    loadingFile: "Indlæser...",
    chooseFile: "Vælg fil(er)...",
    noFileChosen: "Ingen fil er valgt",
    confirmDelete: "Vil du fjerne den?",
    keyDuplicationError: "Denne værdi skal være unik.",
    addColumn: "Tilføj kolonne",
    addRow: "Tilføj række",
    removeRow: "Fjern",
    addPanel: "Tilføj ny",
    removePanel: "Fjern",
    choices_Item: "valg",
    matrix_column: "Kolonne",
    matrix_row: "Række",
    savingData: "Resultaterne bliver gemt på serveren...",
    savingDataError: "Der opstod en fejl og vi kunne ikke gemme resultatet.",
    savingDataSuccess: "Resultatet blev gemt!",
    saveAgainButton: "Prøv igen",
    timerMin: "min",
    timerSec: "sek",
    timerSpentAll: "Du har brugt {0} på denne side og {1} i alt.",
    timerSpentPage: "Du har brugt {0} på denne side.",
    timerSpentSurvey: "Du har brugt {0} i alt.",
    timerLimitAll: "Du har brugt {0} af {1} på denne side og {2} af {3} i alt.",
    timerLimitPage: "Du har brugt {0} af {1} på denne side.",
    timerLimitSurvey: "Du har brugt {0} af {1} i alt.",
    cleanCaption: "Rens",
    clearCaption: "Fjern",
    chooseFileCaption: "Vælg fil",
    removeFileCaption: "Fjern denne fil",
    booleanCheckedLabel: "Ja",
    booleanUncheckedLabel: "Ingen",
    confirmRemoveFile: "Er du sikker på, at du vil fjerne denne fil: {0}?",
    confirmRemoveAllFiles: "Er du sikker på, at du vil fjerne alle filer?",
    questionTitlePatternText: "Spørgsmåls titel",
};
_surveyStrings__WEBPACK_IMPORTED_MODULE_0__["surveyLocalization"].locales["da"] = danishSurveyStrings;
_surveyStrings__WEBPACK_IMPORTED_MODULE_0__["surveyLocalization"].localeNames["da"] = "dansk";


/***/ }),

/***/ "./src/localization/dutch.ts":
/*!***********************************!*\
  !*** ./src/localization/dutch.ts ***!
  \***********************************/
/*! exports provided: dutchSurveyStrings */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "dutchSurveyStrings", function() { return dutchSurveyStrings; });
/* harmony import */ var _surveyStrings__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ../surveyStrings */ "./src/surveyStrings.ts");
//Created on behalf https://github.com/Frank13
//Modified on behalf Roeland Verbakel

var dutchSurveyStrings = {
    pagePrevText: "Vorige",
    pageNextText: "Volgende",
    completeText: "Verzenden",
    previewText: "Voorbeeld",
    editText: "Bewerk",
    startSurveyText: "Begin met",
    otherItemText: "Anders, nl.",
    noneItemText: "Geen",
    selectAllItemText: "Selecteer Alles",
    progressText: "Pagina {0} van {1}",
    panelDynamicProgressText: "Record {0} of {1}",
    questionsProgressText: "Geantwoord {0}/{1} vragen",
    emptySurvey: "Er is geen zichtbare pagina of vraag in deze vragenlijst",
    completingSurvey: "Bedankt voor het invullen van de vragenlijst",
    completingSurveyBefore: "Onze gegevens tonen aan dat je deze vragenlijst reeds beantwoord hebt.",
    loadingSurvey: "De vragenlijst is aan het laden...",
    optionsCaption: "Kies...",
    value: "waarde",
    requiredError: "Dit is een vereiste vraag",
    requiredErrorInPanel: "Gelieve ten minste een vraag te beantwoorden.",
    requiredInAllRowsError: "Deze vraag vereist één antwoord per rij",
    numericError: "Het antwoord moet een getal zijn",
    textMinLength: "Vul minstens {0} karakters in",
    textMaxLength: "Gelieve minder dan {0} karakters in te vullen.",
    textMinMaxLength: "Gelieve meer dan {0} en minder dan {1} karakters in te vullen.",
    minRowCountError: "Gelieve ten minste {0} rijen in te vullen.",
    minSelectError: "Selecteer minimum {0} antwoorden",
    maxSelectError: "Selecteer niet meer dan {0} antwoorden",
    numericMinMax: "Uw antwoord '{0}' moet groter of gelijk zijn aan {1} en kleiner of gelijk aan {2}",
    numericMin: "Uw antwoord '{0}' moet groter of gelijk zijn aan {1}",
    numericMax: "Uw antwoord '{0}' moet groter of gelijk zijn aan {1}",
    invalidEmail: "Vul een geldig e-mailadres in",
    invalidExpression: "De uitdrukking: {0} moet 'waar' teruggeven.",
    urlRequestError: "De vraag keerde een fout terug '{0}'. {1}",
    urlGetChoicesError: "De vraag gaf een leeg antwoord terug of de 'pad' eigenschap is niet correct",
    exceedMaxSize: "De grootte van het bestand mag niet groter zijn dan {0}",
    otherRequiredError: "Vul het veld 'Anders, nl.' in",
    uploadingFile: "Uw bestand wordt opgeladen. Gelieve enkele seconden te wachten en opnieuw te proberen.",
    loadingFile: "Opladen...",
    chooseFile: "Kies uw bestand(en)...",
    noFileChosen: "Geen bestand gekozen",
    confirmDelete: "Wil je deze gegevens verwijderen?",
    keyDuplicationError: "Deze waarde moet uniek zijn.",
    addColumn: "Voeg kolom toe",
    addRow: "Voeg rij toe",
    removeRow: "Verwijder",
    addPanel: "Nieuwe toevoegen",
    removePanel: "Verwijder",
    choices_Item: "onderwerp",
    matrix_column: "Kolom",
    matrix_row: "Rij",
    savingData: "De resultaten worden bewaard op de server...",
    savingDataError: "Er was een probleem en we konden de resultaten niet bewaren.",
    savingDataSuccess: "De resultaten werden succesvol bewaard!",
    saveAgainButton: "Probeer opnieuw",
    timerMin: "minimum",
    timerSec: "sec",
    timerSpentAll: "U heeft {0} gespendeerd op deze pagina en {1} in totaal.",
    timerSpentPage: "U heeft {0} op deze pagina gespendeerd.",
    timerSpentSurvey: "U heeft in totaal {0} gespendeerd.",
    timerLimitAll: "U heeft {0} van {1} op deze pagina gespendeerd en {2} van {3} in totaal.",
    timerLimitPage: "U heeft {0} van {1} gespendeerd op deze pagina.",
    timerLimitSurvey: "U heeft {0} van {1} in het totaal.",
    cleanCaption: "Kuis op",
    clearCaption: "Kuis op",
    chooseFileCaption: "Gekozen bestand",
    removeFileCaption: "Verwijder deze file",
    booleanCheckedLabel: "Ja",
    booleanUncheckedLabel: "Neen",
    confirmRemoveFile: "Bent u zeker dat u deze file wilt verwijderen: {0}?",
    confirmRemoveAllFiles: "Bent u zeker dat u al deze files wilt verwijderen?",
    questionTitlePatternText: "Titel van de vraag",
};
_surveyStrings__WEBPACK_IMPORTED_MODULE_0__["surveyLocalization"].locales["nl"] = dutchSurveyStrings;
_surveyStrings__WEBPACK_IMPORTED_MODULE_0__["surveyLocalization"].localeNames["nl"] = "nederlands";


/***/ }),

/***/ "./src/localization/english.ts":
/*!*************************************!*\
  !*** ./src/localization/english.ts ***!
  \*************************************/
/*! exports provided: englishStrings */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "englishStrings", function() { return englishStrings; });
//Uncomment this line on creating a translation file
//import { surveyLocalization } from "../surveyStrings";
var englishStrings = {
    pagePrevText: "Previous",
    pageNextText: "Next",
    completeText: "Complete",
    previewText: "Preview",
    editText: "Edit",
    startSurveyText: "Start",
    otherItemText: "Other (describe)",
    noneItemText: "None",
    selectAllItemText: "Select All",
    progressText: "Page {0} of {1}",
    panelDynamicProgressText: "Record {0} of {1}",
    questionsProgressText: "Answered {0}/{1} questions",
    emptySurvey: "There is no visible page or question in the survey.",
    completingSurvey: "Thank you for completing the survey!",
    completingSurveyBefore: "Our records show that you have already completed this survey.",
    loadingSurvey: "Loading Survey...",
    optionsCaption: "Choose...",
    value: "value",
    requiredError: "Response required.",
    requiredErrorInPanel: "Response required: answer at least one question.",
    requiredInAllRowsError: "Response required: answer questions in all rows.",
    numericError: "The value should be numeric.",
    minError: "The value should not be less than {0}",
    maxError: "The value should not be greater than {0}",
    textMinLength: "Please enter at least {0} character(s).",
    textMaxLength: "Please enter no more than {0} character(s).",
    textMinMaxLength: "Please enter at least {0} and no more than {1} characters.",
    minRowCountError: "Please fill in at least {0} row(s).",
    minSelectError: "Please select at least {0} variant(s).",
    maxSelectError: "Please select no more than {0} variant(s).",
    numericMinMax: "The '{0}' should be at least {1} and at most {2}",
    numericMin: "The '{0}' should be at least {1}",
    numericMax: "The '{0}' should be at most {1}",
    invalidEmail: "Please enter a valid e-mail address.",
    invalidExpression: "The expression: {0} should return 'true'.",
    urlRequestError: "The request returned error '{0}'. {1}",
    urlGetChoicesError: "The request returned empty data or the 'path' property is incorrect",
    exceedMaxSize: "The file size should not exceed {0}.",
    otherRequiredError: "Response required: enter another value.",
    uploadingFile: "Your file is uploading. Please wait several seconds and try again.",
    loadingFile: "Loading...",
    chooseFile: "Choose file(s)...",
    noFileChosen: "No file chosen",
    fileDragAreaPlaceholder: "Drop a file here or click the button below to load the file.",
    confirmDelete: "Do you want to delete the record?",
    keyDuplicationError: "This value should be unique.",
    addColumn: "Add column",
    addRow: "Add row",
    removeRow: "Remove",
    emptyRowsText: "There are no rows.",
    addPanel: "Add new",
    removePanel: "Remove",
    choices_Item: "item",
    matrix_column: "Column",
    matrix_row: "Row",
    multipletext_itemname: "text",
    savingData: "The results are being saved on the server...",
    savingDataError: "An error occurred and we could not save the results.",
    savingDataSuccess: "The results were saved successfully!",
    saveAgainButton: "Try again",
    timerMin: "min",
    timerSec: "sec",
    timerSpentAll: "You have spent {0} on this page and {1} in total.",
    timerSpentPage: "You have spent {0} on this page.",
    timerSpentSurvey: "You have spent {0} in total.",
    timerLimitAll: "You have spent {0} of {1} on this page and {2} of {3} in total.",
    timerLimitPage: "You have spent {0} of {1} on this page.",
    timerLimitSurvey: "You have spent {0} of {1} in total.",
    cleanCaption: "Clean",
    clearCaption: "Clear",
    signaturePlaceHolder: "Sign here",
    chooseFileCaption: "Choose file",
    removeFileCaption: "Remove this file",
    booleanCheckedLabel: "Yes",
    booleanUncheckedLabel: "No",
    confirmRemoveFile: "Are you sure that you want to remove this file: {0}?",
    confirmRemoveAllFiles: "Are you sure that you want to remove all files?",
    questionTitlePatternText: "Question Title",
    modalCancelButtonText: "Cancel",
    modalApplyButtonText: "Apply",
    filteredTextPlaceholder: "Type to search...",
};
//Uncomment these two lines on creating a translation file. You should replace "en" and enStrings with your locale ("fr", "de" and so on) and your variable.
//surveyLocalization.locales["en"] = englishStrings;
//surveyLocalization.localeNames["en"] = "English";


/***/ }),

/***/ "./src/localization/estonian.ts":
/*!**************************************!*\
  !*** ./src/localization/estonian.ts ***!
  \**************************************/
/*! exports provided: estonianSurveyStrings */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "estonianSurveyStrings", function() { return estonianSurveyStrings; });
/* harmony import */ var _surveyStrings__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ../surveyStrings */ "./src/surveyStrings.ts");

var estonianSurveyStrings = {
    pagePrevText: "Tagasi",
    pageNextText: "Edasi",
    completeText: "Lõpeta",
    previewText: "Eelvaade",
    editText: "Muuda",
    startSurveyText: "Alusta",
    otherItemText: "Muu (täpsusta)",
    noneItemText: "Mitte midagi",
    selectAllItemText: "Vali kõik",
    progressText: "Lehekülg {0}/{1}",
    panelDynamicProgressText: "Kirje {0}/{1}",
    questionsProgressText: "Vastatud {0} küsimust {1}-st",
    emptySurvey: "Selles uuringus ei ole ühtki nähtavat lehekülge või küsimust.",
    completingSurvey: "Aitäh, et vastasid ankeedile!",
    completingSurveyBefore: "Meie andmetel oled sa sellele ankeedile juba vastanud.",
    loadingSurvey: "Laen ankeeti...",
    optionsCaption: "Vali...",
    value: "väärtus",
    requiredError: "Palun vasta küsimusele.",
    requiredErrorInPanel: "Palun vasta vähemalt ühele küsimusele.",
    requiredInAllRowsError: "Palun anna vastus igal real.",
    numericError: "See peaks olema numbriline väärtus.",
    textMinLength: "Palun sisesta vähemalt {0} tähemärki.",
    textMaxLength: "Palun ära sisesta rohkem kui {0} tähemärki.",
    textMinMaxLength: "Sisesta palun {0} - {1} tähemärki.",
    minRowCountError: "Sisesta plaun vähemalt {0} rida.",
    minSelectError: "Palun vali vähemalt {0} varianti.",
    maxSelectError: "Palun vali kõige rohkem {0} varianti.",
    numericMinMax: "'{0}' peaks olema võrdne või suurem kui {1} ja võrdne või väiksem kui {2}",
    numericMin: "'{0}' peaks olema võrdne või suurem kui {1}",
    numericMax: "'{0}' peaks olema võrnde või väiksem kui {1}",
    invalidEmail: "Sisesta palun korrektne e-posti aadress.",
    invalidExpression: "Avaldis: {0} peaks tagastama tõese.",
    urlRequestError: "Taotlus tagastas vea „{0}”. {1}",
    urlGetChoicesError: "Taotlus tagastas tühjad andmed või atribuut 'path' on vale",
    exceedMaxSize: "Faili suurus ei tohi ületada {0}.",
    otherRequiredError: "Sisesta palun muu vastus.",
    uploadingFile: "Sinu fail laeb üles. Palun oota mõned sekundid ning proovi seejärel uuesti.",
    loadingFile: "Laen...",
    chooseFile: "Vali fail(id)...",
    noFileChosen: "Faili pole valitud",
    confirmDelete: "Kas tahad kirje kustutada?",
    keyDuplicationError: "See väärtus peab olema unikaalne.",
    addColumn: "Lisa veerg",
    addRow: "Lisa rida",
    removeRow: "Eemalda",
    addPanel: "Lisa uus",
    removePanel: "Eemalda",
    choices_Item: "üksus",
    matrix_column: "Veerg",
    matrix_row: "Rida",
    savingData: "Salvestan andmed serveris...",
    savingDataError: "Tekkis viga ning me ei saanud vastuseid salvestada.",
    savingDataSuccess: "Vastuste salvestamine õnnestus!",
    saveAgainButton: "Proovi uuesti",
    timerMin: "min",
    timerSec: "sek",
    timerSpentAll: "Oled veetnud {0} sellel lehel ning kokku {1}.",
    timerSpentPage: "Oled veetnud {0} sellel lehel.",
    timerSpentSurvey: "Oled veetnud {0} kokku.",
    timerLimitAll: "Oled kulutanud {0} võimalikust {1} sellel lehel ning {2} võimalikust {3} kokku.",
    timerLimitPage: "Oled kulutanud {0} võimalikust {1} sellel lehel.",
    timerLimitSurvey: "Oled kulutanud {0} võimalikust {1} koguajast.",
    cleanCaption: "Puhasta",
    clearCaption: "Puhasta",
    chooseFileCaption: "Vali fail",
    removeFileCaption: "Eemalda see fail",
    booleanCheckedLabel: "Jah",
    booleanUncheckedLabel: "Ei",
    confirmRemoveFile: "Oled sa kindel, et soovid selle faili eemaldada: {0}?",
    confirmRemoveAllFiles: "Oled sa kindel, et soovid eemaldada kõik failid?",
    questionTitlePatternText: "Küsimuse pealkiri",
};
_surveyStrings__WEBPACK_IMPORTED_MODULE_0__["surveyLocalization"].locales["et"] = estonianSurveyStrings;
_surveyStrings__WEBPACK_IMPORTED_MODULE_0__["surveyLocalization"].localeNames["et"] = "eesti keel";


/***/ }),

/***/ "./src/localization/finnish.ts":
/*!*************************************!*\
  !*** ./src/localization/finnish.ts ***!
  \*************************************/
/*! exports provided: finnishSurveyStrings */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "finnishSurveyStrings", function() { return finnishSurveyStrings; });
/* harmony import */ var _surveyStrings__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ../surveyStrings */ "./src/surveyStrings.ts");

var finnishSurveyStrings = {
    pagePrevText: "Edellinen",
    pageNextText: "Seuraava",
    completeText: "Valmis",
    previewText: "Esikatselu",
    editText: "Muokkaa",
    startSurveyText: "Aloita",
    otherItemText: "Muu (tarkenna)",
    noneItemText: "Ei mitään",
    selectAllItemText: "Valitse kaikki",
    progressText: "Sivu {0} / {1}",
    panelDynamicProgressText: "Osio {0} / {1}",
    questionsProgressText: "Olet vastannut {0} / {1} kysymykseen.",
    emptySurvey: "Tässä kyselyssä ei ole yhtään näkyvillä olevaa sivua tai kysymystä.",
    completingSurvey: "Kiitos kyselyyn vastaamisesta!",
    completingSurveyBefore: "Tietojemme mukaan olet jo suorittanut tämän kyselyn.",
    loadingSurvey: "Kyselyä ladataan palvelimelta...",
    optionsCaption: "Valitse...",
    value: "arvo",
    requiredError: "Vastaa kysymykseen, kiitos.",
    requiredErrorInPanel: "Vastaa ainakin yhteen kysymykseen.",
    requiredInAllRowsError: "Vastaa kysymyksiin kaikilla riveillä.",
    numericError: "Arvon tulee olla numeerinen.",
    textMinLength: "Syötä vähintään {0} merkkiä.",
    textMaxLength: "Älä syötä yli {0} merkkiä.",
    textMinMaxLength: "Syötä vähintään {0} ja enintään {1} merkkiä.",
    minRowCountError: "Täytä vähintään {0} riviä.",
    minSelectError: "Valitse vähintään {0} vaihtoehtoa.",
    maxSelectError: "Valitse enintään {0} vaihtoehtoa.",
    numericMinMax: "Luvun '{0}' tulee olla vähintään {1} ja korkeintaan {2}.",
    numericMin: "Luvun '{0}' tulee olla vähintään {1}.",
    numericMax: "Luvun '{0}' tulee olla korkeintaan {1}.",
    invalidEmail: "Syötä validi sähköpostiosoite.",
    invalidExpression: "Lausekkeen: {0} pitäisi palauttaa 'true'.",
    urlRequestError: "Pyyntö palautti virheen {0}. {1}",
    urlGetChoicesError: "Pyyntö palautti tyhjän tiedoston tai 'path'-asetus on väärä",
    exceedMaxSize: "Tiedoston koko ei saa olla suurempi kuin {0}.",
    otherRequiredError: "Tarkenna vastaustasi tekstikenttään.",
    uploadingFile: "Tiedostoa lähetetään. Odota muutama sekunti ja yritä uudelleen.",
    loadingFile: "Ladataan...",
    chooseFile: "Valitse tiedosto(t)...",
    noFileChosen: "Ei tiedostoa valittuna",
    confirmDelete: "Haluatko poistaa osion?",
    keyDuplicationError: "Tämä arvo on jo käytössä. Syötä toinen arvo.",
    addColumn: "Lisää sarake",
    addRow: "Lisää rivi",
    removeRow: "Poista",
    emptyRowsText: "Ei rivejä",
    addPanel: "Lisää uusi",
    removePanel: "Poista",
    choices_Item: "kohde",
    matrix_column: "Sarake",
    matrix_row: "Rivi",
    savingData: "Tietoja tallennetaan palvelimelle...",
    savingDataError: "Tapahtui virhe, emmekä voineet tallentaa kyselyn tietoja.",
    savingDataSuccess: "Tiedot tallennettiin onnistuneesti!",
    saveAgainButton: "Yritä uudelleen",
    timerMin: "min",
    timerSec: "sek",
    timerSpentAll: "Olet käyttänyt {0} tällä sivulla ja yhteensä {1}.",
    timerSpentPage: "Olet käyttänyt {0} tällä sivulla.",
    timerSpentSurvey: "Olet käyttänyt yhteensä {0}.",
    timerLimitAll: "Olet käyttänyt tällä sivulla {0} / {1} ja yhteensä {2} / {3}.",
    timerLimitPage: "Olet käyttänyt {0} / {1} tällä sivulla.",
    timerLimitSurvey: "Olet käyttänyt yhteensä {0} / {1}.",
    cleanCaption: "Pyyhi",
    clearCaption: "Tyhjennä",
    chooseFileCaption: "Valitse tiedosto",
    removeFileCaption: "Poista tämä tiedosto",
    booleanCheckedLabel: "Kyllä",
    booleanUncheckedLabel: "Ei",
    confirmRemoveFile: "Haluatko varmasti poistaa tämän tiedoston: {0}?",
    confirmRemoveAllFiles: "Haluatko varmasti poistaa kaikki tiedostot?",
    questionTitlePatternText: "Kysymyksen otsikko",
    modalCancelButtonText: "Peruuta",
    modalApplyButtonText: "Käytä",
};
_surveyStrings__WEBPACK_IMPORTED_MODULE_0__["surveyLocalization"].locales["fi"] = finnishSurveyStrings;
_surveyStrings__WEBPACK_IMPORTED_MODULE_0__["surveyLocalization"].localeNames["fi"] = "suomi";


/***/ }),

/***/ "./src/localization/french.ts":
/*!************************************!*\
  !*** ./src/localization/french.ts ***!
  \************************************/
/*! exports provided: frenchSurveyStrings */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "frenchSurveyStrings", function() { return frenchSurveyStrings; });
/* harmony import */ var _surveyStrings__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ../surveyStrings */ "./src/surveyStrings.ts");

var frenchSurveyStrings = {
    pagePrevText: "Précédent",
    pageNextText: "Suivant",
    completeText: "Terminer",
    previewText: "Aperçu",
    editText: "Modifier",
    startSurveyText: "Commencer",
    otherItemText: "Autre (préciser)",
    noneItemText: "Aucun",
    selectAllItemText: "Tout sélectionner",
    progressText: "Page {0} sur {1}",
    panelDynamicProgressText: "Enregistrement {0} sur {1}",
    questionsProgressText: "{0}/{1} question(s) répondue(s)",
    emptySurvey: "Il n'y a ni page visible ni question visible dans ce questionnaire",
    completingSurvey: "Merci d'avoir répondu au questionnaire !",
    completingSurveyBefore: "Nos données indiquent que vous avez déjà rempli ce questionnaire.",
    loadingSurvey: "Le questionnaire est en cours de chargement...",
    optionsCaption: "Choisissez...",
    value: "valeur",
    requiredError: "La réponse à cette question est obligatoire.",
    requiredErrorInPanel: "Merci de répondre au moins à une question.",
    requiredInAllRowsError: "Toutes les lignes sont obligatoires",
    numericError: "La réponse doit être un nombre.",
    textMinLength: "Merci de saisir au moins {0} caractères.",
    textMaxLength: "Merci de saisir moins de {0} caractères.",
    textMinMaxLength: "Merci de saisir entre {0} et {1} caractères.",
    minRowCountError: "Merci de compléter au moins {0} lignes.",
    minSelectError: "Merci de sélectionner au minimum {0} réponses.",
    maxSelectError: "Merci de sélectionner au maximum {0} réponses.",
    numericMinMax: "Votre réponse '{0}' doit être supérieure ou égale à {1} et inférieure ou égale à {2}",
    numericMin: "Votre réponse '{0}' doit être supérieure ou égale à {1}",
    numericMax: "Votre réponse '{0}' doit être inférieure ou égale à {1}",
    invalidEmail: "Merci d'entrer une adresse mail valide.",
    invalidExpression: "L'expression: {0} doit retourner 'true'.",
    urlRequestError: "La requête a renvoyé une erreur '{0}'. {1}",
    urlGetChoicesError: "La requête a renvoyé des données vides ou la propriété 'path' est incorrecte",
    exceedMaxSize: "La taille du fichier ne doit pas excéder {0}.",
    otherRequiredError: "Merci de préciser le champ 'Autre'.",
    uploadingFile: "Votre fichier est en cours de chargement. Merci d'attendre quelques secondes et de réessayer.",
    loadingFile: "Chargement...",
    chooseFile: "Ajouter des fichiers...",
    noFileChosen: "Aucun fichier ajouté",
    confirmDelete: "Voulez-vous supprimer cet enregistrement ?",
    keyDuplicationError: "Cette valeur doit être unique.",
    addColumn: "Ajouter une colonne",
    addRow: "Ajouter une ligne",
    removeRow: "Supprimer",
    addPanel: "Ajouter",
    removePanel: "Supprimer",
    choices_Item: "item",
    matrix_column: "Colonne",
    matrix_row: "Ligne",
    savingData: "Les résultats sont en cours de sauvegarde sur le serveur...",
    savingDataError: "Une erreur est survenue et a empêché la sauvegarde des résultats.",
    savingDataSuccess: "Les résultats ont bien été enregistrés !",
    saveAgainButton: "Réessayer",
    timerMin: "min",
    timerSec: "sec",
    timerSpentAll: "Vous avez passé {0} sur cette page et {1} au total.",
    timerSpentPage: "Vous avez passé {0} sur cette page.",
    timerSpentSurvey: "Vous avez passé {0} au total.",
    timerLimitAll: "Vous avez passé {0} sur {1} sur cette page et {2} sur {3} au total.",
    timerLimitPage: "Vous avez passé {0} sur {1} sur cette page.",
    timerLimitSurvey: "Vous avez passé {0} sur {1} au total.",
    cleanCaption: "Nettoyer",
    clearCaption: "Vider",
    chooseFileCaption: "Ajouter un fichier",
    removeFileCaption: "Enlever ce fichier",
    booleanCheckedLabel: "Oui",
    booleanUncheckedLabel: "Non",
    confirmRemoveFile: "Êtes-vous certains de vouloir supprimer ce fichier : {0}?",
    confirmRemoveAllFiles: "Êtes-vous certains de vouloir supprimer tous les fichiers?",
    questionTitlePatternText: "Titre de la question",
};
_surveyStrings__WEBPACK_IMPORTED_MODULE_0__["surveyLocalization"].locales["fr"] = frenchSurveyStrings;
_surveyStrings__WEBPACK_IMPORTED_MODULE_0__["surveyLocalization"].localeNames["fr"] = "français";


/***/ }),

/***/ "./src/localization/georgian.ts":
/*!**************************************!*\
  !*** ./src/localization/georgian.ts ***!
  \**************************************/
/*! exports provided: georgianSurveyStrings */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "georgianSurveyStrings", function() { return georgianSurveyStrings; });
/* harmony import */ var _surveyStrings__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ../surveyStrings */ "./src/surveyStrings.ts");

var georgianSurveyStrings = {
    pagePrevText: "უკან",
    pageNextText: "შემდეგ",
    completeText: "დასრულება",
    progressText: "გვერდი {0} / {1}",
    emptySurvey: "არცერთი კითხვა არ არის.",
    completingSurvey: "გმადლობთ კითხვარის შევსებისთვის!",
    loadingSurvey: "ჩატვირთვა სერვერიდან...",
    otherItemText: "სხვა (გთხოვთ მიუთითეთ)",
    optionsCaption: "არჩევა...",
    requiredError: "გთხოვთ უპასუხეთ კითხვას.",
    numericError: "პასუხი უნდა იყოს რიცხვი.",
    textMinLength: "გთხოვთ შეიყვანეთ არანაკლებ {0} სიმბოლო.",
    minSelectError: "გთხოვთ აირჩიეთ არანაკლებ {0} ვარიანტი.",
    maxSelectError: "გთხოვთ აირჩიეთ არაუმეტეს {0} ვარიანტი.",
    numericMinMax: "'{0}' უნდა იყოს მეტი ან ტოლი, ვიდრე {1}, და ნაკლები ან ტოლი ვიდრე {2}",
    numericMin: "'{0}' უნდა იყოს მეტი ან ტოლი ვიდრე {1}",
    numericMax: "'{0}' უნდა იყოს ნაკლები ან ტოლი ვიდრე {1}",
    invalidEmail: "გთხოვთ შეიყვანოთ ელ. ფოსტის რეალური მისამართი.",
    otherRequiredEror: "გთხოვთ შეავსეთ ველი 'სხვა'"
};
_surveyStrings__WEBPACK_IMPORTED_MODULE_0__["surveyLocalization"].locales["ka"] = georgianSurveyStrings;
_surveyStrings__WEBPACK_IMPORTED_MODULE_0__["surveyLocalization"].localeNames["ka"] = "ქართული";


/***/ }),

/***/ "./src/localization/german.ts":
/*!************************************!*\
  !*** ./src/localization/german.ts ***!
  \************************************/
/*! exports provided: germanSurveyStrings */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "germanSurveyStrings", function() { return germanSurveyStrings; });
/* harmony import */ var _surveyStrings__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ../surveyStrings */ "./src/surveyStrings.ts");

var germanSurveyStrings = {
    pagePrevText: "Zurück",
    pageNextText: "Weiter",
    completeText: "Abschließen",
    previewText: "Vorschau",
    editText: "Bearbeiten",
    startSurveyText: "Start",
    otherItemText: "Sonstiges (Bitte angeben)",
    noneItemText: "Nichts trifft zu",
    selectAllItemText: "Alles auswählen",
    progressText: "Seite {0} von {1}",
    panelDynamicProgressText: "Eintrag {0} von {1}",
    questionsProgressText: "{0}/{1} Fragen beantwortet",
    emptySurvey: "Es sind keine Fragen vorhanden.",
    completingSurvey: "Vielen Dank, dass Sie die Umfrage abgeschlossen haben!",
    completingSurveyBefore: "Wir haben festgestellt, dass Sie diese Umfrage bereits abgeschlossen haben.",
    loadingSurvey: "Umfrage wird geladen...",
    optionsCaption: "Bitte auswählen...",
    value: "Wert",
    requiredError: "Bitte beantworten Sie diese Frage.",
    requiredErrorInPanel: "Bitte beantworten Sie mindestens eine Frage.",
    requiredInAllRowsError: "Bitte beantworten Sie alle Fragen.",
    numericError: "Der Wert muss eine Zahl sein.",
    textMinLength: "Bitte geben Sie mindestens {0} Zeichen ein.",
    textMaxLength: "Bitte geben Sie nicht mehr als {0} Zeichen ein.",
    textMinMaxLength: "Bitte geben Sie mindestens {0} und maximal {1} Zeichen ein.",
    minRowCountError: "Bitte machen Sie in mindestens {0} Zeilen eine Eingabe.",
    minSelectError: "Bitte wählen Sie mindestens {0} Antwort(en) aus.",
    maxSelectError: "Bitte wählen Sie nicht mehr als {0} Antwort(en) aus.",
    numericMinMax: "'{0}' muss größer oder gleich {1} und kleiner oder gleich {2} sein",
    numericMin: "'{0}' muss größer oder gleich {1} sein",
    numericMax: "'{0}' muss kleiner oder gleich {1} sein",
    invalidEmail: "Bitte geben Sie eine gültige E-Mail-Adresse ein.",
    invalidExpression: "Der Ausdruck: {0} muss den Wert 'wahr' zurückgeben.",
    urlRequestError: "Ein Netzwerkdienst hat folgenden Fehler zurückgegeben '{0}'. {1}",
    urlGetChoicesError: "Eine Netzwerkdienst hat ungültige Daten zurückgegeben",
    exceedMaxSize: "Die Datei darf nicht größer als {0} sein.",
    otherRequiredError: "Bitte geben Sie einen Wert an.",
    uploadingFile: "Bitte warten Sie bis der Upload Ihrer Dateien abgeschlossen ist.",
    loadingFile: "Wird hochgeladen...",
    chooseFile: "Datei(en) auswählen...",
    noFileChosen: "Keine Datei ausgewählt",
    confirmDelete: "Wollen Sie den Eintrag löschen?",
    keyDuplicationError: "Dieser Wert muss einmalig sein.",
    addColumn: "Spalte hinzufügen",
    addRow: "Zeile hinzufügen",
    removeRow: "Entfernen",
    addPanel: "Neu hinzufügen",
    removePanel: "Entfernen",
    choices_Item: "Element",
    matrix_column: "Spalte",
    matrix_row: "Zeile",
    savingData: "Die Ergebnisse werden auf dem Server gespeichert...",
    savingDataError: "Es ist ein Fehler aufgetreten. Die Ergebnisse konnten nicht gespeichert werden.",
    savingDataSuccess: "Die Ergebnisse wurden gespeichert!",
    saveAgainButton: "Erneut absenden",
    timerMin: "Min.",
    timerSec: "Sek.",
    timerSpentAll: "Sie waren {0} auf dieser Seite und brauchten insgesamt {1}.",
    timerSpentPage: "Sie waren {0} auf dieser Seite.",
    timerSpentSurvey: "Sie haben insgesamt {0} gebraucht.",
    timerLimitAll: "Sie waren {0} von {1} auf dieser Seite und brauchten insgesamt {2} von {3}.",
    timerLimitPage: "Sie waren {0} von {1} auf dieser Seite.",
    timerLimitSurvey: "Sie haben insgesamt {0} von {1} gebraucht.",
    cleanCaption: "Alles löschen",
    clearCaption: "Auswahl entfernen",
    chooseFileCaption: "Datei auswählen",
    removeFileCaption: "Datei löschen",
    booleanCheckedLabel: "Ja",
    booleanUncheckedLabel: "Nein",
    confirmRemoveFile: "Sind Sie sicher, dass Sie diese Datei löschen möchten: {0}?",
    confirmRemoveAllFiles: "Sind Sie sicher, dass Sie alle Dateien löschen möchten?",
    questionTitlePatternText: "Fragentitel",
};
_surveyStrings__WEBPACK_IMPORTED_MODULE_0__["surveyLocalization"].locales["de"] = germanSurveyStrings;
_surveyStrings__WEBPACK_IMPORTED_MODULE_0__["surveyLocalization"].localeNames["de"] = "deutsch";


/***/ }),

/***/ "./src/localization/greek.ts":
/*!***********************************!*\
  !*** ./src/localization/greek.ts ***!
  \***********************************/
/*! exports provided: greekSurveyStrings */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "greekSurveyStrings", function() { return greekSurveyStrings; });
/* harmony import */ var _surveyStrings__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ../surveyStrings */ "./src/surveyStrings.ts");
//Created by https://github.com/agelospanagiotakis

var greekSurveyStrings = {
    pagePrevText: "Προηγούμενο",
    pageNextText: "Επόμενο",
    completeText: "Ολοκλήρωση",
    previewText: "Προεπισκόπηση",
    editText: "Επεξεργασία",
    startSurveyText: "Αρχή",
    otherItemText: "Άλλο (παρακαλώ διευκρινίστε)",
    noneItemText: "Κανένας",
    selectAllItemText: "Επιλογή όλων",
    progressText: "Σελίδα {0} από {1}",
    panelDynamicProgressText: "Εγγραφή {0} από {1}",
    questionsProgressText: "Απαντήθηκαν {0} / {1} ερωτήσεις",
    emptySurvey: "Δεν υπάρχει καμία ορατή σελίδα ή ορατή ερώτηση σε αυτό το ερωτηματολόγιο.",
    completingSurvey: "Ευχαριστούμε για την συμπλήρωση αυτού του ερωτηματολογίου!",
    completingSurveyBefore: "Τα αρχεία μας δείχνουν ότι έχετε ήδη ολοκληρώσει αυτήν την έρευνα.",
    loadingSurvey: "Το ερωτηματολόγιο φορτώνεται απο το διακομιστή...",
    optionsCaption: "Επιλέξτε...",
    value: "αξία",
    requiredError: "Παρακαλώ απαντήστε στην ερώτηση.",
    requiredErrorInPanel: "Απαντήστε σε τουλάχιστον μία ερώτηση.",
    requiredInAllRowsError: "Παρακαλώ απαντήστε στις ερωτήσεις σε όλες τις γραμμές.",
    numericError: "Η τιμή πρέπει να είναι αριθμητική.",
    textMinLength: "Παρακαλώ συμπληρώστε τουλάχιστον {0} σύμβολα.",
    textMaxLength: "Εισαγάγετε λιγότερους από {0} χαρακτήρες.",
    textMinMaxLength: "Εισαγάγετε περισσότερους από {0} και λιγότερους από {1} χαρακτήρες.",
    minRowCountError: "Παρακαλώ συμπληρώστε τουλάχιστον {0} γραμμές.",
    minSelectError: "Παρακαλώ επιλέξτε τουλάχιστον {0} παραλλαγές.",
    maxSelectError: "Παρακαλώ επιλέξτε όχι παραπάνω απο {0} παραλλαγές.",
    numericMinMax: "Το '{0}' θα πρέπει να είναι ίσο ή μεγαλύτερο απο το {1} και ίσο ή μικρότερο απο το {2}",
    numericMin: "Το '{0}' πρέπει να είναι μεγαλύτερο ή ισο με το {1}",
    numericMax: "Το '{0}' πρέπει να είναι μικρότερο ή ίσο απο το {1}",
    invalidEmail: "Παρακαλώ δώστε μια αποδεκτή διεύθυνση e-mail.",
    invalidExpression: "Η έκφραση: {0} θα πρέπει να επιστρέψει 'true'.",
    urlRequestError: "Η αίτηση επέστρεψε σφάλμα '{0}'. {1}",
    urlGetChoicesError: "Η αίτηση επέστρεψε κενά δεδομένα ή η ιδιότητα 'μονοπάτι/path' είναι εσφαλμένη",
    exceedMaxSize: "Το μέγεθος δεν μπορεί να υπερβαίνει τα {0}.",
    otherRequiredError: "Παρακαλώ συμπληρώστε την τιμή για το πεδίο 'άλλο'.",
    uploadingFile: "Το αρχείο σας ανεβαίνει. Παρακαλώ περιμένετε καποια δευτερόλεπτα και δοκιμάστε ξανά.",
    loadingFile: "Φόρτωση...",
    chooseFile: "Επιλογή αρχείων ...",
    noFileChosen: "Δεν έχει επιλεγεί αρχείο",
    confirmDelete: "Θέλετε να διαγράψετε την εγγραφή;",
    keyDuplicationError: "Αυτή η τιμή πρέπει να είναι μοναδική.",
    addColumn: "Προσθήκη στήλης",
    addRow: "Προσθήκη γραμμής",
    removeRow: "Αφαίρεση",
    addPanel: "Προσθεσε νεο",
    removePanel: "Αφαιρώ",
    choices_Item: "είδος",
    matrix_column: "Στήλη",
    matrix_row: "Σειρά",
    savingData: "Τα αποτελέσματα αποθηκεύονται στον διακομιστή ...",
    savingDataError: "Παρουσιάστηκε σφάλμα και δεν ήταν δυνατή η αποθήκευση των αποτελεσμάτων.",
    savingDataSuccess: "Τα αποτελέσματα αποθηκεύτηκαν με επιτυχία!",
    saveAgainButton: "Προσπάθησε ξανά",
    timerMin: "ελάχ",
    timerSec: "δευτ",
    timerSpentAll: "Έχετε δαπανήσει {0} σε αυτήν τη σελίδα και {1} συνολικά.",
    timerSpentPage: "Έχετε ξοδέψει {0} σε αυτήν τη σελίδα.",
    timerSpentSurvey: "Έχετε ξοδέψει συνολικά {0}.",
    timerLimitAll: "Έχετε δαπανήσει {0} από {1} σε αυτήν τη σελίδα και {2} από {3} συνολικά.",
    timerLimitPage: "Έχετε ξοδέψει {0} από {1} σε αυτήν τη σελίδα.",
    timerLimitSurvey: "Έχετε ξοδέψει {0} από {1} συνολικά.",
    cleanCaption: "ΚΑΘΑΡΗ",
    clearCaption: "Σαφή",
    chooseFileCaption: "Επιλέξτε το αρχείο",
    removeFileCaption: "Καταργήστε αυτό το αρχείο",
    booleanCheckedLabel: "Ναί",
    booleanUncheckedLabel: "Οχι",
    confirmRemoveFile: "Είστε βέβαιοι ότι θέλετε να καταργήσετε αυτό το αρχείο: {0};",
    confirmRemoveAllFiles: "Είστε βέβαιοι ότι θέλετε να καταργήσετε όλα τα αρχεία;",
    questionTitlePatternText: "Τίτλος ερώτησης",
};
_surveyStrings__WEBPACK_IMPORTED_MODULE_0__["surveyLocalization"].locales["gr"] = greekSurveyStrings;
_surveyStrings__WEBPACK_IMPORTED_MODULE_0__["surveyLocalization"].localeNames["gr"] = "ελληνικά";


/***/ }),

/***/ "./src/localization/hebrew.ts":
/*!************************************!*\
  !*** ./src/localization/hebrew.ts ***!
  \************************************/
/*! exports provided: hebrewSurveyStrings */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "hebrewSurveyStrings", function() { return hebrewSurveyStrings; });
/* harmony import */ var _surveyStrings__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ../surveyStrings */ "./src/surveyStrings.ts");

var hebrewSurveyStrings = {
    pagePrevText: "אחורה",
    pageNextText: "קדימה",
    completeText: "סיום",
    previewText: "תצוגה מקדימה",
    editText: "לַעֲרוֹך",
    startSurveyText: "הַתחָלָה",
    otherItemText: "אחר (נא לתאר)",
    noneItemText: "אף אחד",
    selectAllItemText: "בחר הכל",
    progressText: "דף {1} מתוך {0}",
    panelDynamicProgressText: "הקלטה {0} מתוך {1}",
    questionsProgressText: "ענה על שאלות",
    emptySurvey: "אין שאלות",
    completingSurvey: "תודה על מילוי השאלון!",
    completingSurveyBefore: "הרשומות שלנו מראות שכבר סיימת את הסקר הזה.",
    loadingSurvey: "טעינה מהשרת...",
    optionsCaption: "בחר...",
    value: "ערך",
    requiredError: "אנא השב על השאלה",
    requiredErrorInPanel: "אנא ענה לפחות על שאלה אחת.",
    requiredInAllRowsError: "אנא ענה על שאלות בכל השורות.",
    numericError: "התשובה צריכה להיות מספר.",
    textMinLength: "הזן לפחות {0} תווים.",
    textMaxLength: "הזן פחות מ- {0} תווים.",
    textMinMaxLength: "הזן יותר מ- {0} ופחות מ- {1} תווים.",
    minRowCountError: "אנא מלא לפחות {0} שורות.",
    minSelectError: "בחר לפחות {0} אפשרויות.",
    maxSelectError: "בחר עד {0} אפשרויות.",
    numericMinMax: "'{0}' חייב להיות שווה או גדול מ {1}, ושווה ל- {2} או פחות מ- {}}",
    numericMin: "'{0}' חייב להיות שווה או גדול מ {1}",
    numericMax: "'{0}' חייב להיות שווה או קטן מ {1}",
    invalidEmail: 'הזן כתובת דוא"ל חוקית.',
    invalidExpression: "הביטוי: {0} צריך להחזיר 'אמת'.",
    urlRequestError: "הבקשה החזירה את השגיאה '{0}'. {1}",
    urlGetChoicesError: "הבקשה החזירה נתונים ריקים או שהמאפיין 'נתיב' שגוי",
    exceedMaxSize: "גודל הקובץ לא יעלה על {0}.",
    otherRequiredError: 'נא להזין נתונים בשדה "אחר"',
    uploadingFile: "הקובץ שלך נטען. המתן מספר שניות ונסה שוב.",
    loadingFile: "טוען...",
    chooseFile: "לבחור קבצים...",
    noFileChosen: "לא נבחר קובץ",
    confirmDelete: "האם אתה רוצה למחוק את הרשומה?",
    keyDuplicationError: "ערך זה צריך להיות ייחודי.",
    addColumn: "הוסף עמודה",
    addRow: "להוסיף שורה",
    removeRow: "לְהַסִיר",
    addPanel: "הוסף חדש",
    removePanel: "לְהַסִיר",
    choices_Item: "פריט",
    matrix_column: "טור",
    matrix_row: "שׁוּרָה",
    savingData: "התוצאות נשמרות בשרת ...",
    savingDataError: "אירעה שגיאה ולא הצלחנו לשמור את התוצאות.",
    savingDataSuccess: "התוצאות נשמרו בהצלחה!",
    saveAgainButton: "נסה שוב",
    timerMin: "דקה",
    timerSec: "שניות",
    timerSpentAll: "הוצאת {0} בדף זה ובסך הכל {1}.",
    timerSpentPage: "הוצאת {0} בדף זה.",
    timerSpentSurvey: "הוצאת סכום כולל של {0}.",
    timerLimitAll: "הוצאת {0} מתוך {1} בדף זה ו- {2} מתוך {3} בסך הכל.",
    timerLimitPage: "הוצאת {0} מתוך {1} בדף זה.",
    timerLimitSurvey: "הוצאת סכום כולל של {0} מתוך {1}.",
    cleanCaption: "לְנַקוֹת",
    clearCaption: "ברור",
    chooseFileCaption: "בחר קובץ",
    removeFileCaption: "הסר קובץ זה",
    booleanCheckedLabel: "כן",
    booleanUncheckedLabel: "לא",
    confirmRemoveFile: "האם אתה בטוח שברצונך להסיר קובץ זה: {0}?",
    confirmRemoveAllFiles: "האם אתה בטוח שברצונך להסיר את כל הקבצים?",
    questionTitlePatternText: "כותרת שאלה",
};
_surveyStrings__WEBPACK_IMPORTED_MODULE_0__["surveyLocalization"].locales["he"] = hebrewSurveyStrings;
_surveyStrings__WEBPACK_IMPORTED_MODULE_0__["surveyLocalization"].localeNames["he"] = "עברית";


/***/ }),

/***/ "./src/localization/hindi.ts":
/*!***********************************!*\
  !*** ./src/localization/hindi.ts ***!
  \***********************************/
/*! exports provided: hindiStrings */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "hindiStrings", function() { return hindiStrings; });
/* harmony import */ var _surveyStrings__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ../surveyStrings */ "./src/surveyStrings.ts");

var hindiStrings = {
    pagePrevText: "पिछला",
    pageNextText: "अगला",
    completeText: "पूरा",
    previewText: "पूर्वसमीक्षा",
    editText: "संपादित",
    startSurveyText: "शुरू",
    otherItemText: "दूसरा (वर्णन करें)",
    noneItemTex: "कोई नहीं",
    selectAllItemText: "सभी का चयन करें",
    progressText: "पृष्ठ 1 में से 0",
    panelDynamicProgressText: " दस्तावेज {1} के {0}",
    questionsProgressText: "{1} सवालों में से {0} के जवाब दिए",
    emptySurvey: "सर्वेक्षण में कोई दृश्यमान पृष्ठ या प्रश्न नहीं है",
    completingSurvey: "सर्वेक्षण को पूरा करने के लिए धन्यवाद",
    completingSurveyBefore: " हमारे रिकॉर्ड बताते हैं कि आप पहले ही इस सर्वेक्षण को पूरा कर चुके हैं",
    loadingSurvey: "सर्वेक्षण खुल रहा है.…",
    optionsCaption: "चुनें",
    value: "मूल्य",
    requiredError: "कृपया प्रश्न का उत्तर दें",
    requiredErrorInPanel: "कृपया कम से कम एक प्रश्न का उत्तर दें",
    requiredInAllRowsError: "कृपया सभी पंक्तियों में सवालों के जवाब दें",
    numericError: "मूल्य संख्यात्मक होना चाहिए",
    textMinLength: "कृपया कम से कम {0} वर्ण दर्ज करें",
    textMaxLength: "कृपया {0} से कम वर्ण दर्ज करें",
    textMinMaxLength: "कृपया {0} से अधिक और {1} से कम पात्रों में प्रवेश करें",
    minRowCountError: "कृपया कम से कम {0} पंक्तियों को भरें",
    minSelectError: "कृपया कम से कम {0} विकल्प का चयन करें",
    maxSelectError: "कृपया {0} विकल्पों से अधिक नहीं चुनें",
    numericMinMax: "'{0}' {1} से बराबर या अधिक और {2} से बराबर या कम होना चाहिए",
    numericMin: "'{0}' {1} से बराबर या अधिक होना चाहिए",
    numericMax: "'{0}' {1} से बराबर या कम होना चाहिए",
    invalidEmail: "कृपया एक वैध ईमेल पता दर्ज करें",
    invalidExpression: "अभिव्यक्ति: {0} को ' सच ' लौटना चाहिए",
    urlRequestError: "अनुरोध लौटाया त्रुटि '{0}' . {1}",
    urlGetChoicesError: "अनुरोध ने खाली डेटा वापस कर दिया है ",
    exceedMaxSize: "फ़ाइल का आकार {0} से अधिक नहीं होना चाहिए  या फिर 'पाथ' प्रॉपर्टी गलत है",
    otherRequiredError: "कृपया दूसरा मूल्य दर्ज करें",
    uploadingFile: "आपकी फाइल अपलोड हो रही है। कृपया कई सेकंड इंतजार करें और फिर से प्रयास करें।",
    loadingFile: "लोडिंग",
    chooseFile: "फ़ाइल चुनें",
    noFileChosen: "कोई फाइल नहीं चुनी गई",
    confirmDelete: "क्या आप रिकॉर्ड हटाना चाहते हैं",
    keyDuplicationError: "यह मान अनोखा होना चाहिए",
    addColumn: "कॉलम जोड़ें",
    addRow: "पंक्ति जोड़ें",
    removeRow: "हटाए",
    addPanel: "नया जोड़ें",
    removePanel: "हटाए",
    choices_Item: "मद",
    matrix_column: "कॉलम",
    matrix_row: "पंक्ति",
    savingData: "परिणाम सर्वर पर सेव हो रहे हैं",
    savingDataError: "एक त्रुटि हुई और हम परिणामों को नहीं सेव कर सके",
    savingDataSuccess: "परिणाम सफलतापूर्वक सेव हो गए",
    saveAgainButton: "फिर कोशिश करो",
    timerMin: "मिनट",
    timerSec: "सेकंड",
    timerSpentAll: "आपने इस पृष्ठ पर {0} खर्च किए हैं और कुल {1}",
    timerSpentPage: "आपने इस पृष्ठ पर {0} खर्च किया है",
    timerSpentSurvey: "आपने कुल {0} खर्च किया है",
    timerLimitAll: "आपने इस पृष्ठ पर {1} की {0} और कुल {3} की {2} खर्च की है।",
    timerLimitPage: "आपने इस पृष्ठ पर {1} का {0} खर्च किया है",
    timerLimitSurvey: "आपने कुल {1} की {0} खर्च की है",
    cleanCaption: "साफ",
    clearCaption: "स्पष्ट",
    chooseFileCaption: "फ़ाइल चुनें",
    removeFileCaption: "इस फाइल को निकालें",
    booleanCheckedLabel: "हाँ",
    booleanUncheckedLabel: "नहीं",
    confirmRemoveFile: "क्या आप सुनिश्चित हैं कि आप इस फ़ाइल को हटाना चाहते हैं: {0}",
    confirmRemoveAllFiles: "क्या आप सुनिश्चित हैं कि आप सभी फ़ाइलों को हटाना चाहते हैं",
    questionTitlePatternText: "प्रश्न का शीर्षक",
};
_surveyStrings__WEBPACK_IMPORTED_MODULE_0__["surveyLocalization"].locales["hi"] = hindiStrings;
_surveyStrings__WEBPACK_IMPORTED_MODULE_0__["surveyLocalization"].localeNames["hi"] = "hindi";


/***/ }),

/***/ "./src/localization/hungarian.ts":
/*!***************************************!*\
  !*** ./src/localization/hungarian.ts ***!
  \***************************************/
/*! exports provided: hungarianSurveyStrings */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "hungarianSurveyStrings", function() { return hungarianSurveyStrings; });
/* harmony import */ var _surveyStrings__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ../surveyStrings */ "./src/surveyStrings.ts");

var hungarianSurveyStrings = {
    pagePrevText: "Vissza",
    pageNextText: "Tovább",
    completeText: "Kész",
    previewText: "Előnézet",
    editText: "Szerkesztés",
    startSurveyText: "Rajt",
    otherItemText: "Egyéb (adja meg)",
    noneItemText: "Egyik sem",
    selectAllItemText: "Mindet kiválaszt",
    progressText: "{0}./{1} oldal",
    panelDynamicProgressText: "{0} / {1} rekord",
    questionsProgressText: "Válaszolt kérdések: {0} / {1}",
    emptySurvey: "There is no visible page or question in the survey.",
    completingSurvey: "Köszönjük, hogy kitöltötte felmérésünket!",
    completingSurveyBefore: "Már kitöltötte a felmérést.",
    loadingSurvey: "Felmérés betöltése...",
    optionsCaption: "Válasszon...",
    value: "érték",
    requiredError: "Kérjük, válaszolja meg ezt a kérdést!",
    requiredErrorInPanel: "Kérjük, válaszoljon legalább egy kérdésre.",
    requiredInAllRowsError: "Kérjük adjon választ minden sorban!",
    numericError: "Az érték szám kell, hogy legyen!",
    textMinLength: "Adjon meg legalább {0} karaktert!",
    textMaxLength: "Legfeljebb {0} karaktert adjon meg!",
    textMinMaxLength: "Adjon meg legalább {0}, de legfeljebb {1} karaktert!",
    minRowCountError: "Töltsön ki minimum {0} sort!",
    minSelectError: "Válasszon ki legalább {0} lehetőséget!",
    maxSelectError: "Ne válasszon többet, mint {0} lehetőség!",
    numericMinMax: "'{0}' legyen nagyobb, vagy egyenlő, mint {1} és kisebb, vagy egyenlő, mint {2}!",
    numericMin: "'{0}' legyen legalább {1}!",
    numericMax: "The '{0}' ne legyen nagyobb, mint {1}!",
    invalidEmail: "Adjon meg egy valós email címet!",
    invalidExpression: "A következő kifejezés: {0} vissza kell adnia az „igaz” értéket.",
    urlRequestError: "A lekérdezés hibával tért vissza: '{0}'. {1}",
    urlGetChoicesError: "A lekérdezés üres adattal tért vissza, vagy a 'path' paraméter helytelen.",
    exceedMaxSize: "A méret nem lehet nagyobb, mint {0}.",
    otherRequiredError: "Adja meg az egyéb értéket!",
    uploadingFile: "Feltöltés folyamatban. Várjon pár másodpercet, majd próbálja újra.",
    loadingFile: "Betöltés...",
    chooseFile: "Fájlok kiválasztása ...",
    noFileChosen: "Nincs kiválasztva fájl",
    confirmDelete: "Törli ezt a rekordot?",
    keyDuplicationError: "Az értéknek egyedinek kell lennie.",
    addColumn: "Oszlop hozzáadása",
    addRow: "Sor hozzáadása",
    removeRow: "Eltávolítás",
    addPanel: "Új hozzáadása",
    removePanel: "Eltávolítás",
    choices_Item: "elem",
    matrix_column: "Oszlop",
    matrix_row: "Sor",
    savingData: "Eredmény mentése a szerverre...",
    savingDataError: "Egy hiba folytán nem tudtuk elmenteni az eredményt.",
    savingDataSuccess: "Eredmény sikeresen mentve!",
    saveAgainButton: "Próbálja újra",
    timerMin: "min",
    timerSec: "sec",
    timerSpentAll: "Ön {0} összeget költött ezen az oldalon, és összesen {1}.",
    timerSpentPage: "{0} összeget költött ezen az oldalon.",
    timerSpentSurvey: "Összesen {0} költött.",
    timerLimitAll: "Ön {0} / {1} összeget költött ezen az oldalon, és összesen {2} / {3}.",
    timerLimitPage: "Ön {0} / {1} összeget költött ezen az oldalon.",
    timerLimitSurvey: "Összesen {0} / {1} összeget költött el.",
    cleanCaption: "Tiszta",
    clearCaption: "Egyértelmű",
    chooseFileCaption: "Válassz fájlt",
    removeFileCaption: "Távolítsa el ezt a fájlt",
    booleanCheckedLabel: "Igen",
    booleanUncheckedLabel: "Nem",
    confirmRemoveFile: "Biztosan eltávolítja ezt a fájlt: {0}?",
    confirmRemoveAllFiles: "Biztosan el akarja távolítani az összes fájlt?",
    questionTitlePatternText: "Kérdés címe",
};
_surveyStrings__WEBPACK_IMPORTED_MODULE_0__["surveyLocalization"].locales["hu"] = hungarianSurveyStrings;
_surveyStrings__WEBPACK_IMPORTED_MODULE_0__["surveyLocalization"].localeNames["hu"] = "magyar";


/***/ }),

/***/ "./src/localization/icelandic.ts":
/*!***************************************!*\
  !*** ./src/localization/icelandic.ts ***!
  \***************************************/
/*! exports provided: icelandicSurveyStrings */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "icelandicSurveyStrings", function() { return icelandicSurveyStrings; });
/* harmony import */ var _surveyStrings__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ../surveyStrings */ "./src/surveyStrings.ts");

var icelandicSurveyStrings = {
    pagePrevText: "Tilbaka",
    pageNextText: "Áfram",
    completeText: "Lokið",
    previewText: "Forskoða",
    editText: "Breyta",
    startSurveyText: "Byrjaðu",
    otherItemText: "Hinn (skýring)",
    noneItemText: "Enginn",
    selectAllItemText: "Velja allt",
    progressText: "Síða {0} of {1}",
    panelDynamicProgressText: "Taka upp {0} af {1}",
    questionsProgressText: "Svarað {0} / {1} spurningum",
    emptySurvey: "Það er enginn síða eða spurningar í þessari könnun.",
    completingSurvey: "Takk fyrir að fyllja út þessa könnun!",
    completingSurveyBefore: "Skrár okkar sýna að þú hefur þegar lokið þessari könnun.",
    loadingSurvey: "Könnunin er að hlaða...",
    optionsCaption: "Veldu...",
    value: "gildi",
    requiredError: "Vinsamlegast svarið spurningunni.",
    requiredErrorInPanel: "Vinsamlegast svaraðu að minnsta kosti einni spurningu.",
    requiredInAllRowsError: "Vinsamlegast svarið spurningum í öllum röðum.",
    numericError: "Þetta gildi verður að vera tala.",
    textMinLength: "Það ætti að vera minnst {0} tákn.",
    textMaxLength: "Það ætti að vera mest {0} tákn.",
    textMinMaxLength: "Það ætti að vera fleiri en {0} og færri en {1} tákn.",
    minRowCountError: "Vinsamlegast fyllið úr að minnsta kosti {0} raðir.",
    minSelectError: "Vinsamlegast veljið að minnsta kosti {0} möguleika.",
    maxSelectError: "Vinsamlegast veljið ekki fleiri en {0} möguleika.",
    numericMinMax: "'{0}' ætti að vera meira en eða jafnt og {1} minna en eða jafnt og {2}",
    numericMin: "{0}' ætti að vera meira en eða jafnt og {1}",
    numericMax: "'{0}' ætti að vera minna en eða jafnt og {1}",
    invalidEmail: "Vinsamlegast sláið inn gilt netfang.",
    invalidExpression: "Tjáningin: {0} ætti að skila 'satt'.",
    urlRequestError: "Beiðninn skilaði eftirfaranadi villu '{0}'. {1}",
    urlGetChoicesError: "Beiðninng skilaði engum gögnum eða slóðinn var röng",
    exceedMaxSize: "Skráinn skal ekki vera stærri en {0}.",
    otherRequiredError: "Vinamlegast fyllið út hitt gildið.",
    uploadingFile: "Skráinn þín var send. Vinsamlegast bíðið í nokkrar sekúndur og reynið aftur.",
    loadingFile: "Hleður ...",
    chooseFile: "Veldu skrár ...",
    noFileChosen: "Engin skrá valin",
    confirmDelete: "Viltu eyða skránni?",
    keyDuplicationError: "Þetta gildi ætti að vera einstakt.",
    addColumn: "Bæta við dálki",
    addRow: "Bæta við röð",
    removeRow: "Fjarlægja",
    addPanel: "Bæta við nýju",
    removePanel: "Fjarlægðu",
    choices_Item: "hlutur",
    matrix_column: "Dálkur",
    matrix_row: "Röð",
    savingData: "Niðurstöðurnar eru að spara á netþjóninum ... ",
    savingDataError: "Villa kom upp og við gátum ekki vistað niðurstöðurnar.",
    savingDataSuccess: "Árangurinn var vistaður með góðum árangri!",
    saveAgainButton: "Reyndu aftur",
    timerMin: "mín",
    timerSec: "sek",
    timerSpentAll: "Þú hefur eytt {0} á þessari síðu og {1} samtals.",
    timerSpentPage: "Þú hefur eytt {0} á þessari síðu.",
    timerSpentSurvey: "Þú hefur eytt {0} samtals.",
    timerLimitAll: "Þú hefur eytt {0} af {1} á þessari síðu og {2} af {3} samtals.",
    timerLimitPage: "Þú hefur eytt {0} af {1} á þessari síðu.",
    timerLimitSurvey: "Þú hefur eytt {0} af {1} samtals.",
    cleanCaption: "Hreint",
    clearCaption: "Hreinsa",
    chooseFileCaption: "Veldu skrá",
    removeFileCaption: "Fjarlægðu þessa skrá",
    booleanCheckedLabel: "Já",
    booleanUncheckedLabel: "Nei",
    confirmRemoveFile: "Ertu viss um að þú viljir fjarlægja þessa skrá: {0}?",
    confirmRemoveAllFiles: "Ertu viss um að þú viljir fjarlægja allar skrár?",
    questionTitlePatternText: "Spurningartitill",
};
_surveyStrings__WEBPACK_IMPORTED_MODULE_0__["surveyLocalization"].locales["is"] = icelandicSurveyStrings;
_surveyStrings__WEBPACK_IMPORTED_MODULE_0__["surveyLocalization"].localeNames["is"] = "íslenska";


/***/ }),

/***/ "./src/localization/indonesian.ts":
/*!****************************************!*\
  !*** ./src/localization/indonesian.ts ***!
  \****************************************/
/*! exports provided: indonesianStrings */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "indonesianStrings", function() { return indonesianStrings; });
/* harmony import */ var _surveyStrings__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ../surveyStrings */ "./src/surveyStrings.ts");

var indonesianStrings = {
    pagePrevText: "Sebelumnya",
    pageNextText: "Selanjutnya",
    completeText: "Selesai",
    previewText: "Pratinjau",
    editText: "Sunting",
    startSurveyText: "Mulai",
    otherItemText: "Lainnya (jelaskan)",
    noneItemText: "Tidak Ada",
    selectAllItemText: "Pilih Semua",
    progressText: "Halaman {0} dari {1}",
    panelDynamicProgressText: "Rekam {0} dari {1}",
    questionsProgressText: "Menjawab pertanyaan {0} / {1}",
    emptySurvey: "Tidak ada halaman atau pertanyaan dalam survei.",
    completingSurvey: "Terima kasih telah menyelesaikan survei!",
    completingSurveyBefore: "Catatan kami menunjukkan bahwa Anda telah menyelesaikan survei ini.",
    loadingSurvey: "Memuat survei...",
    optionsCaption: "Pilih...",
    value: "nilai",
    requiredError: "Silahkan jawab pertanyaan berikut.",
    requiredErrorInPanel: "Silahkan jawab setidaknya satu petanyaan.",
    requiredInAllRowsError: "Silahkan jawab pertanyaan pada semua baris.",
    numericError: "Nilai harus berupa angka.",
    textMinLength: "Silahkan masukkan setidaknya {0} karakter.",
    textMaxLength: "Silahkan masukkan kurang {0} karakter.",
    textMinMaxLength: "PSilahkan masukkan lebih dari {0} dan kurang dari {1} karakter.",
    minRowCountError: "Silahkan isi setidaknya {0} baris.",
    minSelectError: "Silahkan pilih setidaknya {0} varian.",
    maxSelectError: "Silahkan pilih tidak lebih dari {0} varian.",
    numericMinMax: "'{0}' harus sama dengan atau lebih dari {1} dan harus sama dengan atau kurang dari {2}",
    numericMin: "'{0}' harus sama dengan atau lebih dari {1}",
    numericMax: "'{0}' harus sama dengan atau kurang dari {1}",
    invalidEmail: "Silahkan masukkan e-mail yang benar.",
    invalidExpression: "Ekspresi: {0} harus mengembalikan 'benar'.",
    urlRequestError: "Permintaan mengembalikan kesalahan '{0}'. {1}",
    urlGetChoicesError: "Permintaan mengembalikan data kosong atau properti 'path' salah.",
    exceedMaxSize: "Ukuran berkas tidak boleh melebihi {0}.",
    otherRequiredError: "Silahkan masukkan nilai lainnnya.",
    uploadingFile: "Berkas Anda sedang diunggah. Silahkan tunggu beberapa saat atau coba lagi.",
    loadingFile: "Memuat...",
    chooseFile: "Pilih berkas...",
    noFileChosen: "Tidak ada file yang dipilih",
    confirmDelete: "Apakah Anda ingin menghapus catatan?",
    keyDuplicationError: "Nilai harus unik.",
    addColumn: "Tambah kolom",
    addRow: "Tambah baris",
    removeRow: "Hapus",
    addPanel: "Tambah baru",
    removePanel: "Hapus",
    choices_Item: "item",
    matrix_column: "Kolom",
    matrix_row: "Baris",
    savingData: "Hasil sedang disimpan pada server...",
    savingDataError: "Kesalahan terjadi dan kami tidak dapat menyimpan hasil.",
    savingDataSuccess: "Hasil telah sukses disimpan!",
    saveAgainButton: "Coba lagi",
    timerMin: "menit",
    timerSec: "detik",
    timerSpentAll: "Anda telah menghabiskan {0} pada halaman ini dan {1} secara keseluruhan.",
    timerSpentPage: "YAnda telah menghabiskan {0} pada halaman ini.",
    timerSpentSurvey: "Anda telah menghabiskan {0} secara keseluruhan.",
    timerLimitAll: "Anda telah menghabiskan {0} dari {1} pada halaman ini dan {2} dari {3} secara keseluruhan.",
    timerLimitPage: "Anda telah menghabiskan {0} dari {1} pada halaman ini.",
    timerLimitSurvey: "Anda telah menghabiskan {0} dari {1} secara keseluruhan.",
    cleanCaption: "Bersihkan",
    clearCaption: "Bersihkan",
    chooseFileCaption: "Pilih File",
    removeFileCaption: "Hapus berkas ini",
    booleanCheckedLabel: "Iya",
    booleanUncheckedLabel: "Tidak",
    confirmRemoveFile: "Anda yakin ingin menghapus file ini: {0}?",
    confirmRemoveAllFiles: "Anda yakin ingin menghapus semua file?",
    questionTitlePatternText: "Judul pertanyaan",
};
_surveyStrings__WEBPACK_IMPORTED_MODULE_0__["surveyLocalization"].locales["id"] = indonesianStrings;
_surveyStrings__WEBPACK_IMPORTED_MODULE_0__["surveyLocalization"].localeNames["id"] = "bahasa Indonesia";


/***/ }),

/***/ "./src/localization/italian.ts":
/*!*************************************!*\
  !*** ./src/localization/italian.ts ***!
  \*************************************/
/*! exports provided: italianSurveyStrings */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "italianSurveyStrings", function() { return italianSurveyStrings; });
/* harmony import */ var _surveyStrings__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ../surveyStrings */ "./src/surveyStrings.ts");

var italianSurveyStrings = {
    pagePrevText: "Precedente",
    pageNextText: "Successivo",
    completeText: "Salva",
    previewText: "Anteprima",
    editText: "Modifica",
    startSurveyText: "Inizio",
    otherItemText: "Altro (descrivi)",
    noneItemText: "Nessuno",
    selectAllItemText: "Seleziona tutti",
    progressText: "Pagina {0} di {1}",
    panelDynamicProgressText: "Record di {0} di {1}",
    questionsProgressText: "Risposte a {0}/{1} domande",
    emptySurvey: "Non ci sono pagine o domande visibili nel questionario.",
    completingSurvey: "Grazie per aver completato il questionario!",
    completingSurveyBefore: "I nostri records mostrano che hai già completato questo questionario.",
    loadingSurvey: "Caricamento del questionario in corso...",
    optionsCaption: "Scegli...",
    value: "valore",
    requiredError: "Campo obbligatorio",
    requiredErrorInPanel: "Per Favore, rispondi ad almeno una domanda.",
    requiredInAllRowsError: "Completare tutte le righe",
    numericError: "Il valore deve essere numerico",
    textMinLength: "Inserire almeno {0} caratteri",
    textMaxLength: "Lunghezza massima consentita {0} caratteri",
    textMinMaxLength: "Inserire una stringa con minimo {0} e massimo {1} caratteri",
    minRowCountError: "Completare almeno {0} righe.",
    minSelectError: "Selezionare almeno {0} varianti.",
    maxSelectError: "Selezionare massimo {0} varianti.",
    numericMinMax: "'{0}' deve essere uguale o superiore a {1} e uguale o inferiore a {2}",
    numericMin: "'{0}' deve essere uguale o superiore a {1}",
    numericMax: "'{0}' deve essere uguale o inferiore a {1}",
    invalidEmail: "Inserire indirizzo mail valido",
    invalidExpression: "L'espressione: {0} dovrebbe tornare 'vero'.",
    urlRequestError: "La richiesta ha risposto con un errore '{0}'. {1}",
    urlGetChoicesError: "La richiesta ha risposto null oppure il percorso non è corretto",
    exceedMaxSize: "Il file non può eccedere {0}",
    otherRequiredError: "Inserire il valore 'altro'",
    uploadingFile: "File in caricamento. Attendi alcuni secondi e riprova",
    loadingFile: "Caricamento...",
    chooseFile: "Selezionare file(s)...",
    noFileChosen: "Nessun file selezionato",
    confirmDelete: "Sei sicuro di voler elminare il record?",
    keyDuplicationError: "Questo valore deve essere univoco.",
    addColumn: "Aggiungi colonna",
    addRow: "Aggiungi riga",
    removeRow: "Rimuovi riga",
    addPanel: "Aggiungi riga",
    removePanel: "Elimina",
    choices_Item: "Elemento",
    matrix_column: "Colonna",
    matrix_row: "Riga",
    savingData: "Salvataggio dati sul server...",
    savingDataError: "Si è verificato un errore e non è stato possibile salvare i risultati.",
    savingDataSuccess: "I risultati sono stati salvati con successo!",
    saveAgainButton: "Riprova",
    timerMin: "min",
    timerSec: "sec",
    timerSpentAll: "Hai impiegato {0} su questa pagina e {1} in totale.",
    timerSpentPage: "Hai impiegato {0} su questa pagina.",
    timerSpentSurvey: "Hai impiegato {0} in totale.",
    timerLimitAll: "Hai impiegato {0} di {1} su questa pagina e {2} di {3} in totale.",
    timerLimitPage: "Hai impiegato {0} di {1} su questa pagina.",
    timerLimitSurvey: "Hai impiegato {0} di {1} in totale.",
    cleanCaption: "Pulisci",
    clearCaption: "Cancella",
    chooseFileCaption: "Scegliere il file",
    removeFileCaption: "Rimuovere questo file",
    booleanCheckedLabel: "Sì",
    booleanUncheckedLabel: "No",
    confirmRemoveFile: "Sei sicuro di voler elminare questo file: {0}?",
    confirmRemoveAllFiles: "Sei sicuro di voler elminare tutti i files?",
    questionTitlePatternText: "Titolo della domanda",
};
_surveyStrings__WEBPACK_IMPORTED_MODULE_0__["surveyLocalization"].locales["it"] = italianSurveyStrings;
_surveyStrings__WEBPACK_IMPORTED_MODULE_0__["surveyLocalization"].localeNames["it"] = "italiano";


/***/ }),

/***/ "./src/localization/japanese.ts":
/*!**************************************!*\
  !*** ./src/localization/japanese.ts ***!
  \**************************************/
/*! exports provided: japaneseSurveyStrings */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "japaneseSurveyStrings", function() { return japaneseSurveyStrings; });
/* harmony import */ var _surveyStrings__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ../surveyStrings */ "./src/surveyStrings.ts");

var japaneseSurveyStrings = {
    pagePrevText: "前へ",
    pageNextText: "次へ",
    completeText: "完了",
    previewText: "プレビュー",
    editText: "編集",
    startSurveyText: "スタート",
    otherItemText: "その他（説明）",
    noneItemText: "なし",
    selectAllItemText: "すべて選択",
    progressText: "{0}/{1}頁",
    panelDynamicProgressText: "{1}の{0}を記録する",
    questionsProgressText: "{0}/{1}の質問に回答しました。",
    emptySurvey: "この調査に表示できるページや質問はありません",
    completingSurvey: "調査を完了してくれてありがとうございました",
    completingSurveyBefore: "当社の記録によると、この調査はすでに完了しています。",
    loadingSurvey: "調査をダウンロード中",
    optionsCaption: "選択",
    value: "値打ち",
    requiredError: "質問にお答え下さい",
    requiredErrorInPanel: "最低でも1つの質問に答えてください。",
    requiredInAllRowsError: "質問には全列で回答してください。",
    numericError: "数字でご記入下さい",
    textMinLength: "{0} 文字以上で入力して下さい",
    textMaxLength: "{0}文字以下で入力してください。",
    textMinMaxLength: "{0}以上{1}未満の文字を入力してください。",
    minRowCountError: "{0}行以上で入力して下さい",
    minSelectError: "{0}種類以上を選択して下さい",
    maxSelectError: "{0}以上のバリアントを選択しないでください。",
    numericMinMax: "{0}は{1}以上であり、{2}以下であることが望ましい。",
    numericMin: "'{0}' は同等か{1}より大きくなければなりません",
    numericMax: "'{0}' は同等か{1}より小さくなければなりません",
    invalidEmail: "有効なメールアドレスをご記入下さい",
    invalidExpression: "式は {0}は'true'を返すべきです。",
    urlRequestError: "リクエストはエラー '{0}' を返しました。{1}",
    urlGetChoicesError: "リクエストが空のデータを返したか、'path' プロパティが正しくありません。",
    exceedMaxSize: "ファイルのサイズは{0}を超えてはいけません",
    otherRequiredError: "その他の値を入力してください。",
    uploadingFile: "ファイルをアップロード中です。しばらくしてから再度お試し下さい",
    loadingFile: "読み込み中",
    chooseFile: "ファイルを選択",
    noFileChosen: "選択されたファイルはありません",
    confirmDelete: "レコードを削除しますか？",
    keyDuplicationError: "この値は一意でなければなりません。",
    addColumn: "列の追加",
    addRow: "追加行",
    removeRow: "除去",
    addPanel: "新規追加",
    removePanel: "除去",
    choices_Item: "品目",
    matrix_column: "コラム",
    matrix_row: "行",
    savingData: "結果はサーバーに保存されています...。",
    savingDataError: "エラーが発生し、結果を保存できませんでした。",
    savingDataSuccess: "結果は無事に保存されました",
    saveAgainButton: "もう一度試してみてください。",
    timerMin: "僅少",
    timerSec: "セック",
    timerSpentAll: "あなたはこのページに{0}を費やし、合計で{1}を費やしました。",
    timerSpentPage: "あなたはこのページに{0}を費やしました。",
    timerSpentSurvey: "合計で{0}を使ったことになります。",
    timerLimitAll: "このページに{1}のうち{0}を費やし、{3}のうち{2}を合計で費やしました。",
    timerLimitPage: "このページで{1}の{0}を使ったことがあります。",
    timerLimitSurvey: "合計で{1}の{0}を使ったことがあります。",
    cleanCaption: "削除",
    clearCaption: "空白",
    chooseFileCaption: "ファイルを選択",
    removeFileCaption: "このファイルを削除",
    booleanCheckedLabel: "噫",
    booleanUncheckedLabel: "否",
    confirmRemoveFile: "このファイルを削除してもよろしいですか？{0}?",
    confirmRemoveAllFiles: "すべてのファイルを削除してもよろしいですか？",
    questionTitlePatternText: "質問名",
};
_surveyStrings__WEBPACK_IMPORTED_MODULE_0__["surveyLocalization"].locales["ja"] = japaneseSurveyStrings;
_surveyStrings__WEBPACK_IMPORTED_MODULE_0__["surveyLocalization"].localeNames["ja"] = "日本語";


/***/ }),

/***/ "./src/localization/kazakh.ts":
/*!************************************!*\
  !*** ./src/localization/kazakh.ts ***!
  \************************************/
/*! exports provided: kazakhStrings */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "kazakhStrings", function() { return kazakhStrings; });
/* harmony import */ var _surveyStrings__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ../surveyStrings */ "./src/surveyStrings.ts");

var kazakhStrings = {
    pagePrevText: "Артқа",
    pageNextText: "Келесі",
    completeText: "Дайын",
    previewText: "Алдын ала қарау",
    editText: "Редакциялау",
    startSurveyText: "Бастау",
    otherItemText: "Басқа (өтінеміз, жазыңыз)",
    noneItemText: "Жоқ",
    selectAllItemText: "Барлығын таңдау",
    progressText: "{0} ден {1} бет ",
    panelDynamicProgressText: "{0} ден {1} жазба",
    questionsProgressText: "{0}/{1} сұрақтарға жауап",
    emptySurvey: "Бір де бір сұрақ жоқ.",
    completingSurvey: "Сауалнаманы толтырғаныңыз үшін рахмет!",
    completingSurveyBefore: "Сіз бұл сауалнаманы өтіп қойдыңыз.",
    loadingSurvey: "Серверден жүктеу...",
    optionsCaption: "Таңдау...",
    value: "мәні",
    requiredError: "Өтінеміз, сұраққа жауап беріңіз.",
    requiredErrorInPanel: "Өтінеміз, кем дегенде бір сұраққа жауап беріңіз.",
    requiredInAllRowsError: "Өтінеміз, әрбір жолдың сұрағаны жауап беріңіз.",
    numericError: "Жауап сан түрінде болуы керек.",
    textMinLength: "Өтінеміз, {0} ден көп таңба енгізіңіз.",
    textMaxLength: "Өтінеміз, {0} ден аз таңба енгізіңіз.",
    textMinMaxLength: "Өтінеміз, {0} аз және {1} көп таңба енгізіңіз.",
    minRowCountError: "Өтінеміз, {0} ден кем емес жол толтырыңыз.",
    minSelectError: "Өтінеміз, тым болмаса {0} нұсқа таңдаңыз.",
    maxSelectError: "Өтінеміз, {0} нұсқадан көп таңдамаңыз.",
    numericMinMax: "'{0}' {1} ден кем емес және {2} ден көп емес болу керек",
    numericMin: "'{0}' {1} ден кем емес болу керек",
    numericMax: "'{0}' {1} ден көп емес болу керек",
    invalidEmail: "Өтінеміз, жарамды электрондық поштаңызды енгізіңіз.",
    invalidExpression: "{0} өрнегі  'true' қайтару керек.",
    urlRequestError: "Сұратым қателікті қайтарды'{0}'. {1}",
    urlGetChoicesError: "Сұратымға жауап бос келді немесе 'path' қасиеті қате көрсетілген ",
    exceedMaxSize: "Файлдың мөлшері {0} аспау керек.",
    otherRequiredError: "Өтінеміз, “Басқа” жолына деректі енгізіңіз",
    uploadingFile: "Сіздің файлыңыз жүктеліп жатыр. Бірнеше секунд тосып, қайтадан байқап көріңіз.",
    loadingFile: "Жүктеу...",
    chooseFile: "Файлдарды таңдаңыз...",
    noFileChosen: "Файл таңдалынбады",
    confirmDelete: "Сіз жазбаны жоятыныңызға сенімдісіз бе?",
    keyDuplicationError: "Бұл мән бірегей болу керек.",
    addColumn: "Бағана қосу",
    addRow: "Жолды қосу",
    removeRow: "Өшіру",
    addPanel: "Жаңа қосу",
    removePanel: "Өшіру",
    choices_Item: "Нұсқа",
    matrix_column: "Бағана",
    matrix_row: "Жол",
    savingData: "Нәтижелер серверде сақталады...",
    savingDataError: "Қателік туындады, нәтиже сақталынбады.",
    savingDataSuccess: "Нәтиже ойдағыдай сақталды!",
    saveAgainButton: "Қайтадан байқап көру",
    timerMin: "мин",
    timerSec: "сек",
    timerSpentAll: "Сіз бұл бетте {0} кетірдіңіз және барлығы {1}.",
    timerSpentPage: "Сіз бұл бетте {0} кетірдіңіз.",
    timerSpentSurvey: "Сіз сауалнама кезінде {0} кетірдіңіз.",
    timerLimitAll: "Сіз бұл бетте {0} ден {1} кетірдіңіз және {2} ден {3} бүкіл сауалнама үшін.",
    timerLimitPage: "Сіз бұл бетте {0} ден {1} кетірдіңіз.",
    timerLimitSurvey: "Сіз бүкіл сауалнама үшін {0} ден {1} кетірдіңіз ",
    cleanCaption: "Тазалау",
    clearCaption: "Тазалау",
    chooseFileCaption: "Файл таңдаңыз",
    removeFileCaption: "Файлды жойыңыз",
    booleanCheckedLabel: "Иә",
    booleanUncheckedLabel: "Жоқ",
    confirmRemoveFile: "Сіз бұл файлды жоятыныңызға сенімдісіз бе: {0}?",
    confirmRemoveAllFiles: "Сіз барлық файлдарды жоятыныңызға сенімдісіз бе?",
    questionTitlePatternText: "Сұрақтың атауы",
};
_surveyStrings__WEBPACK_IMPORTED_MODULE_0__["surveyLocalization"].locales["kk"] = kazakhStrings;
_surveyStrings__WEBPACK_IMPORTED_MODULE_0__["surveyLocalization"].localeNames["kk"] = "Kazakh";


/***/ }),

/***/ "./src/localization/korean.ts":
/*!************************************!*\
  !*** ./src/localization/korean.ts ***!
  \************************************/
/*! exports provided: koreanStrings */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "koreanStrings", function() { return koreanStrings; });
/* harmony import */ var _surveyStrings__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ../surveyStrings */ "./src/surveyStrings.ts");

var koreanStrings = {
    pagePrevText: "이전",
    pageNextText: "다음",
    completeText: "완료",
    previewText: "시사",
    editText: "편집하다",
    startSurveyText: "시작",
    otherItemText: "기타(설명)",
    noneItemText: "없음",
    selectAllItemText: "모두 선택",
    progressText: "페이지 {1} 중 {0}",
    panelDynamicProgressText: "{0} / {1} 기록",
    questionsProgressText: "{0} / {1} 개의 질문에 답변 함",
    emptySurvey: "설문지에 보여지는 페이지나 질문이 없습니다",
    completingSurvey: "설문 조사를 완료해 주셔서 감사합니다!",
    completingSurveyBefore: "기록에 따르면 이미 설문 조사를 마치셨습니다.",
    loadingSurvey: "설문조사가 로드중입니다...",
    optionsCaption: "선택하십시오...",
    value: "값",
    requiredError: "질문에 답하시오.",
    requiredErrorInPanel: "하나 이상의 질문에 답하십시오.",
    requiredInAllRowsError: "모든 행에 있는 질문에 답하십시오.",
    numericError: "값은 숫자여야 합니다.",
    textMinLength: "답변의 길이는 최소 {0}자여야 입니다.",
    textMaxLength: "답변의 길이는 {0}자를 초과 할 수 없습니다.",
    textMinMaxLength: "답변의 길이는 {0} - {1}자 사이여야 합니다.",
    minRowCountError: "최소 {0}개의 행을 채우십시오",
    minSelectError: "최소 {0}개의 변수를 선택하십시오.",
    maxSelectError: "최대 {0}개의 변수를 선택하십시오.",
    numericMinMax: "'{0}'은 {1}보다 크거나 같고 {2}보다 작거나 같아야합니다.",
    numericMin: "'{0}'은 {1}보다 크거나 같아야합니다.",
    numericMax: "'{0}'은 {1}보다 작거나 같아야합니다.",
    invalidEmail: "올바른 이메일 주소를 입력하십시오.",
    invalidExpression: "표현식: {0}은 '참'이어야 합니다.",
    urlRequestError: "'{0}'으로 잘못된 요청입니다. {1}",
    urlGetChoicesError: "비어있는 데이터를 요청했거나 잘못된 속성의 경로입니다.",
    exceedMaxSize: "파일 크기가 {0}을 초과 할 수 없습니다.",
    otherRequiredError: "다른 질문을 작성하십시오.",
    uploadingFile: "파일 업로드 중입니다. 잠시 후 다시 시도하십시오.",
    loadingFile: "로드 중...",
    chooseFile: "파일 선택...",
    noFileChosen: "선택된 파일이 없습니다",
    confirmDelete: "기록을 삭제하시겠습니까?",
    keyDuplicationError: " 이 값은 고유해야합니다.",
    addColumn: "열 추가",
    addRow: "행 추가",
    removeRow: "제거",
    addPanel: "새롭게 추가",
    removePanel: "제거",
    choices_Item: "항목",
    matrix_column: "열",
    matrix_row: "행",
    savingData: "결과가 서버에 저장 중입니다...",
    savingDataError: "오류가 발생하여 결과를 저장할 수 없습니다.",
    savingDataSuccess: "결과가 성공적으로 저장되었습니다!",
    saveAgainButton: "다시 시도하십시오",
    timerMin: "분",
    timerSec: "초",
    timerSpentAll: "현재 페이지에서 {0}을 소요해 총 {1}이 걸렸습니다.",
    timerSpentPage: "현재 페이지에서 {0]이 걸렸습니다",
    timerSpentSurvey: "총 {0}이 걸렸습니다.",
    timerLimitAll: "현재 페이지에서 {0}/{1}을 소요해 총 {2}/{3}이 걸렸습니다.",
    timerLimitPage: "현재 페이지에서 {0}/{1}이 걸렸습니다.",
    timerLimitSurvey: "총 {0}/{1}이 걸렸습니다.",
    cleanCaption: "닦기",
    clearCaption: "지우기",
    chooseFileCaption: "파일을 선택",
    removeFileCaption: "이 파일 제거",
    booleanCheckedLabel: "예",
    booleanUncheckedLabel: "아니",
    confirmRemoveFile: "{0} 파일을 제거 하시겠습니까?",
    confirmRemoveAllFiles: "모든 파일을 제거 하시겠습니까?",
    questionTitlePatternText: "질문 제목",
};
_surveyStrings__WEBPACK_IMPORTED_MODULE_0__["surveyLocalization"].locales["ko"] = koreanStrings;
_surveyStrings__WEBPACK_IMPORTED_MODULE_0__["surveyLocalization"].localeNames["ko"] = "한국어";


/***/ }),

/***/ "./src/localization/latvian.ts":
/*!*************************************!*\
  !*** ./src/localization/latvian.ts ***!
  \*************************************/
/*! exports provided: latvianSurveyStrings */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "latvianSurveyStrings", function() { return latvianSurveyStrings; });
/* harmony import */ var _surveyStrings__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ../surveyStrings */ "./src/surveyStrings.ts");

var latvianSurveyStrings = {
    pagePrevText: "Atpakaļ",
    pageNextText: "Tālāk",
    completeText: "Pabeigt",
    previewText: "Priekšskatījums",
    editText: "Rediģēt",
    startSurveyText: "Sākt",
    otherItemText: "Cits (lūdzu, aprakstiet!)",
    noneItemText: "Nav",
    selectAllItemText: "Izvēlēties visus",
    progressText: "Lappuse {0} no {1}",
    panelDynamicProgressText: "Ierakstīt {0} no {1}",
    questionsProgressText: "Atbildēja uz jautājumiem {0} / {1}",
    emptySurvey: "Nav neviena jautājuma.",
    completingSurvey: "Pateicamies Jums par anketas aizpildīšanu!",
    completingSurveyBefore: "Mūsu ieraksti liecina, ka jūs jau esat aizpildījis šo aptauju.",
    loadingSurvey: "Ielāde no servera...",
    optionsCaption: "Izvēlēties...",
    value: "value",
    requiredError: "Lūdzu, atbildiet uz jautājumu!",
    requiredErrorInPanel: "Lūdzu, atbildiet uz vismaz vienu jautājumu.",
    requiredInAllRowsError: "Lūdzu, atbildiet uz jautājumiem visās rindās.",
    numericError: "Atbildei ir jābūt skaitlim.",
    textMinLength: "Lūdzu, ievadiet vismaz {0} simbolus.",
    textMaxLength: "Lūdzu, ievadiet mazāk nekā {0} rakstzīmes.",
    textMinMaxLength: "Lūdzu, ievadiet vairāk nekā {0} rakstzīmes un mazāk nekā {1} rakstzīmes.",
    minRowCountError: "Lūdzu, aizpildiet vismaz {0} rindas.",
    minSelectError: "Lūdzu, izvēlieties vismaz {0} variantu.",
    maxSelectError: "Lūdzu, izvēlieties ne vairak par {0} variantiem.",
    numericMinMax: "'{0}' jābūt vienādam vai lielākam nekā {1}, un vienādam vai mazākam, nekā {2}",
    numericMin: "'{0}' jābūt vienādam vai lielākam {1}",
    numericMax: "'{0}' jābūt vienādam vai lielākam {1}",
    invalidEmail: "Lūdzu, ievadiet patiesu e-pasta adresi!",
    invalidExpression: "Izteicienam: {0} jāatgriež “true”.",
    urlRequestError: "Pieprasījumā tika atgriezta kļūda “{0}”. {1}",
    urlGetChoicesError: "Pieprasījums atgrieza tukšus datus vai rekvizīts “path” ir nepareizs",
    exceedMaxSize: "Faila lielums nedrīkst pārsniegt {0}.",
    otherRequiredError: "Lūdzu, ievadiet datus laukā 'Cits'",
    uploadingFile: "Jūsu fails tiek augšupielādēts. Lūdzu, uzgaidiet vairākas sekundes un mēģiniet vēlreiz.",
    loadingFile: "Notiek ielāde ...",
    chooseFile: "Izvēlieties failus ...",
    noFileChosen: "Nav izvēlēts neviens fails",
    confirmDelete: "Vai vēlaties izdzēst ierakstu?",
    keyDuplicationError: "Šai vērtībai jābūt unikālai.",
    addColumn: "Pievienot kolonnu",
    addRow: "Pievienot rindu",
    removeRow: "Noņemt",
    addPanel: "Pievieno jaunu",
    removePanel: "Noņemt",
    choices_Item: "lieta",
    matrix_column: "Sleja",
    matrix_row: "Rinda",
    savingData: "Rezultāti tiek saglabāti serverī ...",
    savingDataError: "Radās kļūda, un mēs nevarējām saglabāt rezultātus.",
    savingDataSuccess: "Rezultāti tika veiksmīgi saglabāti!",
    saveAgainButton: "Mēģini vēlreiz",
    timerMin: "min",
    timerSec: "sek",
    timerSpentAll: "Šajā lapā esat iztērējis {0} un kopā {1}.",
    timerSpentPage: "Šajā lapā esat iztērējis {0}.",
    timerSpentSurvey: "Kopā esat iztērējis {0}.",
    timerLimitAll: "Šajā lapā esat iztērējis {0} no {1} un kopā {2} no {3}.",
    timerLimitPage: "Šajā lapā esat iztērējis {0} no {1}.",
    timerLimitSurvey: "Kopā esat iztērējis {0} no {1}.",
    cleanCaption: "Tīrs",
    clearCaption: "Skaidrs",
    chooseFileCaption: "Izvēlēties failu",
    removeFileCaption: "Noņemiet šo failu",
    booleanCheckedLabel: "Jā",
    booleanUncheckedLabel: "Nē",
    confirmRemoveFile: "Vai tiešām vēlaties noņemt šo failu: {0}?",
    confirmRemoveAllFiles: "Vai tiešām vēlaties noņemt visus failus?",
    questionTitlePatternText: "Jautājuma nosaukums",
};
_surveyStrings__WEBPACK_IMPORTED_MODULE_0__["surveyLocalization"].locales["lv"] = latvianSurveyStrings;
_surveyStrings__WEBPACK_IMPORTED_MODULE_0__["surveyLocalization"].localeNames["lv"] = "latviešu";


/***/ }),

/***/ "./src/localization/lithuanian.ts":
/*!****************************************!*\
  !*** ./src/localization/lithuanian.ts ***!
  \****************************************/
/*! exports provided: lithuaniaSurveyStrings */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "lithuaniaSurveyStrings", function() { return lithuaniaSurveyStrings; });
/* harmony import */ var _surveyStrings__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ../surveyStrings */ "./src/surveyStrings.ts");

var lithuaniaSurveyStrings = {
    pagePrevText: "Atgal",
    pageNextText: "Toliau",
    completeText: "Baigti",
    previewText: "Peržiūra",
    editText: "Redaguoti",
    startSurveyText: "Pradėti",
    otherItemText: "Kita (įvesti)",
    noneItemText: "Nėra",
    selectAllItemText: "Pasirinkti visus",
    progressText: "Puslapis {0} iš {1}",
    panelDynamicProgressText: "Įrašyti {0} iš {1}",
    questionsProgressText: "Atsakė į {0} / {1} klausimus",
    emptySurvey: "Apklausoje nėra matomo puslapio ar klausimo.",
    completingSurvey: "Dėkojame už dalyvavimą apklausoje!",
    completingSurveyBefore: "Mūsų įrašai rodo, kad jau atlikote šią apklausą.",
    loadingSurvey: "Prašome palaukti...",
    optionsCaption: "Pasirinkti...",
    value: "reikšmė",
    requiredError: "Būtina atsakyti į šį klausimą.",
    requiredErrorInPanel: "Būtina atsakyti bent į vieną klausimą.",
    requiredInAllRowsError: "Prašome atsakyti į klausimus visose eilutėse.",
    numericError: "Turi būti skaičiai.",
    textMinLength: "Prašome suvesti bent {0} simbolius.",
    textMaxLength: "Prašome suvesti mažiau nei {0} simbolių.",
    textMinMaxLength: "Prašome suvesti daugiau nei {0} ir mažiau nei {1} simbolių.",
    minRowCountError: "Prašome suvesti ne mažiau nei {0} eilučių.",
    minSelectError: "Prašome pasirinkti bent {0} variantų.",
    maxSelectError: "Pasirinkite ne daugiau kaip {0} variantus.",
    numericMinMax: "'{0}' turi būti lygus arba didesnis nei {1} ir lygus arba mažesnis nei {2}",
    numericMin: "'{0}' turėtų būti lygus arba didesnis nei {1}",
    numericMax: "'{0}' turėtų būti lygus ar mažesnis už {1}",
    invalidEmail: "Prašome įvesti galiojantį elektroninio pašto adresą.",
    invalidExpression: "Reikšmė: {0} turi grąžinti 'true'.",
    urlRequestError: "Užklausa grąžino klaidą'{0}'. {1}",
    urlGetChoicesError: "Užklausa grąžino tuščius duomenis arba 'path' savybė yra neteisinga",
    exceedMaxSize: "Failo dydis neturi viršyti {0}.",
    otherRequiredError: "Įveskite kitą reikšmę.",
    uploadingFile: "Jūsų failas yra keliamas. Palaukite keletą sekundžių ir bandykite dar kartą.",
    loadingFile: "Prašome palaukti...",
    chooseFile: "Pasirinkti failą(us)...",
    noFileChosen: "Nepasirinktas joks failas",
    confirmDelete: "Ar norite ištrinti įrašą?",
    keyDuplicationError: "Ši reikšmė turėtų būti unikali.",
    addColumn: "Pridėti stulpelį",
    addRow: "Pridėti eilutę",
    removeRow: "Ištrinti",
    addPanel: "Pridėti naują",
    removePanel: "Ištrinti",
    choices_Item: "elementas",
    matrix_column: "Stulpelis",
    matrix_row: "Eilutė",
    savingData: "Rezultatai saugomi serveryje...",
    savingDataError: "Įvyko klaida ir mes negalėjome išsaugoti rezultatų.",
    savingDataSuccess: "Rezultatai buvo išsaugoti sėkmingai!",
    saveAgainButton: "Bandyti dar kartą",
    timerMin: "min",
    timerSec: "sek",
    timerSpentAll: "Praleidote {0} šiame puslapyje ir {1} iš viso.",
    timerSpentPage: "Praleidote {0} šiame puslapyje.",
    timerSpentSurvey: "Praleidote {0} iš viso.",
    timerLimitAll: "Praleidote {0} iš {1} šiame puslapyje ir {2} iš {3} iš viso.",
    timerLimitPage: "Praleidote {0} iš {1} šiame puslapyje.",
    timerLimitSurvey: "Praleidote {0} iš {1} iš viso.",
    cleanCaption: "Išvalyti",
    clearCaption: "Valyti",
    chooseFileCaption: "Pasirinkti failą",
    removeFileCaption: "Ištrinti šį failą",
    booleanCheckedLabel: "Taip",
    booleanUncheckedLabel: "Ne",
    confirmRemoveFile: "Ar tikrai norite pašalinti šį failą: {0}?",
    confirmRemoveAllFiles: "Ar tikrai norite pašalinti visus failus?",
    questionTitlePatternText: "Klausimo pavadinimas",
};
_surveyStrings__WEBPACK_IMPORTED_MODULE_0__["surveyLocalization"].locales["lt"] = lithuaniaSurveyStrings;
_surveyStrings__WEBPACK_IMPORTED_MODULE_0__["surveyLocalization"].localeNames["lt"] = "lietuvių";


/***/ }),

/***/ "./src/localization/macedonian.ts":
/*!****************************************!*\
  !*** ./src/localization/macedonian.ts ***!
  \****************************************/
/*! exports provided: macedonianSurveyStrings */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "macedonianSurveyStrings", function() { return macedonianSurveyStrings; });
/* harmony import */ var _surveyStrings__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ../surveyStrings */ "./src/surveyStrings.ts");

var macedonianSurveyStrings = {
    pagePrevText: "Претходна",
    pageNextText: "Следно",
    completeText: "Заврши",
    previewText: "Преглед",
    editText: "Уредување",
    startSurveyText: "Започнете",
    otherItemText: "Друго (опиши)",
    noneItemText: "Ништо",
    selectAllItemText: "Селектирај се",
    progressText: "Страница {0} од {1}",
    panelDynamicProgressText: "Сними {0} од {1}",
    questionsProgressText: "Одговорени на {0} / {1} прашања",
    emptySurvey: "Нема видлива страница или прашање во истражувањето.",
    completingSurvey: "Ви благодариме што го завршивте истражувањето!",
    completingSurveyBefore: "Нашите записи покажуваат дека веќе сте го завршиле ова истражување.",
    loadingSurvey: "Анкетата се вчитува ...",
    optionsCaption: "Изберете ...",
    value: "вредност",
    requiredError: "Ве молам, одговорете на прашањето.",
    requiredErrorInPanel: "Ве молам, одговорете барем на едно прашање.",
    requiredInAllRowsError: "Ве молиме, одговорете на прашања во сите редови.",
    numericError: "Вредноста треба да биде нумеричка.",
    minError: "Вредноста не треба да биде помала од {0}",
    maxError: "Вредноста не треба да биде поголема од {0}",
    textMinLength: "Внесете најмалку {0} знак/ци.",
    textMaxLength: "Внесете не повеќе од {0} знак/ци.",
    textMinMaxLength: "Внесете најмалку {0} и не повеќе од {1} знаци.",
    minRowCountError: "Пополнете најмалку {0} ред(ови).",
    minSelectError: "Ве молиме изберете најмалку {0} варијанта(и).",
    maxSelectError: "Изберете не повеќе од {0} варијанта(и).",
    numericMinMax: "'{0}' треба да биде најмалку {1} и најмногу {2}",
    numericMin: "'{0}' треба да биде најмалку {1}",
    numericMax: "'{0}' треба да биде најмногу {1}",
    invalidEmail: "Ве молиме внесете валидна е-маил адреса.",
    invalidExpression: "Изразот: {0} треба да се врати 'true'.",
    urlRequestError: "Барањето врати грешка '{0}'. {1} ",
    urlGetChoicesError: "Барањето врати празни податоци или својството 'path' е неточно",
    exceedMaxSize: "Големината на датотеката не треба да надминува {0}.",
    otherRequiredError: "Внесете ја другата вредност.",
    uploadingFile: "Вашата датотека се поставува. Ве молиме почекајте неколку секунди и обидете се повторно.",
    loadingFile: "Се вчитува ...",
    chooseFile: "Изберете датотека (и) ...",
    noFileChosen: "Не се избрани датотеки",
    confirmDelete: "Дали сакате да го избришете записот?",
    keyDuplicationError: "Оваа вредност треба да биде единствена.",
    addColumn: "Додај колона",
    addRow: "Додади ред",
    removeRow: "Отстрани",
    emptyRowsText: "Нема редови.",
    addPanel: "Додади ново",
    removePanel: "Отстрани",
    choices_Item: "ставка",
    matrix_column: "Колона",
    matrix_row: "Ред",
    savingData: "Резултатите се зачувуваат на серверот ...",
    savingDataError: "Настана грешка и не можевме да ги зачуваме резултатите.",
    savingDataSuccess: "Резултатите беа успешно зачувани!",
    saveAgainButton: "Обиди се повторно",
    timerMin: "мин",
    timerSec: "сек",
    timerSpentAll: "Поминавте {0} на оваа страница и вкупно {1}.",
    timerSpentPage: "Поминавте {0} на оваа страница.",
    timerSpentSurvey: "Вие потрошивте вкупно {0}.",
    timerLimitAll: "Поминавте {0} од {1} на оваа страница и {2} од {3} вкупно.",
    timerLimitPage: "Поминавте {0} од {1} на оваа страница.",
    timerLimitSurvey: "Вие потрошивте вкупно {0} од {1}.",
    cleanCaption: "Чисти",
    clearCaption: "Да расчисти",
    chooseFileCaption: "Изберете датотека",
    removeFileCaption: "Отстранете ја оваа датотека",
    booleanCheckedLabel: "Да",
    booleanUncheckedLabel: "Не",
    confirmRemoveFile: "Дали сте сигурни дека сакате да ја отстраните оваа датотека: {0}?",
    confirmRemoveAllFiles: "Дали сте сигурни дека сакате да ги отстраните сите датотеки?",
    questionTitlePatternText: "Наслов на прашањето",
    modalCancelButtonText: "Откажи",
    modalApplyButtonText: "Аплицирај",
};
_surveyStrings__WEBPACK_IMPORTED_MODULE_0__["surveyLocalization"].locales["mk"] = macedonianSurveyStrings;
_surveyStrings__WEBPACK_IMPORTED_MODULE_0__["surveyLocalization"].localeNames["mk"] = "Македонски";


/***/ }),

/***/ "./src/localization/norwegian.ts":
/*!***************************************!*\
  !*** ./src/localization/norwegian.ts ***!
  \***************************************/
/*! exports provided: norwegianSurveyStrings */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "norwegianSurveyStrings", function() { return norwegianSurveyStrings; });
/* harmony import */ var _surveyStrings__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ../surveyStrings */ "./src/surveyStrings.ts");

var norwegianSurveyStrings = {
    pagePrevText: "Forrige",
    pageNextText: "Neste",
    completeText: "Fullfør",
    previewText: "Forhåndsvisning",
    editText: "Redigere",
    startSurveyText: "Start",
    otherItemText: "Annet (beskriv)",
    noneItemText: "Ingen",
    selectAllItemText: "Velg alle",
    progressText: "Side {0} av {1}",
    panelDynamicProgressText: "Ta opp {0} av {1}",
    questionsProgressText: "Besvarte {0} / {1} spørsmål",
    emptySurvey: "Det er ingen synlig side eller spørsmål i undersøkelsen.",
    completingSurvey: "Takk for at du fullførte undersøkelsen!",
    completingSurveyBefore: "Våre data viser at du allerede har gjennomført denne undersøkelsen.",
    loadingSurvey: "Undersøkelsen laster...",
    optionsCaption: "Velg...",
    value: "verdi",
    requiredError: "Vennligst svar på spørsmålet.",
    requiredErrorInPanel: "Vennligst svar på minst ett spørsmål.",
    requiredInAllRowsError: "Vennligst svar på spørsmål i alle rader.",
    numericError: "Verdien skal være numerisk.",
    textMinLength: "Vennligst skriv inn minst {0} tegn.",
    textMaxLength: "Vennligst skriv inn mindre enn {0} tegn.",
    textMinMaxLength: "Vennligst skriv inn mer enn {0} og mindre enn {1} tegn.",
    minRowCountError: "Vennligst fyll inn minst {0} rader.",
    minSelectError: "Vennligst velg minst {0} varianter.",
    maxSelectError: "Vennligst ikke velg mer enn {0} varianter.",
    numericMinMax: "'{0}' bør være lik eller mer enn {1} og lik eller mindre enn {2}",
    numericMin: "'{0}' bør være lik eller mer enn {1}",
    numericMax: "'{0}' bør være lik eller mindre enn {1}",
    invalidEmail: "Vennligst skriv inn en gyldig e-post adresse.",
    invalidExpression: "Uttrykket: {0} skal returnere 'sant'.",
    urlRequestError: "Forespørselen returnerte feilen '{0}'. {1}",
    urlGetChoicesError: "Forespørselen returnerte tomme data, eller 'sti' -egenskapen er feil",
    exceedMaxSize: "Filstørrelsen bør ikke overstige {0}.",
    otherRequiredError: "Vennligst skriv inn den andre verdien.",
    uploadingFile: "Filen din lastes opp. Vennligst vent noen sekunder og prøv igjen.",
    loadingFile: "Laster inn ...",
    chooseFile: "Velg fil (er) ...",
    noFileChosen: "Ingen fil valgt",
    confirmDelete: "Ønsker du å slette posten?",
    keyDuplicationError: "Denne verdien skal være unik.",
    addColumn: "Legg til kolonne",
    addRow: "Legg til rad",
    removeRow: "Fjern",
    addPanel: "Legg til ny",
    removePanel: "Fjerne",
    choices_Item: "element",
    matrix_column: "Kolonne",
    matrix_row: "Rad",
    savingData: "Resultatene lagres på serveren ...",
    savingDataError: "Det oppsto en feil, og vi kunne ikke lagre resultatene.",
    savingDataSuccess: "Resultatene ble lagret!",
    saveAgainButton: "Prøv igjen",
    timerMin: "min",
    timerSec: "sek",
    timerSpentAll: "Du har tilbrakt {0} på denne siden og {1} totalt.",
    timerSpentPage: "Du har tilbrakt {0} på denne siden.",
    timerSpentSurvey: "Du har tilbrakt {0} totalt.",
    timerLimitAll: "Du har tilbrakt {0} av {1} på denne siden og totalt {2} av {3}.",
    timerLimitPage: "Du har tilbrakt {0} av {1} på denne siden.",
    timerLimitSurvey: "Du har tilbrakt {0} av {1} totalt.",
    cleanCaption: "Rens",
    clearCaption: "Klar",
    chooseFileCaption: "Velg Fil",
    removeFileCaption: "Fjern denne filen",
    booleanCheckedLabel: "Ja",
    booleanUncheckedLabel: "Nei",
    confirmRemoveFile: "Er du sikker på at du vil fjerne denne filen: {0}?",
    confirmRemoveAllFiles: "Er du sikker på at du vil fjerne alle filene?",
    questionTitlePatternText: "Spørsmålstittel",
};
_surveyStrings__WEBPACK_IMPORTED_MODULE_0__["surveyLocalization"].locales["no"] = norwegianSurveyStrings;
_surveyStrings__WEBPACK_IMPORTED_MODULE_0__["surveyLocalization"].localeNames["no"] = "norsk";


/***/ }),

/***/ "./src/localization/persian.ts":
/*!*************************************!*\
  !*** ./src/localization/persian.ts ***!
  \*************************************/
/*! exports provided: persianSurveyStrings */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "persianSurveyStrings", function() { return persianSurveyStrings; });
/* harmony import */ var _surveyStrings__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ../surveyStrings */ "./src/surveyStrings.ts");

var persianSurveyStrings = {
    pagePrevText: "قبلی",
    pageNextText: "بعدی",
    completeText: "تکمیل",
    previewText: "پیش نمایش",
    editText: "ویرایش",
    startSurveyText: "شروع",
    otherItemText: "دیگر(توضیح)",
    noneItemText: "هیچ",
    selectAllItemText: "انتخاب همه",
    progressText: "صفحه {0} از {1}",
    panelDynamicProgressText: "مورد {0} از {1}",
    questionsProgressText: "تعداد پاسخ {0}/{1} سوال",
    emptySurvey: "صفحه ای یا گزینه ای برای این پرسشنامه موجود نیست.",
    completingSurvey: "از شما بابت تکمیل این پرسشنامه متشکریم",
    completingSurveyBefore: "به نظر می رسد هم هم اکنون پرسشنامه را تکمیل کرده اید.",
    loadingSurvey: "درحال ایجاد پرسشنامه",
    optionsCaption: "انتخاب کنید...",
    value: "مقدار",
    requiredError: "لطفا به سوال پاسخ دهید",
    requiredErrorInPanel: "لطفا حداقل به یک سوال پاسخ دهید.",
    requiredInAllRowsError: "لطفا سوالات تمام سطرها را پاسخ دهید.",
    numericError: "مقدار باید عددی باشد",
    textMinLength: "لطفا حداقل  {0} حرف وارد کنید",
    textMaxLength: "لطفا کمتر از  {0} حرف وارد کنید.",
    textMinMaxLength: "لطفا بیشتر از  {0} حرف و کمتر از {1} حرف وارد کنید.",
    minRowCountError: "لطفا حداقل {0} سطر وارد کنید.",
    minSelectError: "حداقل {0} انتخاب کنید.",
    maxSelectError: "لطفا بیشتر از  {0} انتخاب کنید.",
    numericMinMax: "'{0}' باید بین {1} و {2} باشد",
    numericMin: "'{0}' بزرگتر مساوی {1} باشد",
    numericMax: "'{0}' باید کوچکتر یا مساوی {1} باشد",
    invalidEmail: "لطفا ایمیل صحیح درج کنید",
    invalidExpression: "عبارت: {0} پاسخ باید 'true' باشد.",
    urlRequestError: "درخواست با خطا روبرو شد: '{0}'. {1}",
    urlGetChoicesError: "درخواست مسیری خالی بازگشت داده یا مسیر درست تنظیم نشده",
    exceedMaxSize: "بیشترین حجم مجاز فایل: {0}",
    otherRequiredError: "مقدار 'دیگر' را وارد کنید",
    uploadingFile: "فایل در حال آیلود است. لطفا صبر کنید.",
    loadingFile: "بارگیری...",
    chooseFile: "انتخاب فایل(ها)...",
    noFileChosen: "هیچ فایلی انتخاب نشده",
    confirmDelete: "آیا مایل به حذف این ردیف هستید؟",
    keyDuplicationError: "این مقدار باید غیر تکراری باشد",
    addColumn: "ستون جدید",
    addRow: "سطر جدید",
    removeRow: "حذف",
    addPanel: "جدید",
    removePanel: "حذف",
    choices_Item: "آیتم",
    matrix_column: "ستون",
    matrix_row: "سطر",
    savingData: "نتایج در حال ذخیره سازی در سرور است",
    savingDataError: "خطایی در ذخیره سازی نتایج رخ داده است",
    savingDataSuccess: "نتایج با موفقیت ذخیره شد",
    saveAgainButton: "مجدد تلاش کنید",
    timerMin: "دقیقه",
    timerSec: "ثانیه",
    timerSpentAll: "شما مدت {0} در این صفحه و مدت {1} را در مجموع سپری کرده اید.",
    timerSpentPage: "شما مدت {0} را در این صفحه سپری کرده اید.",
    timerSpentSurvey: "شما مدت {0} را در مجموع سپری کرده اید.",
    timerLimitAll: "شما مدت {0} از {1} در این صفحه و مدت {2} از {3} را در مجموع سپری کرده اید.",
    timerLimitPage: "شما مدت {0} از {1} را در این صفحه سپری کرده اید.",
    timerLimitSurvey: "شما مدت {0} از {1} را در مجموع سپری کرده اید.",
    cleanCaption: "پاکسازی",
    clearCaption: "خالی کردن",
    chooseFileCaption: "انتخاب فایل",
    removeFileCaption: "حذف این فایل",
    booleanCheckedLabel: "بله",
    booleanUncheckedLabel: "خیر",
    confirmRemoveFile: "آیا میخواهید این فایل را پاک کنید: {0}?",
    confirmRemoveAllFiles: "آیا میخواهید تمام فایل ها را پاک کنید?",
    questionTitlePatternText: "عنوان سوال",
};
_surveyStrings__WEBPACK_IMPORTED_MODULE_0__["surveyLocalization"].locales["fa"] = persianSurveyStrings;
_surveyStrings__WEBPACK_IMPORTED_MODULE_0__["surveyLocalization"].localeNames["fa"] = "فارْسِى";


/***/ }),

/***/ "./src/localization/polish.ts":
/*!************************************!*\
  !*** ./src/localization/polish.ts ***!
  \************************************/
/*! exports provided: polishSurveyStrings */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "polishSurveyStrings", function() { return polishSurveyStrings; });
/* harmony import */ var _surveyStrings__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ../surveyStrings */ "./src/surveyStrings.ts");

var polishSurveyStrings = {
    pagePrevText: "Wstecz",
    pageNextText: "Dalej",
    completeText: "Gotowe",
    previewText: "Premiera",
    editText: "Edycja",
    startSurveyText: "Start",
    otherItemText: "Inna odpowiedź (wpisz)",
    noneItemText: "Brak",
    selectAllItemText: "Wybierz wszystkie",
    progressText: "Strona {0} z {1}",
    panelDynamicProgressText: "Zapis {0} z {1}",
    questionsProgressText: "Odpowiedzi na {0}/{1} pytania",
    emptySurvey: "Nie ma widocznych pytań.",
    completingSurvey: "Dziękujemy za wypełnienie ankiety!",
    completingSurveyBefore: "Z naszych zapisów wynika, że wypełniłeś już tę ankietę.",
    loadingSurvey: "Trwa wczytywanie ankiety...",
    optionsCaption: "Wybierz...",
    value: "Wartość",
    requiredError: "Proszę odpowiedzieć na to pytanie.",
    requiredErrorInPanel: "Proszę odpowiedzieć na co najmniej jedno pytanie.",
    requiredInAllRowsError: "Proszę odpowiedzieć na wszystkie pytania.",
    numericError: "W tym polu można wpisać tylko liczby.",
    textMinLength: "Proszę wpisać co najmniej {0} znaków.",
    textMaxLength: "Proszę wpisać mniej niż {0} znaków.",
    textMinMaxLength: "Proszę wpisać więcej niż {0} i mniej niż {1} znaków.",
    minRowCountError: "Proszę uzupełnić przynajmniej {0} wierszy.",
    minSelectError: "Proszę wybrać co najmniej {0} pozycji.",
    maxSelectError: "Proszę wybrać nie więcej niż {0} pozycji.",
    numericMinMax: "Odpowiedź '{0}' powinna być większa lub równa {1} oraz mniejsza lub równa {2}",
    numericMin: "Odpowiedź '{0}' powinna być większa lub równa {1}",
    numericMax: "Odpowiedź '{0}' powinna być mniejsza lub równa {1}",
    invalidEmail: "Proszę podać prawidłowy adres email.",
    invalidExpression: "Wyrażenie: {0} powinno wracać 'prawdziwe'.",
    urlRequestError: "Żądanie zwróciło błąd '{0}'. {1}",
    urlGetChoicesError: "Żądanie nie zwróciło danych albo ścieżka jest nieprawidłowa",
    exceedMaxSize: "Rozmiar przesłanego pliku nie może przekraczać {0}.",
    otherRequiredError: "Proszę podać inną odpowiedź.",
    uploadingFile: "Trwa przenoszenie Twojego pliku, proszę spróbować ponownie za kilka sekund.",
    loadingFile: "Ładowanie...",
    chooseFile: "Wybierz plik(i)...",
    noFileChosen: "Nie wybrano żadnego pliku",
    confirmDelete: "Chcesz skasować nagranie?",
    keyDuplicationError: "Ta wartość powinna być wyjątkowa.",
    addColumn: "Dodaj kolumnę",
    addRow: "Dodaj wiersz",
    removeRow: "Usuń",
    addPanel: "Dodaj panel",
    removePanel: "Usuń",
    choices_Item: "element",
    matrix_column: "Kolumna",
    matrix_row: "Wiersz",
    savingData: "Zapisuję wyniki ankiety na serwerze...",
    savingDataError: "Wystąpił błąd i wyniki nie mogły zostać zapisane.",
    savingDataSuccess: "Wyniki zostały poprawnie zapisane!",
    saveAgainButton: "Spróbuj ponownie",
    timerMin: "min",
    timerSec: "sek",
    timerSpentAll: "Spędziłeś {0} na tej stronie a w sumie {1}.",
    timerSpentPage: "Spędziłeś {0} na tej stronie.",
    timerSpentSurvey: "Spędziłeś w sumie {0}.",
    timerLimitAll: "Spędziłeś {0} z {1} na tej stronie a w sumie {2} z {3}.",
    timerLimitPage: "Spędziłeś {0} z {1} na tej stronie",
    timerLimitSurvey: "Spędziłeś {0} z {1}.",
    cleanCaption: "Wyczyść",
    clearCaption: "Jasne",
    chooseFileCaption: "Wybierz plik",
    removeFileCaption: "Usuń ten plik",
    booleanCheckedLabel: "Tak",
    booleanUncheckedLabel: "Nie",
    confirmRemoveFile: "Jesteś pewien, że chcesz usunąć ten plik: {0}?",
    confirmRemoveAllFiles: "Jesteś pewien, że chcesz usunąć wszystkie pliki?",
    questionTitlePatternText: "Tytuł pytania",
};
_surveyStrings__WEBPACK_IMPORTED_MODULE_0__["surveyLocalization"].locales["pl"] = polishSurveyStrings;
_surveyStrings__WEBPACK_IMPORTED_MODULE_0__["surveyLocalization"].localeNames["pl"] = "polski";


/***/ }),

/***/ "./src/localization/portuguese-br.ts":
/*!*******************************************!*\
  !*** ./src/localization/portuguese-br.ts ***!
  \*******************************************/
/*! exports provided: portugueseBrSurveyStrings */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "portugueseBrSurveyStrings", function() { return portugueseBrSurveyStrings; });
/* harmony import */ var _surveyStrings__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ../surveyStrings */ "./src/surveyStrings.ts");

var portugueseBrSurveyStrings = {
    pagePrevText: "Anterior",
    pageNextText: "Próximo",
    completeText: "Finalizar",
    previewText: "Pré-visualização",
    editText: "Editar",
    startSurveyText: "Começar",
    otherItemText: "Outros (descrever)",
    noneItemText: "Nenhum",
    selectAllItemText: "Selecionar Todos",
    progressText: "Página {0} de {1}",
    panelDynamicProgressText: "Registro {0} de {1}",
    questionsProgressText: "Respostas {0}/{1} perguntas",
    emptySurvey: "Não há página visível ou pergunta na pesquisa.",
    completingSurvey: "Obrigado por finalizar a pesquisa!",
    completingSurveyBefore: "Nossos registros mostram que você já finalizou a pesquisa.",
    loadingSurvey: "A pesquisa está carregando...",
    optionsCaption: "Selecione...",
    value: "valor",
    requiredError: "Por favor, responda a pergunta.",
    requiredErrorInPanel: "Por favor, responda pelo menos uma pergunta.",
    requiredInAllRowsError: "Por favor, responda as perguntas em todas as linhas.",
    numericError: "O valor deve ser numérico.",
    textMinLength: "Por favor, insira pelo menos {0} caracteres.",
    textMaxLength: "Por favor, insira menos de {0} caracteres.",
    textMinMaxLength: "Por favor, insira mais de {0} e menos de {1} caracteres.",
    minRowCountError: "Preencha pelo menos {0} linhas.",
    minSelectError: "Selecione pelo menos {0} opções.",
    maxSelectError: "Por favor, selecione não mais do que {0} opções.",
    numericMinMax: "O '{0}' deve ser igual ou superior a {1} e igual ou menor que {2}",
    numericMin: "O '{0}' deve ser igual ou superior a {1}",
    numericMax: "O '{0}' deve ser igual ou inferior a {1}",
    invalidEmail: "Por favor, informe um e-mail válido.",
    invalidExpression: "A expressão: {0} deve retornar 'verdadeiro'.",
    urlRequestError: "A requisição retornou o erro '{0}'. {1}",
    urlGetChoicesError: "A requisição não retornou dados ou o 'caminho' da requisição não está correto",
    exceedMaxSize: "O tamanho do arquivo não deve exceder {0}.",
    otherRequiredError: "Por favor, informe o outro valor.",
    uploadingFile: "Seu arquivo está sendo carregado. Por favor, aguarde alguns segundos e tente novamente.",
    loadingFile: "Carregando...",
    chooseFile: "Selecione o(s) arquivo(s)...",
    noFileChosen: "Nenhum arquivo escolhido",
    confirmDelete: "Tem certeza que deseja deletar?",
    keyDuplicationError: "Esse valor deve ser único.",
    addColumn: "Adicionar coluna",
    addRow: "Adicionar linha",
    removeRow: "Remover linha",
    addPanel: "Adicionar novo",
    removePanel: "Remover",
    choices_Item: "item",
    matrix_column: "Coluna",
    matrix_row: "Linha",
    savingData: "Os resultados esto sendo salvos no servidor...",
    savingDataError: "Ocorreu um erro e não foi possível salvar os resultados.",
    savingDataSuccess: "Os resultados foram salvos com sucesso!",
    saveAgainButton: "Tente novamente",
    timerMin: "min",
    timerSec: "seg",
    timerSpentAll: "Você gastou {0} nesta página e {1} no total.",
    timerSpentPage: "Você gastou {0} nesta página.",
    timerSpentSurvey: "Você gastou {0} no total.",
    timerLimitAll: "Você gastou {0} de {1} nesta página e {2} de {3} no total.",
    timerLimitPage: "Você gastou {0} de {1} nesta página.",
    timerLimitSurvey: "Você gastou {0} de {1} no total.",
    cleanCaption: "Limpar",
    clearCaption: "Limpar",
    chooseFileCaption: "Escolher arquivo",
    removeFileCaption: "Remover este arquivo",
    booleanCheckedLabel: "Sim",
    booleanUncheckedLabel: "Não",
    confirmRemoveFile: "Tem certeza que deseja remover este arquivo: {0}?",
    confirmRemoveAllFiles: "Tem certeza que deseja remover todos os arquivos?",
    questionTitlePatternText: "Título da questão",
};
_surveyStrings__WEBPACK_IMPORTED_MODULE_0__["surveyLocalization"].locales["pt-br"] = portugueseBrSurveyStrings;
_surveyStrings__WEBPACK_IMPORTED_MODULE_0__["surveyLocalization"].localeNames["pt-br"] = "português brasileiro";


/***/ }),

/***/ "./src/localization/portuguese.ts":
/*!****************************************!*\
  !*** ./src/localization/portuguese.ts ***!
  \****************************************/
/*! exports provided: portugueseSurveyStrings */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "portugueseSurveyStrings", function() { return portugueseSurveyStrings; });
/* harmony import */ var _surveyStrings__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ../surveyStrings */ "./src/surveyStrings.ts");

var portugueseSurveyStrings = {
    pagePrevText: "Anterior",
    pageNextText: "Próximo",
    completeText: "Finalizar",
    previewText: "Pré-visualização",
    editText: "Editar",
    startSurveyText: "Começar",
    otherItemText: "Outros (descrever)",
    noneItemText: "Nenhum",
    selectAllItemText: "Selecionar Todos",
    progressText: "Página {0} de {1}",
    panelDynamicProgressText: "Registo {0} de {1}",
    questionsProgressText: "Respostas {0}/{1} perguntas",
    emptySurvey: "Não há página visível ou pergunta no questionário.",
    completingSurvey: "Obrigado por finalizar o questionário!",
    completingSurveyBefore: "Os nossos registos mostram que já finalizou o questionário.",
    loadingSurvey: "O questionário está a carregar...",
    optionsCaption: "Selecione...",
    value: "valor",
    requiredError: "Por favor, responda à pergunta.",
    requiredErrorInPanel: "Por favor, responda pelo menos a uma pergunta.",
    requiredInAllRowsError: "Por favor, responda às perguntas em todas as linhas.",
    numericError: "O valor deve ser numérico.",
    textMinLength: "Por favor, insira pelo menos {0} caracteres.",
    textMaxLength: "Por favor, insira menos de {0} caracteres.",
    textMinMaxLength: "Por favor, insira mais de {0} e menos de {1} caracteres.",
    minRowCountError: "Preencha pelo menos {0} linhas.",
    minSelectError: "Selecione pelo menos {0} opções.",
    maxSelectError: "Por favor, selecione no máximo {0} opções.",
    numericMinMax: "O '{0}' deve ser igual ou superior a {1} e igual ou menor que {2}",
    numericMin: "O '{0}' deve ser igual ou superior a {1}",
    numericMax: "O '{0}' deve ser igual ou inferior a {1}",
    invalidEmail: "Por favor, insira um e-mail válido.",
    invalidExpression: "A expressão: {0} deve retornar 'verdadeiro'.",
    urlRequestError: "O pedido retornou o erro '{0}'. {1}",
    urlGetChoicesError: "O pedido não retornou dados ou o 'caminho' do pedido não está correto",
    exceedMaxSize: "O tamanho do arquivo não deve exceder {0}.",
    otherRequiredError: "Por favor, insira o outro valor.",
    uploadingFile: "O seu ficheiro está a carregar. Por favor, aguarde alguns segundos e tente novamente.",
    loadingFile: "A carregar...",
    chooseFile: "Selecione o(s) arquivo(s)...",
    noFileChosen: "Nenhum ficheiro escolhido",
    confirmDelete: "Tem a certeza que deseja apagar?",
    keyDuplicationError: "Este valor deve ser único.",
    addColumn: "Adicionar coluna",
    addRow: "Adicionar linha",
    removeRow: "Remover linha",
    addPanel: "Adicionar novo",
    removePanel: "Remover",
    choices_Item: "item",
    matrix_column: "Coluna",
    matrix_row: "Linha",
    savingData: "Os resultados estão a ser guardados no servidor...",
    savingDataError: "Ocorreu um erro e não foi possível guardar os resultados.",
    savingDataSuccess: "Os resultados foram guardados com sucesso!",
    saveAgainButton: "Tente novamente",
    timerMin: "min",
    timerSec: "seg",
    timerSpentAll: "Você gastou {0} nesta página e {1} no total.",
    timerSpentPage: "Você gastou {0} nesta página.",
    timerSpentSurvey: "Você gastou {0} no total.",
    timerLimitAll: "Você gastou {0} de {1} nesta página e {2} de {3} no total.",
    timerLimitPage: "Você gastou {0} de {1} nesta página.",
    timerLimitSurvey: "Você gastou {0} de {1} no total.",
    cleanCaption: "Limpar",
    clearCaption: "Limpar",
    chooseFileCaption: "Escolher ficheiro",
    removeFileCaption: "Remover este ficheiro",
    booleanCheckedLabel: "Sim",
    booleanUncheckedLabel: "Não",
    confirmRemoveFile: "Tem a certeza que deseja remover este ficheiro: {0}?",
    confirmRemoveAllFiles: "Tem a certeza que deseja remover todos os ficheiros?",
    questionTitlePatternText: "Título da questão",
};
_surveyStrings__WEBPACK_IMPORTED_MODULE_0__["surveyLocalization"].locales["pt"] = portugueseSurveyStrings;
_surveyStrings__WEBPACK_IMPORTED_MODULE_0__["surveyLocalization"].localeNames["pt"] = "português";


/***/ }),

/***/ "./src/localization/romanian.ts":
/*!**************************************!*\
  !*** ./src/localization/romanian.ts ***!
  \**************************************/
/*! exports provided: romanianSurveyStrings */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "romanianSurveyStrings", function() { return romanianSurveyStrings; });
/* harmony import */ var _surveyStrings__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ../surveyStrings */ "./src/surveyStrings.ts");

var romanianSurveyStrings = {
    pagePrevText: "Precedent",
    pageNextText: "Următor",
    completeText: "Finalizare",
    previewText: "previzualizare",
    editText: "Editați",
    startSurveyText: "start",
    otherItemText: "Altul(precizaţi)",
    noneItemText: "Nici unul",
    selectAllItemText: "Selectează tot",
    progressText: "Pagina {0} din {1}",
    panelDynamicProgressText: "Înregistrare {0} din {1}",
    questionsProgressText: "Răspunsuri la {0} / {1} întrebări",
    emptySurvey: "Nu sunt întrebări pentru acest chestionar",
    completingSurvey: "Vă mulţumim pentru timpul acordat!",
    completingSurveyBefore: "Din înregistrările noastre reiese că ați completat deja acest chestionar.",
    loadingSurvey: "Chestionarul se încarcă...",
    optionsCaption: "Alegeţi...",
    value: "valoare",
    requiredError: "Răspunsul la această întrebare este obligatoriu.",
    requiredErrorInPanel: "Vă rugăm să răspundeți la cel puțin o întrebare.",
    requiredInAllRowsError: "Toate răspunsurile sunt obligatorii",
    numericError: "Răspunsul trebuie să fie numeric.",
    textMinLength: "Trebuie să introduceți minim {0} caractere.",
    textMaxLength: "Trebuie să introduceți maxim {0} caractere.",
    textMinMaxLength: "Trebuie să introduceți mai mult de {0} și mai puțin de {1} caractere.",
    minRowCountError: "Trebuie să completați minim {0} rânduri.",
    minSelectError: "Trebuie să selectați minim {0} opţiuni.",
    maxSelectError: "Trebuie să selectați maxim {0} opţiuni.",
    numericMinMax: "Răspunsul '{0}' trebuie să fie mai mare sau egal ca {1} şî mai mic sau egal cu {2}",
    numericMin: "Răspunsul '{0}' trebuie să fie mai mare sau egal ca {1}",
    numericMax: "Răspunsul '{0}' trebuie să fie mai mic sau egal ca {1}",
    invalidEmail: "Trebuie să introduceţi o adresa de email validă.",
    invalidExpression: "Expresia: {0} ar trebui să returneze „adevărat”.",
    urlRequestError: "Request-ul a returnat eroarea '{0}'. {1}",
    urlGetChoicesError: "Request-ul nu a returnat date sau proprietatea 'path' este incorectă",
    exceedMaxSize: "Dimensiunea fişierului nu trebuie să depăşească {0}.",
    otherRequiredError: "Trebuie să completați câmpul 'Altul'.",
    uploadingFile: "Fișierul dumneavoastră este în curs de încărcare. Vă rugăm așteptați câteva secunde și reveniți apoi.",
    loadingFile: "Se încarcă...",
    chooseFile: "Alege fisierele...",
    noFileChosen: "Niciun fișier ales",
    confirmDelete: "Sunteți sigur că doriți să ștergeți înregistrarea?",
    keyDuplicationError: "Valoarea trebuie să fie unică.",
    addColumn: "Adăugați coloană",
    addRow: "Adăugare rând",
    removeRow: "Ștergere",
    addPanel: "Adăugare",
    removePanel: "Ștergere",
    choices_Item: "opțiune",
    matrix_column: "Coloană",
    matrix_row: "Rând",
    savingData: "Rezultatele sunt în curs de salvare...",
    savingDataError: "A intervenit o eroare, rezultatele nu au putut fi salvate.",
    savingDataSuccess: "Rezultatele au fost salvate cu succes!",
    saveAgainButton: "Încercați din nou",
    timerMin: "min",
    timerSec: "sec",
    timerSpentAll: "Ați petrecut {0} pe această pagină și {1} în total.",
    timerSpentPage: "Ați petrecut {0} pe această pagină.",
    timerSpentSurvey: "Ați petrecut {0} în total.",
    timerLimitAll: "Ați petrecut {0} din {1} pe această pagină și {2} din {3} în total.",
    timerLimitPage: "Ați petrecut {0} din {1} pe această pagină.",
    timerLimitSurvey: "Ați petrecut {0} din {1} în total.",
    cleanCaption: "Curat",
    clearCaption: "clar",
    chooseFileCaption: "Alege fișierul",
    removeFileCaption: "Eliminați acest fișier",
    booleanCheckedLabel: "da",
    booleanUncheckedLabel: "Nu",
    confirmRemoveFile: "Sigur doriți să eliminați acest fișier: {0}?",
    confirmRemoveAllFiles: "Sigur doriți să eliminați toate fișierele?",
    questionTitlePatternText: "Titlul intrebarii",
};
_surveyStrings__WEBPACK_IMPORTED_MODULE_0__["surveyLocalization"].locales["ro"] = romanianSurveyStrings;
_surveyStrings__WEBPACK_IMPORTED_MODULE_0__["surveyLocalization"].localeNames["ro"] = "română";


/***/ }),

/***/ "./src/localization/russian.ts":
/*!*************************************!*\
  !*** ./src/localization/russian.ts ***!
  \*************************************/
/*! exports provided: russianSurveyStrings */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "russianSurveyStrings", function() { return russianSurveyStrings; });
/* harmony import */ var _surveyStrings__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ../surveyStrings */ "./src/surveyStrings.ts");

var russianSurveyStrings = {
    pagePrevText: "Назад",
    pageNextText: "Далее",
    completeText: "Готово",
    previewText: "Предварительный просмотр",
    editText: "Редактирование",
    startSurveyText: "Начать",
    otherItemText: "Другое (пожалуйста, опишите)",
    noneItemText: "Нет",
    selectAllItemText: "Выбрать всё",
    progressText: "Страница {0} из {1}",
    panelDynamicProgressText: "Запись {0} из {1}",
    questionsProgressText: "Ответы на {0}/{1}вопросы",
    emptySurvey: "Нет ни одного вопроса.",
    completingSurvey: "Благодарим Вас за заполнение анкеты!",
    completingSurveyBefore: "Вы уже проходили этот опрос.",
    loadingSurvey: "Загрузка с сервера...",
    optionsCaption: "Выбрать...",
    value: "значение",
    requiredError: "Пожалуйста, ответьте на вопрос.",
    requiredErrorInPanel: "Пожалуйста, ответьте по крайней мере на один вопрос.",
    requiredInAllRowsError: "Пожалуйста, ответьте на вопросы в каждой строке.",
    numericError: "Ответ должен быть числом.",
    textMinLength: "Пожалуйста введите больше {0} символов.",
    textMaxLength: "Пожалуйста введите меньше {0} символов.",
    textMinMaxLength: "Пожалуйста введите больше {0} и меньше {1} символов.",
    minRowCountError: "Пожалуйста, заполните не меньше {0} строк.",
    minSelectError: "Пожалуйста, выберите хотя бы {0} вариантов.",
    maxSelectError: "Пожалуйста, выберите не более {0} вариантов.",
    numericMinMax: "'{0}' должно быть не меньше чем {1}, и не больше чем {2}",
    numericMin: "'{0}' должно быть не меньше чем {1}",
    numericMax: "'{0}' должно быть не больше чем {1}",
    invalidEmail: "Пожалуйста, введите действительный адрес электронной почты.",
    invalidExpression: "Выражение {0} должно возвращать 'true'.",
    urlRequestError: "Запрос вернул ошибку '{0}'. {1}",
    urlGetChoicesError: "Ответ на запрос пришел пустой или свойство 'path' указано неверно",
    exceedMaxSize: "Размер файла не должен превышать {0}.",
    otherRequiredError: "Пожалуйста, введите данные в поле 'Другое'",
    uploadingFile: "Ваш файл загружается. Подождите несколько секунд и попробуйте снова.",
    loadingFile: "Загрузка...",
    chooseFile: "Выберите файл(ы)...",
    noFileChosen: "Файл не выбран",
    confirmDelete: "Вы точно хотите удалить запись?",
    keyDuplicationError: "Это значение должно быть уникальным.",
    addColumn: "Добавить колонку",
    addRow: "Добавить строку",
    removeRow: "Удалить",
    addPanel: "Добавить новую",
    removePanel: "Удалить",
    choices_Item: "Вариант",
    matrix_column: "Колонка",
    matrix_row: "Строка",
    savingData: "Результаты сохраняются на сервер...",
    savingDataError: "Произошла ошибка, результат не был сохранён.",
    savingDataSuccess: "Результат успешно сохранён!",
    saveAgainButton: "Попробовать снова",
    timerMin: "мин",
    timerSec: "сек",
    timerSpentAll: "Вы потратили {0} на этой странице и {1} всего.",
    timerSpentPage: "Вы потратили {0} на этой странице.",
    timerSpentSurvey: "Вы потратили {0} в течение теста.",
    timerLimitAll: "Вы потратили {0} из {1} на этой странице и {2} из {3} для всего теста.",
    timerLimitPage: "Вы потратили {0} из {1} на этой странице.",
    timerLimitSurvey: "Вы потратили {0} из {1} для всего теста.",
    cleanCaption: "Очистить",
    clearCaption: "Очистить",
    chooseFileCaption: "Выберите файл",
    removeFileCaption: "Удалить файл",
    booleanCheckedLabel: "Да",
    booleanUncheckedLabel: "Нет",
    confirmRemoveFile: "Вы уверены, что хотите удалить этот файл: {0}?",
    confirmRemoveAllFiles: "Вы уверены, что хотите удалить все файлы?",
    questionTitlePatternText: "Название вопроса",
};
_surveyStrings__WEBPACK_IMPORTED_MODULE_0__["surveyLocalization"].locales["ru"] = russianSurveyStrings;
_surveyStrings__WEBPACK_IMPORTED_MODULE_0__["surveyLocalization"].localeNames["ru"] = "русский";


/***/ }),

/***/ "./src/localization/serbian.ts":
/*!*************************************!*\
  !*** ./src/localization/serbian.ts ***!
  \*************************************/
/*! exports provided: serbianStrings */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "serbianStrings", function() { return serbianStrings; });
/* harmony import */ var _surveyStrings__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ../surveyStrings */ "./src/surveyStrings.ts");
//Uncomment this line on creating a translation file

var serbianStrings = {
    pagePrevText: "Nazad",
    pageNextText: "Dalje",
    completeText: "Završi",
    previewText: "Pregledaj",
    editText: "Izmeni",
    startSurveyText: "Započni",
    otherItemText: "Drugo (upiši)",
    noneItemText: "Ništa",
    selectAllItemText: "Izaberi sve",
    progressText: "Stranica {0} od {1}",
    panelDynamicProgressText: "Upis {0} od {1}",
    questionsProgressText: "Odgovoreno na {0}/{1} pitanja",
    emptySurvey: "Nema vidljivih stranica ili pitanja u anketi.",
    completingSurvey: "Hvala na popunjavanju ankete!",
    completingSurveyBefore: "Prema našim podacima, već ste popunili ovu anketu.",
    loadingSurvey: "Učitavam anketu...",
    optionsCaption: "Izaberi...",
    value: "vrednost",
    requiredError: "Molimo odgovorite na ovo pitanje.",
    requiredErrorInPanel: "Molimo odgovorite na bar jedno pitanje.",
    requiredInAllRowsError: "Molimo odgovorite na pitanja u svim redovima.",
    numericError: "Vrednost bi trebalo da bude numerička.",
    minError: "Vrednost ne bi trebalo da bude manja od {0}",
    maxError: "Vrednost ne bi trebalo da bude veća od {0}",
    textMinLength: "Molimo unesite bar {0} znak(ov)a.",
    textMaxLength: "Molimo unesite najviše {0} znak(ov)a.",
    textMinMaxLength: "Molimo unesite najmanje {0} i ne više od {1} znak(ov)a.",
    minRowCountError: "Molimo popunite najmanje {0} red(ova).",
    minSelectError: "Molimo izaberite najmanje {0} opcija/e.",
    maxSelectError: "Molimo izaberite najviše {0} opcija/e.",
    numericMinMax: "'{0}' bi trebalo da bude najmanje {1} i najviše {2}",
    numericMin: "'{0}' bi trebalo da bude najmanje {1}",
    numericMax: "'{0}' bi trebalo da bude najviše {1}",
    invalidEmail: "Molimo unesite ispravnu e-mail adresu.",
    // vratiti "true" ?
    invalidExpression: "Izraz: {0} bi trebalo da bude tačan.",
    urlRequestError: "Zahtev je naišao na grešku '{0}'. {1}",
    urlGetChoicesError: "Zahtev nije pronašao podatke, ili je putanja netačna",
    exceedMaxSize: "Veličina fajla ne bi trebalo da prelazi {0}.",
    otherRequiredError: "Molimo unesite drugu vrednost.",
    uploadingFile: "Fajl se šalje. Molimo sačekajte neko vreme i pokušajte ponovo.",
    loadingFile: "Učitavanje...",
    chooseFile: "Izaberite fajlove...",
    noFileChosen: "Nije izabran nijedan fajl",
    confirmDelete: "Da li želite da izbrišete unos?",
    keyDuplicationError: "Ova vrednost treba da bude jedinstvena.",
    addColumn: "Dodaj kolonu",
    addRow: "Dodaj red",
    removeRow: "Ukloni",
    emptyRowsText: "Nema redova.",
    addPanel: "Dodaj novo",
    removePanel: "Ukloni",
    choices_Item: "stavka",
    matrix_column: "Kolona",
    matrix_row: "Red",
    multipletext_itemname: "tekst",
    savingData: "U toku je čuvanje podataka na serveru...",
    savingDataError: "Došlo je do greške i rezultati nisu sačuvani.",
    savingDataSuccess: "Rezultati su uspešno sačuvani!",
    saveAgainButton: "Pokušajte ponovo",
    timerMin: "min",
    timerSec: "sek",
    timerSpentAll: "Proveli ste {0} na ovoj stranici i {1} ukupno.",
    timerSpentPage: "Proveli ste {0} na ovoj stranici.",
    timerSpentSurvey: "Proveli ste {0} ukupno.",
    timerLimitAll: "Proveli ste {0} od {1} na ovoj stranici i {2} od {3} ukupno.",
    timerLimitPage: "Proveli ste {0} od {1} na ovoj stranici.",
    timerLimitSurvey: "Proveli ste {0} od {1} ukupno.",
    cleanCaption: "Očisti",
    clearCaption: "Poništi",
    chooseFileCaption: "Izaberi fajl",
    removeFileCaption: "Ukloni ovaj fajl",
    booleanCheckedLabel: "Da",
    booleanUncheckedLabel: "Ne",
    confirmRemoveFile: "Da li ste sigurni da želite da uklonite ovaj fajl: {0}?",
    confirmRemoveAllFiles: "Da li ste sigurni da želite da uklonite sve fajlove?",
    questionTitlePatternText: "Naslov pitanja",
    modalCancelButtonText: "Otkaži",
    modalApplyButtonText: "Primeni",
};
//Uncomment these two lines on creating a translation file. You should replace "en" and enStrings with your locale ("fr", "de" and so on) and your variable.
_surveyStrings__WEBPACK_IMPORTED_MODULE_0__["surveyLocalization"].locales["rs"] = serbianStrings;
_surveyStrings__WEBPACK_IMPORTED_MODULE_0__["surveyLocalization"].localeNames["rs"] = "Srpski";


/***/ }),

/***/ "./src/localization/simplified-chinese.ts":
/*!************************************************!*\
  !*** ./src/localization/simplified-chinese.ts ***!
  \************************************************/
/*! exports provided: simplifiedChineseSurveyStrings */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "simplifiedChineseSurveyStrings", function() { return simplifiedChineseSurveyStrings; });
/* harmony import */ var _surveyStrings__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ../surveyStrings */ "./src/surveyStrings.ts");

var simplifiedChineseSurveyStrings = {
    pagePrevText: "上一页",
    pageNextText: "下一页",
    completeText: "提交问卷",
    previewText: "预览",
    editText: "编辑",
    startSurveyText: "开始问卷",
    otherItemText: "填写其他答案",
    noneItemText: "无",
    selectAllItemText: "选择全部",
    progressText: "第 {0} 页, 共 {1} 页",
    panelDynamicProgressText: "{0} of {1}",
    questionsProgressText: "第 {0}/{1} 题",
    emptySurvey: "问卷中没有问题或页面",
    completingSurvey: "感谢您的参与!",
    completingSurveyBefore: "你已完成问卷.",
    loadingSurvey: "问卷正在加载中...",
    optionsCaption: "请选择...",
    value: "值",
    requiredError: "请填写此问题",
    requiredErrorInPanel: "至少回答一题.",
    requiredInAllRowsError: "请填写所有行中问题",
    numericError: "答案必须是个数字",
    minError: "该值不能小于 {0}",
    maxError: "该值不能大于 {0}",
    textMinLength: "答案长度至少 {0} 个字符",
    textMaxLength: "答案长度不能超过 {0} 个字符",
    textMinMaxLength: "答案长度必须在 {0} - {1} 个字符之间",
    minRowCountError: "最少需要填写 {0} 行答案",
    minSelectError: "最少需要选择 {0} 项答案",
    maxSelectError: "最多只能选择 {0} 项答案",
    numericMinMax: "答案 '{0}' 必须大于等于 {1} 且小于等于 {2}",
    numericMin: "答案 '{0}' 必须大于等于 {1}",
    numericMax: "答案 '{0}' 必须小于等于 {1}",
    invalidEmail: "请输入有效的 Email 地址",
    invalidExpression: "公式: {0} 无效.",
    urlRequestError: "载入选项时发生错误 '{0}': {1}",
    urlGetChoicesError: "未能载入有效的选项或请求参数路径有误",
    exceedMaxSize: "文件大小不能超过 {0}",
    otherRequiredError: "请完成其他问题",
    uploadingFile: "文件上传中... 请耐心等待几秒后重试",
    loadingFile: "加载...",
    chooseFile: "选择文件...",
    noFileChosen: "未选择文件",
    confirmDelete: "删除记录?",
    keyDuplicationError: "主键不能重复",
    addColumn: "添加列",
    addRow: "添加行",
    removeRow: "删除答案",
    emptyRowsText: "无内容",
    addPanel: "新添",
    removePanel: "删除",
    choices_Item: "选项",
    matrix_column: "列",
    matrix_row: "行",
    multipletext_itemname: "文本",
    savingData: "正在将结果保存到服务器...",
    savingDataError: "在保存结果过程中发生了错误，结果未能保存",
    savingDataSuccess: "结果保存成功!",
    saveAgainButton: "请重试",
    timerMin: "分",
    timerSec: "秒",
    timerSpentAll: "本页用时 {0} 总计用时{1} .",
    timerSpentPage: "本页用时{0} .",
    timerSpentSurvey: "总计用时 {0} .",
    timerLimitAll: "本页用时 {0} 共 {1}， 总计用时 {2} 共 {3} .",
    timerLimitPage: "本页用时 {0} 共 {1} .",
    timerLimitSurvey: "总计用时 {0} 共 {1}.",
    cleanCaption: "清理",
    clearCaption: "清除",
    chooseFileCaption: "选择文件",
    removeFileCaption: "移除文件",
    booleanCheckedLabel: "是",
    booleanUncheckedLabel: "否",
    confirmRemoveFile: "删除文件: {0}?",
    confirmRemoveAllFiles: "删除所有文件?",
    questionTitlePatternText: "标题",
    modalCancelButtonText: "取消",
    modalApplyButtonText: "确定",
};
_surveyStrings__WEBPACK_IMPORTED_MODULE_0__["surveyLocalization"].locales["zh-cn"] = simplifiedChineseSurveyStrings;
_surveyStrings__WEBPACK_IMPORTED_MODULE_0__["surveyLocalization"].localeNames["zh-cn"] = "简体中文";


/***/ }),

/***/ "./src/localization/spanish.ts":
/*!*************************************!*\
  !*** ./src/localization/spanish.ts ***!
  \*************************************/
/*! exports provided: spanishSurveyStrings */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "spanishSurveyStrings", function() { return spanishSurveyStrings; });
/* harmony import */ var _surveyStrings__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ../surveyStrings */ "./src/surveyStrings.ts");

var spanishSurveyStrings = {
    pagePrevText: "Anterior",
    pageNextText: "Siguiente",
    completeText: "Completar",
    previewText: "Vista previa",
    editText: "Edita",
    startSurveyText: "Comienza",
    otherItemText: "Otro (describa)",
    noneItemText: "Ninguno",
    selectAllItemText: "Seleccionar todo",
    progressText: "Página {0} de {1}",
    panelDynamicProgressText: "Registro {0} de {1}",
    questionsProgressText: "Respondió a {0}/{1} preguntas",
    emptySurvey: "No hay página visible o pregunta en la encuesta.",
    completingSurvey: "Gracias por completar la encuesta!",
    completingSurveyBefore: "Nuestros registros muestran que ya ha completado esta encuesta.",
    loadingSurvey: "La encuesta está cargando...",
    optionsCaption: "Seleccione...",
    value: "valor",
    requiredError: "Por favor conteste la pregunta.",
    requiredErrorInPanel: "Por favor, responda al menos una pregunta.",
    requiredInAllRowsError: "Por favor conteste las preguntas en cada hilera.",
    numericError: "La estimación debe ser numérica.",
    minError: "La estimación no debe ser menor que {0}",
    maxError: "La estimación no debe ser mayor que {0}",
    textMinLength: "Por favor entre por lo menos {0} símbolos.",
    textMaxLength: "Por favor entre menos de {0} símbolos.",
    textMinMaxLength: "Por favor entre más de {0} y menos de {1} símbolos.",
    minRowCountError: "Por favor llene por lo menos {0} hileras.",
    minSelectError: "Por favor seleccione por lo menos {0} variantes.",
    maxSelectError: "Por favor seleccione no más de {0} variantes.",
    numericMinMax: "El '{0}' debe de ser igual o más de {1} y igual o menos de {2}",
    numericMin: "El '{0}' debe ser igual o más de {1}",
    numericMax: "El '{0}' debe ser igual o menos de {1}",
    invalidEmail: "Por favor agregue un correo electrónico válido.",
    invalidExpression: "La expresión: {0} debería devolver 'verdadero'.",
    urlRequestError: "La solicitud regresó error '{0}'. {1}",
    urlGetChoicesError: "La solicitud regresó vacío de data o la propiedad 'trayectoria' no es correcta",
    exceedMaxSize: "El tamaño del archivo no debe de exceder {0}.",
    otherRequiredError: "Por favor agregue la otra estimación.",
    uploadingFile: "Su archivo se está subiendo. Por favor espere unos segundos e intente de nuevo.",
    loadingFile: "Cargando...",
    chooseFile: "Elija archivo(s)...",
    noFileChosen: "No se ha elegido ningún archivo",
    confirmDelete: "¿Quieres borrar el registro?",
    keyDuplicationError: "Este valor debe ser único.",
    addColumn: "Añadir columna",
    addRow: "Agregue una hilera",
    removeRow: "Eliminar una hilera",
    emptyRowsText: "No hay hileras.",
    addPanel: "Añadir nuevo",
    removePanel: "Retire",
    choices_Item: "artículo",
    matrix_column: "Columna",
    matrix_row: "Hilera",
    multipletext_itemname: "texto",
    savingData: "Los resultados se están guardando en el servidor...",
    savingDataError: "Los resultados se están guardando en el servidor...",
    savingDataSuccess: "¡Los resultados se guardaron con éxito!",
    saveAgainButton: "Inténtalo de nuevo.",
    timerMin: "min",
    timerSec: "sec",
    timerSpentAll: "Has gastado {0} en esta página y {1} en total.",
    timerSpentPage: "Usted ha pasado {0} en esta página.",
    timerSpentSurvey: "Has gastado en total.",
    timerLimitAll: "Has gastado {0} de {1} en esta página y {2} de {3} en total.",
    timerLimitPage: "Has gastado {0} de {1} en esta página.",
    timerLimitSurvey: "Usted ha gastado {0} de {1} en total.",
    cleanCaption: "Limpia",
    clearCaption: "Despejen",
    signaturePlaceHolder: "Firma aqui",
    chooseFileCaption: "Elija el archivo",
    removeFileCaption: "Elimina este archivo",
    booleanCheckedLabel: "Sí",
    booleanUncheckedLabel: "No",
    confirmRemoveFile: "¿Estás seguro de que quieres eliminar este archivo: {0}?",
    confirmRemoveAllFiles: "¿Estás seguro de que quieres eliminar todos los archivos?",
    questionTitlePatternText: "Título de la pregunta",
    modalCancelButtonText: "Anular",
    modalApplyButtonText: "Aplicar",
};
_surveyStrings__WEBPACK_IMPORTED_MODULE_0__["surveyLocalization"].locales["es"] = spanishSurveyStrings;
_surveyStrings__WEBPACK_IMPORTED_MODULE_0__["surveyLocalization"].localeNames["es"] = "español";


/***/ }),

/***/ "./src/localization/swahili.ts":
/*!*************************************!*\
  !*** ./src/localization/swahili.ts ***!
  \*************************************/
/*! exports provided: swahiliStrings */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "swahiliStrings", function() { return swahiliStrings; });
/* harmony import */ var _surveyStrings__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ../surveyStrings */ "./src/surveyStrings.ts");

var swahiliStrings = {
    pagePrevText: "Iliyotangulia",
    pageNextText: "Ifuatayo",
    completeText: "Kamili",
    previewText: "Hakiki",
    editText: "Hariri",
    startSurveyText: "Anza",
    otherItemText: "Nyingine (eleza)",
    noneItemText: "Hakuna",
    selectAllItemText: "Chagua Zote",
    progressText: "Ukurasa {0} wa {1}",
    panelDynamicProgressText: "Rekodi {0} ya {1}",
    questionsProgressText: "Yaliyojibiwa {0}/{1} maswali",
    emptySurvey: "Hakuna ukurasa unaoonekana au swali katika utafiti.",
    completingSurvey: "Asanti kwa kukamilisha utafiti!",
    completingSurveyBefore: "Recodi zetu zinatuonyesha tayari umekamilisha utafiti.",
    loadingSurvey: "Tunaandaa utafiti...",
    optionsCaption: "Chagua...",
    value: "thamani",
    requiredError: "Tafadhali jibu hili swali.",
    requiredErrorInPanel: "Tafadhali jibu swali angalau moja.",
    requiredInAllRowsError: "Tafadhali jibu maswali katika safu zote.",
    numericError: "Thamani inapaswa kuwa ya nambari.",
    textMinLength: "Tafadhali ingiza angalau{0} husika.",
    textMaxLength: "Tafadhali ingiza isiozidi {0} husika.",
    textMinMaxLength: "Tafadhali ingiza kiwango zaidi ya {0} na kisichopungua {1} husika.",
    minRowCountError: "Tafadhali jaza isiopungua {0} safu.",
    minSelectError: "Tafadhali chagua angalau {0} lahaja.",
    maxSelectError: "Tafadhali changua isiozidi {0} lahaja.",
    numericMinMax: " '{0}' inapaswa kuwa sawa au zaidi ya {1} na sawa au chini ya {2}",
    numericMin: " '{0}'inapaswa kuwa sawa au zaidi ya {1}",
    numericMax: " '{0}'inapaswa kuwa sawa au chini ya {1}",
    invalidEmail: "Tafadhali ingiza anwani halali ya barua-pepe.",
    invalidExpression: "Usemi:{0} inapaswa kurudi 'kweli'.",
    urlRequestError: "Ombi lina kosa '{0}'. {1}",
    urlGetChoicesError: "Ombi lilirudisha data tupu au the 'path' mali ya njia sio sahihi",
    exceedMaxSize: "Saizi ya faili haipaswi kuzidi {0}.",
    otherRequiredError: "Tafadhali ingiza thamani nyingine.",
    uploadingFile: "Faili yako inapakia.Tafadhali subiri sekunde kadhaa na ujaribu tena.",
    loadingFile: "Inapakia...",
    chooseFile: "Chagua faili...",
    noFileChosen: "Hujachagua faili",
    confirmDelete: "Je! Unataka kufuta rekodi?",
    keyDuplicationError: "Thamani hii inapaswa kuwa ya kipekee.",
    addColumn: "Ongeza Kolamu",
    addRow: "Ongeza safu",
    removeRow: "Toa",
    addPanel: "Ongeza mpya",
    removePanel: "Toa",
    choices_Item: "kitu",
    matrix_column: "Kolamu",
    matrix_row: "Safu",
    savingData: "Matokeo yamehifadhiwa kwa seva...",
    savingDataError: "Kosa limetokea na hatukuweza kuhifadhi matokeo.",
    savingDataSuccess: "Matokeo yamehifadhiwa!",
    saveAgainButton: "Jaribu tena",
    timerMin: "dakika",
    timerSec: "sekunde",
    timerSpentAll: "Umetumia {0} kwenye ukurasa huu na {1} kwa jumla.",
    timerSpentPage: "Umetumia {0} kwenye ukurasa huu.",
    timerSpentSurvey: "Umetumia {0} kwa jumla.",
    timerLimitAll: "Umetumia {0} ya {1} kwenye ukurasa huu {2} wa {3} kwa jumla.",
    timerLimitPage: "Umetumia {0} ya {1} kwenye ukurasa huu.",
    timerLimitSurvey: "Umetumia {0} ya {1} kwa jumla.",
    cleanCaption: "Safisha",
    clearCaption: "Ondoa",
    chooseFileCaption: "Chagua faili",
    removeFileCaption: "Ondoa faili",
    booleanCheckedLabel: "Ndio",
    booleanUncheckedLabel: "Hapana",
    confirmRemoveFile: "Je! Una uhakika kuwa unataka kuondoa faili hii: {0}?",
    confirmRemoveAllFiles: "Je! Una uhakika kuwa unataka kuondoa faili zote?",
    questionTitlePatternText: "Kichwa cha Swali",
};
_surveyStrings__WEBPACK_IMPORTED_MODULE_0__["surveyLocalization"].locales["sw"] = swahiliStrings;
_surveyStrings__WEBPACK_IMPORTED_MODULE_0__["surveyLocalization"].localeNames["sw"] = "swahili";


/***/ }),

/***/ "./src/localization/swedish.ts":
/*!*************************************!*\
  !*** ./src/localization/swedish.ts ***!
  \*************************************/
/*! exports provided: swedishSurveyStrings */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "swedishSurveyStrings", function() { return swedishSurveyStrings; });
/* harmony import */ var _surveyStrings__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ../surveyStrings */ "./src/surveyStrings.ts");
//Create by Mattias Asplund

var swedishSurveyStrings = {
    pagePrevText: "Föregående",
    pageNextText: "Nästa",
    completeText: "Färdig",
    previewText: "Förhandsvisning",
    editText: "Redigera",
    startSurveyText: "Start",
    otherItemText: "Annat (beskriv)",
    noneItemText: "Ingen",
    selectAllItemText: "Välj alla",
    progressText: "Sida {0} av {1}",
    panelDynamicProgressText: "Spela in {0} av {1}",
    questionsProgressText: "Besvarade {0} / {1} frågor",
    emptySurvey: "Det finns ingen synlig sida eller fråga i enkäten.",
    completingSurvey: "Tack för att du genomfört enkäten!!",
    completingSurveyBefore: "Våra register visar att du redan har slutfört denna undersökning.",
    loadingSurvey: "Enkäten laddas...",
    optionsCaption: "Välj...",
    value: "värde",
    requiredError: "Var vänlig besvara frågan.",
    requiredErrorInPanel: "Vänligen svara på minst en fråga.",
    requiredInAllRowsError: "Var vänlig besvara frågorna på alla rader.",
    numericError: "Värdet ska vara numeriskt.",
    textMinLength: "Var vänlig ange minst {0} tecken.",
    textMaxLength: "Ange färre än {0} tecken.",
    textMinMaxLength: "Ange mer än {0} och färre än {1} tecken.",
    minRowCountError: "Var vänlig fyll i minst {0} rader.",
    minSelectError: "Var vänlig välj åtminstone {0} varianter.",
    maxSelectError: "Var vänlig välj inte fler än {0} varianter.",
    numericMinMax: "'{0}' ska vara lika med eller mer än {1} samt lika med eller mindre än {2}",
    numericMin: "'{0}' ska vara lika med eller mer än {1}",
    numericMax: "'{0}' ska vara lika med eller mindre än {1}",
    invalidEmail: "Var vänlig ange en korrekt e-postadress.",
    invalidExpression: "Uttrycket: {0} ska returnera 'true'.",
    urlRequestError: "Förfrågan returnerade felet '{0}'. {1}",
    urlGetChoicesError: "Antingen returnerade förfrågan ingen data eller så är egenskapen 'path' inte korrekt",
    exceedMaxSize: "Filstorleken får ej överstiga {0}.",
    otherRequiredError: "Var vänlig ange det andra värdet.",
    uploadingFile: "Din fil laddas upp. Var vänlig vänta några sekunder och försök sedan igen.",
    loadingFile: "Läser in...",
    chooseFile: "Välj fil (er) ...",
    noFileChosen: "Ingen fil vald",
    confirmDelete: "Vill du radera posten?",
    keyDuplicationError: "Detta värde ska vara unikt.",
    addColumn: "Lägg till kolumn",
    addRow: "Lägg till rad",
    removeRow: "Ta bort",
    addPanel: "Lägg till ny",
    removePanel: "Ta bort",
    choices_Item: "Artikel",
    matrix_column: "Kolumn",
    matrix_row: "Rad",
    savingData: "Resultaten sparas på servern ...",
    savingDataError: "Ett fel inträffade och vi kunde inte spara resultaten.",
    savingDataSuccess: "Resultaten sparades framgångsrikt!",
    saveAgainButton: "Försök igen",
    timerMin: "min",
    timerSec: "sek",
    timerSpentAll: "Du har spenderat {0} på den här sidan och {1} totalt.",
    timerSpentPage: "Du har spenderat {0} på den här sidan.",
    timerSpentSurvey: "Du har spenderat {0} totalt.",
    timerLimitAll: "Du har spenderat {0} av {1} på den här sidan och {2} av {3} totalt.",
    timerLimitPage: "Du har spenderat {0} av {1} på den här sidan.",
    timerLimitSurvey: "Du har spenderat {0} av {1} totalt.",
    cleanCaption: "Rena",
    clearCaption: "Klar",
    chooseFileCaption: "Välj FIL",
    removeFileCaption: "Ta bort den här filen",
    booleanCheckedLabel: "Ja",
    booleanUncheckedLabel: "Nej",
    confirmRemoveFile: "Är du säker på att du vill ta bort den här filen: {0}?",
    confirmRemoveAllFiles: "Är du säker på att du vill ta bort alla filer?",
    questionTitlePatternText: "Frågetitel",
};
_surveyStrings__WEBPACK_IMPORTED_MODULE_0__["surveyLocalization"].locales["sv"] = swedishSurveyStrings;
_surveyStrings__WEBPACK_IMPORTED_MODULE_0__["surveyLocalization"].localeNames["sv"] = "svenska";


/***/ }),

/***/ "./src/localization/tajik.ts":
/*!***********************************!*\
  !*** ./src/localization/tajik.ts ***!
  \***********************************/
/*! exports provided: tajikSurveyStrings */
/***/ (function(module, __webpack_exports__, __webpack_require__) {

"use strict";
__webpack_require__.r(__webpack_exports__);
/* harmony export (binding) */ __webpack_require__.d(__webpack_exports__, "tajikSurveyStrings", function() { return tajikSurveyStrings; });
/* harmony import */ var _surveyStrings__WEBPACK_IMPORTED_MODULE_0__ = __webpack_require__(/*! ../surveyStrings */ "./src/surveyStrings.ts");

var tajikSurveyStrings = {
    pagePrevText: "Бозгашт",
    pageNextText: "Оянда",
    completeText: "Иҷро шуд",
    startSurveyText: "Оғоз",
    otherItemText: "Дигар (лутфан тавсиф кунед)",
    noneItemText: "Не",
    selectAllItemText: "Ҳамаро интихоб кардан",
    progressText: "Саҳифаи {0} аз {1}",
    emptySurvey: "Ягон савол вуҷуд надорад.",
    completingSurvey: "Ташаккур барои пур кардани саволнома!",
    completingSurveyBefore: "Шумо аллакай ин пурсишро анҷом додаед.",
    loadingSurvey: "Боргирӣ аз сервер...",
    optionsCaption: "Интихоб кардан...",
    value: "қиммат",
    requiredError: "Илтимос, ба савол ҷавоб диҳед.",
    requiredErrorInPanel: "Илтимос, ақалан ба як савол ҷавоб диҳед.",
    requiredInAllRowsError: "Илтимос, ба ҳамаи саволҳо дар ҳамаи сатрҳо ҷавоб диҳед.",
    numericError: "Ҷавоб бояд рақам бошад.",
    textMinLength: "Илтимос, аз {0} зиёдтар рамз ворид кунед.",
    textMaxLength: "Илтимос, аз {0} камтар рамз ворид кунед.",
    textMinMaxLength: "Илтимос, аз {0} зиёдтар ва аз {1} камтар рамз ворид кунед.",
    minRowCountError: "Илтимос, на камтар аз {0} сатр пур кунед.",
    minSelectError: "Илтимос, ақалан {0} вариант интихоб кунед.",
    maxSelectError: "Илтимос, на зиёдтар аз {0} вариант интихоб кунед.",
    numericMinMax: "'{0}' бояд на кам аз {1} ва на б