# Version 4.0.0

This version introduces a number of breaking changes, a number being
required to move to a more Promise-based API and one where problems are
detected early at run-time by throwing rather than logging.

Some API changes also involve switching to class methods over instance
methods, though these were private/internally used APIs.

Please see the CHANGES file (or the Git history or Github tracker) for
more fixes and enhancements.

## Breaking changes

- The cookie to track storage preferences is now namespaced as
  "svgeditstore" instead of just "store".
- Require `npx` (used with `babel-node`) to allow Node files for HTML
  building and JSDoc type checking to be expressed as ESM.

### Breaking changes (public API)

#### Callback-to-Promise changes

- `loadSvgString` now returns a `Promise` rather than accepting a callback.
- Callbacks to `editor.ready` are treated as Promises, only resolving after
  all resolve. May require no changes unless for timing.
- `editor.runCallbacks` now returns a `Promise` which resolves upon all
  callbacks resolving.
- Removed `svgCanvas.rasterExport` fourth (callback) argument, collapsing
  fifth (options) to fourth
- Removed `svgCanvas.exportPDF` third (callback) argument
- Removed `svgCanvas.embedImage` second (callback) argument
- Made `getHelpXML` a class instead of instance method of `RGBColor`.

#### Throwing bad arguments instead of mere logging

- `editor/contextmenu.js` `add` now throws instead
  of giving a console error only upon detecting a bad menuitem or
  preexisting context menu
- `addExtension` now throws upon a repeated attempt to add an
  already-added extension

### Breaking changes (internal API)

- Refactor `dbox` (and
  `alert`/`confirm`/`process`/`prompt`/`select`) to avoid a callback argument
  in favor of returning a Promise
- `updateGripCursor` moved to be class method
  of Selector rather than instance method
- `subpathIsClosed` moved to be class method
  of `Path` rather than instance method
