# Version 6.0.0

This release should require minimal updating.

Besides the breaking changes and license updates, contains miscellanous
fixes and enhancements, for example:

1. Switching from `localStorage` to `sessionStorage` for the clipboard (@NeilFraser)
1. PDF export improvements (@cuixiping)

Please see the CHANGES file (or the Git history or Github tracker) for
more fixes and enhancements.

## Breaking changes (and clarifying license info)

- License:
    1. The `license` indicated in `package.json` had not included all
        of the license terms bundled with the package. It now includes them:
        `(MIT AND Apache-2.0 AND CC-BY-SA-2.0 AND ISC AND LGPL-3.0-or-later AND X11)`
        A `licenseInfo.json` file has been added with its `filesByLicense`
        property mapping which files have which licenses. The
        `bundledRootPackages` property in that file indicates which
        `devDependencies` packages are actually copied into this repository
        (so that npm or Git-based hosting services can include them
        for live use of our editors).
    1. License: Relicense `ext-mathjax.js` from `Apache-2.0` to `MIT` per
        permission granted in <https://github.com/josegaert/ext-mathjax/issues/6>
    1. License: Clarify in `@license` jsdoc that `ext-server_moinsave.js` is
          "(MIT OR GPL-2.0-or-later)" per subsequent text
    1. License: Reorder license listing in `jquery.contextMenu.js` so
          that the more permissive license is noticeable first
    1. See the new license badges on the README for a summary of
        the licenses including either bundled devDependencies or all
        `devDependencies` (we have no direct npm `dependencies` currently).
        These badges categorize the licenses into different degrees of
        permissiveness.
1. `$.pref` - Remove in favor of new `svgEditor.pref` (avoids polluting
    `jQuery`). (This might be moved to its own module in future.)
1. `putLocale` (a function called automatically by `svg-editor.js`) no
    longer checks `pref`. Should not impact average consumers.
1. Some unused files were removed, i.e., `jquery-ui-1.8.custom.min.js`,
    some old build/tools closure/yuicompressor code, and the unmaintained
    chrome-app, firefox-extension, and opera-widget. (However, an updated
    WebExtensions replacement (or such) for these would be welcome.)
1. User-facing changes:
    1. Clipboard: Move clipboard from `localStorage` to `sessionStorage`.
        Listing as a breaking change as previously held clipboard data
        will not be restored.
