const getReallyPrefix = (relativePrefix, globalPrefix) => {
  const prefix = new URL("http://sw2express.localhost");
  prefix.pathname = globalPrefix;
  const reallyPrefix = new URL(relativePrefix, prefix.href);
  return reallyPrefix.pathname;
};

export default {
  name: "register",

  func: (that) => (func, globalPrefix = "/") => {
    const app = {
      route: (prefix) => {
        const reallyRoute = that.route(getReallyPrefix(prefix, globalPrefix));
        return reallyRoute;
      },
      use: (Handler) => {
        that._registerMiddlewares.push({
          prefix: globalPrefix,
          Handler: Handler,
        });
      },
    };
    func(app);
    return that;
  },

  bootstrap: (app) => {
    app._register = true;
    app._registerMiddlewares = [];
    app.use(async (req, rep) => {
      app._registerMiddlewares.forEach(async (handler) => {
        if (req.path.indexOf(handler.prefix) === 0) {
          await handler.Handler(req, rep);
        }
      });
    });
  },
};
