import http from "http";
declare namespace sw2express {
  type plugin = {
    /**
     * Plugin Name;
     */
    name: string;
    /**
     * Plugin Function;
     */
    func: Function | Promise<any>;
    /**
     * Plugin Boostrap Function
     */
    bootstrap: (param: sw2express) => Promise<any> | any;
  };
  interface route {
    /**
     * Handle Get Request on this route
     * @param func Handler
```
routeOnRoot.GET(async(req, rep) => "Hello World");
routeOnRoot.GET(async(req, rep) => new Object({Hello:"World"}));
routeOnRoot.GET(async(req, rep) => {rep.end("Hello World");});
```
     */
    GET(func: sw2express.Handler): this;
    /**
     * Handle Post Request on this route
     * @param func Handler
```
routeOnRoot.POST(async(req, rep) => "Hello World");
routeOnRoot.POST(async(req, rep) => new Object({Hello:"World"}));
routeOnRoot.POST(async(req, rep) => {rep.end("Hello World");});
```
     */
    POST(func: sw2express.Handler): this;
    /**
     * Handle ALL Request on this route (Low priority)
     * @param func Handler
```
routeOnRoot.all(async(req, rep) => "Hello World");
routeOnRoot.all(async(req, rep) => new Object({Hello:"World"}));
routeOnRoot.all(async(req, rep) => {rep.end("Hello World");});
```
     */
    all(func: sw2express.Handler): this;
  }
  interface Options {
    /**
     * Start Logger (Node Only)
     * Default: false
     */
    logger?: boolean;
    /**
     * Calc ETag (MD5) (reduce RPS)
     * Default: true
     */
    ETag?: boolean;
    /**
     * Start a Cluster (Node Only)
     * Default: false
     */
    cluster?: boolean;
  }
  /**
   *
   * @param req Request Object
   * @param rep Reply Object
   * @return it will be rep.json ||rep.end
   */
  type Handler = (
    req: sw2express.Request,
    rep: sw2express.Reply
  ) => Promise<string> | Promise<Object> | Promise<undefined>;
  /**
   *
   * @param app Sw=>Express Application Router Interface.
   */
  type Application = (app: sw2express.appRouteInterface) => any;

  interface appRouteInterface {
    /**
   * Add a Middleware for this app
   * @param MiddleWare Middlware
```
app.use(async(req,rep)={
  rep.setHeader("hello","world");
});
```
   */
    use(MiddleWare: sw2express.Handler): this;
    /**
 * Create a route
 * @param prefix prefix
```
const routeOnRoot = app.route('/');
```
 */
    route(prefix: string): sw2express.route;
  }
  interface Request {
    /**
     * Request path, like "/foo/bar"
     */
    path: string;
    /**
     * Native Request
     */
    req: Request | http.ClientRequest;
    /**
     * A Object that contains name:key
     */
    headers: Object;
    /**
     * Request method , like "POST"
     */
    method: string;
    /**
     * Request URL
     */
    url?: URL;
    /**
     * Request Host, like "foo.bar"
     */
    host: string;
    /**
     * Request protocol, like "HTTP/1.1"
     */
    protocol: string;
    /**
     * Request body, Method "POST" only.
     */
    body?: string;
  }
  interface Reply {
    /**
     * A Object that contains name:key
     */
    headers: Object;
    /**
     * HTTP status Code
     */
    statusCode: number;
    /**
     * Native Reponse (NODE only)
     */
    response?: http.ServerResponse;
    /**
     * Status of Reply
     */
    isEnd: boolean;
    /**
     * Status of Reply Headers
     */
    isSendHeader: boolean;
    /**
     * A Array that contains MSG
     */
    sendMsg: String[];
    /**
     * Set Reply Header
     * @param name name
     * @param key key
     */
    setHeader(name: string, key: string): this;
    /**
     * Get Reply name
     * @param name name
     */
    getHeader(name: string): string;
    /**
     * Send Text Native (Node.js)
     * @param text text
     */
    Nativesend(text: string): this;
    /**
     * End text Native (Node.js)
     * @param text text
     */
    Nativeend(text: string): this;
    /**
     * Send Text
     * @param text text
     */
    send(text: string): this;
    /**
     * Send Object
     * @param Obj Object
     */
    json(Obj: Object | Array<any>): this;
    /**
     * End this Reply
     * @param text string
     */
    end(text: string): boolean;
    /**
     * Gen A Reponse (SW only)
     */
    GenResponse?(): Response;
    /**
     * sendMsg => MSG (sw only)
     */
    MSG: string;
  }
  enum Platform {
    "NODE",
    "SW",
  }
}
declare class sw2express {
  /**
   * Create an Sw=>Express Application
```
const app = new sw2express();
```
   */
  constructor(options?: sw2express.Options);
  /**
   * Add a Middleware for this app
   * @param MiddleWare Middlware
```
app.use(async(req,rep)={
  rep.setHeader("hello","world");
});
```
   */
  use(MiddleWare: sw2express.Handler): this;
  /**
   * Create a route
   * @param prefix prefix
```
const routeOnRoot = app.route('/');
```
   */
  route(prefix: string): sw2express.route;
  /**
   * Extend app func.
   * @param plugins plugins
```
app.extend({
  name: "say",
  func: (app) => (text) => console.log(text, app),
  bootstrap: (app) => {
    app._say = true;
  },
});
app.say("Hello world");
```
   */
  extend(plugins: sw2express.plugin): sw2express.plugin;
  /**
   * Make a Application listen on this port (if can)
   * 
```
app.listen(8080);
```
   * @param port
   */
  listen(port: number): any;
  /**
   * Register A Application
   * need `this.extend(registerPlugin)` First.
   * 
```
import { plugins } from 'sw2express';
app.extend(plugins.register);
app.register((app) => {
  app.route("./bar").all(async (req, rep) => "Hello World");
}, "/foo/");
```
   * @param app Application Router.
   */
  register(app: sw2express.Application): this;
}
export default sw2express;
/**
 * Check the platform that sw2express is running on
 * @returns Name of Platform
 */
export function checkPlatform(): sw2express.Platform;

export const plugins: Object = {
  register: sw2express.plugin,
};
