import { checkPlatform } from "../../index.js";
const Headers = {
  "Content-Type": "text/plain; charset=utf-8",
  server: "Sw=>Express",
  "X-Powered-By": (() => {
    switch (checkPlatform()) {
      case "NODE":
        if (process.env.NODE_ENV !== "production") {
          return `Sw2Express on Node.js/${process.version} on ${process.platform}`;
        } else {
          return `Sw2Express`;
        }
      case "SW":
        return `Sw2Express on Service Worker`;
      default:
        return `Sw2Express on JavaScript`;
    }
  })(),
  "X-Served-By": "Sw=>Express",
};
export default Headers;
