import { nodeRequest } from "../req.js";
import { nodeReply } from "../rep.js";

export async function startHTTPServer(PORT) {
  const http = await import("http").then((e) => e.default);
  const app = http.createServer();
  if (PORT) {
    app.listen(PORT);
  }
  return app;
}
async function doRequest(func, NodeRequest, NodeReply) {
  const rep = await func(NodeRequest, NodeReply).catch(async (e) => {
    await doRequest(page.Code(500).GenAsync, NodeRequest, NodeReply);
    console.log(e.stack);
  });
  if (!NodeReply.isEnd) {
    if (typeof rep !== "object") NodeReply.end(rep);
    else NodeReply.json(rep);
  }
}
export const newHTTPServer = async (port) => {
  return async (that) => {
    const options = that.options;

    if (options.cluster) {
      const cluster = await import("cluster").then((e) => e.default);

      if (cluster.isMaster) {
        console.log("Master Process is running...");
        for (let i = 0; i < options.cluster; i++) {
          cluster.fork();
        }

        cluster.on("exit", (worker, code, signal) => {
          console.log(`Worker ${worker.id} is exited with code ${code}`);
          cluster.fork();
        });
      }

      if (cluster.isWorker) {
        console.log(`Worker Process ${cluster.worker.id} is running...`);
        const server = await startHTTPServer(port);
        server.on("request", await HTTPHandler(that));
      }
    } else {
      const server = await startHTTPServer(port);
      server.on("request", await HTTPHandler(that));
      return server;
    }
  };
};

export const HTTPHandler = async (that) => {
  const page = that.DefaultPage;
  return async (request, response) => {
    let body = await new Promise((resolve) => {
      if (request.method === "POST" && !request.body) {
        let body = [];
        request.on("data", (chunk) => body.push(chunk));
        request.on("end", () => {
          body = Buffer.concat(body).toString();
          resolve(body);
        });
      } else if (request.body) {
        resolve(request.body);
      } else {
        resolve();
      }
    });
    let NodeRequest = new nodeRequest(request, body),
      NodeReply = new nodeReply(response, request, that.options),
      path = request.url;
    new Promise((resolve) => {
      if (that.options.logger) {
        console.log(
          `[${new Date().toLocaleString()}] ${request.socket.remoteAddress} - ${
            request.method
          } ${path}`
        );
        resolve();
      }
    });
    await Promise.all(
      that._middleWare.map((middleware) => middleware(NodeRequest, NodeReply))
    );
    if (!NodeReply.isEnd) {
      if (that._route[path]) {
        if (that._route[path][request.method]) {
          await doRequest(
            that._route[path][request.method],
            NodeRequest,
            NodeReply
          );
        } else if (that._route[path].all) {
          await doRequest(that._route[path].all, NodeRequest, NodeReply);
        } else {
          await doRequest(page.Code(500).GenAsync, NodeRequest, NodeReply);
        }
      } else {
        await doRequest(page.Code(404).GenAsync, NodeRequest, NodeReply);
      }
    }
  };
};
