export class nodeRequest {
  constructor(req, body) {
    this.req = req;
    this.headers = req.headers;
    this.method = req.method;
    this.host = this.headers["x-forward-for"] || req.host;
    this.protocol = this.headers["x-forward-proto"] || req.protocol;
    this.path = req.url;
    if (this.method === "POST") {
      this.body = body;
    }
  }
}

export class swRequest {
  constructor(req, body) {
    this.req = req;
    this.headers = Object.fromEntries(req.headers.entries());
    this.method = req.method;
    this.url = new URL(req.url);
    this.host = this.headers["x-forward-for"] || this.url.host;
    this.path = this.url.pathname;
    this.protocol = this.headers["x-forward-proto"] || this.url.protocol;
    if (this.method === "POST") {
      this.body = body;
    }
  }
}
