import { checkPlatform } from "../../index.js";
export default () => {
  if (globalThis.platform === "NODE") {
    const crypto = import("crypto").then((e) => e.default);
    return async (text) => {
      const md5 = (await crypto).createHash("md5");
      const answer = md5.update(text).digest("hex");
      return answer;
    };
  } else if (globalThis.platform === "SW") {
    return async (text) => {
      const textUint8 = new TextEncoder().encode(text);
      const hashBuffer = await crypto.subtle.digest("MD5", textUint8);
      const hashArray = Array.from(new Uint8Array(hashBuffer));
      const hashHex = hashArray
        .map((b) => b.toString(16).padStart(2, "0"))
        .join("");
      return hashHex;
    };
  } else {
    return async (text) => {
      throw new Error("Can't Found Platform!");
    };
    throw new Error("Can't Found Platform!");
  }
};
