importScripts("./sw2express.min.js");
const app = new sw2express({
  logger: true,
  ETag: false,
});
app.route("/").all(async (req, rep) => {
  rep.send(`Send From ${checkPlatform()}\n`);
  rep.send("Hello World, Sw2Express!");
});
app.route("/sw.js").all(async (req, rep) => {
  const answer = await fetch("./sw.js");
  const text = await answer.text();
  rep.setHeader("Content-Type", "application/javascript; charset=utf-8");
  rep.send(text);
});
app.route("/update.html").all(async (req, rep) => {
  const answer = await fetch("./index.html");
  const text = await answer.text();
  rep.setHeader("Content-Type", "text/html; charset=utf-8");
  rep.end(text);
});
app.listen(8080);
