import stampit from 'stampit';
import { mergeRight } from 'ramda';
import Node from "../../Node.js";
const YamlDirective = stampit(Node, {
  statics: {
    type: 'directive'
  },
  props: {
    name: null,
    parameters: null
  },
  init({
    name = null,
    parameters = {}
  } = {}) {
    this.name = name;
    this.parameters = mergeRight({
      version: null,
      handle: null,
      prefix: null
    }, parameters);
  }
});
export default YamlDirective;