import stampit from 'stampit';
import Node from "../../Node.js";
import { isComment, isDocument } from "./predicates.js";
const YamlStream = stampit(Node, {
  statics: {
    type: 'stream'
  },
  propertyDescriptors: {
    content: {
      get() {
        // @ts-ignore
        return Array.isArray(this.children) ?
        // @ts-ignore
        this.children.filter(node => isDocument(node) || isComment(node)) : [];
      },
      enumerable: true
    }
  }
});
export default YamlStream;