import stampit from 'stampit';
import JsonNode from "./JsonNode.js";
import { isArray, isFalse, isKey, isNull, isNumber, isObject, isString, isTrue } from "./predicates.js";
const JsonProperty = stampit(JsonNode, {
  statics: {
    type: 'property'
  },
  methods: {
    // @ts-ignore
    get key() {
      // @ts-ignore
      return this.children.find(isKey);
    },
    // @ts-ignore
    get value() {
      // @ts-ignore
      return this.children.find(node => isFalse(node) || isTrue(node) || isNull(node) || isNumber(node) || isString(node) || isArray(node) || isObject(node));
    }
  }
});
export default JsonProperty;