"use strict";

var _interopRequireDefault = require("@babel/runtime-corejs3/helpers/interopRequireDefault");
exports.__esModule = true;
exports.default = void 0;
var _stampit = _interopRequireDefault(require("stampit"));
var _canonicalFormat = require("./canonical-format.cjs");
var _YamlStyle = require("../nodes/YamlStyle.cjs");
var _YamlTag = require("../nodes/YamlTag.cjs");
const ScalarTag = (0, _stampit.default)({
  methods: {
    test(node) {
      return node.tag.kind === _YamlTag.YamlNodeKind.Scalar && typeof node.content === 'string';
    },
    canonicalFormat(node) {
      let canonicalForm = node.content;
      const nodeClone = node.clone();
      if (node.style === _YamlStyle.YamlStyle.Plain) {
        // @ts-ignore
        canonicalForm = (0, _canonicalFormat.formatFlowPlain)(node.content);
      } else if (node.style === _YamlStyle.YamlStyle.SingleQuoted) {
        // @ts-ignore
        canonicalForm = (0, _canonicalFormat.formatFlowSingleQuoted)(node.content);
      } else if (node.style === _YamlStyle.YamlStyle.DoubleQuoted) {
        // @ts-ignore
        canonicalForm = (0, _canonicalFormat.formatFlowDoubleQuoted)(node.content);
      } else if (node.style === _YamlStyle.YamlStyle.Literal) {
        // @ts-ignore
        canonicalForm = (0, _canonicalFormat.formatBlockLiteral)(node.content);
      } else if (node.style === _YamlStyle.YamlStyle.Folded) {
        // @ts-ignore
        canonicalForm = (0, _canonicalFormat.formatBlockFolded)(node.content);
      }
      nodeClone.content = canonicalForm;
      return nodeClone;
    },
    resolve(node) {
      return node;
    }
  }
});
var _default = ScalarTag;
exports.default = _default;