import stampit from 'stampit';
import Node from "../../Node.js";
import YamlStyleModel from "./YamlStyle.js";
import { isScalar, isMapping, isSequence, isAlias } from "./predicates.js";
const YamlKeyValuePair = stampit(Node, YamlStyleModel, {
  statics: {
    type: 'keyValuePair'
  },
  propertyDescriptors: {
    key: {
      get() {
        // @ts-ignore
        return this.children.filter(node => isScalar(node) || isMapping(node) || isSequence(node))[0];
      },
      enumerable: true
    },
    value: {
      get() {
        // @ts-ignore
        const {
          key,
          children
        } = this;
        const excludeKeyPredicate = node => node !== key;
        const valuePredicate = node => isScalar(node) || isMapping(node) || isSequence(node) || isAlias(node);

        // @ts-ignore
        return children.filter(node => excludeKeyPredicate(node) && valuePredicate(node))[0];
      },
      enumerable: true
    }
  }
});
export default YamlKeyValuePair;