"use strict";

var _interopRequireDefault = require("@babel/runtime-corejs3/helpers/interopRequireDefault");
exports.__esModule = true;
exports.default = void 0;
var _stampit = _interopRequireDefault(require("stampit"));
const Node = (0, _stampit.default)({
  props: {
    type: null,
    position: null,
    children: []
  },
  // eslint-disable-next-line @typescript-eslint/default-param-last
  init({
    children = [],
    position = null,
    isMissing = false
  } = {}, {
    stamp = {}
  }) {
    this.type = stamp.type;
    this.isMissing = isMissing;
    this.children = children;
    this.position = position;
  },
  methods: {
    // creates shallow clone of node
    clone() {
      // 1. copy has same prototype as orig
      const copy = Object.create(Object.getPrototypeOf(this));

      // 2. copy has all of orig’s properties
      Object.getOwnPropertyNames(this) // (1)
      .forEach(propKey => {
        // (2)
        const descriptor = Object.getOwnPropertyDescriptor(this, propKey); // (3)
        // @ts-ignore
        Object.defineProperty(copy, propKey, descriptor); // (4)
      });

      return copy;
    }
  }
});
var _default = Node;
exports.default = _default;