"use strict";

exports.__esModule = true;
exports.isPosition = exports.isPoint = exports.isParseResult = exports.isNodeType = exports.isLiteral = void 0;
const isNodeType = (type, node) => (node === null || node === void 0 ? void 0 : node.type) === type;
exports.isNodeType = isNodeType;
const isLiteral = isNodeType.bind(undefined, 'literal');
exports.isLiteral = isLiteral;
const isPosition = isNodeType.bind(undefined, 'position');
exports.isPosition = isPosition;
const isPoint = isNodeType.bind(undefined, 'point');
exports.isPoint = isPoint;
const isParseResult = isNodeType.bind(undefined, 'parseResult');
exports.isParseResult = isParseResult;