"use strict";

var _interopRequireDefault = require("@babel/runtime-corejs3/helpers/interopRequireDefault");
exports.__esModule = true;
exports.default = void 0;
var _stampit = _interopRequireDefault(require("stampit"));
var _Node = _interopRequireDefault(require("../../Node.cjs"));
var _YamlStyle = _interopRequireDefault(require("./YamlStyle.cjs"));
var _predicates = require("./predicates.cjs");
const YamlKeyValuePair = (0, _stampit.default)(_Node.default, _YamlStyle.default, {
  statics: {
    type: 'keyValuePair'
  },
  propertyDescriptors: {
    key: {
      get() {
        // @ts-ignore
        return this.children.filter(node => (0, _predicates.isScalar)(node) || (0, _predicates.isMapping)(node) || (0, _predicates.isSequence)(node))[0];
      },
      enumerable: true
    },
    value: {
      get() {
        // @ts-ignore
        const {
          key,
          children
        } = this;
        const excludeKeyPredicate = node => node !== key;
        const valuePredicate = node => (0, _predicates.isScalar)(node) || (0, _predicates.isMapping)(node) || (0, _predicates.isSequence)(node) || (0, _predicates.isAlias)(node);

        // @ts-ignore
        return children.filter(node => excludeKeyPredicate(node) && valuePredicate(node))[0];
      },
      enumerable: true
    }
  }
});
var _default = YamlKeyValuePair;
exports.default = _default;