"use strict";

var _interopRequireDefault = require("@babel/runtime-corejs3/helpers/interopRequireDefault");
exports.__esModule = true;
exports.default = void 0;
var _ramda = require("ramda");
var _stampit = _interopRequireDefault(require("stampit"));
var _YamlTagError = _interopRequireDefault(require("../../errors/YamlTagError.cjs"));
var _YamlTag = require("../../nodes/YamlTag.cjs");
var _GenericMapping = _interopRequireDefault(require("./GenericMapping.cjs"));
var _GenericSequence = _interopRequireDefault(require("./GenericSequence.cjs"));
var _GenericString = _interopRequireDefault(require("./GenericString.cjs"));
var _ScalarTag = _interopRequireDefault(require("../ScalarTag.cjs"));
const FailsafeSchema = (0, _stampit.default)({
  props: {
    tags: [],
    tagDirectives: []
  },
  init() {
    this.tags = [];
    this.tagDirectives = [];
    this.registerTag((0, _GenericMapping.default)());
    this.registerTag((0, _GenericSequence.default)());
    this.registerTag((0, _GenericString.default)());
  },
  methods: {
    toSpecificTagName(node) {
      let specificTagName = node.tag.explicitName;
      if (node.tag.explicitName === '!') {
        // non-specific tag; we assume tag by kind
        if (node.tag.kind === _YamlTag.YamlNodeKind.Scalar) {
          // @ts-ignore
          specificTagName = _GenericString.default.uri;
        } else if (node.tag.kind === _YamlTag.YamlNodeKind.Sequence) {
          // @ts-ignore
          specificTagName = _GenericSequence.default.uri;
        } else if (node.tag.kind === _YamlTag.YamlNodeKind.Mapping) {
          // @ts-ignore
          specificTagName = _GenericMapping.default.uri;
        }
      } else if (node.tag.explicitName.startsWith('!<')) {
        // verbatim form
        specificTagName = node.tag.explicitName.replace(/^!</, '').replace(/>$/, '');
      } else if (node.tag.explicitName.startsWith('!!')) {
        // shorthand notation
        specificTagName = `tag:yaml.org,2002:${node.tag.explicitName.replace(/^!!/, '')}`;
      }
      return specificTagName;
    },
    registerTagDirective(tagDirective) {
      this.tagDirectives.push({
        handle: tagDirective.parameters.handle,
        prefix: tagDirective.parameters.prefix
      });
    },
    registerTag(tag, beginning = false) {
      if (beginning) {
        this.tags.unshift(tag);
      } else {
        this.tags.push(tag);
      }
      return this;
    },
    overrideTag(tag) {
      this.tags = this.tags.filter(itag => itag.tag === tag.tag);
      this.tags.push(tag);
      return this;
    },
    resolve(node) {
      const specificTagName = this.toSpecificTagName(node);

      // leave this node unresolved
      if (specificTagName === '?') {
        return node;
      }

      // turn scalar nodes into canonical format before resolving
      let canonicalNode = node;
      if (node.tag.kind === _YamlTag.YamlNodeKind.Scalar) {
        canonicalNode = (0, _ScalarTag.default)().canonicalFormat(node);
      }
      const tag = this.tags.find(itag => (itag === null || itag === void 0 ? void 0 : itag.tag) === specificTagName);

      // mechanism for resolving node (tag implementation) not found
      if (typeof tag === 'undefined') {
        throw new _YamlTagError.default(`Tag "${specificTagName}" was not recognized.`, {
          specificTagName,
          explicitTagName: node.tag.explicitName,
          tagKind: node.tag.kind,
          tagPosition: (0, _ramda.clone)(node.tag.position)
        });
      }

      // node content is not compatible with resolving mechanism (tag implementation)
      if (!tag.test(canonicalNode)) {
        throw new _YamlTagError.default(`Node couldn't be resolved against the tag "${specificTagName}"`, {
          specificTagName,
          explicitTagName: node.tag.explicitName,
          tagKind: node.tag.kind,
          tagPosition: (0, _ramda.clone)(node.tag.position),
          nodeCanonicalContent: canonicalNode.content
        });
      }
      return tag.resolve(canonicalNode);
    }
  }
});
var _default = FailsafeSchema;
exports.default = _default;