"use strict";

var _interopRequireDefault = require("@babel/runtime-corejs3/helpers/interopRequireDefault");
exports.__esModule = true;
exports.default = void 0;
var _stampit = _interopRequireDefault(require("stampit"));
var _index = _interopRequireDefault(require("../failsafe/index.cjs"));
var _Boolean = _interopRequireDefault(require("./Boolean.cjs"));
var _FloatingPoint = _interopRequireDefault(require("./FloatingPoint.cjs"));
var _Integer = _interopRequireDefault(require("./Integer.cjs"));
var _Null = _interopRequireDefault(require("./Null.cjs"));
var _YamlTag = require("../../nodes/YamlTag.cjs");
var _GenericSequence = _interopRequireDefault(require("../failsafe/GenericSequence.cjs"));
var _GenericMapping = _interopRequireDefault(require("../failsafe/GenericMapping.cjs"));
const JsonSchema = (0, _stampit.default)(_index.default, {
  init() {
    /**
     * We're registering more specific tags before more generic ones from Failsafe schema.
     */
    this.registerTag((0, _Boolean.default)(), true);
    this.registerTag((0, _FloatingPoint.default)(), true);
    this.registerTag((0, _Integer.default)(), true);
    this.registerTag((0, _Null.default)(), true);
  },
  methods: {
    toSpecificTagName(node) {
      // @ts-ignore
      let specificTagName = _index.default.compose.methods.toSpecificTagName.call(this, node);
      if (specificTagName === '?') {
        if (node.tag.vkind === _YamlTag.YamlNodeKind.Sequence) {
          // @ts-ignore
          specificTagName = _GenericSequence.default.uri;
        } else if (node.tag.kind === _YamlTag.YamlNodeKind.Mapping) {
          // @ts-ignore
          specificTagName = _GenericMapping.default.uri;
        } else if (node.tag.kind === _YamlTag.YamlNodeKind.Scalar) {
          // @ts-ignore
          const foundTag = this.tags.find(tag => tag.test(node));
          specificTagName = (foundTag === null || foundTag === void 0 ? void 0 : foundTag.tag) || '?';
        }
      }
      return specificTagName;
    }
  }
});
var _default = JsonSchema;
exports.default = _default;