import stampit from 'stampit';
import JsonNode from "./JsonNode.js";
import { isFalse, isTrue, isNull, isNumber, isString, isArray, isObject } from "./predicates.js";
const JsonArray = stampit(JsonNode, {
  statics: {
    type: 'array'
  },
  methods: {
    get items() {
      // @ts-ignore
      return this.children.filter(node => isFalse(node) || isTrue(node) || isNull(node) || isNumber(node) || isString(node) || isArray(node) || isObject);
    }
  }
});
export default JsonArray;