import stampit from 'stampit';
import JsonNode from "./JsonNode.js";
import { isEscapeSequence, isStringContent } from "./predicates.js";
const JsonString = stampit(JsonNode, {
  statics: {
    type: 'string'
  },
  methods: {
    get value() {
      // @ts-ignore
      if (this.children.length === 1) {
        // @ts-ignore
        return this.children[0].value;
      }
      return this.children
      // @ts-ignore
      .filter(node => isStringContent(node) || isEscapeSequence(node)).reduce((acc, cur) => acc + cur.value, '');
    }
  }
});
export default JsonString;