import stampit from 'stampit';
import YamlCollection from "./YamlCollection.js";
import { isKeyValuePair } from "./predicates.js";
const YamlMapping = stampit(YamlCollection, {
  statics: {
    type: 'mapping'
  },
  propertyDescriptors: {
    content: {
      get() {
        // @ts-ignore
        return Array.isArray(this.children) ? this.children.filter(isKeyValuePair) : [];
      },
      enumerable: true
    }
  }
});
export default YamlMapping;