import stampit from 'stampit';
import YamlCollection from "./YamlCollection.js";
import { isMapping, isScalar, isSequence, isAlias } from "./predicates.js";
const YamlSequence = stampit(YamlCollection, {
  statics: {
    type: 'sequence'
  },
  propertyDescriptors: {
    content: {
      get() {
        // @ts-ignore
        const {
          children
        } = this;
        return Array.isArray(children) ? children.filter(node => isSequence(node) || isMapping(node) || isScalar(node) || isAlias(node)) : [];
      },
      enumerable: true
    }
  }
});
export default YamlSequence;