import stampit from 'stampit';
import FailsafeSchema from "../failsafe/index.js";
import Boolean from "./Boolean.js";
import FloatingPoint from "./FloatingPoint.js";
import Integer from "./Integer.js";
import Null from "./Null.js";
import { YamlNodeKind } from "../../nodes/YamlTag.js";
import GenericSequence from "../failsafe/GenericSequence.js";
import GenericMapping from "../failsafe/GenericMapping.js";
const JsonSchema = stampit(FailsafeSchema, {
  init() {
    /**
     * We're registering more specific tags before more generic ones from Failsafe schema.
     */
    this.registerTag(Boolean(), true);
    this.registerTag(FloatingPoint(), true);
    this.registerTag(Integer(), true);
    this.registerTag(Null(), true);
  },
  methods: {
    toSpecificTagName(node) {
      // @ts-ignore
      let specificTagName = FailsafeSchema.compose.methods.toSpecificTagName.call(this, node);
      if (specificTagName === '?') {
        if (node.tag.vkind === YamlNodeKind.Sequence) {
          // @ts-ignore
          specificTagName = GenericSequence.uri;
        } else if (node.tag.kind === YamlNodeKind.Mapping) {
          // @ts-ignore
          specificTagName = GenericMapping.uri;
        } else if (node.tag.kind === YamlNodeKind.Scalar) {
          // @ts-ignore
          const foundTag = this.tags.find(tag => tag.test(node));
          specificTagName = (foundTag === null || foundTag === void 0 ? void 0 : foundTag.tag) || '?';
        }
      }
      return specificTagName;
    }
  }
});
export default JsonSchema;