import stampit from 'stampit';
import { ApiDOMStructuredError, ApiDOMErrorOptions } from '@swagger-api/apidom-error';

interface Point {
    type: 'point';
    row: number | null;
    column: number | null;
    char: number | null;
}
declare const Point: stampit.Stamp<Point>;
interface Position extends Node {
    type: 'position';
    start: Point | null;
    end: Point | null;
}
declare const Position: stampit.Stamp<Position>;

interface Node$1 {
    type: string | null;
    isMissing: boolean;
    children: unknown[];
    position: Position | null;
}
declare const Node$1: stampit.Stamp<Node$1>;

type JsonNode = Node$1;
declare const JsonNode: stampit.Stamp<JsonNode>;

interface JsonDocument extends JsonNode {
    child: unknown | null;
}
declare const JsonDocument: stampit.Stamp<JsonDocument>;

type JsonObject = JsonNode;
declare const JsonObject: stampit.Stamp<JsonObject>;

interface JsonString extends JsonNode {
    value: string;
}
declare const JsonString: stampit.Stamp<JsonString>;

type JsonKey = JsonString;
declare const JsonKey: stampit.Stamp<JsonKey>;

interface JsonProperty extends JsonNode {
    key: JsonKey;
    value: unknown;
}
declare const JsonProperty: stampit.Stamp<JsonProperty>;

type JsonArray = JsonNode;
declare const JsonArray: stampit.Stamp<JsonArray>;

interface JsonValue extends JsonNode {
    value: unknown;
}
declare const JsonValue: stampit.Stamp<JsonValue>;

type JsonStringContent = JsonValue;
declare const JsonStringContent: stampit.Stamp<JsonStringContent>;

type JsonEscapeSequence = JsonValue;
declare const JsonEscapeSequence: stampit.Stamp<JsonEscapeSequence>;

type JsonNumber = JsonValue;
declare const JsonNumber: stampit.Stamp<JsonNumber>;

type JsonTrue = JsonValue;
declare const JsonTrue: stampit.Stamp<JsonTrue>;

type JsonFalse = JsonValue;
declare const JsonFalse: stampit.Stamp<JsonFalse>;

type JsonNull = JsonValue;
declare const JsonNull: stampit.Stamp<JsonNull>;

declare const isDocument$1: (node: any) => boolean;
declare const isString: (node: any) => boolean;
declare const isFalse: (node: any) => boolean;
declare const isTrue: (node: any) => boolean;
declare const isNull: (node: any) => boolean;
declare const isNumber: (node: any) => boolean;
declare const isArray: (node: any) => boolean;
declare const isObject: (node: any) => boolean;
declare const isStringContent: (node: any) => boolean;
declare const isEscapeSequence: (node: any) => boolean;
declare const isProperty: (node: any) => boolean;
declare const isKey: (node: any) => boolean;

interface YamlAlias extends Node$1 {
    type: 'alias';
    content: string | null;
}
declare const YamlAlias: stampit.Stamp<YamlAlias>;

declare enum YamlNodeKind {
    Scalar = "Scalar",
    Sequence = "Sequence",
    Mapping = "Mapping"
}
interface YamlTag extends Node$1 {
    type: 'tag';
    explicitName: string;
    kind: YamlNodeKind;
}
declare const YamlTag: stampit.Stamp<YamlTag>;

interface YamlAnchor extends Node$1 {
    type: 'anchor';
    name: string | null;
}
declare const YamlAnchor: stampit.Stamp<YamlAnchor>;

declare enum YamlStyle {
    Plain = "Plain",
    SingleQuoted = "SingleQuoted",
    DoubleQuoted = "DoubleQuoted",
    Literal = "Literal",
    Folded = "Folded",
    Explicit = "Explicit",
    SinglePair = "SinglePair",
    NextLine = "NextLine",
    InLine = "InLine"
}
declare enum YamlStyleGroup {
    Flow = "Flow",
    Block = "Block"
}
interface YamlStyleModel {
    styleGroup: YamlStyleGroup | null;
    style: YamlStyle | null;
}
declare const YamlStyleModel: stampit.Stamp<YamlStyleModel>;

interface YamlNode extends Node$1 {
    anchor: YamlAnchor | null;
    tag: YamlTag | null;
    style: YamlStyle;
    styleGroup: YamlStyleGroup;
}
declare const YamlNode: stampit.Stamp<YamlNode>;

type YamlCollection = YamlNode;
declare const YamlCollection: stampit.Stamp<YamlCollection>;

interface YamlComment extends Node$1 {
    type: 'comment';
    content: string | null;
}
declare const YamlComment: stampit.Stamp<YamlComment>;

interface YamlDirectiveParameters {
    version: string | null;
    handle: string | null;
    prefix: string | null;
}
interface YamlDirective extends Node$1 {
    type: 'directive';
    name: string | null;
    parameters: YamlDirectiveParameters;
}
declare const YamlDirective: stampit.Stamp<YamlDirective>;

interface YamlDocument extends Node$1 {
    type: 'document';
}
declare const YamlDocument: stampit.Stamp<YamlDocument>;

interface YamlScalar extends YamlNode {
    type: 'scalar';
    format: string | null;
    text: string;
    readonly content: string | null;
}
declare const YamlScalar: stampit.Stamp<YamlScalar>;

interface YamlKeyValuePair extends Node$1, YamlStyleModel {
    type: 'keyValuePair';
    readonly key: YamlScalar;
    readonly value: any;
}
declare const YamlKeyValuePair: stampit.Stamp<YamlKeyValuePair>;

interface YamlMapping extends YamlCollection {
    type: 'mapping';
    readonly content: Array<YamlKeyValuePair>;
}
declare const YamlMapping: stampit.Stamp<YamlMapping>;

interface YamlSequence extends YamlCollection {
    type: 'sequence';
    readonly content: Array<YamlSequence | YamlMapping | YamlScalar | YamlAlias>;
}
declare const YamlSequence: stampit.Stamp<YamlSequence>;

interface YamlStream extends Node$1 {
    type: 'stream';
    readonly content: Array<YamlDocument | YamlComment>;
    children: Array<YamlDocument>;
}
declare const YamlStream: stampit.Stamp<YamlStream>;

declare const FailsafeSchema: stampit.Stamp<any>;

declare const JsonSchema: stampit.Stamp<any>;

declare const isStream: (node: any) => boolean;
declare const isDocument: (node: any) => boolean;
declare const isMapping: (node: any) => boolean;
declare const isSequence: (node: any) => boolean;
declare const isKeyValuePair: (node: any) => boolean;
declare const isTag: (node: any) => boolean;
declare const isScalar: (node: any) => boolean;
declare const isAlias: (node: any) => boolean;
declare const isDirective: (node: any) => boolean;

declare class YamlSchemaError extends ApiDOMStructuredError {
}

interface YamlTagErrorOptions extends ApiDOMErrorOptions {
    readonly specificTagName: string;
    readonly explicitTagName: string;
    readonly tagKind: string;
    readonly tagPosition?: Position;
    readonly nodeCanonicalContent?: string;
}
declare class YamlTagError extends YamlSchemaError {
    readonly specificTagName: string;
    readonly explicitTagName: string;
    readonly tagKind: string;
    readonly tagPosition?: Position;
    readonly nodeCanonicalContent?: string;
    constructor(message?: string, structuredOptions?: YamlTagErrorOptions);
}

interface Literal extends Node$1 {
    type: 'literal';
    value: unknown;
}
declare const Literal: stampit.Stamp<Literal>;

interface Error extends Node$1 {
    value: unknown;
    isUnexpected: boolean;
}
declare const Error: stampit.Stamp<Error>;

interface ParseResult extends Node$1 {
    type: 'parseResult';
    rootNode: unknown;
}
declare const ParseResult: stampit.Stamp<ParseResult>;

declare const isLiteral: (node: any) => boolean;
declare const isPosition: (node: any) => boolean;
declare const isPoint: (node: any) => boolean;
declare const isParseResult: (node: any) => boolean;

/**
 * SPDX-FileCopyrightText: Copyright (c) GraphQL Contributors
 *
 * SPDX-License-Identifier: MIT
 */
declare const getVisitFn: (visitor: any, type: string, isLeaving: boolean) => any;
declare const BREAK: {};
declare const getNodeType: (node: any) => any;
declare const isNode: (node: any) => boolean;
/**
 * Creates a new visitor instance which delegates to many visitors to run in
 * parallel. Each visitor will be visited for each node before moving on.
 *
 * If a prior visitor edits a node, no following visitors will see that node.
 */
declare const mergeAll: (visitors: any[], { visitFnGetter, nodeTypeGetter }?: {
    visitFnGetter?: ((visitor: any, type: string, isLeaving: boolean) => any) | undefined;
    nodeTypeGetter?: ((node: any) => any) | undefined;
}) => {
    enter(node: any, ...rest: any[]): any;
    leave(node: any, ...rest: any[]): any;
};
/**
 * visit() will walk through an AST using a preorder depth first traversal, calling
 * the visitor's enter function at each node in the traversal, and calling the
 * leave function after visiting that node and all of its child nodes.
 *
 * By returning different values from the enter and leave functions, the
 * behavior of the visitor can be altered, including skipping over a sub-tree of
 * the AST (by returning false), editing the AST by returning a value or null
 * to remove the value, or to stop the whole traversal by returning BREAK.
 *
 * When using visit() to edit an AST, the original AST will not be modified, and
 * a new version of the AST with the changes applied will be returned from the
 * visit function.
 *
 *     const editedAST = visit(ast, {
 *       enter(node, key, parent, path, ancestors) {
 *         // @return
 *         //   undefined: no action
 *         //   false: skip visiting this node
 *         //   BREAK: stop visiting altogether
 *         //   null: delete this node
 *         //   any value: replace this node with the returned value
 *       },
 *       leave(node, key, parent, path, ancestors) {
 *         // @return
 *         //   undefined: no action
 *         //   false: no action
 *         //   BREAK: stop visiting altogether
 *         //   null: delete this node
 *         //   any value: replace this node with the returned value
 *       }
 *     });
 *
 * Alternatively to providing enter() and leave() functions, a visitor can
 * instead provide functions named the same as the kinds of AST nodes, or
 * enter/leave visitors at a named key, leading to four permutations of
 * visitor API:
 *
 * 1) Named visitors triggered when entering a node a specific kind.
 *
 *     visit(ast, {
 *       Kind(node) {
 *         // enter the "Kind" node
 *       }
 *     })
 *
 * 2) Named visitors that trigger upon entering and leaving a node of
 *    a specific kind.
 *
 *     visit(ast, {
 *       Kind: {
 *         enter(node) {
 *           // enter the "Kind" node
 *         }
 *         leave(node) {
 *           // leave the "Kind" node
 *         }
 *       }
 *     })
 *
 * 3) Generic visitors that trigger upon entering and leaving any node.
 *
 *     visit(ast, {
 *       enter(node) {
 *         // enter any node
 *       },
 *       leave(node) {
 *         // leave any node
 *       }
 *     })
 *
 * 4) Parallel visitors for entering and leaving nodes of a specific kind.
 *
 *     visit(ast, {
 *       enter: {
 *         Kind(node) {
 *           // enter the "Kind" node
 *         }
 *       },
 *       leave: {
 *         Kind(node) {
 *           // leave the "Kind" node
 *         }
 *       }
 *     })
 *
 *  @sig visit :: (Node, Visitor, Options)
 *  @sig      Options = { keyMap: Object, state: Object }
 */
declare const visit: (root: any, visitor: any, { keyMap, state, breakSymbol, deleteNodeSymbol, skipVisitingNodeSymbol, visitFnGetter, nodeTypeGetter, nodePredicate, detectCycles, }?: {
    keyMap?: null | undefined;
    state?: {} | undefined;
    breakSymbol?: {} | undefined;
    deleteNodeSymbol?: null | undefined;
    skipVisitingNodeSymbol?: boolean | undefined;
    visitFnGetter?: ((visitor: any, type: string, isLeaving: boolean) => any) | undefined;
    nodeTypeGetter?: ((node: any) => any) | undefined;
    nodePredicate?: ((node: any) => boolean) | undefined;
    detectCycles?: boolean | undefined;
}) => any;

export { BREAK, Error, JsonArray, JsonDocument, JsonEscapeSequence, JsonFalse, JsonKey, JsonNode, JsonNull, JsonNumber, JsonObject, JsonProperty, JsonString, JsonStringContent, JsonTrue, JsonValue, Literal, ParseResult, Point, Position, YamlAlias, YamlAnchor, YamlCollection, YamlComment, YamlDirective, YamlDocument, FailsafeSchema as YamlFailsafeSchema, JsonSchema as YamlJsonSchema, YamlKeyValuePair, YamlMapping, YamlNode, YamlNodeKind, YamlScalar, YamlSchemaError, YamlSequence, YamlStream, YamlStyle, YamlStyleGroup, YamlTag, YamlTagError, YamlTagErrorOptions, getNodeType, getVisitFn, isArray as isJsonArray, isDocument$1 as isJsonDocument, isEscapeSequence as isJsonEscapeSequence, isFalse as isJsonFalse, isKey as isJsonKey, isNull as isJsonNull, isNumber as isJsonNumber, isObject as isJsonObject, isProperty as isJsonProperty, isString as isJsonString, isStringContent as isJsonStringContent, isTrue as isJsonTrue, isLiteral, isNode, isParseResult, isPoint, isPosition, isAlias as isYamlAlias, isDirective as isYamlDirective, isDocument as isYamlDocument, isKeyValuePair as isYamlKeyValuePair, isMapping as isYamlMapping, isScalar as isYamlScalar, isSequence as isYamlSequence, isStream as isYamlStream, isTag as isYamlTag, mergeAll as mergeAllVisitors, visit };
