"use strict";

exports.__esModule = true;
exports.isPosition = exports.isPoint = exports.isParseResult = exports.isNodeType = exports.isLiteral = void 0;
/**
 * @public
 */
const isNodeType = (type, node) => node != null && typeof node === 'object' && 'type' in node && node.type === type;

/**
 * @public
 */
exports.isNodeType = isNodeType;
const isLiteral = node => isNodeType('literal', node);

/**
 * @public
 */
exports.isLiteral = isLiteral;
const isPosition = node => isNodeType('position', node);

/**
 * @public
 */
exports.isPosition = isPosition;
const isPoint = node => isNodeType('point', node);

/**
 * @public
 */
exports.isPoint = isPoint;
const isParseResult = node => isNodeType('parseResult', node);
exports.isParseResult = isParseResult;