import type { ApiDOMErrorOptions } from '@swagger-api/apidom-error';
import { ApiDOMStructuredError } from '@swagger-api/apidom-error';

/**
 * @public
 */
export declare const BREAK: {};

/**
 * @public
 */
export declare const cloneNode: (node: any) => any;

/**
 * @public
 */
declare class Error_2 extends Node_2 {
    static readonly type: string;
    readonly value: unknown;
    readonly isUnexpected: boolean;
    constructor({ value, isUnexpected, ...rest }?: ErrorOptions_2);
}
export { Error_2 as Error }

/**
 * @public
 */
declare interface ErrorOptions_2 extends NodeOptions {
    readonly value?: unknown;
    readonly isUnexpected?: boolean;
}
export { ErrorOptions_2 as ErrorOptions }

/**
 * @public
 */
export declare const getNodeType: (node: any) => string | undefined;

/**
 * @public
 */
export declare const getVisitFn: (visitor: any, type: string | undefined, isLeaving: boolean) => ((...args: any[]) => any) | null;

/**
 * @public
 */
export declare const isJsonArray: (node: unknown) => node is JsonArray;

/**
 * @public
 */
export declare const isJsonDocument: (node: unknown) => node is JsonDocument;

/**
 * @public
 */
export declare const isJsonEscapeSequence: (node: unknown) => node is JsonEscapeSequence;

/**
 * @public
 */
export declare const isJsonFalse: (node: unknown) => node is JsonFalse;

/**
 * @public
 */
export declare const isJsonKey: (node: unknown) => node is JsonKey;

/**
 * @public
 */
export declare const isJsonNull: (node: unknown) => node is JsonNull;

/**
 * @public
 */
export declare const isJsonNumber: (node: unknown) => node is JsonNumber;

/**
 * @public
 */
export declare const isJsonObject: (node: unknown) => node is JsonObject;

/**
 * @public
 */
export declare const isJsonProperty: (node: unknown) => node is JsonProperty;

/**
 * @public
 */
export declare const isJsonString: (node: unknown) => node is JsonString;

/**
 * @public
 */
export declare const isJsonStringContent: (node: unknown) => node is JsonStringContent;

/**
 * @public
 */
export declare const isJsonTrue: (node: unknown) => node is JsonTrue;

/**
 * @public
 */
export declare const isLiteral: (node: unknown) => node is Literal;

/**
 * @public
 */
export declare const isNode: (node: any) => boolean;

/**
 * @public
 */
export declare const isParseResult: (node: unknown) => node is ParseResult;

/**
 * @public
 */
export declare const isPoint: (node: unknown) => node is Point;

/**
 * @public
 */
export declare const isPosition: (node: unknown) => node is Position;

/**
 * @public
 */
export declare const isYamlAlias: (node: unknown) => node is YamlAlias;

/**
 * @public
 */
export declare const isYamlAnchor: (node: unknown) => node is YamlAnchor;

/**
 * @public
 */
export declare const isYamlComment: (node: unknown) => node is YamlComment;

/**
 * @public
 */
export declare const isYamlDirective: (node: unknown) => node is YamlDirective;

/**
 * @public
 */
export declare const isYamlDocument: (node: unknown) => node is YamlDocument;

/**
 * @public
 */
export declare const isYamlKeyValuePair: (node: unknown) => node is YamlKeyValuePair;

/**
 * @public
 */
export declare const isYamlMapping: (node: unknown) => node is YamlMapping;

/**
 * @public
 */
export declare const isYamlScalar: (node: unknown) => node is YamlScalar;

/**
 * @public
 */
export declare const isYamlSequence: (node: unknown) => node is YamlSequence;

/**
 * @public
 */
export declare const isYamlStream: (node: unknown) => node is YamlStream;

/**
 * @public
 */
export declare const isYamlTag: (node: unknown) => node is YamlTag;

/**
 * @public
 */
export declare class JsonArray extends JsonNode {
    static readonly type = "array";
    get items(): unknown[];
}

/**
 * @public
 */
export declare class JsonDocument extends JsonNode {
    static readonly type = "document";
    get child(): unknown;
}

/**
 * @public
 */
export declare class JsonEscapeSequence extends JsonValue {
    static readonly type = "escapeSequence";
}

/**
 * @public
 */
export declare class JsonFalse extends JsonValue {
    static readonly type = "false";
}

/**
 * @public
 */
export declare class JsonKey extends JsonString {
    static readonly type = "key";
}

/**
 * @public
 */
export declare class JsonNode extends Node_2 {
}

/**
 * @public
 */
export declare class JsonNull extends JsonValue {
    static readonly type = "null";
}

/**
 * @public
 */
export declare class JsonNumber extends JsonValue {
    static readonly type = "number";
}

/**
 * @public
 */
export declare class JsonObject extends JsonNode {
    static readonly type = "object";
    get properties(): Array<JsonProperty>;
}

/**
 * @public
 */
export declare class JsonProperty extends JsonNode {
    static readonly type = "property";
    get key(): JsonKey | undefined;
    get value(): JsonPropertyValue | undefined;
}

/**
 * @public
 */
export declare type JsonPropertyValue = JsonFalse | JsonTrue | JsonNull | JsonNumber | JsonString | JsonArray | JsonObject;

/**
 * @public
 */
export declare class JsonString extends JsonNode {
    static readonly type: string;
    get value(): string;
}

/**
 * @public
 */
export declare class JsonStringContent extends JsonValue {
    static readonly type = "stringContent";
}

/**
 * @public
 */
export declare class JsonTrue extends JsonValue {
    static readonly type = "true";
}

/**
 * @public
 */
export declare class JsonValue extends JsonNode {
    static readonly type: string;
    readonly value: string;
    constructor({ value, ...rest }: JsonValueOptions);
}

/**
 * @public
 */
export declare interface JsonValueOptions extends NodeOptions {
    value: string;
}

/**
 * @public
 */
export declare class Literal extends Node_2 {
    static readonly type: string;
    readonly value: unknown;
    constructor({ value, ...rest }?: LiteralOptions);
}

/**
 * @public
 */
export declare interface LiteralOptions extends NodeOptions {
    readonly value?: unknown;
}

/**
 * @public
 */
export declare interface MergeAllAsync {
    (visitors: any[], options?: {
        visitFnGetter?: typeof getVisitFn;
        nodeTypeGetter?: typeof getNodeType;
        breakSymbol?: typeof BREAK;
        deleteNodeSymbol?: any;
        skipVisitingNodeSymbol?: boolean;
        exposeEdits?: boolean;
    }): {
        enter: (node: any, ...rest: any[]) => Promise<any>;
        leave: (node: any, ...rest: any[]) => Promise<any>;
    };
}

/**
 * Creates a new visitor instance which delegates to many visitors to run in
 * parallel. Each visitor will be visited for each node before moving on.
 *
 * If a prior visitor edits a node, no following visitors will see that node.
 * `exposeEdits=true` can be used to expose the edited node from the previous visitors.
 * @public
 */
export declare interface MergeAllSync {
    (visitors: any[], options?: {
        visitFnGetter?: typeof getVisitFn;
        nodeTypeGetter?: typeof getNodeType;
        breakSymbol?: typeof BREAK;
        deleteNodeSymbol?: any;
        skipVisitingNodeSymbol?: boolean;
        exposeEdits?: boolean;
    }): {
        enter: (node: any, ...rest: any[]) => any;
        leave: (node: any, ...rest: any[]) => any;
    };
    [key: symbol]: MergeAllAsync;
}

/**
 * @public
 */
export declare const mergeAllVisitors: MergeAllSync;

/**
 * @public
 */
declare class Node_2 {
    static readonly type: string;
    readonly type: string;
    readonly isMissing: boolean;
    children: unknown[];
    position?: Position;
    constructor({ children, position, isMissing }?: NodeOptions);
    clone(): Node_2;
}
export { Node_2 as Node }

/**
 * @public
 */
export declare interface NodeOptions {
    readonly children?: unknown[];
    readonly position?: Position;
    readonly isMissing?: boolean;
}

/**
 * @public
 */
export declare class ParseResult extends Node_2 {
    static readonly type: string;
    get rootNode(): unknown;
}

/**
 * @public
 */
export declare class Point {
    static readonly type: string;
    readonly type: string;
    readonly row: number;
    readonly column: number;
    readonly char: number;
    constructor({ row, column, char }: PointOptions);
}

/**
 * @public
 */
export declare interface PointOptions {
    readonly row: number;
    readonly column: number;
    readonly char: number;
}

/**
 * @public
 */
export declare class Position {
    static readonly type: string;
    readonly type: string;
    readonly start: Point;
    readonly end: Point;
    constructor({ start, end }: PositionOptions_2);
}

/**
 * @public
 */
declare interface PositionOptions_2 {
    readonly start: Point;
    readonly end: Point;
}
export { PositionOptions_2 as PositionOptions }

/**
 * visit() will walk through an AST using a preorder depth first traversal, calling
 * the visitor's enter function at each node in the traversal, and calling the
 * leave function after visiting that node and all of its child nodes.
 *
 * By returning different values from the enter and leave functions, the
 * behavior of the visitor can be altered, including skipping over a sub-tree of
 * the AST (by returning false), editing the AST by returning a value or null
 * to remove the value, or to stop the whole traversal by returning BREAK.
 *
 * When using visit() to edit an AST, the original AST will not be modified, and
 * a new version of the AST with the changes applied will be returned from the
 * visit function.
 *
 * @example
 * ```
 *     const editedAST = visit(ast, {
 *       enter(node, key, parent, path, ancestors) {
 *         // return
 *         //   undefined: no action
 *         //   false: skip visiting this node
 *         //   BREAK: stop visiting altogether
 *         //   null: delete this node
 *         //   any value: replace this node with the returned value
 *       },
 *       leave(node, key, parent, path, ancestors) {
 *         // return
 *         //   undefined: no action
 *         //   false: no action
 *         //   BREAK: stop visiting altogether
 *         //   null: delete this node
 *         //   any value: replace this node with the returned value
 *       }
 *     });
 *```
 * Alternatively to providing enter() and leave() functions, a visitor can
 * instead provide functions named the same as the kinds of AST nodes, or
 * enter/leave visitors at a named key, leading to four permutations of
 * visitor API:
 *
 * 1) Named visitors triggered when entering a node a specific kind.
 * ```
 *     visit(ast, {
 *       Kind(node) {
 *         // enter the "Kind" node
 *       }
 *     })
 * ```
 * 2) Named visitors that trigger upon entering and leaving a node of
 *    a specific kind.
 * ```
 *     visit(ast, {
 *       Kind: {
 *         enter(node) {
 *           // enter the "Kind" node
 *         }
 *         leave(node) {
 *           // leave the "Kind" node
 *         }
 *       }
 *     })
 * ```
 * 3) Generic visitors that trigger upon entering and leaving any node.
 * ```
 *     visit(ast, {
 *       enter(node) {
 *         // enter any node
 *       },
 *       leave(node) {
 *         // leave any node
 *       }
 *     })
 * ```
 * 4) Parallel visitors for entering and leaving nodes of a specific kind.
 * ```
 *     visit(ast, {
 *       enter: {
 *         Kind(node) {
 *           // enter the "Kind" node
 *         }
 *       },
 *       leave: {
 *         Kind(node) {
 *           // leave the "Kind" node
 *         }
 *       }
 *     })
 * ```
 *  sig `visit :: (Node, Visitor, Options)`
 *
 *  sig `Options = { keyMap: Object, state: Object }`
 *
 *  @public
 */
export declare const visit: (root: any, visitor: any, { keyMap, state, breakSymbol, deleteNodeSymbol, skipVisitingNodeSymbol, visitFnGetter, nodeTypeGetter, nodePredicate, nodeCloneFn, detectCycles, detectCyclesCallback, }?: {
    keyMap?: null | undefined;
    state?: {} | undefined;
    breakSymbol?: {} | undefined;
    deleteNodeSymbol?: null | undefined;
    skipVisitingNodeSymbol?: boolean | undefined;
    visitFnGetter?: ((visitor: any, type: string | undefined, isLeaving: boolean) => ((...args: any[]) => any) | null) | undefined;
    nodeTypeGetter?: ((node: any) => string | undefined) | undefined;
    nodePredicate?: ((node: any) => boolean) | undefined;
    nodeCloneFn?: ((node: any) => any) | undefined;
    detectCycles?: boolean | undefined;
    detectCyclesCallback?: null | undefined;
}) => any;

/**
 * @public
 */
export declare class YamlAlias extends Node_2 {
    static readonly type = "alias";
    readonly content: string;
    constructor({ content, ...rest }: YamlAliasOptions);
}

/**
 * @public
 */
export declare interface YamlAliasOptions extends NodeOptions {
    readonly content: string;
}

/**
 * @public
 */
export declare class YamlAnchor extends Node_2 {
    static readonly type = "anchor";
    readonly name: string;
    constructor({ name, ...rest }: YamlAnchorOptions);
}

/**
 * @public
 */
export declare interface YamlAnchorOptions extends NodeOptions {
    readonly name: string;
}

/**
 * @public
 */
export declare class YamlCollection extends YamlNode {
}

/**
 * @public
 */
export declare class YamlComment extends Node_2 {
    static readonly type = "comment";
    readonly content: string;
    constructor({ content, ...rest }: YamlCommentOptions);
}

/**
 * @public
 */
export declare interface YamlCommentOptions extends NodeOptions {
    readonly content: string;
}

/**
 * @public
 */
export declare class YamlDirective extends Node_2 {
    static readonly type = "directive";
    readonly name?: string;
    readonly parameters: YamlDirectiveParameters;
    constructor({ name, parameters, ...rest }: YamlDirectiveOptions);
}

/**
 * @public
 */
export declare interface YamlDirectiveOptions extends NodeOptions {
    readonly name?: string;
    readonly parameters: YamlDirectiveParameters;
}

/**
 * @public
 */
export declare interface YamlDirectiveParameters {
    readonly version?: string;
    readonly handle?: string;
    readonly prefix?: string;
}

/**
 * @public
 */
export declare class YamlDocument extends Node_2 {
    static readonly type = "document";
}

/**
 * @public
 */
export declare class YamlError extends ApiDOMStructuredError {
}

/**
 * @public
 */
export declare class YamlFailsafeSchema {
    tags: any[];
    tagDirectives: YamlDirective[];
    constructor();
    toSpecificTagName(node: any): string;
    registerTagDirective(tagDirective: YamlDirective): void;
    registerTag(tag: any, beginning?: boolean): this;
    overrideTag(tag: any): this;
    resolve(node: any): any;
}

/**
 * @public
 */
export declare class YamlJsonSchema extends YamlFailsafeSchema {
    constructor();
    toSpecificTagName(node: any): any;
}

/**
 * @public
 */
export declare class YamlKeyValuePair extends Node_2 {
    static readonly type = "keyValuePair";
    readonly styleGroup: YamlStyleGroup;
    constructor({ styleGroup, ...rest }: YamlKeyValuePairOptions);
}

/**
 * @public
 */
export declare interface YamlKeyValuePairOptions extends NodeOptions {
    readonly styleGroup: YamlStyleGroup;
}

/**
 * @public
 */
export declare class YamlMapping extends YamlCollection {
    static readonly type = "mapping";
}

/**
 * @public
 */
export declare class YamlNode extends Node_2 {
    readonly anchor?: YamlAnchor;
    readonly tag?: YamlTag;
    readonly style: YamlStyle;
    readonly styleGroup: YamlStyleGroup;
    constructor({ anchor, tag, style, styleGroup, ...rest }: YamlNodeOptions);
}

/**
 * @public
 */
export declare enum YamlNodeKind {
    Scalar = "Scalar",
    Sequence = "Sequence",
    Mapping = "Mapping"
}

/**
 * @public
 */
export declare interface YamlNodeOptions extends NodeOptions {
    readonly anchor?: YamlAnchor;
    readonly tag?: YamlTag;
    readonly style: YamlStyle;
    readonly styleGroup: YamlStyleGroup;
}

/**
 * @public
 */
export declare class YamlReferenceError extends YamlError {
}

/**
 * @public
 */
export declare class YamlReferenceManager {
    addAnchor(node: YamlNode): void;
    resolveAlias(alias: YamlAlias): YamlScalar;
}

/**
 * @public
 */
export declare class YamlScalar extends YamlNode {
    static readonly type = "scalar";
    readonly content: string;
    constructor({ content, ...rest }: YamlScalarOptions);
}

/**
 * @public
 */
export declare interface YamlScalarOptions extends YamlNodeOptions {
    readonly content: string;
}

/**
 * @public
 */
export declare class YamlSchemaError extends YamlError {
}

/**
 * @public
 */
export declare class YamlSequence extends YamlCollection {
    static readonly type = "sequence";
}

/**
 * @public
 */
export declare class YamlStream extends Node_2 {
    static readonly type = "stream";
}

/**
 * @public
 */
export declare enum YamlStyle {
    Plain = "Plain",
    SingleQuoted = "SingleQuoted",
    DoubleQuoted = "DoubleQuoted",
    Literal = "Literal",
    Folded = "Folded",
    Explicit = "Explicit",
    SinglePair = "SinglePair",
    NextLine = "NextLine",
    InLine = "InLine"
}

/**
 * @public
 */
export declare enum YamlStyleGroup {
    Flow = "Flow",
    Block = "Block"
}

/**
 * @public
 */
export declare class YamlTag extends Node_2 {
    static readonly type = "tag";
    readonly explicitName: string;
    readonly kind: YamlNodeKind;
    constructor({ explicitName, kind, ...rest }: YamlTagOptions);
}

/**
 * @public
 */
export declare class YamlTagError extends YamlSchemaError {
    readonly specificTagName: string;
    readonly explicitTagName: string;
    readonly tagKind: string;
    readonly tagPosition?: Position;
    readonly nodeCanonicalContent?: string;
    readonly node?: unknown;
    constructor(message?: string, structuredOptions?: YamlTagErrorOptions);
}

/**
 * @public
 */
export declare interface YamlTagErrorOptions<T extends Node_2 = Node_2> extends ApiDOMErrorOptions {
    readonly specificTagName: string;
    readonly explicitTagName: string;
    readonly tagKind: string;
    readonly tagPosition?: Position;
    readonly nodeCanonicalContent?: string;
    readonly node?: T;
}

/**
 * @public
 */
export declare interface YamlTagOptions extends NodeOptions {
    readonly explicitName: string;
    readonly kind: YamlNodeKind;
}

export { }
