"use strict";

exports.__esModule = true;
exports.default = void 0;
var _ramdaAdjunct = require("ramda-adjunct");
var _ramda = require("ramda");
class ApiDOMAggregateError extends AggregateError {
  // eslint-disable-next-line @typescript-eslint/no-explicit-any
  constructor(errors, message, options) {
    super(errors, message, options);
    this.name = this.constructor.name;
    if (typeof message === 'string') {
      this.message = message;
    }
    if (typeof Error.captureStackTrace === 'function') {
      Error.captureStackTrace(this, this.constructor);
    } else {
      this.stack = new Error(message).stack;
    }

    /**
     * This needs to stay here until our minimum supported version of Node.js is >= 16.9.0.
     * Node.js is >= 16.9.0 supports error causes natively.
     */
    if ((0, _ramdaAdjunct.isPlainObject)(options) && (0, _ramda.hasIn)('cause', options) && !(0, _ramda.hasIn)('cause', this)) {
      const {
        cause
      } = options;
      this.cause = cause;
      if (cause instanceof Error && (0, _ramda.hasIn)('stack', cause)) {
        this.stack = `${this.stack}\nCAUSE: ${cause === null || cause === void 0 ? void 0 : cause.stack}`;
      }
    }
  }
}
var _default = ApiDOMAggregateError;
exports.default = _default;