import { hasIn } from 'ramda';
import { isPlainObject } from 'ramda-adjunct';
import ApiDOMAggregateError from "./ApiDOMAggregateError.js";
class ApiDOMError extends Error {
  static [Symbol.hasInstance](instance) {
    // we want to ApiDOMAggregateError to act as if ApiDOMError was its superclass
    return Function.prototype[Symbol.hasInstance].call(ApiDOMError, instance) || Function.prototype[Symbol.hasInstance].call(ApiDOMAggregateError, instance);
  }
  constructor(message, options) {
    super(message, options);
    this.name = this.constructor.name;
    if (typeof message === 'string') {
      this.message = message;
    }
    if (typeof Error.captureStackTrace === 'function') {
      Error.captureStackTrace(this, this.constructor);
    } else {
      this.stack = new Error(message).stack;
    }

    /**
     * This needs to stay here until our minimum supported version of Node.js is >= 16.9.0.
     * Node.js is >= 16.9.0 supports error causes natively.
     */
    if (isPlainObject(options) && hasIn('cause', options) && !hasIn('cause', this)) {
      const {
        cause
      } = options;
      this.cause = cause;
      if (cause instanceof Error && hasIn('stack', cause)) {
        this.stack = `${this.stack}\nCAUSE: ${cause === null || cause === void 0 ? void 0 : cause.stack}`;
      }
    }
  }
}
export default ApiDOMError;