"use strict";

var _interopRequireDefault = require("@babel/runtime-corejs3/helpers/interopRequireDefault").default;
exports.__esModule = true;
exports.default = void 0;
var _ramda = require("ramda");
var _ramdaAdjunct = require("ramda-adjunct");
var _ApiDOMAggregateError = _interopRequireDefault(require("./ApiDOMAggregateError.cjs"));
class ApiDOMError extends Error {
  static [Symbol.hasInstance](instance) {
    // we want to ApiDOMAggregateError to act as if ApiDOMError was its superclass
    return Function.prototype[Symbol.hasInstance].call(ApiDOMError, instance) || Function.prototype[Symbol.hasInstance].call(_ApiDOMAggregateError.default, instance);
  }
  constructor(message, options) {
    super(message, options);
    this.name = this.constructor.name;
    if (typeof message === 'string') {
      this.message = message;
    }
    if (typeof Error.captureStackTrace === 'function') {
      Error.captureStackTrace(this, this.constructor);
    } else {
      this.stack = new Error(message).stack;
    }

    /**
     * This needs to stay here until our minimum supported version of Node.js is >= 16.9.0.
     * Node.js is >= 16.9.0 supports error causes natively.
     */
    if ((0, _ramdaAdjunct.isPlainObject)(options) && (0, _ramda.hasIn)('cause', options) && !(0, _ramda.hasIn)('cause', this)) {
      const {
        cause
      } = options;
      this.cause = cause;
      if (cause instanceof Error && (0, _ramda.hasIn)('stack', cause)) {
        this.stack = `${this.stack}\nCAUSE: ${cause == null ? void 0 : cause.stack}`;
      }
    }
  }
}
var _default = ApiDOMError;
exports.default = _default;