"use strict";

exports.__esModule = true;
exports.default = void 0;
class InvalidJsonPointerError extends Error {
  constructor(pointer) {
    super(`Invalid $ref pointer "${pointer}". Pointers must begin with "/"`);
    this.name = this.constructor.name;
    this.message = `Invalid $ref pointer "${pointer}". Pointers must begin with "/"`;
    if (typeof Error.captureStackTrace === 'function') {
      Error.captureStackTrace(this, this.constructor);
    } else {
      this.stack = new Error(`Invalid $ref pointer "${pointer}". Pointers must begin with "/"`).stack;
    }
  }
}
exports.default = InvalidJsonPointerError;