import { Element } from '@swagger-api/apidom-core';

declare class EvaluationJsonPointerError extends Error {
}

declare class InvalidJsonPointerError extends Error {
    constructor(pointer: string);
}

declare const escape: (str: string) => string;
declare const unescape: (str: string) => string;
declare const parse: (pointer: string) => string[];
declare const compile: (tokens: string[]) => string;
declare const evaluate: <T extends Element>(pointer: string, element: T) => Element;
declare const uriToPointer: (uri: string) => string;

export { EvaluationJsonPointerError, InvalidJsonPointerError, compile, escape, evaluate, parse, unescape, uriToPointer };
