"use strict";

var _interopRequireDefault = require("@babel/runtime-corejs3/helpers/interopRequireDefault").default;
exports.__esModule = true;
exports.default = void 0;
var _apidomCore = require("@swagger-api/apidom-core");
var _JsonPointerError = _interopRequireDefault(require("./JsonPointerError.cjs"));
class EvaluationJsonPointerError extends _JsonPointerError.default {
  constructor(message, structuredOptions) {
    super(message, structuredOptions);
    if (typeof structuredOptions !== 'undefined') {
      this.pointer = structuredOptions.pointer;
      if (Array.isArray(structuredOptions.tokens)) {
        this.tokens = [...structuredOptions.tokens];
      }
      this.failedToken = structuredOptions.failedToken;
      this.failedTokenPosition = structuredOptions.failedTokenPosition;
      this.element = structuredOptions.element.element;
      if ((0, _apidomCore.hasElementSourceMap)(structuredOptions.element)) {
        this.elementSourceMap = (0, _apidomCore.toValue)(structuredOptions.element.getMetaProperty('sourceMap'));
      }
    }
  }
}
var _default = EvaluationJsonPointerError;
exports.default = _default;