"use strict";

var _interopRequireDefault = require("@babel/runtime-corejs3/helpers/interopRequireDefault");
exports.__esModule = true;
exports.default = void 0;
var _stampit = _interopRequireDefault(require("stampit"));
var _apidomCore = require("@swagger-api/apidom-core");
var _FallbackVisitor = _interopRequireDefault(require("../FallbackVisitor.cjs"));
var _SpecificationVisitor = _interopRequireDefault(require("../SpecificationVisitor.cjs"));
var _predicates = require("../../predicates.cjs");
var _predicates2 = require("../../../predicates.cjs");
const ParametersVisitor = (0, _stampit.default)(_SpecificationVisitor.default, _FallbackVisitor.default, {
  init() {
    this.element = new _apidomCore.ArrayElement();
    this.element.classes.push('parameters');
  },
  methods: {
    ArrayElement(arrayElement) {
      arrayElement.forEach(item => {
        const specPath = (0, _predicates.isReferenceLikeElement)(item) ? ['document', 'objects', 'Reference'] : ['document', 'objects', 'Parameter'];
        const element = this.toRefractedElement(specPath, item);
        if ((0, _predicates2.isReferenceElement)(element)) {
          element.setMetaProperty('referenced-element', 'parameter');
        }
        this.element.push(element);
      });
      this.copyMetaAndAttributes(arrayElement, this.element);
      return _apidomCore.BREAK;
    }
  }
});
var _default = ParametersVisitor;
exports.default = _default;