"use strict";

var _interopRequireDefault = require("@babel/runtime-corejs3/helpers/interopRequireDefault");
exports.__esModule = true;
exports.default = void 0;
var _stampit = _interopRequireDefault(require("stampit"));
var _ramda = require("ramda");
var _Callback = _interopRequireDefault(require("../../../../elements/Callback.cjs"));
var _PatternedFieldsVisitor = _interopRequireDefault(require("../../generics/PatternedFieldsVisitor.cjs"));
var _FallbackVisitor = _interopRequireDefault(require("../../FallbackVisitor.cjs"));
var _MapVisitor = _interopRequireDefault(require("../../generics/MapVisitor.cjs"));
var _predicates = require("../../../../predicates.cjs");
const CallbackVisitor = (0, _stampit.default)(_PatternedFieldsVisitor.default, _FallbackVisitor.default, {
  props: {
    fieldPatternPredicate: (0, _ramda.test)(/{(?<expression>.*)}/),
    specPath: (0, _ramda.always)(['document', 'objects', 'PathItem']),
    canSupportSpecificationExtensions: true
  },
  init() {
    this.element = new _Callback.default();
  },
  methods: {
    ObjectElement(objectElement) {
      // @ts-ignore
      const result = _MapVisitor.default.compose.methods.ObjectElement.call(this, objectElement);

      // decorate every PathItemElement with Callback Object expression metadata
      this.element.filter(_predicates.isPathItemElement).forEach((pathItemElement, key) => {
        pathItemElement.setMetaProperty('runtime-expression', key.toValue());
      });
      return result;
    }
  }
});
var _default = CallbackVisitor;
exports.default = _default;