"use strict";

var _interopRequireDefault = require("@babel/runtime-corejs3/helpers/interopRequireDefault");
exports.__esModule = true;
exports.default = void 0;
var _stampit = _interopRequireDefault(require("stampit"));
var _ComponentsHeaders = _interopRequireDefault(require("../../../../elements/nces/ComponentsHeaders.cjs"));
var _MapVisitor = _interopRequireDefault(require("../../generics/MapVisitor.cjs"));
var _FallbackVisitor = _interopRequireDefault(require("../../FallbackVisitor.cjs"));
var _predicates = require("../../../predicates.cjs");
var _predicates2 = require("../../../../predicates.cjs");
const HeadersVisitor = (0, _stampit.default)(_MapVisitor.default, _FallbackVisitor.default, {
  props: {
    specPath: element => {
      // eslint-disable-next-line no-nested-ternary
      return (0, _predicates.isReferenceLikeElement)(element) ? ['document', 'objects', 'Reference'] : ['document', 'objects', 'Header'];
    }
  },
  init() {
    this.element = new _ComponentsHeaders.default();
  },
  methods: {
    ObjectElement(objectElement) {
      // @ts-ignore
      const result = _MapVisitor.default.compose.methods.ObjectElement.call(this, objectElement);

      // decorate every ReferenceElement with metadata about their referencing type
      this.element.filter(_predicates2.isReferenceElement).forEach(referenceElement => {
        referenceElement.setMetaProperty('referenced-element', 'header');
      });

      // decorate every HeaderElement with metadata about their name
      this.element.filter(_predicates2.isHeaderElement).forEach((value, key) => {
        value.setMetaProperty('header-name', key.toValue());
      });
      return result;
    }
  }
});
var _default = HeadersVisitor;
exports.default = _default;