"use strict";

var _interopRequireDefault = require("@babel/runtime-corejs3/helpers/interopRequireDefault");
exports.__esModule = true;
exports.default = void 0;
var _stampit = _interopRequireDefault(require("stampit"));
var _ramda = require("ramda");
var _Responses = _interopRequireDefault(require("../../../../elements/Responses.cjs"));
var _MixedFieldsVisitor = _interopRequireDefault(require("../../generics/MixedFieldsVisitor.cjs"));
var _FallbackVisitor = _interopRequireDefault(require("../../FallbackVisitor.cjs"));
var _predicates = require("../../../predicates.cjs");
var _predicates2 = require("../../../../predicates.cjs");
const ResponsesVisitor = (0, _stampit.default)(_MixedFieldsVisitor.default, _FallbackVisitor.default, {
  props: {
    specPathFixedFields: (0, _ramda.always)(['document', 'objects', 'Responses']),
    specPathPatternedFields: element => {
      return (0, _predicates.isReferenceLikeElement)(element) ? ['document', 'objects', 'Reference'] : ['document', 'objects', 'Response'];
    },
    fieldPatternPredicate: (0, _ramda.test)(new RegExp(`^(1XX|2XX|3XX|4XX|5XX|${(0, _ramda.range)(100, 600).join('|')})$`)),
    canSupportSpecificationExtensions: true
  },
  init() {
    this.element = new _Responses.default();
  },
  methods: {
    ObjectElement(objectElement) {
      // @ts-ignore
      const result = _MixedFieldsVisitor.default.compose.methods.ObjectElement.call(this, objectElement);

      // decorate every ReferenceElement with metadata about their referencing type
      this.element.filter(_predicates2.isReferenceElement).forEach(referenceElement => {
        referenceElement.setMetaProperty('referenced-element', 'response');
      });

      // decorate every ResponseElement with metadata about their status code
      this.element.filter(_predicates2.isResponseElement).forEach((value, key) => {
        const httpStatusCode = key.clone();
        if (!this.fieldPatternPredicate(httpStatusCode.toValue())) return;
        value.setMetaProperty('http-status-code', httpStatusCode);
      });
      return result;
    }
  }
});
var _default = ResponsesVisitor;
exports.default = _default;