"use strict";

var _interopRequireDefault = require("@babel/runtime-corejs3/helpers/interopRequireDefault");
exports.__esModule = true;
exports.default = void 0;
var _stampit = _interopRequireDefault(require("stampit"));
var _apidomCore = require("@swagger-api/apidom-core");
var _apidomNsJsonSchemaDraft = require("@swagger-api/apidom-ns-json-schema-draft-4");
var _predicates = require("../../../../predicates.cjs");
const {
  items: JSONSchemaItemsVisitor
} = _apidomNsJsonSchemaDraft.specificationObj.visitors.document.objects.JSONSchema.fixedFields;
const ItemsVisitor = (0, _stampit.default)(JSONSchemaItemsVisitor, {
  methods: {
    ObjectElement(objectElement) {
      // @ts-ignore
      const result = JSONSchemaItemsVisitor.compose.methods.ObjectElement.call(this, objectElement);
      if ((0, _predicates.isReferenceElement)(this.element)) {
        this.element.setMetaProperty('referenced-element', 'schema');
      }
      return result;
    },
    ArrayElement(arrayElement) {
      this.element = arrayElement.clone();
      return _apidomCore.BREAK;
    }
  }
});
var _default = ItemsVisitor;
exports.default = _default;