import { createPredicate, isBooleanElement, isStringElement } from '@swagger-api/apidom-core';
import CallbackElement from "./elements/Callback.js";
import ComponentsElement from "./elements/Components.js";
import ContactElement from "./elements/Contact.js";
import ExampleElement from "./elements/Example.js";
import ExternalDocumentationElement from "./elements/ExternalDocumentation.js";
import HeaderElement from "./elements/Header.js";
import InfoElement from "./elements/Info.js";
import LicenseElement from "./elements/License.js";
import LinkElement from "./elements/Link.js";
import OpenapiElement from "./elements/Openapi.js";
import OpenApi3_0Element from "./elements/OpenApi3-0.js";
import OperationElement from "./elements/Operation.js";
import ParameterElement from "./elements/Parameter.js";
import PathItemElement from "./elements/PathItem.js";
import PathsElement from "./elements/Paths.js";
import ReferenceElement from "./elements/Reference.js";
import RequestBodyElement from "./elements/RequestBody.js";
import ResponseElement from "./elements/Response.js";
import ResponsesElement from "./elements/Responses.js";
import SchemaElement from "./elements/Schema.js";
import SecurityRequirementElement from "./elements/SecurityRequirement.js";
import ServerElement from "./elements/Server.js";
import ServerVariableElement from "./elements/ServerVariable.js";
import MediaTypeElement from "./elements/MediaType.js";
export const isCallbackElement = createPredicate(({
  hasBasicElementProps,
  isElementType,
  primitiveEq
}) => {
  return element => element instanceof CallbackElement || hasBasicElementProps(element) && isElementType('callback', element) && primitiveEq('object', element);
});
export const isComponentsElement = createPredicate(({
  hasBasicElementProps,
  isElementType,
  primitiveEq
}) => {
  return element => element instanceof ComponentsElement || hasBasicElementProps(element) && isElementType('components', element) && primitiveEq('object', element);
});
export const isContactElement = createPredicate(({
  hasBasicElementProps,
  isElementType,
  primitiveEq
}) => {
  return element => element instanceof ContactElement || hasBasicElementProps(element) && isElementType('contact', element) && primitiveEq('object', element);
});
export const isExampleElement = createPredicate(({
  hasBasicElementProps,
  isElementType,
  primitiveEq
}) => {
  return element => element instanceof ExampleElement || hasBasicElementProps(element) && isElementType('example', element) && primitiveEq('object', element);
});
export const isExternalDocumentationElement = createPredicate(({
  hasBasicElementProps,
  isElementType,
  primitiveEq
}) => {
  return element => element instanceof ExternalDocumentationElement || hasBasicElementProps(element) && isElementType('externalDocumentation', element) && primitiveEq('object', element);
});
export const isHeaderElement = createPredicate(({
  hasBasicElementProps,
  isElementType,
  primitiveEq
}) => {
  return element => element instanceof HeaderElement || hasBasicElementProps(element) && isElementType('header', element) && primitiveEq('object', element);
});
export const isInfoElement = createPredicate(({
  hasBasicElementProps,
  isElementType,
  primitiveEq
}) => {
  return element => element instanceof InfoElement || hasBasicElementProps(element) && isElementType('info', element) && primitiveEq('object', element);
});
export const isLicenseElement = createPredicate(({
  hasBasicElementProps,
  isElementType,
  primitiveEq
}) => {
  return element => element instanceof LicenseElement || hasBasicElementProps(element) && isElementType('license', element) && primitiveEq('object', element);
});
export const isLinkElement = createPredicate(({
  hasBasicElementProps,
  isElementType,
  primitiveEq
}) => {
  return element => element instanceof LinkElement || hasBasicElementProps(element) && isElementType('link', element) && primitiveEq('object', element);
});
export const isLinkElementExternal = element => {
  if (!isLinkElement(element)) {
    return false;
  }
  if (!isStringElement(element.operationRef)) {
    return false;
  }
  const value = element.operationRef.toValue();
  return typeof value === 'string' && value.length > 0 && !value.startsWith('#');
};
export const isOpenapiElement = createPredicate(({
  hasBasicElementProps,
  isElementType,
  primitiveEq
}) => {
  return element => element instanceof OpenapiElement || hasBasicElementProps(element) && isElementType('openapi', element) && primitiveEq('string', element);
});

// eslint-disable-next-line @typescript-eslint/naming-convention
export const isOpenApi3_0Element = createPredicate(({
  hasBasicElementProps,
  isElementType,
  primitiveEq,
  hasClass
}) => {
  return element => element instanceof OpenApi3_0Element || hasBasicElementProps(element) && isElementType('openApi3_0', element) && primitiveEq('object', element) && hasClass('api', element);
});
export const isOperationElement = createPredicate(({
  hasBasicElementProps,
  isElementType,
  primitiveEq
}) => {
  return element => element instanceof OperationElement || hasBasicElementProps(element) && isElementType('operation', element) && primitiveEq('object', element);
});
export const isParameterElement = createPredicate(({
  hasBasicElementProps,
  isElementType,
  primitiveEq
}) => {
  return element => element instanceof ParameterElement || hasBasicElementProps(element) && isElementType('parameter', element) && primitiveEq('object', element);
});
export const isPathItemElement = createPredicate(({
  hasBasicElementProps,
  isElementType,
  primitiveEq
}) => {
  return element => element instanceof PathItemElement || hasBasicElementProps(element) && isElementType('pathItem', element) && primitiveEq('object', element);
});
export const isPathItemElementExternal = element => {
  if (!isPathItemElement(element)) {
    return false;
  }
  if (!isStringElement(element.$ref)) {
    return false;
  }
  const value = element.$ref.toValue();
  return typeof value === 'string' && value.length > 0 && !value.startsWith('#');
};
export const isPathsElement = createPredicate(({
  hasBasicElementProps,
  isElementType,
  primitiveEq
}) => {
  return element => element instanceof PathsElement || hasBasicElementProps(element) && isElementType('paths', element) && primitiveEq('object', element);
});
export const isReferenceElement = createPredicate(({
  hasBasicElementProps,
  isElementType,
  primitiveEq
}) => {
  return element => element instanceof ReferenceElement || hasBasicElementProps(element) && isElementType('reference', element) && primitiveEq('object', element);
});
export const isReferenceElementExternal = element => {
  if (!isReferenceElement(element)) {
    return false;
  }
  if (!isStringElement(element.$ref)) {
    return false;
  }
  const value = element.$ref.toValue();
  return typeof value === 'string' && value.length > 0 && !value.startsWith('#');
};
export const isRequestBodyElement = createPredicate(({
  hasBasicElementProps,
  isElementType,
  primitiveEq
}) => {
  return element => element instanceof RequestBodyElement || hasBasicElementProps(element) && isElementType('requestBody', element) && primitiveEq('object', element);
});
export const isResponseElement = createPredicate(({
  hasBasicElementProps,
  isElementType,
  primitiveEq
}) => {
  return element => element instanceof ResponseElement || hasBasicElementProps(element) && isElementType('response', element) && primitiveEq('object', element);
});
export const isResponsesElement = createPredicate(({
  hasBasicElementProps,
  isElementType,
  primitiveEq
}) => {
  return element => element instanceof ResponsesElement || hasBasicElementProps(element) && isElementType('responses', element) && primitiveEq('object', element);
});
export const isSchemaElement = createPredicate(({
  hasBasicElementProps,
  isElementType,
  primitiveEq
}) => {
  return element => element instanceof SchemaElement || hasBasicElementProps(element) && isElementType('schema', element) && primitiveEq('object', element);
});
export const isBooleanJsonSchemaElement = element => {
  return isBooleanElement(element) && element.classes.includes('boolean-json-schema');
};
export const isSecurityRequirementElement = createPredicate(({
  hasBasicElementProps,
  isElementType,
  primitiveEq
}) => {
  return element => element instanceof SecurityRequirementElement || hasBasicElementProps(element) && isElementType('securityRequirement', element) && primitiveEq('object', element);
});
export const isServerElement = createPredicate(({
  hasBasicElementProps,
  isElementType,
  primitiveEq
}) => {
  return element => element instanceof ServerElement || hasBasicElementProps(element) && isElementType('server', element) && primitiveEq('object', element);
});
export const isServerVariableElement = createPredicate(({
  hasBasicElementProps,
  isElementType,
  primitiveEq
}) => {
  return element => element instanceof ServerVariableElement || hasBasicElementProps(element) && isElementType('serverVariable', element) && primitiveEq('object', element);
});
export const isMediaTypeElement = createPredicate(({
  hasBasicElementProps,
  isElementType,
  primitiveEq
}) => {
  return element => element instanceof MediaTypeElement || hasBasicElementProps(element) && isElementType('mediaType', element) && primitiveEq('object', element);
});