import _defineProperty from "@babel/runtime-corejs3/helpers/esm/defineProperty";
function ownKeys(object, enumerableOnly) { var keys = Object.keys(object); if (Object.getOwnPropertySymbols) { var symbols = Object.getOwnPropertySymbols(object); enumerableOnly && (symbols = symbols.filter(function (sym) { return Object.getOwnPropertyDescriptor(object, sym).enumerable; })), keys.push.apply(keys, symbols); } return keys; }
function _objectSpread(target) { for (var i = 1; i < arguments.length; i++) { var source = null != arguments[i] ? arguments[i] : {}; i % 2 ? ownKeys(Object(source), !0).forEach(function (key) { _defineProperty(target, key, source[key]); }) : Object.getOwnPropertyDescriptors ? Object.defineProperties(target, Object.getOwnPropertyDescriptors(source)) : ownKeys(Object(source)).forEach(function (key) { Object.defineProperty(target, key, Object.getOwnPropertyDescriptor(source, key)); }); } return target; }
import { specificationObj as JSONSchemaDraft4Specification } from '@swagger-api/apidom-ns-json-schema-draft-4';
import OpenApi3_0Visitor from "./visitors/open-api-3-0/index.js";
import OpenapiVisitor from "./visitors/open-api-3-0/OpenapiVisitor.js";
import SpecificationExtensionVisitor from "./visitors/SpecificationExtensionVisitor.js";
import InfoVisitor from "./visitors/open-api-3-0/info/index.js";
import InfoTitleVisitor from "./visitors/open-api-3-0/info/TitleVisitor.js";
import InfoDescriptionVisitor from "./visitors/open-api-3-0/info/DescriptionVisitor.js";
import InfoTermsOfServiceVisitor from "./visitors/open-api-3-0/info/TermsOfServiceVisitor.js";
import InfoVersionVisitor from "./visitors/open-api-3-0/info/VersionVisitor.js";
import ContactVisitor from "./visitors/open-api-3-0/contact/index.js";
import ContactNameVisitor from "./visitors/open-api-3-0/contact/NameVisitor.js";
import ContactUrlVisitor from "./visitors/open-api-3-0/contact/UrlVisitor.js";
import ContactEmailVisitor from "./visitors/open-api-3-0/contact/EmailVisitor.js";
import LicenseVisitor from "./visitors/open-api-3-0/license/index.js";
import LicenseNameVisitor from "./visitors/open-api-3-0/license/NameVisitor.js";
import LicenseUrlVisitor from "./visitors/open-api-3-0/license/UrlVisitor.js";
import LinkVisitor from "./visitors/open-api-3-0/link/index.js";
import LinkOperationRefVisitor from "./visitors/open-api-3-0/link/OperationRefVisitor.js";
import LinkOperationIdVisitor from "./visitors/open-api-3-0/link/OperationIdVisitor.js";
import LinkParametersVisitor from "./visitors/open-api-3-0/link/ParametersVisitor.js";
import LinkRequestBodyVisitor from "./visitors/open-api-3-0/link/RequestBodyVisitor.js";
import LinkDescriptionVisitor from "./visitors/open-api-3-0/link/DescriptionVisitor.js";
import ServerVisitor from "./visitors/open-api-3-0/server/index.js";
import ServerUrlVisitor from "./visitors/open-api-3-0/server/UrlVisitor.js";
import ServerDescriptionVisitor from "./visitors/open-api-3-0/server/DescriptionVisitor.js";
import ServersVisitor from "./visitors/open-api-3-0/ServersVisitor.js";
import ServerVariableVisitor from "./visitors/open-api-3-0/server-variable/index.js";
import ServerVariableEnumVisitor from "./visitors/open-api-3-0/server-variable/EnumVisitor.js";
import ServerVariableDefaultVisitor from "./visitors/open-api-3-0/server-variable/DefaultVisitor.js";
import ServerVariableDescriptionVisitor from "./visitors/open-api-3-0/server-variable/DescriptionVisitor.js";
import ServerVariablesVisitor from "./visitors/open-api-3-0/server/VariablesVisitor.js";
import FallbackVisitor from "./visitors/FallbackVisitor.js";
import MediaTypeVisitor from "./visitors/open-api-3-0/media-type/index.js";
import MediaTypeSchemaVisitor from "./visitors/open-api-3-0/media-type/SchemaVisitor.js";
import MediaTypeExampleVisitor from "./visitors/open-api-3-0/media-type/ExampleVisitor.js";
import MediaTypeExamplesVisitor from "./visitors/open-api-3-0/media-type/ExamplesVisitor.js";
import MediaTypeEncodingVisitor from "./visitors/open-api-3-0/media-type/EncodingVisitor.js";
import SecurityRequirementVisitor from "./visitors/open-api-3-0/security-requirement/index.js";
import SecurityVisitor from "./visitors/open-api-3-0/SecurityVisitor.js";
import ComponentsVisitor from "./visitors/open-api-3-0/components/index.js";
import TagVisitor from "./visitors/open-api-3-0/tag/index.js";
import TagNameVisitor from "./visitors/open-api-3-0/tag/NameVisitor.js";
import TagDescriptionVisitor from "./visitors/open-api-3-0/tag/DescriptionVisitor.js";
import ReferenceVisitor from "./visitors/open-api-3-0/reference/index.js";
import Reference$RefVisitor from "./visitors/open-api-3-0/reference/$RefVisitor.js";
import ParameterVisitor from "./visitors/open-api-3-0/parameter/index.js";
import ParameterNameVisitor from "./visitors/open-api-3-0/parameter/NameVisitor.js";
import ParameterInVisitor from "./visitors/open-api-3-0/parameter/InVisitor.js";
import ParameterDescriptionVisitor from "./visitors/open-api-3-0/parameter/DescriptionVisitor.js";
import ParameterRequiredVisitor from "./visitors/open-api-3-0/parameter/RequiredVisitor.js";
import ParameterDeprecatedVisitor from "./visitors/open-api-3-0/parameter/DeprecatedVisitor.js";
import ParameterAllowEmptyValueVisitor from "./visitors/open-api-3-0/parameter/AllowEmptyValueVisitor.js";
import ParameterStyleVisitor from "./visitors/open-api-3-0/parameter/StyleVisitor.js";
import ParameterExplodeVisitor from "./visitors/open-api-3-0/parameter/ExplodeVisitor.js";
import ParameterAllowReservedVisitor from "./visitors/open-api-3-0/parameter/AllowReservedVisitor.js";
import ParameterSchemaVisitor from "./visitors/open-api-3-0/parameter/SchemaVisitor.js";
import HeaderVisitor from "./visitors/open-api-3-0/header/index.js";
import HeaderDescriptionVisitor from "./visitors/open-api-3-0/header/DescriptionVisitor.js";
import HeaderRequiredVisitor from "./visitors/open-api-3-0/header/RequiredVisitor.js";
import HeaderDeprecatedVisitor from "./visitors/open-api-3-0/header/DeprecatedVisitor.js";
import HeaderAllowEmptyValueVisitor from "./visitors/open-api-3-0/header/AllowEmptyValueVisitor.js";
import HeaderStyleVisitor from "./visitors/open-api-3-0/header/StyleVisitor.js";
import HeaderExplodeVisitor from "./visitors/open-api-3-0/header/ExplodeVisitor.js";
import HeaderAllowReservedVisitor from "./visitors/open-api-3-0/header/AllowReservedVisitor.js";
import HeaderSchemaVisitor from "./visitors/open-api-3-0/header/SchemaVisitor.js";
import HeaderExampleVisitor from "./visitors/open-api-3-0/header/ExampleVisitor.js";
import HeaderExamplesVisitor from "./visitors/open-api-3-0/header/ExamplesVisitor.js";
import HeaderContentVisitor from "./visitors/open-api-3-0/header/ContentVisitor.js";
import SchemaVisitor from "./visitors/open-api-3-0/schema/index.js";
import SchemaItemsVisitor from "./visitors/open-api-3-0/schema/ItemsVisitor.js";
import SchemaPropertiesVisitor from "./visitors/open-api-3-0/schema/PropertiesVisitor.js";
import SchemaTypeVisitor from "./visitors/open-api-3-0/schema/TypeVisitor.js";
import SchemaNullableVisitor from "./visitors/open-api-3-0/schema/NullableVisitor.js";
import SchemaWriteOnlyVisitor from "./visitors/open-api-3-0/schema/WriteOnlyVisitor.js";
import SchemaExampleVisitor from "./visitors/open-api-3-0/schema/ExampleVisitor.js";
import SchemaDeprecatedVisitor from "./visitors/open-api-3-0/schema/DeprecatedVisitor.js";
import schemaInheritedFixedFields from "./visitors/open-api-3-0/schema/inherited-fixed-fields.js";
import DiscriminatorVisitor from "./visitors/open-api-3-0/distriminator/index.js";
import DiscriminatorPropertyNameVisitor from "./visitors/open-api-3-0/distriminator/PropertyNameVisitor.js";
import DiscriminatorMappingVisitor from "./visitors/open-api-3-0/distriminator/MappingVisitor.js";
import XmlVisitor from "./visitors/open-api-3-0/xml/index.js";
import XmlNameVisitor from "./visitors/open-api-3-0/xml/NameVisitor.js";
import XmlNamespaceVisitor from "./visitors/open-api-3-0/xml/NamespaceVisitor.js";
import XmlPrefixVisitor from "./visitors/open-api-3-0/xml/PrefixVisitor.js";
import XmlAttributeVisitor from "./visitors/open-api-3-0/xml/AttributeVisitor.js";
import XmlWrappedVisitor from "./visitors/open-api-3-0/xml/WrappedVisitor.js";
import ParameterExampleVisitor from "./visitors/open-api-3-0/parameter/ExampleVisitor.js";
import ParameterExamplesVisitor from "./visitors/open-api-3-0/parameter/ExamplesVisitor.js";
import ParameterContentVisitor from "./visitors/open-api-3-0/parameter/ContentVisitor.js";
import ComponentsSchemasVisitor from "./visitors/open-api-3-0/components/SchemasVisitor.js";
import ComponentsResponsesVisitor from "./visitors/open-api-3-0/components/ResponsesVisitor.js";
import ComponentsParametersVisitor from "./visitors/open-api-3-0/components/ParametersVisitor.js";
import ComponentsExamplesVisitor from "./visitors/open-api-3-0/components/ExamplesVisitor.js";
import ComponentsRequestBodiesVisitor from "./visitors/open-api-3-0/components/RequestBodiesVisitor.js";
import ComponentsHeadersVisitor from "./visitors/open-api-3-0/components/HeadersVisitor.js";
import ComponentsSecuritySchemesVisitor from "./visitors/open-api-3-0/components/SecuritySchemesVisitor.js";
import ComponentsLinksVisitor from "./visitors/open-api-3-0/components/LinksVisitor.js";
import ComponentsCallbacksVisitor from "./visitors/open-api-3-0/components/CallbacksVisitor.js";
import ExampleVisitor from "./visitors/open-api-3-0/example/index.js";
import ExampleSummaryVisitor from "./visitors/open-api-3-0/example/SummaryVisitor.js";
import ExampleDescriptionVisitor from "./visitors/open-api-3-0/example/DescriptionVisitor.js";
import ExampleValueVisitor from "./visitors/open-api-3-0/example/ValueVisitor.js";
import ExampleExternalValueVisitor from "./visitors/open-api-3-0/example/ExternalValueVisitor.js";
import ExternalDocumentationVisitor from "./visitors/open-api-3-0/external-documentation/index.js";
import ExternalDocumentationDescriptionVisitor from "./visitors/open-api-3-0/external-documentation/DescriptionVisitor.js";
import ExternalDocumentationUrlVisitor from "./visitors/open-api-3-0/external-documentation/UrlVisitor.js";
import EncodingVisitor from "./visitors/open-api-3-0/encoding/index.js";
import EncodingContentTypeVisitor from "./visitors/open-api-3-0/encoding/ContentTypeVisitor.js";
import EncodingHeadersVisitor from "./visitors/open-api-3-0/encoding/HeadersVisitor.js";
import EncodingStyleVisitor from "./visitors/open-api-3-0/encoding/StyleVisitor.js";
import EncodingExplodeVisitor from "./visitors/open-api-3-0/encoding/ExplodeVisitor.js";
import EncodingAllowReserved from "./visitors/open-api-3-0/encoding/AllowReservedVisitor.js";
import PathsVisitor from "./visitors/open-api-3-0/paths/index.js";
import RequestBodyVisitor from "./visitors/open-api-3-0/request-body/index.js";
import RequestBodyDescriptionVisitor from "./visitors/open-api-3-0/request-body/DescriptionVisitor.js";
import RequestBodyContentVisitor from "./visitors/open-api-3-0/request-body/ContentVisitor.js";
import RequestBodyRequiredVisitor from "./visitors/open-api-3-0/request-body/RequiredVisitor.js";
import CallbackVisitor from "./visitors/open-api-3-0/callback/index.js";
import ResponseVisitor from "./visitors/open-api-3-0/response/index.js";
import ResponseDescriptionVisitor from "./visitors/open-api-3-0/response/DescriptionVisitor.js";
import ResponseHeadersVisitor from "./visitors/open-api-3-0/response/HeadersVisitor.js";
import ResponseContentVisitor from "./visitors/open-api-3-0/response/ContentVisitor.js";
import ResponseLinksVisitor from "./visitors/open-api-3-0/response/LinksVisitor.js";
import ResponsesVisitor from "./visitors/open-api-3-0/responses/index.js";
import ResponsesDefaultVisitor from "./visitors/open-api-3-0/responses/DefaultVisitor.js";
import OperationVisitor from "./visitors/open-api-3-0/operation/index.js";
import OperationTagsVisitor from "./visitors/open-api-3-0/operation/TagsVisitor.js";
import OperationSummaryVisitor from "./visitors/open-api-3-0/operation/SummaryVisitor.js";
import OperationDescriptionVisitor from "./visitors/open-api-3-0/operation/DescriptionVisitor.js";
import OperationOperationIdVisitor from "./visitors/open-api-3-0/operation/OperationIdVisitor.js";
import OperationParametersVisitor from "./visitors/open-api-3-0/operation/ParametersVisitor.js";
import OperationRequestBodyVisitor from "./visitors/open-api-3-0/operation/RequestBodyVisitor.js";
import OperationCallbacksVisitor from "./visitors/open-api-3-0/operation/CallbacksVisitor.js";
import OperationDeprecatedVisitor from "./visitors/open-api-3-0/operation/DeprecatedVisitor.js";
import OperationSecurityVisitor from "./visitors/open-api-3-0/operation/SecurityVisitor.js";
import OperationServersVisitor from "./visitors/open-api-3-0/operation/ServersVisitor.js";
import PathItemVisitor from "./visitors/open-api-3-0/path-item/index.js";
import PathItem$RefVisitor from "./visitors/open-api-3-0/path-item/$RefVisitor.js";
import PathItemSummaryVisitor from "./visitors/open-api-3-0/path-item/SummaryVisitor.js";
import PathItemDescriptionVisitor from "./visitors/open-api-3-0/path-item/DescriptionVisitor.js";
import PathItemServersVisitor from "./visitors/open-api-3-0/path-item/ServersVisitor.js";
import PathItemParametersVisitor from "./visitors/open-api-3-0/path-item/ParametersVisitor.js";
import SecuritySchemeVisitor from "./visitors/open-api-3-0/security-scheme/index.js";
import SecuritySchemeTypeVisitor from "./visitors/open-api-3-0/security-scheme/TypeVisitor.js";
import SecuritySchemeDescriptionVisitor from "./visitors/open-api-3-0/security-scheme/DescriptionVisitor.js";
import SecuritySchemeNameVisitor from "./visitors/open-api-3-0/security-scheme/NameVisitor.js";
import SecuritySchemeInVisitor from "./visitors/open-api-3-0/security-scheme/InVisitor.js";
import SecuritySchemeSchemeVisitor from "./visitors/open-api-3-0/security-scheme/SchemeVisitor.js";
import SecuritySchemeBearerFormatVisitor from "./visitors/open-api-3-0/security-scheme/BearerFormatVisitor.js";
import SecuritySchemeOpenIdConnectUrlVisitor from "./visitors/open-api-3-0/security-scheme/OpenIdConnectUrlVisitor.js";
import OAuthFlowsVisitor from "./visitors/open-api-3-0/oauth-flows/index.js";
import OAuthFlowVisitor from "./visitors/open-api-3-0/oauth-flow/index.js";
import OAuthFlowAuthorizationUrlVisitor from "./visitors/open-api-3-0/oauth-flow/AuthorizationUrlVisitor.js";
import OAuthFlowTokenUrlVisitor from "./visitors/open-api-3-0/oauth-flow/TokenUrlVisitor.js";
import OAuthFlowRefreshUrlVisitor from "./visitors/open-api-3-0/oauth-flow/RefreshUrlVisitor.js";
import OAuthFlowScopesVisitor from "./visitors/open-api-3-0/oauth-flow/ScopesVisitor.js";
import TagsVisitor from "./visitors/open-api-3-0/TagsVisitor.js";
/**
 * Specification object allows us to have complete control over visitors
 * when traversing the ApiDOM.
 * Specification also allows us to create amended refractors from
 * existing ones by manipulating it.
 *
 * Note: Specification object allows to use absolute internal JSON pointers.
 */
const ReferenceSpecification = {
  $visitor: ReferenceVisitor,
  fixedFields: {
    $ref: Reference$RefVisitor
  }
};
const SchemaSpecification = {
  $visitor: SchemaVisitor,
  fixedFields: _objectSpread(_objectSpread({}, schemaInheritedFixedFields), {}, {
    // validation vocabulary
    // validation keywords for arrays
    items: SchemaItemsVisitor,
    // Validation keywords for objects
    properties: SchemaPropertiesVisitor,
    // validation keywords for any instance type
    type: SchemaTypeVisitor,
    // OpenAPI vocabulary
    nullable: SchemaNullableVisitor,
    discriminator: {
      $ref: '#/visitors/document/objects/Discriminator'
    },
    writeOnly: SchemaWriteOnlyVisitor,
    xml: {
      $ref: '#/visitors/document/objects/XML'
    },
    externalDocs: {
      $ref: '#/visitors/document/objects/ExternalDocumentation'
    },
    example: SchemaExampleVisitor,
    deprecated: SchemaDeprecatedVisitor
  })
};
const specification = {
  visitors: {
    value: FallbackVisitor,
    document: {
      objects: {
        OpenApi: {
          $visitor: OpenApi3_0Visitor,
          fixedFields: {
            openapi: OpenapiVisitor,
            info: {
              $ref: '#/visitors/document/objects/Info'
            },
            servers: ServersVisitor,
            paths: {
              $ref: '#/visitors/document/objects/Paths'
            },
            components: {
              $ref: '#/visitors/document/objects/Components'
            },
            security: SecurityVisitor,
            tags: TagsVisitor,
            externalDocs: {
              $ref: '#/visitors/document/objects/ExternalDocumentation'
            }
          }
        },
        Info: {
          $visitor: InfoVisitor,
          fixedFields: {
            title: InfoTitleVisitor,
            description: InfoDescriptionVisitor,
            termsOfService: InfoTermsOfServiceVisitor,
            contact: {
              $ref: '#/visitors/document/objects/Contact'
            },
            license: {
              $ref: '#/visitors/document/objects/License'
            },
            version: InfoVersionVisitor
          }
        },
        Contact: {
          $visitor: ContactVisitor,
          fixedFields: {
            name: ContactNameVisitor,
            url: ContactUrlVisitor,
            email: ContactEmailVisitor
          }
        },
        License: {
          $visitor: LicenseVisitor,
          fixedFields: {
            name: LicenseNameVisitor,
            url: LicenseUrlVisitor
          }
        },
        Server: {
          $visitor: ServerVisitor,
          fixedFields: {
            url: ServerUrlVisitor,
            description: ServerDescriptionVisitor,
            variables: ServerVariablesVisitor
          }
        },
        ServerVariable: {
          $visitor: ServerVariableVisitor,
          fixedFields: {
            enum: ServerVariableEnumVisitor,
            default: ServerVariableDefaultVisitor,
            description: ServerVariableDescriptionVisitor
          }
        },
        Components: {
          $visitor: ComponentsVisitor,
          fixedFields: {
            schemas: ComponentsSchemasVisitor,
            responses: ComponentsResponsesVisitor,
            parameters: ComponentsParametersVisitor,
            examples: ComponentsExamplesVisitor,
            requestBodies: ComponentsRequestBodiesVisitor,
            headers: ComponentsHeadersVisitor,
            securitySchemes: ComponentsSecuritySchemesVisitor,
            links: ComponentsLinksVisitor,
            callbacks: ComponentsCallbacksVisitor
          }
        },
        Paths: {
          $visitor: PathsVisitor
        },
        PathItem: {
          $visitor: PathItemVisitor,
          fixedFields: {
            $ref: PathItem$RefVisitor,
            summary: PathItemSummaryVisitor,
            description: PathItemDescriptionVisitor,
            get: {
              $ref: '#/visitors/document/objects/Operation'
            },
            put: {
              $ref: '#/visitors/document/objects/Operation'
            },
            post: {
              $ref: '#/visitors/document/objects/Operation'
            },
            delete: {
              $ref: '#/visitors/document/objects/Operation'
            },
            options: {
              $ref: '#/visitors/document/objects/Operation'
            },
            head: {
              $ref: '#/visitors/document/objects/Operation'
            },
            patch: {
              $ref: '#/visitors/document/objects/Operation'
            },
            trace: {
              $ref: '#/visitors/document/objects/Operation'
            },
            servers: PathItemServersVisitor,
            parameters: PathItemParametersVisitor
          }
        },
        Operation: {
          $visitor: OperationVisitor,
          fixedFields: {
            tags: OperationTagsVisitor,
            summary: OperationSummaryVisitor,
            description: OperationDescriptionVisitor,
            externalDocs: {
              $ref: '#/visitors/document/objects/ExternalDocumentation'
            },
            operationId: OperationOperationIdVisitor,
            parameters: OperationParametersVisitor,
            requestBody: OperationRequestBodyVisitor,
            responses: {
              $ref: '#/visitors/document/objects/Responses'
            },
            callbacks: OperationCallbacksVisitor,
            deprecated: OperationDeprecatedVisitor,
            security: OperationSecurityVisitor,
            servers: OperationServersVisitor
          }
        },
        ExternalDocumentation: {
          $visitor: ExternalDocumentationVisitor,
          fixedFields: {
            description: ExternalDocumentationDescriptionVisitor,
            url: ExternalDocumentationUrlVisitor
          }
        },
        Parameter: {
          $visitor: ParameterVisitor,
          fixedFields: {
            name: ParameterNameVisitor,
            in: ParameterInVisitor,
            description: ParameterDescriptionVisitor,
            required: ParameterRequiredVisitor,
            deprecated: ParameterDeprecatedVisitor,
            allowEmptyValue: ParameterAllowEmptyValueVisitor,
            style: ParameterStyleVisitor,
            explode: ParameterExplodeVisitor,
            allowReserved: ParameterAllowReservedVisitor,
            schema: ParameterSchemaVisitor,
            example: ParameterExampleVisitor,
            examples: ParameterExamplesVisitor,
            content: ParameterContentVisitor
          }
        },
        RequestBody: {
          $visitor: RequestBodyVisitor,
          fixedFields: {
            description: RequestBodyDescriptionVisitor,
            content: RequestBodyContentVisitor,
            required: RequestBodyRequiredVisitor
          }
        },
        MediaType: {
          $visitor: MediaTypeVisitor,
          fixedFields: {
            schema: MediaTypeSchemaVisitor,
            example: MediaTypeExampleVisitor,
            examples: MediaTypeExamplesVisitor,
            encoding: MediaTypeEncodingVisitor
          }
        },
        Encoding: {
          $visitor: EncodingVisitor,
          fixedFields: {
            contentType: EncodingContentTypeVisitor,
            headers: EncodingHeadersVisitor,
            style: EncodingStyleVisitor,
            explode: EncodingExplodeVisitor,
            allowReserved: EncodingAllowReserved
          }
        },
        Responses: {
          $visitor: ResponsesVisitor,
          fixedFields: {
            default: ResponsesDefaultVisitor
          }
        },
        Response: {
          $visitor: ResponseVisitor,
          fixedFields: {
            description: ResponseDescriptionVisitor,
            headers: ResponseHeadersVisitor,
            content: ResponseContentVisitor,
            links: ResponseLinksVisitor
          }
        },
        Callback: {
          $visitor: CallbackVisitor
        },
        Example: {
          $visitor: ExampleVisitor,
          fixedFields: {
            summary: ExampleSummaryVisitor,
            description: ExampleDescriptionVisitor,
            value: ExampleValueVisitor,
            externalValue: ExampleExternalValueVisitor
          }
        },
        Link: {
          $visitor: LinkVisitor,
          fixedFields: {
            operationRef: LinkOperationRefVisitor,
            operationId: LinkOperationIdVisitor,
            parameters: LinkParametersVisitor,
            requestBody: LinkRequestBodyVisitor,
            description: LinkDescriptionVisitor,
            server: {
              $ref: '#/visitors/document/objects/Server'
            }
          }
        },
        Header: {
          $visitor: HeaderVisitor,
          fixedFields: {
            description: HeaderDescriptionVisitor,
            required: HeaderRequiredVisitor,
            deprecated: HeaderDeprecatedVisitor,
            allowEmptyValue: HeaderAllowEmptyValueVisitor,
            style: HeaderStyleVisitor,
            explode: HeaderExplodeVisitor,
            allowReserved: HeaderAllowReservedVisitor,
            schema: HeaderSchemaVisitor,
            example: HeaderExampleVisitor,
            examples: HeaderExamplesVisitor,
            content: HeaderContentVisitor
          }
        },
        Tag: {
          $visitor: TagVisitor,
          fixedFields: {
            name: TagNameVisitor,
            description: TagDescriptionVisitor,
            externalDocs: {
              $ref: '#/visitors/document/objects/ExternalDocumentation'
            }
          }
        },
        JSONReference: ReferenceSpecification,
        Reference: ReferenceSpecification,
        JSONSchema: SchemaSpecification,
        Schema: SchemaSpecification,
        LinkDescription: JSONSchemaDraft4Specification.visitors.document.objects.LinkDescription,
        Media: JSONSchemaDraft4Specification.visitors.document.objects.Media,
        Discriminator: {
          $visitor: DiscriminatorVisitor,
          fixedFields: {
            propertyName: DiscriminatorPropertyNameVisitor,
            mapping: DiscriminatorMappingVisitor
          }
        },
        XML: {
          $visitor: XmlVisitor,
          fixedFields: {
            name: XmlNameVisitor,
            namespace: XmlNamespaceVisitor,
            prefix: XmlPrefixVisitor,
            attribute: XmlAttributeVisitor,
            wrapped: XmlWrappedVisitor
          }
        },
        SecurityScheme: {
          $visitor: SecuritySchemeVisitor,
          fixedFields: {
            type: SecuritySchemeTypeVisitor,
            description: SecuritySchemeDescriptionVisitor,
            name: SecuritySchemeNameVisitor,
            in: SecuritySchemeInVisitor,
            scheme: SecuritySchemeSchemeVisitor,
            bearerFormat: SecuritySchemeBearerFormatVisitor,
            flows: {
              $ref: '#/visitors/document/objects/OAuthFlows'
            },
            openIdConnectUrl: SecuritySchemeOpenIdConnectUrlVisitor
          }
        },
        OAuthFlows: {
          $visitor: OAuthFlowsVisitor,
          fixedFields: {
            implicit: {
              $ref: '#/visitors/document/objects/OAuthFlow'
            },
            password: {
              $ref: '#/visitors/document/objects/OAuthFlow'
            },
            clientCredentials: {
              $ref: '#/visitors/document/objects/OAuthFlow'
            },
            authorizationCode: {
              $ref: '#/visitors/document/objects/OAuthFlow'
            }
          }
        },
        OAuthFlow: {
          $visitor: OAuthFlowVisitor,
          fixedFields: {
            authorizationUrl: OAuthFlowAuthorizationUrlVisitor,
            tokenUrl: OAuthFlowTokenUrlVisitor,
            refreshUrl: OAuthFlowRefreshUrlVisitor,
            scopes: OAuthFlowScopesVisitor
          }
        },
        SecurityRequirement: {
          $visitor: SecurityRequirementVisitor
        }
      },
      extension: {
        $visitor: SpecificationExtensionVisitor
      }
    }
  }
};
export default specification;