import stampit from 'stampit';
import { ObjectElement } from '@swagger-api/apidom-core';
import MapVisitor from "../generics/MapVisitor.js";
import FallbackVisitor from "../FallbackVisitor.js";
import { isReferenceLikeElement } from "../../predicates.js";
import { isReferenceElement } from "../../../predicates.js";
const ExamplesVisitor = stampit(MapVisitor, FallbackVisitor, {
  props: {
    specPath: element => isReferenceLikeElement(element) ? ['document', 'objects', 'Reference'] : ['document', 'objects', 'Example'],
    canSupportSpecificationExtensions: true
  },
  init() {
    this.element = new ObjectElement();
    this.element.classes.push('examples');
  },
  methods: {
    ObjectElement(objectElement) {
      // @ts-ignore
      const result = MapVisitor.compose.methods.ObjectElement.call(this, objectElement);
      this.element.filter(isReferenceElement).forEach(referenceElement => {
        referenceElement.setMetaProperty('referenced-element', 'example');
      });
      return result;
    }
  }
});
export default ExamplesVisitor;