import stampit from 'stampit';
import { ArrayElement, BREAK } from '@swagger-api/apidom-core';
import FallbackVisitor from "../FallbackVisitor.js";
import SpecificationVisitor from "../SpecificationVisitor.js";
import { isReferenceLikeElement } from "../../predicates.js";
import { isReferenceElement } from "../../../predicates.js";
const ParametersVisitor = stampit(SpecificationVisitor, FallbackVisitor, {
  init() {
    this.element = new ArrayElement();
    this.element.classes.push('parameters');
  },
  methods: {
    ArrayElement(arrayElement) {
      arrayElement.forEach(item => {
        const specPath = isReferenceLikeElement(item) ? ['document', 'objects', 'Reference'] : ['document', 'objects', 'Parameter'];
        const element = this.toRefractedElement(specPath, item);
        if (isReferenceElement(element)) {
          element.setMetaProperty('referenced-element', 'parameter');
        }
        this.element.push(element);
      });
      this.copyMetaAndAttributes(arrayElement, this.element);
      return BREAK;
    }
  }
});
export default ParametersVisitor;