import stampit from 'stampit';
import { isObjectElement, BREAK } from '@swagger-api/apidom-core';
import SecurityElement from "../../../elements/nces/Security.js";
import SpecificationVisitor from "../SpecificationVisitor.js";
import FallbackVisitor from "../FallbackVisitor.js";
const SecurityVisitor = stampit(SpecificationVisitor, FallbackVisitor, {
  init() {
    this.element = new SecurityElement();
  },
  methods: {
    ArrayElement(arrayElement) {
      arrayElement.forEach(item => {
        if (isObjectElement(item)) {
          const element = this.toRefractedElement(['document', 'objects', 'SecurityRequirement'], item);
          this.element.push(element);
        } else {
          this.element.push(item.clone());
        }
      });
      this.copyMetaAndAttributes(arrayElement, this.element);
      return BREAK;
    }
  }
});
export default SecurityVisitor;