import stampit from 'stampit';
import { BREAK } from '@swagger-api/apidom-core';
import ServersElement from "../../../elements/nces/Servers.js";
import SpecificationVisitor from "../SpecificationVisitor.js";
import FallbackVisitor from "../FallbackVisitor.js";
import { isServerLikeElement } from "../../predicates.js";
const ServersVisitor = stampit(SpecificationVisitor, FallbackVisitor, {
  init() {
    this.element = new ServersElement();
  },
  methods: {
    ArrayElement(arrayElement) {
      arrayElement.forEach(item => {
        const specPath = isServerLikeElement(item) ? ['document', 'objects', 'Server'] : ['value'];
        const element = this.toRefractedElement(specPath, item);
        this.element.push(element);
      });
      this.copyMetaAndAttributes(arrayElement, this.element);
      return BREAK;
    }
  }
});
export default ServersVisitor;