import stampit from 'stampit';
import ComponentsHeadersElement from "../../../../elements/nces/ComponentsHeaders.js";
import MapVisitor from "../../generics/MapVisitor.js";
import FallbackVisitor from "../../FallbackVisitor.js";
import { isReferenceLikeElement } from "../../../predicates.js";
import { isReferenceElement, isHeaderElement } from "../../../../predicates.js";
const HeadersVisitor = stampit(MapVisitor, FallbackVisitor, {
  props: {
    specPath: element => {
      // eslint-disable-next-line no-nested-ternary
      return isReferenceLikeElement(element) ? ['document', 'objects', 'Reference'] : ['document', 'objects', 'Header'];
    }
  },
  init() {
    this.element = new ComponentsHeadersElement();
  },
  methods: {
    ObjectElement(objectElement) {
      // @ts-ignore
      const result = MapVisitor.compose.methods.ObjectElement.call(this, objectElement);

      // decorate every ReferenceElement with metadata about their referencing type
      this.element.filter(isReferenceElement).forEach(referenceElement => {
        referenceElement.setMetaProperty('referenced-element', 'header');
      });

      // decorate every HeaderElement with metadata about their name
      this.element.filter(isHeaderElement).forEach((value, key) => {
        value.setMetaProperty('header-name', key.toValue());
      });
      return result;
    }
  }
});
export default HeadersVisitor;