import stampit from 'stampit';
import { always } from 'ramda';
import MediaTypeElement from "../../../../elements/MediaType.js";
import FallbackVisitor from "../../FallbackVisitor.js";
import FixedFieldsVisitor from "../../generics/FixedFieldsVisitor.js";
const MediaTypeVisitor = stampit(FixedFieldsVisitor, FallbackVisitor, {
  props: {
    specPath: always(['document', 'objects', 'MediaType']),
    canSupportSpecificationExtensions: true
  },
  init() {
    this.element = new MediaTypeElement();
  }
});
export default MediaTypeVisitor;