import stampit from 'stampit';
import { T as stubTrue } from 'ramda';
import { isReferenceLikeElement } from "../../../predicates.js";
import { isReferenceElement, isResponseElement } from "../../../../predicates.js";
import AlternatingVisitor from "../../generics/AlternatingVisitor.js";
import FallbackVisitor from "../../FallbackVisitor.js";
const DefaultVisitor = stampit(AlternatingVisitor, FallbackVisitor, {
  props: {
    alternator: [{
      predicate: isReferenceLikeElement,
      specPath: ['document', 'objects', 'Reference']
    }, {
      predicate: stubTrue,
      specPath: ['document', 'objects', 'Response']
    }]
  },
  methods: {
    ObjectElement(objectElement) {
      // @ts-ignore
      const result = AlternatingVisitor.compose.methods.enter.call(this, objectElement);

      // decorate ReferenceElement with type of referencing element
      if (isReferenceElement(this.element)) {
        this.element.setMetaProperty('referenced-element', 'response');
      } else if (isResponseElement(this.element)) {
        this.element.setMetaProperty('http-status-code', 'default');
      }
      return result;
    }
  }
});
export default DefaultVisitor;