"use strict";

var _interopRequireDefault = require("@babel/runtime-corejs3/helpers/interopRequireDefault");
exports.__esModule = true;
exports.default = void 0;
var _stampit = _interopRequireDefault(require("stampit"));
var _ramda = require("ramda");
var _ramdaAdjunct = require("ramda-adjunct");
var _apidomCore = require("@swagger-api/apidom-core");
var _Visitor = _interopRequireDefault(require("./Visitor.cjs"));
var _visitor = require("../../traversal/visitor.cjs");
/**
 * This is a base Type for every visitor that does
 * internal look-ups to retrieve other child visitors.
 */
const SpecificationVisitor = (0, _stampit.default)(_Visitor.default, {
  props: {
    passingOptionsNames: ['specObj', 'openApiGenericElement', 'openApiSemanticElement'],
    specObj: null,
    openApiGenericElement: null,
    openApiSemanticElement: null
  },
  init({
    // @ts-ignore
    specObj = this.specObj,
    // @ts-ignore
    openApiGenericElement = this.openApiGenericElement,
    // @ts-ignore
    openApiSemanticElement = this.openApiSemanticElement
  }) {
    this.specObj = specObj;
    this.openApiGenericElement = openApiGenericElement;
    this.openApiSemanticElement = openApiSemanticElement;
  },
  methods: {
    retrievePassingOptions() {
      return (0, _ramda.pick)(this.passingOptionsNames, this);
    },
    retrieveFixedFields(specPath) {
      return (0, _ramda.pipe)((0, _ramda.path)(['visitors', ...specPath, 'fixedFields']), _ramda.keys)(this.specObj);
    },
    retrieveVisitor(specPath) {
      if ((0, _ramda.pathSatisfies)(_ramdaAdjunct.isFunction, ['visitors', ...specPath], this.specObj)) {
        return (0, _ramda.path)(['visitors', ...specPath], this.specObj);
      }
      return (0, _ramda.path)(['visitors', ...specPath, '$visitor'], this.specObj);
    },
    retrieveVisitorInstance(specPath, options = {}) {
      const passingOpts = this.retrievePassingOptions();
      return this.retrieveVisitor(specPath)({
        ...passingOpts,
        ...options
      });
    },
    toRefractedElement(specPath, element, options = {}) {
      /**
       * This is `Visitor shortcut`: mechanism for short circuiting the traversal and replacing
       * it by basic node cloning.
       *
       * Visiting the element is equivalent to cloning it  if the prototype of a visitor
       * is the same as the prototype of FallbackVisitor. If that's the case, we can avoid
       * bootstrapping the traversal cycle for fields that don't require any special visiting.
       */
      const visitor = this.retrieveVisitorInstance(specPath, options);
      const visitorPrototype = Object.getPrototypeOf(visitor);
      if ((0, _ramdaAdjunct.isUndefined)(this.fallbackVisitorPrototype)) {
        this.fallbackVisitorPrototype = Object.getPrototypeOf(this.retrieveVisitorInstance(['value']));
      }
      if (this.fallbackVisitorPrototype === visitorPrototype) {
        return element.clone();
      }

      // standard processing continues
      (0, _apidomCore.visit)(element, visitor, {
        keyMap: _visitor.keyMap,
        nodeTypeGetter: _visitor.getNodeType,
        ...options
      });
      return visitor.element;
    }
  }
});
var _default = SpecificationVisitor;
exports.default = _default;