"use strict";

var _interopRequireDefault = require("@babel/runtime-corejs3/helpers/interopRequireDefault");
exports.__esModule = true;
exports.default = void 0;
var _stampit = _interopRequireDefault(require("stampit"));
var _ramda = require("ramda");
var _AlternatingVisitor = _interopRequireDefault(require("../../generics/AlternatingVisitor.cjs"));
var _FallbackVisitor = _interopRequireDefault(require("../../FallbackVisitor.cjs"));
var _predicates = require("../../../predicates.cjs");
var _predicates2 = require("../../../../predicates.cjs");
const SchemaVisitor = (0, _stampit.default)(_AlternatingVisitor.default, _FallbackVisitor.default, {
  props: {
    alternator: [{
      predicate: _predicates.isReferenceLikeElement,
      specPath: ['document', 'objects', 'Reference']
    }, {
      predicate: _ramda.T,
      specPath: ['document', 'objects', 'Schema']
    }]
  },
  methods: {
    ObjectElement(objectElement) {
      // @ts-ignore
      const result = _AlternatingVisitor.default.compose.methods.enter.call(this, objectElement);
      if ((0, _predicates2.isReferenceElement)(this.element)) {
        this.element.setMetaProperty('referenced-element', 'schema');
      }
      return result;
    }
  }
});
var _default = SchemaVisitor;
exports.default = _default;